﻿<?php 
class CDeptInfo
{
	var $dept_id;
	var $parent_id;
	var $dept_name;
	var $dept_dec;
	var $childrens;
	var $level;
	
	function CDeptInfo()
	{
		$this->childrens=array();
		$this->level=0;
	}

	function Insert($mod)
	{
		if($this->dept_id==$mod->parent_id)
		{	
			$mod->level = $this->level+1;
			$this->childrens[sizeof($this->childrens)] = $mod; 
			return true;
		}
		
		for($i=0; $i<sizeof($this->childrens); $i++)
		{
			if($this->childrens[$i]->Insert($mod))
				return true;
		}
			
		return false;
	}

	function GetOption()
	{
		$blank = "|_";
		for($i=0; $i<$this->level; $i++)
			$blank = "&nbsp;&nbsp;".$blank;
			
		$str = "<option value=".$this->dept_id.">".$blank.$this->dept_name."</option>";
		for($i=0;$i<sizeof($this->childrens);$i++)
			$str = $str . $this->childrens[$i]->GetOption();	
			
		return $str;
	}
	
	function Display()
	{
		$blank = "|_";
		for($i=0; $i<$this->level; $i++)
			$blank = "&nbsp;&nbsp;".$blank;	
			
		echo "<tr bgcolor=\"#ffffff\" height=24 onmouseover=\"setPointer(this, 'over', '#D0DCE0', '#ffffff');\" onmouseout=\"setPointer(this, 'out', '#D0DCE0', '#ffffff');\">";
		echo "<td >".$blank.$this->dept_name."</td>";
		echo "<td align=center>".$this->dept_desc."</td>";
		echo "<td align=center><img src=\"imgs/b_edit.png\" alt=\"编辑\" id=\"edit_dept\" class=\"link\" onclick=\"ClickEditDept(".$this->dept_id.")\"></td>";
		echo "<td align=center><img src=\"imgs/b_drop.png\" alt=\"删除\" id=\"del_dept\" class=\"link\" onclick=\"ClickDelDept(".$this->dept_id.", '".$this->dept_name."')\"></td>";
		echo "</tr>";
		
		for($n=0; $n<sizeof($this->childrens); $n++)
			$this->childrens[$n]->Display();	
	}
	
};

class CModuleDept extends CModuleBase
{
	function Init()
	{
		$sql = "select dept_id, parent_id, dept_name, dept_desc from tb_dept order by parent_id, dept_id";		
		$this->db->ExeQuerySql($sql);
		while($this->db->FetchRow())
		{				
			$mod = new CDeptInfo();
			$mod->dept_id = $this->db->Get("dept_id");
			$mod->parent_id = $this->db->Get("parent_id");
			$mod->dept_name = $this->db->Get("dept_name"); 
			$mod->dept_desc = $this->db->Get("dept_desc");
			if($mod->parent_id == 0)
				$this->modules[$this->GetSize()] = $mod;
			else
				$this->InsertDept($mod);
		}
		
		$this->db->FreeResult();
	}
	
	function InitByID($ids)
	{
		$sql = "select distinct dept_id, parent_id, dept_name, dept_desc from tb_dept where dept_id in (";
		$sql = $sql . $ids;	
		$sql = $sql . ") order by parent_id, dept_id";		
		$this->db->ExeQuerySql($sql);
		while($this->db->FetchRow())
		{				
			$mod = new CDeptInfo();
			$mod->dept_id = $this->db->Get("dept_id");
			$mod->parent_id = $this->db->Get("parent_id");
			$mod->dept_name = $this->db->Get("dept_name"); 
			$mod->dept_desc = $this->db->Get("dept_desc");
			if($mod->parent_id == 0)
				$this->modules[$this->GetSize()] = $mod;
			else
				$this->InsertDept($mod);
		}
		
		$this->db->FreeResult();
	}
	
	function InitModule($module_id)
	{
		$sql = "select dept_id,parent_id, dept_name, dept_desc from tb_dept where dept_id=".$module_id." order by 1";		
		$this->db->ExeQuerySql($sql);
		while($this->db->FetchRow())
		{			
			$this->module = new CDeptInfo();
			$this->module->dept_id = $this->db->Get("dept_id");
			$this->module->parent_id = $this->db->Get("parent_id");
			$this->module->dept_name = $this->db->Get("dept_name");
			$this->module->dept_desc = $this->db->Get("dept_desc");
		}
		
		$this->db->FreeResult();
	}

	function InsertDept($dept)
	{
		for($i=0;$i<sizeof($this->modules); $i++)
		{
				if($this->modules[$i]->Insert($dept)) 
					break;
		}
	}

	function GetOptions()
	{
		$op_str = "";
		for($i=0; $i<sizeof($this->modules); $i++)
			$op_str = $op_str . $this->modules[$i]->GetOption();

		return $op_str;
	}
	
	function Display()
	{
		for($i=0; $i<sizeof($this->modules); $i++)
			$this->modules[$i]->Display();
	}
};
?>
