﻿<?php
class CMember
{
	var $member_type;
	var $member_id;
	var $member_name;
	var $dept_id;	
};

class CField
{
	var $field_id;
	var $field_title;
	var $field_type;
	var $edit_rule;
	var $edit_order;
	var $field_type_title;
	var $field_len;
	var $field_width;
	var $field_height;
	var $field_default;
	var $field_option;
	
	//编辑字段
	function GetEditContent()
	{		
		//生成编辑内容
		$content = "";
		$id="custom_field_".$this->field_id;
		switch($this->field_type)
		{
			case 0: //单行文本
					$content = $content."<input id='".$id."' name='".$id."' size='".$this->field_width."' class='box' value='".$this->field_default[0]."'>";
			break;
			case 1: //多行文本
					$content = $content."<textarea id='".$id."' name='".$id."' cols='".$this->field_width."' rows='".$this->field_height."' class='box'>".$this->field_default[0]."</textarea>";
			break;
			case 2: //多行富文本
			{
				$content = $content."<textarea id='".$id."' name='".$id."' cols='".$this->field_width."' rows='".$this->field_height."' class='box'>".$this->field_default[0]."</textarea>";
				$content = $content."<script>";
				$content = $content."					var editor;";
				$content = $content."					KindEditor.ready(function(K) {";
				$content = $content."						editor = K.create(\'textarea[name='".$id."']\', {";
				$content = $content."							resizeType : 1,";
				$content = $content."							allowPreviewEmoticons : false,";
				$content = $content."							allowImageUpload : false,";
				$content = $content."							items : [";
				$content = $content."								'fontname', 'fontsize', '|', 'forecolor', 'hilitecolor', 'bold', 'italic', 'underline',";
				$content = $content."								'removeformat', '|', 'emoticons', '|', ";
				$content = $content."								'justifyleft', 'justifycenter', 'justifyright', 'insertorderedlist', 'insertunorderedlist']";
				$content = $content."						});";
				$content = $content."					});";
				$content = $content."		</script>";
			}
			break;
			case 3: //单选下拉框
			{
				$content = $content."<select id='".$id."' name='".$id."' class=txtput>";
				for($i=0; $i<sizeof($this->field_option); $i++)
				{
					$selected = "";
					for($n=0; $n<sizeof($this->field_default); $n++)
					{
						if($this->field_option[$i]["id"] == $this->field_default[$n])	
						{
							$selected = "selected";
							break;	
						}
					}
				
					$content = $content."<option value='".$this->field_option[$i]["id"]."' ".$selected.">".$this->field_option[$i]["value"]."</option>";
				}
				$content = $content."</select>";	
			}
			break;
			case 4: //单选列表框
				{
					for($i=0; $i<sizeof($this->field_option); $i++)
					{
						$checked = "";
						for($n=0; $n<sizeof($this->field_default); $n++)
						{
							if($this->field_option[$i]["id"] == $this->field_default[$n])	
							{
								$checked = "checked";
								break;	
							}
						}					
						$content = $content."<input type=radio  id='".$id."' name='".$id."' value='".$this->field_option[$i]["id"]."' ".$checked.">".$this->field_option[$i]["value"];
					}
				}
			break;
			case 5: //多选下拉框
				{
					$content = $content."<select id='".$id."' name='".$id."[]' multiple=true size=".$this->field_height." class=txtput>";
					for($i=0; $i<sizeof($this->field_option); $i++)
					{
						$selected = "";
						for($n=0; $n<sizeof($this->field_default); $n++)
						{
							if($this->field_option[$i]["id"] == $this->field_default[$n])	
							{
								$selected = "selected";
								break;	
							}
						}					
						$content = $content."<option value='".$this->field_option[$i]["id"]."' ".$selected.">".$this->field_option[$i]["value"]."</option>";
					}
					$content = $content."</select>";
				}
			break;
			case 6: //多选选择框
				{
					for($i=0; $i<sizeof($this->field_option); $i++)
					{
						$checked = "";
						for($n=0;$n<sizeof($this->field_default);$n++)
						{
							if($this->field_option[$i]["id"] == $this->field_default[$n])	
							{
								$checked = "checked";
								break;	
							}
						}					
						$content = $content."<input type=checkbox  id='".$id."' name='".$id."[]' value='".$this->field_option[$i]["id"]."' ".$checked.">".$this->field_option[$i]["value"];
					}
				}
			break;
			case 7: //时间日期
				$content = $content."<input id='".$id."' name='".$id."' onfocus='setday(this)' class=box value='".$this->field_default[0]."'>";
			break;
		}
		
		return $content;	
	}
};

class CActionInfo
{
	var $action_id   ;
	var $action_name ;
	var $src_status_id;	//status_id
	var $src_status_type;
	var $src_status  ; //status_name
	var $chart_src_status;//status_chart
	var $dst_status_id;
	var $dst_status_type;
	var $dst_status  ;
	var $chart_dst_status  ;
	var $action_title;
	var $members;
	var $depts;
	var $fields;
	
	//判断目标状态是否是关闭状态
	function DstIsClose()
	{
		return $this->dst_status_type == 0;
	}
	
	//判断源状态是否是新建状态
	function SrcIsNew()
	{
			return $this->src_status_type == 1;
	}
	
	function CActionInfo()
	{
		$this->members=array();
		$this->fields=array();
	}
	
	function InitMember($db, $issue_typeid)
	{
		$sql = "select a.*, b.real_name from tb_project_worker a, tb_user b where a.member_type=0 ";
		$sql = $sql . " and a.issue_type_id=".$issue_typeid;
		$sql = $sql . " and a.action_id=".$this->action_id;
		$sql = $sql . " and a.member_id=b.user_id order by 1";
		$db->ExeQuerySql($sql);
		while($db->FetchRow())
		{
			$member = new CMember();
			$member->member_type = 0;
			$member->member_id = $db->Get("member_id");
			$member->member_name = $db->Get("real_name");
			$this->members[sizeof($this->members)] = $member;
		}
		$db->FreeResult();
		
		$sql = "select a.*, b.group_name from tb_project_worker a, tb_project_group b where a.member_type=1";
		$sql = $sql . " and a.issue_type_id=".$issue_typeid;
		$sql = $sql . " and a.action_id=".$this->action_id;
		$sql = $sql . " and a.member_id=b.group_id  order by 1";
		$db->ExeQuerySql($sql);
		while($db->FetchRow())
		{
			$member = new CMember();
			$member->member_type = 1;
			$member->member_id = $db->Get("member_id");
			$member->member_name = $db->Get("group_name");
			$this->members[sizeof($this->members)] = $member;
		}
		$db->FreeResult();
	}
	
	function InitNextActionMember($db, $issue_typeid)
	{		
		$sql = "select d.user_id, d.real_name, d.dept_id from tb_project_group_member c, tb_user d where c.user_id=d.user_id and c.group_id in (";
		$sql = $sql . "select a.member_id from tb_project_worker a, tb_project_group b where a.member_type=1";
		$sql = $sql . " and a.issue_type_id=".$issue_typeid;
		$sql = $sql . " and a.action_id in ";
		$sql = $sql . "		(select action_id from tb_flow_action where src_status = '".$this->chart_dst_status."' and flow_id=(select flow_id from tb_flow_action where action_id=".$this->action_id.")) ";
		$sql = $sql . " and a.member_id=b.group_id  ";
		$sql = $sql . " ) and d.state=1 order by d.dept_id"; 
		$db->ExeQuerySql($sql); 
		while($db->FetchRow())
		{
			if(!$this->ContainMember($db->Get("user_id"))){
				$member = new CMember();
				$member->member_type = 0;
				$member->member_id = $db->Get("user_id");
				$member->member_name = $db->Get("real_name");
				$member->dept_id = $db->Get("dept_id");
				$this->members[sizeof($this->members)] = $member;
			}
		}
		$db->FreeResult();
		
		$sql = "select distinct a.member_id, b.real_name, b.dept_id from tb_project_worker a, tb_user b where a.member_type=0 and b.state=1";
		$sql = $sql . " and a.issue_type_id=".$issue_typeid;
		$sql = $sql . " and a.action_id in ";
		$sql = $sql . "(select action_id from tb_flow_action where src_status = '".$this->chart_dst_status."' and flow_id=(select flow_id from tb_flow_action where action_id=".$this->action_id.")) ";
		$sql = $sql . " and a.member_id=b.user_id order by b.real_name";
		$db->ExeQuerySql($sql);
		while($db->FetchRow())
		{
			$member = new CMember();
			$member->member_type = 0;
			$member->member_id = $db->Get("member_id");
			$member->member_name = $db->Get("real_name");
			$member->dept_id = $db->Get("dept_id");
			$this->members[sizeof($this->members)] = $member;
		}
		$db->FreeResult();
	}
	
	function ContainMember($member_id, $member_type=0)
	{
		for($i=0;$i<sizeof($this->members);$i++)
		{
				if($this->members[$i]->member_type == $member_type && $this->members[$i]->member_id == $member_id)
					return true;
		}
		
		return false;
	}
		
	function InitFieldEdit($db, $issue_typeid)
	{
		global $Config;
		$sql = "select a.*, b.field_title, b.field_type, b.field_len, b.field_width, b.field_height, b.field_default, b.field_option ";
		$sql = $sql . " from tb_project_field_edit a, tb_project_fields b where a.field_id=b.field_id ";
		$sql = $sql . " and issue_type_id=".$issue_typeid." and action_id=".$this->action_id;
		$sql = $sql . " order by a.edit_order";
		$db->ExeQuerySql($sql);
	
		while($db->FetchRow())
		{		
				$field = new CField();
				$field->field_id = $db->Get("field_id");
				$field->edit_rule = $db->Get("edit_rule");
				$field->edit_order = $db->Get("edit_order");
				$field->field_title = $db->Get("field_title");
				$field->field_type = $db->Get("field_type");
				$field->field_type_title = $Config["field_type"][$field->field_type];
	
				$field->field_len    =$db->Get("field_len");
				$field->field_width  =$db->Get("field_width");
				$field->field_height =$db->Get("field_height");
				$field->field_default=UnSerializeArray($db->Get("field_default"));
				$field->field_option =UnSerializeOption($db->Get("field_option"));
	
				$this->fields[sizeof($this->fields)] = $field;
		}
		$db->FreeResult();
	}
};

class CModuleFlowAction extends CModuleBase
{
	function Init($flow_id)
	{
		$sql = "select a.action_id, a.action_name, a.action_title, ";
		$sql = $sql . "b.status_id src_status_id, b.state_name src_status, b.chart_state_id chart_src_status, b.state_type src_status_type, ";
		$sql = $sql . "c.status_id dst_status_id, c.state_name dst_status, c.chart_state_id chart_dst_status, c.state_type dst_status_type  ";
		$sql = $sql . " from tb_flow_action a, tb_flow_status b, tb_flow_status c ";
		$sql = $sql . " where a.flow_id=".$flow_id." and a.src_status=b.chart_state_id and a.flow_id=b.flow_id and a.dst_status=c.chart_state_id and a.flow_id=c.flow_id ";
		$sql = $sql . " order by 1";		
		$this->db->ExeQuerySql($sql);
	
		while($this->db->FetchRow())
		{			
			$mod = new CActionInfo();
			$mod->action_id = $this->db->Get("action_id");
			$mod->action_name = $this->db->Get("action_name");
			$mod->src_status_id = $this->db->Get("src_status_id");	
			$mod->src_status = $this->db->Get("src_status");
			$mod->chart_src_status = $this->db->Get("chart_src_status");	
			$mod->src_status_type = $this->db->Get("src_status_type");
			$mod->dst_status_id = $this->db->Get("dst_status_id");	
			$mod->dst_status = $this->db->Get("dst_status");
			$mod->chart_dst_status = $this->db->Get("chart_dst_status");
			$mod->dst_status_type = $this->db->Get("dst_status_type");
			$mod->action_title = $this->db->Get("action_title");
			$this->modules[$this->GetSize()] = $mod;
		}
		$this->db->FreeResult(); 
	}
		
	function InitModule($module_id)
	{
		$sql = "select a.action_id, a.action_name, a.action_title, ";
		$sql = $sql . " b.status_id src_status_id, b.state_name src_status, b.chart_state_id chart_src_status, b.state_type src_status_type,";
		$sql = $sql . " c.status_id dst_status_id, c.state_name dst_status, c.chart_state_id chart_dst_status, c.state_type dst_status_type ";
		$sql = $sql . " from tb_flow_action a, tb_flow_status b, tb_flow_status c ";
		$sql = $sql . " where a.action_id=".$module_id." and a.src_status=b.chart_state_id and a.flow_id=b.flow_id and a.dst_status=c.chart_state_id and a.flow_id=c.flow_id ";
		$sql = $sql . " order by 1";
		$this->db->ExeQuerySql($sql);
	
		if($this->db->FetchRow())
		{			
			$this->module = new CActionInfo();
			$this->module->action_id = $this->db->Get("action_id");
			$this->module->action_name = $this->db->Get("action_name");
			$this->module->src_status_id = $this->db->Get("src_status_id");	
			$this->module->src_status = $this->db->Get("src_status");	
			$this->module->chart_src_status = $this->db->Get("chart_src_status");	
			$this->module->src_status_type = $this->db->Get("src_status_type");
			$this->module->dst_status_id = $this->db->Get("dst_status_id");
			$this->module->dst_status = $this->db->Get("dst_status");
			$this->module->chart_dst_status = $this->db->Get("chart_dst_status");
			$this->module->dst_status_type = $this->db->Get("dst_status_type");
			$this->module->action_title = $this->db->Get("action_title");
		}
		$this->db->FreeResult();
	}
	
	function InitMember($issue_typeid, $is_all=1)
	{
		if($is_all)
		{
			for($i=0; $i<$this->GetSize();$i++)
				$this->modules[$i]->InitMember($this->db, $issue_typeid);
		}
		else
			$this->module->InitMember($this->db, $issue_typeid);
	}
	
	function InitField($issue_typeid, $is_all=1)
	{	
		if($is_all)
		{
			for($i=0; $i<$this->GetSize();$i++)
				$this->modules[$i]->InitFieldEdit($this->db, $issue_typeid);
		}
		else
			$this->module->InitFieldEdit($this->db, $issue_typeid);
	}
	
	function InitActionByIssueType($issue_type, $begin_state=0, $action_user=0)
	{
		$sql = "select a.action_id, a.action_name, a.action_title, b.state_name src_status, c.state_name dst_status ";
		$sql = $sql . " from tb_flow_action a, tb_flow_status b, tb_flow_status c, tb_project_issue_type d ";
		$sql = $sql . " where a.flow_id=d.flow_id and d.issue_type_id=".$issue_type;
		
		if($action_user != 0) //根据人物ID选择可以处理的动作
		{
			$sql = $sql . " and a.action_id in (";
			$sql = $sql . " select action_id from tb_project_worker where issue_type_id=".$issue_type." and ";
			$sql = $sql . "(";
			$sql = $sql . "		(member_type=0 and member_id=".$action_user.") "; 
			$sql = $sql . " 		or ";
			$sql = $sql . " 	(member_type=1 and member_id in (select group_id from tb_project_group_member where user_id=".$action_user." and  group_id in (select group_id from tb_project_group z, tb_project_issue_type x where z.project_id=x.project_id and x.issue_type_id=".$issue_type.") ) )";
			$sql = $sql . " ) ";	
			$sql = $sql . ") ";		
		}
	
		if($begin_state==0)
		 $sql = $sql . " and a.src_status in (select chart_state_id from tb_flow_status where state_type=1) ";
		else
			$sql = $sql . " and a.src_status in (select chart_state_id from tb_flow_status where status_id=".$begin_state.") ";
			
		$sql = $sql . " and a.src_status=b.chart_state_id and a.flow_id=b.flow_id and a.dst_status=c.chart_state_id and a.flow_id=c.flow_id ";
		$sql = $sql . " order by 1";
		
		$this->db->ExeQuerySql($sql);
	
		while($this->db->FetchRow())
		{			
			$mod = new CActionInfo();
			$mod->action_id = $this->db->Get("action_id");
			$mod->action_name = $this->db->Get("action_name");
			$mod->src_status = $this->db->Get("src_status");	
			$mod->dst_status = $this->db->Get("dst_status");
			$mod->action_title = $this->db->Get("action_title");
			$this->modules[$this->GetSize()] = $mod;
		}
		$this->db->FreeResult();
	}
	
	function InitNextActionMember($issue_type)
	{
		$this->module->InitNextActionMember($this->db, $issue_type);
	}
};
?>
