﻿<?php
class CAttachInfo
{
	var $attach_id  ;
	var $issue_id   ;
	var $log_id     ;
	var $attach_name;
	var $attach_type;
	var $file_name  ;
	var $file_size  ;
	var $user_id    ;
	var $create_time;
};

class CAction
{
	var $action_id;
	var $action_name;
	var $src_status_id;
	var $src_status_name;
	var $dst_status_id;
	var $dst_status_name;
};

class CActionUsers
{
		var $action_code;
		var $issue_id;
		var $status_id;
		var $action_user_id;
		var $action_user_name;
		var $action_id;
		var $action_name;
		var $action_time;
};

class CIssueLog
{
	var $log_id;
	var $issue_id;
	var $status_id;
	var $user_id;
	var $real_name;
	var $action_id;
	var $action_name;
	var $work_log;
	var $work_time;
	var $attach;
};

class CIssueComment
{
	var $comment_id   ;
	var $issue_id     ;
	var $issue_comment;
	var $user_id      ;
	var $real_name;
	var $comment_time ;
};

class CIssueInfo
{
	var $issue_id;
	var $parent_issue_id;
	var $issue_type_id;
	var $issue_type_name;
	var $project_id;
	var $project_name;
	var $issue_title;
	var $issue_content;
	var $status_id;
	var $status_name;
	var $create_user;
	var $create_user_name;
	var $process_user;
	//var $module_id;
	//var $module_name;
	var $pripority_id;
	var $serverity_id;
	var $solution_id;
	var $is_close;
	var $create_time;
	var $close_time;
	var $exp_time;
	var $custom_fields;
	
	var $logs;
	var $comments;
	var $attachs;
	var $actions;
	var $action_users;
	var $parent_issue;
	var $child_issues;
	var $edit_grade;
	
	function CIssueInfo()
	{
		$this->custom_fields = array();
		$this->logs = array();
		$this->comments = array();
		$this->attachs = array();
		$this->action_users = array();
		$this->child_issues = array();
		$this->edit_grade = 0;
	}
	
	function InitCustomFields($db)
	{
		$fields = array();
		$sql = "select field_id, field_value from tb_issue_field where issue_id=".$this->issue_id;
		$db->ExeQuerySql($sql);
		while($db->FetchRow())
			$fields[sizeof($fields)] = array("id"=>$db->Get("field_id"), "value"=>$db->Get("field_value"));
		$db->FreeResult();
		
		require_once("module.project_fields.php");
		$f = new CModuleProjectFields();
		for($i=0; $i<sizeof($fields); $i++)
		{
			$f->InitModule($fields[$i]["id"]);
			$f->module->field_default = UnSerializeArray($fields[$i]["value"]);
			$this->custom_fields[sizeof($this->custom_fields)] = $f->module;
		}
	}
	
	function InitAttachs($db)
	{
		$sql = "select * from tb_issue_attach where log_id=0 and issue_id=".$this->issue_id;
		$db->ExeQuerySql($sql);
		while($db->FetchRow())
		{
				$mod = new CAttachInfo();
				$mod->attach_id   = $db->Get("attach_id");
				$mod->issue_id    = $db->Get("issue_id");
				$mod->log_id      = $db->Get("log_id");
				$mod->attach_name = $db->Get("attach_name");
				$mod->attach_type = $db->Get("attach_type");
				$mod->file_name   = $db->Get("file_name");
				$mod->file_size   = $db->Get("file_size");
				$mod->user_id     = $db->Get("user_id");
				$mod->create_time = $db->Get("create_time");
				$this->attachs[sizeof($this->attachs)] = $mod;
		}
		$db->FreeResult();
	}
	
	function InitActions($db)
	{
		global $UserInfo;
		$sql = "select a.*,b.status_id src_status_id, b.state_name src_status_name, c.status_id dst_status_id, c.state_name dst_status_name ";
		$sql = $sql . " from tb_flow_action a, tb_flow_status b, tb_flow_status c ";
		$sql = $sql . " where a.flow_id=b.flow_id and a.src_status=b.chart_state_id and b.status_id=".$this->status_id;
		$sql = $sql . " and a.flow_id=c.flow_id and a.dst_status=c.chart_state_id";
		$sql = $sql . " and a.src_status in ";
		$sql = $sql . " ( select chart_state_id from tb_flow_status a, tb_issue_action_user b ";
		$sql = $sql . " 	where b.issue_id=".$this->issue_id." and b.action_user_id=".$UserInfo['UID']." and b.action_id=0 and a.status_id=b.status_id)";
		
		$db->ExeQuerySql($sql);
		while($db->FetchRow())
		{
				$mod = new CAction();
				$mod->action_id=$db->Get("action_id");
				$mod->action_name=$db->Get("action_name");
				$mod->src_status_id = $db->Get("src_status_id");
				$mod->src_status_name = $db->Get("src_status_name");
				$mod->dst_status_id = $db->Get("dst_status_id");
				$mod->dst_status_name = $db->Get("dst_status_name");
				$this->actions[sizeof($this->actions)] = $mod;
		}
		$db->FreeResult();
	}
	
	//初始化事务当前的处理人员
	function InitActionUsers($db)
	{
		$action_code = 0;
		$sql = "select a.action_code, a.issue_id, a.status_id, a.action_id, a.action_user_id, b.real_name, a.action_time ";
		$sql = $sql . " from tb_issue_action_user a, tb_user b ";
		$sql = $sql . " where a.issue_id=".$this->issue_id." and a.status_id=".$this->status_id. " and a.action_user_id=b.user_id ";
		$sql = $sql . " order by action_code desc";
		$db->ExeQuerySql($sql);		
		while($db->FetchRow())
		{
				if($action_code>0 && $db->Get("action_code") != $action_code)
					break;
					
				$mod = new CAction();
				$action_code = $db->Get("action_code");
				$mod->action_code			 = $action_code;
				$mod->issue_id				 = $db->Get("issue_id");
				$mod->status_id				 = $db->Get("status_id");
				$mod->action_user_id	 = $db->Get("action_user_id");
				$mod->action_user_name = $db->Get("real_name");
				$mod->action_id				 = $db->Get("action_id");
				$mod->action_name			 = "";
				$mod->action_time			 = $db->Get("action_time");				
				$this->action_users[sizeof($this->action_users)] = $mod;
		}
		$db->FreeResult();
		
		for($i=0; $i<sizeof($this->action_users); $i++)
		{
			if($this->action_users[$i]->action_id==0) continue;
			$sql = "select action_name from tb_flow_action where action_id=".$this->action_users[$i]->action_id;
			$db->ExeQuerySql($sql);		
			if($db->FetchRow())
				$this->action_users[$i]->action_name = $db->Get("action_name");
			$db->FreeResult();
		}
	}
	
	//需要处理的人员数量
	function ActionUserCount()
	{
		$cnt = 0;
		for($i=0;$i<sizeof($this->action_users);$i++)
		{
			if($this->action_users[$i]->action_id==0)
				$cnt++;	
		}
		
		return $cnt;
	}
	
	//是否包含处理人
	function ContainActionUser($user_id)
	{
		for($i=0;$i<sizeof($this->action_users);$i++)
			if($this->action_users[$i]->action_user_id == $user_id) return true;
		
		return false;
	}
	
	function InitLog($db)
	{
		$sql = "select a.*, b.real_name, c.action_name from tb_issue_log a, tb_user b, tb_flow_action c where a.issue_id=".$this->issue_id." and a.user_id=b.user_id and a.action_id=c.action_id order by a.log_id desc";
		$db->ExeQuerySql($sql);
		
		while($db->FetchRow())
		{					
				$mod = new CIssueLog();
				$mod->log_id = $db->Get("log_id");
				$mod->issue_id = $db->Get("issue_id");
				$mod->status_id = $db->Get("status_id");
				$mod->user_id = $db->Get("user_id");
				$mod->real_name = $db->Get("real_name");
				$mod->action_id = $db->Get("action_id");
				$mod->action_name = $db->Get("action_name");
				$mod->work_log = $db->Get("work_log");
				$mod->work_time = $db->Get("work_time");
				
				$this->logs[sizeof($this->logs)] = $mod;
		}
		$db->FreeResult();
		
		
		$sql = "select * from tb_issue_attach where issue_id=".$this->issue_id." and log_id<>0";
		
		$db->ExeQuerySql($sql);
		while($db->FetchRow())
		{
					$mod = new CAttachInfo();
					$mod->attach_id   = $db->Get("attach_id");
					$mod->issue_id    = $db->Get("issue_id");
					$mod->log_id      = $db->Get("log_id");
					$mod->attach_name = $db->Get("attach_name");
					$mod->attach_type = $db->Get("attach_type");
					$mod->file_name   = $db->Get("file_name");
					$mod->file_size   = $db->Get("file_size");
					$mod->user_id     = $db->Get("user_id");
					$mod->create_time = $db->Get("create_time");
		
					for($i=0 ;$i<sizeof($this->logs);$i++)
					{
						if($this->logs[$i]->log_id==$mod->log_id)
						$this->logs[$i]->attach = $mod;
					}
			}
			$db->FreeResult();
			
	}
	
	function InitComment($db)
	{
		$sql = "select a.*, b.real_name from tb_issue_comment a, tb_user b where a.issue_id=".$this->issue_id." and a.user_id=b.user_id order by a.comment_id desc";
		$db->ExeQuerySql($sql);
		
		while($db->FetchRow())
		{					
				$mod = new CIssueComment();
				$mod->comment_id    = $db->Get("comment_id");
				$mod->issue_id      = $db->Get("issue_id");
				$mod->issue_comment = $db->Get("issue_comment");
				$mod->user_id       = $db->Get("user_id");
				$mod->real_name			= $db->Get("real_name") ;
				$mod->comment_time  = $db->Get("comment_time");
				$this->comments[sizeof($this->comments)] = $mod;
		}
		$db->FreeResult();
	}
	
	//关联事务
	function InitRelation($db)
	{
		$sql = "select a.*, b.state_name status_name from tb_issue a, tb_flow_status b ";
		$sql = $sql . " where a.is_delete=0 and a.status_id=b.status_id and a.issue_id=".$this->parent_issue_id;
		$db->ExeQuerySql($sql);
		if($db->FetchRow())
		{
			$this->parent_issue = new CIssueInfo();
			$this->parent_issue->issue_id			= $db->Get("issue_id");
			$this->parent_issue->issue_title	= $db->Get("issue_title");	
			$this->parent_issue->status_name	= $db->Get("status_name");	
			$this->parent_issue->is_close			= $db->Get("is_close");	
		}
		$db->FreeResult();
		
		$sql = "select a.*, b.state_name status_name from tb_issue a, tb_flow_status b ";
		$sql = $sql . " where a.is_delete=0 and a.status_id=b.status_id and a.parent_issue_id=".$this->issue_id;
		
		$db->ExeQuerySql($sql);
		while($db->FetchRow())
		{
			$mod = new CIssueInfo();
			$mod->issue_id		= $db->Get("issue_id");
			$mod->issue_title	= $db->Get("issue_title");	
			$mod->status_name	= $db->Get("status_name");	
			$mod->is_close		= $db->Get("is_close");
			$this->child_issues[sizeof($this->child_issues)] = $mod;
		}
		$db->FreeResult();
	}
	
	//用户当前编辑权限
	function InitEditGrade($db)
	{
		global $UserInfo;
		$sql = "select a.group_grade from tb_project_group a, tb_project_group_member b ";
		$sql = $sql . " where a.project_id=".$this->project_id." and a.group_id=b.group_id and b.user_id=".$UserInfo['UID'];
		
		$db->ExeQuerySql($sql);
		while($db->FetchRow())
			$this->edit_grade |= $db->Get("group_grade");
		$db->FreeResult();
	}
};

class CModuleIssue extends CModuleBase
{
	function Init($issue_id)
	{
		$sql = "select a.*, b.issue_type_name, c.project_name, e.state_name status_name, f.real_name ";
		$sql = $sql . " from tb_issue a, tb_project_issue_type b, tb_project c, tb_flow_status e, tb_user f ";
		$sql = $sql . " where a.issue_id=".$issue_id;
		$sql = $sql . " and a.issue_type_id = b.issue_type_id ";
		$sql = $sql . " and a.project_id=c.project_id ";
		$sql = $sql . " and a.status_id=e.status_id ";
		$sql = $sql . " and a.create_user=f.user_id";
		
		$this->db->ExeQuerySql($sql);
		if($this->db->FetchRow())
		{			
			$mod = new CIssueInfo();
			$mod->issue_id				 = $this->db->Get("issue_id");
			$mod->parent_issue_id  = $this->db->Get("parent_issue_id");
			$mod->issue_type_id		 = $this->db->Get("issue_type_id");
			$mod->issue_type_name	 = $this->db->Get("issue_type_name");
			$mod->project_id			 = $this->db->Get("project_id");
			$mod->project_name		 = $this->db->Get("project_name");
			$mod->issue_title			 = $this->db->Get("issue_title");
			$mod->issue_content		 = $this->db->Get("issue_content");
			$mod->status_id				 = $this->db->Get("status_id");
			$mod->status_name			 = $this->db->Get("status_name");
			$mod->create_user			 = $this->db->Get("create_user");
			$mod->create_user_name = $this->db->Get("real_name");
			$mod->process_user			 = $this->db->Get("process_user");			
			//$mod->module_id				 = $this->db->Get("module_id");
			//$mod->module_name			 = "未知模块";
			$mod->pripority_id		 = $this->db->Get("pripority_id");
			$mod->serverity_id		 = $this->db->Get("serverity_id");
			$mod->solution_id			 = $this->db->Get("solution_id");
			$mod->is_close 				 = $this->db->Get("is_close");
			$mod->create_time			 = $this->db->Get("create_time");
			$mod->close_time			 = $this->db->Get("close_time");
			$mod->exp_time				 = $this->db->Get("exp_time");
			$this->modules[$this->GetSize()] = $mod;
		} 
		$this->db->FreeResult();
	
		/*if($this->modules[0]->module_id > 0)
		{
				require_once("module.project_module.php");
				$module = new CModuleProjectModule();
				$module->InitModule($this->modules[0]->module_id);
				$this->modules[0]->module_name = $module->module->module_name;
		}*/
		
		$this->modules[0]->InitCustomFields($this->db);
		$this->modules[0]->InitAttachs($this->db);
		$this->modules[0]->InitActions($this->db);
		$this->modules[0]->InitActionUsers($this->db);
		$this->modules[0]->InitRelation($this->db);
		$this->modules[0]->InitEditGrade($this->db);
	}
	
	function FindAction($action_id)
	{
		for($i=0; $i<sizeof($this->modules[0]->actions); $i++)
		{
				if($this->modules[0]->actions[$i]->action_id == $action_id)
					return $this->modules[0]->actions[$i];
		}	
		return "";
	}
	
	function InitLog()
	{
		for($i=0;$i<$this->GetSize();$i++)
			$this->modules[$i]->InitLog($this->db);	
	}
	
	function InitComment() 
	{
		for($i=0;$i<$this->GetSize();$i++)
			$this->modules[$i]->InitComment($this->db);
	}
};
?>
