﻿<?php

class CWorker
{
	var $worker_id;
	var $worker_name;	
};

class CListInfo
{
	var $issue_id;
	var $project_name;
	var $issue_type_name;	
	var $issue_title;
	var $priority;
	var $serverity;
	var $status_name;
	var $create_user;
	var $create_time;
	var $exp_time;
	var $close_time;
	var $is_close;
	var $is_exp;//是否过期
	var $workers; //当前处理人员
	
	function CListInfo()
	{
		$this->workers = array();
		$this->is_exp=0;
		$this->is_press=0;
	}
	
	function InitWorkers($db)
	{
		global $UserInfo;
		$sql = "select a.action_code, a.action_user_id, c.real_name from tb_issue_action_user a, tb_issue b, tb_user c ";
		$sql = $sql . " where a.action_id=0 and a.issue_id=b.issue_id and a.status_id=b.status_id and a.issue_id=".$this->issue_id." and a.action_user_id=c.user_id";
		
		$db->ExeQuerySql($sql);
		$action_code = 0;
		while($db->FetchRow())
		{
				if($action_code>0 && $db->Get("action_code") != $action_code)
					break;
					
				$worker = new CWorker();
				$action_code = $db->Get("action_code");
				$worker->worker_id				= $db->Get("action_user_id");
				$worker->worker_name			= $db->Get("real_name");
								
				$this->workers[sizeof($this->workers)] = $worker;
		}
		$db->FreeResult();
	}
	
	//判断是否过期
	function CalcExp()
	{
		if($this->exp_time == '0000-00-00 00:00:00' || $this->is_close==1) return;
		if(strftime("%Y-%m-%d %H:%M:%S", time())>$this->exp_time)
			$this->is_exp=1;
	}
};

class CQueryInfo
{
	var $query_id;
	var $project_id  			;
	var $query_str 				;
	var $query_field  		;
	var $query_property 	;
	var $query_date 			;
	var $issue_type  			;
	var $issue_status 		;
	var $serverity   			;
	var $priority    			;
	var $create_user  		;
	var $process_user    	;
	var $create_date_begin;
	var $create_date_end 	;
	var $close_date_begin ;
	var $close_date_end  	;
	
	function Init($db, $query_id)
	{
		$sql = "select * from tb_query_view where query_id=".$query_id;
		$db->ExeQuerySql($sql);
		if(!$db->FetchRow())
			return false;
			
			$this->query_id					 = $db->Get("query_id");
			$this->project_id  			 = $db->Get("project_id");
			$this->query_str 				 = $db->Get("query_str");
			$this->query_field  		 = $db->Get("query_field");
			$this->query_property 	 = $db->Get("query_property");
			$this->query_date 			 = $db->Get("query_date");
			$this->issue_type  			 = $db->Get("issue_type");
			$this->issue_status 		 = $db->Get("issue_status");
			$this->serverity   			 = $db->Get("serverity");
			$this->priority    			 = $db->Get("priority");
			$this->create_user  		 = $db->Get("create_user");
			$this->process_user    	 = $db->Get("process_user");
			$this->create_date_begin = $db->Get("create_date_begin");
			$this->create_date_end 	 = $db->Get("create_date_end");
			$this->close_date_begin  = $db->Get("close_date_begin");
			$this->close_date_end  	 = $db->Get("close_date_end");
		
		$db->FreeResult();
		return true;
	}
};

class CResult
{
	var $query_id;
	var $total_count;
	var $page_count;
	var $page_size;
	var $page_number;
	var $issues;
	
	function CResult()
	{
		$this->issues = array();	
	}
}

class CModuleQuery extends CModuleBase
{
	var $query_info;
	
	function InitModule($module_id, $page=1)
	{
		global $Config;
		
		//初始化查询信息
		if($module_id > 0)
		{
			$this->query_info = new CQueryInfo();
			if(!$this->query_info->Init($this->db, $module_id))
				return;
		}
		
		//查询结果数量 分页
		$sql = $this->GetQueryCountSql($module_id);
		$this->db->ExeQuerySql($sql);	
		$ncount = 0;
		if($this->db->FetchRow())
			$ncount = $this->db->Get("nCount");
		$this->db->FreeResult();
		
		$this->module = new CResult();
		$this->module->query_id = $module_id;
		$this->module->page_size = $Config["pagesize"];
		$this->module->total_count = $ncount;
		$this->module->page_count = (int)( ($this->module->total_count-1)/$this->module->page_size )+1;
		$this->module->page_number = ($page<1)? 1 : ( ( $page>$this->module->page_count) ? $this->module->page_count:$page);
		
		//查询数据
		$sql = $this->GetQuerySql($module_id, $this->module->page_number);
		$this->db->ExeQuerySql($sql);	
		while($this->db->FetchRow())
		{			
			$mod = new CListInfo();
			$mod->issue_id				= $this->db->Get("issue_id");
			$mod->project_name		= $this->db->Get("project_name");
			$mod->issue_type_name	= $this->db->Get("issue_type_name");	
			$mod->issue_title			= $this->db->Get("issue_title");
			$mod->priority				= $Config["priority"][$this->db->Get("pripority_id")];
			$mod->serverity				= $Config["serverity"][$this->db->Get("serverity_id")];
			$mod->status_name			= $this->db->Get("status_name");
			$mod->create_user			= $this->db->Get("real_name");
			$mod->create_time			= $this->db->Get("create_time");
			$mod->exp_time				= $this->db->Get("exp_time");
			$mod->close_time			= $this->db->Get("close_time");
			$mod->is_close				= $this->db->Get("is_close");
			$this->module->issues[sizeof($this->module->issues)] = $mod;
		}
		$this->db->FreeResult();
		
		for($i=0;$i<sizeof($this->module->issues);$i++)
		{
			$this->module->issues[$i]->CalcExp();
			$this->module->issues[$i]->InitWorkers($this->db);
		}
	}
	
	function GetQueryCountSql($query_id)
	{
		global $UserInfo;
		$sql = '';
		
		if($query_id == '0')//等待我处理
		{
			$sql = "select count(*) nCount from tb_issue a, tb_issue_action_user b ";
			$sql = $sql . " where a.issue_id=b.issue_id and b.action_id=0 and (b.action_user_id=".$UserInfo['UID']." or b.consign_user_id=".$UserInfo['UID'].")";
		}
		else if($query_id == '-1')//由我创建
		{
			$sql = "select count(*) nCount from tb_issue";
			$sql = $sql . " where create_user=".$UserInfo['UID'];
		}
		else if($query_id == '-2')//我处理过
		{
			$sql = "select count(*) nCount from tb_issue a, tb_issue_log b ";
			$sql = $sql . " where a.issue_id = b.issue_id and b.user_id=".$UserInfo['UID'];
		}
		else //组合查询
		{
			$sql = "select count(*) nCount from tb_issue a ";
			
			//有用户查询条件
			if($this->query_info->query_property > 0 && $this->query_info->create_user <> '')
				$sql = $sql . " , tb_user f ";
				
			$sql = $sql . $this->GetQueryClause();
			$sql = $sql . " and a.is_delete=0 ";
		}
		
		return $sql;
	}
	
	function GetQuerySql($query_id, $page)
	{
		global $UserInfo, $Config;
		$sql = "select distinct a.issue_id, a.issue_title, a.pripority_id, a.serverity_id, a.is_close, a.create_time,a.close_time, a.exp_time, ";
		$sql = $sql . " b.project_name, ";
		$sql = $sql . " d.issue_type_name,";
		$sql = $sql . " e.state_name status_name, ";
		$sql = $sql . " f.real_name ";			
		$sql = $sql . " from tb_issue a, tb_project b, tb_project_issue_type d, tb_flow_status e, tb_user f ";
		
		$sql_tail = " and a.project_id=b.project_id ";
		$sql_tail = $sql_tail . " and a.issue_type_id=d.issue_type_id ";
		$sql_tail = $sql_tail . " and a.status_id=e.status_id  ";
		$sql_tail = $sql_tail . " and a.create_user=f.user_id ";
		$sql_tail = $sql_tail . " and a.is_delete=0 ";
		$sql_tail = $sql_tail . " order by is_close, a.issue_id desc ";
		$sql_tail = $sql_tail . " limit ". (($page-1) * $Config["pagesize"]) . ",".$Config["pagesize"];
		
		$sql_mid = ""; 
		if($query_id == '0')//等待我处理
		{
				$sql_mid = $sql_mid . ", tb_issue_action_user g ";
				$sql_mid = $sql_mid . " where a.issue_id=g.issue_id and g.action_id=0 and ";
				$sql_mid = $sql_mid ." (g.action_user_id=".$UserInfo['UID']." or g.consign_user_id=".$UserInfo['UID'].")";
		}
		else if($query_id == '-1')//由我创建
		{
				$sql_mid = $sql_mid . " where a.create_user=".$UserInfo['UID'];
		}
		else if($query_id == '-2')//我处理过
		{
				$sql_mid = $sql_mid . ", tb_issue_log g ";
				$sql_mid = $sql_mid . " where a.issue_id = g.issue_id and g.user_id=".$UserInfo['UID'];
		}
		else
			$sql_mid = $this->GetQueryClause();
		
		$sql = $sql . $sql_mid . $sql_tail;
		
		return $sql;
	}
	
	function GetQueryClause()
	{
			$sql_mid = "";
			if($this->query_info->query_field & 1)
				$sql_mid = $sql_mid . " where a.issue_title like '%".$this->query_info->query_str."%' ";
			else
				$sql_mid = $sql_mid . " where a.issue_title <> '' ";
			
			if($this->query_info->query_field & 2)
				$sql_mid = $sql_mid . " where a.issue_content like '%".$this->query_info->query_str."%' ";
				
			if($this->query_info->project_id > 0)
				$sql_mid = $sql_mid . " and a.project_id=".$this->query_info->project_id;
			
			if($this->query_info->query_property > 0)
			{
				if($this->query_info->issue_type > 0)
					$sql_mid = $sql_mid . " and a.issue_type_id=".$this->query_info->issue_type;
				if($this->query_info->issue_status > 0)
					$sql_mid = $sql_mid . " and a.status_id=".$this->query_info->issue_status;
				if($this->query_info->serverity > 0)
					$sql_mid = $sql_mid . " and a.serverity_id=".$this->query_info->serverity;					
				if($this->query_info->priority > 0)
					$sql_mid = $sql_mid . " and a.pripority_id=".$this->query_info->priority;					
				if($this->query_info->create_user <> '')
					$sql_mid = $sql_mid . " and f.real_name like '%".$this->query_info->create_user."%' ";
				if($this->query_info->process_user <> '')
					$sql_mid = $sql_mid . " and a.issue_id in (select a.issue_id from tb_issue_action_user a, tb_user b where a.action_id=0 and a.action_user_id=b.user_id and b.real_name like '%".$this->query_info->process_user."%' ) ";
			}
			
			if($this->query_info->query_date > 0)
			{
				if($this->query_info->create_date_begin != '0000-00-00')
					$sql_mid = $sql_mid . " and a.create_time>='".$this->query_info->create_date_begin."'";
				
				if($this->query_info->create_date_end != '0000-00-00')
					$sql_mid = $sql_mid . " and a.create_time<='".$this->query_info->create_date_end."'";
					
				if($this->query_info->close_date_begin != '0000-00-00')
					$sql_mid = $sql_mid . " and a.close_time>='".$this->query_info->close_date_begin."'";
					
				if($this->query_info->close_date_end != '0000-00-00')
					$sql_mid = $sql_mid . " and a.close_time>='".$this->query_info->close_date_end."'";
			}
			
			return $sql_mid;
	}
	
};
?>
