﻿$(window).load(function(){Init();});

function Init()
{	
	//部门相关操作
	$('#add_dept').click(function(e){
		OpenDialog("dialog/dialog.php?dlg=dlg_dept", 400, 240);
	});
	//角色相关操作
	$('#add_role').click(function(e){
		OpenDialog("dialog/dialog.php?dlg=dlg_role", 400, 240);
	});
	//用户相关操作
	$('#add_user').click(function(e){
		OpenDialog("dialog/dialog.php?dlg=dlg_user", 500, 360);
	});
	//增加改项目信息
	$('#project_op').click(function(e){
		OpenDialog("dialog/dialog.php?dlg=dlg_project", 400, 260);
	});
	//增加事务类型
	$('#add_issuetype').click(function(e){		
		OpenDialog("dialog/dialog.php?dlg=dlg_issuetype&project_id="+$('#project_id').val(), 400, 260);
	});
}

//点击编辑部门
function ClickEditDept(dept_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_dept&job=mod&dept_id="+dept_id, 400, 240);
}

//点击删除部门
function ClickDelDept(dept_id, dept_name)
{
	if(confirm('确认删除部门: '+dept_name+' ?'))
	{
		$.ajax({
			type: "POST",
		  url: "control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_dept",
				job:'del',
				dept_id:dept_id
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				switch(data)
				{
					case 1: //部门成员不为空,删除失败
						alert('部门成员不为空,删除失败');
						return;
					break;
				}
				window.location.reload(true); 
			}
		});	
	}	
}

//提交增加部门
function SubmitDept(job)
{
	//判断部门名称是否合法
	var dept_name = $('#dept_name').val();
	var dept_desc = $('#dept_desc').val();
	
	if(dept_name == '')
	{
		alert("部门名称不能为空");
		return;
	}
	if(dept_name.length >36)
	{
		alert("部门名称超出长度");
		return;
	}
	if(dept_desc.length >128)
	{
		alert("部门描述超出长度");
		return;	
	}
	
	$.ajax({
			type: "POST",
		  url: "../control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_dept",
				job:job,
				dept_id:$('#dept_id').val(),
				parent_id:$('#parent_id').val(),
				dept_name:$('#dept_name').val(),
				dept_desc:$('#dept_desc').val()
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				if(data == 2)
					alert('部门名称相同');
				else
					CloseDialog(1);
			}
	});	
}

//点击编辑角色
function ClickEditRole(role_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_role&job=mod&role_id="+role_id, 400, 240);
}

//点击删除角色
function ClickDelRole(role_id, role_name)
{
	if(confirm('确认删除角色: '+role_name))
	{
			$.ajax({
			type: "POST",
		  url: "control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_role",
				job:'del',
				role_id:role_id
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				switch(data)
				{
					case 1: //角色成员不为空,删除失败
						alert('角色成员不为空,删除失败');
						return;
					break;
				}
				window.location.reload(true); 
			}
		});	
	}	
}

//提交增加角色
function SubmitRole(job)
{
	var role_grade=0;
	for(i=0; i<$(':checkbox').length; i++)
	{
		if($(':checkbox').eq(i).attr("checked") == "checked")
			role_grade |= $(':checkbox').eq(i).val();
	}
	
	$.ajax({
			type: "POST",
		  url: "../control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_role",
				job:job,
				role_id:$('#role_id').val(),
				role_name:$('#role_name').val(),
				role_desc:$('#role_desc').val(),
				role_grade:role_grade
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				if(data == 2)
					alert("角色名称相同");
				else
					CloseDialog(1);
			}
	});	
}

//点击编辑用户
function ClickEditUser(user_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_user&job=mod&user_id="+user_id, 500, 360);
}

//点击取消用户
function ClickCancelUser(user_id, user_name)
{
	if(confirm('确认关闭用户: '+user_name))
	{
			$.ajax({
			type: "POST",
		  url: "control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_user",
				job:'cancel',
				user_id:user_id
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				window.location.reload(true); 
			}
		});	
	}	
}

//点击删除用户
function ClickDelUser(user_id, user_name)
{
	if(confirm('确认删除用户: '+user_name))
	{
			$.ajax({
			type: "POST",
		  url: "control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_user",
				job:'del',
				user_id:user_id
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				window.location.reload(true); 
			}
		});	
	}	
}

//点击恢复用户
function ClickBackUser(user_id)
{
		$.ajax({
			type: "POST",
		  url: "control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_user",
				job:'back',
				user_id:user_id
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				window.location.reload(true); 
			}
		});		
}

//提交增加用户
function SubmitUser(job)
{
	$.ajax({
		type: "POST",
		url: "../control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_user",
				job:job,
				user_id:$('#user_id').val(),
				user_name:$('#user_name').val(),
				user_pwd:$('#user_pwd').val(),
				real_name:$('#real_name').val(),
				email:$('#email').val(),
				ip:$('#ip').val(),
				phone:$('#phone').val(),
				photo:$('#photo').attr('src'),
				dept_id:$('#dept_id').val(),
				role_id:$('#role_id').val(),
				user_state:1
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				if(data == 2)
					alert("用户名称相同");
				else
					CloseDialog(1);
			}
	});	
}

//提交状态修改
function SubmitState()
{
	var state_type=0;
	for(i=0; i<$(':radio').length; i++)
	{
		if($(':radio').eq(i).attr("checked") == "checked")
		{
			state_type = $(':radio').eq(i).val();
			break;
		}
	}
	
	var state_id = $('#state_id').val();
	var state_name = $('#state_name').val();
	var state_title = $('#state_title').val();
	
	var json_value = "{";
	json_value += "'obj_type':1";
	json_value += ",'state_id':'"+state_id+"'";
	json_value += ",'state_type':"+state_type;
	json_value += ",'state_name':'"+state_name+"'";
	json_value += ",'state_title':'"+state_title+"'";
	json_value += "}";
	CloseDialog(json_value);
}

//提交动作修改
function SubmitAction()
{
	var action_id = $('#action_id').val();
	var action_name = $('#action_name').val();
	var action_title = $('#action_title').val();
	
	var json_value = "{";
	json_value += "'obj_type':2";
	json_value += ",'action_id':'"+action_id+"'";
	json_value += ",'action_name':'"+action_name+"'";
	json_value += ",'action_title':'"+action_title+"'";
	json_value += "}";
	CloseDialog(json_value);
}

//提交保存流程
function SubmitSaveFlow()
{
	var flow_id = $('#flow_id').val();
	var flow_name = $('#flow_name').val();

	$.ajax({
		type: "POST",
		url: "../control/daemon.php",
		dataType: "text",
		data: { 
			job:'getFlowCount',
			flow_id:flow_id,
			flow_name:flow_name
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			if(data>0)
				alert('流程名称重复');
			else
				CloseDialog(flow_name);
		}
	});
}

//删除流程
function DelFlow(flow_id, flow_name)
{
	if(flow_id==0) return;
	if(confirm("确认要删除流程: " + flow_name + " 吗?"))
	{
		$.ajax({
			type: "POST",
			url: "control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_flow",
				job:"del",
				flow_id:flow_id
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				alert("流程已删除");
				KisFlow._clear();
			}
		});
	}
}

//装载流程
function LoadFlow(flow_id)
{	
	$.ajax({
		type: "POST",
		url: "control/daemon.php",
		dataType: "text",
		data: { 
			job:'loadFlow',
			flow_id:flow_id
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			KisFlow._clear();
			KisFlow._load(data);
		}
	});
}

//点击编辑项目
function ClickEditProject(project_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_project&job=mod&project_id="+project_id, 400, 260);
}

//点击删除项目
function ClickDelProject(project_id, project_name)
{
	if(confirm('确认删除项目: '+project_name))
	{
		$.ajax({
			type: "POST",
			url: "control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_project",
				job:'del',
				project_id:project_id
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				window.location.reload(true); 
			}
		});	
	}	
}
//提交增加项目
function SubmitProject(job)
{
	var project_state=0;
	for(i=0; i<$(':radio').length; i++)
	{
		if($(':radio').eq(i).attr("checked") == "checked")
		{
			project_state = $(':radio').eq(i).val();
			break;
		}
	}
	
	$.ajax({
		type: "POST",
		url: "../control/doaction.php",
		dataType: "text",
		data: { 
			action:"cfg_project",
			job:job,
			project_id:$('#project_id').val(),
			project_name:$('#project_name').val(),
			project_code:$('#project_code').val(),
			project_desc:$('#project_desc').val(),
			project_state: project_state
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{			
			if(data == 2)
				alert("项目名称相同");
			else
				CloseDialog(1);
		}
	});	
}

//点击编辑事务类型
function ClickEditIssueType(type_id, project_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_issuetype&job=mod&project_id="+project_id+"&type_id="+type_id, 400, 260);
}

//点击删除事务类型
function ClickDelIssueType(type_id, type_name)
{
	if(confirm('确认删除事务类型: '+type_name))
	{
		$.ajax({
			type: "POST",
			url: "control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_project_issuetype",
				job:'del',
				type_id:type_id
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				window.location.reload(true); 
			}
		});	
	}	
}

//提交增加事务类型
function SubmitIssueType(job)
{	
	$.ajax({
		type: "POST",
		url: "../control/doaction.php",
		dataType: "text",
		data: { 
			action:"cfg_project_issuetype",
			job:job,
			type_id : $('#type_id').val(),
			project_id:$('#project_id').val(),
			flow_id:$('#flow_id').val(),
			type_name:$('#type_name').val(),
			type_desc:$('#type_desc').val()
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{			
			if(data == 2)
				alert("事务类型名称相同");
			else
				CloseDialog(1);
			//alert(data);	
		}
	});	
}

//点击编辑工作组
function ClickEditWorkGroup(job, group_id, project_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_workgroup&job="+job+"&project_id="+project_id+"&group_id="+group_id, 500, 400);
}

//点击删除工作组
function ClickDelWorkGroup(group_id, group_name)
{
	if(confirm('确认删除工作组: '+group_name))
	{
		$.ajax({
			type: "POST",
			url: "control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_workgroup",
				job:'del',
				group_id:group_id
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				window.location.reload(true); 
			}
		});	
	}	
}

//提交增加工作组
function SubmitWorkGroup(job)
{
	var group_grade=0;
	for(i=0; i<$(':checkbox').length; i++)
	{
		if($(':checkbox').eq(i).attr("checked") == "checked")
			group_grade |= $(':checkbox').eq(i).val();
	}
	
	var group_members = document.getElementById("group_members").options;
	var members = "[";
	for(var i=1; i<group_members.length; i++)
	{
		if(group_members[i].value==-1) continue;
		
		if(i>1) members += ",";
		members += group_members[i].value;
	}
	members += "]";
	
	$.ajax({
		type: "POST",
		url: "../control/doaction.php",
		dataType: "text",
		data: { 
			action:"cfg_workgroup",
			job:job,
			group_id:$('#group_id').val(),
			project_id:$('#project_id').val(),
			group_name:$('#group_name').val(),
			group_desc:$('#group_desc').val(),
			group_grade:group_grade,
			members : members
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			if(data == 2)
				alert("工作组名称相同");
			else
				CloseDialog(1);
		}
	});
}

//获取部门成员
function CallDeptMember()
{
	var dept_id = $('#dept_id').val();
	if(dept_id == -1) return;
	
	$.ajax({
		type: "POST",
		url: "../control/daemon.php",
		dataType: "text",
		data: { 
			job:'getDeptMember',
			dept_id:dept_id
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			var objs = eval( "(" +data+")" );
			var dept_members=document.getElementById("dept_members");
			dept_members.options.length=1;
			
			for(var i=0; i<objs.length; i++)
			{
				dept_members.add(document.createElement("option"));
				dept_members.options[i+1].value = objs[i].user_id;
				dept_members.options[i+1].text =objs[i].real_name;		
			}
		}
	});	
}

//增加工作组成员
function AddGroupMember()
{
	var dept_members=document.getElementById("dept_members").options;
	var group = document.getElementById("group_members");
	var group_members=group.options;
	
	for(var i=0; i<dept_members.length; i++)
	{
		if(!dept_members[i].selected) continue;
		if(dept_members[i].value == -1) continue;
		
		//检查成员是否重复
		var is_repeat = 0;
		for(var n=0; n<group_members.length; n++)
		{
			if(group_members[n].value == dept_members[i].value)
			{
				is_repeat = 1;
				break;
			}
		}
		
		if(is_repeat) {
			alert( dept_members[i].text + " 已经加入工作组" );
			continue;
		}
		//添加
		var index=group_members.length;
		group.add(document.createElement("option"));
		group.options[index].value = dept_members[i].value;
		group.options[index].text = dept_members[i].text;
	}
}

//减少工作组成员
function DelGroupMember()
{
	var group = document.getElementById("group_members");
	var group_members=group.options;
	for(var i=0; i<group_members.length; i++)
	{
		if(!group_members[i].selected) continue;
		if(group_members[i].value==-1) continue;
		
		for(var n=i; n<(group_members.length-1); n++)
		{
			group_members[n].value = group_members[n+1].value;
			group_members[n].text = group_members[n+1].text;
		}
		group_members.length--;
	}
}

//点击编辑项目模块
function ClickEditModule(job, module_id, parent_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_module&job="+job+"&project_id="+$('#project_id').val()+"&module_id="+module_id+"&parent_id="+parent_id, 500, 260);
}

//删除项目模块
function ClickDelModule(module_id, module_name)
{
	if(confirm("确认要删除模块: "+module_name+" 吗?"))
	{
		$.ajax({
			type: "POST",
			url: "control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_module",
				job:'del',
				module_id:module_id
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				window.location.reload(true); 
			}
		});	
	}
}

//提交项目模块
function SubmitModule(job)
{	
	$.ajax({
		type: "POST",
		url: "../control/doaction.php",
		dataType: "text",
		data: { 
			action:"cfg_module",
			job:job,
			module_id:$('#module_id').val(),
			parent_id:$('#parent_id').val(),
			project_id:$('#project_id').val(),
			module_name:$('#module_name').val(),
			module_desc:$('#module_desc').val(),
			manager_id:$('#manager_id').val()
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			CloseDialog(1);
		}
	});
}

//点击编辑项目字段
function ClickEditField(job, project_id, field_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_fields&job="+job+"&project_id="+project_id+"&field_id="+field_id, 500,360);
}

//删除项目字段
function ClickDelField(field_id, field_title)
{
	if(confirm("确认要删除字段: "+field_title+" 吗?"))
	{
		$.ajax({
			type: "POST",
			url: "control/doaction.php",
			dataType: "text",
			data: { 
				action:"cfg_fields",
				job:'del',
				field_id:field_id
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				//alert(data);
				window.location.reload(true); 
			}
		});	
	}
}

//提交项目字段
function SubmitField(job)
{	
	if(IsNull($("#field_title").val()))
	{
		alert("字段标题不能为空");
		return;	
	}
	
	$.ajax({
		type: "POST",
		url: "../control/doaction.php",
		dataType: "text",
		data: { 
			action:"cfg_fields",
			job:job,
			project_id:$('#project_id').val(),
			field_id:$("#field_id").val(),
			field_title:$("#field_title").val(),
			field_desc:$("#field_desc").val(),
			field_type:$("#field_type").val(),
			field_len:$("#field_len").val(),
			field_width:$("#field_width").val(),
			field_height:$("#field_height").val(),
			field_default:$("#field_default").val(),
			field_option:$("#field_option").val(),		
			field_desc:$("#field_desc ").val()
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			CloseDialog(1);
		}
	});
}

//关闭显示层
function CloseLayer()
{
	$("#display_div").css("display", "none");
}

//显示事务处理成员
function OpenMemberLayer(project_id, flow_id, issue_typeid)
{
	var l = event.clientX;
	if(document.body.scrollLeft > 0)
		l += parseInt(document.body.scrollLeft);
	
	var t = event.clientY;
	if(document.body.scrollTop > 0)
		t += parseInt(document.body.scrollTop);
	
	$("#display_div").css("position", "absolute");
	$("#display_div").css("left", l);
	$("#display_div").css("top", t);
	$("#display_div").css("display", "block");
	$("#display_span").html('');
	
	$.ajax({
		type: "POST",
		url: "control/daemon.php",
		dataType: "text",
		data: { 
			job:'getActionMember',
			flow_id:flow_id,
			issue_typeid:issue_typeid
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			var objs = eval( "(" +data+")" );
			var tb = "<table width=100% border=0 cellspacing='1' cellpadding='0' bgcolor='#000000'>";
			tb+="<tr height=30 bgcolor=#cccccc>";
			tb+="<td width=80><b>动作名称</td>";
			tb+="<td width=100><b>状态转换</td>";
			tb+="<td width=100><b>动作描述</td>";
			tb+="<td width=320><b>处理成员</td>";
			tb+="<td width=40 align=center><b>操作</td>";
			tb+="</tr>";
			
			for(var i=0; i<objs.length; i++)
			{
				tb+="<tr height=30 bgcolor=#ffffff onmouseover=\"setPointer(this, 'over', '#D0DCE0', '#ffffff');\" onmouseout=\"setPointer(this, 'out', '#D0DCE0', '#ffffff');\">";
				tb+="<td align=center>"+objs[i].action_name+"</td>";
				tb+="<td align=center>"+objs[i].src_status+" => "+objs[i].dst_status+"</td>";
				tb+="<td align=center>"+objs[i].action_title+"</td>";
				tb+="<td>";
				for(var n=0; n<objs[i].members.length; n++)
				{
					tb += objs[i].members[n].member_name;
					if(objs[i].members[n].member_type)
						tb+= " [工作组]";
					tb += "; ";
					if((n+1)%3==0 && n>0) tb+="<br>";
				}
				tb+="</td>";
				tb+="<td align=center><img src='imgs/b_edit.png' alt='编辑处理成员' class='link' onclick='ClickEditActionMember("+project_id+","+issue_typeid+","+objs[i].action_id+")'></td>";
				tb+="</tr>";
			}
			
			tb+="</table>";
			
			$("#display_span").html(tb);
		}
	});	
}

//显示字段编辑规则
var EDIT_RULES = ['可选编辑','必须编辑'];
function OpenFieldLayer(project_id, flow_id, issue_typeid)
{
	var l = event.clientX;
	if(document.body.scrollLeft > 0)
		l += parseInt(document.body.scrollLeft);
	
	var t = event.clientY;
	if(document.body.scrollTop > 0)
		t += parseInt(document.body.scrollTop);
	
	$("#display_div").css("position", "absolute");
	$("#display_div").css("left", l);
	$("#display_div").css("top", t);
	$("#display_div").css("display", "block");
	$("#display_span").html('');
	
	$.ajax({
		type: "POST",
		url: "control/daemon.php",
		dataType: "text",
		data: { 
			job:'getActionField',
			project_id:project_id,
			flow_id:flow_id,
			issue_typeid:issue_typeid
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			var objs = eval( "(" +data+")" );
			var tb = "<table width=100% border=0 cellspacing='1' cellpadding='0' bgcolor='#000000'>";
			tb+="<tr height=30 bgcolor=#cccccc>";
			tb+="<td width=80><b>动作名称</td>";
			tb+="<td width=100><b>状态转换</td>";
			tb+="<td width=100><b>动作描述</td>";
			tb+="<td><b>字段编辑规则</td>";
			tb+="<td width=40 align=center><b>操作</td>";
			tb+="</tr>";
			
			for(var i=0; i<objs.length; i++)
			{
				tb+="<tr height=30 bgcolor=#ffffff onmouseover=\"setPointer(this, 'over', '#D0DCE0', '#ffffff');\" onmouseout=\"setPointer(this, 'out', '#D0DCE0', '#ffffff');\">";
				tb+="<td align=center>"+objs[i].action_name+"</td>";
				tb+="<td align=center>"+objs[i].src_status+" => "+objs[i].dst_status+"</td>";
				tb+="<td align=center>"+objs[i].action_title+"</td>";
				tb+="<td><table width=100% border=0 cellspacing='0' cellpadding='0'>";
				for(var n=0; n<objs[i].fields.length;n++)
				{
					tb+="<tr>";
					tb+="<td width=30% align=center>"+objs[i].fields[n].field_title+"</td>";
					tb+="<td width=30%>"+objs[i].fields[n].field_type_title+"</td>";
					tb+="<td>"+EDIT_RULES[objs[i].fields[n].edit_rule]+"</td>";
					tb+="</tr>";
				}
				tb+="</table></td>";
				tb+="<td align=center><img src='imgs/b_edit.png' alt='编辑字段规则' class='link' onclick='ClickEditActionField("+project_id+","+issue_typeid+","+objs[i].action_id+")'></td>";
				tb+="</tr>";
			}
			
			tb+="</table>";
			
			$("#display_span").html(tb);
		}
	});	
}

function ClickEditActionMember(project_id, issue_typeid, action_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_action_member&project_id="+project_id+"&issue_typeid="+issue_typeid+"&action_id="+action_id, 500,360);	
}

//获取工作组成员
function CallGroupMember()
{
	var group_id = $('#group_id').val();
	if(group_id == -1) return;
	
	$.ajax({
		type: "POST",
		url: "../control/daemon.php",
		dataType: "text",
		data: { 
			job:'getGroupMember',
			group_id:group_id
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{			
			var obj = eval( "(" +data+")" );
			var group_members=document.getElementById("group_members");
			group_members.options.length=1;
			
			for(var i=0; i<obj.group_members.length; i++)
			{
				group_members.add(document.createElement("option"));
				group_members.options[i+1].value = obj.group_members[i].user_id;
				group_members.options[i+1].text =obj.group_members[i].real_name;		
			}
		}
	});	
}

//增加工作组为事务处理成员
function AddActionGroup(group)
{
	var action = document.getElementById("action_members");
	var action_members=action.options;
	
	var groups=document.getElementById("group_id").options;
	for(var i=0; i<groups.length; i++)
	{
		if(!groups[i].selected) continue;
		if(groups[i].value == -1) continue;
		
		//检查成员是否重复
		var is_repeat = 0;
		for(var n=0; n<action_members.length; n++)
		{
			if(action_members[n].text.indexOf('[工作组]')<0) continue; //非工作组不加入比较
			if(action_members[n].value == groups[i].value)
			{
				is_repeat = 1;
				break;
			}
		}
		
		if(is_repeat) {
			alert( groups[i].text + " 已经加入事务处理成员" );
			continue;
		}
		
		//添加
		var index=action_members.length;
		action.add(document.createElement("option"));
		action.options[index].value = groups[i].value;
		action.options[index].text = groups[i].text+' [工作组]';
	}
}

//增加动作处理成员
function AddActionMember()
{
	var group_members=document.getElementById("group_members").options;
	var action = document.getElementById("action_members");
	var action_members=action.options;
	
	for(var i=0; i<group_members.length; i++)
	{
		if(!group_members[i].selected) continue;
		if(group_members[i].value == -1) continue;
		
		
		//检查成员是否重复
		var is_repeat = 0;
		for(var n=0; n<action_members.length; n++)
		{
			if(action_members[n].text.indexOf('[工作组]')>0) continue; //工作组不加入单个用户比较
			if(action_members[n].value == group_members[i].value)
			{
				is_repeat = 1;
				break;
			}
		}
		
		if(is_repeat) {
			alert( group_members[i].text + " 已经加入事务处理成员" );
			continue;
		}
		//添加
		var index=action_members.length;
		action.add(document.createElement("option"));
		action.options[index].value = group_members[i].value;
		action.options[index].text = group_members[i].text;
	}
}

//减少工作组成员
function DelActionMember()
{
	var action = document.getElementById("action_members");
	var action_members=action.options;
	for(var i=0; i<action_members.length; i++)
	{
		if(!action_members[i].selected) continue;
		if(action_members[i].value==-1) continue;
		
		for(var n=i; n<(action_members.length-1); n++)
		{
			action_members[n].value = action_members[n+1].value;
			action_members[n].text = action_members[n+1].text;
		}
		action_members.length--;
	}
}

//提交事务处理人员修改
function SubmitActionMember()
{
	var action_members = document.getElementById("action_members").options;
	var members = "[";
	for(var i=1; i<action_members.length; i++)
	{
		if(action_members[i].value==-1) continue;
		
		if(i>1) members += ",";
		members += "{";
		members += "\"member_type\":";
		if(action_members[i].text.indexOf('[工作组]') > 0)
			members += "1";
		else
			members += "0";
		members += ",";	
		members += "\"member_id\":"+action_members[i].value;
		members += "}";
	}
	members += "]";
	//alert(members);
	//return;

	$.ajax({
		type: "POST",
		url: "../control/doaction.php",
		dataType: "text",
		data: { 
			action:"cfg_actionmember",
			job:'mod',
			issue_typeid:$("#issue_typeid").val(),
			action_id:$("#action_id").val(),
			members : members
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			CloseDialog(1);
		}
	});	
}

//编辑字段规则
function ClickEditActionField(project_id, issue_typeid, action_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_action_field&project_id="+project_id+"&issue_typeid="+issue_typeid+"&action_id="+action_id, 500,360);	
}

//提交修改字段编辑
function SubmitActionField()
{
	var rules = "[";
	var count =0;
	for(var i=0; i<$(':checkbox').length; i++)
	{
		if($(':checkbox').eq(i).attr("checked") != "checked") continue;
		var field_id = $(':checkbox').eq(i).attr("id").replace("checkbox_", "");
		var edit_rule = $('#edit_rule_'+field_id).eq(0).attr("checked") ? 0 : 1;
		
		if(count != 0) rules += ",";
		count++;
		
		rules += "{";
		rules += "\"field_id\":"+field_id;
		rules += ",";
		rules += "\"edit_rule\":"+edit_rule;
		rules += ",";
		rules += "\"edit_order\":"+$('#edit_order_'+field_id).val();
		rules += "}";
	}
	rules += "]";

	$.ajax({
		type: "POST",
		url: "../control/doaction.php",
		dataType: "text",
		data: { 
			action:"cfg_actionfield",
			job:'mod',
			issue_typeid:$("#issue_typeid").val(),
			action_id:$("#action_id").val(),
			rules : rules
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			CloseDialog(1);
		}
	});
}

//登陆
function CheckLogin()
{
	if(IsNull($('#user_name').val()))
	{
		alert("用户名不能为空");
		return false;		
	}
	
	if(IsNull($('#user_pwd').val()))
	{
		alert("密码不能为空");
		return false;		
	}
	
	$.ajax({
		type: "POST",
		url: "action/action.login.php",
		dataType: "text",
		data: {
			job:"check",
			user_name:$("#user_name").val(),
			user_pwd:$("#user_pwd").val()
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			var obj = eval('('+data+')');
			
			if(obj.result == 0)
			{
					document.LoginForm.submit();
			}
			else if(obj.result == 1)
			{
				alert("登陆账号错误");
				return false;
			}
			else if(obj.result == 2)
			{
				alert("密码错误");
				return false;	
			}
			else if(obj.result == 3)
			{
				alert("用户已关闭");
				return false;	
			}
		}
	});
	
	return false;	
}

//获取工作组成员
function CallIssueType()
{
	var project_id = $('#project_id').val();
	
	$.ajax({
		type: "POST",
		url: "control/daemon.php",
		dataType: "text",
		data: { 
			job:'getIssueTypes',
			project_id:project_id
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			var objs = eval( "(" +data+")" );
			var issue_type=document.getElementById("issue_type");
			issue_type.options.length=0;
			
			for(var i=0; i<objs.length; i++)
			{
				issue_type.add(document.createElement("option"));
				issue_type.options[i].value = objs[i].type_id;
				issue_type.options[i].text =objs[i].type_name;		
			}
			CallAction();
		}
	});	
}

function CallIssueType2()
{
	var project_id = $('#project_id').val();
	
	$.ajax({
		type: "POST",
		url: "../control/daemon.php",
		dataType: "text",
		data: { 
			job:'getIssueTypes',
			project_id:project_id
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			var objs = eval( "(" +data+")" );
			var issue_type=document.getElementById("issue_type");
			issue_type.options.length=0;
			
			for(var i=0; i<objs.length; i++)
			{
				issue_type.add(document.createElement("option"));
				issue_type.options[i].value = objs[i].type_id;
				issue_type.options[i].text =objs[i].type_name;		
			}
		}
	});	
}

//获取事物动作
function CallAction()
{
	var issue_type = $('#issue_type').val();
	$.ajax({
		type: "POST",
		url: "control/daemon.php",
		dataType: "text",
		data: { 
			job:'getActions',
			issue_type:issue_type
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{			
			var objs = eval( "(" +data+")" );
			var action=document.getElementById("issue_action");
			action.options.length=0;
			
			for(var i=0; i<objs.length; i++)
			{
				action.add(document.createElement("option"));
				action.options[i].value = objs[i].action_id;
				action.options[i].text =objs[i].action_name;		
			}
			CallActionUser();
		}
	});	
}

//获取可编辑字段
function CallActionEditField()
{
	var issue_type = $('#issue_type').val();
	var action_id = $('#issue_action').val();

	$.ajax({
		type: "POST",
		url: "control/daemon.php",
		dataType: "text",
		data: { 
			job:'getActionEditFields',
			issue_type:issue_type,
			action_id:action_id
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			fields = eval('('+data+')');
			if(fields.field_count==0)
				$("#edit_content").html("");
			else
				$("#edit_content").html(fields.field_str);
		}
	});
}
//获取处理人
function CallActionUser()
{
	var issue_type = $('#issue_type').val();
	var action_id = $('#issue_action').val();
	
	$.ajax({
		type: "POST",
		url: "control/daemon.php",
		dataType: "text",
		data: { 
			job:'getNextActionMember',
			issue_type:issue_type,
			action_id:action_id
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{		
			var obj = eval( "(" +data+")" );
			
			str = "";
			if( obj.dst_status_type==4 ) //目标状态是多人处理
			{
				//alert(obj.depts);
				str += "<input type=hidden value='0' id='action_user' name='action_user'>";
				str += "<table width=200 border=0 cellspacing='1' cellpadding='0' bgcolor='#000000'>";
				str += "<tr bgcolor='#ffffff' height=20>";
				str += "<td id='action_user_name'>&nbsp;</td><td width=20><img id='action_user_img' src='imgs/pg_down.gif' align=right style='cursor:hand' onclick=\"DisplayActionUser()\"></td>";
				str += "</tr>";
				str += "</table>";
				
				str += "<div id='user_list' style='border:1px solid #000;width:200px;height:180px;overflow-y:auto;display:none;'>";
				
				str += "<table width=100% border=0 cellspacing='0' cellpadding='0' bgcolor=#ffffff>";
				str += "<tr>";
				str += "<td>";
				str += "<select class=box id='action_dept' onchange='ChangeActionDept()'>";
				str += "<option value=0>-------------------选择部门-------------------</option>";
				str += obj.depts;
				str += "</select>";
				str += "</td>";
				str += "</tr>";
				str += "</table>";
				
				str += "<div id='action_members'>";
				str += "<table width=100% border=0 cellspacing='0' cellpadding='0' bgcolor=#ffffff>";
				for(var i=0; i<obj.members.length; i++)
				{
					var a = new ActionMember(obj.members[i].member_id, obj.members[i].member_name, obj.members[i].dept_id);
					ams.push(a);
					str += "<tr onmouseover=\"ChangeActionUser('#0080ff',"+i+")\" onmouseout=\"ChangeActionUser('#ffffff',"+i+")\">";
					str += "<td>";
					str += "<input id='action_user_box' type=Checkbox value="+obj.members[i].member_id+" onclick='CheckActionUser(this, "+i+")'>";
					str += "<span id='action_user_"+i+"'>"+obj.members[i].member_name+"</span>";
					str += "<br>";
					str += "</td>";
					str += "</tr>";
				}
				str += "</table>";
				str += "</div>";
				str += "</div>";				
			}
			else
			{
				str += "<select id='action_user' name='action_user' class='box'>";
				for(var i=0; i<obj.members.length; i++)
					str += "<option value="+obj.members[i].member_id+">"+obj.members[i].member_name+"</option>";	

				str += "</select>";
			}
			
			$("#select_action_user").html(str);
			
			CallActionEditField();
		}
	});
}
//获取处理动作的目标状态
function CallActionStatus()
{
	var action_id = $('#issue_action').val();
	$.ajax({
		type: "POST",
		url: "control/daemon.php",
		dataType: "text",
		data: { 
			job:'getActionStatus',
			action_id:action_id
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			var objs = eval( "(" +data+")" );
			var action_user=document.getElementById("action_user");
			action_user.options.length=1;
			
			for(var i=0; i<objs.length; i++)
			{
				action_user.add(document.createElement("option"));
				action_user.options[i+1].value = objs[i].member_id;
				action_user.options[i+1].text =objs[i].member_name;		
			}
		}
	});
}

//提交事务信息
var upload_array = ['gif','jpg','png','bmp', 'rar','zip','txt','doc','xls','ppt','chm','hlp','pdf','vsd'];
function SubmitIssue()
{
	//1 检查输入是否正常
	if( IsNull($('#issue_title').val()) )
	{
		alert("请输入事务标题");
		return;
	}
	
	//2 检查处理人员
	if($('#action_user').val() == null || $('#action_user').val()=='0')
	{
		alert( "请选择处理人员" );
		return;
	}
	
	//$('#action_users').val($('#action_user').val());
	
	//3 检查上传附件
	var attach_file = $('#attach_file').val();
	if(!IsNull(attach_file))
	{
		var is_find = 0;
		var pos = attach_file.lastIndexOf(".");
		if(pos >= 0)
		{
			
			var attr = attach_file.slice(pos+1).toLowerCase();
			for(var i=0; i<upload_array.length; i++)
			{
				if(upload_array[i] == attr)
				{
					is_find = 1;	
					break;
				}
			}
		}
		if(!is_find)
		{
			alert("上传附件类型非法");
			return;	
		}
	}
	
	$('#issue_content').val(editor.html());
	document.issue_form.submit();
}

//删除事务
function ClickDelIssue(issue_id)
{
	if(confirm("确认要删除当前事务吗?"))
	{
		$.ajax({
			type: "POST",
			url: "control/doaction.php",
			dataType: "text",
			data: { 
				action:"do_issue",
				job:'del',
				issue_id:issue_id
			},
			timeout: 1000,
			complete: function(){},
			success: function(data)
			{
				query_id = $('#hidden_query_id').val();
				view_job = $('#hidden_view_job').val();
				page = $('#hidden_page').val();
				go2web("index.php?job=issue_delte&query_id="+query_id+"&page="+page+"&view_job="+view_job);
			}
		});	
	}
}

//点击事务编辑
function ClickIssueEdit(issue_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_edit&issue_id="+issue_id, 520,400);
}

//添加事务附件
function ClickIssueAttach(issue_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_attach&issue_id="+issue_id, 500,240);
}

//事务转移
function ClickIssueTran(issue_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_tran&issue_id="+issue_id, 500,240);
}

//点击关闭事务
function ClickIssueClose(issue_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_close&issue_id="+issue_id, 520,320);
}

function SubmitIssueClose()
{
	$.ajax({
		type: "POST",
		url: "../control/doaction.php",
		dataType: "text",
		data: { 
			action:"do_issue",
			job:'close',
			issue_id:$("#issue_id").val(),
			issue_content:editor.html()
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			CloseDialog(1);
		}
	});
}

//点击事务评论
function ClickIssueComment(issue_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_comment&issue_id="+issue_id, 520,320);
}

//提交事务评论
function SubmitComment()
{
	$.ajax({
		type: "POST",
		url: "../control/doaction.php",
		dataType: "text",
		data: { 
			action:"issue_comment",
			job:'add',
			issue_id:$("#issue_id").val(),
			issue_comment:editor.html()
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			CloseDialog(1);
		}
	});	
}

//提交事务评论
function SubmitIssueTran()
{
	$.ajax({
		type: "POST",
		url: "../control/doaction.php",
		dataType: "text",
		data: { 
			action:"do_issue",
			job:'tran',
			issue_id:$("#issue_id").val(),
			project_id:$("#project_id").val(),
			issue_type:$("#issue_type").val()
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			CloseDialog(1);
		}
	});
}

//点击事务处理
function ClickIssueAction(issue_id, action_id)
{
	OpenDialog("dialog/dialog.php?dlg=dlg_issue&issue_id="+issue_id+"&action_id="+action_id, 700,540);
}

//提交事务处理
function SubmitIssueAction()
{
	if(editor.isEmpty())
	{
		alert('处理日志不能为空');
		return;
	}
	
	//2 检查处理人员
	if($('#action_user').val() == null )
	{
		alert( "请选择处理人员" );
		return;
	}
		
	//3 检查上传附件
	var attach_file = $('#attach_file').val();
	if(!IsNull(attach_file))
	{
		var is_find = 0;
		var pos = attach_file.lastIndexOf(".");
		if(pos >= 0)
		{
			
			var attr = attach_file.slice(pos+1).toLowerCase();
			for(var i=0; i<upload_array.length; i++)
			{
				if(upload_array[i] == attr)
				{
					is_find = 1;	
					break;
				}
			}
		}
		if(!is_find)
		{
			alert("上传附件类型非法");
			return;	
		}
	}
	
	$('#issue_content').val(editor.html());
	document.issue_form.submit();	
}

//提交事务编辑
function SubmitIssueEdit()
{
	if(editor.isEmpty())
	{
		alert('处理日志不能为空');
		return;
	}

	$('#issue_content').val(editor.html());
	document.issue_form.submit();	
}

//提交附件上传
function SubmitIssueAttach()
{
	//3 检查上传附件
	var attach_file = $('#attach_file').val();
	if(IsNull(attach_file))
	{
		alert('请选择需要上传的文件');
		return;
	}
	
	
	var is_find = 0;
	var pos = attach_file.lastIndexOf(".");
	if(pos >= 0)
	{	
		var attr = attach_file.slice(pos+1).toLowerCase();
		for(var i=0; i<upload_array.length; i++)
		{
			if(upload_array[i] == attr)
			{
				is_find = 1;	
				break;
			}
		}
	}
	
	if(!is_find)
	{
		alert("上传附件类型非法");
		return;	
	}
	
	document.issue_form.submit();		
}

//切换页面
function SwitchPage(page)
{
	if(page == 1)
	{
		$('ul li').eq(0).attr('class', 'active');
		$('ul li').eq(1).attr('class', '');
		$('#li_log').attr('class', '');
		$('#li_comment').attr('class', 'link');
		$('#div_issue_log').css('display', 'block');
		$('#div_issue_comment').css('display', 'none');
	}
	else
	{
		$('ul li').eq(0).attr('class', '');
		$('ul li').eq(1).attr('class', 'active');
		$('#li_log').attr('class', 'link');
		$('#li_comment').attr('class', '');
		$('#div_issue_log').css('display', 'none');
		$('#div_issue_comment').css('display', 'block');	
	}
}

//显示事务列表
function CallIssueList(query_id, page)
{
	$.ajax({
		type: "POST",
		url: "control/daemon.php",
		dataType: "text",
		data: { 
			job:'getIssueList',
			query_id:query_id,
			page:page
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			var obj = eval( "(" + data + ")" );
			var issue_list = "<table width=100% bgcolor=#FFFFFF border=0 cellspacing=1 cellpadding=0>";
			var issues = obj.issues;
			for(var i=0; i<issues.length; i++)
			{
				var linethrough = '';
				var bgcolor='#ffffff';
				if(issues[i].is_close == '1')
				{
					linethrough = "style='text-decoration:line-through'";
					bgcolor = '#cccccc';
				}
				else if(issues[i].is_exp)
					bgcolor = '#F76348';
				
				issue_list += "<tr bgcolor="+bgcolor+" onmouseover=\"setPointer(this, 'over', '#D0DCE0', '"+bgcolor+"');\" onmouseout=\"setPointer(this, 'out', '#D0DCE0', '"+bgcolor+"');\""+linethrough+">";
					
				issue_list += "<td width=80 align=center><a href='javascript:go2issue("+issues[i].issue_id+")'>#"+issues[i].issue_id+"</a></td>";
				issue_list += "<td width=120 align=center>"+issues[i].project_name+"</td>";
				issue_list += "<td width=100 align=center>"+issues[i].issue_type_name+"</td>";
				issue_list += "<td><a href='javascript:go2issue("+issues[i].issue_id+")'>"+issues[i].issue_title+"</a></td>";
				issue_list += "<td width=60 align=center>"+issues[i].serverity+"</td>";
				issue_list += "<td width=60 align=center>"+issues[i].priority+"</td>";
				issue_list += "<td width=80 align=center>"+issues[i].status_name+"</td>";
				issue_list += "<td width=80 align=center>"+issues[i].create_user+"</td>";
				issue_list += "<td width=100>";
					for(var n=0;n<issues[i].workers.length; n++)
						issue_list += issues[i].workers[n].worker_name + " ";
				issue_list += "</td>";
				issue_list += "<td width=120>"+issues[i].create_time+"</td>";
				issue_list += "<td width=120>"+issues[i].exp_time+"</td>";
				issue_list += "<td width=120>"+issues[i].close_time+"</td>";
				issue_list += "</tr>";
			}
			issue_list += "</table>";
			$('#span_issue_list').html(issue_list);
			$('#hidden_query_id').val(obj.query_id);			
			$('#hidden_page').val(obj.page_number);
			
			var page_link = "共 "+obj.total_count+" 条记录";
			page_link += " ("+obj.page_number+"/"+obj.page_count+") ";
			page_link += " <a href='javascript:goPage("+obj.query_id+",1)'>第一页</a> |";
			page_link += " <a href='javascript:goPage("+obj.query_id+","+( parseInt(obj.page_number)-1 )+")'>上一页</a> |";
			page_link += " <a href='javascript:goPage("+obj.query_id+","+( parseInt(obj.page_number)+1 )+")'>下一页</a> |";
			page_link += " <a href='javascript:goPage("+obj.query_id+","+obj.page_count+")'>最后一页</a>";			
			$('#td_page').html(page_link);
		}
	});		
}

//显示查询框
function DisplayQueryLayer(div_id)
{
	var up_img = 'imgs/pg_up.gif';
	var down_img = 'imgs/pg_down.gif';
	
	if(div_id == 'query_frame')
	{
		up_img = 'imgs/calendarPrev.gif';
		down_img = 'imgs/calendarNext.gif';
	}
	
	if($('#'+div_id).css('display') == 'none')
	{
		$('#'+div_id).css('display', 'block');
		$('#icon_'+div_id).attr('src', up_img);
		$('#icon_'+div_id).attr('alt', '隐藏查询框');
	}
	else
	{
		$('#'+div_id).css('display', 'none');
		$('#icon_'+div_id).attr('src', down_img);
		$('#icon_'+div_id).attr('alt', '展示查询框');
	}
}

//选择查询项目
function QueryChangeProject()
{
	document.getElementById("issue_status").options.length=1;
		
	var project_id = $('#project_id').val();
	$.ajax({
		type: "POST",
		url: "control/daemon.php",
		dataType: "text",
		data: { 
			job:'getIssueTypes',
			project_id:project_id
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			var objs = eval( "(" +data+")" );
			var issue_type=document.getElementById("issue_type");
			issue_type.options.length=1;
			
			for(var i=0; i<objs.length; i++)
			{
				issue_type.add(document.createElement("option"));
				issue_type.options[i+1].value = objs[i].type_id;
				issue_type.options[i+1].text =objs[i].type_name;		
			}
		}
	});	
}

//选择查询事务类型
function QueryChangeIssueType()
{
	var issue_type = $('#issue_type').val();
	if(issue_type == 0)
		document.getElementById("issue_status").options.length=1;
		
	$.ajax({
		type: "POST",
		url: "control/daemon.php",
		dataType: "text",
		data: { 
			job:'getIssueStatus',
			issue_type:issue_type
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			var objs = eval( "(" +data+")" );
			var issue_status=document.getElementById("issue_status");
			issue_status.options.length=1;
			
			for(var i=0; i<objs.length; i++)
			{
				issue_status.add(document.createElement("option"));
				issue_status.options[i+1].value = objs[i].status_id;
				issue_status.options[i+1].text =objs[i].state_name;		
			}
		}
	});	
}

function QueryReset()
{
	document.query_form.reset();
	QueryChangeProject();
}

function QueryIssue()
{
	var query_field=0;
	for(i=0; i<$(':checkbox').length; i++)
	{
		if($(':checkbox').eq(i).attr("checked") == "checked")
			query_field |= $(':checkbox').eq(i).val();
	}
	var query_property = ($('#div_property').css('display') == 'none') ? 0 : 1;
	var query_date = ($('#div_date').css('display') == 'none') ? 0 : 1;
	$.ajax({
		type: "POST",
		url: "control/doaction.php",
		dataType: "text",
		data: { 
			action: "issue_query",
			job:'add',
			project_id  : $('#project_id').val(),      
			query_str : $('#query_str').val(),     
			query_field  : query_field,     
			query_property : query_property,   
			query_date : query_date,       
			issue_type  : $('#issue_type').val(),      
			issue_status : $('#issue_status').val(),     
			serverity   : $('#severity').val(),      
			priority    : $('#priority').val(),      
			create_user  : $('#create_user').val(),     
			process_user    : $('#process_user').val(),    
			create_date_begin: $('#create_date_begin').val(), 
			create_date_end : $('#create_date_end').val(),  
			close_date_begin : $('#close_date_begin').val(), 
			close_date_end  : $('#close_date_end').val()
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			var obj = eval('(' +data+')');
			var query_id=obj.query_id;
			CallIssueList(query_id, 0);
			$('#bt_save_view').css('display','block');
		}
	});	
}

function CallSaveQueryView()
{
	var query_id = $('#hidden_query_id').val();
	if(query_id == 0) return;
	OpenDialog("dialog/dialog.php?dlg=dlg_querysave&query_id="+query_id, 360,160);
}

function SubmitQuerySave(job)
{
	if(IsNull($('#query_name').val()))
	{
		alert("视图名称不能为空");
		return false;		
	}
	
	$.ajax({
		type: "POST",
		url: "../control/doaction.php",
		dataType: "text",
		data: { 
			action:"query_save",
			job:job,
			query_id:$("#query_id").val(),
			query_name:$('#query_name').val()
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			CloseDialog(0);
		}
	});	
}

//删除视图
function DropQueryView()
{
	var query_id =$('#hidden_query_id').val();
	if(query_id==0)
	{
		alert('默认视图不能删除');
		return;
	}
	
	if(!confirm("确认要删除这个视图吗?")) return;
	
	$.ajax({
		type: "POST",
		url: "control/doaction.php",
		dataType: "text",
		data: { 
			action:"query_save",
			job:'del',
			query_id:query_id
		},
		timeout: 1000,
		complete: function(){},
		success: function(data)
		{
			window.location.reload(true);
		}
	});	
}

//切换视图
var curretn_view = 'view_0';
function SwitchView(query_id, page)
{
	var view_id='view_'+query_id;
	$('#'+curretn_view).attr('class', 'link2');
	curretn_view = view_id;
	$('#'+curretn_view).attr('class', 'active');
	$('#hidden_query_id').val(query_id);
	CallIssueList(query_id, page);
	
	if(query_id <= 0)
		$('#span_drop_view').hide();
	else
		$('#span_drop_view').show();
}

//切换页面
function goPage(query_id, page)
{
	CallIssueList(query_id, page);
}

//选择处理人
var ams = new Array();//处理人集合
var ActionMember = function(uid, uname, dept_id)
{
	this.uid = uid;
	this.uname = uname;
	this.dept_id = dept_id;
	this.is_checked = false;
}

function ChangeActionDept()
{
	var dept_id = $('#action_dept').val(); 
	var str = "";
	n=0;
	for(i=0; i<ams.length; i++)
	{
		if(dept_id==0 || dept_id==ams[i].dept_id)	
		{	
			bg_color="#ffffff";
			is_check="";
			if(ams[i].is_checked)
			{
				bg_color="#0080ff";
				is_check="checked";
			}
			str += "<table width=100% border=0 cellspacing='0' cellpadding='0' bgcolor=#ffffff>";
			str += "<tr onmouseover=\"ChangeActionUser('#0080ff',"+n+")\" onmouseout=\"ChangeActionUser('#ffffff',"+n+")\" bgcolor='"+bg_color+"'>";
			str += "<td>";
			str += "<input id='action_user_box' type=Checkbox value="+ams[i].uid+" onclick='CheckActionUser(this, "+n+")' "+is_check+">";
			str += "<span id='action_user_"+n+"'>"+ams[i].uname+"</span>";
			str += "<br>";
			str += "</td>";
			str += "</tr>";
			str += "</table>";
			
			n++;
		}
	}

	$('#action_members').html(str);
}

function CheckAms(uid, is_checked)
{
	for(i=0; i<ams.length; i++)
	{
		if(ams[i].uid != uid) continue;
		ams[i].is_checked = is_checked;	
	}	
}

function CheckActionUser(obj, seq)
{
	if(obj.checked)
	{
		$(obj).parent().css('background-color', '#0080ff');
		CheckAms(obj.value, true);
	}
	else
		CheckAms(obj.value, false);
	

	vals = "";	
	names = "&nbsp;";
	for(i=0; i<ams.length; i++)
	{
		if(ams[i].is_checked)
		{
			vals += ams[i].uid + ",";
			names += ams[i].uname+";";
		}
	}
	
	$("#action_user").val(vals);
	$("#action_user_name").html(names);

}