
/**
 * define ShortCut : Third Party UI Options Page
 *
 ***/
cr.define('options', function() {
  var OptionsPage = options.OptionsPage;

  function AdBlock() {
      OptionsPage.call(this, 'adblock', '选项 - 广告过滤', 'adblockPage');
  }

  cr.addSingletonGetter(AdBlock);

  AdBlock.prototype = {
    __proto__: options.OptionsPage.prototype,
    initializePage: function(){

      OptionsPage.prototype.initializePage.call(this);

      $('msgExBlockButton').onclick = function(event) {
        OptionsPage.navigateToPage('adblockException');
      };
      Preferences.getInstance().addEventListener('adblock.enable', function(e) {
        $$('[pref="' + e.type + '"]').parents('.checkbox').nextAll('.sub-item').find(':radio').attr('disabled', !e.value.value);
      });

      // 查询是否显示
      chrome.send('showBlockSoft', ['AdBlock.showBlockSoft']);
      // 勾选显示按钮，不勾选隐藏按钮
      Preferences.getInstance().addEventListener('adblock.enable_soft_block', function(e) {
        $$('[pref="' + e.type + '"]').parents('.checkbox').nextAll('.sub-item').find('button').css('display', e.value.value ? 'block' : 'none');
      });
      // 点击按钮调接口
      $$('#btnSoftBlockSettings').on('click', function(){
        chrome.send('blockSoftAdvance');
      });
    }
  };

  // 查询是否显示回调函数
  AdBlock.showBlockSoft = function(show) {
    show ? $$('#optSoftBlock').show() : $$('#optSoftBlock').hide();
  };

  return {
      AdBlock: AdBlock
    };
});
