/**
 * define ShortCut : Third Party UI Options Page
 *
 ***/
cr.define('options', function() {
  var OptionsPage = options.OptionsPage;

  function AdvanceSettings() {
      OptionsPage.call(this, 'advance', '\u9009\u9879 - 高级设置', 'advancePage');
  }

  cr.addSingletonGetter(AdvanceSettings);

  AdvanceSettings.prototype = {
    __proto__: options.OptionsPage.prototype,

    initializePage: function(){
      OptionsPage.prototype.initializePage.call(this);

      $('privacy_OpenClearBrowsingDataDialog').onclick = function(event) {
        chrome.send('seOpenClearBrowsingDataDialog');
      };
      $('trustOrBlockURLButton').onclick = function(event) {
        chrome.send('seTrustOrBlockURL');
      };
      $('cacheDirChangeButton').onclick = function(event) {
        chrome.send('selectCacheDir');
        window.userGesture = true;
      };
      $('cacheDirResetButton').onclick = function(event) {
        chrome.send('resetCacheDir');
        window.userGesture = true;
      }

      Preferences.getInstance().addEventListener('enable_save_images_quickly', function (e) {
        $$('[pref="' + e.type + '"]').parents('.checkbox').nextAll('.sub-item').find(':checkbox,button').attr('disabled', !e.value.value);
      });

      Preferences.getInstance().addEventListener('se.browser.enable_systray', function(e) {
        $$('[pref="' + e.type + '"]').parents('.checkbox').nextAll('.sub-item').find(':checkbox,button').attr('disabled', !e.value.value);
      });

      Preferences.getInstance().addEventListener('se.browser.enable_todaybuy', function(e) {
        $$('[pref="' + e.type + '"]').parents('.checkbox').nextAll('.sub-item').find(':checkbox,button').attr('disabled', !e.value.value);
      });
    }
  };

  return {
    AdvanceSettings: AdvanceSettings
  };
});
