// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

cr.define('options', function() {
  const OptionsPage = options.OptionsPage;
  const ArrayDataModel = cr.ui.ArrayDataModel;

  //
  // BrowserOptions class
  // Encapsulated handling of browser options page.
  //
  function BrowserOptions() {
    OptionsPage.call(this, 'browser', '选项 - 基本设置', 'browserPage');
  }

  cr.addSingletonGetter(BrowserOptions);

  BrowserOptions.prototype = {
    // Inherit BrowserOptions from OptionsPage.
    __proto__: options.OptionsPage.prototype,

    startup_pages_pref_: {
      'name': 'session.urls_to_restore_on_startup',
      'disabled': false
    },

    /**
     * At autocomplete list that can be attached to a text field during editing.
     * @type {HTMLElement}
     * @private
     */
    autocompleteList_: null,

    /**
     * Initialize BrowserOptions page.
     */
    initializePage: function() {
      // Call base class implementation to start preference initialization.
      OptionsPage.prototype.initializePage.call(this);

      // Wire up controls.
      $('startupUseCurrentButton').onclick = function(event) {
        chrome.send('setStartupPagesToCurrentPages');
      };
      $$('.defaultSearchEngine').on('change', this.setDefaultSearchEngine_);

      var self = this;

      Preferences.getInstance().addEventListener('safemonLockHomePage', function(e) {
        var val = (e.value || {}).value;
        switch (val) {
          case 0:
            break;
          case 1:
            $('safemonLockHomePageTip').hidden = false;
            $$('[name="startup"]').attr('disabled', 'disabled');
            break;
          case 2:
            $('safemonLockHomePageButton').hidden = false;
            $$('[name="startup"]').removeAttr('disabled');
            break;
        }
        $('changeHomePageButton').dataset.smls = val;  // Set the safemonLockStatus mark
      });

      Preferences.getInstance().addEventListener('safemon_lock_search', function(e) {
        var val = (e.value || {}).value;
        switch (val) {
          case 0:
            break;
          case 1:
            $('safemonLockSearchTips').hidden = $('safemonLockSearchTips2').hidden = false;
            $('safemonLockSearchButton').innerHTML = $('safemonLockSearchButton2').innerHTML = '修改';
            $('safemonLockSearchButton').hidden = $('safemonLockSearchButton2').hidden = false;
            var lists = document.querySelectorAll('.search-engine-list');
            for(var i=0; i<lists.length; i++) {
              lists[i].classList.add('safemon-locked');
            }
            break;
          case 2:
            $('safemonLockSearchTips').hidden = $('safemonLockSearchTips2').hidden = true;
            $('safemonLockSearchButton').innerHTML = $('safemonLockSearchButton2').innerHTML = '开启强力防护';
            $('safemonLockSearchButton').hidden = $('safemonLockSearchButton2').hidden = false;
            var lists = document.querySelectorAll('.search-engine-list');
            for(var i=0; i<lists.length; i++) {
              lists[i].classList.remove('safemon-locked');
            }
            break;
        }
      });

      $('safemonLockSearchButton').onclick = $('safemonLockSearchButton2').onclick = function(event) {
        chrome.send('LaunchSafemonLockSearch');
      };

      Preferences.getInstance().addEventListener('se.browser.yunpan.show_yunpan_button', function(e) {
        $$('[pref="' + e.type + '"]').parents('.checkbox').nextAll('.sub-item').find(':checkbox,button').attr('disabled', !e.value.value);
      });

      $('searchEngineSettingsButton').onclick = function(event) {
        OptionsPage.navigateToPage('search_engine');
      };

      $('changeHomePageButton').onclick = function(event) {
        if (this.dataset.smls == '0') {  // Check the safemonLockStatus mark
          $$('.mask').show();
          $$('#homepage-setting-popup textarea')[0].value = $('startupShowPagesText').textContent.replace(/, /g, '\n');
          $$('#homepage-setting-popup').show();
        } else {
          //chrome.send('LaunchSafemonLockHomePage');
          chrome.send('HandleModifyHomePage', ['BrowserOptions.onHandleModifyHomePage']);
        }
      };

      document.addEventListener("change", function(e) {
        var targetNode = e.target;
        if (targetNode) {
          if (targetNode.pref == 'session.restore_on_startup' ) {
            chrome.send('handleConfigChangeByClick', ['session.restore_on_startup', targetNode.value]);
          }
        }
      });

      $('safemonLockHomePageButton').onclick = function(event) {
        chrome.send('LaunchSafemonLockHomePage');
      };

      // select default downloader
      $$('#select_default_downloader').on('change', function(){
        chrome.send('setExternalDownloaderIndex', [parseInt(this.value)]);
      });
      chrome.send('getExternalDownloaderNames');

      // Text fields may change widths when the window changes size, so make
      // sure the suggestion list stays in sync.
      window.addEventListener('resize', function() {
        self.autocompleteList_.syncWidthToInput();
      });

      // Ensure that changes are committed when closing the page.
      window.addEventListener('unload', function() {
        if (document.activeElement == homepageField)
          homepageField.blur();
      });

      function setHomepageText() {
        $$('#homepage-setting-popup textarea')[0].value = this.dataset.url;
      }

      $('hp-btn-hao360').addEventListener('click', setHomepageText, false);
      $('hp-btn-ntp').addEventListener('click', setHomepageText, false);
      $('hp-btn-360so').addEventListener('click', setHomepageText, false);

      $$(document).delegate('#homepage-setting-popup .green-btn', 'click', function() {
          var url_arr = [], arr = $$('#homepage-setting-popup textarea')[0].value.trim().split('\n');
          for (var i = 0, len = arr.length; i < len; i++) {
            if (arr[i].length > 0) url_arr.push(arr[i]);
          }
          chrome.send('SetStartupPagesByClick', url_arr);
          window.userGesture = true;
          $$('#homepage-setting-popup').hide();
          $$('.mask').hide();
      });
      $$(document).delegate('#homepage-setting-popup .gray-btn, #homepage-setting-popup .btn-close', 'click', function() {
          $$('#homepage-setting-popup').hide();
          $$('.mask').hide();
      });

      if (!cr.isChromeOS) {
        $('defaultBrowserUseAsDefaultButton').onclick = function(event) {
          chrome.send('becomeDefaultBrowser');
        };

        $('autoLaunch').addEventListener('click',
                                         this.handleAutoLaunchChanged_);
      }

      var startupPagesList = $('startupPagesList');
      options.browser_options.StartupPageList.decorate(startupPagesList);

      startupPagesList.autoExpands = true;

      // Check if we are in the guest mode.
      if (cr.commandLine && cr.commandLine.options['--bwsi']) {
        // Hide the startup section.
        $('startupSection').hidden = true;
      } else {
        // Initialize control enabled states.
        Preferences.getInstance().addEventListener(
            'session.restore_on_startup',
            function(e) {
              var val = e.value.value;
              if (val == 0 || val == 360 || val == 361) {
                $$('[name=startup][value="4"]')[0].checked = true;
                var url = ['se://newtab', 'http://hao.360.cn', 'se://last'][val % 359];
                $('startupShowPagesText').textContent = $$('#homepage-setting-popup textarea')[0].value = url;
                chrome.send('SetStartupPages', [url]);
              }
            });

        Preferences.getInstance().addEventListener(
            this.startup_pages_pref_.name,
            this.handleStartupPageListChange_.bind(this));

      }

      var suggestionList = new cr.ui.AutocompleteList();
      suggestionList.autoExpands = true;
      suggestionList.suggestionUpdateRequestCallback =
          this.requestAutocompleteSuggestions_.bind(this);
      $('main-content').appendChild(suggestionList);
      this.autocompleteList_ = suggestionList;
      startupPagesList.autocompleteList = suggestionList;

      Preferences.getInstance().addEventListener('bosskey.enable', function(e) {
        $$('[pref="' + e.type + '"]').parents('.checkbox').nextAll('.sub-item').find(':checkbox,button').attr('disabled', !e.value.value);
      });
      $('SettingbossKeyBtn').onclick = function(event) {
        chrome.send('seSetupBosskey');
      };

      chrome.send('getBosskey', ['BrowserOptions.updateBosskeyDisplay']);
    },

    onHandleModifyHomePage_: function() {
      $('safemonLockHomePageTip').hidden = true;
      $('safemonLockHomePageButton').hidden = false;
      $$('[name="startup"]').removeAttr('disabled');
      $$('.mask').show();
      $$('#homepage-setting-popup textarea')[0].value = $('startupShowPagesText').textContent.replace(/, /g, '\n');
      $$('#homepage-setting-popup').show();
    },

    onTpGetExternalDownloaderName_: function(list, index) {
      (list||[]).forEach(function(item, i){
        $('select_default_downloader').options.add(new Option(item, i));
      });
      $('select_default_downloader').value = index;
    },

    /**
     * Called when the value of the homepage-use-NTP pref changes.
     * Updates the disabled state of the homepage text field.
     * Notice that the text field can be disabled for other reasons too
     * (it can be managed by policy, for instance).
     * @param {Event} event Change event.
     * @private
     */
    onHomepageUseNTPChanged_: function(event) {
      var homepageField = $('homepageURL');
      var homepageUseURLButton = $('homepageUseURLButton');
      homepageField.setDisabled('radioNotSelected',
                                !homepageUseURLButton.checked);
    },

    /**
     * Update the Default Browsers section based on the current state.
     * @param {string} statusString Description of the current default state.
     * @param {boolean} isDefault Whether or not the browser is currently
     *     default.
     * @param {boolean} canBeDefault Whether or not the browser can be default.
     * @private
     */
    updateDefaultBrowserState_: function(statusString, isDefault,
                                         canBeDefault) {
      var label = $('defaultBrowserState');
      label.textContent = statusString;

      $('defaultBrowserUseAsDefaultButton').disabled = !canBeDefault ||
                                                       isDefault;
    },

    /**
     * Clears the search engine popup.
     * @private
     */
    clearSearchEngines_: function() {
      //$('defaultSearchEngine').textContent = '';
	  $$('.defaultSearchEngine').text('');
    },

    /**
     * Updates the search engine popup with the given entries.
     * @param {Array} engines List of available search engines.
     * @param {number} defaultValue The value of the current default engine.
     * @param {boolean} defaultManaged Whether the default search provider is
     *     managed. If true, the default search provider can't be changed.
     */
    updateSearchEngines_: function(engines, defaultValue, defaultManaged) {
      this.clearSearchEngines_();

	  $$('.defaultSearchEngine').attr('disabled', defaultManaged);

      var defaultIndex = -1;
	  engines.forEach(function(engine, i){
        $$('.defaultSearchEngine').append(new Option(engine['name'], engine['index']));
        if (defaultValue == engine['index']) {
          defaultIndex = i;
		}
	  });

      if (defaultIndex >= 0) {
  	    $$('.defaultSearchEngine').each(function(){
			this.selectedIndex = defaultIndex;
		});
	  }
    },

    /**
     * Returns true if the custom startup page control block should
     * be enabled.
     * @returns {boolean} Whether the startup page controls should be
     *     enabled.
     */
    shouldEnableCustomStartupPageControls: function(pages) {
      return $('startupShowPagesButton').checked &&
          !this.startup_pages_pref_.disabled;
    },

    /**
     * Updates the startup pages list with the given entries.
     * @param {Array} pages List of startup pages.
     * @private
     */
    updateStartupPages_: function(pages) {
      var model = new ArrayDataModel(pages);
      // Add a "new page" row.
      //$('startupPagesList').dataModel = model;
      //this.updateCustomStartupPageControlStates_();
      var arr = [];
      for (var i = 0, len = pages.length; i < len; i++) {
        if (pages[i].url.length > 0) arr.push(pages[i].url);
      }
      $('startupShowPagesText').textContent = arr.join(', ');
      $$('#homepage-setting-popup textarea')[0].value = arr.join('\n');
    },

    /**
     * Sets the enabled state of the custom startup page list controls
     * based on the current startup radio button selection.
     * @private
     */
    updateCustomStartupPageControlStates_: function() {
      var disable = !this.shouldEnableCustomStartupPageControls();
      var startupPagesList = $('startupPagesList');
      startupPagesList.disabled = disable;
      startupPagesList.setAttribute('tabindex', disable ? -1 : 0);
      // Explicitly set disabled state for input text elements.
      var inputs = startupPagesList.querySelectorAll("input[type='text']");
      for (var i = 0; i < inputs.length; i++) {
        inputs[i].disabled = disable;
		inputs[i].placeholder = disable ? '' : (i > 0 ? '增加启动时要打开的网址' : '在此输入启动时要打开的网址');
	  }
      $('startupUseCurrentButton').disabled = disable;
    },

    /**
     * Handles change events of the preference
     * 'session.urls_to_restore_on_startup'.
     * @param {event} preference changed event.
     * @private
     */
    handleStartupPageListChange_: function(event) {
      this.startup_pages_pref_.disabled = event.value['disabled'];

      var arr = [], val = event.value.value;
      for (var i = 0, len = val.length; i < len; i++) {
        if (val[i].length > 0) arr.push(val[i]);
      }
      $('startupShowPagesText').textContent = arr.join(', ');
      $$('#homepage-setting-popup textarea')[0].value = arr.join('\n');

      //this.updateCustomStartupPageControlStates_();
    },

    /**
     * Sets the default search engine based on the popup selection.
     */
    setDefaultSearchEngine_: function() {
      var engineSelect = this;
      var selectedIndex = engineSelect.selectedIndex;
      if (selectedIndex >= 0) {
        var selection = engineSelect.options[selectedIndex];
        chrome.send('setDefaultSearchEngine', [String(selection.value)]);
      }
    },

    /**
     * Sets or clear whether Chrome should Auto-launch on computer startup.
     */
    handleAutoLaunchChanged_: function() {
      chrome.send('toggleAutoLaunch', [Boolean($('autoLaunch').checked)]);
    },

    /**
     * Sends an asynchronous request for new autocompletion suggestions for the
     * the given query. When new suggestions are available, the C++ handler will
     * call updateAutocompleteSuggestions_.
     * @param {string} query List of autocomplete suggestions.
     * @private
     */
    requestAutocompleteSuggestions_: function(query) {
      chrome.send('requestAutocompleteSuggestions', [query]);
    },

    /**
     * Updates the autocomplete suggestion list with the given entries.
     * @param {Array} pages List of autocomplete suggestions.
     * @private
     */
    updateAutocompleteSuggestions_: function(suggestions) {
      var list = this.autocompleteList_;
      // If the trigger for this update was a value being selected from the
      // current list, do nothing.
      if (list.targetInput && list.selectedItem &&
          list.selectedItem['url'] == list.targetInput.value)
        return;
      list.suggestions = suggestions;
    },

    /**
      * Shows the autoLaunch preference and initializes its checkbox value.
      */
    updateAutoLaunchState_: function(enabled) {
      $('autoLaunchOption').hidden = false;
      $('autoLaunch').checked = enabled;
    },
  };

  BrowserOptions.updateDefaultBrowserState = function(statusString, isDefault,
                                                      canBeDefault) {
    if (!cr.isChromeOS) {
      BrowserOptions.getInstance().updateDefaultBrowserState_(statusString,
                                                              isDefault,
                                                              canBeDefault);
    }
  };

  BrowserOptions.updateSearchEngines = function(engines, defaultValue,
                                                defaultManaged) {
    BrowserOptions.getInstance().updateSearchEngines_(engines, defaultValue,
                                                      defaultManaged);
  };

  BrowserOptions.updateBosskeyDisplay = function(bosskeys) {
    if (bosskeys.length <= 0) return;
    var bosskeyStr = '', len = bosskeys.length - 1;
    if (!(len == 0 && bosskeys[0] == 0)) {
      for (var i = 0; i < len; i++)
        bosskeyStr += bosskeys[i] + '+';
      bosskeyStr += ShortCut.getShortCutEndKeys()[bosskeys[len]] || bosskeys[len];
    }
    $('bosskey_value').textContent = bosskeyStr;
  };

  BrowserOptions.onHandleModifyHomePage = function() {
    BrowserOptions.getInstance().onHandleModifyHomePage_();
  };

  BrowserOptions.updateStartupPages = function(pages) {
    BrowserOptions.getInstance().updateStartupPages_(pages);
  };

  BrowserOptions.updateAutocompleteSuggestions = function(suggestions) {
    BrowserOptions.getInstance().updateAutocompleteSuggestions_(suggestions);
  };

  BrowserOptions.updateAutoLaunchState = function(enabled) {
    BrowserOptions.getInstance().updateAutoLaunchState_(enabled);
  };

  window.onTpGetExternalDownloaderName = function(list, index) {
    BrowserOptions.getInstance().onTpGetExternalDownloaderName_(list, index);
  };

  // Export
  return {
    BrowserOptions: BrowserOptions
  };

});
