/**
 * define MouseGestures : Third Party UI Options Page
 *
 ***/
cr.define('options', function() {
  var OptionsPage = options.OptionsPage;

  function MouseGestures() {
      OptionsPage.call(this, 'mousegestures', '\u9009\u9879 - \u9F20\u6807\u624B\u52BF', 'mousegesturesPage');
  }

  cr.addSingletonGetter(MouseGestures);

  window.resetMouseGesturesSuccess = function() {
    showTip('恢复默认鼠标手势成功');
  };

  MouseGestures.prototype = {
    __proto__: options.OptionsPage.prototype,

    tpInitOptionsMouseGestureData: [
      { key: 'U', text: '上', pos: '0 0'},
      { key: 'L', text: '左', pos: '-64px 0' },
      { key: 'D', text: '下', pos: '-32px 0' },
      { key: 'R', text: '右', pos: '-96px 0' },
      { key: 'UD', text: '上下', pos: '-128px 0' },
      { key: 'RL', text: '右左', pos: '-192px 0' },
      { key: 'DU', text: '下上', pos: '-160px 0' },
      { key: 'LR', text: '左右', pos: '-224px 0' },
      { key: 'UL', text: '上左', pos: '-256px 0' },
      { key: 'RU', text: '右上', pos: '-320px 0' },
      { key: 'UR', text: '上右', pos: '-288px 0' },
      { key: 'RD', text: '右下', pos: '-352px 0' },
      { key: 'DL', text: '下左', pos: '-384px 0' },
      { key: 'LU', text: '左上', pos: '-448px 0' },
      { key: 'DR', text: '下右', pos: '-416px 0' },
      { key: 'LD', text: '左下', pos: '-480px 0' },
      { key: 'BA', text: '单击左键', pos: '-512px 0', tip: '按住右键，单击左键' },
      { key: 'BCU', text: '向上滚轮', pos: '-576px 0', tip: '按住右键，向上滚轮' },
      { key: 'BC', text: '单击中键', pos: '-544px 0', tip: '按住右键，单击中键' },
      { key: 'BCD', text: '向下滚轮', pos: '-608px 0', tip: '按住右键，按下滚轮' }
    ],

    initializePage: function(){
      OptionsPage.prototype.initializePage.call(this);
      $('btn-reset-mouse-gestures').addEventListener('click', this.resetMouseGestures, false);

      this.buildList();
    },

    buildList: function(){
      for (var i = 0, len = this.tpInitOptionsMouseGestureData.length; i < len; i++ ) {
        var item = this.tpInitOptionsMouseGestureData[i],
            liEl = document.createElement('li'),
            iEl = document.createElement('i'),
            //spanEl = document.createElement('span'),
            selectEl = document.createElement('select');
        iEl.style.backgroundPosition = item.pos;
        if (item.tip) iEl.title = item.tip;
        liEl.appendChild(iEl);
        //spanEl.innerHTML = item.text;
        //liEl.appendChild(spanEl);
        selectEl.id = 'SELECT_' + item.key;
        selectEl.setAttribute('pref', 'kMouseGestureProfile.' + item.key);
        selectEl.setAttribute('data-type', 'number');
        selectEl.innerHTML = '\
          <option value="0">无效动作</option>\
          <option value="1">向上翻页</option>\
          <option value="2">向下翻页</option>\
          <option value="3">向左滚动</option>\
          <option value="4">向右滚动</option>\
          <option value="5">滚动到页面顶部</option>\
          <option value="6">滚动到页面底部</option>\
          <option value="7">后退</option>\
          <option value="8">前进</option>\
          <option value="9">重新载入（刷新）</option>\
          <option value="10">打开新标签页</option>\
          <option value="11">打开主页</option>\
          <option value="12">关闭标签页</option>\
          <option value="13">关闭其他标签页</option>\
          <option value="14">恢复刚关闭的标签</option>\
          <option value="15">模拟键盘左键按下</option>\
          <option value="16">模拟键盘右键按下</option>\
          <option value="17">前一个标签</option>\
          <option value="18">后一个标签</option>\
          <option value="19">全屏切换</option>\
          <option value="20">停止</option>\
          <option value="21">最小化</option>\
          <option value="22">关闭所有标签页</option>';
        liEl.appendChild(selectEl);
        (i < 4 ? $('basicMouseGestureList') : $('advancedMouseGestureList')).appendChild(liEl);
      }
    },

    resetMouseGestures: function() {
      really('确定要恢复到默认的鼠标手势设置吗？', function() {
        chrome.send('resetDefaultSettings', ['resetMouseGesturesSuccess',
            'kMouseGestureProfile.kMouseGestureUserMouseGesture', 'kMouseGestureProfile.kMouseGestureUserMouseGestureTips',
            'kMouseGestureProfile.U', 'kMouseGestureProfile.D', 'kMouseGestureProfile.L',
            'kMouseGestureProfile.R', 'kMouseGestureProfile.UL', 'kMouseGestureProfile.UR',
            'kMouseGestureProfile.DL', 'kMouseGestureProfile.DR', 'kMouseGestureProfile.RL',
            'kMouseGestureProfile.LR', 'kMouseGestureProfile.UD', 'kMouseGestureProfile.DU',
            'kMouseGestureProfile.RU', 'kMouseGestureProfile.RD', 'kMouseGestureProfile.LU',
            'kMouseGestureProfile.LD', 'kMouseGestureProfile.BA', 'kMouseGestureProfile.BC',
            'kMouseGestureProfile.BCU', 'kMouseGestureProfile.BCD']);
      });
      return false;
    }
  };

  return {
    MouseGestures: MouseGestures
  };
});
