// Copyright (c) 2011 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

var AdvancedOptions = options.AdvancedOptions;
var BrowserOptions = options.BrowserOptions;
var ContentSettings = options.ContentSettings;
var SearchEngineSettings = options.SearchEngineSettings;
var ContentSettingsExceptionsArea = options.contentSettings.ContentSettingsExceptionsArea;
var CookiesView = options.CookiesView;
var HandlerOptions = options.HandlerOptions;
var IntentsView = options.IntentsView;
var InstantConfirmOverlay = options.InstantConfirmOverlay;
var OptionsPage = options.OptionsPage;
var Preferences = options.Preferences;
var ManageProfileOverlay = options.ManageProfileOverlay;
var ProxyOptions = options.ProxyOptions;
var SearchEngineManager = options.SearchEngineManager;
var SearchPage = options.SearchPage;

/** 360 add **/
var TabOptionsPage = options.TabOptionsPage;
var SpeedupOptions = options.SpeedupOptions;
var LibOptions = options.LibOptions;
var UistyleOptions = options.UistyleOptions;
var CloudAndMultiscreen = options.CloudAndMultiscreen;
var AddressBar = options.AddressBar;
var SearchBar = options.SearchBar;
var MouseGestures = options.MouseGestures;
var ShortCut = options.ShortCut;
var AdBlock = options.AdBlock;
var AdBlockExceptionOptions = options.ADBlockExceptionOptions;
var HotkeyUrls = options.HotkeyUrls;
var AdvanceSettings = options.AdvanceSettings;
/** 360 add end **/

/**
 * DOMContentLoaded handler, sets up the page.
 */
function load() {

  var menuOffPattern = /(^\?|&)menu=off($|&)/;
  var menuDisabled = menuOffPattern.test(window.location.search);
  // document.documentElement.setAttribute('hide-menu', menuDisabled);
  // We can't use an attribute on the html element because of webkit bug
  // 12519. Instead, we add a class.
  if (menuDisabled)
    document.documentElement.classList.add('hide-menu');

  OptionsPage.register(SearchPage.getInstance());

  OptionsPage.register(BrowserOptions.getInstance());
  OptionsPage.register(UistyleOptions.getInstance());
  OptionsPage.registerSubPage(SearchEngineManager.getInstance(),
                              BrowserOptions.getInstance(),
                              [$('searchEngineSettingsButton')]);
  /** 360 add **/
  OptionsPage.register(TabOptionsPage.getInstance());
  OptionsPage.register(AddressBar.getInstance());
  //OptionsPage.register(SearchBar.getInstance());
  /** 360 add **/



  OptionsPage.register(AdvancedOptions.getInstance());
  OptionsPage.registerSubPage(ContentSettings.getInstance(),
                              AdvanceSettings.getInstance(),
                              [$('privacyContentSettingsButton')]);

  OptionsPage.registerSubPage(ContentSettingsExceptionsArea.getInstance(),
                              ContentSettings.getInstance());

  OptionsPage.registerSubPage(CookiesView.getInstance(),
                              ContentSettings.getInstance(),
                              [$('privacyContentSettingsButton'),
                               $('show-cookies-button')]);


  OptionsPage.registerSubPage(SearchEngineSettings.getInstance(),
                              BrowserOptions.getInstance(),
                              [$('searchEngineSettingsButton')]);

  // If HandlerOptions is null it means it got compiled out.
  if (HandlerOptions) {
    OptionsPage.registerSubPage(HandlerOptions.getInstance(),
                                ContentSettings.getInstance(),
                                [$('manage-handlers-button')]);
  }
  if (IntentsView && $('manage-intents-button')) {
    OptionsPage.registerSubPage(IntentsView.getInstance(),
                                ContentSettings.getInstance(),
                                [$('manage-intents-button')]);
  }

  /** 360 add **/
  OptionsPage.register(SpeedupOptions.getInstance());
  //OptionsPage.register(CloudAndMultiscreen.getInstance());
  OptionsPage.register(MouseGestures.getInstance());
  OptionsPage.register(ShortCut.getInstance());
  OptionsPage.register(AdBlock.getInstance());
  OptionsPage.registerSubPage(AdBlockExceptionOptions.getInstance(),
                              AdBlock.getInstance());
  //OptionsPage.register(HotkeyUrls.getInstance());
  OptionsPage.register(AdvanceSettings.getInstance());
  OptionsPage.register(LibOptions.getInstance());
  /** 360 add end **/

  // image toolbar width height limit
  $$('[pref="se.browser.image_toolbar_img_minwidth"]').bind('change', function(){
    if (this.value < 150) {
      this.value = 150;
    }
    if (this.value > 10000) {
      this.value = 10000;
    }
  });
  $$('[pref="se.browser.image_toolbar_img_minheight"]').bind('change', function(){
    if (this.value < 100) {
      this.value = 100;
    }
    if (this.value > 10000) {
      this.value = 10000;
    }
  });
  // autoclear
  $$('[pref="se.browser.auto_clear_cache_files_size"]').bind('change', function(){
    var val = parseInt(this.value) || 0;
    if (val < 100) {
      this.value = 100;
    }
    if (val > 1000) {
      this.value = 1000;
    }
  });
  // Decorate the existing elements in the document.
  cr.ui.decorate('input[pref][type=checkbox]', options.PrefCheckbox);
  cr.ui.decorate('input[pref][type=number]', options.PrefNumber);
  cr.ui.decorate('input[pref][type=radio]', options.PrefRadio);
  cr.ui.decorate('input[pref][type=range]', options.PrefRange);
  cr.ui.decorate('select[pref]', options.PrefSelect);
  cr.ui.decorate('input[pref][type=text]', options.PrefTextField);
  cr.ui.decorate('input[pref][type=url]', options.PrefTextField);
  cr.ui.decorate('button[pref]', options.PrefButton);
  cr.ui.decorate('#content-settings-page input[type=radio]:not(.handler-radio)',
      options.ContentSettingsRadio);
  cr.ui.decorate('#content-settings-page input[type=radio].handler-radio',
      options.HandlersEnabledRadio);
  cr.ui.decorate('span.controlled-setting-indicator',
      options.ControlledSettingIndicator);

  Preferences.getInstance().initialize();
  OptionsPage.initialize();

  var path = document.location.pathname;

  if (path.length > 1) {
    // Skip starting slash and remove trailing slash (if any).
    var pageName = path.slice(1).replace(/\/$/, '');
    // Proxy page is now per network and only reachable from internet details.
    if (pageName != 'proxy') {
      // Show page, but don't update history (there's already an entry for it).
      if (pageName == 'search' || pageName == 'tpMoreMouseGesture'){
        OptionsPage.showDefaultPage();
      } else {
      OptionsPage.showPageByName(pageName, false);
    }
    }
  } else {
    OptionsPage.showDefaultPage();
  }

  var subpagesNavTabs = document.querySelectorAll('.subpages-nav-tabs');
  for(var i = 0; i < subpagesNavTabs.length; i++) {
    subpagesNavTabs[i].onclick = function(event) {
      OptionsPage.showTab(event.srcElement);
    }
  }

  // Allow platform specific CSS rules.
  cr.enablePlatformSpecificCSSRules();

  if (navigator.plugins['Shockwave Flash'])
    document.documentElement.setAttribute('hasFlashPlugin', '');

  // Clicking on the Settings title brings up the 'Basics' page.
  $('navbar-content-title').onclick = function() {
    OptionsPage.navigateToPage(BrowserOptions.getInstance().name);
  };

}

function highlightAnchor() {
  var hash = location.hash.substr(1);
  if (hash.indexOf('Section') > 0) {
    var el = document.querySelector('#' + hash + ' > h3 + div');
    if (el) el.classList.add('anchor');
  }
}

window.addEventListener('load', function() {
  var navSelected = document.querySelector('.navbar-item-selected');
  $('btn-reset-mouse-gestures').style.display
    = (navSelected.id == 'mousegesturesPageNav' ? 'block' : 'none');

  $('btn-reset-shortcuts').style.display
     = (navSelected.id == 'shortcutPageNav' ? 'block' : 'none');

  $('navbar').addEventListener('click', function(e){
    $('btn-reset-mouse-gestures').style.display = (e.target.id == 'mousegesturesPageNav' ? 'block' : 'none');
    $('btn-reset-shortcuts').style.display = (e.target.id == 'shortcutPageNav' ? 'block' : 'none');
    $$('.savemsg').css('opacity', 0);
  });

  highlightAnchor();
}, false);

window.addEventListener('hashchange', function() {
  Array.prototype.forEach.call(document.getElementsByClassName('anchor'), function(item) {
    item.classList.remove('anchor');
  });

  highlightAnchor();
}, false);

document.addEventListener('DOMContentLoaded', load);

window.onpopstate = function(e) {
  options.OptionsPage.setState(e.state);
};

window.onbeforeunload = function() {
  options.OptionsPage.willClose();
};

window.onOptionSavedSuccessfully = function() {
  showTip('设置保存成功');
}
