
// Copyright (c) 2012 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

cr.define('options', function() {

  var OptionsPage = options.OptionsPage;

  //////////////////////////////////////////////////////////////////////////////
  // SearchEngineSettings class:

  /**
   * Encapsulated handling of search engine settings page.
   * @constructor
   */
  function SearchEngineSettings() {
    this.activeNavTab = null;
    OptionsPage.call(this, 'search_engine', '搜索引擎设置',
                     'search-engine-settings-page');
  }

  cr.addSingletonGetter(SearchEngineSettings);

  SearchEngineSettings.prototype = {
    __proto__: OptionsPage.prototype,

    initializePage: function() {
      OptionsPage.prototype.initializePage.call(this);
    }
  };
  return {
    SearchEngineSettings: SearchEngineSettings
  };
});

