/**
 * define ShortCut : Third Party UI Options Page
 *
 ***/
cr.define('options', function() {
  var OptionsPage = options.OptionsPage;

  function ShortCut() {
    OptionsPage.call(this, 'shortcut', '\u9009\u9879 - \u5feb\u6377\u952e', 'shortcutPage');
  }

  cr.addSingletonGetter(ShortCut);

  function findAncestorWithClass(node, className) {
    do{
      if (node.classList && node.classList.contains(className)) return node;
    }while(node = node.parentNode);
    return null;
  }

  function findAncestorWithTagName(node, tagName) {
    do{
      if (node.classList && node.tagName.toUpperCase() == tagName.toUpperCase()) return node;
    }while(node = node.parentNode);
    return null;
  }

  function merge(toObj, fromObj, force){
    for(var k in fromObj){
      if(!(k in toObj) || force){
        toObj[k] = fromObj[k];
      }
    }
  }

  window.showTip = function(msg, isErr){

    var fTipDom = document.querySelector('.savemsg'),
    tipWrap = fTipDom.parentNode;
    if (fTipDom) {
      tipWrap.removeChild(fTipDom);
    }

    var tipDom = document.createElement('div');
    tipDom.className = 'savemsg trans-hide';
    tipDom.addEventListener('webkitTransitionEnd', function(){
      if(!tipDom.classList.contains('trans-hide')){
        window.setTimeout(function(){
          tipDom.classList.add('trans-hide');
        }, 3000);
      }
    });

    tipDom.innerHTML = msg;
    if (isErr) {
      tipDom.style.backgroundColor = '#f93';
    }
    tipWrap.insertBefore(tipDom, tipWrap.firstChild);
    tipDom.style.marginLeft = (- tipDom.getBoundingClientRect().width / 2) + 'px';
    window.setTimeout(function(){
      tipDom.classList.remove('trans-hide');
    });
  };


  const ctlKey = {
    16: 'Shift',
    17: 'Ctrl',
    18: 'Alt'
  };

  const endKey = {
    8: 'Backspace',
    9: 'Tab',
    20: 'Caps Lock',
    27: 'Esc',
    33: 'PgUp',
    34: 'PgDown',
    35: 'End',
    36: 'Home',
    37: '←',
    38: '↑',
    39: '→',
    40: '↓',
    45: 'Insert',
    46: 'Delete',
    48: '0',
    49: '1',
    50: '2',
    51: '3',
    52: '4',
    53: '5',
    54: '6',
    55: '7',
    56: '8',
    57: '9',
    65: 'A',
    66: 'B',
    67: 'C',
    68: 'D',
    69: 'E',
    70: 'F',
    71: 'G',
    72: 'H',
    73: 'I',
    74: 'J',
    75: 'K',
    76: 'L',
    77: 'M',
    78: 'N',
    79: 'O',
    80: 'P',
    81: 'Q',
    82: 'R',
    83: 'S',
    84: 'T',
    85: 'U',
    86: 'V',
    87: 'W',
    88: 'X',
    89: 'Y',
    90: 'Z',
    96: 'Num0',
    97: 'Num1',
    98: 'Num2',
    99: 'Num3',
    100: 'Num4',
    101: 'Num5',
    102: 'Num6',
    103: 'Num7',
    104: 'Num8',
    105: 'Num9',
    107: 'Num+',
    109: 'Num-',
    112: 'F1',
    113: 'F2',
    114: 'F3',
    115: 'F4',
    116: 'F5',
    117: 'F6',
    118: 'F7',
    119: 'F8',
    120: 'F9',
    121: 'F10',
    122: 'F11',
    123: 'F12',
    144: 'Num Lock',
    145: 'Scroll Lock',
    186: ';',
    187: '=',
    188: ',',
    189: '-',
    190: '.',
    191: '/',
    192: '`',
    219: '[',
    220: '\\',
    221: ']',
    222: '\''
  };

  var sysShortcuts = [
    ['Ctrl', 'Shift', 78],
    ['Ctrl', 187],
    ['Ctrl', 189],
    ['Ctrl', 48],
    ['Ctrl', 80],
    ['Ctrl', 'Shift', 46]
  ];

  var osShortcuts = [
    ['Ctrl', 88],
    ['Ctrl', 67],
    ['Ctrl', 86],
    ['Ctrl', 65],
    ['Ctrl', 90]
  ];

  var idWordMap = {
    34014: "新建标签",
    34027: "复制标签",
    33003: "新建主页标签",
    34015: "关闭当前标签",
    34050: "关闭全部标签",
    34028: "恢复最后关闭页面",
    34017: "切换到上一个标签",
    34016: "切换到下一个标签",
    34000: "打开新窗口",
    39001: "选中地址栏",
    34001: "新建无痕（小号）窗口",
    20018: "弹出地址栏下拉列表",
    33006: "停止",
    33002: "刷新（重新载入）",
    33007: "强制刷新当前页面",
    33007: "刷新所有页面",
    38001: "页面放大",
    38003: "页面缩小",
    38002: "恢复页面到100%",
    34030: "全屏显示",
    35004: "保存网页",
    39009: "将当前页面保存为图片",
    35003: "打印…",
    40000: "打开文件",
    37000: "页面内查找",
    40012: "打开下载管理器",
    40010: "查看历史记录",
    40013: "清除上网痕迹",
    35000: "添加收藏",
    40009: "显示/隐藏收藏栏",
    20019: "显示/隐藏侧边栏",
    20020: "浏览器静音",
    40019: "浏览器医生",
    40003: "开发人员工具",
    40040: "开启/关闭图片放大镜"
  };

  function reserveQueryEndKey(keyStr){
    var rTable = reserveQueryEndKey.reserveTable;
    if(!rTable){
      rTable = {};
      for(var keyCode in endKey){
        rTable[endKey[keyCode]] = keyCode;
      }
      reserveQueryEndKey.reserveTable = rTable;
    }

    return rTable[keyStr];
  }

  function renderShortCutsTr(json, actionId){

    if(!idWordMap[actionId]){
      return;
    }

    var tr,td,div,span1,span2,a,b;

    tr = document.createElement('tr');
    tr.dataset.actionId = actionId;

    td = document.createElement('td');
    td.innerHTML = idWordMap[actionId];
    tr.appendChild(td);
    td = document.createElement('td');
    for(var k in json){
      div = document.createElement('div');
      div.className = 'normal';
      span1 = document.createElement('span');
      span1.className = 'shortcuts normal-shortcuts';
      span1.title = '点击可修改快捷键';
      for(var n in json[k]['Keys']){
        if(n!=0){
          span1.appendChild(document.createTextNode(' + '));
        }
        span2 = document.createElement('span');
        span2.innerHTML = endKey[json[k]['Keys'][n]] || json[k]['Keys'][n];
        span1.appendChild(span2);
      }
      div.appendChild(span1);
      if(isSysShortcuts(parseShortCutsSpan(span1))){
        div.className = 'sys';
        span1.title = '系统快捷键不可编辑';
      }

      if(Object.keys(json).length>1){
        b = document.createElement('b');
        b.className = 'remove';
        b.title = '删除快捷键';
        div.appendChild(b);
        span1 = document.createElement('span');
        span1.className = 'shortcuts edit-shortcuts';
        div.appendChild(span1);
      }else{
        span1 = document.createElement('span');
        span1.className = 'shortcuts edit-shortcuts';
        div.appendChild(span1);
      }
      td.appendChild(div);
    }
    if(td.querySelectorAll('.normal').length + td.querySelectorAll('.sys').length<3){
      a = document.createElement('a');
      a.className = 'add';
      td.appendChild(a);
    }
    tr.appendChild(td);
    return tr;
  }

  function parseShortCutsTr(tr){
    if(!tr){
      return;
    }
    var json={},
    shortcuts = [],
    normalSpans = tr.querySelectorAll('span.normal-shortcuts');

    for(var i=0,normalSpan; normalSpan=normalSpans[i++]; ){
      shortcuts.push({Keys:parseShortCutsSpan(normalSpan)});
    }

    json[tr.dataset.actionId] = shortcuts;
    return json;
  }

  function parseShortCutsSpan(normalSpan){
    var keys = [],
    keySpans = normalSpan.querySelectorAll('span');

    for(var j=0,keySpan; keySpan=keySpans[j++]; ){
      keys.push(reserveQueryEndKey(keySpan.innerHTML) || keySpan.innerHTML);
    }
    return keys;
  }


  function renderShortCutsTBody(json){
    var tbody = document.querySelector('#shortcutPage tbody:nth-child(2)'),
    tr;
    tbody.innerHTML = '';
    for(var j in json){
      if(tr = renderShortCutsTr(json[j], j)){
        tbody.appendChild(tr);
      }
    }
  }


  function getActionIdFromKeys(keys){
    var datas = window.loadShortCuts.data,
    same = false;
    for(var i in datas){
      for(var j=0;j<datas[i].length;j++){
        if(keys.length == datas[i][j]['Keys'].length){
          same = true;

          for(var k=0;k<keys.length; k++){
            if(datas[i][j]['Keys'][k] != keys[k]){
              same = false;
            }
          }
          if(same){
            return i;
          }
        }
      }
    }
  }

  function resort(wrap){
    var keys = wrap.querySelectorAll('span'),
    ctrlKey,shiftKey,altKey;
    if(keys.length){
      for(var i=0,el; el=keys[i++];){
        switch(el.innerHTML){
          case 'Ctrl':
            ctrlKey = el;
            break;
          case 'Shift':
            shiftKey = el;
            break;
          case 'Alt':
            altKey = el;
            break;
        }
      }
    }
    var lastEl = wrap.lastElementChild;
    wrap.innerHTML = '';
    if(ctrlKey){
      wrap.appendChild(ctrlKey);
      wrap.appendChild(document.createTextNode(' + '));
    }
    if(shiftKey){
      wrap.appendChild(shiftKey);
      wrap.appendChild(document.createTextNode(' + '));
    }
    if(altKey){
      wrap.appendChild(altKey);
      wrap.appendChild(document.createTextNode(' + '));
    }
    if(lastEl && ['Ctrl','Shift','Alt'].indexOf(lastEl.innerHTML) == -1){
      wrap.appendChild(lastEl);
    }
  }
  function isValidate(keys){
    if (keys && keys.length == 1) return (keys[0] >= 112) && (keys[0] <= 123);
    return keys && keys.length>1 && endKey[keys[keys.length-1]] && (keys[0] != 'Shift' || (keys[0] == 'Shift' && (keys[1] < 65 || keys[1] > 90)) );
  }

  function isExist(keys){
    var datas = window.loadShortCuts.data,
    same;
    for(var k in datas){
      for(var j=0;j<datas[k].length;j++){
        //console.log(datas[k][j]['Keys'], keys);
        if(datas[k][j]['Keys'].length == keys.length){
          same = true;
          for(var i=0;i<keys.length;i++){
            if(keys[i] != datas[k][j]['Keys'][i]){
              same = false
              break;
            }
          }
          if(same){
            return k;
          }
        }
      }
    }
  }

  function isSysShortcuts(keys){
    if(keys.length == 1){
      return keys[0] == 27;
    }
    return false;
  }

  function isOsShortcuts(keys){
    var osKeys,
    same = false;
    for(var i=0; i<osShortcuts.length; i++){
      osKeys = osShortcuts[i];
      if(osKeys.length == keys.length){
        same = true;
        for(var j=0; j<keys.length; j++){
          if(keys[j] != osKeys[j]){
            same = false;
            break;
          }
        }
        if(same == true){
          return true;
        }
      }
    }
    return false;
  }

  window.saveSuccess = function(){
    showTip('自动保存成功');
    chrome.send('loadShortCuts',['loadShortCuts', false]);
  };

  function saveShortCuts(){
    var trs = ShortCut.getInstance().pageDiv.querySelectorAll('tr[data-action-id]'),
    json = {};
    for(var i=0,tr;tr=trs[i++];){
      merge(json, parseShortCutsTr(tr), true);
    }
    merge(json, window.loadShortCuts.data, false);
    chrome.send('saveShortCuts', ['saveSuccess', JSON.stringify(json)]);
  }

  window.loadShortCuts = function(jsonStr){
    window.loadShortCuts.data = JSON.parse(jsonStr);
    renderShortCutsTBody(window.loadShortCuts.data);
  };
  document.addEventListener('DOMContentLoaded', function(){
    window.setTimeout(function(){
      chrome.send('loadShortCuts', ['loadShortCuts', false]);
    });
  });

  window.resetSuccess = function(){
    showTip('恢复默认快捷键成功');
    chrome.send('loadShortCuts',['loadShortCuts', false]);
  };


  ShortCut.prototype = {
    __proto__: options.OptionsPage.prototype,

    initializePage: function(){
      OptionsPage.prototype.initializePage.call(this);
      document.body.addEventListener('click', this.onClick);
    },
    cleanEdit: function(){
      var editEl;
      if(editEl = document.querySelector('.edit') || document.querySelector('.waitedit')){
        editEl.classList.remove('edit')
        editEl.classList.remove('waitedit')
        editEl.classList.add('normal');
      }
    },
    onClick: function(e){
      var el;
      if(e.target.id == 'btn-reset-shortcuts'){
        really('确定要恢复到默认的快捷键设置吗？',function(){
          chrome.send('resetDefaultSettings',['resetSuccess','se.browser.custom_shortcuts']);
        });
        return false;
      }
      if(e.target.classList.contains('remove')){
        el = findAncestorWithTagName(e.target, 'div');
        el.parentNode.removeChild(el);
        saveShortCuts();
        return false;
      }
      if(e.target.classList.contains('add')){
        el = findAncestorWithTagName(e.target, 'td');
        var tmp = document.createElement('div');
        tmp.innerHTML = '<div class="normal"><span class="shortcuts normal-shortcuts">请按下快捷键</span><span class="shortcuts edit-shortcuts"></span><b class="remove"></b></div>';
        el.insertBefore(tmp = tmp.firstChild, e.target);
        window.setTimeout(function(){
          var ev = document.createEvent('HTMLEvents');
          ev.initEvent('click', true, true);
          tmp.dispatchEvent(ev);
        });
        if(el.querySelectorAll('.normal').length > 2){
          el.querySelector('.add').classList.add('hide');
        }else{
          el.querySelector('.add').classList.remove('hide');
        }

      }

      if(el = findAncestorWithClass(e.target, 'normal')){
        ShortCut.getInstance().cleanEdit();
        el.classList.remove('normal');
        el.classList.add('waitedit');
        var lastKeyCode,
        normalShortcutsEl = el.querySelector('.normal-shortcuts'),
        editShortcutsEl = el.querySelector('.edit-shortcuts');

        window.onkeydown = function(e){
          e.preventDefault();
          if(e.keyCode == lastKeyCode){
            return false;
          }
          /*
          if(e.keyCode == 46 || e.keyCode == 8){
            el.parentNode.removeChild(el);
            saveShortCuts();
            return false;
          }
          */
          chrome.send('enterShortcutEdit', [true]);

          var key, keyEl, plusEl;
          if(key = ctlKey[e.keyCode]){
            el.classList.remove('waitedit');
            el.classList.add('edit');
            keyEl = document.createElement('span');
            keyEl.innerHTML = key;
            editShortcutsEl.appendChild(keyEl);
            plusEl = document.createTextNode(' + ');
            editShortcutsEl.appendChild(plusEl);
            resort(editShortcutsEl);
          }else if((key = endKey[e.keyCode]) && ctlKey[lastKeyCode]){
            keyEl = document.createElement('span');
            keyEl.innerHTML = key;
            editShortcutsEl.appendChild(keyEl);
          } else if(e.keyCode >= 112 && e.keyCode <= 123) {
            keyEl = document.createElement('span');
            keyEl.innerHTML = endKey[e.keyCode];
            editShortcutsEl.appendChild(keyEl);
          }
          lastKeyCode = e.keyCode;
          return false;
        };
        window.onkeyup = function(e){
          e.preventDefault();
          ShortCut.getInstance().cleanEdit();
          chrome.send('enterShortcutEdit', [false]);
          window.onkeydown = null;
          window.onkeyup = null;
          var keys = parseShortCutsSpan(editShortcutsEl),
          actionId;
          if(isOsShortcuts(keys)){
            showTip('不可使用操作系统快捷键！',true);
          }else{
            if(actionId = isExist(keys)){
              if(idWordMap[actionId]){
                showTip('该快捷键已被“'+idWordMap[actionId]+'”占用，请重新设置！',true);
              }else{
                showTip('该快捷键已被系统默认热键占用，请重新设置！',true);
              }
            }else{
              if(isValidate(keys)){
                normalShortcutsEl.innerHTML = editShortcutsEl.innerHTML;
                saveShortCuts();
              }else{
              }
            }
          }
          editShortcutsEl.innerHTML = '';
          return false;
        };

      }else{
        if(!findAncestorWithClass(e.target, 'edit') && !findAncestorWithClass(e.target, 'waitedit')){
          ShortCut.getInstance().cleanEdit();
          window.onkeydown = null;
          window.onkeyup = null;
        }
      }
    }
  };

  ShortCut.getShortCutEndKeys = function() {
    return endKey;
  };

  return {
    ShortCut: ShortCut
  };
});
