/**
 * define tabOptionsPage
 *
 ***/
cr.define('options', function() {
  var OptionsPage = options.OptionsPage;

  function TabOptionsPage() {
    OptionsPage.call(this, 'tab', '\u9009\u9879 - \u6807\u7B7E\u680F', 'tabOptionsPage');
  }

  cr.addSingletonGetter(TabOptionsPage);

  TabOptionsPage.prototype = {
    __proto__: options.OptionsPage.prototype,

    initializePage: function(){
      OptionsPage.prototype.initializePage.call(this);

      Preferences.getInstance().addEventListener('se.virtual.tab_unactive_color', function(e) {
        $$('#ui_SetTabUnactiveColor').attr('disabled', !e.value.value);
        $$('#ui_SetTabUnactiveColor_copy').attr('disabled', !e.value.value);
      });
      $$('[pref="se.virtual.tab_width_min"]').bind('change', function() {
        var v = parseInt(this.value);
        if (v < 34) this.value = 34;
        if (v > 800) this.value = 800;
        if (v > parseInt($$('[pref="se.virtual.tab_width_max"]')[0].value))
          this.value = $$('[pref="se.virtual.tab_width_max"]')[0].value;
      });
      $$('[pref="se.virtual.tab_width_max"]').bind('change', function() {
        var v = parseInt(this.value);
        if (v < 34) this.value = 34;
        if (v > 800) this.value = 800;
        if (v < parseInt($$('[pref="se.virtual.tab_width_min"]')[0].value))
          this.value = $$('[pref="se.virtual.tab_width_min"]')[0].value;
      });
      $('ui_SetTabUnactiveColor').onclick = function(event) {
        chrome.send('seSetupTabUnactiveColor');
      };
      $('ui_SetTabUnactiveColor_copy').onclick = function(event) {
        chrome.send('seSetupTabUnactiveColor');
      };
    }
  };

  return {
    TabOptionsPage: TabOptionsPage
  };
});
