;(function(window, $) {

	// Slider Constructor
	var Slider = function(options) {
		var that = this,
			i;

		// Default options		Ĭ
		that.options = {
			// Element
			wrapper: ".slider",
			ul: $(".slider ul"),
			li: $(".slider li"),
			trigger: $(".slider .trigger"),
			prev: null,
			next: null,

			// options
			isAuto: true,
			autoTime: 3000,
			mode: "opacity",
			triggerEvent: "mouseenter"
		};

		// User defined options		Ķ
		for (i in options) {

			that.options[i] = options[i];
		}

		that.len = that.options.li.length;
		this.curIndex = 0;

		that.init();
	};

	// Prototype
	Slider.prototype = {
		autoTimer: null,
		triggerSpan: null,

		go: function(target) {
			var _this = this;

			_this.stopAuto();

			// жϴĲ "next", "prev"
			if (typeof target == "string") {

				target = (_this.curIndex + _this.len + (target == "next" ? 1 : -1)) % _this.len;
			}

			_this.opacityTo(target);

			// жǷtargger,±ʾ
			if (_this.triggerSpan !== null) {

				_this.triggerSpan.eq(_this.curIndex).removeClass("cur")
					.end().eq(target).addClass("cur");
			}
			_this.curIndex = target;
			_this.startAuto();
		},

		// opacity 
		opacityTo: function(target) {
			var _this = this;

			_this.options.li.eq(_this.curIndex).css("z-index", 1).stop().animate({"opacity": 0}, 500);
			_this.options.li.eq(target).stop().css("z-index", 2).animate({"opacity": 1}, 500);
		},

		// opacity ʼ
		_initOpacity: function() {
			var _this = this;

			//_this.options.ul.css({"position": "relative"});
			//_this.options.li.css({"opacity": 0, "position": "absolute", "left": 0, "top": 0});
			_this.options.li.css({"opacity": 0});
		},


		// trigger span
		_createTrigger: function() {
			var _this = this,
				i = _this.len,
				triggerHTML = "";

			while (i--) {

				triggerHTML += "<span></span>";
			}

			_this.options.trigger.html(triggerHTML);
		},

		onEvent: function() {
			var _this = this;
			
			// trigger span¼
			if (_this.options.trigger !== null) {
				_this.triggerSpan = _this.options.trigger.find("span");

				_this.triggerSpan.on(_this.options.triggerEvent, function() {
					var index = $(this).index();

					if (index != _this.curIndex) {
						_this.go(index);
					}
				});
			}

			// prev,nextл¼
			if (_this.options.prev !== null) {

				_this.options.prev.on("click", function() {

					_this.go("prev");
				});
				_this.options.next.on("click", function() {

					_this.go("next");
				});
			}
		},

		// Զ
		startAuto: function() {
			var _this = this;

			_this.autoTimer = setInterval(function() {

				_this.go("next");
			}, _this.options.autoTime);
		},

		// ֹͣԶ
		stopAuto: function() {

			window.clearInterval(this.autoTimer);
		},

		// ʼSlider
		init: function() {
			var _this = this;

			// жлģʽͬģʽʹòͬĳʼ
			switch (_this.options.mode) {

				case "opacity": 

					_this._initOpacity();
					break;
			}

			// жǷtrigger,span
			if (_this.options.trigger[0]) {

				_this._createTrigger();
			}

			_this.onEvent();

			// жǷԶл
			if (_this.options.isAuto) {

				_this.startAuto();
			}

			// ʼĬϽһ
			_this.go(0);
		}
	};

	// ӿ
	window.Slider = Slider;

})(window, jQuery);

$(function() {
	/**** ҳԶ *****/ 
	var $rmdCont = $(".header .rmd"),
		rmdTimer = null;

	function rmdAnimate() {
		$rmdCont.stop().animate({scrollTop: 20}, 500, function() {

			$rmdCont[0].scrollTop = 0;
			$rmdCont.find("a").eq(0).appendTo($rmdCont);
		});
	}
	if ($rmdCont.find("a").length >= 1) {
		rmdTimer = setInterval(rmdAnimate, 5000);

		$rmdCont.hover(function() {

			clearInterval(rmdTimer);
		}, function() {

			rmdTimer = setInterval(rmdAnimate, 5000);
		});
	}


	/***  *******/ 
	$(".wrap-nav").hover(function() {
		
		$(".wrap-sub-nav").stop().animate({height: 160}, 500);
	}, function() {

		$(".wrap-sub-nav").stop().animate({height: 0}, 500);
	});
	
	/*** Fixed *******/ 
	(function() {
		$(".index-fixed .btn").on("click", function(){
			$(".index-fixed-cont").stop().animate({left: -282}, 500);
		}).trigger("click");

		$(".index-fixed-cont .close").on("click", function() {
			$(".index-fixed-cont").stop().animate({left: 33}, 500);
		});
	})();

});