<?php
/**
* @author moufer<moufer@163.com>
* @copyright www.modoer.com
*/
return array(
    'aid' => array (
        'fieldname'=>'aid',
        'title'=>'地区',
        'note'=>'',
        'type'=>'area',
        'listorder'=>'0',
        'allownull'=>'0',
        'enablesearch'=>'1',
        'iscore'=>'2',
        'isadminfield'=>'0',
        'regular'=>'/[0-9]+/',
        'errmsg'=>'未选择地区',
        'datatype' => 'smallint(5)',
        'config'=> array (
            'default' => '0',
        ),
    ),
    'catid' => array (
        'fieldname'=>'catid',
        'title'=>'分类',
        'note'=>'',
        'type'=>'category',
        'listorder'=>'1',
        'allownull'=>'0',
        'enablesearch'=>'1',
        'iscore'=>'2',
        'isadminfield'=>'0',
        'regular'=>'/[0-9]+/',
        'errmsg'=>'未选择分类',
        'datatype' => 'smallint(5)',
        'config'=> array (
            'default' => '0',
        ),
    ),
    'name' => array (
        'fieldname'=>'name',
        'title'=>'名称',
        'note'=>'',
        'type'=>'text',
        'listorder'=>'2',
        'allownull'=>'0',
        'enablesearch'=>'1',
        'iscore'=>'1',
        'isadminfield'=>'0',
        'regular'=>'',
        'errmsg'=>'',
        'datatype' => 'varchar(80)',
        'config'=> array (
			'len' => '80',
            'default' => '',
        ),
    ),
    'subname' => array (
        'fieldname'=>'subname',
        'title'=>'子名称',
        'note'=>'',
        'type'=>'text',
        'listorder'=>'3',
        'allownull'=>'1',
        'enablesearch'=>'1',
        'iscore'=>'1',
        'isadminfield'=>'0',
        'regular'=>'',
        'errmsg'=>'',
        'datatype' => 'varchar(80)',
        'config'=> array (
			'len' => '80',
            'default' => '',
        ),
    ),
    'mappoint' => array (
        'fieldname'=>'mappoint',
        'title'=>'地图坐标',
        'note'=>'',
        'type'=>'mappoint',
        'listorder'=>'4',
        'allownull'=>'0',
        'enablesearch'=>'0',
        'iscore'=>'1',
        'isadminfield'=>'0',
        'regular'=>'/[\-\.0-9a-z]+,[\-\.0-9a-z]+/i',
        'errmsg'=>'地图坐标不正确',
        'datatype' => 'varchar(60)',
        'config'=> array (
            'default' => '',
			'size' => '30',
        ),
    ),
    'video' => array (
        'fieldname'=>'video',
        'title'=>'视频地址',
        'note'=>'',
        'type'=>'video',
        'listorder'=>'5',
        'allownull'=>'1',
        'enablesearch'=>'0',
        'iscore'=>'0',
        'isadminfield'=>'0',
        'regular'=>'',
        'errmsg'=>'',
        'datatype' => 'varchar(255)',
        'config'=> array (
            'default' => '',
			'size' => '30',
        ),
    ),
    'description' => array (
        'fieldname'=>'description',
        'title'=>'简介',
        'note'=>'',
        'type'=>'text',
        'listorder'=>'7',
        'allownull'=>'1',
        'enablesearch'=>'0',
        'iscore'=>'1',
        'isadminfield'=>'0',
        'regular'=>'',
        'errmsg'=>'',
        'datatype' => 'varchar(255)',
        'config'=> array (
			'len' => '255',
            'default' => '',
			'size' => '60',
        ),
    ),
    'status' => array (
        'fieldname'=>'status',
        'title'=>'状态',
        'note'=>'',
        'type'=>'status',
        'listorder'=>'99',
        'allownull'=>'0',
        'enablesearch'=>'1',
        'iscore'=>'1',
        'isadminfield'=>'1',
        'regular'=>'/[0-9]+/',
        'errmsg'=>'未选择状态',
        'datatype' => 'tinyint(1)',
        'config'=> array (
            'default' => 1,
        ),
    ),
    'level' => array (
        'fieldname'=>'level',
        'title'=>'等级',
        'note'=>'',
        'type'=>'level',
        'listorder'=>'92',
        'allownull'=>'0',
        'enablesearch'=>'1',
        'iscore'=>'1',
        'isadminfield'=>'1',
        'regular'=>'/[0-9]+/',
        'errmsg'=>'未选择点评对象等级',
        'datatype' => 'tinyint(3)',
        'config'=> array (
            'default' => 0,
        ),
    ),
    'finer' => array (
        'fieldname' => 'finer',
        'title' => '推荐度',
        'note' => '',
        'type' => 'numeric',
        'listorder' => '91',
        'allownull' => '1',
        'enablesearch' => '0',
        'iscore' => '1',
        'isadminfield' => '1',
        'show_list' => '0',
        'show_detail' => '0',
        'regular' => '',
        'errmsg' => '',
        'datatype' => 'SMALLINT(5)',
        'config' => 
        array (
          'min' => 0,
          'max' => 255,
          'point' => '0',
          'default' => '0',
        ),
        'disable' => '0',
    ),
);
?>