<?php
// +----------------------------------------------------------------------
// | MAYBECMS	幻灯片管理
// +----------------------------------------------------------------------
// | Copyright (c) 2012-2014 http://www.maybecms.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: Lou <379559090@qq.com>
// +----------------------------------------------------------------------

class slide_control extends admin_control {
	
	public function index(){
		$model = &$this->slide;
		
		$pagenum = 15;
		$urlstr = '';
		$where = array();
		
		$total = $model->count();
		
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pages($page, $maxpage, 'index.php?u=slide-index'.$urlstr.'-page-{page}');
		$this->assign('total', $total);
		$this->assign('pages', $pages);
		
		$list = $model->find_fetch($where,array('id'=>'-1'),($page-1)*$pagenum, $pagenum, $total);
		$this->assign('list', $list);
		
		$this->display();
	}
	
	public function add(){
		if( empty($_POST) ){
			$data = array('status'=>1);
			$this->assign('data', $data);
			
			$this->display('slide_set.htm');
		}else{
			$info = R('info','P');
			if( $info['title'] == '' ) $this->message(0, '添加幻灯片失败：幻灯片名称不能为空！');
			
			$info['dateline'] = $_ENV['_time'];
			
			$model = &$this->slide;
			$id = $model->create($info);
			if(!$id) {
				$this->message(0, '添加幻灯片失败：写入幻灯片表失败！');
			}else{
				$this->message(1, '添加幻灯片成功！','index.php?u=slide-index');
			}
		}
	}
	
	public function edit(){
		$model = &$this->slide;
		
		if( empty($_POST) ){
			$id = intval( R('id','G') );
			$data = $model->get($id);
			if( empty($data) )	$this->message(0, '编辑幻灯片失败：'.$id.'不存在！');
			$this->assign('data', $data);
			
			$this->display('slide_set.htm');
		}else{
			$id = intval( R('id','P') );
			if( empty($id) )	$this->message(0, '编辑幻灯片失败：'.$id.'不存在！');
				
			$info = R('info','P');
				
			if( $info['title'] == '' ) $this->message(0, '添加幻灯片失败：幻灯片名称不能为空！');
				
			$info['id'] = $id;
				
			if(!$model->update($info)) {
				$this->message(0, '编辑幻灯片失败：更新幻灯片表失败！');
			}else{
				$this->message(1, '编辑幻灯片成功！','index.php?u=slide-index');
			}
		}
	}
	
	public function del(){
		$model = &$this->slide;
		$id = intval( R('id','P') );
	
		$msg = $model->xdelete($id);
		if( $msg == '' ){
			$this->message(1, '删除幻灯片成功,幻灯片ID:'.$id,'index.php?u=slide-index');
		}else{
			$this->message(0, '删除幻灯片失败:'.$msg);
		}
	}
	
	//==========================================================幻灯片图片管理
	public function pic(){
		$model = &$this->slide_data;
		$slide_id = intval( R('id','G') );
		$data = array(
				'slide_id'=>$slide_id
		);
		$this->assign('data', $data);
		
		$where['slide_id'] = $slide_id;
		$list = $model->find_fetch($where,array('id'=>'-1'));
		$this->assign('list', $list);
		
		$this->display();
	}
	
	// 排序
	public function listorder() {
		$listorder = R('listorder','P');
		if( empty($listorder) ){
			$this->message(0, '排序参数错误！');
		}
		$model = &$this->slide_data;
		foreach ($listorder as $k=>$v){
			$data['id']=$k;
			$data['listorder'] = intval($v);
			$model->update($data);
		}
		$this->message(1, '排序成功！');
	}
	
	public function addpic(){
		if( empty($_POST) ){
			$slide_id = intval( R('id','G') );
			$data = array(
					'slide_id'=>$slide_id,
					'status'=>1,
					'listorder'=>0
					);
			$this->assign('data', $data);
			
			$this->display('slide_pic_set.htm');
		}else{
			$info = R('info','P');
			if( $info['slide_id'] == '' ) $this->message(0, '添加幻灯片图片失败：幻灯片ID为空！');
			if( $info['link'] && !check::is_url($info['link']) )	$this->message(0, '添加幻灯片图片失败：图片链接格式不正确');
				
			$info['dateline'] = $_ENV['_time'];
			$info['listorder'] = intval( $info['listorder'] );			
				
			$model = &$this->slide_data;
			$id = $model->create($info);
			if(!$id) {
				$this->message(0, '写入幻灯片图片表失败！');
			}else{
				$this->message(1, '添加幻灯片图片成功！','index.php?u=slide-pic-id-'.$info['slide_id']);
			}
		}
	}
	
	public function editpic(){
		$model = &$this->slide_data;
		
		if( empty($_POST) ){
			$id = intval( R('id','G') );
			$data = $model->get($id);
			$this->assign('data', $data);
				
			$this->display('slide_pic_set.htm');
		}else{
			$id = intval( R('id','P') );
			if( empty($id) )	$this->message(0, '编辑幻灯片图片失败：'.$id.'不存在！');
			
			$info = R('info','P');
			if( $info['slide_id'] == '' ) $this->message(0, '编辑幻灯片图片失败：幻灯片ID为空！');
			if( $info['link'] && !check::is_url($info['link']) )	$this->message(0, '编辑幻灯片图片失败：图片链接格式不正确');
			
			$info['listorder'] = intval( $info['listorder'] );
			$info['id'] = $id;
			
			if(!$model->update($info)) {
				$this->message(0, '写入幻灯片图片表失败！');
			}else{
				$this->message(1, '编辑幻灯片图片成功！','index.php?u=slide-pic-id-'.$info['slide_id']);
			}
		}
	}
	
	public function delpic(){
		$model = &$this->slide_data;
		$id = intval( R('id','P') );
		$slideid = intval( R('slideid','P') );
	
		$status = $model->delete($id);
		if( $status ){
			$this->message(1, '删除幻灯片图片成功！'.$id,'index.php?u=slide-pic-id-'.$slideid);
		}else{
			$this->message(0, '删除幻灯片图片失败！');
		}
	}
}
