<?php
defined('KONG_PATH') || exit;

class maybekeywords_control extends admin_control {
	// 管理
	public function index() {
		$keywords = $this->kv->xget('maybe_keywords');
		$this->assign('keywords', $keywords);
		
		$this->display();
	}

	// 增加/编辑
	public function set() {
		$name = htmlspecialchars(R('name', 'P'));
		$url = htmlspecialchars(R('url', 'P'));
		$count = intval(R('count', 'P'));
		isset($_POST['key']) && $key = (int) R('key', 'P');

		!$name && $this->message(0, '关键词名称不能为空！','index.php?u=maybekeywords-index');
		!$url && $this->message(0, '关键词 URL不能为空！','index.php?u=maybekeywords-index');
		
		if( $count == 0 ){
			$this->message(0, '替换次数必须大于0！','index.php?u=maybekeywords-index');
		}elseif ( $count > 5 ){
			$this->message(0, '替换次数必须小于5！','index.php?u=maybekeywords-index');
		}

		$arr = $this->kv->xget('maybe_keywords');
		$row = array('name' => $name, 'url' => $url,'count'=>$count);

		// key 有值为编辑
		if(isset($key)) {
			$arr[$key] = $row;
			usort($arr, "keywords_sort");
			$this->kv->set('maybe_keywords', $arr);
			$this->message(1, '保存成功！','index.php?u=maybekeywords-index');
		}else{
			$arr[] = $row;
			usort($arr, "keywords_sort");
			$this->kv->set('maybe_keywords', $arr);
			end($arr);
			$key = key($arr);
			$this->message(1, '添加成功！','index.php?u=maybekeywords-index');
		}
	}

	// 删除
	public function del() {
		$key = (int) R('key', 'P');

		$arr = $this->kv->xget('maybe_keywords');
		unset($arr[$key]);
		
		usort($arr, "keywords_sort");
		
		$this->kv->set('maybe_keywords', $arr);
		
		$this->message(1, '删除成功！','index.php?u=maybekeywords-index');
	}
	
	//按长度排序
	public function keywords_sort($a = '',$b = ''){
		if ( $a['name'] == $b['name'] ) return 0;
		return ( strlen($a['name']) > strlen($b['name']) ) ? -1 : 1;
	}
}
