<?php
// +----------------------------------------------------------------------
// | MAYBECMS	文章管理控制器
// +----------------------------------------------------------------------
// | Copyright (c) 2012-2014 http://www.maybecms.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: Lou <379559090@qq.com>
// +----------------------------------------------------------------------

class article_control extends user_control{
	private $_table = 'cms_audit_article';	//待审核文章模型表名
	private $_mid = 2;	//模型ID
	private $_audit_mid = 255;	//模型ID (审核专用)
	
	//待审核文章列表
	public function index(){
		$cid = intval(R('cid','R'));
		
		// 获取分类下拉框
		$cidhtml = $this->category->get_cidhtml_by_mid($this->_mid, $cid, '所有文章');
		$this->assign('cidhtml', $cidhtml);
		
		// 初始模型表名
		$this->cms_content->table = $this->_table;
		
		// 初始分页
		$where['uid'] = $this->_uid;
		$pagenum = 10;
		if($cid) {
			$where['cid'] = $cid;			
			$urlstr = '-cid-'.$cid;
		}else{
			$urlstr = '';
		}
		$total = $this->cms_content->find_count($where);
		
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pages($page, $maxpage, 'index.php?u=article-index'.$urlstr.'-page-{page}');
		$this->assign('total', $total);
		$this->assign('pages', $pages);
		
		$cms_arr = $this->cms_content->list_arr($where, 'id', -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($cms_arr as &$v) {
			$this->cms_content->format($v, 2);
		}
		$this->assign('lists', $cms_arr);
		
		$this->display('article_audit.htm');
	}
	
	//添加
	public function add(){
		$uid = $this->_uid;
		$this->assign('_cfg', $this->_cfg);
		
		if(empty($_POST)) {
				
			//上次发布的分类CID
			$habits = (array)$this->kv->get('user_habits_uid_'.$uid);
			$cid = isset($habits['last_add_cid']) ? (int)$habits['last_add_cid'] : 0;
				
			//自动保存的数据
			$data = $this->kv->get('auto_save_article_uid_'.$uid);
		
			if($data) {
				!empty($data['cid']) && $cid = $data['cid'];
				$data['pic_src'] = empty($data['pic']) ? '../static/img/nopic.gif' : '../'.$data['pic'];
				empty($data['author']) && $data['author'] = $this->_user['author'];
				$data['iscomment'] = isset($data['iscomment']) ? intval($data['iscomment']):0;
			}else{
				//初始值
				$data['pic_src'] = '../static/img/nopic.gif';
				$data['author'] = $this->_user['author'];
				$data['iscomment'] = 0;
			}
				
			$this->assign('data', $data);
		
			$cidhtml = $this->category->get_cidhtml_by_mid($this->_mid);
			$this->assign('cidhtml', $cidhtml);
				
			//用于编辑器定位到模型ID
			$edit_cid_id = '&mid='.$this->_audit_mid;
			$this->assign('edit_cid_id', $edit_cid_id);
		
			$this->display('article_set.htm');
		}else{
				
			$cid = intval( R('cid','P') );
			empty($cid) && $this->message(0, '请选择分类！');
			
			$code = R('code','P');
			empty($code) && $this->message(0, '请输入验证码！');
			if( md5($code) != session::get('postcode') ){
				$this->message(0, '验证码不正确！');
			}
				
			//主表数据
			$info = R('info','P');
			$info['cid'] = $cid;
			$info['uid'] = $this->_uid;
			$info['title'] = trim(strip_tags($info['title']));
			
			empty($info['title']) && $this->message(0, '标题不能为空！');
			
			$categorys = $this->category->read($info['cid']);
			if(empty($categorys)) $this->message(0, '分类ID不存在！');
				
			$contentstr = trim( $info['content'] );
			
			$table = 'audit_article';
			$mid = $this->_audit_mid;
				
			// 远程图片本地化
			$isremote = intval(R('isremote', 'P'));
			$endstr = '';
			if($isremote) {
				$endstr .= $this->get_remote_img($table, $contentstr, $uid);
			}
				
			// 计算图片数，和非图片文件数
			$imagenum = $this->cms_attach->find_count(array('id'=>0,'mid'=>$mid, 'uid'=>$uid, 'isimage'=>1));
			$filenum = $this->cms_attach->find_count(array('id'=>0,'mid'=>$mid, 'uid'=>$uid, 'isimage'=>0));
				
			// 如果摘要为空，自动生成摘要
			$info['intro'] = $this->auto_intro($info['intro'], $contentstr);
			
			$info['lasttime'] = $_ENV['_time'];
			$info['dateline'] = $_ENV['_time'];
			$info['imagenum'] = $imagenum;
			$info['filenum'] = $filenum;
				
			//该钩子用来扩展文章主表
			// hook user_article_control_add_content_after.php
		
			$this->cms_content->table = 'cms_'.$table;
			$id = $this->cms_content->create($info);
			if(!$id) {
				$this->message(0, '写入内容表出错');
			}
		
			// 更新附件归宿 cid 和 id
			if($imagenum || $filenum) {
				if(!$this->cms_attach->find_update(array('id'=>0,'mid'=>$mid, 'uid'=>$uid), array('cid'=>$info['cid'], 'id'=>$id))) {
					$this->message(0, '更新内容附件表出错');
				}
			}
							
			//删除自动保存的数据
			$this->kv->delete('auto_save_article_uid_'.$uid);
				
			//记住最后一次发布的分类CID，感觉这样人性化一些吧。
			$habits = (array) $this->kv->get('user_habits_uid_'.$uid);
			$habits['last_add_cid'] = $cid;
			$habits = $this->kv->set('user_habits_uid_'.$uid, $habits);
		
			// hook user_article_control_add_after.php
			$this->message(1, '发布完成'.$endstr,'index.php?u=article-index');
		}
	}
	
	// 编辑文章
	public function edit() {
		// hook user_article_control_edit_before.php
		$this->assign('_cfg', $this->_cfg);
		if(empty($_POST)) {
			$id = intval(R('id'));
			$cid = intval(R('cid'));
	
			$cidhtml = $this->category->get_cidhtml_by_mid($this->_mid, $cid);
			$this->assign('cidhtml', $cidhtml);
			
			// 读取内容
			$this->cms_content->table = $this->_table;
				
			$data = $this->cms_content->get($id);
			if(empty($data)) $this->message(0, '内容不存在！');	
				
			$data['content'] = htmlspecialchars($data['content']);
			$data['intro'] = str_replace('<br />', "\n", strip_tags($data['intro'], '<br>'));
			$data['pic_src'] = empty($data['pic']) ? '../static/img/nopic.gif' : '../'.$data['pic'];
			$this->assign('data', $data);
				
			//用于编辑器定位到模型ID
			$edit_cid_id = '&mid='.$this->_audit_mid.'&cid='.$data['cid'].'&id='.$data['id'];
			$this->assign('edit_cid_id', $edit_cid_id);
	
			$this->display('article_set.htm');
		}else{
				
			$cid = intval( R('cid','P') );
			empty($cid) && $this->message(0, '请选择分类！');
				
			$uid = $this->_user['uid'];
				
			//主表数据
			$info = R('info','P');
			$info['cid'] = $cid;
			$id = intval( $info['id'] );
			$info['title'] = trim(strip_tags($info['title']));
				
			empty($info['title']) && $this->message(0, '标题不能为空！');
	
			$categorys = $this->category->read($info['cid']);
			if(empty($categorys)) $this->message(0, '分类ID不存在！');
				
			$contentstr = trim( $info['content'] );
			
			$table = 'audit_article';
			$mid = $this->_audit_mid;
	
			// 远程图片本地化
			$isremote = intval(R('isremote', 'P'));
			$endstr = '';
			if($isremote) {
				$endstr .= $this->get_remote_img($table, $contentstr, $uid, $cid, $id);
			}
	
			// 计算图片数，和非图片文件数
			$imagenum = $this->cms_attach->find_count(array('id'=>$id,'mid'=>$mid, 'uid'=>$uid, 'isimage'=>1));
			$filenum = $this->cms_attach->find_count(array('id'=>$id,'mid'=>$mid, 'uid'=>$uid, 'isimage'=>0));
	
			// 如果摘要为空，自动生成摘要
			$info['intro'] = $this->auto_intro($info['intro'], $contentstr);
			
			// 写入内容表
			$info['lasttime'] = $_ENV['_time'];
			$info['imagenum'] = $imagenum;
			$info['filenum'] = $filenum;
			
			$info['status'] = 0;	//待审核状态
				
			//该钩子用来扩展文章主表
			// hook user_article_control_edit_content_after.php

			$this->cms_content->table = 'cms_'.$table;
			if(!$this->cms_content->update($info)) {
				$this->message(0, '更新内容表出错');
			}
	
			// hook user_article_control_edit_after.php
	
			$this->message(1, '编辑完成'.$endstr,'index.php?u=article-index');
		}
	}
	
	//删除
	public function del(){
		$id = (int) R('id', 'P');
		$cid = (int) R('cid', 'P');

		empty($id) && $this->message(0,'内容ID不能为空！');
		empty($cid) && $this->message(0,'分类ID不能为空！');
		
		$this->cms_content->table = 'cms_article';
		
		//是否属于该用户
		$data = $this->cms_content->get($id);
		if( empty($data) || $data['cid'] != $cid || $data['uid'] != $this->_uid ){
			$this->message(0,'无效请求！');
		}

		// hook user_article_control_del_after.php

		$err = $this->cms_content->xdelete('article', $id, $cid);
		if($err) {
			$this->message(0,$err);
		}else{
			$this->message(1,'删除文章成功！','index.php?u=my-index');
		}
	}
	
	//删除待审核内容
	public function delaudit(){
		$id = (int) R('id', 'P');
		empty($id) && $this->message(0,'内容ID不能为空！');
		
		$this->cms_content->table = 'cms_audit_article';
		
		//是否属于该用户
		$data = $this->cms_content->get($id);
		if( empty($data) || $data['uid'] != $this->_uid ){
			$this->message(0,'无效请求！');
		}
		
		$this->cms_attach->table = 'cms_attach';
		
		// 删除附件
		$attach_arr = $this->cms_attach->find_fetch(array('id'=>$id,'mid'=>255));
		$updir = MAYBECMS_PATH.'upload/article/';
		foreach($attach_arr as $v) {
			$file = $updir.$v['filepath'];
			$thumb = image::thumb_name($file);
			try{
				is_file($file) && unlink($file);
				is_file($thumb) && unlink($thumb);
			}catch(Exception $e) {
			}
			$this->cms_attach->delete($v['aid']);
		}
		
		$this->cms_content->delete($id);
		$this->message(1,'删除成功!','index.php?u=article-index');
	}
	
	// 自动保存
	public function auto_save() {
		$this->kv->set('auto_save_article_uid_'.$this->_user['uid'], $_POST) ? E(0, '自动保存成功！') : E(1, '自动保存失败！');
	}
	
	// 自动生成摘要
	private function auto_intro($intro, &$content) {
		if(empty($intro)) {
			$intro = preg_replace('/\s{2,}/', ' ', strip_tags($content));
			return trim(utf8::cutstr_cn($intro, 255, ''));
		}else{
			return str_replace(array("\r\n", "\r", "\n"), '<br />', strip_tags($intro));
		}
	}
	
	// 获取远程图片
	private function get_remote_img($table, &$content, $uid, $cid = 0, $id = 0) {
		function_exists('set_time_limit') && set_time_limit(0);
		$cfg = $this->runtime->xget();
		$updir = 'upload/'.$table.'/';
		$_ENV['_prc_err'] = 0;
		$_ENV['_prc_arg'] = array(
				'hosts'=>array('127.0.0.1', 'localhost', $_SERVER['HTTP_HOST'], $cfg['webdomain']),
				'uid'=>$uid,
				'cid'=>$cid,
				'id'=>$id,
				'mid'=>$this->_audit_mid,
				'maxSize'=>10000,
				'upDir'=>MAYBECMS_PATH.$updir,
				'preUri'=>$cfg['weburl'].$updir,
				'cfg'=>$cfg,
		);
		$content = preg_replace_callback('#\<img [^\>]*src=["\']((?:http|ftp)\://[^"\']+)["\'][^\>]*\>#iU', array($this, 'img_replace'), $content);
		unset($_ENV['_prc_arg']);
		return $_ENV['_prc_err'] ? '，但远程抓取图片失败 '.$_ENV['_prc_err'].' 张！' : '';
	}
	
	// 远程图片处理 (如果抓取失败则不替换)
	// $conf 用到4个参数 hosts preUri cfg upDir
	private function img_replace($mat) {
		static $uris = array();
		$uri = $mat[1];
		$conf = &$_ENV['_prc_arg'];
	
		// 排除重复保存相同URL图片
		if(isset($uris[$uri])) return str_replace($uri, $uris[$uri], $mat[0]);
	
		// 根据域名排除本站图片
		$urls = parse_url($uri);
		if(in_array($urls['host'], $conf['hosts'])) return $mat[0];
	
		$file = $this->cms_attach->remote_down($uri, $conf);
		if($file) {
			$uris[$uri] = $conf['preUri'].$file;
			$cfg = $conf['cfg'];
	
			// 是否添加水印
			if(!empty($cfg['watermark_pos'])) {
				image::watermark($conf['upDir'].$file, MAYBECMS_PATH.'static/img/watermark.png', null, $cfg['watermark_pos'], $cfg['watermark_pct']);
			}
	
			return str_replace($uri, $uris[$uri], $mat[0]);
		}else{
			$_ENV['_prc_err']++;
			return $mat[0];
		}
	}

	// hook user_article_control_after.php
}
