<?php
// +----------------------------------------------------------------------
// | MAYBECMS	用户留言管理控制器
// +----------------------------------------------------------------------
// | Copyright (c) 2012-2014 http://www.maybecms.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: Lou <379559090@qq.com>
// +----------------------------------------------------------------------

class guestbook_control extends user_control{
	
	//我的留言
	public function index(){
		$model = &$this->guestbook;
		
		$keyword = empty($_POST) ? R('keyword') : R('keyword', 'P');
		if($keyword) {
			$keyword = urldecode($keyword);
			$keyword = safe_str($keyword);
		}
		$this->assign('keyword', $keyword);
		
		// 初始分页
		$pagenum = 10;
		$where['uid'] = $this->_user['uid'];
		if($keyword) {
			$where = array('title'=>array('LIKE'=>$keyword));
			$urlstr = '-keyword-'.urlencode($keyword);
		}else{
			$urlstr = '';
		}

		$total = $model->find_count($where);
		
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pages($page, $maxpage, 'index.php?u=guestbook-index'.$urlstr.'-page-{page}');
		$this->assign('total', $total);
		$this->assign('pages', $pages);
		
		$list_arr = $model->find_fetch($where, array('id'=>'-1'), ($page-1)*$pagenum, $pagenum, $total);
		$this->assign('lists', $list_arr);
		
		$this->display('guestbook.htm');
	}
	
	//发布
	public function add(){
		if( empty($_POST) ){
			$this->display();
		}else{
			$data = R('data_info','P');
			if( empty($data) ){
				$this->message(0, '留言数据为空！');
			}elseif ( $data['email'] && !check::is_email($data['email']) ){
				$this->message(0, '邮箱格式错误！');
			}else{
				$code = R('code','P');
				if( empty($code) ){
					$this->message(0, '验证码不能为空！');
				}elseif ( md5($code) != session::get('guestcode') ){
					$this->message(0, '验证码不正确！');
				}
				
				$model = &$this->guestbook;
				
				$data['uid'] = $this->_uid;
				$data['dateline'] = time();
				$data['ip'] = ip(1);
				
				$id = $model->create($data);
				if( $id ){
					$this->message(1, '留言成功！','index.php?u=guestbook-index');
				}else{
					$this->message(0, '留言失败！');
				}
			}
		}
	}
	
	//删除
	public function del(){
		$model = &$this->guestbook;
		$id = intval( R('id','P') );
	
		$where['id'] = $id;
		$where['uid'] = $this->_uid;
		
		$status = $model->find_delete($where);
		if( $status ){
			$this->message(1, '删除留言成功！','index.php?u=guestbook-index');
		}else{
			$this->message(0, '删除留言失败！');
		}
	}

	// hook user_guestbook_control_after.php
}
