<?php
// +----------------------------------------------------------------------
// | MAYBECMS	用户首页控制器
// +----------------------------------------------------------------------
// | Copyright (c) 2012-2014 http://www.maybecms.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: Lou <379559090@qq.com>
// +----------------------------------------------------------------------

class index_control extends user_control{
	//首页
	public function index() {
		$menu=Array ( 
              0 => Array ( 
                    'title' => '会员信息' ,
                    'channels' => Array ( 
                                  0 => Array ( 
                                         'channel' => '账户管理',
                                         'pages' => Array ( 
                                                    0 => Array ('name' => '基本信息', 'url' => 'index.php?u=index-welcome' ) ,
                                                    1 => Array ('name' => '详细信息', 'url' => 'index.php?u=index-detail' ) ,
                                                    2 => Array ('name' => '修改资料', 'url' => 'index.php?u=index-profile' ),
                                         			3 => Array ('name' => '修改密码', 'url' => 'index.php?u=index-password' )
                                          ) 
                                  )
                    ) 
               ),
              1 => Array ( 
                    'title' => '信息管理' ,
                    'channels' => Array ( 
                                  0 => Array ( 
                                         'channel' => '信息管理',
                                         'pages' => Array ( 
                                                    0 => Array ('name' => '我的文章', 'url' => 'index.php?u=my-index' ) ,
                                         			1 => Array ('name' => '待审核文章', 'url' => 'index.php?u=article-index' ) ,
                                                    2 => Array ('name' => '我的评论', 'url' => 'index.php?u=my-comment' ),
                                         			//3 => Array ('name' => '我的收藏', 'url' => 'index.php?u=my-collect' ),
                                         			4 => Array ('name' => '我的留言', 'url' => 'index.php?u=guestbook-index' )
                                          ) 
                                  ) 
                    ) 
               )
         );
		foreach ($menu as $key=>$vo) {
			foreach ($vo['channels'] as $ke=>$v) {
				$i=0;
				$page=array();
				foreach ($v['pages'] as $k=>$e) {
						$page[$i]['name']=$e['name'];
						$page[$i]['url']=$e['url'];
						$i++;
					
				}
				$menu[$key]['channels'][$ke]['pages']=$page;
			}
		}
		
		$menulist= json_encode($menu);
		$this->assign_value('menulist', $menulist);
		
		$this->assign_value('act', 'index.php?u=index-welcome');
		
		$this->_cfg['titles'] = '个人中心_'.$this->_cfg['webname'];
		$this->assign('maybe', $this->_cfg);
		
		$this->display();
	}
	
	//基本信息
	public function welcome(){
		$this->display('welcome.htm');
	}
	
	//详细信息
	public function detail(){
		$this->display('user_detail.htm');
	}
	
	//修改资料
	public function profile(){
		if( empty($_POST) ){
			$this->display('user_profile.htm');
		}else{
			$info = R('info','P');
			$data_info = R('data_info','P');
			
			if( $info['email'] && !check::is_email($info['email']) ){
				$this->message(0, '邮箱格式不正确！');
			}elseif ( $data_info['qq'] && !check::is_qq($data_info['qq']) ){
				$this->message(0, 'QQ格式不正确！');
			}elseif ( $data_info['mobile'] && !check::is_mobile($data_info['mobile']) ){
				$this->message(0, '手机号格式不正确！');
			}else{
				$user = &$this->user;
				$info['uid'] = $this->_user['uid'];
				if( $user->update($info) ){
					$data_info['uid'] = $this->_user['uid'];
					$user_data = &$this->user_data;
					$user_data->update($data_info);
					
					$this->message(1, '修改资料成功！','index.php?u=index-welcome');
				}else{
					$this->message(0, '修改资料失败！');
				}
			}
			
		}
	}
	
	//修改密码
	public function password(){
		if( empty($_POST) ){
			$this->display('user_password.htm');
		}else{
			$user = &$this->user;
			
			$oldpassword = R('oldpassword','P');
			$password = R('password','P');
			$repassword = R('repassword','P');
			
			if ( empty($oldpassword) ){
				$this->message(0, '旧密码不能为空！');
			}elseif ( empty($password) ){
				$this->message(0, '新密码不能为空！');
			}elseif ( $password != $repassword ){
				$this->message(0, '两次输入的新密码不一致！');
			}elseif ( !$user->verify_password($oldpassword,$this->_user['salt'],$this->_user['password']) ){
				$this->message(0, '旧密码不正确！');
			}else{
				//检测密码规则
				$errmsg = $user->check_password($password);
				if( $errmsg )	$this->message(0, $errmsg);

				//新密码
				$data['password'] = get_password($password,$this->_user['salt']);
				$data['uid'] = $this->_user['uid'];
				
				if( $user->update($data) ){
					$this->message(1, '修改密码成功！','index.php?u=index-welcome');
				}else{
					$this->message(0, '修改密码失败！');
				}
			}
		}
	}

	// hook user_index_control_after.php
}
