<?php
// +----------------------------------------------------------------------
// | MAYBECMS	用户信息管理控制器
// +----------------------------------------------------------------------
// | Copyright (c) 2012-2014 http://www.maybecms.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: Lou <379559090@qq.com>
// +----------------------------------------------------------------------

class my_control extends user_control{
	//我的文章
	public function index() {
		$cid = intval(R('cid','R'));
		
		// 获取分类下拉框
		$cidhtml = $this->category->get_cidhtml_by_mid(2, $cid, '所有文章');
		$this->assign('cidhtml', $cidhtml);
		
		// 初始模型表名
		$this->cms_content->table = 'cms_article';
		
		// 初始分页
		$where['uid'] = $this->_uid;
		$pagenum = 10;
		if($cid) {
			$where = array('cid' => $cid);
			$categorys = $this->category->read($cid);
			$total = isset($categorys['count']) ? $categorys['count'] : 0;
			$urlstr = '-cid-'.$cid;
		}else{
			$total = $this->cms_content->find_count($where);
			$urlstr = '';
		}
		
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pages($page, $maxpage, 'index.php?u=my-index'.$urlstr.'-page-{page}');
		$this->assign('total', $total);
		$this->assign('pages', $pages);
		
		$cms_arr = $this->cms_content->list_arr($where, 'id', -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($cms_arr as &$v) {
			$this->cms_content->format($v, 2);
		}
		$this->assign('lists', $cms_arr);
		
		$this->display('article.htm');
	}
	
	//我的评论
	public function comment(){
		$mid = max(2, (int)R('mid'));
		$table = $this->models->get_table($mid);
		
		// 模型名称
		$mod_name = $this->models->get_name();
		if(isset($mod_name[1])) unset($mod_name[1]);
		$this->assign('mid', $mid);
		$this->assign('mod_name', $mod_name);
		
		$where['mid'] = $mid;
		$where['uid'] = $this->_uid;
		
		// 初始分页
		$pagenum = 20;
		$total = $this->cms_comment->count();
		$maxpage = max(1, ceil($total/$pagenum));
		$page = min($maxpage, max(1, intval(R('page'))));
		$pages = pages($page, $maxpage, 'index.php?u=my-comment-mid-'.$mid.'-page-{page}');
		$this->assign('pages', $pages);
		$this->assign('total', $total);
		
		// 获取评论列表
		$id_arr = array();
		$comment_arr = $this->cms_comment->list_arr(array('mid'=>$mid), -1, ($page-1)*$pagenum, $pagenum, $total);
		foreach($comment_arr as &$v) {
			$this->cms_comment->format($v, 'Y-m-d H:i:s', 0);
			$id_arr[] = $v['id'];
		}
		
		$id_arr = array_unique($id_arr);
		$this->cms_content->table = 'cms_'.$table;
		$key_pre = 'cms_'.$table.'-id-';
		$tmp = $this->cms_content->mget($id_arr);
		foreach($comment_arr as &$v) {
			$row = $tmp[$key_pre.$v['id']];
			$v['title'] = $row['title'];
			$v['url'] = $this->cms_content->content_url($row['cid'], $row['id'], $row['alias'], $row['dateline']);
		}
		$this->assign('lists', $comment_arr);
		
		$this->display('comment.htm');
	}
	
	//删除评论
	public function commentdel(){
		$commentid = intval( R('commentid','G') );
		$model = $this->cms_comment;
		$comment_data = $model->get($commentid);
		if( $comment_data['uid'] != $this->_uid ){
			$this->message(0, '该评论部属于你！');
		}
		
		$table = $this->models->get_table($comment_data['mid']);
		$err = $model->xdelete($table, $comment_data['id'], $commentid);
		if($err) {
			$this->message(0, $err);
		}else{
			$this->message(1, '删除成功！','index.php?u=my-comment');
		}
	}
	
	//我的收藏
	public function collect(){
		$this->display('collect.htm');
	}
	
	// hook user_my_control_after.php
}
