<?php
// +----------------------------------------------------------------------
// | MAYBECMS	用户登陆管理
// +----------------------------------------------------------------------
// | Copyright (c) 2012-2014 http://www.maybecms.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: Lou <379559090@qq.com>
// +----------------------------------------------------------------------

class public_control extends control {
	public $_uid;
	public $_cfg = array();	// 全站参数
	public $_user_cfg = array();	//用户模块配置
	
	public function __construct(){
		$this->_uid = session::get('_uid');
		
		$this->assign('C', $_ENV['_config']);
		
		$this->_cfg = $this->runtime->xget();
		$this->_user_cfg = $this->kv->xget('user_cfg');
		
		if( empty($this->_user_cfg['open_user_model']) ){	//关闭用户模块
			$this->message(0, '站点已关闭用户中心！',$this->_cfg['weburl']);
		}
	}
	
	public function login(){
		if( $this->_uid ){
			$this->message(0, '你已经登录！', 'index.php?u=index-index');
		}
		
		if( empty($_POST) ){
			$this->_cfg['titles'] = '用户登录_'.$this->_cfg['webname'];
			$this->assign('maybe', $this->_cfg);
			$this->display('login.htm');
		}else{
			$user = &$this->user;
			$username = strip_tags(R('username', 'P'));
			$password = R('password', 'P');
			$code = R('code', 'P');
			
			if( empty($username) ){
				$this->message(0, '啊哦，用户名不能为空！');
			}elseif( empty($password) ){
				$this->message(0, '啊哦，密码不能为空！');
			}elseif( empty($code) ){
				$this->message(0, '啊哦，验证码不能为空！');
			}elseif( md5($code) != session::get('logincode') ){
				$this->message(0, '啊哦，验证码不正确！');
			}
			

			if($message = $user->check_username($username)) {
				$this->message(0, $message);
			}elseif($message = $user->check_password($password)){
				$this->message(0, $message);
			}

			// 防IP暴力破解
			$ip = &$_ENV['_ip'];
			if($user->anti_ip_brute($ip)) {
				$this->message(0, "啊哦，请15分钟之后再试！");
			}

			$data = $user->get_user_by_username($username);
			if($data && $user->verify_password($password, $data['salt'], $data['password'])) {
				
				$statusFormat = array(0=>'账号还未通过审核，请等待审核',1=>'正常',2=>'该账号已被禁止登录');
				
				if( $data['status'] != 1 ){
					$this->message(0, $statusFormat[$data['status']]);
				}
				
				//写入SESSION
				session::set('_uid', $data['uid']);

				// 更新登陆信息
				$data['lastip'] = $data['loginip'];
				$data['lastdate'] = $data['logindate'];
				$data['loginip'] = ip(1);
				$data['logindate'] = $_ENV['_time'];
				$data['logins']++;
				$user->update($data);

				// 删除密码错误记录
				$this->runtime->delete('password_error_'.$ip);
				
				$this->message(1, "登录成功！",'index.php?u=index-index');
			}else{
				// 记录密码错误次数
				$user->password_error($ip);

				$this->message(0, "啊哦，帐号或密码不正确！");
			}
		}
	}
	
	//注册
	public function register(){
		if( empty($this->_user_cfg['open_user_reg']) ){	//关闭新会员注册
			$this->message(0, '站点已关闭注册功能！');
		}
		
		if( empty($_POST) ){
			$this->_cfg['titles'] = '用户注册_'.$this->_cfg['webname'];
			$this->assign('maybe', $this->_cfg);
			$this->display('register.htm');
		}else{
			$user = &$this->user;
			
			$username = strip_tags(R('username', 'P'));
			$password = R('password', 'P');
			$repassword = R('repassword', 'P');
			$email = R('email', 'P');
			$code = R('code', 'P');
			
			if( empty($username) ){
				$this->message(0, '啊哦，用户名不能为空！');
			}elseif( empty($password) ){
				$this->message(0, '啊哦，密码不能为空！');
			}elseif( empty($repassword) ){
				$this->message(0, '啊哦，确认密码不能为空！');
			}elseif( empty($code) ){
				$this->message(0, '啊哦，验证码不能为空！');
			}elseif( !check::is_email($email) ){
				$this->message(0, '啊哦，邮箱格式不正确！');
			}elseif ( $password != $repassword ){
				$this->message(0, '啊哦，两次输入的密码不一致！');
			}elseif( md5($code) != session::get('regcode') ){
				$this->message(0, '啊哦，验证码不正确！');
			}
			
			if($message = $user->check_username($username)) {
				$this->message(0, $message);
			}elseif($message = $user->check_password($password)){
				$this->message(0, $message);
			}
			
			if( $user->get_user_by_username($username) ){
				$this->message(0, '啊哦，用户名已被注册！');
			}
			
			//激活方式
			$user_active_method = isset($this->_user_cfg['user_active_method']) ? intval($this->_user_cfg['user_active_method']):0;
			
			$ip = ip(1);
			$time = time();
			$salt = random(16, 3, '0123456789abcdefghijklmnopqrstuvwxyz~!@#$%^&*()_+<>,.');
			$data = array(
					'username'=>$username,
					'password'=>get_password($password,$salt),
					'salt'=>$salt,
					'groupid'=>11,
					'email'=>$email,
					'regip'=>$ip,
					'regdate'=>$time,
					'author'=>$username,
					'isadmin'=>0,
					'status'=> $user_active_method == 0 ? 1:0,
					);
			$uid = $user->create($data);
			if( $uid ){	
				$user_data = &$this->user_data;	
				$info_data['uid'] = $uid;
				$user_data->create($info_data);
				
				$endStr = '';
				if( $user_active_method == 1 ){	//管理审核激活
					$endStr = '，请等待管理员审核！';
				}elseif( $user_active_method == 2 ){	//邮箱激活
					//发送邮件
					$s = $uid.','.$time;
					$Xxtea = new Xxtea();
					$code = $Xxtea->encrypt($s,$_ENV['_config']['auth_key']);
					$url = $this->_cfg['weburl'].'user/index.php?u=public-active-code-'.$code;
					$clickUrl = '<a target="_blank" href="'.$url.'">激活账号</a>';

					$email_content = $this->_user_cfg['email_active_content'];
					$email_content = str_replace('{click}', $clickUrl, $email_content);
					$email_content = str_replace('{url}', $url, $email_content);
					
					$subject = '请激活您在'.$this->_cfg['webname'].'注册的账号！';
					$message = "
					<html>
					<head>
					<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
					</head>
					<body>
					{$username}，您好！<br />
					$email_content
					</body>
					</html>";
					
					$mmiscModel = &$this->mmisc;
					$errMsg = $mmiscModel->sendmail($username,$email,$subject,$message);
					
					$endStr = '请查收邮件，进行账号激活！';
					
					if( $errMsg ){
						$this->message(0, '邮件发送失败，请联系网站管理员！');
					}
				}
					
				$this->message(1, '注册成功！'.$endStr,'index.php?u=public-login');
			}else{
				$this->message(0, '注册失败，请重试！');
			}
			
		}
	}
	
	//邮箱激活账号
	public function active(){
		$code = R('code','G');
		if(empty($code)) {
			$this->message(0,'缺少参数 code。');
		}
		$Xxtea = new Xxtea();
		$s = $Xxtea->decrypt($code,$_ENV['_config']['auth_key']);
		
		$arr = explode(",",  $s);
		if(empty($arr) || empty($s)) {
			$this->message(0,'参数解密错误。');
		}
		
		$uid = $arr[0];
		$time = $arr[1];
		if(time() - $time > 86400) {
			$this->message(0,'激活链接已经过期（超过一天），请重新注册。');
		}
		
		$user = $this->user->read($uid);
		if( empty($user) ) {
			$this->message(0,'用户不存在！可能已经被删除。');
		}elseif($user['status'] == 1) {
			$this->message(0,'您的账户已经激活，不需要重新激活。');
		}
		$user['status'] = 1;
		$this->user->update($user);
		
		// hook user_public_active_after.php
		
		$this->message(1,$user['username'].'，您好！您的账号激活成功！','index.php?u=public-login');
	}
	
	//忘记密码
	public function getpassword(){
		if( empty($_POST) ){
			$this->_cfg['titles'] = '忘记密码_'.$this->_cfg['webname'];
			$this->assign('maybe', $this->_cfg);
			$this->display('forget.htm');
		}else{
			$username = strip_tags(R('username','P'));
			$email = R('email','P');
			
			$user = &$this->user;
			
			if( empty($username) ){
				$this->message(0, '啊哦，用户名不能为空！');
			}elseif( !check::is_email($email) ){
				$this->message(0, '啊哦，邮箱格式不正确！');
			}elseif( $message = $user->check_username($username) ) {
				$this->message(0, $message);
			}
			$userInfo = $user->get_user_by_username($username);
			if( empty($userInfo) ){
				$this->message(0, '啊哦，用户名不存在！');
			}elseif ( $userInfo['email'] != $email ){
				$this->message(0, '啊哦，绑定邮箱不正确！');
			}else{
				//生成一个新的随机密码，已邮件的形式发到邮箱
				$password = random(10,2);
				$userInfo['password'] = get_password($password,$userInfo['salt']);
				if( !$user->update($userInfo) ){
					$this->message(0, '啊哦，重置密码失败，请重试！');
				}else{
					
					$email_content = $this->_user_cfg['email_pwd_content'];
					$email_content = str_replace('{password}', $password, $email_content);
						
					$subject = $this->_cfg['webname'].'注册账号新密码！';
					$message = "
					<html>
					<head>
					<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />
					</head>
					<body>
					{$username}，您好！<br />
					$email_content
					</body>
					</html>";
						
					$mmiscModel = &$this->mmisc;
					$errMsg = $mmiscModel->sendmail($username,$email,$subject,$message);
					if( $errMsg ){
						$this->message(0, '啊哦，邮件发送失败，请重试！');
					}else{
						$this->message(1, '邮件发送成功，请稍后查收邮件内容！');
					}
				}
			}
		}
	}
	
	//登出
	public function logout(){
		session::delete('_uid');
		session::destory();
		exit('<html><body><script>window.location="index.php?u=public-login"</script></body></html>');
	}
}
