<?php
// +----------------------------------------------------------------------
// | MAYBECMS	用户模块基类控制器
// +----------------------------------------------------------------------
// | Copyright (c) 2012-2014 http://www.maybecms.com, All rights reserved.
// +----------------------------------------------------------------------
// | Author: Lou <379559090@qq.com>
// +----------------------------------------------------------------------
defined('MAYBECMS_PATH') or exit('Maybecms Access Denied');
class user_control extends control{
	public $_user = array();	// 用户
	public $_uid = 0;	//UID
	public $_group = array();	// 当前组
	public $_cfg = array();	// 全站参数
	public $_user_cfg = array();	//用户模块配置
	
	function __construct() {
		$this->assign('C', $_ENV['_config']);
		$this->assign_value('core', F_APP_NAME);
		
		$this->_cfg = $this->runtime->xget('cfg');
		$this->_cfg['titles'] = $this->_cfg['webname'];
		$this->assign('maybe', $this->_cfg);
		
		$this->_user_cfg = $this->kv->xget('user_cfg');
		
		if( empty($this->_user_cfg['open_user_model']) ){	//关闭用户模块
			$this->message(0, '站点已关闭用户中心！',$this->_cfg['weburl']);
		}
		
		$this->_uid = session::get('_uid');
		
		$err = 1;
		
		if( $this->_uid ){
			$err = 0;
			$user = &$this->user;
			$user_group = &$this->user_group;
			$this->_user = $user->get_user_by_uid($this->_uid);	//当前管理员信息
			
			$user->format($this->_user);		
			$group = $user_group->find_fetch( array('groupid'=>$this->_user['groupid']) );
			$gKey = 'user_group-groupid-'.$this->_user['groupid'];
			$this->_group = $group[$gKey];
			
			$this->assign('user', $this->_user);
			$this->assign('group', $this->_group);
		}
		
		if($err) {
			if(R('ajax')) {
				$this->message(0, '非法访问，请登陆后再试！', 'index.php?u=public-login');
			}
			exit('<html><body><script>top.location="index.php?u=public-login"</script></body></html>');
		}
	}
	
	//重写父类的信息提示方法
	public function message($status, $message, $jumpurl = '', $delay = 2) {	
		if(R('ajax')) {
			$status = $status == 1 ? 0:1;	//AJAX返回0表示成功，1表示失败
			echo json_encode(array('err'=>$status, 'msg'=>$message, 'jumpurl'=>$jumpurl, 'delay'=>$delay));
		}else{
			if(empty($jumpurl)) {
				$jumpurl = empty($_SERVER['HTTP_REFERER']) ? '' : $_SERVER['HTTP_REFERER'];
			}
			include KONG_PATH.'tpl/sys_message.php';
		}
		exit;
	}
	
	// hook user_user_control_after.php
}