<?php
/*
Plugin Name: Ajax Portfolio
Plugin URI: http://www.wpthemers.net
Description: Ajax Portfolio Grid for WordPress
Version: 2.0.0 RC1
Author: WP Themers
Author Email: support@wpthemers.net
*/
/*--------------------------------------------*
 * DO NOT EDIT THIS LINE
 *--------------------------------------------*/
if(!defined('GF_ENABLE_SETTINGS')) {
	define('GF_ENABLE_SETTINGS', FALSE);
}

/*--------------------------------------------*
 * Include Includes
 *--------------------------------------------*/
require_once 'lib/class-tgm-plugin-activation.php';
require_once 'lib/BFI_Thumb.php';
require_once 'lib/gravity-fields/gravity-fields.php';

/*--------------------------------------------*
 * Main Class
 *--------------------------------------------*/
class AjaxPortfolio {

	/*--------------------------------------------*
	 * Constants
	 *--------------------------------------------*/
	const name = 'Ajax Portfolio';
	const slug = 'ajax_portfolio';

	public $atts;
	private $entries;


	/**
	 * Constructor
	 */
	function __construct() {
		add_action( 'tgmpa_register', array( &$this, 'ajax_portfolio_required_plugins' ) );
		add_action( 'init', array( &$this, 'init_ajax_portfolio' ) );
		add_action( 'admin_footer', array( &$this, 'shortcode_editor_html' ), 1000 );
		add_action( 'gf_setup', array( $this, 'setup_ui' ) );
		add_action( 'wp_enqueue_scripts', array( $this, 'load_site_assets' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'load_admin_assets' ) );
		// Setup the event handler for generating html for the ajax
		add_action( 'wp_ajax_nopriv_get_portfolio', array( &$this, 'get_portfolio' ) );
		add_action( 'wp_ajax_get_portfolio', array( &$this, 'get_portfolio' ) );
		add_action( 'wp_ajax_nopriv_infinte_items', array( &$this, 'infinte_items' ) );
		add_action( 'wp_ajax_infinte_items', array( &$this, 'infinte_items' ) );
	}

	function ajax_portfolio_required_plugins() {

		$plugins = array(
			array(
				'name'         => 'Gravity Portfolio Post Type', // The plugin name
				'slug'         => 'gravity-portfolio-post-type', // The plugin slug (typically the folder name)
				'source'       => dirname( __FILE__ ).'/lib/plugins/gravity-portfolio-post-type.zip', // The plugin source
				'required'     => true, // If false, the plugin is only 'recommended' instead of required
				'version'     => '1.0.1', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
				'force_activation'   => false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
				'force_deactivation'  => false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
				'external_url'    => '', // If set, overrides default API URL and points to an external URL
			)
		);

		// Change this to your theme text domain, used for internationalising strings
		$theme_text_domain = self::slug;

		/**
		 * Array of configuration settings. Amend each line as needed.
		 * If you want the default strings to be available under your own theme domain,
		 * leave the strings uncommented.
		 * Some of the strings are added into a sprintf, so see the comments at the
		 * end of each line for what each argument will be.
		 */
		$config = array(
			'domain'         => $theme_text_domain,          // Text domain - likely want to be the same as your theme.
			'default_path'   => '',                          // Default absolute path to pre-packaged plugins
			'parent_menu_slug'  => 'plugins.php',     // Default parent menu slug
			'parent_url_slug'  => 'plugins.php',     // Default parent URL slug
			'menu'           => 'install-required-plugins',  // Menu slug
			'has_notices'       => true,                        // Show admin notices or not
			'is_automatic'     => true,         // Automatically activate plugins after installation or not
			'message'    => '',       // Message to output right before the plugins table
			'strings'        => array(
				'page_title'                          => __( 'Install Required Plugins', $theme_text_domain ),
				'menu_title'                          => __( 'Install Plugins', $theme_text_domain ),
				'installing'                          => __( 'Installing Plugin: %s', $theme_text_domain ), // %1$s = plugin name
				'oops'                                => __( 'Something went wrong with the plugin API.', $theme_text_domain ),
				'notice_can_install_required'        => _n_noop( 'Ajax Portfolio requires the following plugin: %1$s.', 'Ajax Portfolio requires the following plugins: %1$s.' ), // %1$s = plugin name(s)
				'notice_can_install_recommended'   => _n_noop( 'Ajax Portfolio recommends the following plugin: %1$s.', 'Ajax Portfolio recommends the following plugins: %1$s.' ), // %1$s = plugin name(s)
				'notice_cannot_install'       => _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.' ), // %1$s = plugin name(s)
				'notice_can_activate_required'       => _n_noop( 'The following required plugin for Ajax Portfolio is currently inactive: %1$s.', 'The following required plugins for Ajax Portfolio are currently inactive: %1$s.' ), // %1$s = plugin name(s)
				'notice_can_activate_recommended'   => _n_noop( 'The following recommended plugin for Ajax Portfolio is currently inactive: %1$s.', 'The following recommended plugins for Ajax Portfolio are currently inactive: %1$s.' ), // %1$s = plugin name(s)
				'notice_cannot_activate'      => _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.' ), // %1$s = plugin name(s)
				'notice_ask_to_update'       => _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.' ), // %1$s = plugin name(s)
				'notice_cannot_update'       => _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.' ), // %1$s = plugin name(s)
				'install_link'           => _n_noop( 'Begin installing plugin', 'Begin installing plugins' ),
				'activate_link'          => _n_noop( 'Activate installed plugin', 'Activate installed plugins' ),
				'return'                              => __( 'Return to Required Plugins Installer', $theme_text_domain ),
				'plugin_activated'                    => __( 'Plugin activated successfully.', $theme_text_domain ),
				'complete'          => __( 'All plugins installed and activated successfully. %s', $theme_text_domain ), // %1$s = dashboard link
				'nag_type'         => 'error' // Determines admin notice type - can only be 'updated' or 'error'
			)
		);

		tgmpa( $plugins, $config );

	}

	function init_ajax_portfolio() {
		// Setup localization
		load_plugin_textdomain( self::slug, false, dirname( plugin_basename( __FILE__ ) ) . '/lang' );
		// Register the tinyMce buttons
		add_filter( 'mce_external_plugins', array( &$this, 'add_buttons' ), 1000 );
		add_filter( 'mce_buttons', array( &$this, 'register_buttons' ), 1000 );
		// Register the shortcode [ajax_portfolio]
		add_shortcode( 'ajax_portfolio', array( &$this, 'render_shortcode' ) );
		// Add Thumbnail support for themes
		add_theme_support( 'post-thumbnails' );
	}

	function load_site_assets() {

		//wp_enqueue_style( 'gravity_mediaelement' );
		wp_enqueue_style( 'dashicons' );
		wp_enqueue_style( 'gravity_plug_mediaelement_css', plugins_url( 'asset/mejs/mediaelementplayer.css', __FILE__ ) );
		wp_enqueue_style( self::slug.'frontend_css', plugins_url( 'asset/frontend/css/style.css', __FILE__ ) );
		
		wp_enqueue_script( 'gravity_plug_modernizr', plugins_url( 'asset/frontend/js/modernizr.js', __FILE__ ), array( 'jquery' ), '2.7.1', true );
		wp_enqueue_script( 'gravity_plug_easing', plugins_url( 'asset/frontend/js/jquery.easing.min.js', __FILE__ ), array( 'jquery' ), '1.3', true );
		wp_enqueue_script( 'gravity_plug_mousewheel', plugins_url( 'asset/frontend/js/jquery.mousewheel.min.js', __FILE__ ), array( 'jquery' ), '3.1.8', true );
		wp_enqueue_script( 'gravity_plug_waitforimages', plugins_url( 'asset/frontend/js/jquery.waitforimages.min.js', __FILE__ ), array( 'jquery' ), '1.0.0', true );
		wp_enqueue_script( 'gravity_plug_throttledresize', plugins_url( 'asset/frontend/js/jquery.throttledresize.min.js', __FILE__ ), array( 'jquery' ), '1.0', true );
		wp_enqueue_script( 'gravity_plug_actual', plugins_url( 'asset/frontend/js/jquery.actual.min.js', __FILE__ ), array( 'jquery' ), '1.0.16', true );
		wp_enqueue_script( 'gravity_plug_transit', plugins_url( 'asset/frontend/js/jquery.transit.min.js', __FILE__ ), array( 'jquery' ), '0.9.9', true );
		wp_enqueue_script( 'gravity_plug_withinviewport', plugins_url( 'asset/frontend/js/jquery.withinViewport.js', __FILE__ ), array( 'jquery' ), '0.0.2', true );
		wp_enqueue_script( 'gravity_plug_sgallery', plugins_url( 'asset/frontend/js/jquery.sgallery.min.js', __FILE__ ), array( 'jquery' ), '1.0.0', true );
		wp_enqueue_script( 'gravity_plug_flexslider', plugins_url( 'asset/frontend/js/jquery.flexslider.min.js', __FILE__ ), array( 'jquery' ), '2.2.2', true );
		wp_enqueue_script( 'gravity_plug_isotope', plugins_url( 'asset/frontend/js/isotope.min.js', __FILE__ ), array( 'jquery' ), '2.0.0', true );
		wp_enqueue_script( 'gravity_plug_mediaelement', plugins_url( 'asset/mejs/mediaelement-and-player.min.js', __FILE__ ) );
		wp_enqueue_script( self::slug.'frontend_js', plugins_url( 'asset/frontend/js/custom.js', __FILE__ ), array( 'jquery' ), '1.2', true );
		wp_localize_script( self::slug.'frontend_js', 'ajp', array( 'ajaxurl' => admin_url( 'admin-ajax.php' ), 'flashName' => plugins_url( 'asset/mejs/flashmediaelement.js', __FILE__ ) ) );
	}

	function load_admin_assets() {
		wp_enqueue_style( self::slug.'backend_css', plugins_url( 'asset/backend/css/style.css', __FILE__ ) );
	}

	function shortcode_editor_html() {
		include 'views/editor-html.php';
	}

	function setup_ui() {
		GF_Postmeta::factory( 'Portfolio Settings', array(
				'portfolio'
			) )
		->add_fields( array(
				GF_Field::factory( 'repeater', 'slider' )
				->set_title( __( 'Slideshow', 'ajax_portfolio' ) )
				->add_fields( 'image', __( 'Image', 'ajax_portfolio' ) , array(
						GF_Field::factory( 'image', 'image' )
					) )
				/*Add by Sentient*/
				->add_fields( 'thumbnailgallery', __( 'Thumbnail Gallery', 'ajax_portfolio' ) , array(
						GF_Field::factory( 'repeater', 'gallery' )
						->add_fields( 'image', __( 'Gallery Item', 'ajax_portfolio' ) , array(
								GF_Field::factory( 'image', 'image' )
							) )

					) )					
				->add_fields( 'gallery', __( 'Gallery', 'ajax_portfolio' ) , array(
						GF_Field::factory( 'repeater', 'gallery' )
						->add_fields( 'image', __( 'Gallery Item', 'ajax_portfolio' ) , array(
								GF_Field::factory( 'image', 'image' )
							) )

					) ),



				)
					
			) ;
	}

	function add_buttons( $plugin_array ) {
		$plugin_array['ajp'] = plugins_url( 'asset/backend/js/editor-plugin.js', __FILE__ );
		return $plugin_array;
	}

	function register_buttons( $buttons ) {
		array_push( $buttons, 'ajp' );
		return $buttons;
	}

	function render_shortcode( $atts ) {
		$this->atts = shortcode_atts( array(
				'categories'=> '',
				'columns'  => '4',
				'thumb_size' => 'medium',
				'thumb_width' => '400',
				'thumb_height' => '300',
				'padding' => '0',
				'items'  => '16',
				'sort'   => 'yes',
				'orderby' => 'date',
				'order'  => 'DESC',
				'caption' => 'no',
				'prevnext' => 'no',
				'paginate' => 'no',
				'post_type' => 'portfolio',
				'taxonomy'  => 'portfolio_category',
				'animation' => '2'
			), $atts );

		return $this->create_grid_html();
	}


	function sort_buttons( $params ) {
		//get all categories that are actually listed on the page
		
		$tax_selected = explode(',', $this->atts['categories']);
		
		$categories = get_terms( $params['taxonomy'], 'orderby=name&hide_empty=0' );
		$count = count( $categories );
		$output  = "<div class='sort_width_container clearfix' ><div id='js_sort_items' >";
		$output .= "<div class='sort_by_cat clearfix'>";
		$output .= "<span class='sort_label'>".__( 'All', 'ajax_portfolio' )."</span>";
		$output .= "<ul class='sort_list'>";
		$output .= "<li><a href='#' data-filter='*' class='all_sort_button active_sort'>".__( 'All', 'ajax_portfolio' )."</a></li>";
		if ( $count > 0 ) {
			foreach ( $categories as $category ) {
				if(in_array($category->term_id, $tax_selected)) {
					$output .= "<li><a href='#' data-filter='.".$category->slug."_sort' class='".$category->slug."_sort_button' >".$category->name."</a></li>";
				}
			}
		}
		$output .= "</ul>";
		$output .= "</div></div></div>";
		return $output;
	}

	//get the categories for each post and create a string that serves as classes so the javascript can sort by those classes
	function sort_cat_string( $the_id, $params ) {
		$sort_classes = "";
		$item_categories = get_the_terms( $the_id, $params['taxonomy'] );
		if ( is_object( $item_categories ) || is_array( $item_categories ) ) {
			foreach ( $item_categories as $cat ) {
				$sort_classes .= $cat->slug.'_sort ';
			}
		}
		return $sort_classes;
	}
	
	function query_entries($params = array()){
		$query = array();
		if ( empty( $params ) ) $params = $this->atts;

		if ( !empty( $params['categories'] ) ) {
			$terms  = explode( ',', $params['categories'] );
		}
		$page = get_query_var( 'paged' ) ? get_query_var( 'paged' ) : get_query_var( 'page' );
		if ( !$page ) $page = 1;
		//if we find categories perform complex query, otherwise simple one
		if ( isset( $terms[0] ) && !empty( $terms[0] ) && !is_null( $terms[0] ) && $terms[0] != "null" ) {
			$query = array(
				'orderby'  => $params['orderby'],
				'order'  => $params['order'],
				'paged'  => $page,
				'posts_per_page' => $params['items'],
				'post_type' => $params['post_type'],
				'tax_query' => array(  
					array(  'taxonomy'  => $params['taxonomy'],
							'field'  => 'id',
							'terms'  => $terms,
							'operator'  => 'IN')
					)
			); // End query args array
		}
		else {
			$query = array( 'paged'=> $page, 'posts_per_page' => $params['items'], 'post_type' => $params['post_type'] );
		}
		
		$new_query = new WP_Query($query);
		
		return $new_query;
	}
	
	function create_grid_entry($the_id = false) {
		$output = '';
		$padding_adjust_style = $this->atts['padding'] ? 'style="padding: '.$this->atts['padding'].'px"' : '';
		$post_class = "portfolio-entry portfolio-overlay amer";
		$sort_class = $this->sort_cat_string( $the_id, $this->atts );
		if ( has_post_thumbnail( $the_id ) ) {
			$thumb = get_post_thumbnail_id( $the_id );
			if($this->atts['thumb_size'] == 'custom') {
				$img_url = wp_get_attachment_url( $thumb );
				$post_image = bfi_thumb( $img_url, array( 'width' => $this->atts['thumb_width'], 'height' => $this->atts['thumb_height'], 'crop' => true ) );
			} else {
				$img_url = wp_get_attachment_image_src( $thumb, $this->atts['thumb_size'] );
				$post_image = $img_url[0];
			}
		}
		else {
			$post_image = 'http://dummyimage.com/'.$this->atts['thumb_width'].'x'.$this->atts['thumb_height'].'/eee/333.png';
		}
		
		//$post_image = aq_resize( $img_url, 410, 310, true, true );
		
		$link = get_permalink( $the_id );
		$title = get_the_title( $the_id );
		//$term = strip_tags( get_the_term_list( $the_id, $taxonomy, '', ', ', '' ) );
		$output .= "<div id='entry-{$the_id}' class='{$post_class} {$sort_class}' {$padding_adjust_style}>";
		$output .= "<div data-permalink='{$link}' data-post-id='{$the_id}' class='portfolio-image project-load'>";
		$output .= "<img class='entry-image' src='{$post_image}' alt='{$title}'>";
		if($this->atts['caption'] == 'yes') {
			$caption_text = get_post_meta( $the_id, 'custom_caption', true );
			if ( !empty( $caption_text ) )
				$output .= "<div class='img-overlay'><div>{$caption_text}</div></div>";
			else
				$output .= "<div class='img-overlay'><div><h2 class='overlay-title'>{$title}</h2></div></div>";
		} else {
			$output .= "<div class='img-overlay'><div class='dashicons dashicons-plus'></div></div>";
		}
		$output .= "</div>";
		$output .= "</div>";
		return $output;
	}
	
	function create_grid_html( $params = array() ) {
		global $post;
		$entries = $this->query_entries();
		$output = '';
		$margin_adjust_style = $this->atts['padding'] ? 'style="margin: -'.$this->atts['padding'].'px"' : '';
		$pagination_class = 'pagination-'.$this->atts['paginate'];
		$animation = $this->atts['animation'];
		if ( $entries->have_posts() ) :
			$postCount = $entries->found_posts;
			$output .= "<div class='portfolio-grid {$pagination_class}'>";
			$output .= "<div class='portfolio-loader'><div></div></div>";
			$output .= $this->atts['sort'] == "yes" ? $this->sort_buttons( $this->atts ) : "";
			$output .= "<div class='ajax-container'>";
			$output .= "<div class='ajax-controls'>";
			$output .= $this->atts['prevnext'] == "yes" ? "<a href='#' class='prev-ajax-container'><i class='dashicons dashicons-arrow-left-alt'></i></a>" : "";
			$output .= "<a href='#' class='close-ajax-container'><i class='dashicons dashicons-no'></i></a>";
			$output .= $this->atts['prevnext'] == "yes" ? "<a href='#' class='next-ajax-container'><i class='dashicons dashicons-arrow-right-alt'></i></a>" : "";
			$output .= "</div></div>";
			$output .= "<div id='portfolio-grid-frame' class='portfolio-grid-container isotope' data-effect='effect-{$animation}' data-post-count='{$postCount}' data-columns='{$this->atts["columns"]}' {$margin_adjust_style} >";
			while ( $entries->have_posts() ) : $entries->the_post();
				$output.= $this->create_grid_entry($post->ID);
			endwhile;
			$output .= "</div>";
			if($this->atts['paginate'] != 'no') {
				if($pagination = $this->pagination($entries->max_num_pages)){
					$output .= "<div class='portfolio-pagination'>{$pagination}</div>";	
				}
			}
			$output .= "</div>";
		endif;
		return $output;
	}

	function infinte_items() {
		
	}

	function get_portfolio() {
		if ( isset( $_POST['id'] ) && !empty( $_POST['id'] ) ):
			$html = $this->project_html( $_POST['id'] );
		die( $html );
		else:
			die( 0 );
		endif;
	}

	function pagination( $pages = '', $wrapper = 'div' ) {
		global $paged;
		if ( get_query_var( 'paged' ) ) {
			$paged = get_query_var( 'paged' );
		} elseif ( get_query_var( 'page' ) ) {
			$paged = get_query_var( 'page' );
		} else {
			$paged = 1;
		}
		$output    = "";
		$prev      = $paged - 1;
		$next      = $paged + 1;
		$range     = 2; // only edit this if you want to show more page-links
		$showitems = ( $range * 2 ) + 1;
		if ( $pages == '' ) {
			global $wp_query;
			//$pages = ceil(wp_count_posts($post_type)->publish / $per_page);
			$pages = $wp_query->max_num_pages;
			if ( !$pages ) {
				$pages = 1;
			}
		}
		$method = "get_pagenum_link";
		if ( is_single() ) {
			$method = "$this->post_pagination_link";
		}
		if ( 1 != $pages ) {
			$output .= "<$wrapper class='pagination'>";
			$output .= ( $paged > 2 && $paged > $range + 1 && $showitems < $pages ) ? "<a href='" . $method( 1 ) . "'>&laquo;</a>" : "";
			$output .= ( $paged > 1 && $showitems < $pages ) ? "<a href='" . $method( $prev ) . "'>&lsaquo;</a>" : "";
			for ( $i = 1; $i <= $pages; $i++ ) {
				if ( 1 != $pages && ( !( $i >= $paged + $range + 1 || $i <= $paged - $range - 1 ) || $pages <= $showitems ) ) {
					$output .= ( $paged == $i ) ? "<span class='current'>" . $i . "</span>" : "<a href='" . $method( $i ) . "' class='inactive' >" . $i . "</a>";
				}
			}
			$output .= ( $paged < $pages && $showitems < $pages ) ? "<a href='" . $method( $next ) . "'>&rsaquo;</a>" : "";
			$output .= ( $paged < $pages - 1 && $paged + $range - 1 < $pages && $showitems < $pages ) ? "<a href='" . $method( $pages ) . "'>&raquo;</a>" : "";
			$output .= "</$wrapper>\n";
		}
		return $output;
	}
	function post_pagination_link( $link ) {
		$url = preg_replace( '!">$!', '', _wp_link_page( $link ) );
		$url = preg_replace( '!^<a href="!', '', $url );
		return $url;
	}


	function project_html( $id = false ) {
		$query = array();
		global $wp_embed;
		if ( empty( $id ) )
			return false;
		query_posts( array(
				'post_type' => 'portfolio',
				'p' => $id
			) );
		$html = '';
		if ( have_posts() ):
			while ( have_posts() ):
				the_post();
			$the_id                  = get_the_ID();
		$size                    = 'full';
		$current_post['title']   = get_the_title();
		$current_post['content'] = get_the_content();
		// Apply the default wordpress filters to the content
		$current_post['content'] = str_replace( ']]>', ']]&gt;', apply_filters( 'the_content', $current_post['content'] ) );
		$slides                  = get_post_meta( $the_id, 'slider', false );
		$slides                  = $slides[0];
		$rand                    = mt_rand();
		$slideshow               = '';
		
		/*Added by Sentient*/
		$sentient_make_it_gallery = false;
		
		foreach ( $slides as $slide ):
			switch ( $slide['type'] ) {
			
			/*Added by Sentient*/
			case 'thumbnailgallery':
				$gallery_images = $slide['gallery'];

				$output = "<div id='gallery-{$the_id}' class='sentient-gallery-slideshow sentient-gallery-slideshow-play'>";
				$output .= "<ul class='sentient-gallery-list slides'>";
				
				foreach ( $gallery_images as $gallery_image ):
					$attachment_id = $gallery_image['image'];
					$get_image_url_only = wp_get_attachment_url( $attachment_id );
					$image = wp_get_attachment_image_src( $attachment_id, array(777,660) );
					$image = $image[0];
					$output .= "<li class='gallery-item' data-thumb='{$get_image_url_only}' >";
					$alt = get_post_meta($attachment_id, '_wp_attachment_image_alt', true);
					$output .= "<img src='{$image}' alt='{$alt}' />";
					$output .= "</li>";
				endforeach;

				$output .= "</ul></div>";
				$slideshow = $output;
				$sentient_make_it_gallery = true;
				break;
				
			case 'gallery':
				$gallery_images = $slide['gallery'];
				/*$gallery_cols   = $slide['columns'];*/
				$gallery_cols   = 1;
				$thumb_width    = round( 100 / $gallery_cols, 4 );
				$small_items    = $big_items = "";
				$counter        = 0;
				$width          = 400;
				$height         = 300;
				foreach ( $gallery_images as $gallery_image ):
					$attachment_id = $gallery_image['image'];
				if ( empty( $attachment_id ) )
					continue;
				$img_url    = wp_get_attachment_url( $attachment_id, 'full' );
				/*$post_image = bfi_thumb( $img_url, array( 'width' => $width, 'height' => $height, 'crop' => true ) );*/
				
				/*Added by Sentient*/
				$post_image = bfi_thumb( $img_url, array( 'width' => $width, 'height' => $height, 'crop' => true ) );

				$full_image = wp_get_attachment_image_src( $attachment_id, 'full' );
				$full_image = $full_image[0];
				$small_items .= '<li class="item"><a href="' . $full_image . '"><img src="' . $post_image . '" alt=""></a></li>';
				$big_items .= '<li class="item"><a href="' . $full_image . '"><img src="' . $full_image . '" alt=""><i class="fa-plus"></i></a></li>';
				endforeach;
				$output = '<div class="gallery-block" id="gallery-' . $rand . '">';
				$output .= '<div class="gallery-inner">';
				$output .= '<ul class="items-small clearfix">' . $big_items . '</ul>';
				$output .= '<ul class="items-big">' . $big_items . '</ul>';
				$output .= '<div class="controls"><span class="prev"><i class="dashicons dashicons-arrow-left-alt"></i></span><span class="grid"><i class="dashicons dashicons-screenoptions"></i></span><span class="next"><i class="dashicons dashicons-arrow-right-alt"></i></span></div>';
				$output .= "</div>";
				$output .= "</div>";
				$output .= "<style type='text/css'>";
				$output .= "#gallery-" . $rand . " .items-small .item{width:{$thumb_width}%;}";
				$output .= "</style>";
				$slideshow = "<li class='project_slide slide-type-gallery'>" . $output . "</li>";
				break;
			case 'image':
				$attachment_id = $slide['image'];
				if ( empty( $attachment_id ) )
					continue;
				/*$image = wp_get_attachment_image_src( $attachment_id, $size );*/
				$image = wp_get_attachment_image_src( $attachment_id, array(777,590) );
				$image = $image[0];
				/*The style inside img is added by Sentient*/
				$slideshow .= "<li class='project_slide slide-type-image'><div><img  src='{$image}' alt='' /></div></li>";
				break;
			case 'video':
				$video_url = $slide['video_url'];
				if ( empty( $video_url ) )
					continue;
				$output = '';
				$output = $wp_embed->run_shortcode( "[embed]" . trim( $video_url ) . "[/embed]" );
				if ( $output )
					$slideshow .= "<li class='project_slide slide-type-video'><div class='portfolio-responsive-media'>{$output}</div></li>";
				break;
			case 'svideo':
				$output = $poster = '';
				$source = array();
				if ( isset( $slide['mp4_url'] ) && !empty( $slide['mp4_url'] ) ) {
					$file_extension = substr( $slide['mp4_url'], strrpos( $slide['mp4_url'], '.' ) + 1 );
					if ( ( $file_extension == 'mp4' ) || ( $file_extension ) == 'MP4' )
						$source['mp4'] = $slide['mp4_url'];
				}
				if ( isset( $slide['webm_url'] ) && !empty( $slide['webm_url'] ) ) {
					$file_extension = substr( $slide['webm_url'], strrpos( $slide['webm_url'], '.' ) + 1 );
					if ( ( $file_extension == 'webm' ) || ( $file_extension ) == 'WEBM' )
						$source['webm'] = $slide['webm_url'];
				}
				if ( isset( $slide['flv_url'] ) && !empty( $slide['flv_url'] ) ) {
					$file_extension = substr( $slide['flv_url'], strrpos( $slide['flv_url'], '.' ) + 1 );
					if ( ( $file_extension == 'flv' ) || ( $file_extension ) == 'FLV' )
						$source['flv'] = $slide['flv_url'];
				}
				if ( empty( $source ) )
					continue;
				$attachment_id = $slide['poster'];
				if ( !empty( $attachment_id ) ) {
					$poster = wp_get_attachment_image_src( $attachment_id, $size );
					$poster = $poster[0];
				}
				$uid    = 'player_' . mt_rand();
				$poster = 'poster="' . $poster . '"';
				$output .= '<video controls="" width="640" height="360" class="video" ' . $poster . ' id="' . $uid . '" >';
				foreach ( $source as $type => $source_url ) {
					$output .= "<source src='{$source_url}' type='video/{$type}' />";
				}
				$output .= '</video>';
				if ( $output )
					$slideshow .= "<li class='project_slide slide-type-self-video'><div>{$output}</div></li>";
				break;
			case 'saudio':
				$output = $poster = '';
				$source = array();
				if ( isset( $slide['mp3_url'] ) && !empty( $slide['mp3_url'] ) ) {
					$file_extension = substr( $slide['mp3_url'], strrpos( $slide['mp3_url'], '.' ) + 1 );
					if ( ( $file_extension == 'mp3' ) || ( $file_extension ) == 'MP3' )
						$source['mp3'] = $slide['mp3_url'];
				}
				if ( isset( $slide['ogg_url'] ) && !empty( $slide['ogg_url'] ) ) {
					$file_extension = substr( $slide['ogg_url'], strrpos( $slide['ogg_url'], '.' ) + 1 );
					if ( ( $file_extension == 'ogg' ) || ( $file_extension ) == 'OGG' )
						$source['ogg'] = $slide['ogg_url'];
				}
				if ( empty( $source ) )
					continue;
				$attachment_id = $slide['poster'];
				if ( !empty( $attachment_id ) ) {
					$poster = wp_get_attachment_image_src( $attachment_id, $size );
					$poster = $poster[0];
				}
				$uid    = 'player_' . mt_rand();
				$poster = 'poster="' . $poster . '"';
				$output .= '<audio class="audio" ' . $poster . ' controls id="' . $uid . '" >';
				foreach ( $source as $type => $source_url ) {
					$output .= "<source src='{$source_url}' type='audio/{$type}' />";
				}
				$output .= '</audio>';
				if ( $output )
					$slideshow .= "<li class='project_slide slide-type-self-audio'><div>{$output}</div></li>";
				break;
			case 'audio':
				$audio_url = $slide['audio_url'];
				if ( empty( $audio_url ) )
					continue;
				$output = '';
				$output = $wp_embed->run_shortcode( "[embed]" . trim( $audio_url ) . "[/embed]" );
				if ( $output )
					$slideshow .= "<li class='project_slide slide-type-audio'><div class='portfolio-responsive-media'>{$output}</div></li>";
				break;
			}
		endforeach;
		extract( $current_post );
		if ( empty( $slideshow ) ):
			$full_image = wp_get_attachment_image_src( get_post_thumbnail_id( $the_id ), 'full' );
		$full_image = $full_image[0];
		$slideshow .= "<li class='project_slide'><div><img src='{$full_image}' alt='' /></div></li>";
		endif;
		
		$project_position = get_post_meta( $the_id, 'desc_position', true ) ? get_post_meta( $the_id, 'desc_position', true ) : 'right';
		
		/*Add by Sentient*/
		$sentientlink = get_permalink( $the_id );
		
		$html .= "<div id='ajax_project_{$the_id}' class='ajax_project clearfix project_position_{$project_position}' data-project_id='{$the_id}'>";
		$html .= "<div class='project_media'>";
		
		/*Added by Sentient*/
		if($sentient_make_it_gallery){
			$html .= "<div class='project_flexslider sentient_project_flexslider_gallery'>";
			$html .= $slideshow;
		} else {
			$html .= "<div class='project_flexslider'>";
			$html .= "<ul class='project_slides'>";
			$html .= $slideshow;
			$html .= "</ul>";
		}

		$html .= "</div>";
		$html .= "</div>";
		$html .= "<div class='project_description'>";
		/*Add by Sentient*/
		$html .= "<h2 class='title'><a href='{$sentientlink}'>{$title}</a></h2>";
		$html .= $content;
		$html .= "</div>";
		$html .= "</div>";
		endwhile;
		endif;
		wp_reset_query();
		if ( $html )
			return $html;
	}

}

new AjaxPortfolio();