jQuery(document).ready(function ($) {

	$('#ajp_shortcode_html').on('display', function () {

		var el = $(this),

			overlay = el.prev(),

			btnSubmit = $('#ajp_submit'),

			btnCancel = $('#ajp_cancel'),

			opts = el.find('select, input[type="text"]'),

			params = '';

		overlay.fadeIn(400);

		el.fadeIn(400);

		btnCancel.on('click', function () {

			overlay.fadeOut(400);

			el.fadeOut(400);

			return false;

		});

		btnSubmit.off('click');

		btnSubmit.on('click', function () {

			var params = '';

			opts.each(function (index, element) {

				var value = $(this).val(),

					multiple = $.isArray(value),

					name = $(this).attr('name');

				if (value) {

					name = name.replace('ajp_', '');

					value = multiple ? value.join() : value;

					params = params + name + '="' + value + '" ';

				}

			});

			var shortcode = '[ajax_portfolio ' + params + ']';

			console.log(shortcode);

			if(window.tinyMCE) {

				/* get the TinyMCE version to account for API diffs */

				var tmce_ver=window.tinyMCE.majorVersion;

				if (tmce_ver>="4") {

					window.tinyMCE.execCommand('mceInsertContent', false, shortcode);

				} else {

					window.tinyMCE.execInstanceCommand(window.tinyMCE.activeEditor.id, 'mceInsertContent', false, shortcode);

				}

			}

			overlay.fadeOut(400);

			el.fadeOut(400);

			return false;

		});

	});

});

(function () {

	tinymce.create('tinymce.plugins.ajp', {

		init: function (ed, url) {

			ed.addButton('ajp', {

				title: 'Ajax Portfolio',

				image: url + '../../../images/shortcode.png',

				onclick: function () {

					jQuery('#ajp_shortcode_html').trigger('display');

				}

			});

		},

		createControl: function (n, cm) {

			return null;

		},

		getInfo: function () {

			return {

				longname: 'Ajax Portfolio Button',

				author: 'WP Themers',

				authorurl: 'http://wpthemers.net',

				infourl: 'http://wiki.moxiecode.com/index.php/TinyMCE:Plugins/example',

				version: "0.1"

			};

		}

	});

	tinymce.PluginManager.add('ajp', tinymce.plugins.ajp);

})();