
(function ($, window, document, undefined) {
	"use strict";
	var pluginName = "ajaxPortfolio",
		defaults = {
			propertyName: "value"
		};

	function Plugin(element, options) {
		this.element = $(element);
		this.settings = $.extend({}, defaults, options);
		this.init();
	}
	Plugin.prototype = {
		init: function () {
			var obj = this;
			this.grid = this.element.find('.portfolio-grid-container'),
			this.items = this.grid.children();
			if (this.items.length < 1) return false; //If no items was found then exit
			this.ajaxDiv = this.element.find('div.ajax-container'),
			this.ajaxFrame = '#portfolio-grid-frame',
			this.filter = this.element.find('.sort_by_cat'),
			this.loader = this.element.find('.portfolio-loader'),
			this.triggers = this.items.find('.project-load'),
			this.ajaxControls = this.ajaxDiv.find('.ajax-controls'),
			this.closeBtn = this.ajaxControls.find('.close-ajax-container'),
			this.nextBtn = this.ajaxControls.find('.next-ajax-container'),
			this.prevBtn = this.ajaxControls.find('.prev-ajax-container'),
			this.pagination = this.element.find('.portfolio-pagination'),
			this.api = {},
			this.id = null,
			this.win = $(window),
			this.current = 0,
			this.breakpointT = 979,
			this.breakpointP = 767,
			this.columns = this.grid.data('columns'),
			this.real_col = this.columns;
			this.loader.fadeIn();
			if (this.items.length == 1) {
				this.nextBtn.remove();
				this.prevBtn.remove();
			}
			this.grid.waitForImages(function () {
				obj.animate_custom();
				//obj.triggers.overlayer();
				obj.loader.fadeOut();
				obj.set_width();
				obj.relayout();
				obj.bind_handler();
				if(obj.element.hasClass('pagination-infinite')) {
					obj.implement_infinite_scroll();
				}
				$(window).trigger('portfolioLoaded');
			});
		},
		animate_custom: function(){
			var obj = this;
			if(this.grid.data('effect') == 'effect-none')
				return false;
			
			$(window).on('scroll portfolioLoaded', function(){
				var animation_delay = 0.0;
				if($('body').hasClass('ajax-portfolio-loading')) {
					return false;
				}
				var itemsToAnimate = obj.items.not('.portfolio-animated').withinViewportBottom({bottom: -50});
				itemsToAnimate.each(function(){
					if( $(this).hasClass('portfolio-animated') ) {
						return;
					}
					var item = $(this).find('> div'),
						effect = obj.grid.data('effect');
					$(this).addClass('portfolio-animated');
					item.css({
						'-moz-animation-delay' : animation_delay + 's',
						'-webkit-animation-delay' : animation_delay + 's',
						'animation-delay' : animation_delay + 's',
					}).addClass('portfolio-animate ' + effect);
					animation_delay += 0.1;
				});
			});
		},
		relayout: function () {
			if (this.grid.hasClass('.isotope'))
				this.grid.isotope('layout');
			else {
				this.grid.isotope().fadeTo(500, 1);
				this.grid.isotope( function(){
					$(window).trigger('portfolioLoaded');
				});
			}
		},
		implement_infinite_scroll: function () {
			if (!this.pagination.length) {
				return false;
			}
			var obj = this; // Temp instance of this object
			this.pagination.hide();
			this.tempDiv = $('<div/>', {
				class: 'temp-results'
			}).appendTo(obj.element);
			this.paginationLinks = this.pagination.find('a').addClass('unloaded');
			this.loadMoreDiv = $('<div/>', {
				class: 'load-more-wrap'
			}).appendTo(obj.element);
			this.loadMoreTrigger = $('<a/>', {
				class: 'load-more',
				href: '#',
				html: 'Loading'
			}).appendTo(obj.loadMoreDiv);
			$(window).on('scroll portfolioLoaded', function(){
				if(obj.loadMoreTrigger.is(":within-viewport")) {
					if ($('body').hasClass('ajax-portfolio-loading')) {
						return false;
					}
					obj.infinite_scroll_handler();
				}
			});
		},
		infinite_scroll_handler: function () {
			var obj = this; // Temp instance of this object
			this.paginationTrigger = this.pagination.find('a.unloaded').first().removeClass('unloaded');
			if (this.paginationTrigger.length) {
				var paginationTriggerLink = this.paginationTrigger.attr('href') + ' ' + obj.ajaxFrame;
				$('body').addClass('ajax-portfolio-loading');
				this.tempDiv.load(paginationTriggerLink, function () {
					obj.newEntries = obj.tempDiv.find('.portfolio-entry');
					obj.grid.append(obj.newEntries);
					obj.tempDiv.empty();
					obj.infinite_scroll_callback();
				});
				if (this.paginationTrigger.is(":last-child")) {
					//this.loadMoreTrigger.text('No More Posts');
					this.loadMoreDiv.fadeOut();
				}
			}
		},
		infinite_scroll_callback: function () {
			var obj = this; // Temp instance of this object
			this.items = this.grid.children();
			this.grid.waitForImages(function(){
				obj.triggers = obj.items.find('.project-load');
				obj.triggers.on('click', function () {
					var clicked = $(this),
						clickedParent = clicked.parent();
					obj.current = clickedParent.index();
					if (clicked.hasClass('active'))
						return false;
					obj.close_project();
					obj.triggers.removeClass('active');
					clicked.addClass('active');
					obj.grid.addClass('grid-open');
					obj.loader.fadeIn();
					obj.id = clicked.data('post-id');
					obj.load_project();
					return false;
				});
				//obj.newEntries.find('.project-load').overlayer();
				obj.set_width();
				obj.grid.isotope('appended', obj.newEntries);
				$('body').removeClass('ajax-portfolio-loading');
				$(window).trigger('portfolioLoaded');
			});
		},
		bind_handler: function () {
			var obj = this; // Temp instance of this object
			// Bind the filters with isotope
			
			
			obj.filter.find('.sort_label').click(function () {
				obj.filter.toggleClass('active');
			});
			obj.filter.find('a').click(function () {
				obj.triggers.removeClass('active');
				obj.grid.removeClass('grid-open');
				obj.close_project();
				obj.filter.find('a').removeClass('active_sort');
				$(this).addClass('active_sort');
				var selector = $(this).attr('data-filter');
				obj.grid.isotope({
					filter: selector
				});
				var label = $(this).text();
				obj.filter.find('.sort_label').text(label).end().toggleClass('active');
				return false;
			});
			obj.triggers.on('click', function () {
				var clicked = $(this),
					clickedParent = clicked.parent();
				obj.current = clickedParent.index();
				if (clicked.hasClass('active'))
					return false;
				obj.close_project();
				obj.triggers.removeClass('active');
				clicked.addClass('active');
				obj.grid.addClass('grid-open');
				obj.loader.fadeIn();
				obj.id = clicked.data('post-id');
				obj.load_project();
				return false;
			});
			
			obj.nextBtn.on('click', function () {
				if (obj.current == obj.triggers.length - 1) {
					obj.triggers.eq(0).trigger('click');
					return false;
				} else {
					obj.triggers.eq(obj.current + 1).trigger('click');
					return false;
				}
			});
			obj.prevBtn.on('click', function () {
				if (obj.current == 0) {
					obj.triggers.eq(obj.triggers.length - 1).trigger('click');
					return false;
				} else {
					obj.triggers.eq(obj.current - 1).trigger('click');
					return false;
				}
			});
			// Bind close button
			obj.closeBtn.on('click', function () {
				obj.close_project();
				obj.triggers.removeClass('active');
				obj.grid.removeClass('grid-open');
				return false;
			});
			// Calculate the widths amd relayout the grid when window size changes
			obj.win.on('throttledresize', function () {
				obj.set_width();
				obj.relayout();
			});
		},
		// Function to close the ajax container div
		close_project: function () {
			var obj = this, // Temp instance of this object
				video = obj.ajaxDiv.find('iframe'),
				src = video.attr('src'),
				project = obj.ajaxDiv.find('.ajax_project'),
				newH = project.actual('outerHeight');
			obj.ajaxDiv.find('video, audio').each(function () {
				this.player.pause()
			});
			video.attr('src', '');
			//video.attr( 'src', src );
			if (obj.ajaxDiv.height() > 0) {
				obj.ajaxDiv.css('height', newH + 'px').transition({
					height: 0,
					opacity: 0
				}, 400);
			} else {
				obj.ajaxDiv.transition({
					height: 0,
					opacity: 0
				}, 400);
			}
		},
		load_project: function () {
			var obj = this;
			$.post(ajp.ajaxurl, {
				action: 'get_portfolio',
				id: obj.id
			}, function (response) {
				obj.ajaxDiv.find('.ajax_project').remove();
				obj.ajaxDiv.append(response);
				obj.project_factory();
			});
		},
		project_factory: function () {
			var obj = this,
				project = this.ajaxDiv.find('.ajax_project'),
				slider = project.find('.project_flexslider'),
				gallery = project.find('.gallery-inner');
			/*obj.ajaxDiv.css({
				'display': 'block',
				opacity: 0,
				height:0
			});*/
			project.waitForImages(function () {
				$('html:not(:animated),body:not(:animated)').animate({
					scrollTop: obj.grid.offset().top
				}, 500);
				if (jQuery().mediaelementplayer)
					slider.find('audio, video').mediaelementplayer({
						videoWidth: '100%',
						videoHeight: '100%',
						audioWidth: '99.6%',
						audioHeight: 300,
						videoVolume: 'horizontal',
						flashName: ajp.flashName,
						success: function (mediaElement, domObject) { 
							 
							// add event listener
							mediaElement.addEventListener('canplay', function(e) {
								$(window).trigger('resize');
							}, false);
							 
							// call the play method
							 
						},						
					});
				if (gallery.length) {
					gallery.sGallery();
				}
				slider.flexslider({
					selector: ".project_slides > li",
					smoothHeight: true,
					prevText: "<i class='icon-left-open'></i>", /*Changed by Sentient*/
					nextText: "<i class='icon-right-open'></i>", /*Changed by Sentient*/
					animation: 'slide',
					animationLoop: false,
					video: true,
					controlNav: true,
					slideshow: false,
					before: function (slideshow) {
						var ul = slideshow.container ? slideshow.container : '';
						if (ul.length)
							ul.parent().removeClass('animating-height');
					},
					after: function (slideshow) {
						var index = slideshow.currentSlide,
							ul = slideshow.container ? slideshow.container : '';
						if (ul.length) {
							var isgal = ul.find('> li').eq(index).find(' > div ').hasClass('gallery-block');
							if (isgal)
								ul.parent().addClass('animating-height');
						}
					},
					start: function (slideshow) {
						var index = slideshow.currentSlide,
							ul = slideshow.container ? slideshow.container : '';
						if (ul.length) {
							var isgal = ul.find('> li').eq(index).find(' > div ').hasClass('gallery-block');
							if (isgal)
								ul.parent().addClass('animating-height');
						}
						
						$('.project_flexslider li img').show();
						
					}
				});
				obj.loader.fadeOut(function () {
					var newH = project.actual('outerHeight');
					obj.ajaxDiv.transition({
						opacity: 1,
						height: newH
					}, 400, function () {
						obj.ajaxDiv.css({
							height: 'auto'
						});
						$(window).trigger('resize');
					});
				});
			});
			
			$(".sentient-gallery-slideshow.sentient-gallery-slideshow-play").each(function() {
				$(this).flexslider({
					animation: "fade",
					slideshow: false,
					controlNav: "thumbnails",
					directionNav: true, 
					pauseOnAction: false,			
					start: function(slider){
						$('.flex-control-nav.flex-control-thumbs li img').mouseover(function(){
							 var activeSlide = 'false';
							 if ($(this).hasClass('flex-active')){  
								activeSlide = 'true';                       
							 }
							 if (activeSlide == 'false'){
							  $(this).trigger("click"); 
							 }
							 $(this).parent().find("i").addClass("icon-plus-gallery-hover");
						 });

						$('.flex-control-nav.flex-control-thumbs li').mouseover(function(){
							$(this).find("i").addClass("icon-plus-gallery-hover");
						 }).mouseout(function(){
							$(this).find("i").removeClass("icon-plus-gallery-hover");  	
						 });					 
					}		
				});
			});	

			
			$(".sentient-gallery-slideshow.sentient-gallery-slideshow-play .flex-control-nav.flex-control-thumbs li").mouseover(function() {
				$(this).addClass("sentient-gallery-slideshow-thumbnail-hover");	
			  }).mouseout(function(){
				$(this).removeClass("sentient-gallery-slideshow-thumbnail-hover");	
			});	
			
			$(".sentient-gallery-slideshow.sentient-gallery-slideshow-play .flex-direction-nav .flex-prev ").each(function() {	
				$(this).append( "<i class='icon-left-open'></i>" );
			});
			
			$(".sentient-gallery-slideshow.sentient-gallery-slideshow-play .flex-direction-nav .flex-next").each(function() {	
				$(this).append( "<i class='icon-right-open'></i>" );
			});
		
			$(".sentient-social-shortcode-container").mouseover(function() {
				$(this).addClass("sentient-social-shortcode-container-hover");	
				$(this).find("i").addClass("icon-social-hover");
				$(this).find(".sentient-header-top-popup-container").addClass("sentient-header-top-popup-container-show");		
			  }).mouseout(function(){
				$(this).removeClass("sentient-social-shortcode-container-hover");
				$(this).find("i").removeClass("icon-social-hover");
				$(this).find(".sentient-header-top-popup-container").removeClass("sentient-header-top-popup-container-show");	
			});			
		
			$(".sentient-social-shortcode-style-two-container").first().addClass("sentient-social-shortcode-style-two-first");
			$(".sentient-social-shortcode-style-two-container").last().addClass("sentient-social-shortcode-style-two-last");
			
			$('#portfolio-filter').on( 'click', 'button', function() {
			  var filterValue = $(this).attr('data-filter');
			  var filterContainerValue = $("#portfolio-grid-frame");
				filterContainerValue.isotope({
					filter: filterValue
				});
		
			});
		
			$(".sentient-gallery-slideshow.sentient-gallery-slideshow-play .flex-control-nav.flex-control-thumbs li").each(function() {
				var getSrc = $(this).find("img").attr('src');
				var getTitle = $(this).parent().parent().find("ul.slides li[data-thumb$='" + getSrc + "']").find("img").attr('alt');
				/*var getTitle = $(this).parent().parent().parent().parent().find("ul.slides img[src$='" + getSrc + "']").attr('alt');*/
				/*var getTitle = $(this).parent().parent().find("ul.slides img[src$='" + getSrc + "']").attr('alt');*/
				
				if(getTitle != ''){
					$(this).append( "<div class='sentient-header-top-popup-container animated'><div class='sentient-header-top-popup'>" + getTitle + "</div><div class='sentient-header-search-pointer-main'><div class='sentient-header-search-pointer'>▴</div></div></div>" );
					$(this).find("img").wrap("<div class='gallery-thumbnail-wrapper'></div>");
				}
			});
		
			$(".project_slides li.item").mouseover(function() {
				$(this).addClass("sentient-portfolio-four-col-thumb-show");	
			  }).mouseout(function(){
				$(this).removeClass("sentient-portfolio-four-col-thumb-show");	
			});	
	
			setTimeout(
			  function() 
			  {
				window.vc_js();
					
			  }, 3000);		
	
			$( window ).resize(function() {
				$(".sentient-gallery-slideshow .gallery-item").each(function() {
					var currentheight = $(this).parent().height();

					var thisULMax = $(this).height();
					$(this).parent().css({ "height": thisULMax + "px"});
				});		
				
			});			
		
		},
		set_width: function () {
			var gridW = this.grid.width(),
				winW = this.win.width();
			if (winW > this.breakpointP && winW <= this.breakpointT)
				this.real_col = 2;
			else if (winW <= this.breakpointP)
				this.real_col = 1;
			else
				this.real_col = this.columns;
			this.items.outerWidth(Math.floor(gridW / this.real_col));
		}		
		
	};
	$.fn[pluginName] = function (options) {
		return this.each(function () {
			if (!$.data(this, "plugin_" + pluginName)) {
				$.data(this, "plugin_" + pluginName, new Plugin(this, options));
			}
		});
	};
})(jQuery, window, document);
jQuery(document).ready(function ($) {
	$('.portfolio-grid').ajaxPortfolio();
});