<?php

/**

 * Registers the post type.

 */

register_post_type('gravityfields', array(

	'public' => false,

	'publicly_queryable' => false,

	'show_ui' => true,

	'show_in_menu' => false,

	'query_var' => false,

	'rewrite' => false,

	'capability_type' => 'post',

	'has_archive' => true,

	'hierarchical' => false,

	'supports' => array(

		'slug'

	),

	'labels' => array(

		'name' => __('Fields', 'gf'),

		'singular_name' => __('Container', 'gf'),

		'add_new' => __('Add New', 'gf'),

		'add_new_item' => __('Add New Container', 'gf'),

		'edit_item' => __('Edit Container', 'gf'),

		'new_item' => __('New Container', 'gf'),

		'all_items' => __('Containers', 'gf'),

		'view_item' => __('View Container', 'gf'),

		'search_items' => __('Search Containers', 'gf'),

		'not_found' => __('No Containers found', 'gf'),

		'not_found_in_trash' => __('No Containers found in Trash', 'gf'),

		'parent_item_colon' => __('', 'gf'),

		'menu_name' => __('Gravity Fields', 'gf')

	)

));

/**

 * The default title and editor are disabled, because the editor is too big and the title depends on it when qTranslate is on.

 * Because of this, when saving the container, the title and description are replaced.

 * 

 * This function does also do caching so that all info about all fields is in the options table.

 * 

 * @param int $post_id the ID of the post.

 */

add_action('save_post', 'gf_save_gravityfields', 12);

function gf_save_gravityfields($post_id) {

	global $wpdb;

	if (get_post_type($post_id) != 'gravityfields') {

		return;

	}

	$title   = get_post_meta($post_id, 'gf_title', true);

	$content = get_post_meta($post_id, 'gf_description', true);

	# Prevent recursion

	remove_action('save_post', 'gf_save_gravityfields', 12);

	# Update the post

	wp_update_post(array(

		'ID' => $post_id,

		'post_title' => $title,

		'post_content' => $content

	));

	# Now that the post is updated, fetch all fields and cache 'em

	$containers = array();

	$raw        = get_posts(array(

		'post_type' => 'gravityfields',

		'posts_per_page' => -1

	));

	foreach ($raw as $container) {

		$meta     = array();

		$raw_meta = $wpdb->get_results("SELECT meta_key, meta_value FROM $wpdb->postmeta WHERE post_id=$container->ID");

		foreach ($raw_meta as $m) {

			$meta[$m->meta_key] = maybe_unserialize($m->meta_value);

		}

		$containers[$container->ID] = array(

			'post' => $container,

			'meta' => $meta

		);

	}

	# Save everything in an option

	update_option('gf_containers', $containers);

}

/**

 * Changes the columns of the table with fields.

 * 

 * @param string[] $columns The previous columns, will be ignored.

 * @return string[]

 * 

 * @since 1.0

 */

add_filter('manage_edit-gravityfields_columns', 'gf_edit_gravityfields_columns');

function gf_edit_gravityfields_columns($columns) {

	$columns = array(

		'cb' => '<input type="checkbox" />',

		'title' => __('Title'),

		'containers' => __('Types', 'gf'),

		'fields_count' => __('Fields', 'gf')

	);

	return $columns;

}

add_action('manage_gravityfields_posts_custom_column', 'gf_manage_gravityfields_columns', 10, 2);

function gf_manage_gravityfields_columns($column, $post_id) {

	global $post;

	$containers = get_option('gf_containers');

	foreach ($containers as $c) {

		if ($c['post']->ID == $post_id) {

			$container = $c;

			break;

		}

	}

	switch ($column) {

		case 'containers':

			$text = array();

			if (get_post_meta($post_id, 'gf_options_page', true)) {

				$text[] = __('Options Page', 'gf');

			}

			if (get_post_meta($post_id, 'gf_postmeta_box', true)) {

				$text[] = __('Post Meta', 'gf');

			}

			if (get_post_meta($post_id, 'gf_termsmeta', true)) {

				$text[] = __('Term Meta', 'gf');

			}

			if (get_post_meta($post_id, 'gf_usermeta', true)) {

				$text[] = __('User Meta', 'gf');

			}

			if (get_post_meta($post_id, 'gf_widget', true)) {

				$text[] = __('Widget', 'gf');

			}

			echo empty($text) ? __('None', 'gf') : implode(', ', $text);

			break;

		case 'fields_count':

			echo count(get_post_meta($post_id, 'fields', true));

			break;

	}

}

# Modify actions - remove quick edit and add export

add_filter('post_row_actions', 'remove_quick_edit', 10, 2);

function remove_quick_edit($actions) {

	global $post;

	if ($post->post_type != 'gravityfields' || !isset($actions['edit'])) {

		return $actions;

	}

	$export_link = admin_url('edit.php?post_type=gravityfields&page=gf-export&export_container=' . $post->ID);

	# Add export link

	$actions     = array(

		'edit' => $actions['edit'],

		'export-link' => '<a href="' . esc_attr($export_link) . '">' . __('Export to PHP', 'gf') . '</a>',

		'trash' => $actions['trash']

	);

	return $actions;

}

/**

 * When a container is updated, it's message should not be "Post Published".

 *

 * @param mixed[] $messages The current group of messages.

 * @return mixed[]

 */

add_filter('post_updated_messages', 'gf_change_updated_message_gravityfields');

function gf_change_updated_message_gravityfields($messages) {

	if (!isset($_GET['post']))

		return $messages;

	$p = get_post($_GET['post']);

	if ($p->post_type != 'gravityfields') {

		return $messages;

	}

	$messages['post'][6] = __('Container saved.', 'uf');

	return $messages;

}



register_post_type( 'gravityposttypes', array(

	'public'             => false,

	'publicly_queryable' => false,

	'show_ui'            => true, 

	'query_var'          => false,

	'rewrite'            => false,

	'capability_type'    => 'post',

	'has_archive'        => true, 

	'hierarchical'       => false,

	'supports'           => array( 'slug' ),

	'show_in_menu'       => false, 

	'labels'             => array(

		'name'               => __( 'Post Types', 'gf' ),

		'singular_name'      => __( 'Post Type', 'gf' ),

		'add_new'            => __( 'Add New', 'gf' ),

		'add_new_item'       => __( 'Add New Post Type', 'gf' ),

		'edit_item'          => __( 'Edit Post Type', 'gf' ),

		'new_item'           => __( 'New Post Type', 'gf' ),

		'all_items'          => __( 'Post Types', 'gf' ),

		'view_item'          => __( 'View Post Type', 'gf' ),

		'search_items'       => __( 'Search Post Types', 'gf' ),

		'not_found'          => __( 'No Post Types found', 'gf' ),

		'not_found_in_trash' => __( 'No Post Types found in Trash', 'gf' ),

		'parent_item_colon'  => __( '', 'gf' ),

		'menu_name'          => __( 'Post Types', 'gf' )

	)

) );

/**

 * The default title and editor are disabled, because the editor is too big and the title depends on it when qTranslate is on.

 * Because of this, when saving the container, the title and description are replaced.

 * 

 * This function does also do caching so that all info about all fields is in the options table.

 * 

 * @param int $post_id the ID of the post.

 */

add_action('save_post', 'gf_save_gravityposttypes', 12);

function gf_save_gravityposttypes($post_id) {

	global $wpdb;

	if (get_post_type($post_id) != 'gravityposttypes') {

		return;

	}

	$title   = get_post_meta($post_id, 'gf_cpt_label', true);

	$content = get_post_meta($post_id, 'gf_cpt_description', true);

	# Prevent recursion

	remove_action('save_post', 'gf_save_gravityposttypes', 12);

	# Update the post

	wp_update_post(array(

		'ID' => $post_id,

		'post_title' => $title,

		'post_content' => $content

	));

	# Now that the post is updated, fetch all fields and cache 'em

	$containers = array();

	$raw        = get_posts(array(

		'post_type' => 'gravityposttypes',

		'posts_per_page' => -1

	));

	foreach ($raw as $container) {

		$meta     = array();

		$raw_meta = $wpdb->get_results("SELECT meta_key, meta_value FROM $wpdb->postmeta WHERE post_id=$container->ID");

		foreach ($raw_meta as $m) {

			$meta[$m->meta_key] = maybe_unserialize($m->meta_value);

		}

		$containers[$container->ID] = array(

			'post' => $container,

			'meta' => $meta

		);

	}

	# Save everything in an option

	update_option('gf_cpt_containers', $containers);

}



# Modify actions - remove quick edit and add export

add_filter('post_row_actions', 'remove_quick_edit_gravityposttypes', 10, 2);

function remove_quick_edit_gravityposttypes($actions) {

	global $post;

	if ($post->post_type != 'gravityposttypes' || !isset($actions['edit'])) {

		return $actions;

	}

	$actions     = array(

		'edit' => $actions['edit'],

		'trash' => $actions['trash']

	);

	return $actions;

}



register_post_type( 'gravitytaxonomies', array(

	'public'             => false,

	'publicly_queryable' => false,

	'show_ui'            => true, 

	'query_var'          => false,

	'rewrite'            => false,

	'capability_type'    => 'post',

	'has_archive'        => true, 

	'hierarchical'       => false,

	'supports'           => array( 'slug', 'title' ),

	'show_in_menu'       => false, 

	'labels'             => array(

		'name'               => __( 'Taxonomies', 'gf' ),

		'singular_name'      => __( 'Taxonomy', 'gf' ),

		'add_new'            => __( 'Add New', 'gf' ),

		'add_new_item'       => __( 'Add New Taxonomy', 'gf' ),

		'edit_item'          => __( 'Edit Taxonomy', 'gf' ),

		'new_item'           => __( 'New Taxonomy', 'gf' ),

		'all_items'          => __( 'Taxonomies', 'gf' ),

		'view_item'          => __( 'View Taxonomy', 'gf' ),

		'search_items'       => __( 'Search Taxonomies', 'gf' ),

		'not_found'          => __( 'No Taxonomies found', 'gf' ),

		'not_found_in_trash' => __( 'No Taxonomies found in Trash', 'gf' ),

		'parent_item_colon'  => __( '', 'gf' ),

		'menu_name'          => __( 'Taxonomies', 'gf' )

	)

) );



# Add page to options menu

function admin_menu_gravityfields(){

	add_utility_page( __('Gravity Framework', 'gf'), __('Gravity', 'gf'), 'manage_options', 'edit.php?post_type=gravityfields', '', 'dashicons-editor-kitchensink');

	add_submenu_page( 'edit.php?post_type=gravityfields', __('Fields', 'gf'), __('Fields', 'gf'), 'manage_options', 'edit.php?post_type=gravityfields' );

	add_submenu_page( 'edit.php?post_type=gravityfields', __('Post Types', 'gf'), __('Post Types', 'gf'), 'manage_options', 'edit.php?post_type=gravityposttypes' );

	add_submenu_page( 'edit.php?post_type=gravityfields', __('Taxonomies', 'gf'), __('Taxonomies', 'gf'), 'manage_options', 'edit.php?post_type=gravitytaxonomies' );

}

add_action( 'admin_menu', 'admin_menu_gravityfields' );