<?php 

function number_option($from = 0, $to = 100, $steps = 1) {

	$html = '';

	for ($i = $from; $i <= $to; $i += $steps) {

		$html .= "<option value='{$i}'>{$i}</option>";

	}

	return $html;

}

$terms = get_terms( 'portfolio_category');

$count = count($terms); 

?>

<div id="ajp_overlay"></div>

<div id="ajp_shortcode_html">

	<form id="ajp_shortcode_form" method="post">

		<div class="ajp_header">

			Ajax Portfolio Grid

			<a id="ajp_cancel" class="ajp_button"><i class="dashicons dashicons-no"></i></a>

		</div>

		<div class="ajp_body">

			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_categories"><?php _e( 'Portfolio Categories', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'Select the categories that will be displayed.', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					<?php if($count) : ?>

					<select id="ajp_categories" name="ajp_categories" multiple="multiple">

					<?php foreach ( $terms as $term) : ?>

						<option value="<?php echo $term->term_id; ?>"><?php echo $term->name; ?></option>

					<?php endforeach; ?>

					</select>

					<?php endif;?>

				</div>

			</div>

			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_columns"><?php _e( 'Columns', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'Select the number of columns.', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					<select id="ajp_columns" name="ajp_columns">

						<?php echo number_option(1,12); ?>

					</select>

				</div>

			</div>



			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_animation"><?php _e( 'Animation', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'The animtion effect on scroll.', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					<select id="ajp_animation" name="ajp_animation">

						<option value="1"><?php _e( 'Fade In', 'ajax_portfolio' ); ?></option>

						<option value="2"><?php _e( 'Slide In', 'ajax_portfolio' ); ?></option>

						<option value="3"><?php _e( 'Zoom In', 'ajax_portfolio' ); ?></option>

						<option value="none"><?php _e( 'No Effect', 'ajax_portfolio' ); ?></option>

					</select>

				</div>

			</div>



			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_thumb_size"><?php _e( 'Thumbnail Dimension', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'Select the size of the thumbnails.', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					<?php $image_sizes = get_intermediate_image_sizes(); ?>

					<select id="ajp_thumb_size" name="ajp_thumb_size">

					<?php foreach ($image_sizes as $size_name) : ?>

					<option value="<?php echo $size_name ?>"><?php echo $size_name ?></option>

					<?php endforeach; ?>

					<option value="full"><?php _e( 'Full', 'ajax_portfolio' ); ?></option>

					<option value="custom"><?php _e( 'Custom Dimension', 'ajax_portfolio' ); ?></option>

					</select>				

				</div>

			</div>



			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_thumb_width"><?php _e( 'Custom Thumbnail Width', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'Enter the custom width of thumbnail.', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					  <input type="text" id="ajp_thumb_width" name="ajp_thumb_width" value="400" >

				</div>

			</div>



			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_thumb_height"><?php _e( 'Custom Thumbnail Height', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'Enter the custom height of thumbnail.', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					  <input type="text" id="ajp_thumb_height" name="ajp_thumb_height" value="300" >

				</div>

			</div>



			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_padding"><?php _e( 'Thumbnail Spacing', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'Padding between thumbnails.', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					<select id="ajp_padding" name="ajp_padding">

						<?php echo number_option(0,100); ?>

					</select>

				</div>

			</div>



			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_items"><?php _e( 'Items', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'No. of items to load.', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					<select id="ajp_items" name="ajp_items">

						<option value="-1">All</option>

						<?php echo number_option(1,100); ?>

					</select>

				</div>

			</div>



			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_sort"><?php _e( 'Sortable Buttons', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'Enble dynamic sorting?', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					<select id="ajp_sort" name="ajp_sort">

						<option value="no"><?php _e( 'No', 'ajax_portfolio' ); ?></option>

						<option value="yes"><?php _e( 'Yes', 'ajax_portfolio' ); ?></option>

					</select>

				</div>

			</div>



			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_prevnext"><?php _e( 'Prev/Next Buttons', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'Show the previous/next paging buttons?', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					<select id="ajp_prevnext" name="ajp_prevnext">

						<option value="no"><?php _e( 'No', 'ajax_portfolio' ); ?></option>

						<option value="yes"><?php _e( 'Yes', 'ajax_portfolio' ); ?></option>

					</select>

				</div>

			</div>



			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_paginate"><?php _e( 'Pagination', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'Display pagination type?', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					<select id="ajp_paginate" name="ajp_paginate">

						<option value="no"><?php _e( 'No', 'ajax_portfolio' ); ?></option>

						<option value="normal"><?php _e( 'Normal', 'ajax_portfolio' ); ?></option>

						<option value="infinite"><?php _e( 'Inifinite Loading', 'ajax_portfolio' ); ?></option>

					</select>

				</div>

			</div>



			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_caption"><?php _e( 'Captions', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'Show title as caption?', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					<select id="ajp_caption" name="ajp_caption">

						<option value="no"><?php _e( 'No', 'ajax_portfolio' ); ?></option>

						<option value="yes"><?php _e( 'Yes', 'ajax_portfolio' ); ?></option>

				   </select>

				</div>

			</div>

			

			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_orderby"><?php _e( 'Order By', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'Sort retrieved entries', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					<select id="ajp_orderby" name="ajp_orderby">

						<option value="none"><?php _e( 'None', 'ajax_portfolio' ); ?></option>

						<option value="ID"><?php _e( 'ID', 'ajax_portfolio' ); ?></option>

						<option value="title"><?php _e( 'Title', 'ajax_portfolio' ); ?></option>

						<option value="date"><?php _e( 'Date', 'ajax_portfolio' ); ?></option>

						<option value="modified"><?php _e( 'Last Modified Date', 'ajax_portfolio' ); ?></option>

						<option value="menu_order"><?php _e( 'Menu Order', 'ajax_portfolio' ); ?></option>

					</select>

				</div>

			</div>



			<div class="ajp_option">

				<div class="ajp_description">

					<label for="ajp_order"><?php _e( 'Order', 'ajax_portfolio' ); ?></label>

					<span><?php _e( 'Selected order by method', 'ajax_portfolio' ); ?></span>

				</div>

				<div class="ajp_field">

					<select id="ajp_order" name="ajp_order">

						<option value="DESC"><?php _e( 'Descending Order', 'ajax_portfolio' ); ?></option>

						<option value="ASC"><?php _e( 'Ascending Order', 'ajax_portfolio' ); ?></option>

					</select>

				</div>

			</div>



		</div>

		<div class="ajp_footer">

			<button id="ajp_submit" class="button button-primary button-large" type="submit"><?php _e( 'Insert Shortcode', 'ajax_portfolio' ); ?></button>

		</div>

	</form>

</div>