<?php
/*
	Plugin Name: Sentient Mega Menu
	Plugin URL: http://themes.profteamsolutions.com/sentient/
	Description: A little plugin to add attributes to WordPress menu
	Version: 0.1
	Author: ProfTeam
	Author URI: http:www.profteamsolutions.com
	Contributors: ProfTeam
	Text Domain: rc_scm
	Domain Path: languages
*/


class rc_sweet_custom_menu {

	/*--------------------------------------------*
	 * Constructor
	 *--------------------------------------------*/

	/**
	 * Initializes the plugin by setting localization, filters, and administration functions.
	 */

	function __construct() {
		/* add custom menu fields to menu*/
		add_filter( 'wp_setup_nav_menu_item', array( $this, 'rc_scm_add_custom_nav_fields' ) );
		add_filter( 'wp_setup_nav_menu_item', array( $this, 'rc_scm_add_custom_nav_fields_two' ) );		
		
		add_action( 'wp_update_nav_menu_item', array( $this, 'rc_scm_update_custom_nav_fields'), 10, 3 );		
		add_action( 'wp_update_nav_menu_item', array( $this, 'rc_scm_update_custom_nav_fields_two'), 10, 3 );	
		
		/* edit menu walker */
		add_filter( 'wp_edit_nav_menu_walker', array( $this, 'rc_scm_edit_walker'), 10, 2 );				
	} /* end constructor */

	function rc_scm_add_custom_nav_fields( $menu_item ) {
		$menu_item->subtitle = get_post_meta( $menu_item->ID, '_menu_item_subtitle', true );
		return $menu_item;
	}
	
	function rc_scm_add_custom_nav_fields_two( $menu_item ) {
		$menu_item->subtitletwo = get_post_meta( $menu_item->ID, '_menu_item_subtitletwo', true );
		return $menu_item;
	}	
	
	function rc_scm_update_custom_nav_fields( $menu_id, $menu_item_db_id, $args ) {
		/* Check if element is properly sent*/
		if(isset ($_REQUEST['menu-item-subtitle'])){
			if ( is_array( $_REQUEST['menu-item-subtitle']) ) {
				$subtitle_value = $_REQUEST['menu-item-subtitle'][$menu_item_db_id];
				update_post_meta( $menu_item_db_id, '_menu_item_subtitle', $subtitle_value );
			}
		}
	}
	
	function rc_scm_update_custom_nav_fields_two( $menu_id, $menu_item_db_id, $args ) {
		/* Check if element is properly sent*/
		if(isset ($_REQUEST['menu-item-subtitletwo'])){		
			if ( is_array( $_REQUEST['menu-item-subtitletwo']) ) {
				$subtitle_value = $_REQUEST['menu-item-subtitletwo'][$menu_item_db_id];
				update_post_meta( $menu_item_db_id, '_menu_item_subtitletwo', $subtitle_value );
			}
		}
	}	
	
	function rc_scm_edit_walker($walker,$menu_id) {
		return 'Walker_Nav_Menu_Edit_Custom';
	}
	


}

	include_once( 'edit_custom_walker.php' );
	include_once( 'custom_walker.php' );



/* instantiate plugin's class*/
$GLOBALS['sweet_custom_menu'] = new rc_sweet_custom_menu();


?>