<?php
/*
Template Name: Template - Blog Right Sidebar
*/
?>


<!-- Get Page Header
================================================== -->
<?php get_header(); ?>



<!-- Page Title Section
================================================== -->
<?php

	global $prof_default;
	$sentient_breadcrumb_text = __("You are here:  ","sentient");
	if(of_get_option('select_breadcrumb_position',$prof_default) == 'Right') {$breadcrumbPosition = '';} else {$breadcrumbPosition = 'breadcrumb-left';}
?>


<?php if(of_get_option('select_breadcrumb',$prof_default) == 'On'){ ?>
	<div class="homepage-container-design  homepage-container-design-top sentient-page-title-container">
		<div class="homepage-container-design-inner">
			<span class="sentient-page-title-text <?php echo $breadcrumbPosition; ?>"><?php echo get_the_title(); ?></span>
			<span class="sentient-page-breadcrumb-text <?php echo $breadcrumbPosition; ?>"><span class="sentient-page-breadcrumb-text-colored"><?php echo esc_attr($sentient_breadcrumb_text); ?></span><?php sentient_bread_crumbs(); ?></span>
		</div>
	</div>
<?php } ?>


<!-- Page Blog Body Start
================================================== -->
<div class="page-main-container page-main-container-blog">
	 <div class="middle-container blog-middle-container blog-right-sidebar">
	 	<div class="sentient-blog-date-separator"></div>
		
		<!-- Loop Started
		================================================== -->		
		
	 	<?php if(have_posts()) : while(have_posts()) : the_post(); ?>				
			<div class="sidebar-container blog-sidebar">
				<?php get_sidebar(); ?>
			</div>			
			<div class="main-blog">

				<?php
					if ($post->post_content == ""){
					
					} else {
				?>
					<div>
						<?php the_content(); ?>
					</div>
				<?php } ?>
			
				<div class="main-blog-for-sidebar cbp-so-section">			
				<?php
					$ProfPortfolioColCounter=1;
					$ProfPortfolioColIteration=1;
					$ProfPortfolioColNextIteration=0;
					$ProfPortfolioColIterationCompare = 1;	
				
					$temp = $wp_query;
					$wp_query= null;
					$wp_query = new WP_Query();
					
					
					if(get_post_meta(get_the_ID(), 'Category for Blogs Templates Only', true) != ''){
						$getpagecategory = get_post_meta(get_the_ID(), 'Category for Blogs Templates Only', true);
						$wp_query->query('posts_per_page=6'.'&paged='. $paged .'&category_name='.$getpagecategory);
					} else {
						$wp_query->query('posts_per_page=6'.'&paged='.$paged);
					}
					/*$wp_query->query('posts_per_page=6'.'&paged='.$paged);*/
					while ($wp_query->have_posts()) : $wp_query->the_post();
				?>				
				<div <?php post_class(); ?>>
					<div class="sentient-blog-listing-circle-container">
						<div class="sentient-blog-listing-date-circle">
							<span class="sentient-blog-listing-circle-day"><?php echo get_the_time('M'); ?></span>							
							<span class="sentient-blog-listing-circle-month"><?php echo get_the_time('j'); ?></span>
						</div>
						<div class="sentient-blog-listing-thumb-circle">
							<?php echo get_avatar( get_the_author_meta( 'ID' ), 70 ); ?>
						</div>
					</div>
					<div class="prof-blog-col-thumb-box">
						
						<!-- Standard Post Format
						================================================== -->							
						
						<?php
							if ( get_post_format() == false && has_post_thumbnail()) {									
						?>
							<div class="blog-modern-left-box-thumb">								
								<a href="<?php echo esc_url(the_permalink()); ?>">
									<?php the_post_thumbnail('full'); ?>
									<i class="icon-pencil"></i>
								</a>								
							</div>
						<?php } ?>
												
						<!-- Video Post Format
						================================================== -->								
						<?php
							if ( has_post_format( 'video' ) && get_post_meta(get_the_ID(), 'Post Video URL', true) != '') {
						?>
							<div class="sentient-blog-listing-video-container">
								<iframe width="100%" height="450px" src="<?php echo esc_url(get_post_meta(get_the_ID(), 'Post Video URL', true)); ?>"></iframe>
							</div>
						<?php } ?>

						<!-- Gallery Post Format
						================================================== -->							
						<?php
							if ( has_post_format( 'gallery' ) && get_post_meta(get_the_ID(), 'Post Gallery Shortcode', true)!= '') { ?>
								<div class="sentient-blog-listing-gallery-container">
									<?php
										$newstring = 'gallery putin="blogs" ';
										$oldstring = get_post_meta(get_the_ID(), 'Post Gallery Shortcode', true);
										$gallerycode = str_replace("gallery",$newstring,$oldstring); 	
										echo  do_shortcode($gallerycode) . '<i class="icon-camera"></i>';
									?>
								</div>
						<?php } ?>
						
						<!-- Audio Post Format
						================================================== -->								
						<?php
							if ( has_post_format( 'audio' ) && get_post_meta(get_the_ID(), 'Post Audio Shortcode', true)!= '') { ?>
								<div class="sentient-blog-listing-audio-container">								
									<?php echo do_shortcode(get_post_meta(get_the_ID(), 'Post Audio Shortcode', true)) ;  ?>
								</div>
						<?php } ?>														
						
						<!-- Chat Post Format
						================================================== -->								
						<?php
							if ( has_post_format( 'chat' )) { ?>
								<div class="sentient-blog-listing-chat-container">
									<div class="sentient-blog-chat-quote-left"><i class="fa-quote-left"></i></div>
									<div class="sentient-blog-chat-quote-text">
										<a href="<?php echo esc_url(the_permalink()); ?>">„<?php echo strip_shortcodes(wp_trim_words( get_the_content(), 35 )); ?>“</a>
										<div class="sentient-blog-chat-quote-person"><?php echo '- ' . esc_attr(get_post_meta(get_the_ID(), 'Chat Person Name', true)); ?></div>
									</div>
									<div class="sentient-blog-chat-quote-right"><i class="fa-quote-right"></i></div>
								</div>
						<?php } ?>

						<!-- Post Body Begin
						================================================== -->								
						<?php if ( !has_post_format( 'chat' )) {?>
						<div class="blog-modern-left-box-content">
							<?php 
								$all = __(' Comments', 'sentient');
								$one = __(' Comment', 'sentient');
							?>	
							<span class="prof-blog-col-title">
								<a href="<?php echo esc_url(the_permalink()); ?>"><?php the_title(); ?></a>
								<?php if ( has_post_format( 'link' )) {  ?>
									<span class="prof-blog-post-title-link"><a href="<?php echo esc_url(get_post_meta(get_the_ID(), 'Link Post URL Value', true)); ?>"><?php echo esc_url(get_post_meta(get_the_ID(), 'Link Post URL Value', true)); ?></a></span>
								<?php } ?>
							</span>
							
							<?php if (of_get_option('blog_functional',$prof_default) == 'On'){ ?>
								<div class="prof-blog-col-icon-container">
									<span class="blog-modern-thumb-text-date"><?php echo get_the_time('j') . ' ' . get_the_time('M') . ', ' . get_the_time('Y'); ?></span><span class="sentient-blog-normal-date-seperator">.</span>
									<span class="blog-modern-thumb-text-comments"><a href="<?php echo esc_url(get_comments_link(get_the_ID())); ?>"><?php comments_number( '0 ' . $all, '1 ' . $one, '% ' . $all); ?></a></span><span class="sentient-blog-normal-date-seperator">.</span>								
									<span class="blog-modern-thumb-text-cat"><?php 
										$categories = get_the_category(get_the_ID());
										$output = '';
										foreach ( $categories as $category ) {
											$output .= '<a href="' . esc_url(get_category_link( $category->term_id )) . '" >' . esc_attr($category->name) . '</a>' . ', ';
										}
										echo trim($output, ', ');
									?></span><span class="sentient-blog-normal-date-seperator">.</span>								
									<span class="blog-modern-thumb-text-author"><?php echo  _e('Posted By: ','sentient')?><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ) )); ?>"><?php esc_attr(the_author_meta( 'display_name' )); ?></a></span>
								</div>														
							<?php } else { ?>
								<div class="prof-blog-col-icon-container">
									<span class="blog-modern-thumb-text-date"><?php echo get_the_time('j') . ' ' . get_the_time('M') . ', ' . get_the_time('Y'); ?></span><span class="sentient-blog-normal-date-seperator">.</span>
									<span class="blog-modern-thumb-text-comments"><?php comments_number( '0 ' . $all, '1 ' . $one, '% ' . $all); ?></span><span class="sentient-blog-normal-date-seperator">.</span>								
									<span class="blog-modern-thumb-text-cat"><?php 
										$categories = get_the_category(get_the_ID());
										$output = '';
										foreach ( $categories as $category ) {
											$output .= '' . esc_attr($category->name) . '' . ', ';
										}
										echo trim($output, ', ');
									?></span><span class="sentient-blog-normal-date-seperator">.</span>								
									<span class="blog-modern-thumb-text-author"><?php echo  _e('Posted By: ','sentient')?><?php esc_attr(the_author_meta( 'display_name' )); ?></span>
								</div>														
							<?php } ?>
							
							<div class="blog-modern-left-box-content-text">
								<?php echo strip_shortcodes(wp_trim_words( get_the_content(), 100 )); ?>
							</div>
							<div class="sentient-read-more-button">
								<a class="sentient-button sentient-button-blog-listing" href="<?php esc_url(the_permalink()); ?>"><?php _e( "Read More" , 'sentient') ?></a>
							</div>
						</div>
						<!-- Post Body End
						================================================== -->								
						<?php } ?>
					</div>					
				</div>				
				<?php endwhile; ?>
				</div>
				
				<!-- Pagination Begin
				================================================== -->						
				<div class="portfolio-pagination">
				<?php
					global $wp_query;

					$big = 999999999;

					echo paginate_links( array(
						'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
						'format' => '?paged=%#%',
						'current' => max( 1, get_query_var('paged') ),
						'total' => $wp_query->max_num_pages
					) );
				?>
				</div>
				<!-- Pagination End
				================================================== -->				
				
				
				<!-- Pagination Number Begin
				================================================== -->						
				<?php
					$sentient_pagination = '';
					$sentient_page_text = __("Page","sentient");
					$sentient_of_text = __("of","sentient");
					$total = $wp_query->max_num_pages;

					if ( $total > 1 ) {
						if ( !$current_page = get_query_var('paged') ){$current_page = 1;}
						$sentient_pagination = '<span class="sentient-number-of-pages">' . $sentient_page_text . ' ' . $current_page . ' ' . $sentient_of_text . ' ' . $total . '</span>';
					} else {
						$sentient_pagination = '';
					}
					
					echo $sentient_pagination;
				?>

				<!-- Pagination Number End
				================================================== -->	
				
				<?php $wp_query = null; $wp_query = $temp;?>				
			</div>
		<?php endwhile; endif; ?>				
	 </div>
</div>
<!-- Page Blog Full Body End
================================================== -->



<!-- Get Page Footer
================================================== -->
<?php get_footer(); ?>