
<!-- Comments Section Begin
================================================== -->	



<!-- Please, Do not delete these lines
================================================== -->	
<?php
	if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
		die ('Please do not load this page directly. Thanks!');

	if ( post_password_required() ) { ?>
		<p class="no-comments"><?php _e('This post is password protected. Enter the password to view comments.', 'Prof'); ?></p>
	<?php
		return;
	}
	
	$commentvalue = false;
?>


<!-- Check if have Comments then Begin
================================================== -->	
<?php if ( have_comments() ) : ?>

	<div class="comment_list" id="comments">
		<h5><?php comments_number(__('No Comments', 'Prof'), __('One Comment', 'Prof'), __('% Comments', 'Prof'));?></h5>

		<!-- Comment list -->
		<ol>
			<?php wp_list_comments('type=comment&callback=sentient_comment&avatar_size=70'); ?>
		</ol>
		<!-- Comment list::END -->
		
		<div class="clearfix">
		    <div class="float-left"><?php previous_comments_link(); ?></div>
		    <div class="float-right"><?php next_comments_link(); ?></div>
		</div>
	</div>

<?php else : /*this is displayed if there are no comments so far*/ ?>

	<?php if ( comments_open() ) : ?>
		<!-- If comments are open, but there are no comments. -->
	 <?php else : // comments are closed ?>
		<!-- If comments are closed. -->
		<div class="sentient_vc_separator sentient-inside-seperator">
			<h4><?php _e('Comments are closed', 'Prof'); ?></h4>	
			<span class="sentient_vc_sep_holder">
				<span class="sentient_vc_sep_line"></span>
			</span>
		</div>	
	<?php endif; ?>

<?php endif; ?>


<!-- Check if have Comments Open then Begin
================================================== -->	
<?php if ( comments_open() ) : ?>

				
		<!-- Comment Section -->	
		<div id="respond" class="comments_section">
			<?php
				$nocomment = __('No Comments Yet', 'sentient');
				$onecomment = __('1 Comment', 'sentient');
				$morecomments = __('% Comments', 'sentient');
			?>
			<div class="sentient_vc_separator sentient-inside-seperator">
				<h4><?php comments_number( $nocomment , $onecomment , $morecomments ); ?></h4>	
				<span class="sentient_vc_sep_holder">
					<span class="sentient_vc_sep_line"></span>
				</span>
			</div>			

			<div class="commentlistcontainer">
				<?php wp_list_comments('type=comment&callback=sentient_comment&avatar_size=60'); ?>
			</div>
			<div class="comments-pagination">
				<?php paginate_comments_links(); ?>
			</div>				
			
			<div class="sentient_vc_separator sentient-inside-seperator">
				<h4><?php comment_form_title(__('Leave a Comment', 'sentient'), __('Leave a Comment', 'sentient')); ?></h4>	
				<span class="sentient_vc_sep_holder">
					<span class="sentient_vc_sep_line"></span>
				</span>
			</div>							
			
			<p class="cancel-comment-reply"><?php cancel_comment_reply_link(); ?></p>

			<?php if ( get_option('comment_registration') && !is_user_logged_in() ) : ?>
			<p>You must be <a href="<?php echo esc_url(wp_login_url( get_permalink() )); ?>">logged in</a> to post a comment.</p>
			<?php else : ?>
			
			<form action="<?php echo get_option('siteurl'); ?>/wp-comments-post.php" method="post" id="commentform">
				
				<?php if ( is_user_logged_in() ) : ?>

				<p><?php _e('Logged in as', 'Prof'); ?> <a href="<?php echo esc_url(get_option('siteurl')); ?>/wp-admin/profile.php"><?php echo esc_attr($user_identity); ?></a>. <a href="<?php echo esc_url(wp_logout_url(get_permalink())); ?>" title="Log out of this account"><?php _e('Log out &raquo;', 'Prof'); ?></a></p>
		
				<div id="comment-textarea">
					<p class="comment-input-message">
						<textarea name="comment" id="comment" rows="8" class="Prof_input"></textarea>			
					</p>
				</div>
				
				<div id="comment-submit">				
					<p class="comment-input-submit"><input name="submit" type="submit" id="submit" value="<?php _e('SEND MESSAGE', 'sentient'); ?>" class="sm_button" /></p>
					<?php comment_id_fields(); ?>
					<?php do_action('comment_form', $post->ID); ?>					
				</div>
				
				<?php else : ?>
				
				<div id="comment-input">
					<p class="comment-input-field">
						<input placeholder="Name*" id="author" class="Prof_input" name="author" type="text" value=""/>
					</p>
					<p class="comment-input-field">	
						<input placeholder="Email*" id="email" class="Prof_input" name="email" type="email" value=""/>
					</p>
					<p class="comment-input-field">		
						<input placeholder="Subject*" id="url" class="Prof_input" name="url" type="text" value="" size="30"/>
					</p>
				</div>
				<div id="comment-textarea">
					<p class="comment-input-message">		
						<textarea placeholder="Your Message*" id="comment" rows="8" class="Prof_input" name="comment"></textarea>
					</p>
				</div>
				
				<div id="comment-submit">
					<p class="comment-input-submit"><input name="submit" type="submit" id="submit" value="<?php _e('SEND MESSAGE', 'sentient'); ?>" class="sm_button"></p>	
					<?php comment_id_fields(); ?>
					<?php do_action('comment_form', $post->ID); ?>	
				</div>	
				<?php endif; ?>
								
			</form>
			
			<?php endif; ?>
			
		</div>								
		<!-- Comment Section::END -->


<?php endif; ?>


<?php if($commentvalue){comment_form(); wp_enqueue_script( 'comment-reply' );} ?>


<!-- Comments Section End
================================================== -->	

