<?php


/*------------------------------------------------------*/
/* Sentient functions.php Started */
/*------------------------------------------------------*/


/*------------------------------------------------------
Sentient, After Theme Setup - Started
-------------------------------------------------------*/

add_action('after_setup_theme', 'sentient_setup');

function sentient_setup(){

	/* Add theme-supported features here. */
	add_theme_support( 'post-thumbnails' ); 	
	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'custom-header');
	add_theme_support( 'post-formats', array('video', 'gallery','link','audio','chat' ) );
	add_theme_support('woocommerce');
	
	
	/* Add custom actions here. */
	add_action('wp_enqueue_scripts', 'sentient_load_theme_fonts', 30);
	add_action('wp_enqueue_scripts', 'sentient_load_theme_scripts' );
	add_action('wp_enqueue_scripts', 'sentient_load_theme_styles');	
	add_action('widgets_init', 'sentient_recent_comments_registration');	
	add_action('widgets_init', 'sentient_recent_posts_registration');
	add_action('init', 'sentient_register_menus' );
	add_action('init', 'sentient_register_cpt_team' );
	add_action( 'add_meta_boxes', 'sentient_add_sidebar_metabox' );  
	add_action( 'save_post', 'sentient_save_sidebar_postdata' );  
	add_action( 'init', 'sentient_add_page_cats' );	
	add_action( 'tgmpa_register', 'sentient_register_required_plugins' );	
	
	
	/* Add custom filters here. */	
	add_filter('wp_list_categories','categories_postcount_filter');
	add_filter( 'get_search_form', 'sentient_search_form' );
	add_filter('add_to_cart_fragments', 'woocommerce_header_add_to_cart_fragment');
	add_filter( 'woocommerce_breadcrumb_defaults', 'sentient_breadcrumb_delimiter' );
	add_filter( 'loop_shop_per_page', create_function( '$cols', 'return 9;' ), 20 );
	add_filter('woocommerce_get_catalog_ordering_args', 'sentient_woocommerce_catalog_orderby');	
	add_filter( 'wp_generate_attachment_metadata', 'sentient_retina_support_attachment_meta', 10, 2 );
	add_filter( 'delete_attachment', 'sentient_delete_retina_support_images' );
	add_filter( 'request', 'sentient_request_filter' );
	add_filter( 'excerpt_length', 'sentient_custom_excerpt_length', 999 );
	add_filter('excerpt_more', 'sentient_excerpt_more_string');
	add_filter('widget_text', 'do_shortcode');
	add_filter('pre_get_posts', 'limit_archive_posts');
	
	/* Add ceditor Styles here. */	
	add_editor_style();
	
	/* Add Sentient Content Width. */
	if ( ! isset( $content_width ) ){ $content_width = 1200;}	

	/* Add Custom Background. */
	add_theme_support( 'custom-background');
	
	/* Load Text Domain. */
	load_theme_textdomain('sentient', get_template_directory() . '/languages');
	
}


/*------------------------------------------------------
Sentient, After Theme Setup - End
-------------------------------------------------------*/



/*------------------------------------------------------*/
/* TGM_Plugin_Activation class Started*/
/*------------------------------------------------------*/

require_once ('admin/tgm/class-tgm-plugin-activation.php');

function sentient_register_required_plugins() {

	/**
	 * Array of plugin arrays. Required keys are name and slug.
	 * If the source is NOT from the .org repo, then source is also required.
	 */
	 
	$sentient_layerslider_path = get_template_directory() . '/admin/lib/plugins/layersliderwp.zip';
	$sentient_vc_path = get_template_directory() . '/admin/lib/plugins/visual-composer.zip';
	$sentient_portfolio_path = get_template_directory() . '/admin/lib/plugins/ajax-portfolio.zip';
	$sentient_megamenu_path = get_template_directory() . '/admin/lib/plugins/sentient-mega-menu.zip';	
	
	$plugins = array(

		// This is an example of how to include a plugin pre-packaged with a theme	
		array(
			'name'     				=> 'Layerslider', // The plugin name
			'slug'     				=> 'LayerSlider', // The plugin slug (typically the folder name)
			'source'   				=> $sentient_layerslider_path, // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '4.6.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		
		array(
			'name'     				=> 'Visual Composer', // The plugin name
			'slug'     				=> 'js_composer', // The plugin slug (typically the folder name)
			'source'   				=> $sentient_vc_path, // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '3.6.3', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),

		array(
			'name'     				=> 'Ajax Portfolio', // The plugin name
			'slug'     				=> 'ajax-portfolio', // The plugin slug (typically the folder name)
			'source'   				=> $sentient_portfolio_path, // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '2.0', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		
		array(
			'name'     				=> 'Sentient Mega Menu', // The plugin name
			'slug'     				=> 'sentient-mega-menu', // The plugin slug (typically the folder name)
			'source'   				=> $sentient_megamenu_path, // The plugin source
			'required' 				=> true, // If false, the plugin is only 'recommended' instead of required
			'version' 				=> '0.1', // E.g. 1.0.0. If set, the active plugin must be this version or higher, otherwise a notice is presented
			'force_activation' 		=> false, // If true, plugin is activated upon theme activation and cannot be deactivated until theme switch
			'force_deactivation' 	=> false, // If true, plugin is deactivated upon theme switch, useful for theme-specific plugins
			'external_url' 			=> '', // If set, overrides default API URL and points to an external URL
		),
		
        array(
            'name'      => 'contact-form-7',
            'slug'      => 'contact-form-7',
            'required'  => false,
        ),
		
        array(
            'name'      => 'woocommerce',
            'slug'      => 'woocommerce',
            'required'  => false,
        ),		
	);
	
	
	$theme_text_domain = 'sentient';

	/**
	 * Array of configuration settings. Amend each line as needed.
	 * If you want the default strings to be available under your own theme domain,
	 * leave the strings uncommented.
	 * Some of the strings are added into a sprintf, so see the comments at the
	 * end of each line for what each argument will be.
	 */
	$config = array(
		'domain'       		=> $theme_text_domain,         	// Text domain - likely want to be the same as your theme.
		'default_path' 		=> '',                         	// Default absolute path to pre-packaged plugins
		'parent_menu_slug' 	=> 'themes.php', 				// Default parent menu slug
		'parent_url_slug' 	=> 'themes.php', 				// Default parent URL slug
		'menu'         		=> 'install-required-plugins', 	// Menu slug
		'has_notices'      	=> true,                       // Show admin notices or not
		'is_automatic'    	=> false,					   	// Automatically activate plugins after installation or not
		'message' 			=> '',							// Message to output right before the plugins table
		'strings'      		=> array(
			'page_title'                       			=> __( 'Install Required Plugins', 'sentient'),
			'menu_title'                       			=> __( 'Install Plugins', 'sentient' ),
			'installing'                       			=> __( 'Installing Plugin: %s', 'sentient' ), // %1$s = plugin name
			'oops'                             			=> __( 'Something went wrong with the plugin API.', 'sentient' ),
			'notice_can_install_required'     			=> _n_noop( 'This theme requires the following plugin: %1$s.', 'This theme requires the following plugins: %1$s.' ), // %1$s = plugin name(s)
			'notice_can_install_recommended'			=> _n_noop( 'This theme recommends the following plugin: %1$s.', 'This theme recommends the following plugins: %1$s.' ), // %1$s = plugin name(s)
			'notice_cannot_install'  					=> _n_noop( 'Sorry, but you do not have the correct permissions to install the %s plugin. Contact the administrator of this site for help on getting the plugin installed.', 'Sorry, but you do not have the correct permissions to install the %s plugins. Contact the administrator of this site for help on getting the plugins installed.' ), // %1$s = plugin name(s)
			'notice_can_activate_required'    			=> _n_noop( 'The following required plugin is currently inactive: %1$s.', 'The following required plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
			'notice_can_activate_recommended'			=> _n_noop( 'The following recommended plugin is currently inactive: %1$s.', 'The following recommended plugins are currently inactive: %1$s.' ), // %1$s = plugin name(s)
			'notice_cannot_activate' 					=> _n_noop( 'Sorry, but you do not have the correct permissions to activate the %s plugin. Contact the administrator of this site for help on getting the plugin activated.', 'Sorry, but you do not have the correct permissions to activate the %s plugins. Contact the administrator of this site for help on getting the plugins activated.' ), // %1$s = plugin name(s)
			'notice_ask_to_update' 						=> _n_noop( 'The following plugin needs to be updated to its latest version to ensure maximum compatibility with this theme: %1$s.', 'The following plugins need to be updated to their latest version to ensure maximum compatibility with this theme: %1$s.' ), // %1$s = plugin name(s)
			'notice_cannot_update' 						=> _n_noop( 'Sorry, but you do not have the correct permissions to update the %s plugin. Contact the administrator of this site for help on getting the plugin updated.', 'Sorry, but you do not have the correct permissions to update the %s plugins. Contact the administrator of this site for help on getting the plugins updated.' ), // %1$s = plugin name(s)
			'install_link' 					  			=> _n_noop( 'Begin installing plugin', 'Begin installing plugins' ),
			'activate_link' 				  			=> _n_noop( 'Activate installed plugin', 'Activate installed plugins' ),
			'return'                           			=> __( 'Return to Required Plugins Installer', 'sentient' ),
			'plugin_activated'                 			=> __( 'Plugin activated successfully.', 'sentient' ),
			'complete' 									=> __( 'All plugins installed and activated successfully. %s', 'sentient' ), // %1$s = dashboard link
			'nag_type'									=> 'updated' // Determines admin notice type - can only be 'updated' or 'error'
		)
	);

	tgmpa( $plugins, $config );

}

/**************************************/
/*TGM_Plugin_Activation class End*/
/**************************************/



/***************************************************/
/*Set Visual Composer as Theme Function - Started*/
/***************************************************/

if(function_exists('vc_set_as_theme')) vc_set_as_theme();

/***************************************************/
/*Set Visual Composer as Theme Function - End*/
/***************************************************/



/***************************************************/
/*Load Sentient Fonts - Started*/
/***************************************************/
function sentient_load_theme_fonts() {

	global $prof_default;
	$sentientProtocol = is_ssl() ? 'https' : 'http';
	
	if(of_get_option('select_font',$prof_default) == 'Open+Sans'){
		wp_enqueue_style( 'siteFont', "$sentientProtocol://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,800italic,400,600,300,700,800,bold");		
	} else {
		wp_enqueue_style( 'siteFont', "$sentientProtocol://fonts.googleapis.com/css?family=" . of_get_option('select_font',$prof_default));		
	}
	
	if(of_get_option('menu_font',$prof_default) == 'Open+Sans'){
		wp_enqueue_style( 'menuFont', "$sentientProtocol://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,800italic,400,600,300,700,800,bold");		
	} elseif(of_get_option('menu_font',$prof_default) == 'Ubuntu+Condensed'){
		wp_enqueue_style( 'menuFont', "$sentientProtocol://fonts.googleapis.com/css?family=Ubuntu+Condensed");
	} else {
		wp_enqueue_style( 'menuFont', "$sentientProtocol://fonts.googleapis.com/css?family=" . of_get_option('menu_font',$prof_default));		
	}
	
	if(of_get_option('h1_font',$prof_default) == 'Open+Sans'){
		wp_enqueue_style( 'headingOneFont', "$sentientProtocol://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,800italic,400,600,300,700,800,bold");		
	} else {
		wp_enqueue_style( 'headingOneFont', "$sentientProtocol://fonts.googleapis.com/css?family=" . of_get_option('h1_font',$prof_default));		
	}
	
	if(of_get_option('h2_font',$prof_default) == 'Open+Sans'){
		wp_enqueue_style( 'headingTwoFont', "$sentientProtocol://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,800italic,400,600,300,700,800,bold");		
	} else {
		wp_enqueue_style( 'headingTwoFont', "$sentientProtocol://fonts.googleapis.com/css?family=" . of_get_option('h2_font',$prof_default));		
	}	
	
	if(of_get_option('h3_font',$prof_default) == 'Open+Sans'){
		wp_enqueue_style( 'headingThreeFont', "$sentientProtocol://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,800italic,400,600,300,700,800,bold");		
	} else {
		wp_enqueue_style( 'headingThreeFont', "$sentientProtocol://fonts.googleapis.com/css?family=" . of_get_option('h3_font',$prof_default));		
	}	
	
	if(of_get_option('h4_font',$prof_default) == 'Open+Sans'){
		wp_enqueue_style( 'headingFourFont', "$sentientProtocol://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,800italic,400,600,300,700,800,bold");		
	} else {
		wp_enqueue_style( 'headingFourFont', "$sentientProtocol://fonts.googleapis.com/css?family=" . of_get_option('h4_font',$prof_default));		
	}		
	
	if(of_get_option('h5_font',$prof_default) == 'Open+Sans'){
		wp_enqueue_style( 'headingFiveFont', "$sentientProtocol://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,800italic,400,600,300,700,800,bold");		
	} else {
		wp_enqueue_style( 'headingFiveFont', "$sentientProtocol://fonts.googleapis.com/css?family=" . of_get_option('h5_font',$prof_default));		
	}		
	
	if(of_get_option('h6_font',$prof_default) == 'Open+Sans'){
		wp_enqueue_style( 'headingSixFont', "$sentientProtocol://fonts.googleapis.com/css?family=Open+Sans:300italic,400italic,600italic,700italic,800italic,400,600,300,700,800,bold");		
	} else {
		wp_enqueue_style( 'headingSixFont', "$sentientProtocol://fonts.googleapis.com/css?family=" . of_get_option('h6_font',$prof_default));		
	}			
	
	
}

/***************************************************/
/*Load Sentient Fonts - End*/
/***************************************************/



/***************************************************/
/*Load Sentient Styles - Started*/
/***************************************************/
function sentient_load_theme_styles() {

	global $prof_default;
	
	wp_register_style('jquery-ui', get_template_directory_uri().'/styles/jquery-ui.css');
	wp_register_style('responsive', get_template_directory_uri().'/styles/responsive.css');
	wp_register_style('sentient-styles', get_template_directory_uri().'/sentient-styles.css');
	wp_register_style('sentient-icons', get_template_directory_uri().'/styles/sentient-icons.css');
	
	wp_register_style('sentient-bbpress', get_template_directory_uri().'/styles/sentient-bbpress.css');
	wp_register_style('sentient-custom', get_template_directory_uri().'/styles/sentient-custom.css');
	wp_register_style('sentient-layerslider', get_template_directory_uri().'/styles/sentient-layerslider.css');
	wp_register_style('sentient-menu', get_template_directory_uri().'/styles/sentient-menu.css');
	wp_register_style('sentient-transition', get_template_directory_uri().'/styles/sentient-transition.css');
	wp_register_style('sentient-woocommerce', get_template_directory_uri().'/styles/sentient-woocommerce.css');
	
	wp_register_style('style', get_stylesheet_uri());
	
	wp_enqueue_style( 'style');	
	wp_enqueue_style( 'jquery-ui');
	wp_enqueue_style( 'sentient-icons');	

	wp_enqueue_style( 'sentient-custom');	
	wp_enqueue_style( 'sentient-layerslider');	
	wp_enqueue_style( 'sentient-menu');	
	wp_enqueue_style( 'sentient-transition');
	
	if (class_exists('Woocommerce')) {
		wp_enqueue_style( 'sentient-woocommerce');
	}
	
	if (class_exists('bbPress')) {
		wp_enqueue_style('sentient-bbpress');	
	}
	
	if (of_get_option('select_responsive',$prof_default) == 'On') {
		wp_enqueue_style( 'responsive');
	}
	
	wp_enqueue_style( 'sentient-styles');
}

/***************************************************/
/*Load Sentient Styles - End*/
/***************************************************/



/***************************************************/
/*Load Sentient Scripts - Started*/
/***************************************************/
function sentient_load_theme_scripts() {
	global $is_IE;
	
	wp_enqueue_script('jquery');

	wp_enqueue_script('prof.common', get_template_directory_uri().'/js/prof.common.js',false,false,true);		
	wp_enqueue_script('prof.modified',get_template_directory_uri().'/js/prof.modified.js',false,false,true);	
	wp_enqueue_script('jquery.flexslider', get_template_directory_uri().'/js/jquery.flexslider.js',false,false,true);		
	wp_enqueue_script('modernizr.custom', get_template_directory_uri().'/js/modernizr.custom.js',false,false,true);
	wp_enqueue_script('classie', get_template_directory_uri().'/js/classie.js',false,false,true);
	wp_enqueue_script('jquery.visible', get_template_directory_uri().'/js/jquery.visible.js',false,false,true);
	wp_enqueue_script('lean-slider', get_template_directory_uri().'/js/lean-slider.js',false,false,true);
	wp_enqueue_script('numinate', get_template_directory_uri().'/js/numinate.js',false,false,true);
	wp_enqueue_script('isotope', get_template_directory_uri().'/js/isotope.js',false,false,true);	
	wp_enqueue_script('rotator', get_template_directory_uri().'/js/rotator.js',false,false,true);
	wp_enqueue_script('jquery.infinitescroll', get_template_directory_uri().'/js/jquery.infinitescroll.js',false,false,true);	
	wp_enqueue_script('retina', get_template_directory_uri().'/js/retina.js', '', '', true);		
	
	
	if (is_page_template ( 'portfolio-ajax.php' ) ) {
		wp_enqueue_script('js_composer_front', get_site_url() . '/wp-content/plugins/js_composer/assets/js/js_composer_front.js',false,false,true);		
	}	
	
	if (is_singular() || is_page_template ( 'blog-full.php' ) || is_page_template ( 'blog-left-sidebar.php' ) || is_page_template ( 'blog-right-sidebar.php' ) || is_home() || is_single() ) {
		wp_enqueue_script('jquery-cycle', get_template_directory_uri() . '/js/jquery.cycle.js',false,false,true);
		wp_enqueue_script('post-format-gallery', get_template_directory_uri() . '/js/prof.gallery.js',false,false,true);
	}	

	if ( $is_IE ) {
		wp_enqueue_script('html5','http://html5shim.googlecode.com/svn/trunk/html5.js',false,false,true);
	}

}

/***************************************************/
/*Load Sentient Scripts - End*/
/***************************************************/



/***************************************************/
/*Sentient Retina Functions - Started*/
/***************************************************/

/**
* Retina images
*
* This function is attached to the 'wp_generate_attachment_metadata' filter hook.
*/

function sentient_retina_support_attachment_meta( $metadata, $attachment_id ) {
	foreach ( $metadata as $key => $value ) {
		if ( is_array( $value ) ) {
			foreach ( $value as $image => $attr ) {
				if ( is_array( $attr ) )
					sentient_retina_support_create_images( get_attached_file( $attachment_id ), $attr['width'], $attr['height'], true );
			}
		}
	}

	return $metadata;
}


/**
 * Create retina-ready images
 *
 * Referenced via retina_support_attachment_meta().
 */
function sentient_retina_support_create_images( $file, $width, $height, $crop = false ) {
    if ( $width || $height ) {
        $resized_file = wp_get_image_editor( $file );
        if ( ! is_wp_error( $resized_file ) ) {
            $filename = $resized_file->generate_filename( $width . 'x' . $height . '@2x' );
 
            $resized_file->resize( $width * 2, $height * 2, $crop );
            $resized_file->save( $filename );
 
            $info = $resized_file->get_size();
 
            return array(
                'file' => wp_basename( $filename ),
                'width' => $info['width'],
                'height' => $info['height'],
            );
        }
    }
    return false;
}

/**
 * Delete retina-ready images
 *
 * This function is attached to the 'delete_attachment' filter hook.
 */
function sentient_delete_retina_support_images( $attachment_id ) {
    $meta = wp_get_attachment_metadata( $attachment_id );
    $upload_dir = wp_upload_dir();
	
	if(is_array($meta)){	
		$path = pathinfo( $meta['file'] );

		foreach ( $meta as $key => $value ) {
			if ( 'sizes' === $key ) {
				foreach ( $value as $sizes => $size ) {
					$original_filename = $upload_dir['basedir'] . '/' . $path['dirname'] . '/' . $size['file'];
					$retina_filename = substr_replace( $original_filename, '@2x.', strrpos( $original_filename, '.' ), strlen( '.' ) );
					if ( file_exists( $retina_filename ) )
						unlink( $retina_filename );
				}
			}
		}
	}
}
/***************************************************/
/*Sentient Retina Functions - End*/
/***************************************************/



/***************************************************/
/*Sentient General Array's that will be used - Started*/
/***************************************************/
$sentient_cat_arr = sentient_get_all_categories();
$sentient_yes_no_arr = array(__("Yes", "sentient") => "yes", __("No", "sentient") => "no");
$sentient_team_arr = array(__("Three per Row", "sentient") => "three", __("Four per Row", "sentient") => "four");
$sentient_button_arr = array(__("Make it as Theme Color on Hover", "sentient") => "liketheme", __("Make it with Opacity on Hover", "sentient") => "likeopacity");
$sentient_items_width = array(__("One Column", "sentient") => "1", __("Two Columns", "sentient") => "2", __("Three Columns", "sentient") => "3", __("Four Columns", "sentient") => "4", __("2/3 Columns", "sentient") => "twothree", __("1/3 Columns", "sentient") => "onethree");
$sentient_icons_align_arr = array(__("From Left to Right", "sentient") => "left", __("From Right to Left", "sentient") => "right");
$sentient_button_size = array( __("Large", "sentient") => "large", __("Medium", "sentient") => "medium", __("Small", "sentient") => "small");
$sentient_social_icon = array( __("dribbble", "sentient") => "dribbble", __("facebook", "sentient") => "facebook", __("twitter", "sentient") => "twitter", __("vimeo", "sentient") => "vimeo", __("flickr", "sentient") => "flickr", __("linkedin", "sentient") => "linkedin", __("google", "sentient") => "google");
$sentient_icon_styleone_arr = array(__("Note", "sentient") => "icon-note",
__("Logo", "sentient") => "icon-logo-db",
__("Music", "sentient") => "icon-music",
__("Search", "sentient") => "icon-search",
__("Flash Light", "sentient") => "icon-flashlight",
__("Mail", "sentient") => "icon-mail",
__("Heart", "sentient") => "icon-heart",
__("Empty Heart", "sentient") => "heart-empty",
__("Star", "sentient") => "icon-star",
__("Empty Star", "sentient") => "icon-star-empty",
__("User", "sentient") => "icon-user",
__("Users", "sentient") => "icon-users",
__("Add User", "sentient") => "user-add",
__("Video", "sentient") => "icon-video",
__("Picture", "sentient") => "icon-picture",
__("Camera", "sentient") => "icon-camera",
__("Layout", "sentient") => "icon-layout",
__("Menu", "sentient") => "icon-menu",
__("Check", "sentient") => "icon-check",
__("Cancel", "sentient") => "icon-cancel",
__("Plus", "sentient") => "icon-plus",
__("Minus", "sentient") => "icon-minus",
__("Help", "sentient") => "icon-help",
__("Info", "sentient") => "icon-info-circled",
__("Back in Time", "sentient") => "icon-back-in-time",
__("Back", "sentient") => "icon-back",
__("Home", "sentient") => "icon-home",
__("Link", "sentient") => "icon-link",
__("Attach", "sentient") => "icon-attach",
__("Lock", "sentient") => "icon-lock",
__("Eye", "sentient") => "icon-eye",
__("Tag", "sentient") => "icon-tag",
__("Bookmark", "sentient") => "icon-bookmark",
__("Flag", "sentient") => "icon-flag",
__("Thumbs up", "sentient") => "icon-thumbs-up",
__("Thumbs down", "sentient") => "icon-thumbs-down",
__("Download", "sentient") => "icon-download",
__("Upload", "sentient") => "icon-upload",
__("Reply", "sentient") => "icon-reply",
__("Forward", "sentient") => "icon-forward",
__("Quote", "sentient") => "icon-quote",
__("Code", "sentient") => "icon-code",
__("Export", "sentient") => "icon-export",
__("Pencil", "sentient") => "icon-pencil",
__("Feather", "sentient") => "icon-feather",
__("Print", "sentient") => "icon-print",
__("Retweet", "sentient") => "icon-retweet",
__("Keyboard", "sentient") => "icon-keyboard",
__("Comment", "sentient") => "icon-comment",
__("Chat", "sentient") => "icon-chat",
__("Bell", "sentient") => "icon-bell",
__("Attention", "sentient") => "icon-attention",
__("Alert", "sentient") => "icon-alert",
__("Address", "sentient") => "icon-address",
__("Location", "sentient") => "icon-location",
__("Map", "sentient") => "icon-map",
__("Direction", "sentient") => "icon-direction",
__("Compass", "sentient") => "icon-compass",
__("Cup", "sentient") => "icon-cup",
__("Trash", "sentient") => "icon-trash",
__("Document", "sentient") => "icon-doc",
__("Newspaper", "sentient") => "icon-newspaper",
__("Book", "sentient") => "icon-book",
__("Folder", "sentient") => "icon-folder",
__("Archive", "sentient") => "icon-archive",
__("Box", "sentient") => "icon-box",
__("Phone", "sentient") => "icon-phone",
__("Tools", "sentient") => "icon-tools",
__("Share", "sentient") => "icon-share",
__("Basket", "sentient") => "icon-basket",
__("Bag", "sentient") => "icon-bag",
__("Calendar", "sentient") => "icon-calendar",
__("Login", "sentient") => "icon-login",
__("Logout", "sentient") => "icon-logout",
__("Mic", "sentient") => "icon-mic",
__("Mute", "sentient") => "icon-mute",
__("Sound", "sentient") => "icon-sound",
__("Volume", "sentient") => "icon-volume",
__("Clock", "sentient") => "icon-clock",
__("Hour Glass", "sentient") => "icon-hourglass",
__("Lamp", "sentient") => "icon-lamp",
__("Light Down", "sentient") => "icon-light-down",
__("Light Up", "sentient") => "icon-light-up",
__("Resize Full", "sentient") => "icon-resize-full",
__("Resize Small", "sentient") => "icon-resize-small",
__("Pop up", "sentient") => "icon-popup",
__("Publish", "sentient") => "icon-publish",
__("Window", "sentient") => "icon-window",
__("Shuffle", "sentient") => "icon-shuffle",
__("Loop", "sentient") => "icon-loop",
__("Switch", "sentient") => "icon-switch",
__("Play", "sentient") => "icon-play",
__("Stop", "sentient") => "icon-stop",
__("Pause", "sentient") => "icon-pause",
__("Record", "sentient") => "icon-record",
__("Target", "sentient") => "icon-target",
__("Palette", "sentient") => "icon-palette",
__("Signal", "sentient") => "icon-signal",
__("Trophy", "sentient") => "icon-trophy",
__("Battery", "sentient") => "icon-battery",
__("Monitor", "sentient") => "icon-monitor",
__("Mobile", "sentient") => "icon-mobile",
__("Network", "sentient") => "icon-network",
__("Inbox", "sentient") => "icon-inbox",
__("Flash", "sentient") => "icon-flash",
__("Moon", "sentient") => "icon-moon",
__("Flight", "sentient") => "icon-flight",
__("Leaf", "sentient") => "icon-leaf",
__("Mouse", "sentient") => "icon-mouse",
__("Brush", "sentient") => "icon-brush",
__("Magnet", "sentient") => "icon-magnet",
__("Infinity", "sentient") => "icon-infinity",
__("Erase", "sentient") => "icon-erase",
__("Tape", "sentient") => "icon-tape",
__("Language", "sentient") => "icon-language",
__("Ticket", "sentient") => "icon-ticket",
__("Water", "sentient") => "icon-water",
__("Droplet", "sentient") => "icon-droplet",
__("Air", "sentient") => "icon-air",
__("Lifebuoy", "sentient") => "icon-lifebuoy",
__("Credit Card", "sentient") => "icon-credit-card",
__("Floppy", "sentient") => "icon-floppy",
__("Clipboard", "sentient") => "icon-clipboard",
__("Mega Phone", "sentient") => "icon-megaphone",
__("Database", "sentient") => "icon-database",
__("Drive", "sentient") => "icon-drive",
__("Bucket", "sentient") => "icon-bucket",
__("Cog", "sentient") => "icon-cog",
__("Doc Text", "sentient") => "icon-doc-text",
__("Key", "sentient") => "icon-key",
__("Rocket", "sentient") => "icon-rocket",
__("Gauge", "sentient") => "icon-gauge",
__("Suitcase", "sentient") => "icon-suitcase",
__("Traffic Cone", "sentient") => "icon-traffic-cone"
);


/***************************************************/
/*Sentient General Array's that will be used - End*/
/***************************************************/


/***************************************************/
/*Sentient Check if Empty Function - Started*/
/***************************************************/
function sentient_check_if_empty($val)
{
	$get_val=$val;
	if(empty($get_val)){
		return true;
	}
	else
	{
		return false;
	}
}
/***************************************************/
/*Sentient Check if Empty Function - End*/
/***************************************************/



/***************************************************/
/*Sentient Search Query Function - Started*/
/***************************************************/
if(!is_admin()){
    add_action('init', 'sentient_search_query_fix');
    function sentient_search_query_fix(){
        if(isset($_GET['s']) && $_GET['s']==''){
            $_GET['s']=' ';
        }
    }
}


function sentient_request_filter( $query_vars ) {
    if( isset( $_GET['s'] ) && empty( $_GET['s'] ) ) {
        $query_vars['s'] = " ";
    }
    return $query_vars;
}
/***************************************************/
/*Sentient Search Query Function - End*/
/***************************************************/



/***************************************************/
/*Sentient Add Post Thumbnails size - Started*/
/***************************************************/
	
	if ( function_exists( 'add_theme_support' ) ) {
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 800, 310, true );
		set_post_thumbnail_size( 777, 590, true );
		set_post_thumbnail_size( 777, 660, true );
		set_post_thumbnail_size( 1200, 420, true );
	}

	if ( function_exists( 'add_image_size' ) ) { 
		add_image_size( 'blog-normal-size', 370, 9999, true ); //(cropped)
		add_image_size( 'blog-slider-size', 9999, 155, true ); //(cropped)
		add_image_size( 'blog-normal-wide-size', 9999, 200, true ); //(cropped)
		add_image_size( 'blog-listing-page-size', 800, 310, true ); //(cropped)
		add_image_size( 'blog-listing-full-page-size', 1200, 310, true ); //(cropped)
		add_image_size( 'blog-ajax-size', 400, 250, true ); //(cropped)
		add_image_size( 'portfolio-small-slider', 777, 590, true ); //(cropped)
		add_image_size( 'portfolio-small-gallery', 777, 660, true ); //(cropped)
		add_image_size( 'portfolio-full-slider', 1200, 420, true ); //(cropped)
	}

/***************************************************/
/*Sentient Add Post Thumbnails sizes - End*/
/***************************************************/



/***************************************************/
/*Sentient Menu Options - Started */
/***************************************************/

function sentient_register_menus() {
  register_nav_menus(
    array(
      'header-menu' => __( 'Header Menu' , 'my-text-domain'),
      'extra-menu' => __( 'Extra Menu' , 'my-text-domain')
    )
  );
}

/***************************************************/
/*Sentient Menu Options - End */
/***************************************************/



/***************************************************/
/*Sentient Menu Fall Back Function - Started */
/***************************************************/
function sentient_menu_fall_back(){
	
	echo '<div id="menu" class="menu-sentient-container sentient-menu-default-regular-container"><ul>';
	wp_list_pages(
      array(
        'title_li'  => '',
      	'sort_column'=> 'menu_order',
      )
    );
    echo '</ul></div>';

}
/***************************************************/
/*Sentient Menu Fall Back Function - End */
/***************************************************/



/***************************************************/
/*Sentient excerpt string function - Started */
/***************************************************/

function sentient_excerpt_more_string( $more ) {
	return '...';
}

/***************************************************/
/*Sentient excerpt string function - End */
/***************************************************/



/***************************************************/
/*Sentient excerpt length Function - Started */
/***************************************************/

function sentient_custom_excerpt_length( $length ) {
	return 80;
}

/***************************************************/
/*Sentient excerpt length Function - End */
/***************************************************/



/***************************************************/
/*Sentient , Add Shortcodes to Visual Composer - Started */
/***************************************************/

/* Here we will check if the Visual Composer is activated */

if(function_exists('vc_map')){


	/*------------------------------------------------------
	Sentient Homepage Row Start - Shortcode
	-------------------------------------------------------*/

	function sentient_homepage_container($atts, $content = null) {
		
		extract(shortcode_atts(array('type' => '','repeat' => 'yes', 'background' => '', 'color' => '#ffffff' , 'bordertop' => 'no' , 'borderbottom' => 'no' , 'font' => '#666666' , 'paddingtop' => '40px' , 'paddingbottom' => '40px' , 'layernav' => 'no'), $atts));
		   		  
		if($layernav == 'yes'){$sentientLayerSlider = 'sentient-layerslider-numbers-container';}else{$sentientLayerSlider = '';}
		
		if($bordertop == 'yes'){$top = 'homepage-container-design-top';}else{$top = '';}
		
		if($borderbottom == 'yes'){$bottom = 'homepage-container-design-bottom';}else{$bottom = '';}
		
		if($repeat == 'yes'){$getrepeat = 'repeat'; $backcover = 'auto';}else{$getrepeat = 'no-repeat'; $backcover = 'cover';}
		
		$returnedvalue = '';
		
		if($type == 'yes'){
			$returnedvalue = '<div class="homepage-container-design '. $top .' '. $sentientLayerSlider . ' ' . $bottom .'" style="background:'. $color .'; color:'. $font .'; padding-top:'. $paddingtop .'; padding-bottom:'. $paddingbottom .';">
				<div class="homepage-container-design-inner">';
		}
		else
		{
			$getimageurlarray = wp_get_attachment_image_src( $background , 'full');
			if( $getimageurlarray ) {$getimageurl = $getimageurlarray[0];} else {$getimageurl = '';}
			$returnedvalue = '<div class="homepage-container-design '. $top .' '. $sentientLayerSlider . ' ' . $bottom .'" style="background-image:url('. $getimageurl .');color:'. $font .';background-repeat:'. $getrepeat .'; padding-top:'. $paddingtop .'; padding-bottom:'. $paddingbottom .'; background-size:'. $backcover .';">
				<div class="homepage-container-design-inner">';
		}

			return $returnedvalue;

	}
	add_shortcode('homepage_container', 'sentient_homepage_container');
	
	
	/*------------------------------------------------------
	Sentient Homepage Row Start - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Row Begin" , "sentient"),
	   "base" => "homepage_container",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Background Color?" , "sentient"),
			 "param_name" => "type",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("If you choose No it will put the background image." , "sentient")
		  ),
		  array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Background color" , "sentient"),
			 "param_name" => "color",
			 "value" => "#FFFFFF",
			 "description" => __("Please Choose Background color for your Row" , "sentient")
		  ),
		  array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Font color" , "sentient"),
			 "param_name" => "font",
			 "value" => "#787878",
			 "description" => __("Please Choose Font color for your Row" , "sentient")
		  ),
		  array(
			 "type" => "attach_image",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Background Image" , "sentient"),
			 "param_name" => "background",
			 "value" => "",
			 "description" => __("Please Choose Background Image for your Row" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Background Image Repeat" , "sentient"),
			 "param_name" => "repeat",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("Do you want to Repeat Background Image?" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Padding from Top" , "sentient"),
			 "param_name" => "paddingtop",
			 "value" => "40px",
			 "description" => __("Distance between row and content from top side" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Padding from Bottom" , "sentient"),
			 "param_name" => "paddingbottom",
			 "value" => "40px",
			 "description" => __("Distance between row and content from bottom side" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Border Top" , "sentient"),
			 "param_name" => "bordertop",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("Do you want to display border on the top of the row" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Border Bottom" , "sentient"),
			 "param_name" => "borderbottom",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("Do you want to display border on the bottom of the row" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Add Numbers navigation for LayerSlider?" , "sentient"),
			 "param_name" => "layernav",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("Do you want to replace the default LayerSlider navigation with Sentient ones?" , "sentient")
		  )

	   )
	) );



	/*------------------------------------------------------
	Sentient Homepage Row Wide Start - Shortcode
	-------------------------------------------------------*/
	function sentient_homepage_container_wide($atts, $content = null) {
		
		extract(shortcode_atts(array('type' => '','repeat' => 'yes', 'background' => '', 'color' => '#ffffff' , 'bordertop' => 'no' , 'borderbottom' => 'no' , 'font' => '#666666' , 'paddingtop' => '40px' , 'paddingbottom' => '40px', 'layernav' => 'no'), $atts));
		   
		if($layernav == 'yes'){$sentientLayerSlider = 'sentient-layerslider-numbers-container';}else{$sentientLayerSlider = '';}	   
		
		if($bordertop == 'yes'){$top = 'homepage-container-design-top';}else{$top = '';}
		
		if($borderbottom == 'yes'){$bottom = 'homepage-container-design-bottom';}else{$bottom = '';}
		
		if($repeat == 'yes'){$getrepeat = 'repeat'; $backcover = 'auto';}else{$getrepeat = 'no-repeat'; $backcover = 'cover';}

		if($type == 'yes'){
			return '<div class="homepage-container-design homepage-container-design-wide '. $top .' '. $sentientLayerSlider . ' ' . $bottom .'" style="background:'. $color .'; color:'. $font .'; padding-top:'. $paddingtop .'; padding-bottom:'. $paddingbottom .';">
				<div class="homepage-container-design-inner">';
		}
		else
		{
			$getimageurlarray = wp_get_attachment_image_src( $background , 'full');
			if( $getimageurlarray ) {$getimageurl = $getimageurlarray[0];} else {$getimageurl = '';}
			return '<div class="homepage-container-design homepage-container-design-wide '. $top .' '. $sentientLayerSlider . ' ' . $bottom .'" style="background-image:url('. $getimageurl .');color:'. $font .';background-repeat:'. $getrepeat .'; padding-top:'. $paddingtop .'; padding-bottom:'. $paddingbottom .'; background-size:'. $backcover .';">
				<div class="homepage-container-design-inner">';
		}

	}
	add_shortcode('homepage_container_wide', 'sentient_homepage_container_wide');

	
	/*------------------------------------------------------
	Sentient Homepage Row Wide Start - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Row Wide Begin" , "sentient"),
	   "base" => "homepage_container_wide",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Background Color?" , "sentient"),
			 "param_name" => "type",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("If you choose No it will put the background image." , "sentient")
		  ),
		  array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Background color" , "sentient"),
			 "param_name" => "color",
			 "value" => "#FFFFFF",
			 "description" => __("Please Choose Background color for your Row" , "sentient")
		  ),
		  array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Font color" , "sentient"),
			 "param_name" => "font",
			 "value" => "#787878",
			 "description" => __("Please Choose Font color for your Row" , "sentient")
		  ),
		  array(
			 "type" => "attach_image",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Background Image" , "sentient"),
			 "param_name" => "background",
			 "value" => "",
			 "description" => __("Please Choose Background Image for your Row" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Background Image Repeat" , "sentient"),
			 "param_name" => "repeat",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("Do you want to Repeat Background Image?" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Padding from Top" , "sentient"),
			 "param_name" => "paddingtop",
			 "value" => "40px",
			 "description" => __("Distance between row and content from top side" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Padding from Bottom" , "sentient"),
			 "param_name" => "paddingbottom",
			 "value" => "40px",
			 "description" => __("Distance between row and content from bottom side" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Border Top" , "sentient"),
			 "param_name" => "bordertop",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("Do you want to display border on the top of the row" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Border Bottom" , "sentient"),
			 "param_name" => "borderbottom",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("Do you want to display border on the bottom of the row" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Add Numbers navigation for LayerSlider?" , "sentient"),
			 "param_name" => "layernav",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("Do you want to replace the default LayerSlider navigation with Sentient ones?" , "sentient")
		  )
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Homepage Video Row Start - Shortcode
	-------------------------------------------------------*/
	function sentient_homepage_video_container($atts, $content = null) {
		
		extract(shortcode_atts(array('video' => '', 'background' => '' , 'font' => '#666666' , 'paddingtop' => '40px' , 'paddingbottom' => '40px'), $atts));
						
		$returnedvalue = '';
		$getimageurlarray = wp_get_attachment_image_src( $background , 'full');
		$getvideourlarray = wp_get_attachment_image_src( $video , 'full');
		
		if( $getimageurlarray ) {$getimageurl = $getimageurlarray[0];} else {$getimageurl = '';}
		
		$returnedvalue = '<div class="homepage-container-design" style="color:'. $font .'; padding-top:'. $paddingtop .'; padding-bottom:'. $paddingbottom .';">
			<div class="sentient-video-container"><video controls="false" width="100%" muted autoplay="autoplay" loop id="sentient-video-row">
				<source type="video/mp4" src="' . $video . '"></source>
			</video></div>
			<div class="homepage-container-design-inner">';

		return $returnedvalue;

	}
	add_shortcode('sentient_homepage_video_container', 'sentient_homepage_video_container');
	
	
	/*------------------------------------------------------
	Sentient Homepage Row Start - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Video Row Begin" , "sentient"),
	   "base" => "sentient_homepage_video_container",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Video URL" , "sentient"),
			 "param_name" => "video",
			 "value" => "",
			 "description" => __("Suggest to upload videos to your Server and paste here the path" , "sentient")
		  ),
		  array(
			 "type" => "attach_image",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Background Image" , "sentient"),
			 "param_name" => "background",
			 "value" => "",
			 "description" => __("Please Choose Background Image for your Row" , "sentient")
		  ),
		  array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Font color" , "sentient"),
			 "param_name" => "font",
			 "value" => "#787878",
			 "description" => __("Please Choose Font color for your Row" , "sentient")
		  ),	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Padding from Top" , "sentient"),
			 "param_name" => "paddingtop",
			 "value" => "40px",
			 "description" => __("Distance between row and content from top side" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Padding from Bottom" , "sentient"),
			 "param_name" => "paddingbottom",
			 "value" => "40px",
			 "description" => __("Distance between row and content from bottom side" , "sentient")
		  )
		  )
	   )
	);


	
	/*------------------------------------------------------
	Sentient Homepage Row End - ShortCode
	-------------------------------------------------------*/
	function sentient_homepage_container_end($atts, $content = null) {
	   return '</div></div>';
	}
	add_shortcode('homepage_container_end', 'sentient_homepage_container_end');

	
	/*------------------------------------------------------
	Sentient Homepage Row End - VC
	-------------------------------------------------------*/
	
	vc_map( array(
	   "name" => __("Sentient Row End" , "sentient"),
	   "base" => "homepage_container_end",
	   "class" => "",
	   "show_settings_on_create" => false,   
	   "category" => __('Content' , "sentient"),
	) );


	
	/*------------------------------------------------------
	Sentient Homepage Icons Style One - Shortcode
	-------------------------------------------------------*/
	function sentient_homepage_icons_styleone($atts, $content = null) {
		extract(shortcode_atts(array('icontype' => 'icon-mobile','title' => 'Title Goes Here', 'text' => 'Content and Text goes here'), $atts));
	   
		return '<div class="sentient-iconsone-container">
			<div class="sentient-iconsOne-iconContainer">
				<i class="' . $icontype . '"></i>
				<div class="sentient-header-search-pointer-main">
					<div class="sentient-header-search-pointer">▴</div>
				</div>
			</div>
			<div class="sentient-iconsOne-titleContainer">
				' . esc_attr($title) . '
			</div>
			<div class="sentient-iconsOne-textContainer">
				' . esc_attr($text) . '
			</div>		
		</div>';
	}
	add_shortcode('homepage_icons_styleone', 'sentient_homepage_icons_styleone');

	
	/*------------------------------------------------------
	Sentient Homepage Icons Style One - VC
	-------------------------------------------------------*/
	
	vc_map( array(
	   "name" => __("Sentient Icons Style One" , "sentient"),
	   "base" => "homepage_icons_styleone",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose icon" , "sentient"),
			 "param_name" => "icontype",
			 "value" => $sentient_icon_styleone_arr,
			 "description" => __("Choose any of the available icons" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a Title here" , "sentient"),
			 "param_name" => "title",
			 "value" => "Title goes here",
			 "description" => __("The Title of the icon container" , "sentient")
		  ),
		  array(
			 "type" => "textarea",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Content here" , "sentient"),
			 "param_name" => "text",
			 "value" => "Content goes here",
			 "description" => __("The content of the icon container" , "sentient")
		  )
	   )
	) );

	
/*------------------------------------------------------
	Sentient Icons Style Two - Shortcode
	-------------------------------------------------------*/
	function sentient_homepage_icons_styletwo($atts, $content = null) {
		global $prof_default;
	   extract(shortcode_atts(array('icontype' => 'icon-mobile', 'title' => 'Title goes here', 'text' => 'Text Content goes here', 'titlecolor' => '#4E4E4E', 'contentcolor' => '#7C7C7C'), $atts));

	   $returnvalue = '<div class="people-container">
				<div class="icon-thumbnail">
					<i class="' . $icontype . '"></i>
				</div>
				<div class="icon-say">
					<div class="people-title" style="color:' . $titlecolor . '">'. esc_attr($title) .'</div>
					<div class="people-desc" style="color:' . $contentcolor . '">'. esc_attr($text) .'</div>
				</div>
			</div>';
			
	   return $returnvalue;

	}
	add_shortcode('homepage_icons_styletwo', 'sentient_homepage_icons_styletwo');

	
	/*------------------------------------------------------
	Sentient Homepage Icons Style Two - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Icons Style Two" , "sentient"),
	   "base" => "homepage_icons_styletwo",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose icon" , "sentient"),
			 "param_name" => "icontype",
			 "value" => $sentient_icon_styleone_arr,
			 "description" => __("Choose any of the available icons" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a Title here" , "sentient"),
			 "param_name" => "title",
			 "value" => "Title goes here",
			 "description" => __("The Title of the icon container" , "sentient")
		  ),
		  array(
			 "type" => "textarea",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Content here" , "sentient"),
			 "param_name" => "text",
			 "value" => "Content goes here",
			 "description" => __("The content of the icon container" , "sentient")
		  ),array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Title Color" , "sentient"),
			 "param_name" => "titlecolor",
			 "value" => "#4E4E4E",
			 "description" => __("Please Choose Title Color" , "sentient")
		  ),array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Content Color" , "sentient"),
			 "param_name" => "contentcolor",
			 "value" => "#7C7C7C",
			 "description" => __("Please Choose Content Color" , "sentient")
		  )
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Icons Style Three - Shortcode
	-------------------------------------------------------*/
	function sentient_homepage_icons_stylethree($atts, $content = null) {
		global $prof_default;
	   extract(shortcode_atts(array('icontype' => 'icon-mobile', 'title' => 'Title goes here', 'text' => 'Text Content goes here' , 'textalign' => 'left'), $atts));
		if($textalign == 'right'){$rightclass = 'people-container-align-right'; } else {$rightclass = ''; }
	   $returnvalue = '<div class="people-container people-container-circle-shape ' . esc_attr($rightclass) . '">
				<div class="icon-thumbnail">
					<i class="' . $icontype . '"></i>
				</div>
				<div class="icon-say">
					<div class="people-title">'. esc_attr($title) .'</div>
					<div class="people-desc">'. esc_attr($text) .'</div>
				</div>
			</div>';
			
	   return $returnvalue;

	}
	add_shortcode('homepage_icons_stylethree', 'sentient_homepage_icons_stylethree');

	
	/*------------------------------------------------------
	Sentient Homepage Icons Style Three - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Icons Style Three" , "sentient"),
	   "base" => "homepage_icons_stylethree",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose align" , "sentient"),
			 "param_name" => "textalign",
			 "value" => $sentient_icons_align_arr,
			 "description" => __("Choose align to display" , "sentient")
		  ),   
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose icon" , "sentient"),
			 "param_name" => "icontype",
			 "value" => $sentient_icon_styleone_arr,
			 "description" => __("Choose any of the available icons" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a Title here" , "sentient"),
			 "param_name" => "title",
			 "value" => "Title goes here",
			 "description" => __("The Title of the icon container" , "sentient")
		  ),
		  array(
			 "type" => "textarea",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Content here" , "sentient"),
			 "param_name" => "text",
			 "value" => "Content goes here",
			 "description" => __("The content of the icon container" , "sentient")
		  )
	   )
	) );

	
	
	
	/*------------------------------------------------------
	Sentient Homepage Icons Style Four - Shortcode
	-------------------------------------------------------*/
	function sentient_homepage_icons_stylefour($atts, $content = null) {
	extract(shortcode_atts(array('icontype' => 'icon-mobile','title' => 'Title Goes Here', 'text' => 'Content and Text goes here'), $atts));
	   
		return '<div class="sentient-iconsFour-Container">
			<div class="sentient-iconsFour-Face">
				<div class="sentient-iconsOne-iconContainer">
					<i class="' . $icontype . '"></i>
					<div class="sentient-header-search-pointer-main">
						<div class="sentient-header-search-pointer">▴</div>
					</div>
				</div>
				<div class="sentient-iconsFour-titleContainer">
					' . esc_attr($title) . '
				</div>
			</div>
			<div class="sentient-iconsFour-textContainer">
				<span class="sentient-iconsFour-FaceTitle">' . esc_attr($title) . '</span>
				<span class="sentient-iconsFour-FaceText">' . esc_attr($text) . '</span>
			</div>		
		</div>';
	}
	add_shortcode('homepage_icons_stylefour', 'sentient_homepage_icons_stylefour');

	
	/*------------------------------------------------------
	Sentient Homepage Icons Style Four - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Icons Style Four" , "sentient"),
	   "base" => "homepage_icons_stylefour",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose icon" , "sentient"),
			 "param_name" => "icontype",
			 "value" => $sentient_icon_styleone_arr,
			 "description" => __("Choose any of the available icons" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a Title here" , "sentient"),
			 "param_name" => "title",
			 "value" => "Title goes here",
			 "description" => __("The Title of the icon container" , "sentient")
		  ),
		  array(
			 "type" => "textarea",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Content here" , "sentient"),
			 "param_name" => "text",
			 "value" => "Content goes here",
			 "description" => __("The content of the icon container" , "sentient")
		  )
	   )
	) );

	
	/*------------------------------------------------------
	Sentient Homepage Icons Style Five - Shortcode
	-------------------------------------------------------*/
	function sentient_homepage_icons_stylefive($atts, $content = null) {
	extract(shortcode_atts(array('icontype' => 'icon-mobile','image' => '','title' => 'Title Goes Here', 'text' => 'Content and Text goes here', 'link' => '#'), $atts));
		$linktext = __("Learn More" , "sentient");
		$getimageurlarray = wp_get_attachment_image_src( $image , 'full');
		if( $getimageurlarray ) {$getimageurl = $getimageurlarray[0];} else {$getimageurl = '';}	
		
		if($link == ''){
			$sentient_link_container = '';
		} else {
			$sentient_link_container = '<div class="sentient-iconsFive-linkContainer">
				<a href="' . esc_url($link) . '" >' . esc_attr($linktext) . '</a>
			</div>';
		}
		
		return '<div class="sentient-iconsFive-Container">
			<div class="sentient-iconsFive-imageContainer">
				<div class="sentient-iconsFive-imageInternal">
					<img src="' . esc_url($getimageurl) . '" alt="icon image" />
				</div>
				<div class="sentient-iconsOne-iconContainer">
					<i class="' . $icontype . '"></i>
					<div class="sentient-header-search-pointer-main">
						<div class="sentient-header-search-pointer">▴</div>
					</div>
				</div>
			</div>
			<div class="sentient-iconsFive-titleContainer">
				' . esc_attr($title) . '
			</div>
			<div class="sentient-iconsFive-textContainer">
				' . esc_attr($text) . '
			</div>
			'. $sentient_link_container .'	
		</div>';
	}
	add_shortcode('homepage_icons_stylefive', 'sentient_homepage_icons_stylefive');

	
	/*------------------------------------------------------
	Sentient Homepage Icons Style Five - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Icons Style Five" , "sentient"),
	   "base" => "homepage_icons_stylefive",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "attach_image",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Icon Image" , "sentient"),
			 "param_name" => "image",
			 "value" => "",
			 "description" => __("Please Choose Image for your icon container" , "sentient")
		  ),      
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose icon" , "sentient"),
			 "param_name" => "icontype",
			 "value" => $sentient_icon_styleone_arr,
			 "description" => __("Choose any of the available icons" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a Title here" , "sentient"),
			 "param_name" => "title",
			 "value" => "Title goes here",
			 "description" => __("The Title of the icon container" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a URL here" , "sentient"),
			 "param_name" => "link",
			 "value" => "Link goes here",
			 "description" => __("The URL of the icon container" , "sentient")
		  ),	  
		  array(
			 "type" => "textarea",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Content here" , "sentient"),
			 "param_name" => "text",
			 "value" => "Content goes here",
			 "description" => __("The content of the icon container" , "sentient")
		  )
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Homepage Icons Style Five - Shortcode
	-------------------------------------------------------*/
	function sentient_homepage_icons_stylesix($atts, $content = null) {
	extract(shortcode_atts(array('icontype' => 'icon-mobile','title' => 'Title Goes Here', 'text' => 'Content and Text goes here', 'link' => ''), $atts));
		$linktext = __("Learn More" , "sentient");
		if($link == ''){
			$linkcontainer = '';
		} else {
			$linkcontainer = '<div class="sentient-iconsFive-linkContainer">
								<a href="' . esc_url($link) . '" >' . esc_attr($linktext) . '</a>
							</div>';
		}
		
		return '<div class="sentient-iconsSix-Container">
			<div class="sentient-iconsFive-imageContainer">
				<div class="sentient-iconsOne-iconContainer">
					<i class="' . $icontype . '"></i>
					<div class="sentient-header-search-pointer-main">
						<div class="sentient-header-search-pointer">▴</div>
					</div>
				</div>
			</div>
			<div class="sentient-iconsFive-titleContainer">
				' . esc_attr($title) . '
			</div>
			<div class="sentient-iconsFive-textContainer">
				' . esc_attr($text) . '
			</div>
			' . $linkcontainer . '		
		</div>';
	}
	add_shortcode('homepage_icons_stylesix', 'sentient_homepage_icons_stylesix');

	
	/*------------------------------------------------------
	Sentient Homepage Icons Style Five - VC
	-------------------------------------------------------*/
	
	vc_map( array(
	   "name" => __("Sentient Icons Style Six" , "sentient"),
	   "base" => "homepage_icons_stylesix",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(     
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose icon" , "sentient"),
			 "param_name" => "icontype",
			 "value" => $sentient_icon_styleone_arr,
			 "description" => __("Choose any of the available icons" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a Title here" , "sentient"),
			 "param_name" => "title",
			 "value" => "Title goes here",
			 "description" => __("The Title of the icon container" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a URL here" , "sentient"),
			 "param_name" => "link",
			 "value" => "",
			 "description" => __("The URL of the icon container" , "sentient")
		  ),	  
		  array(
			 "type" => "textarea",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Content here" , "sentient"),
			 "param_name" => "text",
			 "value" => "Content goes here",
			 "description" => __("The content of the icon container" , "sentient")
		  )
	   )
	) );
	
	
	/*------------------------------------------------------
	Sentient Animated Numbers
	-------------------------------------------------------*/
	function sentient_animated_numbers($atts, $content = null) {
		extract(shortcode_atts(array('icontype' => 'icon-mobile', 'number' => '1000', 'text' => 'Description goes here'), $atts));

		return '
		<div class="sentient-animated-numbers-container">
		<i class="' . $icontype . '"></i>
		<span class="sentient-animated-numbers ' . esc_attr($number) . '"></span>
		<span class="sentient-animated-numbers-text">' . esc_attr($text) . '</span>
		</div>
		';
	}
	add_shortcode('sentient_animated_numbers', 'sentient_animated_numbers');

	
	/*------------------------------------------------------
	Sentient Animated Numbers - VC
	-------------------------------------------------------*/
	
	vc_map( array(
	   "name" => __("Sentient Animated Number" , "sentient"),
	   "base" => "sentient_animated_numbers",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose icon" , "sentient"),
			 "param_name" => "icontype",
			 "value" => $sentient_icon_styleone_arr,
			 "description" => __("Choose any of the available icons" , "sentient")
		  ),	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Number to Animate" , "sentient"),
			 "param_name" => "number",
			 "value" => "1000",
			 "description" => __("Enter Number to Animate" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Description" , "sentient"),
			 "param_name" => "text",
			 "value" => "Description goes here",
			 "description" => __("Enter Number Description" , "sentient")
		  )	  
	   )
	) );



	/*------------------------------------------------------
	Sentient Process - Shortcode
	-------------------------------------------------------*/
	function sentient_process($atts, $content = null) {
	
		extract(shortcode_atts(array('number' => '1','title' => 'Title Goes Here', 'text' => 'Content and Text goes here'), $atts));
	   
		return '<div class="sentient-iconsone-container sentient-working-process">
			<div class="sentient-iconsOne-iconContainer">
				<span class="sentient-process-number">' . esc_attr($number) . '</span>
				<div class="sentient-header-search-pointer-main">
					<div class="sentient-header-search-pointer">▴</div>
				</div>
			</div>
			<div class="sentient-iconsOne-titleContainer">
				' . esc_attr($title) . '
			</div>
			<div class="sentient-iconsOne-textContainer">
				' . esc_attr($text) . '
			</div>
			<div class="sentient-process-line">
			</div>
		</div>';
	}
	add_shortcode('sentient_process', 'sentient_process');

	
	/*------------------------------------------------------
	Sentient Process - VC
	-------------------------------------------------------*/
	
	vc_map( array(
	   "name" => __("Sentient Working Process" , "sentient"),
	   "base" => "sentient_process",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a Number here" , "sentient"),
			 "param_name" => "number",
			 "value" => "1",
			 "description" => __("The Number of the icon container" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a Title here" , "sentient"),
			 "param_name" => "title",
			 "value" => "Title goes here",
			 "description" => __("The Title of the icon container" , "sentient")
		  ),
		  array(
			 "type" => "textarea",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Content here" , "sentient"),
			 "param_name" => "text",
			 "value" => "Content goes here",
			 "description" => __("The content of the icon container" , "sentient")
		  )
	   )
	) );



	
	/*------------------------------------------------------
	Sentient Divider - Shortcode
	-------------------------------------------------------*/
	function sentient_divider($atts, $content = null) {
		return '<div class="sentient-divider">	
		</div>';
	}
	add_shortcode('sentient_divider', 'sentient_divider');

	
	/*------------------------------------------------------
	Sentient Divider - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Divider" , "sentient"),
	   "base" => "sentient_divider",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	  "show_settings_on_create" => false,   
	) );

	
	
	/*------------------------------------------------------
	Sentient Divider Circle - Shortcode
	-------------------------------------------------------*/
	function sentient_divider_circle($atts, $content = null) {
		return '<div class="sentient-divider-circle">	
		</div>';
	}
	add_shortcode('sentient_divider_circle', 'sentient_divider_circle');

	
	/*------------------------------------------------------
	Sentient Divider - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Divider with Circle" , "sentient"),
	   "base" => "sentient_divider_circle",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "show_settings_on_create" => false,   
	) );



	/*------------------------------------------------------
	Sentient Divider Mini - Shortcode
	-------------------------------------------------------*/
	function sentient_divider_mini($atts, $content = null) {
		return '<div class="sentient-portfolio-divider" style="background:' . $color . ';"></div>';
	}
	add_shortcode('sentient_divider_mini', 'sentient_divider_mini');

	/*------------------------------------------------------
	Sentient Divider Mini - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Divider Mini" , "sentient"),
	   "base" => "sentient_divider_mini",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Divider color" , "sentient"),
			 "param_name" => "color",
			 "value" => "#787878",
			 "description" => __("Please Choose Divider color" , "sentient")
		  )  
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Button - Shortcode
	-------------------------------------------------------*/
	function sentient_button($atts, $content = null) {
	   extract(shortcode_atts(array('fontcolor' => '#1BC4DE' , 'buttoncolor' => '#1BC4DE' ,'bordercolor' => '#1BC4DE' , 'link' => '#' , 'size' => 'normal', 'title' => 'Button', 'hoverstate' => 'likeopacity'), $atts));
	   if($hoverstate == 'liketheme'){$sentient_button_hover_state = 'sentient-button-like-theme';} else {$sentient_button_hover_state = 'sentient-button-opacity';}
	   
	   return '<a href='. esc_url($link) .' class="sentient-button ' . esc_attr($sentient_button_hover_state) . ' '. esc_attr($size) .'-size" style="background:' . $buttoncolor . '; color:' . $fontcolor . '; border:1px solid ' . $bordercolor . ';"><span>' . esc_attr($title) . '</span></a>';
	}
	add_shortcode('sentient_button', 'sentient_button');


	/*------------------------------------------------------
	Sentient Button - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Button" , "sentient"),
	   "base" => "sentient_button",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		 array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Button color" , "sentient"),
			 "param_name" => "buttoncolor",
			 "value" => "#2dd2fb",
			 "description" => __("Please Choose color for your Button" , "sentient")
		  ),
		 array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Button Font color" , "sentient"),
			 "param_name" => "fontcolor",
			 "value" => "#FFFFFF",
			 "description" => __("Please Choose Font color for your Button" , "sentient")
		  ),
		 array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Button Border color" , "sentient"),
			 "param_name" => "bordercolor",
			 "value" => "#1fb9e9",
			 "description" => __("Please Choose Border color for your Button" , "sentient")
		  ), 	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Button Title" , "sentient"),
			 "param_name" => "title",
			 "value" => "Button",
			 "description" => __("The Title of your Button" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Button Link" , "sentient"),
			 "param_name" => "link",
			 "value" => "link",
			 "description" => __("The Link of your Button" , "sentient")
		  ),	  
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose Button Size" , "sentient"),
			 "param_name" => "size",
			 "value" => $sentient_button_size,
			 "description" => __("The Size of your button" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose Button Hover State" , "sentient"),
			 "param_name" => "hoverstate",
			 "value" => $sentient_button_arr,
			 "description" => __("The Hover state for the Button" , "sentient")
		  )		  		  
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Button with icon - Shortcode
	-------------------------------------------------------*/
	function sentient_button_icon($atts, $content = null) {
	   extract(shortcode_atts(array('fontcolor' => '#1BC4DE' , 'buttoncolor' => '#1BC4DE' ,'bordercolor' => '#1BC4DE' , 'link' => '#' , 'size' => 'normal', 'title' => 'Button' ,'icontype' => 'icon-mobile', 'hoverstate' => 'likeopacity'), $atts));
	   if($hoverstate == 'liketheme'){$sentient_button_hover_state = 'sentient-button-like-theme';} else {$sentient_button_hover_state = 'sentient-button-opacity';}
	   return '<a href='. esc_url($link) .' class="sentient-button sentient-button-icon ' . esc_attr($sentient_button_hover_state) . ' ' . esc_attr($size) .'-size" style="background:' . $buttoncolor . '; color:' . $fontcolor . '; border:1px solid ' . $bordercolor . ';"><i class="' . $icontype . '"></i><span>' . esc_attr($title) . '</span></a>';
	}
	add_shortcode('sentient_button_icon', 'sentient_button_icon');


	/*------------------------------------------------------
	Sentient Button - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Button with Icon" , "sentient"),
	   "base" => "sentient_button_icon",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		 array(
		  "type" => "dropdown",
		  "holder" => "div",
		  "class" => "",
		  "heading" => __("Please choose icon" , "sentient"),
		  "param_name" => "icontype",
		  "value" => $sentient_icon_styleone_arr,
		  "description" => __("Choose any of the available icons" , "sentient")
		 ),   
		 array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Button color" , "sentient"),
			 "param_name" => "buttoncolor",
			 "value" => "#2dd2fb",
			 "description" => __("Please Choose color for your Button" , "sentient")
		  ),
		 array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Button Font color" , "sentient"),
			 "param_name" => "fontcolor",
			 "value" => "#FFFFFF",
			 "description" => __("Please Choose Font color for your Button" , "sentient")
		  ),
		 array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Button Border color" , "sentient"),
			 "param_name" => "bordercolor",
			 "value" => "#1fb9e9",
			 "description" => __("Please Choose Border color for your Button" , "sentient")
		  ), 	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Button Title" , "sentient"),
			 "param_name" => "title",
			 "value" => "Button",
			 "description" => __("The Title of your Button" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Button Link" , "sentient"),
			 "param_name" => "link",
			 "value" => "link",
			 "description" => __("The Link of your Button" , "sentient")
		  ),	  
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose Button Size" , "sentient"),
			 "param_name" => "size",
			 "value" => $sentient_button_size,
			 "description" => __("The Size of your button" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose Button Hover State" , "sentient"),
			 "param_name" => "hoverstate",
			 "value" => $sentient_button_arr,
			 "description" => __("The Hover state for the Button" , "sentient")
		  )	
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Portfolio Full Width - Shortcode
	-------------------------------------------------------*/
	function sentient_portfolio_full_width( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '3'), $atts));
		
		global $prof_default;
		
		$client_string =  __('Client:  ' , 'sentient');
		$loop = new WP_Query(array('post_type' => 'portfolio', 'posts_per_page' => $noofposts));
		$return_string = '<div class="sentient-portfolio-fw-container sentient-portfolio-fullwidth-container-animate"><ul>';

		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();
		$return_string .= '
				<li>
					<div class="sentient-portfolio-fullwidth-thumb">
						<a href="'. esc_url(get_permalink()) .'">
						' . get_the_post_thumbnail( get_the_ID() , 'full' ) . '
						</a>
						<a href="'. esc_url(get_permalink()) .'"><i class="fa-plus"></i></a>
					</div>
					<div class="sentient-portfolio-fw-content">
						<div class="sentient-portfolio-fw-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-portfolio-fw-client">
							<span class="sentient-portfolio-fw-clientText">' . $client_string . '</span><span class="sentient-portfolio-fw-clientValue"><a href="' . get_post_meta(get_the_ID(), 'Project Client URL', true) . '">' . get_post_meta(get_the_ID(), 'Project Client', true) . '</a></span>
						</div>
						<div class="sentient-portfolio-fw-cat">';
							$terms = get_the_terms( get_the_ID() , 'portfolio_category' );  
							$separator = ' / ';
							$output = '';
							if ( $terms && ! is_wp_error( $terms ) ) {   
								foreach ( $terms as $term )   
								{  
									$output .= '<a href="'.get_category_link( $term->term_id ).'" >'.$term->name.'</a>'.$separator;

								} 
								$return_string .= trim($output, $separator);
							} else {   
							   
							}	
						$return_string .= '</div>
						<div class="sentient-portfolio-divider"></div>					
						<div class="sentient-portfolio-fw-text">
							' . strip_shortcodes(wp_trim_words( get_the_excerpt(), 41 )) . '
						</div>						
					</div>				
				</li>';
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	    
		return $return_string;	
	}
	add_shortcode('sentient_portfolio_full_width', 'sentient_portfolio_full_width');

	
	/*------------------------------------------------------
	Sentient Portfolio Full Width - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Portfolio Full Width" , "sentient"),
	   "base" => "sentient_portfolio_full_width",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of projects" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "3",
			 "description" => __("Number of projects to display" , "sentient")
		  )
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Portfolio four element per row - Shortcode
	-------------------------------------------------------*/
	function sentient_portfolio_four_col( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '4'), $atts));
		
		global $prof_default;
		$cat_count = 1;
		$loop = new WP_Query(array('post_type' => 'portfolio', 'posts_per_page' => $noofposts));
		$return_string = '<div class="sentient-portfolio-four-col"><ul>';

		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();
		$return_string .= '
				<li>
					<div class="sentient-portfolio-four-col-thumb">
						<a href="'. esc_url(get_permalink()) .'">
						' . get_the_post_thumbnail( get_the_ID() , 'full'  ) . '
						</a>
						<a href="'. esc_url(get_permalink()) .'"><i class="fa-plus"></i></a>
					</div>
					<div class="sentient-portfolio-four-col-content-container">
						<div class="sentient-portfolio-four-col-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-portfolio-four-col-categories">';
							$terms = get_the_terms( get_the_ID() , 'portfolio_category' );  
							$separator = ' . ';
							$output = '';
							if ( $terms && ! is_wp_error( $terms ) ) {   

								foreach ( $terms as $term )   
								{  
									if($cat_count < 3){											
										$output .= '<a href="'. esc_url(get_category_link( $term->term_id )) .'" >'.$term->name.'</a>'.$separator;
									}
									$cat_count = $cat_count + 1;
								} 
								
								$return_string .= trim($output, $separator);
								
							} else {   
							   
							}	
		$return_string .= '</div>					
					</div>				
				</li>';
		$cat_count = 1;
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	   return $return_string;	


	}
	add_shortcode('sentient_portfolio_four_col', 'sentient_portfolio_four_col');

	
	/*------------------------------------------------------
	Sentient Portfolio Four Col - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Portfolio Four Column" , "sentient"),
	   "base" => "sentient_portfolio_four_col",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of projects" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "4",
			 "description" => __("Number of projects to display" , "sentient")
		  )
	   )
	) );

	
	/*------------------------------------------------------
	Sentient Portfolio five per row - Shortcode
	-------------------------------------------------------*/
	function sentient_portfolio_five_col( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '5'), $atts));
		
		global $prof_default;
		$cat_count = 1;
			
		$terms = get_terms("portfolio_category");  
		$count = count($terms);  

		$return_string .='<div class="sentient-portfolio-five-col-filter"><ul id="portfolio-filter">';  
		$return_string .= '<li><button data-filter="*">All</button></li>';  
		if ( $count > 0 ){  
		  
			foreach ( $terms as $term ) {  
				if($term->name != 'Uncategorized' && $term->name != 'uncategorized'){
					$termname = strtolower($term->name);  
					$termname = str_replace(' ', '-', $termname);  
					$return_string .= '<li><button data-filter=".'.$termname.'">'.$term->name.'</button></li>';  
				}
			}  
		}  
		$return_string .= "</ul></div>";  
			
		
		$loop = new WP_Query(array('post_type' => 'portfolio', 'posts_per_page' => $noofposts));
		$return_string .= '<div class="sentient-portfolio-five-col"><ul id="portfolio-list">';

		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();
		
		$terms = get_the_terms( get_the_ID() , 'portfolio_category' );  
										  
		if ( $terms && ! is_wp_error( $terms ) ) :   
			$links = array();  

			foreach ( $terms as $term )   
			{  
				$links[] = $term->name;  
			}  
			$links = str_replace(' ', '-', $links);   
			$tax = join( " ", $links );       
		else :    
			$tax = '';    
		endif;	
		
		$return_string .= '
				<li class="sentient-portfolio-full-item grid-sizer ' . strtolower($tax) .'">
					<div class="sentient-portfolio-five-col-thumb">
						<a href="'. esc_url(get_permalink()) .'">
						' . get_the_post_thumbnail( get_the_ID() , 'full'  ) . '
						</a>
						<a href="'. esc_url(get_permalink()) .'"><i class="fa-plus"></i></a>
					</div>
					<div class="sentient-portfolio-five-col-content-container">
						<div class="sentient-portfolio-five-col-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-portfolio-five-col-categories">';
							$terms = get_the_terms( get_the_ID() , 'portfolio_category' );  
							$separator = ' . ';
							$output = '';
							if ( $terms && ! is_wp_error( $terms ) ) {   

								foreach ( $terms as $term )   
								{  
									if($cat_count < 3){											
										$output .= '<a href="' . esc_url(get_category_link( $term->term_id )) .'" >'.$term->name.'</a>'.$separator;
									}
									$cat_count = $cat_count + 1;
								} 
								
								$return_string .= trim($output, $separator);
								
							} else {   
							   
							}	
					$return_string .= '</div>					
					</div>				
				</li>';
		$cat_count = 1;
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	   return $return_string;	


	}
	add_shortcode('sentient_portfolio_five_col', 'sentient_portfolio_five_col');

	
	/*------------------------------------------------------
	Sentient Portfolio five per row - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Portfolio Five Column" , "sentient"),
	   "base" => "sentient_portfolio_five_col",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of projects" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "4",
			 "description" => __("Number of projects to display" , "sentient")
		  )
	   )
	) );

	

	/*------------------------------------------------------
	Sentient Portfolio Six per row - Shortcode
	-------------------------------------------------------*/
	function sentient_portfolio_six_col( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '5'), $atts));
		
		global $prof_default;

		$cat_count = 1;	
		$loop = new WP_Query(array('post_type' => 'portfolio', 'posts_per_page' => $noofposts));
		$return_string .= '<div class="sentient-portfolio-six-col"><ul class="slides">';

		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();

		$return_string .= '
				<li class="">
					<div class="sentient-portfolio-five-col-thumb">
						<a href="'. esc_url(get_permalink()) .'">
						' . get_the_post_thumbnail( get_the_ID() , 'full'  ) . '
						</a>
						<a href="'. esc_url(get_permalink()) .'"><i class="fa-plus"></i></a>
					</div>
					<div class="sentient-portfolio-five-col-content-container">
						<div class="sentient-portfolio-five-col-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-portfolio-five-col-categories">';
							$terms = get_the_terms( get_the_ID() , 'portfolio_category' );  
							$separator = ' . ';
							$output = '';
							if ( $terms && ! is_wp_error( $terms ) ) {   

								foreach ( $terms as $term )   
								{  
									if($cat_count < 3){											
										$output .= '<a href="' . esc_url(get_category_link( $term->term_id )) . '" >'.$term->name.'</a>'.$separator;
									}
									$cat_count = $cat_count + 1;
								} 
								
								$return_string .= trim($output, $separator);
								
							} else {   
							   
							}	
					$return_string .= '</div>					
					</div>				
				</li>';
		$cat_count = 1;
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	    return $return_string;	

	}
	add_shortcode('sentient_portfolio_six_col', 'sentient_portfolio_six_col');

	
	/*------------------------------------------------------
	Sentient Portfolio Six per row - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Portfolio Five Column Slider" , "sentient"),
	   "base" => "sentient_portfolio_six_col",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of projects" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "4",
			 "description" => __("Number of projects to display" , "sentient")
		  )
	   )
	) );


	
	 /*------------------------------------------------------
	Sentient Top Rated Products - ShortCode
	-------------------------------------------------------*/
	function sentient_top_rated_items( $atts, $content = null ){
		if (class_exists('Woocommerce')) {	
		
		global $woocommerce;
		global $woocommerce_loop;

		$sentient_add_to_cart = __("Add to Cart","sentient");
		$sentient_more_details = __("More Details","sentient");
		$sentient_sale_text = __("Sale!","sentient");
		
		extract( shortcode_atts( array(
			'per_page'      => '12',
			'columns'       => '4',
			'orderby'       => 'title',
			'order'         => 'asc'
			), $atts ) );

		$args = array(
			'post_type' 			=> 'product',
			'post_status' 			=> 'publish',
			'ignore_sticky_posts'   => 1,
			'orderby' 				=> $orderby,
			'order'					=> $order,
			'posts_per_page' 		=> $per_page,
			'meta_query' 			=> array(
				array(
					'key' 			=> '_visibility',
					'value' 		=> array('catalog', 'visible'),
					'compare' 		=> 'IN'
				)
			)
		);

		ob_start();

		add_filter( 'posts_clauses', array( WC_Shortcodes, 'order_by_rating_post_clauses' ) );

		$products = new WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $atts ) );

		remove_filter( 'posts_clauses', array( WC_Shortcodes, 'order_by_rating_post_clauses' ) );

		$return_string = '';
		$woocommerce_loop['columns'] = $columns;

		if ( $products->have_posts() ) : 

			 woocommerce_product_loop_start();

				 while ( $products->have_posts() ) : $products->the_post();

					/*wc_get_template_part( 'content', 'product' );*/
				if((get_post_meta( get_the_ID(), '_sale_price', true) != get_post_meta( get_the_ID(), '_regular_price', true) && get_post_meta( get_the_ID(), '_sale_price', true) == get_post_meta( get_the_ID(), '_price', true))){
					$sentient_sale = '<span class="sentient-sale">' . $sentient_sale_text . '</span>';
				} else {
					$sentient_sale = '';
				}			
				
				$product_content= '<a class="button add_to_cart_button product_type_simple added" data-product_sku="" data-product_id="' . get_the_ID() . '" rel="nofollow" href="' . do_shortcode('[add_to_cart_url id="' . get_the_ID() . '"]') . '">Add to cart</a>';
					
				$return_string .= '
				<li class="">
					<div class="sentient-top-rated-items-thumb">
						<a href="'. esc_url(get_permalink()) .'">
						' . get_the_post_thumbnail( get_the_ID() , array(280,9999)  ) . $sentient_sale . '
						</a>
					</div>
					<div class="sentient-top-rated-items-thumb-content-container">
						<div class="sentient-top-rated-items-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-top-rated-items-prices">';
		
						$sentient_currency_sale = get_woocommerce_currency_symbol();
						
						$sentient_get_variation_id = get_post_meta( get_the_ID(), '_min_price_variation_id', true );
						
					if( $sentient_get_variation_id != '' ) {			
						$sentient_price = __("From: " , "sentient") . $sentient_currency_sale . get_post_meta( $sentient_get_variation_id, '_price', true );
						$sentient_sale = '';
					}
					else{
						$sentient_sale = get_post_meta( get_the_ID(), '_sale_price', true);	
		
						if($sentient_sale == ''){
							$sentient_price = $sentient_currency_sale . get_post_meta( get_the_ID(), '_regular_price', true);
						} else {
							$sentient_price = '<del>' . $sentient_currency_sale . get_post_meta( get_the_ID(), '_regular_price', true) . '</del>';
						}					
					}


					if($sentient_sale == ''){$sentient_sale_container='';} else {$sentient_sale_container=' - <span class="sentient-product-slider-sale-price">' . $sentient_currency_sale . $sentient_sale . '</span>';}
					
					
		$return_string .= '<span class="sentient-product-slider-regular-price">' . $sentient_price . '</span>' . $sentient_sale_container . '</div>					
					</div>
					<div class="sentient-top-rated-items-buttons">
						<span class="sentient-top-rated-items-add-to-cart">' . $product_content . '</span>
						<span class="sentient-top-rated-items-view-details"><a href="'. esc_url(get_permalink()) .'"><i class="fa-list"></i>' . $sentient_more_details . '</a></span>
					</div>
				</li>';
				endwhile;

			woocommerce_product_loop_end();

		endif;

		wp_reset_postdata();
		
		return '<div class="sentient-top-rated-items">
			<div class="vc_separator wpb_content_element vc_separator_align_left vc_el_width_100 vc_sep_color_grey sentient-inside-seperator">
				<span class="vc_sep_holder vc_sep_holder_l"><span style="border-color:#e1e1e1;" class="vc_sep_line"></span></span>
				<h4>Top Rated Items</h4>	<span class="vc_sep_holder vc_sep_holder_r"><span style="border-color:#e1e1e1;" class="vc_sep_line"></span></span>
			</div>
			<ul class="slides">' . $return_string . '</ul>
		</div>';
		}
		else {return '';}

	}
	add_shortcode('sentient_top_rated_items', 'sentient_top_rated_items');

	
	/*------------------------------------------------------
	Sentient Top Rated Products - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Top Rated Items" , "sentient"),
	   "base" => "sentient_top_rated_items",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of products" , "sentient"),
			 "param_name" => "per_page",
			 "value" => "5",
			 "description" => __("Number of products to display" , "sentient")
		  )
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Products Four per row - Shortcode
	-------------------------------------------------------*/
	function sentient_products_four_col( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '4'), $atts));
		if (class_exists('Woocommerce')) {	
		
		global $prof_default;

		$cat_count = 1;	
		$loop = new WP_Query(array('post_type' => 'product', 'posts_per_page' => $noofposts));
		$return_string .= '<div class="sentient-products-four-col"><ul class="slides">';

		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();

		$product_content= '<a class="button add_to_cart_button product_type_simple added" data-product_sku="" data-product_id="' . get_the_ID() . '" rel="nofollow" href="' . do_shortcode('[add_to_cart_url id="' . get_the_ID() . '"]') . '"><i class="icon-basket"></i></a>';
		$return_string .= '
				<li class="">
					<div class="sentient-products-four-col-thumb">
						<a href="'. esc_url(get_permalink()) .'">
						' . get_the_post_thumbnail( get_the_ID() , array(475,475)  ) . '
						</a>
						<div class="sentient-products-four-col-icons-container">
							'. $product_content .'
							<a href="'. esc_url(get_permalink()) .'"><i class="icon-plus-squared"></i></a>
						</div>					
					</div>
					<div class="sentient-portfolio-five-col-content-container">
						<div class="sentient-portfolio-five-col-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-portfolio-five-col-categories">';

					$sentient_currency_sale = get_woocommerce_currency_symbol();
						
					$sentient_get_variation_id = get_post_meta( get_the_ID(), '_min_price_variation_id', true );
						
					if( $sentient_get_variation_id != '' ) {			
						$sentient_price = __("From: " , "sentient") . $sentient_currency_sale . get_post_meta( $sentient_get_variation_id, '_price', true );
						$sentient_sale = '';
					}
					else{
						$sentient_sale = get_post_meta( get_the_ID(), '_sale_price', true);
						if($sentient_sale == ''){
							$sentient_price = $sentient_currency_sale . get_post_meta( get_the_ID(), '_regular_price', true);
						} else {
							$sentient_price = '<del>' . $sentient_currency_sale . get_post_meta( get_the_ID(), '_regular_price', true) . '</del>';
						}						
					}


					if($sentient_sale == ''){$sentient_sale_container='';} else {$sentient_sale_container=' - <span class="sentient-product-slider-sale-price">' . $sentient_currency_sale . $sentient_sale . '</span>';}
					
		$return_string .= '<span class="sentient-product-slider-regular-price">' . $sentient_price . '</span>' . $sentient_sale_container .  '</div>					
					</div>				
				</li>';
		$cat_count = 1;
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
		} else {$return_string = '';}
		
	   return $return_string;	


	}
	add_shortcode('sentient_products_four_col', 'sentient_products_four_col');

	
	/*------------------------------------------------------
	Sentient Products Four per row - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Products Four Columns Slider" , "sentient"),
	   "base" => "sentient_products_four_col",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of products" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "4",
			 "description" => __("Number of products to display" , "sentient")
		  )
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Products Three per row - Shortcode
	-------------------------------------------------------*/
	function sentient_products_three_col( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '6'), $atts));
		if (class_exists('Woocommerce')) {	
		
		global $prof_default;
		global $woocommerce;
		global $woocommerce_loop;

		$sentient_add_to_cart = __("Add to Cart","sentient");
		$sentient_more_details = __("More Details","sentient");
		$sentient_sale_text = __("Sale!","sentient");	

		$cat_count = 1;	
		$loop = new WP_Query(array('post_type' => 'product', 'posts_per_page' => $noofposts));
		$return_string .= '<div class="sentient-products-four-col sentient-products-three-col"><ul>';

		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();

				if((get_post_meta( get_the_ID(), '_sale_price', true) != get_post_meta( get_the_ID(), '_regular_price', true) && get_post_meta( get_the_ID(), '_sale_price', true) == get_post_meta( get_the_ID(), '_price', true))){
					$sentient_sale = '<span class="sentient-sale">' . $sentient_sale_text . '</span>';
				} else {
					$sentient_sale = '';
				}			

				$product_content= '<a class="button add_to_cart_button product_type_simple added" data-product_sku="" data-product_id="' . get_the_ID() . '" rel="nofollow" href="' . do_shortcode('[add_to_cart_url id="' . get_the_ID() . '"]') . '">Add to cart</a>';
					
				$return_string .= '
				<li class="">
					<div class="sentient-top-rated-items-thumb">
						<a href="'. esc_url(get_permalink()) .'">
						' . get_the_post_thumbnail( get_the_ID() , array(280,9999)  ) . $sentient_sale . '
						</a>
					</div>
					<div class="sentient-top-rated-items-thumb-content-container">
						<div class="sentient-top-rated-items-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-top-rated-items-prices">';

					$sentient_currency_sale = get_woocommerce_currency_symbol();
					$sentient_get_variation_id = get_post_meta( get_the_ID(), '_min_price_variation_id', true );
						
					if( $sentient_get_variation_id != '' ) {			
						$sentient_price = __("From: " , "sentient") . $sentient_currency_sale . get_post_meta( $sentient_get_variation_id, '_price', true );
						$sentient_sale = '';
					}
					else{
						$sentient_sale = get_post_meta( get_the_ID(), '_sale_price', true);
						if($sentient_sale == ''){
							$sentient_price = $sentient_currency_sale . get_post_meta( get_the_ID(), '_regular_price', true);
						} else {
							$sentient_price = '<del>' . $sentient_currency_sale . get_post_meta( get_the_ID(), '_regular_price', true) . '</del>';
						}					
					}

					if($sentient_sale == ''){$sentient_sale_container='';} else {$sentient_sale_container=' - <span class="sentient-product-slider-sale-price">' . $sentient_currency_sale . $sentient_sale . '</span>';}
					
					
		$return_string .= '<span class="sentient-product-slider-regular-price">' . $sentient_price . '</span>' . $sentient_sale_container . '</div>					
					</div>
					<div class="sentient-top-rated-items-buttons">
						<span class="sentient-top-rated-items-add-to-cart">' . $product_content . '</span>
						<span class="sentient-top-rated-items-view-details"><a href="'. esc_url(get_permalink()) .'"><i class="fa-list"></i>' . $sentient_more_details . '</a></span>
					</div>
				</li>';
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
		} else {$return_string = '';}
		
	   return $return_string;	


	}
	add_shortcode('sentient_products_three_col', 'sentient_products_three_col');

	
	/*------------------------------------------------------
	Sentient Products Four per row - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Products Three Columns" , "sentient"),
	   "base" => "sentient_products_three_col",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of products" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "6",
			 "description" => __("Number of products to display" , "sentient")
		  )
	   )
	) );

	
	
	
	/*------------------------------------------------------
	Sentient Team Members - Three per Row - Shortcode
	-------------------------------------------------------*/
	function sentient_team_members_three_col( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '3'), $atts));
		
		global $prof_default;

		$cat_count = 1;	
		$loop = new WP_Query(array('post_type' => 'team', 'posts_per_page' => $noofposts));
		$return_string .= '<div class="sentient-team-three-col"><ul>';

		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();

				
		if(get_post_meta(get_the_ID(), 'Dribbble URL', true) != ''){
			$dribbble_string = '<div class="sentient-social-shortcode-container sentient-social-dribbble">
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip">Dribbble</span>	
					</div>		
					<span class="sentient-header-top-info-dribbble"><a target="_blank" href="' . esc_url(get_post_meta(get_the_ID(), 'Dribbble URL', true)) . '"><i class="icon-dribbble"></i></a></span>
				</div>';
		} else {$dribbble_string ='';}
		
		if(get_post_meta(get_the_ID(), 'Facebook URL', true) != ''){
			$facebook_string = '<div class="sentient-social-shortcode-container sentient-social-facebook">
			<div class="sentient-header-top-popup-container animated">
				<span class="sentient-tooltip">Facebook</span>	
			</div>		
			<span class="sentient-header-top-info-facebook"><a target="_blank" href="' . esc_url(get_post_meta(get_the_ID(), 'Facebook URL', true)) . '"><i class="icon-facebook"></i></a></span>
		</div>';
		} else {$facebook_string ='';}
		
		if(get_post_meta(get_the_ID(), 'Twitter URL', true) != ''){
			$twitter_string = '<div class="sentient-social-shortcode-container sentient-social-twitter">
			<div class="sentient-header-top-popup-container animated">
				<span class="sentient-tooltip">Twitter</span>	
			</div>		
			<span class="sentient-header-top-info-twitter"><a target="_blank" href="' . esc_url(get_post_meta(get_the_ID(), 'Twitter URL', true)) . '"><i class="icon-twitter"></i></a></span>
		</div>';
		} else {$twitter_string ='';}	
		if(get_post_meta(get_the_ID(), 'LinkedIn URL', true) != ''){
			$linkedin_string = '<div class="sentient-social-shortcode-container sentient-social-linkedin">
			<div class="sentient-header-top-popup-container animated">
				<span class="sentient-tooltip">LinkedIn</span>	
			</div>		
			<span class="sentient-header-top-info-linkedin"><a target="_blank" href="' . esc_url(get_post_meta(get_the_ID(), 'LinkedIn URL', true)) . '"><i class="icon-linkedin"></i></a></span>
		</div>';
		} else {$linkedin_string ='';}	
		if(get_post_meta(get_the_ID(), 'Google URL', true) != ''){
			$google_string = '<div class="sentient-social-shortcode-container sentient-social-google">
			<div class="sentient-header-top-popup-container animated">
				<span class="sentient-tooltip">Google+</span>	
			</div>		
			<span class="sentient-header-top-info-google"><a target="_blank" href="' . esc_url(get_post_meta(get_the_ID(), 'Google URL', true)) . '"><i class="icon-gplus"></i></a></span>
		</div>';
		} else {$google_string ='';}

		$get_team_position =  get_post_meta(get_the_ID(), 'Team Member Position', true);
		
		$return_string .= '
				<li class="">
					<div class="sentient-team-thumb">
						<a href="'. esc_url(get_permalink()) .'">
						' . get_the_post_thumbnail( get_the_ID() , 'full'  ) . '
						</a>
						<div class="sentient-team-social">
							' . $twitter_string . $facebook_string . $dribbble_string . $linkedin_string . $google_string . '
						</div>
					</div>
					<div class="sentient-team-content-container">
						<div class="sentient-team-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-team-position">
							' . esc_attr($get_team_position) . '
						</div>					
						<div class="sentient-team-text">
							' . strip_shortcodes(wp_trim_words( get_the_content(), 20 )) . '
						</div>
					</div>				
				</li>';
		$cat_count = 1;
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	   return $return_string;	


	}
	add_shortcode('sentient_team_members_three_col', 'sentient_team_members_three_col');

	
	/*------------------------------------------------------
	Sentient Team Members - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Team Members 3 Col." , "sentient"),
	   "base" => "sentient_team_members_three_col",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of Team Member to display" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "3",
			 "description" => __("Number of Team Member to display" , "sentient")
		  )
	   )
	) );

	
	
	
	/*------------------------------------------------------
	Sentient Team Members - Style 2 - Shortcode
	-------------------------------------------------------*/
	function sentient_team_members_style_two( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '3' , 'style' => 'three'), $atts));
		
		global $prof_default;
		
		if($style == 'three'){
			$styleclass = 'sentient-team-three-col';
			$stripcontent = 18;
		} else {
			$styleclass = 'sentient-team-four-col';
			$stripcontent = 13;
		}
		
		$cat_count = 1;
		$return_string = '';
		$loop = new WP_Query(array('post_type' => 'team', 'posts_per_page' => $noofposts));
		$return_string .= '<div class="' . esc_attr($styleclass) . ' sentient-team-three-col-style-two"><ul>';

		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();

				
		if(get_post_meta(get_the_ID(), 'Dribbble URL', true) != ''){
			$dribbble_string = '<div class="sentient-social-shortcode-container sentient-social-dribbble">
					<div class="sentient-header-top-popup-container animated">
						<div class="sentient-header-top-popup">dribbble</div>
						<div class="sentient-header-search-pointer-main"><div class="sentient-header-search-pointer">▴</div></div>
					</div>		
					<span class="sentient-header-top-info-dribbble"><a target="_blank" href="' . esc_url(get_post_meta(get_the_ID(), 'Dribbble URL', true)) . '"><i class="icon-dribbble"></i></a></span>
				</div>';
		} else {$dribbble_string ='';}
		
		if(get_post_meta(get_the_ID(), 'Facebook URL', true) != ''){
			$facebook_string = '<div class="sentient-social-shortcode-container sentient-social-facebook">
			<div class="sentient-header-top-popup-container animated">
				<div class="sentient-header-top-popup">facebook</div>
				<div class="sentient-header-search-pointer-main"><div class="sentient-header-search-pointer">▴</div></div>
			</div>		
			<span class="sentient-header-top-info-facebook"><a target="_blank" href="' . esc_url(get_post_meta(get_the_ID(), 'Facebook URL', true)) . '"><i class="icon-facebook"></i></a></span>
		</div>';
		} else {$facebook_string ='';}
		
		if(get_post_meta(get_the_ID(), 'Twitter URL', true) != ''){
			$twitter_string = '<div class="sentient-social-shortcode-container sentient-social-twitter">
			<div class="sentient-header-top-popup-container animated">
				<div class="sentient-header-top-popup">twitter</div>
				<div class="sentient-header-search-pointer-main"><div class="sentient-header-search-pointer">▴</div></div>
			</div>		
			<span class="sentient-header-top-info-twitter"><a target="_blank" href="' . esc_url(get_post_meta(get_the_ID(), 'Twitter URL', true)) . '"><i class="icon-twitter"></i></a></span>
		</div>';
		} else {$twitter_string ='';}	
		if(get_post_meta(get_the_ID(), 'LinkedIn URL', true) != ''){
			$linkedin_string = '<div class="sentient-social-shortcode-container sentient-social-linkedin">
			<div class="sentient-header-top-popup-container animated">
				<div class="sentient-header-top-popup">linkedin</div>
				<div class="sentient-header-search-pointer-main"><div class="sentient-header-search-pointer">▴</div></div>
			</div>		
			<span class="sentient-header-top-info-linkedin"><a target="_blank" href="' . esc_url(get_post_meta(get_the_ID(), 'LinkedIn URL', true)) . '"><i class="icon-linkedin"></i></a></span>
		</div>';
		} else {$linkedin_string ='';}	
		if(get_post_meta(get_the_ID(), 'Google URL', true) != ''){
			$google_string = '<div class="sentient-social-shortcode-container sentient-social-google">
			<div class="sentient-header-top-popup-container animated">
				<div class="sentient-header-top-popup">Google+</div>
				<div class="sentient-header-search-pointer-main"><div class="sentient-header-search-pointer">▴</div></div>
			</div>		
			<span class="sentient-header-top-info-google"><a target="_blank" href="' . esc_url(get_post_meta(get_the_ID(), 'Google URL', true)) . '"><i class="icon-gplus"></i></a></span>
		</div>';
		} else {$google_string ='';}

		$get_team_position =  get_post_meta(get_the_ID(), 'Team Member Position', true);

		$return_string .= '
				<li class="">
					<div class="sentient-team-thumb">
						<a href="'. esc_url(get_permalink()) .'">
						' . get_the_post_thumbnail( get_the_ID() , 'full'  ) . '
						</a>
					</div>
					<div class="sentient-team-content-container">
						<div class="sentient-team-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-team-position">
							' . esc_attr($get_team_position) . '
						</div>					
						<div class="sentient-team-text">
							' . strip_shortcodes(wp_trim_words( get_the_content(), $stripcontent )) . '
						</div>
					</div>
					<div class="sentient-team-style-two-social">
						' . $twitter_string . $facebook_string . $dribbble_string . $linkedin_string . $google_string . '
					</div>
				</li>';
		$cat_count = 1;
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	   return $return_string;	

	}
	add_shortcode('sentient_team_members_style_two', 'sentient_team_members_style_two');

	
	/*------------------------------------------------------
	Sentient Team Members - Style 2 - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Team Members Style2" , "sentient"),
	   "base" => "sentient_team_members_style_two",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose Style" , "sentient"),
			 "param_name" => "style",
			 "value" => $sentient_team_arr,
			 "description" => __("The Size of your button" , "sentient") 
			),   
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of Team Member" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "3",
			 "description" => __("Number of Team Member to display" , "sentient")
		  )
	) ));

	
	
	/*------------------------------------------------------
	Sentient Map - Shortcode
	-------------------------------------------------------*/
	function sentient_map( $atts, $content = null ) {
		extract(shortcode_atts(array('latitude' => '-37.809674' , 'longitude' => '144.954718' , 'mapheight' => '470px' , 'wheel' => ''), $atts));
		
		global $prof_default;
		
		if($wheel == 'yes'){$wheel = 'true';} else {$wheel = 'false';}
				
		$return_string = '<div class="sentient-map">
			<div class="sentient-map-container">
				<!DOCTYPE html>
				<html>
				  <head>
					<style>
					  #map_canvas {
						width: 100%;
						height: ' . $mapheight . ';
					  }
					</style>
					<script src="https://maps.googleapis.com/maps/api/js?sensor=false"></script>
					<script>
					  function initialize() {
						var map_canvas = document.getElementById("map_canvas");
						var map_options = {
							panControl: true,
							zoomControl: true,
							scrollwheel: ' . $wheel . ',
							scaleControl: true,
							center: new google.maps.LatLng(' . $latitude . ', ' . $longitude . '),
							zoom: 15,
							mapTypeId: google.maps.MapTypeId.ROADMAP
						}
						var map = new google.maps.Map(map_canvas, map_options)
					  }
					  google.maps.event.addDomListener(window, "load", initialize);
					</script>
				  </head>
				  <body>
					<div id="map_canvas"></div>
				  </body>
				</html>
			</div>';
			
		if (of_get_option('select_display_map_logo',$prof_default) == 'On'){
		$return_string .='
			<div class="sentient-map-logo">
				<div class="sentient-iconsOne-iconContainer">
					<div class="sentient-map-tip-container">
						' . esc_attr(of_get_option('map_logo_text',$prof_default)) . '
					</div>
					<div class="sentient-header-search-pointer-main sentient-header-search-tooltip">
						<div class="sentient-header-search-pointer">▴</div>
					</div>		
					<img src="' . esc_url(of_get_option('map_logo',$prof_default)) . '" alt=contact logo" />
					<div class="sentient-header-search-pointer-main">
						<div class="sentient-header-search-pointer">▴</div>
					</div>
				</div>
			</div>';
		}
			
		$return_string .= '</div>';
		
	   return $return_string;	


	}
	add_shortcode('sentient_map', 'sentient_map');

	
	/*------------------------------------------------------
	Sentient Map - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Map" , "sentient"),
	   "base" => "sentient_map",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Map Height" , "sentient"),
			 "param_name" => "mapheight",
			 "value" => "470px",
			 "description" => __("Please Enter Map Height in Pixels" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Map Latitude" , "sentient"),
			 "param_name" => "latitude",
			 "value" => "-37.809674",
			 "description" => __("Please Enter Map Latitude Value" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Map embed Longitude" , "sentient"),
			 "param_name" => "longitude",
			 "value" => "144.954718",
			 "description" => __("Please Enter Map Longitude Value" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Enable/Disable Wheel zoom scroll" , "sentient"),
			 "param_name" => "wheel",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("Enable/Disable the Wheel Zoom Scroll of the Map so the user can scroll the map by mouse cursor" , "sentient")
		  )		  
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Services Section with Image - Shortcode
	-------------------------------------------------------*/
	function sentient_services_section_with_image($atts, $content = null) {
		global $prof_default;
	   extract(shortcode_atts(array('image' => '', 'title' => 'Title goes here', 'text' => 'Text Content goes here'), $atts));
		$getimageurlarray = wp_get_attachment_image_src( $image , 'full');
		if( $getimageurlarray ) {$getimageurl = $getimageurlarray[0];} else {$getimageurl = '';}
	   $returnvalue = '
		<div class="sentient-servicesIcons-Container">
			<div class="sentient-servicesIcons-thumb">
				<img src="' . esc_url($getimageurl) . '" alt="services-image" />
			</div>
			<div class="sentient-servicesIcons-title">
				' . esc_attr($title) . '
			</div>
			<div class="sentient-servicesIcons-text">
				' . esc_attr($text) . '		
			</div>		
		</div>  
	   ';
			
	   return $returnvalue;

	}
	add_shortcode('sentient_services_section_with_image', 'sentient_services_section_with_image');

	
	/*------------------------------------------------------
	Sentient Services Section with Image - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Services with image section" , "sentient"),
	   "base" => "sentient_services_section_with_image",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "attach_image",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Service Image" , "sentient"),
			 "param_name" => "image",
			 "value" => "",
			 "description" => __("Please Choose Services Image" , "sentient")
		  ),     
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a Title here" , "sentient"),
			 "param_name" => "title",
			 "value" => "Title goes here",
			 "description" => __("The Title of the icon container" , "sentient")
		  ),
		  array(
			 "type" => "textarea",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Content here" , "sentient"),
			 "param_name" => "text",
			 "value" => "Content goes here",
			 "description" => __("The content of the icon container" , "sentient")
		  )
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Testimonial with Thumbnail - Shortcode
	-------------------------------------------------------*/
	function sentient_testimonial_thumb( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '3' , 'type' => 'no'), $atts));
		
		global $prof_default;
		
		if($type == 'yes'){$autoClass = 'sentient-auto-rotate';} else {$autoClass = '';}
		
		$loop = new WP_Query(array('post_type' => 'testimonial', 'posts_per_page' => $noofposts));
		$return_string = '<div class="sentient-testimonial-with-thumb-container ' . $autoClass . ' "><ul class="slides">';

		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();
		$return_string .= '
				<li>
					<div class="sentient-testimonial-with-thumb-content-container">				
						<div class="sentient-testimonial-with-thumb-text">
							„' . strip_shortcodes(wp_trim_words( get_the_content(), 37 )) . '“						
						</div>
						<div class="sentient-header-search-pointer-main">
							<div class="sentient-header-search-pointer">▴</div>
						</div>					
					</div>
					<div class="sentient-testimonial-with-thumb-bottom-container">
						<div class="sentient-testimonial-thumb">
							<a href="'. esc_url(get_permalink()) .'">
							' . get_the_post_thumbnail( get_the_ID() , 'thumbnail' ) . '
							</a>
						</div>
						<div class="sentient-testimonial-name">
							<span class="sentient-testimonial-person-name">' . esc_attr(get_post_meta(get_the_ID(), 'Person Name', true)) . '</span>
							<span class="sentient-testimonial-person-position">' . esc_attr(get_post_meta(get_the_ID(), 'Person Position', true)) . '</span>
						</div>					
					</div>
				</li>';
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	   return $return_string;	


	}
	add_shortcode('sentient_testimonial_thumb', 'sentient_testimonial_thumb');

	
	/*------------------------------------------------------
	Sentient Testimonial with Thumbnail - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Testimonial Thumbnail Slider" , "sentient"),
	   "base" => "sentient_testimonial_thumb",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of Testimonials" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "3",
			 "description" => __("Number of Testimonials to display" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Automatic Rotation?" , "sentient"),
			 "param_name" => "type",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("If you choose Yes then Automatic Rotation will be enabled." , "sentient")
		  )		  
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Testimonial without Thumbnail - Shortcode
	-------------------------------------------------------*/
	function sentient_testimonial_single_slider( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '3' , 'iconcolor' => '' , 'textcolor' => '' , 'personcolor' => '' , 'pagination' => '' , 'type' => 'no'), $atts));
		
		global $prof_default;
		
		if($type == 'yes'){$autoClass = 'sentient-auto-rotate';} else {$autoClass = '';}		
		if($pagination == 'yes'){$sentient_test_pagination = '';} else {$sentient_test_pagination = 'sentient-test-white';}
		$loop = new WP_Query(array('post_type' => 'testimonial', 'posts_per_page' => $noofposts));
		$return_string = '<div class="sentient-testimonial-with-thumb-container ' . $autoClass . ' ' . $sentient_test_pagination . ' sentient-testimonial-single-container" style="color:' . $textcolor . ';"><ul class="slides" >';

		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();
		$return_string .= '
				<li>
					<div class="sentient-testimonial-single-icon">
						<i class="fa-quote-left" style="color:' . $iconcolor . ';"></i>
					</div>
					<div class="sentient-testimonial-single-content-container">				
						<div class="sentient-testimonial-single-text">
							„' . strip_shortcodes(wp_trim_words( get_the_content(), 50 )) . '“						
						</div>				
					</div>
					<div class="sentient-testimonial-single-bottom-container">
						<div class="sentient-single-testimonial-name">
							<span class="sentient-testimonial-single-person-name">' . esc_attr(get_post_meta(get_the_ID(), 'Person Name', true)) . ' - </span>
							<span class="sentient-testimonial-single-person-position"  style="color:' . $personcolor . ';">' . esc_attr(get_post_meta(get_the_ID(), 'Person Position', true)) . '</span>
						</div>					
					</div>
				</li>';
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	   return $return_string;	

	}
	add_shortcode('sentient_testimonial_single_slider', 'sentient_testimonial_single_slider');

	
	/*------------------------------------------------------
	Sentient Testimonial with Thumbnail - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Testimonial Normal Slider" , "sentient"),
	   "base" => "sentient_testimonial_single_slider",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of Testimonials" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "3",
			 "description" => __("Number of Testimonials to display" , "sentient")
		  ),array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Icon Color" , "sentient"),
			 "param_name" => "iconcolor",
			 "value" => "#6D6D6D",
			 "description" => __("Please Choose Icons Color" , "sentient")
		  ),array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Text Color" , "sentient"),
			 "param_name" => "textcolor",
			 "value" => "#6D6D6D",
			 "description" => __("Please Choose Text Color" , "sentient")
		  ),array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Person Position Color" , "sentient"),
			 "param_name" => "personcolor",
			 "value" => "#6D6D6D",
			 "description" => __("Please Choose Person Position Color" , "sentient")
		  ),array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Pagination Color Dark?" , "sentient"),
			 "param_name" => "pagination",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("If you choose No it will put the pagination color White." , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Automatic Rotation?" , "sentient"),
			 "param_name" => "type",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("If you choose Yes then Automatic Rotation will be enabled." , "sentient")
		  )			  
	   )
	) );

	
	
	
	/*------------------------------------------------------
	Sentient Video - Shortcode
	-------------------------------------------------------*/
	function sentient_video_tutorial($atts, $content = null) {
		global $prof_default;
	   extract(shortcode_atts(array('title' => 'Title goes here', 'text' => 'Text Content goes here', 'background' => '', 'link' => ''), $atts));
		
		$getimageurlarray = wp_get_attachment_image_src( $background , 'full');
		if( $getimageurlarray ) {$getimageurl = $getimageurlarray[0];} else {$getimageurl = '';}
		
	   $returnvalue = '<div class="sentient-video-tutorial-container">
				<div class="sentient-video-tutorial-thumbnail">
					<a href="' . esc_url($link) . '">
						<img src="' . $getimageurl . '" />
						<i class="icon-play"></i>
					</a>
				</div>
				<div class="sentient-video-tutorial-content">
					<div class="sentient-video-tutorial-title">' . esc_attr($title) . '</div>
					<div class="sentient-video-tutorial-desc">' . esc_attr($text) . '</div>
				</div>
			</div>';
			
	   return $returnvalue;

	}
	add_shortcode('sentient_video_tutorial', 'sentient_video_tutorial');

	
	/*------------------------------------------------------
	Sentient Video - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Video Tutorial" , "sentient"),
	   "base" => "sentient_video_tutorial",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "attach_image",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Video Image" , "sentient"),
			 "param_name" => "background",
			 "value" => "",
			 "description" => __("Please Choose a Video Image" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a Title here" , "sentient"),
			 "param_name" => "title",
			 "value" => "Title goes here",
			 "description" => __("The Title of the Video" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a link for your video" , "sentient"),
			 "param_name" => "link",
			 "value" => "Link goes here",
			 "description" => __("The URL of the Video" , "sentient")
		  ),	  
		  array(
			 "type" => "textarea",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Content here" , "sentient"),
			 "param_name" => "text",
			 "value" => "Content goes here",
			 "description" => __("The description of the video" , "sentient")
		  )
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Video - Shortcode
	-------------------------------------------------------*/
	function sentient_video_tutorial_styletwo($atts, $content = null) {
		global $prof_default;
	   extract(shortcode_atts(array('title' => 'Tooltip goes here', 'background' => '', 'link' => ''), $atts));
		
		$getimageurlarray = wp_get_attachment_image_src( $background , 'full');
		if( $getimageurlarray ) {$getimageurl = $getimageurlarray[0];} else {$getimageurl = '';}
		
	   $returnvalue = '
				<div class="sentient-video-tutorial-container sentient-video-tutorial-container-styletwo">
					<div class="sentient-video-tutorial-thumbnail">
						<a href="' . esc_url($link) . '">
							<img src="' . $getimageurl . '" />
							<i class="icon-play"></i>
						</a>
					</div>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip">' . esc_attr($title) . '</span>
					</div>					
				</div>';
			
	   return $returnvalue;

	}
	add_shortcode('sentient_video_tutorial_styletwo', 'sentient_video_tutorial_styletwo');


	/*------------------------------------------------------
	Sentient Video - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Video Tutorial Style 2" , "sentient"),
	   "base" => "sentient_video_tutorial_styletwo",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "attach_image",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Video Image" , "sentient"),
			 "param_name" => "background",
			 "value" => "",
			 "description" => __("Please Choose a Video Image" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a Tool-tip Title here" , "sentient"),
			 "param_name" => "title",
			 "value" => "Title Tooltip goes here",
			 "description" => __("The Title of the Video" , "sentient")
		  ),
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter a link for your video" , "sentient"),
			 "param_name" => "link",
			 "value" => "Link goes here",
			 "description" => __("The URL of the Video" , "sentient")
		  )
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Blogs Normal - Shortcode
	-------------------------------------------------------*/
	function sentient_blogs_normal( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '3'), $atts));
		
		global $prof_default;
		$loop = new WP_Query(array('post_type' => 'post', 'posts_per_page' => $noofposts));
		$return_string = '<div class="sentient-blog-normal-container"><ul>';
		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();
		if(get_comments_number( '0', '1', '%' ) == 1){
			$commenttext = get_comments_number( '0', '1', '%' ) . ' ' . __("Comment" , "sentient");
		} else {
			$commenttext = get_comments_number( '0', '1', '%' ) . ' ' . __("Comments" , "sentient");
		}
		
		$return_string .= '
				<li>
					<div class="sentient-blog-normal-thumb">';
					
		if(get_post_format() == false){			
			$return_string .= '<a href="'. esc_url(get_permalink()) .'">
							' . get_the_post_thumbnail( get_the_ID() , 'full' ) . '
							<i class="icon-pencil"></i>
							</a>';
		} elseif(has_post_format( 'gallery' )){
			$newstring = 'gallery putin="blogs" ';
			$oldstring = get_post_meta(get_the_ID(), 'Post Gallery Shortcode', true);
			$gallerycode = str_replace("gallery",$newstring,$oldstring); 	
			$return_string .=  do_shortcode($gallerycode) . '<i class="icon-camera"></i>';

		} elseif(has_post_format( 'chat' )){	
			$return_string .= '<div class="sentient-blog-normal-thumb-chat"><i class="fa-quote-left"></i></div>';			
		} elseif(has_post_format( 'link' )){	
			$return_string .= '<div class="sentient-blog-normal-thumb-link"><i class="icon-link"></i></div>';		
		} elseif(has_post_format( 'audio' )){	
			$return_string .= '<div class="sentient-blog-normal-thumb-audio"><i class="fa-volume-off"></i></div>';
		} elseif(has_post_format( 'video' )){
			$return_string .= '<iframe width="100%" height="230px" src="' . get_post_meta(get_the_ID(), 'Post Video URL', true) .'"></iframe>';
		}

		
		$return_string .= '</div>
					<div class="sentient-blog-normal-content-container">
						<div class="sentient-blog-normal-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-blog-normal-date-container">
							<span class="sentient-blog-normal-date">'. get_the_date() .'</span>
							<span class="sentient-blog-normal-date-seperator">.</span>
							<span class="sentient-blog-normal-comments"><a href="' . esc_url(get_comments_link(get_the_ID())) . '">' . $commenttext . '</a></span>
						</div>			
						<div class="sentient-blog-normal-text">
							' . strip_shortcodes(wp_trim_words( get_the_content(), 25 )) . '
						</div>						
					</div>				
				</li>';
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	   return $return_string;	


	}
	add_shortcode('sentient_blogs_normal', 'sentient_blogs_normal');

	/*------------------------------------------------------
	Sentient Blogs Normal - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Blogs Normal" , "sentient"),
	   "base" => "sentient_blogs_normal",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of blogs" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "3",
			 "description" => __("Number of blogs to display" , "sentient")
		  )
	   )
	) );

	
	/*------------------------------------------------------
	Sentient Blogs Normal By Category - Shortcode
	-------------------------------------------------------*/
	function sentient_blogs_normal_by_category( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '3' , 'postcategory' => ''), $atts));
		
		global $prof_default;
		$category_id = get_cat_ID($postcategory);
		$loop = new WP_Query(array('post_type' => 'post', 'posts_per_page' => $noofposts, 'cat' => $category_id));		

		$return_string = '<div class="sentient-blog-normal-container"><ul>';
		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();
		if(get_comments_number( '0', '1', '%' ) == 1){
			$commenttext = get_comments_number( '0', '1', '%' ) . ' ' . __("Comment" , "sentient");
		} else {
			$commenttext = get_comments_number( '0', '1', '%' ) . ' ' . __("Comments" , "sentient");
		}
		
		$return_string .= '
				<li>
					<div class="sentient-blog-normal-thumb">';
					
		if(get_post_format() == false){			
			$return_string .= '<a href="'. esc_url(get_permalink()) .'">
							' . get_the_post_thumbnail( get_the_ID() , 'full' ) . '
							<i class="icon-pencil"></i>
							</a>';
		} elseif(has_post_format( 'gallery' )){
			$newstring = 'gallery putin="blogs" ';
			$oldstring = get_post_meta(get_the_ID(), 'Post Gallery Shortcode', true);
			$gallerycode = str_replace("gallery",$newstring,$oldstring); 	
			$return_string .=  do_shortcode($gallerycode) . '<i class="icon-camera"></i>';

		} elseif(has_post_format( 'chat' )){	
			$return_string .= '<div class="sentient-blog-normal-thumb-chat"><i class="fa-quote-left"></i></div>';			
		} elseif(has_post_format( 'link' )){	
			$return_string .= '<div class="sentient-blog-normal-thumb-link"><i class="icon-link"></i></div>';		
		} elseif(has_post_format( 'audio' )){	
			$return_string .= '<div class="sentient-blog-normal-thumb-audio"><i class="fa-volume-off"></i></div>';
		} elseif(has_post_format( 'video' )){
			$return_string .= '<iframe width="100%" height="230px" src="' . get_post_meta(get_the_ID(), 'Post Video URL', true) .'"></iframe>';
		}

		
		$return_string .= '</div>
					<div class="sentient-blog-normal-content-container">
						<div class="sentient-blog-normal-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-blog-normal-date-container">
							<span class="sentient-blog-normal-date">'. get_the_date() .'</span>
							<span class="sentient-blog-normal-date-seperator">.</span>
							<span class="sentient-blog-normal-comments"><a href="' . esc_url(get_comments_link(get_the_ID())) . '">' . $commenttext . '</a></span>
						</div>			
						<div class="sentient-blog-normal-text">
							' . strip_shortcodes(wp_trim_words( get_the_content(), 25 )) . '
						</div>						
					</div>				
				</li>';
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	   return $return_string;	


	}
	add_shortcode('sentient_blogs_normal_by_category', 'sentient_blogs_normal_by_category');

	/*------------------------------------------------------
	Sentient Blogs Normal with Category- VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Blogs Normal By Category" , "sentient"),
	   "base" => "sentient_blogs_normal_by_category",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of blogs" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "3",
			 "description" => __("Number of blogs to display" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please select a category" , "sentient"),
			 "param_name" => "postcategory",
			 "value" => $sentient_cat_arr,
			 "description" => __("Category that you would like to retrieve posts depending on it" , "sentient")
		  )
	   )
	) );	
	
	
	/*------------------------------------------------------
	Sentient Blogs Normal Wide - Shortcode
	-------------------------------------------------------*/
	function sentient_blogs_normal_wide( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '3'), $atts));
		
		global $prof_default;
		$SentientPostBy = __("Posted By: " , "sentient");
		$loop = new WP_Query(array('post_type' => 'post', 'posts_per_page' => $noofposts));
		$return_string = '<div class="sentient-blog-normal-container sentient-blog-normal-wide-container"><ul>';
		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();
		if(get_comments_number( '0', '1', '%' ) == 1){
			$commenttext = get_comments_number( '0', '1', '%' ) . ' ' . __("Comment" , "sentient");
		} else {
			$commenttext = get_comments_number( '0', '1', '%' ) . ' ' . __("Comments" , "sentient");
		}
		
		$return_string .= '
				<li>
					<div class="sentient-blog-normal-thumb">';
					
		if(get_post_format() == false){			
			$return_string .= '<a href="'. esc_url(get_permalink()) .'">
							' . get_the_post_thumbnail( get_the_ID() , 'full' ) . '
							<i class="icon-pencil"></i>
							</a>';
		} elseif(has_post_format( 'gallery' )){
			$newstring = 'gallery putin="blogs" ';
			$oldstring = get_post_meta(get_the_ID(), 'Post Gallery Shortcode', true);
			$gallerycode = str_replace("gallery",$newstring,$oldstring); 	
			$return_string .=  do_shortcode($gallerycode) . '<i class="icon-camera"></i>';
		
		} elseif(has_post_format( 'audio' )){	
			$return_string .= '<div class="sentient-blog-normal-wide-thumb-audio"><i class="fa-volume-off"></i></div>';
		} elseif(has_post_format( 'link' )){	
			$return_string .= '<div class="sentient-blog-normal-wide-thumb-audio sentient-blog-normal-wide-thumb-link"><i class="icon-link"></i></div>';		
		} elseif(has_post_format( 'video' )){
			$return_string .= '<iframe width="100%" height="200px" src="' . esc_url(get_post_meta(get_the_ID(), 'Post Video URL', true)) . '"></iframe>';
		} elseif(has_post_format( 'chat' )){
			$return_string .= '<div class="sentient-blog-normal-wide-thumb-audio sentient-blog-normal-wide-thumb-chat"><i class="fa-quote-left"></i></div>';
		}

		$sentient_button_text = __("READ MORE" , "sentient");
		
		$return_string .= '</div>
					<div class="sentient-blog-normal-content-container">
						<div class="sentient-blog-normal-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-blog-normal-date-container">
							<span class="sentient-blog-normal-date">'. get_the_date() .'</span>
							<span class="sentient-blog-normal-date-seperator">.</span>
							<span class="sentient-blog-normal-comments"><a href="' . esc_url(get_comments_link(get_the_ID())) . '">' . $commenttext . '</a></span>
							<span class="sentient-blog-normal-date-seperator">.</span>
							<span class="sentient-blog-normal-date">' . $SentientPostBy . get_the_author() . '</span>
						</div>			
						<div class="sentient-blog-normal-text">
							' . strip_shortcodes(wp_trim_words( get_the_content(), 25 )) . '
						</div>
						<div class="sentient-blog-normal-link">
							<a style="background:' . of_get_option('sentient_blog_back',$prof_default) . ';border: 1px solid ' . of_get_option('sentient_blog_border',$prof_default) . '; color: ' . of_get_option('sentient_blog_color',$prof_default) . ';" href="'. esc_url(get_permalink()) .'" class="sentient-button sentient-button-opacity medium-size">' . $sentient_button_text . '</a>
						</div>					
					</div>				
				</li>';
		endwhile;
		endif;
					
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	   return $return_string;	


	}
	add_shortcode('sentient_blogs_normal_wide', 'sentient_blogs_normal_wide');

	
	/*------------------------------------------------------
	Sentient Blogs Normal - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Blogs Normal Wide" , "sentient"),
	   "base" => "sentient_blogs_normal_wide",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of blogs" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "3",
			 "description" => __("Number of blogs to display" , "sentient")
		  )
	   )
	) );

	/*------------------------------------------------------
	Sentient Blogs Normal Wide By Category - Shortcode
	-------------------------------------------------------*/
	function sentient_blogs_normal_wide_by_category( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '3' , 'postcategory' => ''), $atts));
		
		global $prof_default;
		$SentientPostBy = __("Posted By: " , "sentient");
		$category_id = get_cat_ID($postcategory);
		$loop = new WP_Query(array('post_type' => 'post', 'posts_per_page' => $noofposts, 'cat' => $category_id));			

		$return_string = '<div class="sentient-blog-normal-container sentient-blog-normal-wide-container"><ul>';
		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();
		if(get_comments_number( '0', '1', '%' ) == 1){
			$commenttext = get_comments_number( '0', '1', '%' ) . ' ' . __("Comment" , "sentient");
		} else {
			$commenttext = get_comments_number( '0', '1', '%' ) . ' ' . __("Comments" , "sentient");
		}
		
		$return_string .= '
				<li>
					<div class="sentient-blog-normal-thumb">';
					
		if(get_post_format() == false){			
			$return_string .= '<a href="'. esc_url(get_permalink()) .'">
							' . get_the_post_thumbnail( get_the_ID() , 'full' ) . '
							<i class="icon-pencil"></i>
							</a>';
		} elseif(has_post_format( 'gallery' )){
			$newstring = 'gallery putin="blogs" ';
			$oldstring = get_post_meta(get_the_ID(), 'Post Gallery Shortcode', true);
			$gallerycode = str_replace("gallery",$newstring,$oldstring); 	
			$return_string .=  do_shortcode($gallerycode) . '<i class="icon-camera"></i>';
		
		} elseif(has_post_format( 'audio' )){	
			$return_string .= '<div class="sentient-blog-normal-wide-thumb-audio"><i class="fa-volume-off"></i></div>';
		} elseif(has_post_format( 'link' )){	
			$return_string .= '<div class="sentient-blog-normal-wide-thumb-audio sentient-blog-normal-wide-thumb-link"><i class="icon-link"></i></div>';		
		} elseif(has_post_format( 'video' )){
			$return_string .= '<iframe width="100%" height="200px" src="' . esc_url(get_post_meta(get_the_ID(), 'Post Video URL', true)) . '"></iframe>';
		} elseif(has_post_format( 'chat' )){
			$return_string .= '<div class="sentient-blog-normal-wide-thumb-audio sentient-blog-normal-wide-thumb-chat"><i class="fa-quote-left"></i></div>';
		}

		$sentient_button_text = __("READ MORE" , "sentient");
		
		$return_string .= '</div>
					<div class="sentient-blog-normal-content-container">
						<div class="sentient-blog-normal-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-blog-normal-date-container">
							<span class="sentient-blog-normal-date">'. get_the_date() .'</span>
							<span class="sentient-blog-normal-date-seperator">.</span>
							<span class="sentient-blog-normal-comments"><a href="' . esc_url(get_comments_link(get_the_ID())) . '">' . $commenttext . '</a></span>
							<span class="sentient-blog-normal-date-seperator">.</span>
							<span class="sentient-blog-normal-date">' . $SentientPostBy . get_the_author() . '</span>
						</div>			
						<div class="sentient-blog-normal-text">
							' . strip_shortcodes(wp_trim_words( get_the_content(), 25 )) . '
						</div>
						<div class="sentient-blog-normal-link">
							<a style="background:' . of_get_option('sentient_blog_back',$prof_default) . ';border: 1px solid ' . of_get_option('sentient_blog_border',$prof_default) . '; color: ' . of_get_option('sentient_blog_color',$prof_default) . ';" href="'. esc_url(get_permalink()) .'" class="sentient-button sentient-button-opacity medium-size">' . $sentient_button_text . '</a>
						</div>					
					</div>				
				</li>';
		endwhile;
		endif;
					
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	   return $return_string;	


	}
	add_shortcode('sentient_blogs_normal_wide_by_category', 'sentient_blogs_normal_wide_by_category');

	
	/*------------------------------------------------------
	Sentient Blogs Normal By Category - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Blogs Normal Wide By Category" , "sentient"),
	   "base" => "sentient_blogs_normal_wide_by_category",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of blogs" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "3",
			 "description" => __("Number of blogs to display" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please select a category" , "sentient"),
			 "param_name" => "postcategory",
			 "value" => $sentient_cat_arr,
			 "description" => __("Category that you would like to retrieve posts depending on it" , "sentient")
		  )
	   )
	) );	
	
	/*------------------------------------------------------
	Sentient Blogs Slider - Shortcode
	-------------------------------------------------------*/
	function sentient_blogs_slider( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '3'), $atts));
		
		global $prof_default;
		$loop = new WP_Query(array('post_type' => 'post', 'posts_per_page' => $noofposts));
		$return_string = '<div class="sentient-blog-normal-container sentient-blog-slider-container"><ul class="slides">';
		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();
		if(get_comments_number( '0', '1', '%' ) == 1){
			$commenttext = get_comments_number( '0', '1', '%' ) . ' ' . __("Comment" , "sentient");
		} else {
			$commenttext = get_comments_number( '0', '1', '%' ) . ' ' . __("Comments" , "sentient");
		}
		
		$return_string .= '
				<li>
					<div class="sentient-blog-normal-thumb">';
					
		if(get_post_format() == false){			
			$return_string .= '<a href="'. esc_url(get_permalink()) .'">
							' . get_the_post_thumbnail( get_the_ID() , 'full' ) . '
							<i class="icon-pencil"></i>
							</a>';
		} elseif(has_post_format( 'gallery' )){
			$newstring = 'gallery putin="blogs" ';
			$oldstring = get_post_meta(get_the_ID(), 'Post Gallery Shortcode', true);
			$gallerycode = str_replace("gallery",$newstring,$oldstring); 	
			$return_string .=  do_shortcode($gallerycode) . '<i class="icon-camera"></i>';
		
		} elseif(has_post_format( 'audio' )){	
				$return_string .= '<div class="sentient-blog-normal-thumb-audio sentient-blog-normal-thumb-audio-slider"><i class="fa-volume-off"></i></div>';
		} elseif(has_post_format( 'link' )){	
				$return_string .= '<div class="sentient-blog-normal-thumb-audio sentient-blog-normal-thumb-link-slider"><i class="icon-link"></i></div>';			
		} elseif(has_post_format( 'video' )){
			$return_string .= '<iframe width="100%" height="152px" src="' . esc_url(get_post_meta(get_the_ID(), 'Post Video URL', true)) . '"></iframe>';
		} elseif(has_post_format( 'chat' )){
			$return_string .= '<div class="sentient-blog-normal-thumb-audio sentient-blog-normal-thumb-chat-slider"><i class="fa-quote-left"></i></div>';
		}

		
		$return_string .= '</div>
					<div class="sentient-blog-normal-content-container">
						<div class="sentient-blog-normal-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-blog-normal-date-container">
							<span class="sentient-blog-normal-date">'. get_the_date() .'</span>
							<span class="sentient-blog-normal-date-seperator">.</span>
							<span class="sentient-blog-normal-comments"><a href="' . esc_url(get_comments_link(get_the_ID())) . '">' . $commenttext . '</a></span>
						</div>			
						<div class="sentient-blog-normal-text">
							' . strip_shortcodes(wp_trim_words( get_the_content(), 12 )) . '
						</div>						
					</div>				
				</li>';
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	   return $return_string;	


	}
	add_shortcode('sentient_blogs_slider', 'sentient_blogs_slider');
	
	
	/*------------------------------------------------------
	Sentient Blogs Slider - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Blogs Slider" , "sentient"),
	   "base" => "sentient_blogs_slider",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of blogs" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "3",
			 "description" => __("Number of blogs to display" , "sentient")
		  )
	   )
	) );

	
	/*------------------------------------------------------
	Sentient Blogs Slider with Category - Shortcode
	-------------------------------------------------------*/
	function sentient_blogs_slider_category( $atts, $content = null ) {
		extract(shortcode_atts(array('noofposts' => '3' , 'postcategory' => ''), $atts));
		
		global $prof_default;
		$category_id = get_cat_ID($postcategory);
		$loop = new WP_Query(array('post_type' => 'post', 'posts_per_page' => $noofposts, 'cat' => $category_id));
		$return_string = '<div class="sentient-blog-normal-container sentient-blog-slider-container"><ul class="slides">';
		if ( $loop ) :   
		while ( $loop->have_posts() ) : $loop->the_post();
		if(get_comments_number( '0', '1', '%' ) == 1){
			$commenttext = get_comments_number( '0', '1', '%' ) . ' ' . __("Comment" , "sentient");
		} else {
			$commenttext = get_comments_number( '0', '1', '%' ) . ' ' . __("Comments" , "sentient");
		}
		
		$return_string .= '
				<li>
					<div class="sentient-blog-normal-thumb">';
					
		if(get_post_format() == false){			
			$return_string .= '<a href="'. esc_url(get_permalink()) .'">
							' . get_the_post_thumbnail( get_the_ID() , 'full' ) . '
							<i class="icon-pencil"></i>
							</a>';
		} elseif(has_post_format( 'gallery' )){
			$newstring = 'gallery putin="blogs" ';
			$oldstring = get_post_meta(get_the_ID(), 'Post Gallery Shortcode', true);
			$gallerycode = str_replace("gallery",$newstring,$oldstring); 	
			$return_string .=  do_shortcode($gallerycode) . '<i class="icon-camera"></i>';
		
		} elseif(has_post_format( 'audio' )){	
				$return_string .= '<div class="sentient-blog-normal-thumb-audio sentient-blog-normal-thumb-audio-slider"><i class="fa-volume-off"></i></div>';
		} elseif(has_post_format( 'link' )){	
				$return_string .= '<div class="sentient-blog-normal-thumb-audio sentient-blog-normal-thumb-link-slider"><i class="icon-link"></i></div>';			
		} elseif(has_post_format( 'video' )){
			$return_string .= '<iframe width="100%" height="152px" src="' . esc_url(get_post_meta(get_the_ID(), 'Post Video URL', true)) . '"></iframe>';
		} elseif(has_post_format( 'chat' )){
			$return_string .= '<div class="sentient-blog-normal-thumb-audio sentient-blog-normal-thumb-chat-slider"><i class="fa-quote-left"></i></div>';
		}

		
		$return_string .= '</div>
					<div class="sentient-blog-normal-content-container">
						<div class="sentient-blog-normal-title">
							<a href="'. esc_url(get_permalink()) .'">'. get_the_title() .'</a>
						</div>
						<div class="sentient-blog-normal-date-container">
							<span class="sentient-blog-normal-date">'. get_the_date() .'</span>
							<span class="sentient-blog-normal-date-seperator">.</span>
							<span class="sentient-blog-normal-comments"><a href="' . esc_url(get_comments_link(get_the_ID())) . '">' . $commenttext . '</a></span>
						</div>			
						<div class="sentient-blog-normal-text">
							' . strip_shortcodes(wp_trim_words( get_the_content(), 12 )) . '
						</div>						
					</div>				
				</li>';
		endwhile;
		endif;
		wp_reset_query();	
		
		$return_string .= '</ul></div>';
	   return $return_string;	


	}
	add_shortcode('sentient_blogs_slider_category', 'sentient_blogs_slider_category');
	
	
	/*------------------------------------------------------
	Sentient Blogs Slider with Category - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Blogs Slider By Category" , "sentient"),
	   "base" => "sentient_blogs_slider_category",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(	  
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter No.# of blogs" , "sentient"),
			 "param_name" => "noofposts",
			 "value" => "3",
			 "description" => __("Number of blogs to display" , "sentient")
		  ),
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please select a category" , "sentient"),
			 "param_name" => "postcategory",
			 "value" => $sentient_cat_arr,
			 "description" => __("Category that you would like to retrieve posts depending on it" , "sentient")
		  )
	   )
	) );	

	/*------------------------------------------------------
	Sentient Clients Slider
	-------------------------------------------------------*/
	function sentient_clients_slider($atts, $content = null) {
		extract(shortcode_atts(array('images' => ''), $atts));
		   
		$returnedvalue = '';
		$splitImagesArray = explode(",", $images);
		$splitImagesArraySize = count($splitImagesArray);


		$returnedvalue .= '<div class="sentient-clients-slider-container"><ul class="slides">';

		for ($x=0; $x < $splitImagesArraySize; $x++)
		{
			$getimageurlarray = wp_get_attachment_image_src( $splitImagesArray[$x] , 'full');
			
			$alt = get_post_meta($splitImagesArray[$x], '_wp_attachment_image_alt', true);
			
			$returnedvalue .= '<li><img src="' . $getimageurlarray[0] . '" alt="' . $alt . '" /></li>';
		} 

		$returnedvalue .= '</ul></div>';
		  
		return $returnedvalue;

	}
	add_shortcode('sentient_clients_slider', 'sentient_clients_slider');

	
	/*------------------------------------------------------
	Sentient Homepage Row Start - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Clients Slider" , "sentient"),
	   "base" => "sentient_clients_slider",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "attach_images",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Clients Images" , "sentient"),
			 "param_name" => "images",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("Upload your images here" , "sentient")
		  )
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Gallery Images
	-------------------------------------------------------*/
	function sentient_gallery($atts, $content = null) {
		extract(shortcode_atts(array('images' => ''), $atts));
		   
		$returnedvalue = '';
		$splitImagesArray = explode(",", $images);
		$splitImagesArraySize = count($splitImagesArray);

		$returnedvalue = do_shortcode('[gallery mood="slideshow" ids="'. $images .'"]');

		return $returnedvalue;

	}
	add_shortcode('sentient_gallery', 'sentient_gallery');

	
	/*------------------------------------------------------
	Sentient Homepage Row Start - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Gallery Images" , "sentient"),
	   "base" => "sentient_gallery",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "attach_images",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Gallery Images" , "sentient"),
			 "param_name" => "images",
			 "value" => $sentient_yes_no_arr,
			 "description" => __("Upload your images here" , "sentient")
		  )
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Social Icons
	-------------------------------------------------------*/

	function sentient_social_media($atts, $content = null) {
	   extract(shortcode_atts(array('type' => '' , 'link' => '#' , 'color' => '#6D6D6D'), $atts));
	   
		if($type == 'google'){$geticon = 'gplus'; $getname = 'Google+';} else {$geticon = $type; $getname = $type;}
	   return '
		<div class="sentient-social-shortcode-container sentient-social-'. $type .'">
			<div class="sentient-header-top-popup-container animated">
				<span class="sentient-tooltip">' . esc_attr($getname) . '</span>
			</div>		
			<span class="sentient-header-top-info-'. esc_attr($type) .'"><a target="_blank" href="'. esc_url($link) .'"><i style="color:' . $color .  ';" class="icon-'. $geticon .'"></i></a></span>
		</div>	
		';
	}
	add_shortcode('social_media', 'sentient_social_media');

	
	/*------------------------------------------------------
	Sentient Social Icons - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Social Icons" , "sentient"),
	   "base" => "social_media",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter URL" , "sentient"),
			 "param_name" => "link",
			 "value" => "http://www.example.com",
			 "description" => __("URL fr the selected social icon" , "sentient")
		  ),array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Icons Color" , "sentient"),
			 "param_name" => "color",
			 "value" => "#6D6D6D",
			 "description" => __("Please Choose Icons Color" , "sentient")
		  ),     
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose icon" , "sentient"),
			 "param_name" => "type",
			 "value" => $sentient_social_icon,
			 "description" => __("Choose any of the available icons" , "sentient")
		  )
	   )
	) );

	

	/*------------------------------------------------------
	Sentient Social Icons Style 2
	-------------------------------------------------------*/
	function sentient_social_media_style_two($atts, $content = null) {
	   extract(shortcode_atts(array('type' => '' , 'link' => '#' , 'color' => '#6D6D6D'), $atts));

	   
	   if($type == 'google'){$geticon = 'gplus'; $getname = 'Google+';} else {$geticon = $type; $getname = $type;}
	   return '
		<div class="sentient-social-shortcode-container sentient-social-shortcode-style-two-container sentient-social-'. esc_attr($type) .'">
			<div class="sentient-header-top-popup-container animated">
				<div class="sentient-header-top-popup">' . esc_attr($getname) . '</div>
				<div class="sentient-header-search-pointer-main"><div class="sentient-header-search-pointer">&#9652;</div></div>
			</div>		
			<span class="sentient-header-top-info-'. esc_attr($type) .'"><a target="_blank" href="'. esc_url($link) .'"><i style="color:' . $color .  ';" class="icon-'. esc_attr($type) .'"></i></a></span>
		</div>
		';
	}
	add_shortcode('social_media_style_two', 'sentient_social_media_style_two');

	
	/*------------------------------------------------------
	Sentient Social Icons - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Social Icons Style 2" , "sentient"),
	   "base" => "social_media_style_two",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter URL" , "sentient"),
			 "param_name" => "link",
			 "value" => "http://www.example.com",
			 "description" => __("URL fr the selected social icon" , "sentient")
		  ),array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Icons Color" , "sentient"),
			 "param_name" => "color",
			 "value" => "#6D6D6D",
			 "description" => __("Please Choose Icons Color" , "sentient")
		  ),     
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose icon" , "sentient"),
			 "param_name" => "type",
			 "value" => $sentient_social_icon,
			 "description" => __("Choose any of the available icons" , "sentient")
		  )
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient List Item
	-------------------------------------------------------*/
	function sentient_list_items($atts, $content = null) {
	   extract(shortcode_atts(array('items' => '', 'itemswidth' => '3'), $atts));
	   
	   if($itemswidth == 1){
		$list_class_name = 'sentient-list-one-col';
	   } else if ($itemswidth == 2){
		$list_class_name = 'sentient-list-two-col';
	   } else if ($itemswidth == 3){
		$list_class_name = 'sentient-list-three-col';   
	   } else if ($itemswidth == 4){
		$list_class_name = 'sentient-list-four-col';
	   } else if ($itemswidth == 'twothree'){
		$list_class_name = 'sentient-list-two-three-col';
	   } else if ($itemswidth == 'onethree'){
		$list_class_name = 'sentient-list-one-three-col';	
	   } else {
		$list_class_name = 'sentient-list-one-col';   
	   }
	   
	   return '
		<div class="sentient-list-items">
			<ul class="' . esc_attr($list_class_name) . '">
			' . $items . '
			</ul>
		</div>	
		';
	}
	add_shortcode('sentient_list_items', 'sentient_list_items');

	
	/*------------------------------------------------------
	Sentient Social Icons - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Items list" , "sentient"),
	   "base" => "sentient_list_items",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "dropdown",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please choose items width" , "sentient"),
			 "param_name" => "itemswidth",
			 "value" => $sentient_items_width,
			 "description" => __("Choose Items width" , "sentient")
		  ),
		 array(
			 "type" => "textarea",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter item list" , "sentient"),
			 "param_name" => "items",
			 "value" => "<li>Item Goes here</li>",
			 "description" => __("Please make sure that each item should start with < li > tag and ends with < /li > tag" , "sentient")
		  )	  
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Percentage Bar - Shortcode
	-------------------------------------------------------*/
	function sentient_percentage_bar($atts, $content = null) {
	   extract(shortcode_atts(array('percentage' => '50%' ,  'title' => 'Title goes here'), $atts));
	   return '	
		<div class="sentient-progress-bar-main-container">
		<div class="progress-bar-upper-container">
			'. $title .'
		</div>
		<div>
			<div class="progress-bar bar-container">	
			  <div class="sentient-bar-container-bar sentient-bar-container-bar-remove" style="width: '. $percentage .';"></div>
			</div>
			<div class="progress-bar-percentage-text">'. esc_attr($percentage) .'</div>
		</div>
		</div>
		';
	}
	add_shortcode('sentient_percentage_bar', 'sentient_percentage_bar');

	
	/*------------------------------------------------------
	Sentient Percentage Bar - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Percentage Bar" , "sentient"),
	   "base" => "sentient_percentage_bar",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Bar Title" , "sentient"),
			 "param_name" => "title",
			 "value" => "Title goes here",
			 "description" => __("Enter Bar Title" , "sentient")
		  )	,
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter percentage" , "sentient"),
			 "param_name" => "percentage",
			 "value" => "50%",
			 "description" => __("Enter the value of Percentage" , "sentient")
		  )	  
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Percentage Circle - Shortcode
	-------------------------------------------------------*/
	function sentient_percentage_circle($atts, $content = null) {
	   extract(shortcode_atts(array('percentage' => '50' ,  'title' => 'Title goes here',  'color' => '#2dd2fb'), $atts));
	   
	   $getcorrectbodyfont = str_replace('+', ' ', of_get_option('select_font',$prof_default));
	   
	   return '
		<div class="sentient-rotator-container sentient-rotator-container-show">
			<div style="width:165px; height:165px;" class="sentient-rotator" data-sentient-percentage="'. $percentage .'" data-sentient-percentage-color="'. $color .'" data-sentient-font="'. $getcorrectbodyfont .'">
			</div>
			<div class="sentient-rotator-title">
				' . esc_attr($title) . '
			</div>
		</div>
		';
	}
	add_shortcode('sentient_percentage_circle', 'sentient_percentage_circle');

	
	/*------------------------------------------------------
	Sentient Percentage Bar - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Percentage Circle" , "sentient"),
	   "base" => "sentient_percentage_circle",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array(
		  array(
			 "type" => "colorpicker",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Circle color" , "sentient"),
			 "param_name" => "color",
			 "value" => "#2dd2fb",
			 "description" => __("Please Choose Circle color" , "sentient")
		  ),   
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Percentage Circle Title" , "sentient"),
			 "param_name" => "title",
			 "value" => "Title goes here",
			 "description" => __("Enter Percentage Circle Title" , "sentient")
		  )	,
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter percentage (ONLY NUMBER)" , "sentient"),
			 "param_name" => "percentage",
			 "value" => "50",
			 "description" => __("Enter the value of Percentage (ONLY NUMBER)" , "sentient")
		  )	  
	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Pricing Table - Shortcode
	-------------------------------------------------------*/
	function sentient_price_item($atts, $content = null) {
	   extract(shortcode_atts(array('type' => 'Free' , 'price' => '0', 'period' => '30 day trial', 'buttonname' => 'Sign Up' , 'link' => '#', 'pricecontent' => '', 'currency' => '$', 'starting' => ''), $atts));
	   $getstring = '';

	   $getstring .= '
		<div class="pricing-column sentient-button-opacity rounded-corners">
			<div class="sentient-pricing-main-title">
				<span>'. esc_attr($type) .'</span>
			</div>
			<div class="pricing-title">';
			
			if($starting != ''){
				$getstring .= '<div class="pricing-period pricing-period-top rounded-corners">'. esc_attr($starting) .'</div>';
			} else {
				$getstring .= '';
			}
			
			$getstring .= '<div class="pricing-title-price"><span class="pricing-title-currency">'. esc_attr($currency) .'</span><span class="pricing-title-amount">' . esc_attr($price) . '</span></div>
				<div class="pricing-period rounded-corners">'. esc_attr($period) .'</div>
			</div>
			<div class="pricing-description">
				<ul>
					'. $pricecontent .'
				</ul>
			</div>
			<div class="pricing-button">
				<a href="'. esc_url($link) .'" class="sentient-button sentient-button-opacity sentient-pricing-button"><span>'. esc_attr($buttonname) .'</span></a>
			</div>		
		</div>';
		
		return $getstring;
	}
	add_shortcode('sentient_price_item', 'sentient_price_item');

	
	/*------------------------------------------------------
	Sentient Percentage Bar - VC
	-------------------------------------------------------*/

	vc_map( array(
	   "name" => __("Sentient Regular Price Item" , "sentient"),
	   "base" => "sentient_price_item",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array( 
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Pricing Type" , "sentient"),
			 "param_name" => "type",
			 "value" => "Pricing Type goes here",
			 "description" => __("Please enter Pricing Type" , "sentient")
		  )	,
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter the Price" , "sentient"),
			 "param_name" => "price",
			 "value" => "$50",
			 "description" => __("Please enter the Price" , "sentient")
		  )	,
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Pricing Currency" , "sentient"),
			 "param_name" => "currency",
			 "value" => "$",
			 "description" => __("Please enter Pricing Currency" , "sentient")
		  ),
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Pricing Period" , "sentient"),
			 "param_name" => "period",
			 "value" => "Per Month",
			 "description" => __("Please enter Pricing Period" , "sentient")
		  )	,
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Starting from text" , "sentient"),
			 "param_name" => "starting",
			 "value" => "",
			 "description" => __("Please enter Starting from text or keep it empty to hide it" , "sentient")
		  ),
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Pricing Button Title" , "sentient"),
			 "param_name" => "buttonname",
			 "value" => "Sign up",
			 "description" => __("Please enter Pricing Button Title" , "sentient")
		  )	,
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Button Redirect URL" , "sentient"),
			 "param_name" => "link",
			 "value" => "#",
			 "description" => __("Please enter Button Redirect URL" , "sentient")
		  )	,
		 array(
			 "type" => "textarea",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Pricing Content" , "sentient"),
			 "param_name" => "pricecontent",
			 "value" => "<li>Item Description One</li><li>Item Description Two</li>",
			 "description" => __("Please note that each item description should be in < li > < / li >" , "sentient")
		  )		

	   )
	) );

	
	
	/*------------------------------------------------------
	Sentient Main Pricing Table - Shortcode - Shortcode
	-------------------------------------------------------*/
	function sentient_price_item_main($atts, $content = null) {
		extract(shortcode_atts(array('type' => 'Free' , 'price' => '$0', 'period' => '30 day trial', 'buttonname' => 'Sign Up' , 'link' => '#', 'pricecontent' => '', 'currency' => '$', 'starting' => ''), $atts));
		$returnstring = '';
	   $returnstring .= '
		<div class="pricing-column pricing-main-column rounded-corners">
			<div class="sentient-pricing-main-title">
				<span>'. esc_attr($type) .'</span>
			</div>
			<div class="pricing-title">';
				
			if($starting != ''){
				$returnstring .= '<div class="pricing-period pricing-period-top rounded-corners">'. esc_attr($starting) .'</div>';
			} else {
				$returnstring .= '';
			}
				
				
		$returnstring .='<div class="pricing-title-price"><span class="pricing-title-currency">'. esc_attr($currency) .'</span><span class="pricing-title-amount">' . esc_attr($price) . '</span></div>
				<div class="pricing-period rounded-corners">'. esc_attr($period) .'</div>
			</div>
			<div class="pricing-description">
				<ul>
					'. $pricecontent .'
				</ul>
			</div>
			<div class="pricing-button">
				<a href="'. esc_url($link) .'" class="sentient-button sentient-button-opacity sentient-pricing-button"><span>'. esc_attr($buttonname) .'</span></a>
			</div>		
		</div>';
		
		return $returnstring;
	}
	add_shortcode('sentient_price_item_main', 'sentient_price_item_main');
	
	
	/*------------------------------------------------------
	Sentient Main Pricing Table - VC
	-------------------------------------------------------*/
	vc_map( array(
	   "name" => __("Sentient Main Price Item" , "sentient"),
	   "base" => "sentient_price_item_main",
	   "class" => "",
	   "category" => __('Content' , "sentient"),
	   "params" => array( 
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Pricing Type" , "sentient"),
			 "param_name" => "type",
			 "value" => "Pricing Type goes here",
			 "description" => __("Please enter Pricing Type" , "sentient")
		  )	,
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter the Price" , "sentient"),
			 "param_name" => "price",
			 "value" => "50",
			 "description" => __("Please enter the Price" , "sentient")
		  )	,
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Pricing Currency" , "sentient"),
			 "param_name" => "currency",
			 "value" => "$",
			 "description" => __("Please enter Pricing Currency" , "sentient")
		  ),
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Pricing Period" , "sentient"),
			 "param_name" => "period",
			 "value" => "Per Month",
			 "description" => __("Please enter Pricing Period" , "sentient")
		  )	,
		  array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Starting from text" , "sentient"),
			 "param_name" => "starting",
			 "value" => "",
			 "description" => __("Please enter Starting from text or keep it empty to hide it" , "sentient")
		  ),
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Pricing Button Title" , "sentient"),
			 "param_name" => "buttonname",
			 "value" => "Sign up",
			 "description" => __("Please enter Pricing Button Title" , "sentient")
		  )	,
		 array(
			 "type" => "textfield",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Button Redirect URL" , "sentient"),
			 "param_name" => "link",
			 "value" => "#",
			 "description" => __("Please enter Button Redirect URL" , "sentient")
		  )	,
		 array(
			 "type" => "textarea",
			 "holder" => "div",
			 "class" => "",
			 "heading" => __("Please enter Pricing Content" , "sentient"),
			 "param_name" => "pricecontent",
			 "value" => "<li>Item Description One</li><li>Item Description Two</li>",
			 "description" => __("Please note that each item description should be in < li > < / li >" , "sentient")
		  )		

	   )
	) );

}



/*------------------------------------------------------
Sentient Sidebar Functions - Started
-------------------------------------------------------*/

if ( function_exists('register_sidebar') ){
register_sidebar(array(
	'name' => 'default',
	'before_widget' => '<div id="%1$s" class="proftheme-widget %2$s">' ,
	'after_widget' =>  '</div>',
	'before_title' => '<div class="sidebar-title"><h5>',
	'after_title' => '<span class="footer-title-underline"></span></h5></div>',
));
//************************
register_sidebar(array(
	'name' => 'Sidebar I',
	'before_widget' => '<div id="%1$s" class="proftheme-widget %2$s">',
	'after_widget' => '</div>',
	'before_title' => '<div class="sidebar-title"><h5>',
	'after_title' => '<span class="footer-title-underline"></span></h5></div>',
));
//************************
register_sidebar(array('name'=>'Sidebar II',
'before_widget' => '<div id="%1$s" class="proftheme-widget %2$s">',
'after_widget' => '</div>',
'before_title' => '<div class="sidebar-title"><h5>',
'after_title' => '<span class="footer-title-underline"></span></h5></div>',
));
//************************
register_sidebar(array('name'=>'Sidebar III',
'before_widget' => '<div id="%1$s" class="proftheme-widget %2$s">',
'after_widget' => '</div>',
'before_title' => '<div class="sidebar-title"><h5>',
'after_title' => '<span class="footer-title-underline"></span></h5></div>',

));
//************************
register_sidebar(array('name'=>'Sidebar IV',
'before_widget' => '<div id="%1$s" class="proftheme-widget %2$s">',
'after_widget' => '</div>',
'before_title' => '<div class="sidebar-title"><h5>',
'after_title' => '<span class="footer-title-underline"></span></h5></div>',

));
//************************
register_sidebar(array('name'=>'Sidebar V',
'before_widget' => '<div id="%1$s" class="proftheme-widget %2$s">',
'after_widget' => '</div>',
'before_title' => '<div class="sidebar-title"><h5>',
'after_title' => '<span class="footer-title-underline"></span></h5></div>',

));
//************************
register_sidebar(array('name'=>'Sidebar VI',
'before_widget' => '<div id="%1$s" class="proftheme-widget %2$s">',
'after_widget' => '</div>',
'before_title' => '<div class="sidebar-title"><h5>',
'after_title' => '<span class="footer-title-underline"></span></h5></div>',

));
//************************
register_sidebar(array('name'=>'Sidebar VII',
'before_widget' => '<div id="%1$s" class="proftheme-widget %2$s">',
'after_widget' => '</div>',
'before_title' => '<div class="sidebar-title"><h5>',
'after_title' => '<span class="footer-title-underline"></span></h5></div>',

));
//************************
register_sidebar(array('name'=>'Sidebar VIII',
'before_widget' => '<div id="%1$s" class="proftheme-widget %2$s">',
'after_widget' => '</div>',
'before_title' => '<div class="sidebar-title"><h5>',
'after_title' => '<span class="footer-title-underline"></span></h5></div>',

));
//************************
register_sidebar(array('name'=>'Footer Col 1',
'before_widget' => '<div class="footer-col-one footer-col-one-add-style"><div id="%1$s" class="proftheme-widget %2$s">',
'after_widget' => '</div></div>',
'before_title' => '<div class="footer-heading">',
'after_title' => '</div>',
));
//************************
register_sidebar(array('name'=>'Footer Col 2',
'before_widget' => '<div class="footer-col-one footer-col-two-add-style  footer-divider"><div id="%1$s" class="proftheme-widget %2$s">',
'after_widget' => '</div></div>',
'before_title' => '<div class="footer-heading">',
'after_title' => '</div>',
));
//************************
register_sidebar(array('name'=>'Footer Col 3',
'before_widget' => '<div class="footer-col-one footer-col-four-add-style  footer-divider"><div id="%1$s" class="proftheme-widget %2$s">',
'after_widget' => '</div></div>',
'before_title' => '<div class="footer-heading">',
'after_title' => '</div>',
));
//************************
register_sidebar(array('name'=>'Footer Col 4',
'before_widget' => '<div class="footer-col-one footer-col-four-add-style footer-col-last-add-style  footer-divider"><div id="%1$s" class="proftheme-widget %2$s">',
'after_widget' => '</div></div>',
'before_title' => '<div class="footer-heading">',
'after_title' => '</div>',
));
}

/*------------------------------------------------------
Sentient Sidebar Functions - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient Recent Comments Widget - Started
-------------------------------------------------------*/
class Sentient_WP_Widget_Recent_Comments extends WP_Widget_Recent_Comments {

	function __construct() {
		$widget_ops = array('classname' => 'widget_recent_comments', 'description' => __( 'Your site&#8217;s most recent comments.' , "sentient") );
		parent::__construct('recent-comments', __('Recent Comments', "sentient"), $widget_ops);
		$this->alt_option_name = 'widget_recent_comments';

		if ( is_active_widget(false, false, $this->id_base) )
			add_action( 'wp_head', array($this, 'recent_comments_style') );

		add_action( 'comment_post', array($this, 'flush_widget_cache') );
		add_action( 'edit_comment', array($this, 'flush_widget_cache') );
		add_action( 'transition_comment_status', array($this, 'flush_widget_cache') );
	}

	function recent_comments_style() {
		if ( ! current_theme_supports( 'widgets' ) // Temp hack #14876
			|| ! apply_filters( 'show_recent_comments_widget_style', true, $this->id_base ) )
			return;
		?>
	<style type="text/css">.recentcomments a{display:inline !important;padding:0 !important;margin:0 !important;}</style>
<?php
	}

	function flush_widget_cache() {
		wp_cache_delete('widget_recent_comments', 'widget');
	}

	function widget( $args, $instance ) {
		global $comments, $comment;

		$cache = wp_cache_get('widget_recent_comments', 'widget');

		if ( ! is_array( $cache ) )
			$cache = array();

		if ( ! isset( $args['widget_id'] ) )
			$args['widget_id'] = $this->id;

		if ( isset( $cache[ $args['widget_id'] ] ) ) {
			echo $cache[ $args['widget_id'] ];
			return;
		}

 		extract($args, EXTR_SKIP);
 		$output = '';

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent Comments' , "sentient");
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 5;
		if ( ! $number )
 			$number = 5;

		$comments = get_comments( apply_filters( 'widget_comments_args', array( 'number' => $number, 'status' => 'approve', 'post_status' => 'publish' ) ) );
		$output .= $before_widget;
		if ( $title )
			$output .= $before_title . $title . $after_title;

		$output .= '<ul id="recentcomments">';
		if ( $comments ) {
			// Prime cache for associated posts. (Prime post term cache if we need it for permalinks.)
			$post_ids = array_unique( wp_list_pluck( $comments, 'comment_post_ID' ) );
			_prime_post_caches( $post_ids, strpos( get_option( 'permalink_structure' ), '%category%' ), false );

			foreach ( (array) $comments as $comment) {
				$output .=  '<li class="recentcomments">' .
				'<span class="sentient-comments-author"><a href="' . esc_url(get_comment_link($comment->comment_ID)) . '">' . get_comment_author($comment->comment_ID) . '</a></span> - ' .
				human_time_diff( get_comment_date('U' , $comment->comment_ID ), current_time('timestamp') ) . ' ago' .
				'<span class="sentient-comments-content">' . strip_shortcodes(wp_trim_words( get_comment_text( $comment->comment_ID ), 9 )) . '</span>' .
				'</li>';
			}
 		}
		$output .= '</ul>';
		$output .= $after_widget;

		echo $output;
		$cache[$args['widget_id']] = $output;
		wp_cache_set('widget_recent_comments', $cache, 'widget');
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = absint( $new_instance['number'] );
		$this->flush_widget_cache();

		$alloptions = wp_cache_get( 'alloptions', 'options' );
		if ( isset($alloptions['widget_recent_comments']) )
			delete_option('widget_recent_comments');

		return $instance;
	}

	function form( $instance ) {
		$title  = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' , "sentient"); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of comments to show:' , "sentient"); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>
<?php
	}
}

/*------------------------------------------------------*/

function sentient_recent_comments_registration() {
	unregister_widget('WP_Widget_Recent_Comments');
	register_widget('Sentient_WP_Widget_Recent_Comments');
}


/*------------------------------------------------------
Sentient Recent Comments Widget - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient Recent Posts Widget - End
-------------------------------------------------------*/
class Sentient_WP_Widget_Recent_Posts extends WP_Widget_Recent_Posts {

	function __construct() {
		$widget_ops = array('classname' => 'widget_recent_entries', 'description' => __( "Your site&#8217;s most recent Posts.", "sentient") );
		parent::__construct('recent-posts', __('Recent Posts', "sentient"), $widget_ops);
		$this->alt_option_name = 'widget_recent_entries';

		add_action( 'save_post', array($this, 'flush_widget_cache') );
		add_action( 'deleted_post', array($this, 'flush_widget_cache') );
		add_action( 'switch_theme', array($this, 'flush_widget_cache') );
	}

	function widget($args, $instance) {
		$cache = wp_cache_get('widget_recent_posts', 'widget');

		if ( !is_array($cache) )
			$cache = array();

		if ( ! isset( $args['widget_id'] ) )
			$args['widget_id'] = $this->id;

		if ( isset( $cache[ $args['widget_id'] ] ) ) {
			echo $cache[ $args['widget_id'] ];
			return;
		}

		ob_start();
		extract($args);

		$title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : __( 'Recent Posts' , "sentient");
		$title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
		$number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 10;
		if ( ! $number )
 			$number = 10;
		$show_date = isset( $instance['show_date'] ) ? $instance['show_date'] : false;

		$r = new WP_Query( apply_filters( 'widget_posts_args', array( 'posts_per_page' => $number, 'no_found_rows' => true, 'post_status' => 'publish', 'ignore_sticky_posts' => true ) ) );
		if ($r->have_posts()) :
?>
		<?php echo $before_widget; ?>
		<?php if ( $title ) echo $before_title . $title . $after_title; ?>
		<ul id="sentient-recent-posts">
		<?php while ( $r->have_posts() ) : $r->the_post(); ?>
			<li class="sentient-widget-recent-post-item">
				<?php if ( has_post_format( 'video' )) {  ?>			
					<span class="sentient-widget-recent-post-thumb sentient-widget-recent-post-video">
						<i class="icon-play"></i>
					</span>
				<?php } else if( has_post_format( 'audio' )) { ?>
					<span class="sentient-widget-recent-post-thumb sentient-widget-recent-post-video sentient-widget-recent-post-audio">
						<i class="fa-volume-off"></i>
					</span>	
				<?php } else if( has_post_format( 'link' )) { ?>
					<span class="sentient-widget-recent-post-thumb sentient-widget-recent-post-video sentient-widget-recent-post-link">
						<i class="icon-link"></i>
					</span>
				<?php } else if( has_post_format( 'chat' ) || has_post_format( 'quote' ) ) { ?>
					<span class="sentient-widget-recent-post-thumb sentient-widget-recent-post-video sentient-widget-recent-post-chat">
						<i class="fa-quote-left"></i>
					</span>					
				<?php } else if(!has_post_thumbnail()) { ?>
					<span class="sentient-widget-recent-post-thumb sentient-widget-recent-post-video sentient-widget-recent-post-link">
						<i class="icon-pencil"></i>
					</span>				
				<?php } else { ?>
					<span class="sentient-widget-recent-post-thumb">
						<?php echo get_the_post_thumbnail( get_the_ID(), array(90,9999)); ?>
					</span>
				<?php } ?>
				<span class="sentient-widget-recent-post-content">
					<a class="sentient-widget-recent-post-title" href="<?php echo esc_url(the_permalink()); ?>"><?php get_the_title() ? the_title() : the_ID(); ?></a>
					<?php if ( $show_date ) : ?>
						<a class="sentient-widget-recent-post-bottom-links" href="<?php echo esc_url(the_permalink()); ?>"><span class="post-date sentient-widget-recent-post-date"><i class="icon-calendar"></i><?php echo get_the_date(); ?></span></a>
						<a class="sentient-widget-recent-post-bottom-links" href="<?php echo esc_url(the_permalink()); ?>"><span class="sentient-widget-recent-post-date"><i class="icon-comment"></i><?php comments_number( '0 comments', '1 comment', '% comments' ); ?></span></a>
					<?php endif; ?>				
				</span>
			</li>
		<?php endwhile; ?>
		</ul>
		<?php echo $after_widget; ?>
<?php
		// Reset the global $the_post as this query will have stomped on it
		wp_reset_postdata();

		endif;

		$cache[$args['widget_id']] = ob_get_flush();
		wp_cache_set('widget_recent_posts', $cache, 'widget');
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags($new_instance['title']);
		$instance['number'] = (int) $new_instance['number'];
		$instance['show_date'] = isset( $new_instance['show_date'] ) ? (bool) $new_instance['show_date'] : false;
		$this->flush_widget_cache();

		$alloptions = wp_cache_get( 'alloptions', 'options' );
		if ( isset($alloptions['widget_recent_entries']) )
			delete_option('widget_recent_entries');

		return $instance;
	}

	function flush_widget_cache() {
		wp_cache_delete('widget_recent_posts', 'widget');
	}

	function form( $instance ) {
		$title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
		$number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 5;
		$show_date = isset( $instance['show_date'] ) ? (bool) $instance['show_date'] : false;
?>
		<p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' , "sentient"); ?></label>
		<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo $title; ?>" /></p>

		<p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'Number of posts to show:', "sentient" ); ?></label>
		<input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo $number; ?>" size="3" /></p>

		<p><input class="checkbox" type="checkbox" <?php checked( $show_date ); ?> id="<?php echo $this->get_field_id( 'show_date' ); ?>" name="<?php echo $this->get_field_name( 'show_date' ); ?>" />
		<label for="<?php echo $this->get_field_id( 'show_date' ); ?>"><?php _e( 'Display post date?' , "sentient"); ?></label></p>
<?php
	}
}

/*-----------------------------------------------------*/

function sentient_recent_posts_registration() {
	unregister_widget('WP_Widget_Recent_Posts');
	register_widget('Sentient_WP_Widget_Recent_Posts');
}


/*------------------------------------------------------
Sentient Recent Posts Widget - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient, Add Testimonial Option to the Theme - Started
-------------------------------------------------------*/

add_action( 'init', 'sentient_register_cpt_testimonial' );

function sentient_register_cpt_testimonial() {

$labels = array(
	'name' => __( 'Testimonials', 'sentient' ),
	'singular_name' => __( 'testimonial', 'sentient' ),
	'add_new' => __( 'Add New', 'sentient' ),
	'add_new_item' => __( 'Add New testimonial', 'sentient' ),
	'edit_item' => __( 'Edit testimonial', 'sentient' ),
	'new_item' => __( 'New testimonial', 'sentient' ),
	'view_item' => __( 'View testimonial', 'sentient' ),
	'search_items' => __( 'Search Testimonials', 'sentient' ),
	'not_found' => __( 'No testimonials found', 'sentient' ),
	'not_found_in_trash' => __( 'No testimonials found in Trash', 'sentient' ),
	'parent_item_colon' => __( 'Parent testimonial:', 'sentient' ),
	'menu_name' => __( 'Testimonials', 'sentient' ),
);

$args = array(
	'labels' => $labels,
	'hierarchical' => false,

	'supports' => array( 'title', 'editor', 'author', 'thumbnail', 'revisions' ),

	'public' => true,
	'show_ui' => true,
	'show_in_menu' => true,
	  
	'show_in_nav_menus' => true,
	'publicly_queryable' => true,
	'exclude_from_search' => false,
	'has_archive' => true,
	'query_var' => true,
	'can_export' => true,
	'rewrite' => true,
	'capability_type' => 'post'
);

register_post_type( 'testimonial', $args );
}

/*------------------------------------------------------
Sentient, Add Testimonial Option to the Theme - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient, Add Team Members Option to the Theme - Started
-------------------------------------------------------*/

function sentient_register_cpt_team() {

$labels = array(
	'name' => __( 'Team', 'sentient' ),
	'singular_name' => __( 'Team', 'sentient' ),
	'add_new' => __( 'Add New', 'sentient' ),
	'add_new_item' => __( 'Add New Team Member', 'sentient' ),
	'edit_item' => __( 'Edit Team Member', 'sentient' ),
	'new_item' => __( 'New Team Member', 'sentient' ),
	'view_item' => __( 'View Team Member', 'sentient' ),
	'search_items' => __( 'Search Team Member', 'sentient' ),
	'not_found' => __( 'No Team Member found', 'sentient' ),
	'not_found_in_trash' => __( 'No Team Member found in Trash', 'sentient' ),
	'parent_item_colon' => __( 'Parent Team Member:', 'sentient' ),
	'menu_name' => __( 'Team', 'sentient' ),
);

$args = array(
	'labels' => $labels,
	'hierarchical' => false,

	'supports' => array( 'title', 'editor', 'author', 'thumbnail', 'revisions' ),

	'public' => true,
	'show_ui' => true,
	'show_in_menu' => true,
	  
	'show_in_nav_menus' => true,
	'publicly_queryable' => true,
	'exclude_from_search' => false,
	'has_archive' => true,
	'query_var' => true,
	'can_export' => true,
	'rewrite' => true,
	'capability_type' => 'post'
);

register_post_type( 'team', $args );
}

/*------------------------------------------------------
Sentient, Add Team Members Option to the Theme - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient, Add Portfolio Thumbnail URL option - Started
-------------------------------------------------------*/

function sentient_get_portfolio_thumbnail_url($pid){  
    $image_id = get_post_thumbnail_id($pid);  
    $image_url = wp_get_attachment_image_src($image_id,'screen-shot');  
    return  $image_url[0];  
}  

/*------------------------------------------------------
Sentient, Add Portfolio Thumbnail URL option - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient, Adds a box to the side column on the Post and Page edit screens - Started
-------------------------------------------------------*/
function sentient_add_sidebar_metabox()  
{  
    add_meta_box(  
        'custom_sidebar',  
        __( 'Custom Sidebar', 'proftheme' ),  
        'sentient_custom_sidebar_callback',  
        'post',  
        'side'  
    );  
    add_meta_box(
        'custom_sidebar',  
        __( 'Custom Sidebar', 'proftheme' ),  
        'sentient_custom_sidebar_callback',  
        'page',  
        'side'  
    );  
    add_meta_box(
        'custom_sidebar',  
        __( 'Custom Sidebar', 'proftheme' ),  
        'sentient_custom_sidebar_callback',  
        'project',  
        'side'  
    );

} 

function sentient_add_page_cats()
{
    register_taxonomy_for_object_type( 'category', 'post' );
}

function sentient_custom_sidebar_callback( $post )  
{  
    global $wp_registered_sidebars;  
      
    $custom = get_post_custom($post->ID);  
      
    if(isset($custom['custom_sidebar']))  
        $val = $custom['custom_sidebar'][0];  
    else  
        $val = "default";  
  
    // Use nonce for verification  
    wp_nonce_field( plugin_basename( __FILE__ ), 'custom_sidebar_nonce' );  
  
    // The actual fields for data entry  
    $output = '<p><label for="myplugin_new_field">'.__("Choose a sidebar to display", 'proftheme' ).'</label></p>';  
    $output .= "<select name='custom_sidebar'>";  
  // Add a default option  
    $output .= "<option";  
    if($val == "default")  
        $output .= " selected='selected'";  
    $output .= " value='default'>".__('default', 'my-text-domain' )."</option>";  
      
    // Fill the select element with all registered sidebars  
    foreach($wp_registered_sidebars as $sidebar_id => $sidebar)  
    {  
        $output .= "<option";  
        if($sidebar_id == $val)  
            $output .= " selected='selected'";  
        $output .= " value='".$sidebar_id."'>".$sidebar['name']."</option>";  
    }  
    
    $output .= "</select>";  
      
    echo $output;  
}

function sentient_save_sidebar_postdata( $post_id )  
{  
    // verify if this is an auto save routine.   
    // If it is our form has not been submitted, so we dont want to do anything  
    if ( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE )   
      return;  
  
    // verify this came from our screen and with proper authorization,  
    // because save_post can be triggered at other times  
  
	if(isset ($_POST['custom_sidebar_nonce'])){
		if ( !wp_verify_nonce( $_POST['custom_sidebar_nonce'], plugin_basename( __FILE__ ) ) )  
		  return; 
	}   
  
    if ( !current_user_can( 'edit_page', $post_id ) )  
        return;  
  
	if(isset ($_POST['custom_sidebar'])){
		$data = $_POST['custom_sidebar'];  
		update_post_meta($post_id, "custom_sidebar", $data);
	}     
}  
/*------------------------------------------------------
Sentient, Adds a box to the side column on the Post and Page edit screens - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient, breadcrumb functions - Started
-------------------------------------------------------*/

function sentient_bread_crumbs() {
	 global $post;
	 global $prof_default;
	 
	 $crumbs = '<a href="'. esc_url(home_url()) .'">Home</a>';

	 
	 //if the page is 404
	 if(is_404()) {
		$crumbs .= ' - ' . of_get_option('blank_page_title',$prof_default);
	 }
	
	
	 //if the page is search
	 if(is_search()) {
		$crumbs .=  ' - ' .  __("Search for : ' " , "sentient") . get_search_query() . " '";
	 }
	 
	 //if the page has a parent add title and link of parent
	 if(is_page() && $post->post_parent > 0) {
		/*$crumbs .=     ' - <a href="' . esc_url(get_permalink($post->post_parent)) .'">'.get_the_title($post->post_parent).'</a>';*/
		
		/*$crumbs .=     ' - ' ;*/
	 }	 

	 
	 //if the page has a parent add title and link of parent
	 if($post->post_parent > 0) {
		$crumbs .=     ' - <a href="' . esc_url(get_permalink($post->post_parent)) .'">'.get_the_title($post->post_parent).'</a>';
		
		/*$crumbs .=     ' - ' ;*/
	 }	 
	 
	 // if it's not the front page of the site, but isn't the blog either
	 if((!is_front_page()) && (is_page())) {
		$crumbs .=    ' - ' . get_the_title($post->ID);
	 }

	 //if it's the news/blog home page or any type of archive
	 if((is_home() ||(is_archive()))) {
		/*$crumbs .=    ' - ' . get_the_title(get_option('page_for_posts'));*/		
		
		$crumbs .=     ' - ' . get_the_title($post->ID);		
	 }

	 //if it's a single news/blog post
	 if(is_single()) {
		/*$crumbs .=     ' - <a href="' . esc_url(get_permalink(get_option('page_for_posts'))) .'">'.get_the_title(get_option('page_for_posts')).'</a>';*/
		
		$crumbs .=     ' - ' . get_the_title($post->ID);
	 }
	 

	 
	 $crumbs .=    '';
	 echo $crumbs;
}
/*------------------------------------------------------
Sentient, breadcrumb functions - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient Walker_Nav_Menu - Started
-------------------------------------------------------*/
class sentient_description_walker extends Walker_Nav_Menu
{
	  function start_el( &$output, $item, $depth = 0, $args = array(), $id = 0 )
      {
           global $wp_query;
           $indent = ( $depth ) ? str_repeat( "\t", $depth ) : '';

		   

			
           $class_names = $value = '';

           $classes = empty( $item->classes ) ? array() : (array) $item->classes;
			
			if($item->subtitle == 'yes'){$sentient_megamenu_containerclass = 'sentient-megamenu-container';} else {$sentient_megamenu_containerclass = '';}
			if($item->subtitletwo == 'yes'){$sentient_megamenu_titlecontainerclass = 'sentient-megamenu-title-container'; $sentient_megamenu_titlelinkclass = 'sentient-megamenu-it-is-title';} else {$sentient_megamenu_titlecontainerclass = ''; $sentient_megamenu_titlelinkclass = '';}
			
           $class_names = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
           $class_names = ' class="'. esc_attr( $class_names ) . ' ' . $sentient_megamenu_containerclass . ' ' . $sentient_megamenu_titlecontainerclass . '"';
		   
           $output .= $indent . '<li ' . $value . $class_names .'>';

           $attributes  = ! empty( $item->attr_title ) ? ' title="'  . esc_attr( $item->attr_title ) .'"' : '';
           $attributes .= ! empty( $item->target )     ? ' target="' . esc_attr( $item->target     ) .'"' : '';
           $attributes .= ! empty( $item->xfn )        ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
           $attributes .= ! empty( $item->url )        ? ' href="'   . esc_attr( $item->url        ) .'"' : '';

           /*$prepend = '<strong>';
           $append = '</strong>';*/
		   
           $prepend = '';
           $append = '';
		   
           $description  = ! empty( $item->description ) ? '<span class="menu-item-description">'.esc_attr( $item->description ).'</span>' : '';

           if($depth != 0)
           {
                     $description = $append = $prepend = "";
           }
			/* Has children */
			$children = get_posts(array('post_type' => 'nav_menu_item', 'nopaging' => true, 'numberposts' => 1, 'meta_key' => '_menu_item_menu_item_parent', 'meta_value' => $item->ID));
			if (empty($children)) {
				$sentientdiv = '<span class="sentient-menu-arrow"> </span>';
				$sentientnochild = '';
			} else {
				$sentientdiv = '<span class="sentient-menu-arrow">&#59232;</span>';
				$sentientnochild = '';
			}
			
			$item_output = $args->before;
			$item_output .= '<a'. $attributes .' class="' . $sentient_megamenu_titlelinkclass . ' ' . $sentientnochild . '">';
			$item_output .= $args->link_before .$prepend.apply_filters( 'the_title', $item->title, $item->ID ).$append;
			$item_output .= $description.$args->link_after;
			$item_output .= '</a>' . $sentientdiv . '';
			$item_output .= $args->after;
			
            $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
      }
}
/*------------------------------------------------------
Sentient Walker_Nav_Menu - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient , Add Custom Fields to the Post Formats (add_action) - Started
-------------------------------------------------------*/
add_action( 'admin_menu', 'sentient_team_post_format_member_position' );
add_action( 'save_post', 'sentient_save_team_post_format_member_position', 10, 2 );

add_action( 'admin_menu', 'sentient_chat_post_format_person_field' );
add_action( 'save_post', 'sentient_save_chat_post_format_person_field', 10, 2 );

add_action( 'admin_menu', 'sentient_link_post_format_URL_field' );
add_action( 'save_post', 'sentient_save_link_post_format_URL_field', 10, 2 );

add_action( 'admin_menu', 'sentient_portfolio_post_format_client_link' );
add_action( 'save_post', 'sentient_save_portfolio_post_format_client_link', 10, 2 );

add_action( 'admin_menu', 'sentient_portfolio_post_format_layout_field' );
add_action( 'save_post', 'sentient_save_portfolio_post_format_layout_field', 10, 2 );

add_action( 'admin_menu', 'sentient_testimonial_post_format_person_name' );
add_action( 'save_post', 'sentient_save_testimonial_post_format_person_name', 10, 2 );

add_action( 'admin_menu', 'sentient_testimonial_post_format_person_position' );
add_action( 'save_post', 'sentient_save_testimonial_post_format_person_position', 10, 2 );

add_action( 'admin_menu', 'sentient_portfolio_post_format_client_name' );
add_action( 'save_post', 'sentient_save_portfolio_post_format_client_name', 10, 2 );

add_action( 'admin_menu', 'sentient_post_format_facebook_field' );
add_action( 'save_post', 'sentient_save_post_format_facebook_field', 10, 2 );

add_action( 'admin_menu', 'sentient_post_format_twitter_field' );
add_action( 'save_post', 'sentient_save_post_format_twitter_field', 10, 2 );

add_action( 'admin_menu', 'sentient_post_format_dribbble_field' );
add_action( 'save_post', 'sentient_save_post_format_dribbble_field', 10, 2 );

add_action( 'admin_menu', 'sentient_post_format_vimeo_field' );
add_action( 'save_post', 'sentient_save_post_format_vimeo_field', 10, 2 );

add_action( 'admin_menu', 'sentient_post_format_flickr_field' );
add_action( 'save_post', 'sentient_save_post_format_flickr_field', 10, 2 );

add_action( 'admin_menu', 'sentient_post_format_linkedin_field' );
add_action( 'save_post', 'sentient_save_post_format_linkedin_field', 10, 2 );

add_action( 'admin_menu', 'sentient_post_format_google_field' );
add_action( 'save_post', 'sentient_save_post_format_google_field', 10, 2 );

add_action( 'admin_menu', 'sentient_video_post_format_URL_field' );
add_action( 'save_post', 'sentient_save_video_post_format_URL_field', 10, 2 );

add_action( 'admin_menu', 'sentient_gallery_post_format_URL_field' );
add_action( 'save_post', 'sentient_save_gallery_post_format_URL_field', 10, 2 );

add_action( 'admin_menu', 'sentient_audio_post_format_URL_field' );
add_action( 'save_post', 'sentient_save_audio_post_format_URL_field', 10, 2 );

add_action( 'admin_menu', 'sentient_page_category_field' );
add_action( 'save_post', 'sentient_save_page_category_field', 10, 2 );
/*------------------------------------------------------
Sentient , Add Custom Fields to the Post Formats (add_action) - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient , Add Custom Fields to the Post Formats (Create Fields) - Started
-------------------------------------------------------*/
function sentient_link_post_format_URL_field() {
	add_meta_box( 'my-post_link-box', 'URL Link for post Link format (only)', 'sentient_create_link_post_format_URL_field', 'post', 'normal', 'high' );
}
function sentient_chat_post_format_person_field() {
	add_meta_box( 'my-chat_person-box', 'Chat Person Name for post Chat format (only)', 'sentient_create_chat_post_format_person_field', 'post', 'normal', 'high' );
}
function sentient_team_post_format_member_position() {
	add_meta_box( 'my-team-position-box', 'Team Member Position', 'sentient_create_team_post_format_member_position', 'team', 'normal', 'high' );
}
function sentient_portfolio_post_format_client_link() {
	add_meta_box( 'my-projectlink-box', 'Project External URL', 'sentient_create_portfolio_post_format_client_link', 'portfolio', 'normal', 'high' );
}
function sentient_portfolio_post_format_layout_field() {
	add_meta_box( 'my-portfoliolayout-box', 'Portfolio Layout', 'sentient_post_portfolio_layout', 'portfolio', 'normal', 'high' );
}
function sentient_testimonial_post_format_person_name() {
	add_meta_box( 'my-test-name-box', 'Person Name', 'sentient_create_testimonial_post_format_person_name', 'testimonial', 'normal', 'high' );
}
function sentient_testimonial_post_format_person_position() {
	add_meta_box( 'my-test-position-box', 'Person Position', 'sentient_create_testimonial_post_format_person_position', 'testimonial', 'normal', 'high' );
}
function sentient_portfolio_post_format_client_name() {
	add_meta_box( 'my-projectdescription-box', 'Project Client', 'sentient_create_portfolio_post_format_client_name', 'portfolio', 'normal', 'high' );
}
function sentient_post_format_facebook_field() {
	add_meta_box( 'my-facebook-box', 'Facebook URL', 'sentient_create_post_format_facebook_field', 'post', 'normal', 'high' );
	add_meta_box( 'my-facebook-box', 'Facebook URL', 'sentient_create_post_format_facebook_field', 'project', 'normal', 'high' );
	add_meta_box( 'my-facebook-box', 'Facebook URL', 'sentient_create_post_format_facebook_field', 'team', 'normal', 'high' );	
}
function sentient_post_format_twitter_field() {
	add_meta_box( 'my-twitter-box', 'Twitter URL', 'sentient_create_post_format_twitter_field', 'post', 'normal', 'high' );
	add_meta_box( 'my-twitter-box', 'Twitter URL', 'sentient_create_post_format_twitter_field', 'project', 'normal', 'high' );
	add_meta_box( 'my-twitter-box', 'Twitter URL', 'sentient_create_post_format_twitter_field', 'team', 'normal', 'high' );	
}
function sentient_post_format_dribbble_field() {
	add_meta_box( 'my-dribbble-box', 'Dribbble URL', 'sentient_create_post_format_dribbble_field', 'project', 'normal', 'high' );
	add_meta_box( 'my-dribbble-box', 'Dribbble URL', 'sentient_create_post_format_dribbble_field', 'post', 'normal', 'high' );
	add_meta_box( 'my-dribbble-box', 'Dribbble URL', 'sentient_create_post_format_dribbble_field', 'team', 'normal', 'high' );	
}
function sentient_post_format_vimeo_field() {
	add_meta_box( 'my-vimeo-box', 'Vimeo URL', 'sentient_create_post_format_vimeo_field', 'project', 'normal', 'high' );
	add_meta_box( 'my-vimeo-box', 'Vimeo URL', 'sentient_create_post_format_vimeo_field', 'post', 'normal', 'high' );
	add_meta_box( 'my-vimeo-box', 'Vimeo URL', 'sentient_create_post_format_vimeo_field', 'team', 'normal', 'high' );	
}
function sentient_post_format_flickr_field() {
	add_meta_box( 'my-flickr-box', 'Flickr URL', 'sentient_create_post_format_flickr_field', 'project', 'normal', 'high' );
	add_meta_box( 'my-flickr-box', 'Flickr URL', 'sentient_create_post_format_flickr_field', 'post', 'normal', 'high' );
	add_meta_box( 'my-flickr-box', 'Flickr URL', 'sentient_create_post_format_flickr_field', 'team', 'normal', 'high' );	
}
function sentient_post_format_linkedin_field() {
	add_meta_box( 'my-linkedin-box', 'LinkedIn URL', 'sentient_create_post_format_linkedin_field', 'team', 'normal', 'high' );	
}
function sentient_post_format_google_field() {
	add_meta_box( 'my-google-box', 'Google URL', 'sentient_create_post_format_google_field', 'team', 'normal', 'high' );	
}
function sentient_video_post_format_URL_field() {
	add_meta_box( 'my-video-box', 'Video URL for post video format (only)', 'sentient_create_video_post_format_URL_field', 'post', 'normal', 'high' );
}
function sentient_gallery_post_format_URL_field() {
	add_meta_box( 'my-gallery-box', 'Gallery Shortcode for post gallery format (only)', 'sentient_create_gallery_post_format_URL_field', 'post', 'normal', 'high' );
}
function sentient_audio_post_format_URL_field() {
	add_meta_box( 'my-audio-box', 'Audio Shortcode for post Audio format (only)', 'sentient_create_audio_post_format_URL_field', 'post', 'normal', 'high' );
}

function sentient_page_category_field() {
	add_meta_box( 'my-category-box', 'Category for blogs Templates (only)', 'sentient_create_category_page_field', 'page', 'normal', 'high' );
}


/*------------------------------------------------------
Sentient , Add Custom Fields to the Post Formats (Create Fields) - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient , Add Custom Fields to the Post Formats (Create Fields Layout) - Started
-------------------------------------------------------*/
function sentient_post_portfolio_layout( $object, $box ) { ?>
	<p>
		<label for="portfoliolayout-shortcode">Portfolio Layout</label>
		<br />
		<input placeholder="full, wide or 2/3" name="portfoliolayout-shortcode" id="portfoliolayout-shortcode" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Portfolio Layout', true )); ?>" />
		<input type="hidden" name="sentient_meta_box_portfoliolayout" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }


function sentient_create_link_post_format_URL_field( $object, $box ) { ?>
	<p>
		<label for="postlink-shortcode">Link Post URL Value</label>
		<br />
		<input name="postlink-shortcode" id="postlink-shortcode" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Link Post URL Value', true )); ?>" />
		<input type="hidden" name="sentient_meta_box_postlink" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }



function sentient_create_chat_post_format_person_field( $object, $box ) { ?>
	<p>
		<label for="chatperson-shortcode">Chat Person Name</label>
		<br />
		<input name="chatperson-shortcode" id="chatperson-shortcode" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Chat Person Name', true )); ?>" />
		<input type="hidden" name="sentient_meta_box_chatperson" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }



function sentient_create_testimonial_post_format_person_name( $object, $box ) { ?>
	<p>
		<label for="testlink-shortcode">Person Name</label>
		<br />
		<input name="testlink-shortcode" id="testlink-shortcode" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Person Name', true )); ?>" />
		<input type="hidden" name="sentient_meta_box_testname" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }


function sentient_create_team_post_format_member_position( $object, $box ) { ?>
	<p>
		<label for="teampositionlink-shortcode">Person Position</label>
		<br />
		<input name="teampositionlink-shortcode" id="teampositionlink-shortcode" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Team Member Position', true )); ?>" />
		<input type="hidden" name="sentient_meta_box_teamposition" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }



function sentient_create_testimonial_post_format_person_position( $object, $box ) { ?>
	<p>
		<label for="testpositionlink-shortcode">Person Position</label>
		<br />
		<input name="testpositionlink-shortcode" id="testpositionlink-shortcode" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Person Position', true )); ?>" />
		<input type="hidden" name="sentient_meta_box_testposition" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }



function sentient_create_portfolio_post_format_client_link( $object, $box ) { ?>
	<p>
		<label for="projectlink-shortcode">Project Client URL</label>
		<br />
		<input name="projectlink-shortcode" id="projectlink-shortcode" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Project Client URL', true )); ?>" />
		<input type="hidden" name="sentient_meta_box_projectlink" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }



function sentient_create_portfolio_post_format_client_name( $object, $box ) { ?>
	<p>
		<label for="projectdescription-shortcode">Project Client</label>
		<br />
		<input name="projectdescription-shortcode" id="projectdescription-shortcode" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Project Client', true )); ?>" />
		<input type="hidden" name="sentient_meta_box_projectdesc" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }



function sentient_create_post_format_facebook_field( $object, $box ) { ?>
	<p>
		<label for="post-facebook">Facebook URL</label>
		<br />
		<input name="post-facebook" id="post-facebook" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Facebook URL', true ) ); ?>" />
		<input type="hidden" name="sentient_meta_box_facebook" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }


function sentient_create_post_format_twitter_field( $object, $box ) { ?>
	<p>
		<label for="post-twitter">Twitter URL</label>
		<br />
		<input name="post-twitter" id="post-twitter" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Twitter URL', true ) ); ?>" />
		<input type="hidden" name="sentient_meta_box_twitter" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }


function sentient_create_post_format_linkedin_field( $object, $box ) { ?>
	<p>
		<label for="post-linkedin">LinkedIn URL</label>
		<br />
		<input name="post-linkedin" id="post-linkedin" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'LinkedIn URL', true ) ); ?>" />
		<input type="hidden" name="sentient_meta_box_linkedin" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }



function sentient_create_post_format_google_field( $object, $box ) { ?>
	<p>
		<label for="post-google">Google URL</label>
		<br />
		<input name="post-google" id="post-google" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Google URL', true ) ); ?>" />
		<input type="hidden" name="sentient_meta_box_google" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }


function sentient_create_post_format_dribbble_field( $object, $box ) { ?>
	<p>
		<label for="post-dribbble">Dribbble URL</label>
		<br />
		<input name="post-dribbble" id="post-dribbble" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Dribbble URL', true ) ); ?>" />
		<input type="hidden" name="sentient_meta_box_dribbble" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }


function sentient_create_post_format_vimeo_field( $object, $box ) { ?>
	<p>
		<label for="post-vimeo">Vimeo URL</label>
		<br />
		<input name="post-vimeo" id="post-vimeo" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Vimeo URL', true ) ); ?>" />
		<input type="hidden" name="sentient_meta_box_vimeo" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }


function sentient_create_post_format_flickr_field( $object, $box ) { ?>
	<p>
		<label for="post-flickr">Flickr URL</label>
		<br />
		<input name="post-flickr" id="post-flickr" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Flickr URL', true ) ); ?>" />
		<input type="hidden" name="sentient_meta_box_flickr" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }


function sentient_create_video_post_format_URL_field( $object, $box ) { ?>
	<p>
		<label for="post-video">Post Video URL</label>
		<br />
		<input name="post-video" id="post-video" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Post Video URL', true ) ); ?>" />
		<input type="hidden" name="sentient_meta_box_video" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }


function sentient_create_gallery_post_format_URL_field( $object, $box ) { ?>
	<p>
		<label for="post-gallery">Post Gallery Shortcode</label>
		<br />
		<input name="post-gallery" id="post-gallery" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Post Gallery Shortcode', true ) ); ?>" />
		<input type="hidden" name="sentient_meta_box_gallery" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }

function sentient_create_audio_post_format_URL_field( $object, $box ) { ?>
	<p>
		<label for="post-audio">Post Audio Shortcode</label>
		<br />
		<input name="post-audio" id="post-audio" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Post Audio Shortcode', true ) ); ?>" />
		<input type="hidden" name="sentient_meta_box_audio" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }

function sentient_create_category_page_field( $object, $box ) { ?>
	<p>
		<label for="post-category">Category for Blogs Templates Only</label>
		<br />
		<input name="post-category" id="post-category" cols="60" rows="4" tabindex="30" style="width: 97%;" value="<?php echo esc_html( get_post_meta( $object->ID, 'Category for Blogs Templates Only', true ) ); ?>" />
		<input type="hidden" name="sentient_meta_box_category" value="<?php echo wp_create_nonce( plugin_basename( __FILE__ ) ); ?>" />
	</p>
<?php }



/*------------------------------------------------------
Sentient , Add Custom Fields to the Post Formats (Create Fields Layout) - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient , Limit Archive Posts - Begin
-------------------------------------------------------*/
function limit_archive_posts($query){
    /*if ($query->is_archive && $query->is_archive) {
        $query->set('posts_per_page', 3);
    }
    return $query;*/
}
/*------------------------------------------------------
Sentient , Limit Archive Posts - Begin - End
-------------------------------------------------------*/


/*------------------------------------------------------
Sentient , Add Custom Fields to the Post Formats (Save Values) - Started
-------------------------------------------------------*/
function sentient_save_portfolio_post_format_layout_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_portfoliolayout'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_portfoliolayout'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	


	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Portfolio Layout', true );
	
	if(isset ($_POST['portfoliolayout-shortcode'])){
		$new_meta_value = stripslashes( $_POST['portfoliolayout-shortcode'] );
	} else {
		$new_meta_value = '';
	}

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Portfolio Layout', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Portfolio Layout', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Portfolio Layout', $meta_value );
}


function sentient_save_link_post_format_URL_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_postlink'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_postlink'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Link Post URL Value', true );
	
	if(isset ($_POST['postlink-shortcode'])){
		$new_meta_value = stripslashes( $_POST['postlink-shortcode'] );
	} else {
		$new_meta_value = '';
	}	
	

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Link Post URL Value', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Link Post URL Value', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Link Post URL Value', $meta_value );
}

function sentient_save_chat_post_format_person_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_chatperson'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_chatperson'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Team Member Position', true );
	
	if(isset ($_POST['chatperson-shortcode'])){
		$new_meta_value = stripslashes( $_POST['chatperson-shortcode'] );
	} else {
		$new_meta_value = '';
	}		

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Chat Person Name', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Chat Person Name', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Chat Person Name', $meta_value );
}

function sentient_save_team_post_format_member_position( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_teamposition'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_teamposition'], plugin_basename( __FILE__ ) ) )
			return $post_id;	
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Team Member Position', true );
	
	if(isset ($_POST['teampositionlink-shortcode'])){
		$new_meta_value = stripslashes( $_POST['teampositionlink-shortcode'] );
	} else {
		$new_meta_value = '';
	}			

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Team Member Position', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Team Member Position', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Team Member Position', $meta_value );
}

function sentient_save_testimonial_post_format_person_position( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_testposition'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_testposition'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Person Position', true );
	
	if(isset ($_POST['testpositionlink-shortcode'])){
		$new_meta_value = stripslashes( $_POST['testpositionlink-shortcode'] );
	} else {
		$new_meta_value = '';
	}				

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Person Position', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Person Position', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Person Position', $meta_value );
}


function sentient_save_testimonial_post_format_person_name( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_testname'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_testname'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Person Name', true );
	
	if(isset ($_POST['testlink-shortcode'])){
		$new_meta_value = stripslashes( $_POST['testlink-shortcode'] );
	} else {
		$new_meta_value = '';
	}				

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Person Name', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Person Name', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Person Name', $meta_value );
}


function sentient_save_portfolio_post_format_client_link( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_projectlink'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_projectlink'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Project Client URL', true );
	
	if(isset ($_POST['projectlink-shortcode'])){
		$new_meta_value = stripslashes( $_POST['projectlink-shortcode'] );
	} else {
		$new_meta_value = '';
	}				

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Project Client URL', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Project Client URL', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Project Client URL', $meta_value );
}


function sentient_save_portfolio_post_format_client_name( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_projectdesc'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_projectdesc'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Project Client', true );
	
	if(isset ($_POST['projectdescription-shortcode'])){
		$new_meta_value = stripslashes( $_POST['projectdescription-shortcode'] );
	} else {
		$new_meta_value = '';
	}				

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Project Client', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Project Client', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Project Client', $meta_value );
}

function sentient_save_post_format_facebook_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_facebook'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_facebook'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Facebook URL', true );
	
	if(isset ($_POST['post-facebook'])){
		$new_meta_value = stripslashes( $_POST['post-facebook'] );
	} else {
		$new_meta_value = '';
	}					

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Facebook URL', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Facebook URL', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Facebook URL', $meta_value );
}

function sentient_save_post_format_twitter_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_twitter'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_twitter'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Twitter URL', true );
	
	if(isset ($_POST['post-twitter'])){
		$new_meta_value = stripslashes( $_POST['post-twitter'] );
	} else {
		$new_meta_value = '';
	}						

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Twitter URL', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Twitter URL', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Twitter URL', $meta_value );
}

function sentient_save_post_format_linkedin_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_linkedin'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_linkedin'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'LinkedIn URL', true );
	
	if(isset ($_POST['post-linkedin'])){
		$new_meta_value = stripslashes( $_POST['post-linkedin'] );
	} else {
		$new_meta_value = '';
	}							

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'LinkedIn URL', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'LinkedIn URL', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'LinkedIn URL', $meta_value );
}

function sentient_save_post_format_google_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_google'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_google'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Google URL', true );
	
	if(isset ($_POST['post-google'])){
		$new_meta_value = stripslashes( $_POST['post-google'] );
	} else {
		$new_meta_value = '';
	}								

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Google URL', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Google URL', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Google URL', $meta_value );
}

function sentient_save_post_format_dribbble_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_dribbble'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_dribbble'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Dribbble URL', true );
	
	if(isset ($_POST['post-dribbble'])){
		$new_meta_value = stripslashes( $_POST['post-dribbble'] );
	} else {
		$new_meta_value = '';
	}									

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Dribbble URL', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Dribbble URL', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Dribbble URL', $meta_value );
}

function sentient_save_post_format_vimeo_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_vimeo'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_vimeo'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Vimeo URL', true );
	
	if(isset ($_POST['post-vimeo'])){
		$new_meta_value = stripslashes( $_POST['post-vimeo'] );
	} else {
		$new_meta_value = '';
	}										

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Vimeo URL', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Vimeo URL', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Vimeo URL', $meta_value );
}


function sentient_save_post_format_flickr_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_flickr'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_flickr'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Flickr URL', true );
	
	if(isset ($_POST['post-flickr'])){
		$new_meta_value = stripslashes( $_POST['post-flickr'] );
	} else {
		$new_meta_value = '';
	}											

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Flickr URL', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Flickr URL', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Flickr URL', $meta_value );
}


function sentient_save_video_post_format_URL_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_video'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_video'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Post Video URL', true );
	
	if(isset ($_POST['post-video'])){
		$new_meta_value = stripslashes( $_POST['post-video'] );
	} else {
		$new_meta_value = '';
	}												

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Post Video URL', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Post Video URL', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Post Video URL', $meta_value );
}

function sentient_save_gallery_post_format_URL_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_gallery'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_gallery'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Post Gallery Shortcode', true );
	
	if(isset ($_POST['post-gallery'])){
		$new_meta_value = stripslashes( $_POST['post-gallery'] );
	} else {
		$new_meta_value = '';
	}													

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Post Gallery Shortcode', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Post Gallery Shortcode', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Post Gallery Shortcode', $meta_value );
}

function sentient_save_audio_post_format_URL_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_audio'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_audio'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Post Audio Shortcode', true );
	
	if(isset ($_POST['post-audio'])){
		$new_meta_value = stripslashes( $_POST['post-audio'] );
	} else {
		$new_meta_value = '';
	}														

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Post Audio Shortcode', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Post Audio Shortcode', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Post Audio Shortcode', $meta_value );
}


function sentient_save_page_category_field( $post_id, $post ) {

	if(isset ($_POST['sentient_meta_box_category'])){
		if ( !wp_verify_nonce( $_POST['sentient_meta_box_category'], plugin_basename( __FILE__ ) ) )
			return $post_id;
	}	

	if ( !current_user_can( 'edit_post', $post_id ) )
		return $post_id;

	$meta_value = get_post_meta( $post_id, 'Category for Blogs Templates Only', true );
	
	if(isset ($_POST['post-category'])){
		$new_meta_value = stripslashes( $_POST['post-category'] );
	} else {
		$new_meta_value = '';
	}														

	if ( $new_meta_value && '' == $meta_value )
		add_post_meta( $post_id, 'Category for Blogs Templates Only', $new_meta_value, true );

	elseif ( $new_meta_value != $meta_value )
		update_post_meta( $post_id, 'Category for Blogs Templates Only', $new_meta_value );

	elseif ( '' == $new_meta_value && $meta_value )
		delete_post_meta( $post_id, 'Category for Blogs Templates Only', $meta_value );
}
/*------------------------------------------------------
Sentient , Add Custom Fields to the Post Formats (Save Values) - End
-------------------------------------------------------*/


/*------------------------------------------------------
Sentient , Gallery Settings - Started
-------------------------------------------------------*/

remove_shortcode('gallery');
add_shortcode('gallery', 'sentient_wordpress_gallery');

function sentient_wordpress_gallery($attr){
	
	$post = get_post();

	static $instance = 0;
	$instance++;

	if ( ! empty( $attr['ids'] ) ) {
		// 'ids' is explicitly ordered, unless you specify otherwise.
		if ( empty( $attr['orderby'] ) )
			$attr['orderby'] = 'post__in';
		$attr['include'] = $attr['ids'];
	}

	// Allow plugins/themes to override the default gallery template.
	$output = apply_filters('post_gallery', '', $attr);
	if ( $output != '' )
		return $output;

	// We're trusting author input, so let's at least make sure it looks like a valid orderby statement
	if ( isset( $attr['orderby'] ) ) {
		$attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );
		if ( !$attr['orderby'] )
			unset( $attr['orderby'] );
	}

	extract(shortcode_atts(array(
		'order'      => 'ASC',
		'orderby'    => 'menu_order ID',
		'id'         => $post ? $post->ID : 0,
		'itemtag'    => 'div',
		'icontag'    => 'span',
		'captiontag' => 'span',
		'columns'    => 3,
		'size'       => 'full',
		'include'    => '',
		'mood'    => 'slideshow',
		'putin'    => '',
		'exclude'    => '',
		'link'       => ''
	), $attr, 'gallery'));

	if($mood == 'slideshow' && $putin == false){ $slideshowclass = 'sentient-gallery-slideshow';} else {$slideshowclass = '';}
	if($putin == 'blogs'){ $blogs = true;} else {$blogs = false;}
	
	$id = intval($id);
	if ( 'RAND' == $order )
		$orderby = 'none';

	if ( !empty($include) ) {
		$_attachments = get_posts( array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );

		$attachments = array();
		foreach ( $_attachments as $key => $val ) {
			$attachments[$val->ID] = $_attachments[$key];
		}
	} elseif ( !empty($exclude) ) {
		$attachments = get_children( array('post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	} else {
		$attachments = get_children( array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
	}

	if ( empty($attachments) )
		return '';

	if ( is_feed() ) {
		$output = "";
		foreach ( $attachments as $att_id => $attachment )
			$output .= wp_get_attachment_link($att_id, $size, true);
		return $output;
	}

	$itemtag = tag_escape($itemtag);
	$captiontag = tag_escape($captiontag);
	$icontag = tag_escape($icontag);
	$valid_tags = wp_kses_allowed_html( 'post' );
	if ( ! isset( $valid_tags[ $itemtag ] ) )
		$itemtag = 'div';
	if ( ! isset( $valid_tags[ $captiontag ] ) )
		$captiontag = 'span';
	if ( ! isset( $valid_tags[ $icontag ] ) )
		$icontag = 'span';

	$columns = intval($columns);
	$itemwidth = $columns > 0 ? floor(100/$columns) : 100;
	$float = is_rtl() ? 'right' : 'left';

	$selector = "gallery-{$instance}" . $post->ID;
	$createid = "sentient-slider-{$instance}" . $post->ID;
	
	$instancenav = $instance * 100;
	$navid = "sentient-slider-nav-{$instancenav}" . $post->ID;
	
	
	$gallery_style = $gallery_div = '';
	if ( apply_filters( 'use_default_gallery_style', true ) )
		$gallery_style = "";
	$size_class = sanitize_html_class( $size );
	$gallery_div = "<div id='$selector' class='{$slideshowclass} sentient-gallery-slideshow-play'>";
	$output = apply_filters( 'gallery_style', $gallery_style . "\n\t\t" . $gallery_div );
	
	if($mood == 'slideshow' && $putin == false){
		$i = 0;
		$output .= "<ul class='sentient-gallery-list slides'>";
		foreach ( $attachments as $id => $attachment ) {
			$j= $j + 1;
			if ( ! empty( $link ) && 'file' === $link ){
				/*$image_output = wp_get_attachment_link( $id, $size, false, false );*/
				$image_output = wp_get_attachment_image( $id, $size, false );
			} elseif ( ! empty( $link ) && 'none' === $link ){
				$image_output = wp_get_attachment_image( $id, $size, false );
			} else {
				/*$image_output = wp_get_attachment_link( $id, $size, true, false );*/
				$image_output = wp_get_attachment_image( $id, $size, false );
			}
			
			$image_meta  = wp_get_attachment_metadata( $id );
			$get_image_url_only = wp_get_attachment_url( $id );
			
			$createimageclass= $selector . '-' . $id;
			
			$orientation = '';
			if ( isset( $image_meta['height'], $image_meta['width'] ) )
				$orientation = ( $image_meta['height'] > $image_meta['width'] ) ? 'portrait' : 'landscape';

			$output .= "<li class='gallery-item {$createimageclass}' data-thumb='$get_image_url_only' >";
			$output .= "$image_output";
			if ( $captiontag && trim($attachment->post_excerpt) ) {
				$output .= "
					<{$captiontag} class='wp-caption-text gallery-caption'>
					" . wptexturize($attachment->post_excerpt) . "
					</{$captiontag}>";
			}
			$output .= "</li>";
			if ( $columns > 0 && ++$i % $columns == 0 )
				$output .= '';
		}
		$output .= "</ul>";
		$i = 0;
		$bigsize = ($j * 49) + 10;
	
	} else if ($mood == 'slideshow' && $putin == true){
	
		$i = 0;
		$output .= "<div class='slider-wrapper'>
						<div id='$createid' class='lean-slider sentient-lean-slider'>";

		foreach ( $attachments as $id => $attachment ) {
			$j= $j + 1;
			if ( ! empty( $link ) && 'file' === $link )
				$image_output = wp_get_attachment_image( $id, $size, false);
			elseif ( ! empty( $link ) && 'none' === $link )
				$image_output = wp_get_attachment_image( $id, $size, false );
			else
				$image_output = wp_get_attachment_image( $id, $size, false );

			$image_meta  = wp_get_attachment_metadata( $id );
			
			$createimageclass= $selector . '-' . $id;
			
			$orientation = '';
			if ( isset( $image_meta['height'], $image_meta['width'] ) )
				$orientation = ( $image_meta['height'] > $image_meta['width'] ) ? 'portrait' : 'landscape';

				
			$output .= "<div class='gallery-slider-item {$createimageclass} lean-slider-slide'>";
			$output .= "$image_output";
			$output .= "</div>";
			if ( $columns > 0 && ++$i % $columns == 0 )
				$output .= '';
		}
		
		$output .= "</div>
		    <div id='$navid' class='sentient-lean-slider-nav'></div>
		</div>";		

	}
	
	
	$output .= "</div>";
	
	return $output;
}
/*------------------------------------------------------
Sentient , Gallery Settings - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient Comments - Started
-------------------------------------------------------*/
function sentient_comment($comment, $args, $depth) {
	$GLOBALS['comment'] = $comment;
	extract($args, EXTR_SKIP);

	if ( 'div' == $args['style'] ) {
		$tag = 'div';
		$add_below = 'comment';
	} else {
		$tag = 'li';
		$add_below = 'div-comment';
	}
	?>
	<<?php echo $tag ?> <?php comment_class(empty( $args['has_children'] ) ? '' : 'parent') ?> id="comment-<?php comment_ID() ?>">
	<?php if ( 'div' != $args['style'] ) : ?>
	<div id="div-comment-<?php comment_ID() ?>" class="comment-body">
	<?php endif; ?>
	<div class="comment-avatar">
	<?php if ($args['avatar_size'] != 0) echo get_avatar( $comment, $args['avatar_size'] ); ?>
	</div>
	<div class="comment-content-stuff">
	<div class="comment-author vcard">
	<?php printf(__('<div class="sentient-bolg-comments-author">%s <span>-</span> </div>'), get_comment_author_link()) ?>
	</div>
	<div class="comment-meta commentmetadata">
		<?php
			printf( __('%1$s','my-text-domain'), get_comment_date(),  get_comment_time())
			?>
			<?php edit_comment_link(__('(Edit)','sentient'),'  ','' );
		?>
	</div>
	<div class="reply">
		<div><i class="icon-reply"></i><?php comment_reply_link(array_merge( $args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?></div>
	</div>	
	<?php if ($comment->comment_approved == '0') : ?>
			<em class="comment-awaiting-moderation"><?php _e('Your comment is awaiting moderation.','my-text-domain') ?></em>
			<br />
	<?php endif; ?>

	<div class="comment-text">
		<?php comment_text() ?>
	</div>
	
	</div>	
	<?php if ( 'div' != $args['style'] ) : ?>
	</div>
	<?php endif; ?>
	<?php
}
/*------------------------------------------------------
Sentient Comments - End
-------------------------------------------------------*/



/*------------------------------------------------------
Sentient Search - Started
-------------------------------------------------------*/
function sentient_search_form( $form ) {

    $form = '<form role="search" method="get" id="searchform" action="' . home_url( '/' ) . '" >
    <input type="search" placeholder="'.__("Search...").'" name="s" id="s" />
    <input type="submit" id="searchsubmit" value="Search" />
    </form>';

	/*value="' . esc_attr(get_search_query()) . '"*/
    return $form;
}

/*------------------------------------------------------
Sentient Search - End
-------------------------------------------------------*/


/*------------------------------------------------------
Sentient WooCommerce Functions - Started
-------------------------------------------------------*/
function woocommerce_header_add_to_cart_fragment( $fragments ) {
	global $woocommerce;
	ob_start();
	
	?>
	<a class="cart-contents" href="<?php echo $woocommerce->cart->get_cart_url(); ?>" title="<?php _e('View your shopping cart', 'woothemes'); ?>"><span class="sentient-header-cart">&#59197;</span><span class="sentient-header-cart-count"><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'woothemes'), $woocommerce->cart->cart_contents_count);?></span></a>
	<?php
	
	$fragments['a.cart-contents'] = ob_get_clean();
	return $fragments;
}

function sentient_breadcrumb_delimiter( $defaults ) {
    // Change the breadcrumb delimiter from '/' to '>'
    $defaults['delimiter'] = ' - ';
    return $defaults;
}


function categories_postcount_filter ($variable) {
   $variable = str_replace('(', '<span class="post_count"> ', $variable);
   $variable = str_replace(')', ' </span>', $variable);
   return $variable;
}


function sentient_woocommerce_catalog_orderby( $args ) {
	$args['orderby'] = 'date';
	$args['order'] = 'desc';
	$args['meta_key'] = '';
    return $args;
}


function woocommerce_output_related_products() {
	woocommerce_related_products(4,1); // Display 4 products in rows of 2
}
/*------------------------------------------------------
Sentient WooCommerce Functions - End
-------------------------------------------------------*/



/***************************************************/
/*Sentient , Add WooCommece Cart to Header 
if WooCommerce is activated - Started */
/***************************************************/
function sentient_get_header_cart(){
	
	$sentient_cart = '';
	if (class_exists('Woocommerce')) {
		global $woocommerce;
		
		do_action( 'woocommerce_before_mini_cart' );
		
		$sentient_cart .= '<ul class="cart_list product_list_widget '. $args['list_class'] .'">';

			if ( sizeof( WC()->cart->get_cart() ) > 0 ) {

					foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
						$_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
						$product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

						if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {

							$product_name  = apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key );
							$thumbnail     = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
							$product_price = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );


							$sentient_cart .= '<li>
								<a href="'. esc_url(get_permalink( $product_id )) .'">
									'. $thumbnail . $product_name .'
								</a>

								'. WC()->cart->get_item_data( $cart_item ) .'

								'. apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="quantity">' . sprintf( '%s &times; %s', $cart_item['quantity'], $product_price ) . '</span>', $cart_item, $cart_item_key ) .'
							</li>';

						}
					}


			} else { 
				$sentient_cart_title = __( 'No products in the cart.', 'sentient' );
				$sentient_cart .= '<li class="empty">'. $sentient_cart_title .'</li>';

			}

		$sentient_cart .= '</ul>';

		if ( sizeof( WC()->cart->get_cart() ) > 0 ) {
			
			$sentient_Subtotal = __( 'Subtotal', 'sentient' );
			$sentient_view = __( 'View Cart', 'sentient' );
			$sentient_checkout = __( 'Checkout', 'sentient' );
			
			$sentient_cart .= '<p class="total"><strong>'. $sentient_Subtotal .':</strong> '. WC()->cart->get_cart_subtotal() .'</p>';

			do_action( 'woocommerce_widget_shopping_cart_before_buttons' );

			$sentient_cart .='<p class="buttons">
				<a href="'. esc_url(WC()->cart->get_cart_url()) .'" class="button wc-forward">'. $sentient_view .'</a>
				<a href="'. esc_url(WC()->cart->get_checkout_url()) .'" class="button checkout wc-forward">' . $sentient_checkout . '</a>
			</p>';
			
		}

		do_action( 'woocommerce_after_mini_cart' ); 

	}
	
	return $sentient_cart;
}

/***************************************************/
/*Sentient , Add WooCommece Cart to Header 
if WooCommerce is activated - End */
/***************************************************/



/*------------------------------------------------------
Sentient Admin Panel - Started
-------------------------------------------------------*/
if ( !function_exists( 'optionsframework_init' ) ) {
	define( 'OPTIONS_FRAMEWORK_DIRECTORY', get_template_directory_uri().'/admin/');
	require_once dirname( __FILE__ ) . '/admin/options-framework.php';
}
/*------------------------------------------------------
Sentient Admin Panel - End
-------------------------------------------------------*/



if(!function_exists('sentient_backend_theme_activation'))
{
	/**
	 *  This function gets executed if the theme just got activated. It resets the global frontpage setting
	 *  and then redirects the user to the framework main options page
	 */
	function sentient_backend_theme_activation()
	{
		global $pagenow;
		if ( is_admin() && 'themes.php' == $pagenow && isset( $_GET['activated'] ) )
		{

			#provide hook so themes can execute theme specific functions on activation
			do_action('sentient_backend_theme_activation');

			#redirect to options page
			header( 'Location: '.admin_url().'themes.php?page=options-framework' ) ;
		}
	}

	add_action('admin_init','sentient_backend_theme_activation');
}


/***************************************************/
/*Sentient Get All Categories - Started*/
/***************************************************/
function sentient_get_all_categories(){
	$category_ids = get_all_category_ids();
	$sentientCategories = '';
	$categoryCount = 0;
	$count = 0;
	$arr = array();
	
	foreach ($category_ids as $cat_id) {
		$arr[] = get_cat_name($cat_id);
	}
	
	return $arr;
	
}
/***************************************************/
/*Sentient Get All Categories - End*/
/***************************************************/



/***************************************************/
/*Sentient Import CSS Styles - Started*/
/***************************************************/
function Sentient_Import_CSS(){

	$file = get_template_directory() . '/sentient-styles.css';
	
	// Append a new person to the file
	$current = Sentient_Generate_CSS();
	
	// Write the contents back to the file
	file_put_contents($file, $current);

}
/***************************************************/
/*Sentient Import CSS Styles - End*/
/***************************************************/



/***************************************************/
/*Sentient Generate CSS Styles - Started*/
/***************************************************/

function Sentient_Generate_CSS(){

	global $prof_default;
 
	$prof_siteboxedlayout = false;

	/*Site Layout*/
	$menuboxed = 'styletwo';
	
	/*Site Background Color*/
	if(of_get_option('site_background_option',$prof_default) == 'color'){$bodypattern = of_get_option('body_bg_color',$prof_default);}
	if(of_get_option('site_background_option',$prof_default) == 'pattern'){$bodypattern = "url('" . get_template_directory_uri() . "/images/" . of_get_option('body_bg',$prof_default) . ".png" . "') repeat scroll 0 0 transparent";}
	if(of_get_option('site_background_option',$prof_default) == 'upload'){$bodypattern = "url('" . of_get_option('body_bg_img',$prof_default) . "') repeat scroll 0 0 transparent";}
	
	/*Site Body Light*/
	if(of_get_option('select_body_light',$prof_default) == 'On'){$bodyclass = "body-bk";} else {$bodyclass="";}
		
	/*Body Wrapper*/
	if($prof_siteboxedlayout){$boxedshadow = "boxedshadow";}	else {$boxedshadow = "";}	
	if(of_get_option('select_body_box_shadow',$prof_default) == 'On'){$boxedshadowvalue = "boxedshadowvalue";} else {$boxedshadowvalue = "";}
	
	/*Header Wrapper*/
	$bordercolor = 'transparent';
	if(!$prof_siteboxedlayout){
		$headerborder = 'header-container-border-none';
		$headerContainerWideColor = 'header-container-wide-color';
		$headerStyleTwoBorder = 'menu-header-styletwo-border';
	}else{
		$headerborder = '';
		$headerContainerWideColor = '';
		$headerStyleTwoBorder = '';		
	}
	
	/*LayerSlider Wrapper*/		
	if(of_get_option('select_slider_mobile',$prof_default) == 'On'){$mobileSlider = 'display-slider-container';}else{$mobileSlider = 'not-display-slider-container';}

	$headerShadow = '';
	if(of_get_option('menu_two_img',$prof_default) == ''){$menutwoimg = 'none';}else{$menutwoimg = of_get_option('menu_two_img',$prof_default);}	
	
	if(is_front_page()){
		$menuheaderstyletwohome = 'menu-header-styletwo-home';
		$menuheaderstyletwoborderhome = 'menu-header-styletwo-border-home';
		$topheadercontainercolorhome = 'top-header-container-color-home';
		$headercontainerwidecolorhome = 'header-container-wide-color-home';
		$frontmenu = '';
		$titlemenuoption = '';
	}
	else
	{
		$menuheaderstyletwohome = '';
		$menuheaderstyletwoborderhome = '';
		$topheadercontainercolorhome = 'top-header-container-color-home';
		$headercontainerwidecolorhome = '';
		$frontmenu = 'internal-menu';
		$titlemenuoption = 'homepage-container-design-title-color';
	}
		

	$GetStyle = "";
	
	// Apply Dynamic CSS
	$GetStyle .= "";
	$getcorrectbodyfont = str_replace('+', ' ', of_get_option('select_font',$prof_default));
	
	$getcorrectheadingonefont = str_replace('+', ' ', of_get_option('h1_font',$prof_default));
	$getcorrectheadingtwofont = str_replace('+', ' ', of_get_option('h2_font',$prof_default));
	$getcorrectheadingthreefont = str_replace('+', ' ', of_get_option('h3_font',$prof_default));
	$getcorrectheadingfourfont = str_replace('+', ' ', of_get_option('h4_font',$prof_default));
	$getcorrectheadingfivefont = str_replace('+', ' ', of_get_option('h5_font',$prof_default));
	$getcorrectheadingSixfont = str_replace('+', ' ', of_get_option('h6_font',$prof_default));
	
	$getcorrectmenufont = str_replace('+', ' ', of_get_option('menu_font',$prof_default));


	
	// HTML styles	
	$GetStyle .= "
		
		@font-face{font-family: entypo; src: url(" . get_template_directory_uri(). "/fonts/entypo.woff);}		
		@font-face{font-family: entyposocial; src: url(" . get_template_directory_uri(). "/fonts/entypo-social.woff);}
		@font-face{font-family: fontello; src: url(" . get_template_directory_uri(). "/fonts/fontello.woff);}
		@font-face{font-family: fontawesome; src: url(" . get_template_directory_uri(). "/fonts/fontawesome-webfont.woff);}	
		.people-say-border .people-container:hover{border-bottom:3px solid " . of_get_option('theme_color',$prof_default) . ";}	
		.wpb_wrapper, .wpb_wrapper p, .wpb_wrapper p span, .wpb_wrapper span, .wpb_wrapper span p, .ui-widget, body{font-family: " . $getcorrectbodyfont . " !important;}
		#cssmenu{font-family: " . $getcorrectmenufont . " !important;}
		.menu-item-description{color:" . of_get_option('main_menu_desc_color',$prof_default) . " !important;}
		.internal-menu .menu-item-description{color:" . of_get_option('main_menu_desc_color',$prof_default) . " !important;}
		.sentient-menu-arrow, .sentient-header-cart, .sentient-header-search-container #searchform #searchsubmit, #mobileMenu i.icon-cancel,
		#cssmenu div ul.menu li a , .mobileMenu-icon i.icon-menu{color:" . of_get_option('main_menu_color',$prof_default) . " !important;}
		.make-menu-white .sentient-menu-arrow, .make-menu-white .sentient-header-cart, .make-menu-white .sentient-header-search-container #searchform #searchsubmit,
		.make-menu-white #cssmenu div ul.menu li a{color:#fff !important;}
		
		
		#cssmenu div ul ul li a.sentient-megamenu-it-is-title:hover, #cssmenu div ul.menu ul.sub-menu li a.sentient-megamenu-it-is-title:hover, #cssmenu div ul.menu li a.sentient-megamenu-it-is-title:hover,
		#cssmenu div ul ul li a.sentient-megamenu-it-is-title, #cssmenu div ul.menu ul.sub-menu li a.sentient-megamenu-it-is-title, #cssmenu div ul.menu li a.sentient-megamenu-it-is-title{color:#4E4E4E !important}
		#mobileMenu i.icon-cancel:hover, .mobileMenu-icon i.icon-menu:hover, .sentient-header-cart:hover, .sentient-header-search-container #searchform #searchsubmit:hover{color:" . of_get_option('theme_color',$prof_default) . " !important;}
		.sentient-menu-arrow.sentient-menu-arrow-hover, #cssmenu div ul.menu li a.sentient-menu-arrow-hover{color:" . of_get_option('theme_color',$prof_default) . " !important;}			
		.internal-menu #cssmenu div ul.menu li a{color:" . of_get_option('main_menu_color',$prof_default) . " !important;}
		h1:not(.layerslider-heading){color:" . of_get_option('h1_color',$prof_default) . "; font-family: " . $getcorrectheadingonefont . " !important; font-size: " . of_get_option('h1_font_size',$prof_default) . " !important; line-height: " . of_get_option('h1_line_height',$prof_default) . " !important;}
		h2:not(.layerslider-heading){color:" . of_get_option('h2_color',$prof_default) . "; font-family: " . $getcorrectheadingtwofont . " !important; font-size: " . of_get_option('h2_font_size',$prof_default) . " !important; line-height: " . of_get_option('h2_line_height',$prof_default) . " !important;}
		h3:not(.layerslider-heading){color:" . of_get_option('h3_color',$prof_default) . "; font-family: " . $getcorrectheadingthreefont . " !important; font-size: " . of_get_option('h3_font_size',$prof_default) . " !important; line-height: " . of_get_option('h3_line_height',$prof_default) . " !important;}
		h4:not(.layerslider-heading){color:" . of_get_option('h4_color',$prof_default) . "; font-family: " . $getcorrectheadingfourfont . " !important; font-size: " . of_get_option('h4_font_size',$prof_default) . " !important; line-height: " . of_get_option('h4_line_height',$prof_default) . " !important;}			
		h5:not(.layerslider-heading){color:" . of_get_option('h5_color',$prof_default) . ";font-family: " . $getcorrectheadingfivefont . " !important;font-size: " . of_get_option('h5_font_size',$prof_default) . " !important;line-height: " . of_get_option('h5_line_height',$prof_default) . " !important;}
		h6:not(.layerslider-heading){color:" . of_get_option('h6_color',$prof_default) . "; font-family: " . $getcorrectheadingSixfont . " !important; font-size: " . of_get_option('h6_font_size',$prof_default) . " !important; line-height: " . of_get_option('h6_line_height',$prof_default) . " !important;}			
		.wpb_toggle:not(.layerslider-heading), #content h4.wpb_toggle:not(.layerslider-heading){font-size:13px !important;}
		#cssmenu div ul ul li a , #cssmenu div ul.menu ul.sub-menu li a{color:" . of_get_option('menu_list_font_color',$prof_default) . " !important;}
		.internal-menu #cssmenu div ul.menu ul.sub-menu li a , .internal-menu #cssmenu div ul.menu ul.sub-menu li a:hover{color:" . of_get_option('menu_list_font_color',$prof_default) . " !important;}
		#cssmenu div.sentient-megamenu-added-container,
		#cssmenu div li ul li a{background:" . of_get_option('menu_list_back_color',$prof_default) . " !important;}
		.internal-menu #cssmenu div li ul li a{background:" . of_get_option('menu_list_back_color',$prof_default) . " !important;}

			
		.top-header-container-color{background:transparent;}		
			
		.footer-heading{border-bottom:0 solid " . of_get_option('theme_color',$prof_default) . ";}							
		.logo{margin-top:" . of_get_option('theme_site_logo_padding_top',$prof_default) . "; margin-bottom:" . of_get_option('theme_site_logo_padding_bottom',$prof_default) . "; margin-left:" . of_get_option('theme_site_logo_padding_left',$prof_default) . ";margin-right:" . of_get_option('theme_site_logo_padding_right',$prof_default) . ";}		
		.sentient-list{color:" . of_get_option('theme_color',$prof_default) . ";}
		.people-container-circle-shape .icon-thumbnail.icon-thumbnail-hover{background:" . of_get_option('theme_color',$prof_default) . ";}
		.people-container-circle-shape .icon-thumbnail{border:1px solid " . of_get_option('theme_color',$prof_default) . ";}
		
		.homepage-container-design-solid-color.homepage-container-design-title-color{background-image:none; background-color:" . of_get_option('theme_color',$prof_default) . "!important;}
		.homepage-container-design-solid-image.homepage-container-design-title-color{background-image:url(" . of_get_option('title_bg_img',$prof_default) . ") !important; background-color:transparent !important; background-attachment:fixed;}		
		.footer-container{background-color:" . of_get_option('foo_color',$prof_default) . ";}		
		.footer-bottom-details{border-top:" . of_get_option('footer_separator_width',$prof_default) . " solid " . of_get_option('footer_separator_color',$prof_default) . ";}
		.employee-position-shape{border-color:transparent " . of_get_option('theme_color',$prof_default) . ";}		
		.blog-anchor{border-top:1px solid " . of_get_option('theme_color',$prof_default) . ";}
		.underlined-heading{color:".of_get_option('theme_color',$prof_default)." !important; border-bottom:1px solid ". of_get_option('theme_color',$prof_default) .";}
		.flickr_badge_image:hover{border-color:" . of_get_option('theme_color',$prof_default) . " !important;}			
		#cssmenu div a{font-size:" . of_get_option('main_menu_font_size',$prof_default) . ";}
		.menu-item-description{font-size:" . of_get_option('main_menu_desc_font_size',$prof_default) . ";}
		
		.sentient-header-top-info-languages .sentient-menu-arrow.sentient-menu-languages-arrow, .proftheme-widget ul li a.sentient-widget-recent-post-title:hover,
		.sentient-header-top-social-container div.sentient-header-top-login-divider a:hover, .div-top i.icon-up-open-hover, a.footer-email-link:hover,
		.sentient-header-email a:hover{color:" . of_get_option('theme_color',$prof_default) . " !important;}
		
		.sentient-button.sentient-button-blog-listing{
			background: none repeat scroll 0 0 " . of_get_option('sentient_blog_back',$prof_default) . " !important;
			border: 1px solid " . of_get_option('sentient_blog_border',$prof_default) . " !important;
			color: " . of_get_option('sentient_blog_color',$prof_default) . " !important;
		}
		
		.sentient-header-cart-count{background:" . of_get_option('theme_color',$prof_default) . ";}
		
		.wpb_toggle:hover, #content h4.wpb_toggle:hover{color:#7c7c7c !important;}
		.wpb_toggle_title_active:hover, #content h4.wpb_toggle_title_active:hover{color:#4e4e4e !important;}
		
		.wpb_toggle:hover, #content h4.wpb_toggle:hover{color:#4e4e4e !important;}
		.wpb_toggle, #content h4.wpb_toggle{background-color:#fcfcfc !important; background-image:none !important; color:#7c7c7c !important;}
		.wpb_toggle_title_active, #content h4.wpb_toggle_title_active{background-color:#fff !important; color:#4e4e4e !important; background-image:none !important;}
		
		.portfolio-icon, .block-blogs-main-right-title, .portfolio-upper-date,	.recentpostcontainer-data:hover, .site-background-color{background-color:" . of_get_option('theme_color',$prof_default) . ";}						
		
		.sentient-top-rated-items .flex-direction-nav li.flexslider-arrow-show a.flex-next, .sentient-top-rated-items .flex-direction-nav li.flexslider-arrow-show a.flex-prev,		
		.sentient-blog-normal-container.sentient-blog-slider-container .flex-direction-nav li.flexslider-arrow-show a.flex-next,
		.sentient-blog-normal-container.sentient-blog-slider-container .flex-direction-nav li.flexslider-arrow-show a.flex-prev{border:1px solid " . of_get_option('theme_color',$prof_default) . ";}
		
		.sentient-iconsSix-Container.sentient-homepage-icon-stylefive-wrapper-hover .sentient-iconsFive-imageContainer .sentient-iconsOne-iconContainer{border: 1px solid " . of_get_option('theme_color',$prof_default) . " !important;}
		
		.sentient-map-logo .sentient-iconsOne-iconContainer .sentient-header-search-pointer,
		.sentient-top-rated-items .flex-direction-nav li.flexslider-arrow-show a.flex-next, .sentient-bar-container-bar, .pricing-main-column .sentient-pricing-main-title, .pricing-main-column .sentient-button.sentient-pricing-button,
		.sentient-top-rated-items .flex-direction-nav li.flexslider-arrow-show a.flex-prev, .sentient-products-four-col-icons-container > a:hover,	.pricing-main-column .pricing-title, .ajax-container > .ajax-controls a:hover,
		.blog-box-thumb-date-box, #hot-item-close, .sentient-iconsFour-textContainer,.sentient-map-logo .sentient-iconsOne-iconContainer,.sentient-map-logo .sentient-homepage-icon-styleone-iconcontainer .sentient-header-search-pointer,
		.homepage-blog-colored-design-hover, .format-chat .blog-image-container-modern-design-border, .footer-title-underline,.blog-item-date-container, .home-blogs-modern-container .post .sentient-post-related-container.sentient-post-related-container-color i ,
		.wpb_tabs_nav.ui-tabs-nav.clearfix.ui-helper-reset.ui-helper-clearfix.ui-widget-header.ui-corner-all li.ui-state-default.ui-corner-top.ui-tabs-active.ui-state-active,.woocommerce span.onsale,.woocommerce-page span.onsale ,
		.employee-container-position, .portfolio-details.thumb-content.portfolio-details-hover-back, .jqc-button.jqc-button-pages.jqc-active span, .sentient-sale, .portfolio-pagination span:hover, .portfolio-pagination a.page-numbers:hover , .portfolio-pagination .page-numbers:hover,
		.employee-button-container , .blog-date-container,.portfolio-upper-left, .portfolio-middle-content, .sentient-blog-normal-container.sentient-blog-slider-container .flex-direction-nav li.flexslider-arrow-show a.flex-next, .sentient-blog-normal-container.sentient-blog-slider-container .flex-direction-nav li.flexslider-arrow-show a.flex-prev,
		.recent-post-data-only-date-color, .blog-button-content.blog-button-content-hover, .portfolio-upper-right,.blog-button-content, .blog-box-thumb-date-box ,
		.blog-without-image-container.blog-status-container, .sentient-blog-listing-audio-container .mejs-controls .mejs-time-rail .mejs-time-current, .sentient-blog-listing-audio-container .mejs-controls .mejs-horizontal-volume-slider .mejs-horizontal-volume-current,
		#wp-calendar #today,.prof-wp-links-pages p a:hover,.prof-wp-links-pages-active, .blog-date-fly,
		.contactform .contact-form-send-btn, .heading-left-bar, .portfolio-internal-displayed-title-border, .sentient-testimonial-with-thumb-container .flex-control-nav.flex-control-paging li a.flex-active, .sentient-testimonial-with-thumb-container .flex-control-nav.flex-control-paging li a.flex-active:hover, .sentient-testimonial-with-thumb-container .flex-control-nav.flex-control-paging li a:hover,
		.home-main-col.home-main-col-hover, .home-blogs-modern-chatitem{
			background:" . of_get_option('theme_color',$prof_default) . " !important;
		}
		
		.format-aside .blog-image-container-modern-design-border, .tag-no-featured-image .blog-image-container-modern-design-border,
		.format-status .blog-image-container-modern-design-border{border:5px solid " . of_get_option('theme_color',$prof_default) . " !important;}
		
		.prof-menu-collapse, .portfolio-details-link-icon,.portfolio-project-link-icon,.portfolio-middle-content.portfolio-middle-content-color .gallery-normal .gallery-item,
		.onlyblog-zoom:hover , .onlyblog-read:hover{background-color:" . of_get_option('theme_color',$prof_default) . " !important;}
		
		#timeline {border-left: 8px solid " . of_get_option('theme_color',$prof_default) . ";}
		.timeline-container .circle {border: 5px solid " . of_get_option('theme_color',$prof_default) . ";}
		.timeline-container .content:after {border-right-color: " . of_get_option('theme_color',$prof_default) . ";}
		.timeline-container .radio:checked + .relative label {color:" . of_get_option('theme_color',$prof_default) . ";}
		.timeline-container .radio:checked ~ .content {border-color: " . of_get_option('theme_color',$prof_default) . ";}		
		
		.navigation-sticky #cssmenu div a{font-size:14px;}
		.navigation-sticky .menu-item-description{font-size:10px;}		
		.sentient-iconsOne-iconContainer .sentient-header-search-pointer.sentient-header-search-pointer-icon-hover, .sentient-iconsOne-iconContainer.sentient-homepage-icon-styleone-iconcontainer-hover{background:" . of_get_option('theme_color',$prof_default) . ";}
		.sentient-iconsOne-iconContainer .sentient-header-search-pointer, .sentient-iconsOne-iconContainer{border:1px solid " . of_get_option('theme_color',$prof_default) . ";}		
		.sentient-homepage-icon-stylefive-wrapper-hover .sentient-iconsFive-imageInternal{border-bottom:2px solid " . of_get_option('theme_color',$prof_default) . " !important;}		
		.sentient-homepage-icon-stylefive-wrapper-hover .sentient-iconsFive-Container .sentient-iconsOne-iconContainer, .sentient-iconsSix-Container.sentient-homepage-icon-stylefive-wrapper-hover .sentient-iconsFive-imageContainer .sentient-homepage-icon-styleone-iconcontainer ,
		.sentient-homepage-icon-stylefive-wrapper-hover .sentient-iconsFive-imageContainer .sentient-iconsOne-iconContainer .sentient-header-search-pointer{border:1px solid " . of_get_option('theme_color',$prof_default) . " !important;}		
		blockquote{border-left:2px solid " . of_get_option('theme_color',$prof_default) . ";}		
		.wpcf7-form .wpcf7-submit:hover, .sentient-button.sentient-button-icon.sentient-button-like-theme:hover, .sentient-button.sentient-button-like-theme:hover{text-decoration:none; opacity:1; background:" . of_get_option('theme_color',$prof_default) . " !important; color:#fff !important;}
		
		.woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce nav.woocommerce-pagination ul li a:focus,
		.woocommerce #content nav.woocommerce-pagination ul li a:hover, .woocommerce #content nav.woocommerce-pagination ul li a:focus,
		.woocommerce-page nav.woocommerce-pagination ul li a:hover, .woocommerce-page nav.woocommerce-pagination ul li a:focus,
		.woocommerce-page #content nav.woocommerce-pagination ul li a:hover,.woocommerce-page #content nav.woocommerce-pagination ul li a:focus{
			background:" . of_get_option('theme_color',$prof_default) . " !important;
			color:#ffffff !important;

		}

		.woocommerce nav.woocommerce-pagination ul li a:hover i, .woocommerce nav.woocommerce-pagination ul li a:focus i,
		.woocommerce #content nav.woocommerce-pagination ul li a:hover i, .woocommerce #content nav.woocommerce-pagination ul li a:focus i,
		.woocommerce-page nav.woocommerce-pagination ul li a:hover i, .woocommerce-page nav.woocommerce-pagination ul li a:focus i,
		.woocommerce-page #content nav.woocommerce-pagination ul li a:hover i, .woocommerce-page #content nav.woocommerce-pagination ul li a:focus i{
			color:#ffffff !important;
		}		

		#recentcomments .sentient-comments-author a:hover, .woocommerce .woocommerce-info a,
		.woocommerce-page .woocommerce-info a, .woocommerce .sentient-cart-page #content table.cart a.remove:hover,
		.woocommerce .sentient-cart-page table.cart a.remove:hover, .woocommerce-page .sentient-cart-page #content table.cart a.remove:hover,
		.woocommerce-page .sentient-cart-page table.cart a.remove:hover, .woocommerce .sentient-cart-page #content table.cart a.remove,
		.woocommerce .sentient-cart-page table.cart a.remove, .woocommerce-page .sentient-cart-page #content table.cart a.remove,
		.woocommerce-page .sentient-cart-page table.cart a.remove {
			color:" . of_get_option('theme_color',$prof_default) . " !important;
		}
		
		.sidebar-container .widget_shopping_cart_content .total .amount, .woocommerce-page .woocommerce-info a.showcoupon:hover ,
		.woocommerce .woocommerce-info a.showcoupon:hover, .woocommerce-page .woocommerce-info a.showcoupon ,
		.woocommerce .woocommerce-info a.showcoupon, .woocommerce .sentient-cart-page table.shop_table .cart-subtotal .amount,
		.woocommerce-page .sentient-cart-page table.shop_table .cart-subtotal .amount, .woocommerce .sentient-cart-page table.shop_table .order-total .amount,		
		.woocommerce-page .sentient-cart-page table.shop_table .order-total .amount, .woocommerce .sentient-cart-page table.shop_table td.product-name strong,
		.woocommerce-page .sentient-cart-page table.shop_table td.product-name strong, .woocommerce-page .sentient-cart-page .cart-collaterals .cart_totals tr.cart-subtotal td,
		.woocommerce-page .sentient-cart-page .cart-collaterals .cart_totals tr.order-total td,.woocommerce .sentient-cart-page .cart-collaterals .cart_totals tr.cart-subtotal td,
		.woocommerce .sentient-cart-page .cart-collaterals .cart_totals tr.order-total td{
			color:" . of_get_option('theme_color',$prof_default) . " !important;		
		}
		
		.woocommerce .proftheme-widget .widget_shopping_cart_content .buttons a:hover, .woocommerce-page .proftheme-widget .widget_shopping_cart_content .buttons a:hover, .progress-bar-percentage-text, .pricing-title-amount, .comment-edit-link, .woocommerce .sentient-woocommerce-single div.product p.price,
		.woocommerce .sentient-woocommerce-shop-container ul.products li.product .price, .sidebar-container ul li.sidebar-list-hovered i, .sidebar-container ul li.sidebar-list-hovered a, .woocommerce .proftheme-widget .widget_shopping_cart_content .total .amount, .woocommerce .sentient-woocommerce-single div.product .product_meta a,
		.woocommerce-page .sentient-woocommerce-shop-container ul.products li.product .price, .sidebar-container ul li.sidebar-list-hovered, .sidebar-container ul li.sidebar-list-hovered .count, .sidebar-container .proftheme-widget ul.product_list_widget li ins .amount, .sidebar-container .proftheme-widget ul#sentient-recent-posts li a.sentient-widget-recent-post-title:hover,
		.home-blog-modern-removed-content-title a:hover, .footer-bottom-container a:hover, .blog-right-user .homepage-blog-upper-admin a, a.blog-link, .sentient-iconsOne-iconContainer i, .sentient-top-rated-items-add-to-cart .add_to_cart_button:hover, .sentient-top-rated-items-add-to-cart.sentient-top-rated-items-hover .add_to_cart_button,
		.page-title-container-details a:hover,a:hover:not(.sentient-button), .thumb-content.portfolio-details h5 a:hover, .blog-without-image-details-more a, .sentient-portfolio-five-col-filter > ul > li  > button:hover, .sentient-top-rated-items-view-details a:hover, .sentient-top-rated-items-view-details.sentient-top-rated-items-hover a,
		.blog-title a:hover, .blog-left-content-container .onlyblog-day, .thumb-content.portfolio-details:hover, .thumb-content-title a:hover,.sentient-video-tutorial-thumbnail.sentient-video-tutorial-thumbnail-hover i, .sentient-top-rated-items-add-to-cart .add_to_cart_button:hover i, .sentient-top-rated-items-add-to-cart.sentient-top-rated-items-hover .add_to_cart_button i,
		.footer-col-one #proftheme-widget ul li:hover, .footer-col-one #proftheme-widget ul li a:hover, .portfolio-internal-hidden-date, .people-container i, .sentient-homepage-icon-stylefive-wrapper-hover .sentient-iconsFive-imageContainer .sentient-iconsOne-iconContainer i,
		.Recent-post-list li:hover, Recent-post-list li a:hover, .footer-navigation li a:hover, .portfolio-details-link a, .comment-post-title, .sentient-animated-numbers-container i, .sentient-list-items ul li, .sentient-header-cart-items .buttons a:hover, .sentient-header-cart-items .total .amount,
		.home-main-col.home-main-col-hover .proftheme-button, .site-font-color, .recent-post-data-only-info h5:hover, .post-detailed-title a, .post-project-external-link-value a, .sentient-product-slider-sale-price, .sentient-products-four-col .add_to_cart_button:hover, .woocommerce .sentient-woocommerce-single div.product .woocommerce-tabs .panel #comments ol.commentlist li .comment-text strong,
		.homepage-col h5:hover, .homepage-col h4:hover, #cssmenu div ul.menu ul.sub-menu li.current-menu-item a, #cssmenu div ul.menu ul.sub-menu li.current_page_item a, .sentient-products-four-col .sentient-product-slider-sale-price,.woocommerce nav.woocommerce-pagination ul li:hover i, .woocommerce .sentient-woocommerce-single div.product form .amount,
		.internal-menu #cssmenu div ul.menu ul.sub-menu li.current-menu-item a,.internal-menu #cssmenu div ul.menu ul.sub-menu li.current_page_item a, .sidebar-container .proftheme-widget .menu li.current_page_item a, .ajax_project .project_description .sentient_project_description_link h2.title:hover, .woocommerce .sentient-cart-page table.shop_table td a, .woocommerce-page .sentient-cart-page table.shop_table td a,
		#proftheme-widget .current-menu-item a, #proftheme-widget .current_page_item a,.widget.widget_recent_entries .post-date,#recentcomments .recentcomments a, #comments #respond h3, .reply a.comment-reply-link:hover , .reply:hover{
			color:" . of_get_option('theme_color',$prof_default) . " !important;
		}
		
		.footer-container .sentient-header-top-container{background:" . of_get_option('foo_social_color',$prof_default) . "; color:" . of_get_option('foo_social_text_color',$prof_default) . "; z-index:1;}
		.footer-container .sentient-header-top-container a{color:" . of_get_option('foo_social_text_color',$prof_default) . " !important;}
		.footer-container .sentient-header-top-social-container span a {color: " . of_get_option('foo_social_text_color',$prof_default) . ";}
		.footer-container .sentient-header-top-container {border-bottom: 1px solid " . of_get_option('foo_social_border_color',$prof_default) . ";}
		.footer-container .sentient-header-top-social-container div.sentient-header-top-social-divider {border-left: 1px solid " . of_get_option('foo_social_border_color',$prof_default) . ";}		
		.footer-container .sentient-header-top-social-container {border-right: 1px solid " . of_get_option('foo_social_border_color',$prof_default) . ";}
		
		.footer-heading{color:" . of_get_option('foo_title_color',$prof_default) . " !important;}		
		.footer-upper-container .footer-widget-container .proftheme-widget {color: " . of_get_option('foo_widget_text_color',$prof_default) . ";}		
				
		
		.proftheme-widget #searchform i.icon-search:hover{color:" . of_get_option('theme_color',$prof_default) . " !important;}
		.tagcloud a:hover{background:" . of_get_option('theme_color',$prof_default) . " !important; color:#fff !important;}\n";			
		
	$GetStyle .= of_get_option('css_text',$prof_default);
	$GetStyle .= "\n";
	$GetStyle .= "\t";
	
	return $GetStyle;
}

/***************************************************/
/*Sentient Import CSS Styles - End*/
/***************************************************/
?>