<!DOCTYPE html>
<!--[if gt IE 8]><html class="ie" <?php language_attributes(); ?>><![endif]-->
<!--[if !IE]><!--><html <?php language_attributes(); ?>> <!--<![endif]-->



<!-- Head Section Started
================================================== -->
<head>

	<!-- Basic Page Needs
  ================================================== -->
	<meta charset="<?php bloginfo( 'charset' ); ?>" />
	<title><?php bloginfo('name'); ?> | <?php is_front_page() ? bloginfo('description') : wp_title(''); ?></title>

	<!--[if lt IE 9]>
		<script src="http://html5shiv.googlecode.com/svn/trunk/html5.js"></script>
	<![endif]-->
	
	
	<!-- Get Variables and include files
  ================================================== -->	
	<?php			
		/*Site Layout*/
		global $prof_default;
		
		$prof_siteboxedlayout = false;
		
		if(is_front_page()){ $sentient_front_page = 'sentient-home'; } else { $sentient_front_page = 'sentient-internal'; }		
		if(is_user_logged_in()) {$sentient_user_logged = 'sentient-user-logged';}
		if(of_get_option('select_breadcrumb',$prof_default) != 'On'){$sentient_breadcrumb = 'sentient-breadcrumb';} else {$sentient_breadcrumb = '';}
		if(of_get_option('select_sticky',$prof_default) == 'On'){$sentient_sticky = 'sentient-sticky';} else {$sentient_sticky = '';}		
	?>

	
	<!-- Check if Responsive is enabled 
  ================================================== -->	
	<?php if (of_get_option('select_responsive',$prof_default) == 'On') { ?>
		<meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
	<?php } ?>

	
	<!-- Favicons
	================================================== -->
	<link rel="shortcut icon" href="<?php echo esc_url(of_get_option('theme_favicon',$prof_default)); ?>" type="image/vnd.microsoft.icon"/>	

	<?php wp_head(); ?>	
</head>
<!-- Head Section End
================================================== -->




<!-- Body Section Started
================================================== -->
<body <?php body_class(); ?>>
	<div class="<?php echo esc_attr($sentient_front_page) . ' ' . esc_attr($sentient_user_logged) . ' ' . esc_attr($sentient_breadcrumb); ?>">
		
		
	<!-- For Menu Style
	================================================== -->	
	<?php
		
		$SentientHeaderOption = of_get_option('select_sentient_header',$prof_default);
	?>	

	
	<!-- Menu Style 2 Started
	================================================== -->			
	<?php
	/* Menu Option Two*/
	if($SentientHeaderOption == 'OptionTwo') {
	?>	
	
	
	<div class="sentient-header-top-container">
	
		<!-- Email/Phone/Socials Container
		================================================== -->		
		<div class="sentient-header-top-internal-container">
			<div class="sentient-header-top-info-container">
				<span class="sentient-header-phone"><?php _e('Call Us: ', 'sentient'); ?><?php echo esc_attr(of_get_option('theme_site_phone',$prof_default)); ?></span>
				<span class="sentient-header-email"><?php _e('Email: ', 'sentient'); ?><a href="mailto:<?php echo esc_attr(of_get_option('theme_site_email',$prof_default)); ?>"><?php echo esc_attr(of_get_option('theme_site_email',$prof_default)); ?></a></span>			
			</div>
			<div class="sentient-header-top-social-container">
				<?php if(of_get_option('flicker_user_account',$prof_default) != ''){ ?>
				<div class="sentient-header-top-social-divider">
					<span class="sentient-header-top-info-flickr"><a target="_blank" href="<?php echo esc_url(of_get_option('flicker_user_account',$prof_default)); ?>"><i class="icon-flickr"></i></a></span>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip-top"><?php _e('Flickr', 'sentient'); ?></span>
					</div>
				</div>
				<?php } ?>
				<?php if(of_get_option('vimeo_user_account',$prof_default) != ''){ ?>				
				<div class="sentient-header-top-social-divider">
					<span class="sentient-header-top-info-vimeo"><a target="_blank" href="<?php echo esc_url(of_get_option('vimeo_user_account',$prof_default)); ?>"><i class="icon-vimeo"></i></a></span>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip-top"><?php _e('Vimeo', 'sentient'); ?></span>
					</div>					
				</div>
				<?php } ?>
				<?php if(of_get_option('twitter_user_account',$prof_default) != ''){ ?>					
				<div class="sentient-header-top-social-divider">
					<span class="sentient-header-top-info-twitter"><a target="_blank" href="<?php echo esc_url(of_get_option('twitter_user_account',$prof_default)); ?>"><i class="icon-twitter"></i></a></span>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip-top"><?php _e('Twitter', 'sentient'); ?></span>
					</div>					
				</div>
				<?php } ?>	
				<?php if(of_get_option('facebook_user_account',$prof_default) != ''){ ?>						
				<div class="sentient-header-top-social-divider">
					<span class="sentient-header-top-info-facebook"><a target="_blank" href="<?php echo esc_url(of_get_option('facebook_user_account',$prof_default)); ?>"><i class="icon-facebook"></i></a></span>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip-top"><?php _e('Facebook', 'sentient'); ?></span>
					</div>					
				</div>
				<?php } ?>
				<?php if(of_get_option('dribbble_user_account',$prof_default) != ''){ ?>					
				<div class="sentient-header-top-social-divider">
					<span class="sentient-header-top-info-dribbble"><a target="_blank" href="<?php echo esc_url(of_get_option('dribbble_user_account',$prof_default)); ?>"><i class="icon-dribbble"></i></a></span>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip-top"><?php _e('Dribbble', 'sentient'); ?></span>		
					</div>					
				</div>
				<?php } ?>
				<?php if(of_get_option('linkedin_user_account',$prof_default) != ''){ ?>					
				<div class="sentient-header-top-social-divider">
					<span class="sentient-header-top-info-linkedin"><a target="_blank" href="<?php echo esc_url(of_get_option('linkedin_user_account',$prof_default)); ?>"><i class="icon-linkedin"></i></a></span>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip-top"><?php _e('LinkedIn', 'sentient'); ?></span>		
					</div>					
				</div>
				<?php } ?>				
				<?php if(of_get_option('google_user_account',$prof_default) != ''){ ?>					
				<div class="sentient-header-top-social-divider">
					<span class="sentient-header-top-info-google"><a target="_blank" href="<?php echo esc_url(of_get_option('google_user_account',$prof_default)); ?>"><i class="icon-gplus"></i></a></span>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip-top"><?php _e('Google+', 'sentient'); ?></span>		
					</div>					
				</div>
				<?php } ?>	
				<?php if(of_get_option('rss_user_account',$prof_default) != ''){ ?>					
				<div class="sentient-header-top-social-divider">
					<span class="sentient-header-top-info-rss"><a target="_blank" href="<?php echo esc_url(of_get_option('rss_user_account',$prof_default)); ?>"><i class="icon-rss"></i></a></span>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip-top"><?php _e('RSS', 'sentient'); ?></span>		
					</div>					
				</div>
				<?php } ?>
				<?php if(of_get_option('pinterest_user_account',$prof_default) != ''){ ?>					
				<div class="sentient-header-top-social-divider">
					<span class="sentient-header-top-info-pinterest"><a target="_blank" href="<?php echo esc_url(of_get_option('pinterest_user_account',$prof_default)); ?>"><i class="icon-pinterest"></i></a></span>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip-top"><?php _e('Pinterest', 'sentient'); ?></span>		
					</div>					
				</div>
				<?php } ?>
				<?php if(of_get_option('github_user_account',$prof_default) != ''){ ?>					
				<div class="sentient-header-top-social-divider">
					<span class="sentient-header-top-info-github"><a target="_blank" href="<?php echo esc_url(of_get_option('github_user_account',$prof_default)); ?>"><i class="icon-github"></i></a></span>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip-top"><?php _e('Github', 'sentient'); ?></span>		
					</div>					
				</div>
				<?php } ?>
				<?php if(of_get_option('tumblr_user_account',$prof_default) != ''){ ?>					
				<div class="sentient-header-top-social-divider">
					<span class="sentient-header-top-info-tumblr"><a target="_blank" href="<?php echo esc_url(of_get_option('tumblr_user_account',$prof_default)); ?>"><i class="icon-tumblr"></i></a></span>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip-top"><?php _e('Tumblr', 'sentient'); ?></span>		
					</div>					
				</div>
				<?php } ?>
				<?php if(of_get_option('instagram_user_account',$prof_default) != ''){ ?>					
				<div class="sentient-header-top-social-divider">
					<span class="sentient-header-top-info-instagram"><a target="_blank" href="<?php echo esc_url(of_get_option('instagram_user_account',$prof_default)); ?>"><i class="icon-instagram"></i></a></span>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip-top"><?php _e('Instagram', 'sentient'); ?></span>		
					</div>					
				</div>
				<?php } ?>
				<?php if(of_get_option('skype_user_account',$prof_default) != ''){ ?>					
				<div class="sentient-header-top-social-divider">
					<span class="sentient-header-top-info-skype"><a target="_blank" href="<?php echo esc_url(of_get_option('skype_user_account',$prof_default)); ?>"><i class="icon-skype"></i></a></span>
					<div class="sentient-header-top-popup-container animated">
						<span class="sentient-tooltip-top"><?php _e('Skype', 'sentient'); ?></span>		
					</div>					
				</div>
				<?php } ?>			
			</div>			
		</div>
	</div>
	
	
	<!-- Second Container
	================================================== -->			
	<div class="container-wide sentient-body-style-two <?php echo $sentient_sticky; ?>">
		<div class="logo-container">
			
			<!-- Logo Container
			================================================== -->						
			<div class="logo">				
				<a href="<?php  echo esc_url(home_url()) ; ?>" title="<?php bloginfo( 'name' ) ?>" rel="home">
					<?php if (!sentient_check_if_empty(of_get_option('theme_logo',$prof_default))){?>
					<img src="<?php echo of_get_option('theme_logo',$prof_default); ?>" alt="logo" />
					<?php } else { ?>
					<h1 class="prof-page-title"><?php echo esc_attr(of_get_option('theme_site_logo_text',$prof_default)); ?></h1>
					<?php } ?>
				</a>
			</div>										
			<div class="navigation">
								
				<!-- Search Container
				================================================== -->					
				<?php if (of_get_option('select_search',$prof_default) == 'On') { ?>					
				<div class="sentient-header-search-container">
					<form action="<?php echo esc_url(get_site_url()); ?>" id="searchform" method="get" role="search">
						<span class="sentient-header-search-icon"><a id="searchsubmit"><i class="icon-search"></i></a></span>							
						<div class="sentient-header-search-input-container animated">
							<input type="search" id="s" name="s" value="" placeholder="Search...">
							<div class="sentient-header-search-pointer-main"><div class="sentient-header-search-pointer">&#9652;</div></div>
						</div>
					</form>
				</div>				
				<?php }?>
				
				
				<!-- Cart Container
				================================================== -->						
				<?php
					global $woocommerce; 
					if (class_exists('Woocommerce') && of_get_option('select_cart',$prof_default) == 'On') {	
				?>
				<div class="sentient-header-cart-container">
					<a class="cart-contents" href="<?php echo esc_url($woocommerce->cart->get_cart_url()); ?>" title="<?php _e('View your shopping cart', 'woothemes'); ?>"><span class="sentient-header-cart">&#59197;</span><span class="sentient-header-cart-count"><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'woothemes'), $woocommerce->cart->cart_contents_count);?></span></a>
					<div class="sentient-header-cart-items-container">
						<div class="sentient-header-cart-items">
							<div class="sentient-header-search-pointer-main sentient-header-search-tooltip">
								<div class="sentient-header-search-pointer">▴</div>
							</div>
							<div class="widget_shopping_cart_content">
								<?php echo sentient_get_header_cart(); ?>
							</div>
						</div>
					</div>
				</div>
				<?php } ?>
				
				<!-- Menu Container
				================================================== -->						
				<div id="cssmenu">						
					<?php wp_nav_menu( array( 'theme_location' => 'header-menu' , 'fallback_cb' => 'sentient_menu_fall_back', 'walker' => new sentient_description_walker() )); ?>					
				</div>
		
				<span class="mobileMenu-icon"><i class="icon-menu"></i></span>
			</div>	
		</div>			
	</div>
	
	<!-- Mobile Container
	================================================== -->			
	<div id='mobileMenu' class="mobile-menu-two">
		<span class="mobileMenu-icon-close"><i class="icon-cancel"></i></span>			
		<div id="MobileMenuContainer">			
			<?php wp_nav_menu( array( 'theme_location' => 'header-menu' , 'fallback_cb' => 'sentient_menu_fall_back', 'walker' => new sentient_description_walker() )); ?>					
		</div>
	</div>
	<!-- Menu Style 2 End
	================================================== -->		
	
	
	<!-- Menu Style 3 Started
	================================================== -->			
	<?php 
		/* Menu Option Three*/
	} elseif($SentientHeaderOption == 'OptionThree') { 
	?>
	<div class="header-sentient-menu-three container-wide <?php echo $sentient_sticky; ?>">
		<div class="logo-container">
			
			<!-- Logo Container
			================================================== -->					
			<div class="logo">				
				<a href="<?php  echo esc_url(home_url()) ; ?>" title="<?php bloginfo( 'name' ) ?>" rel="home">
					<?php if (!sentient_check_if_empty(of_get_option('theme_logo',$prof_default))){?>
					<img src="<?php echo esc_url(of_get_option('theme_logo',$prof_default)); ?>" alt="logo" />
					<?php } else { ?>
					<h1 class="prof-page-title"><?php echo esc_attr(of_get_option('theme_site_logo_text',$prof_default)); ?></h1>
					<?php } ?>
				</a>
			</div>		

				
			<div class="navigation">

				<!-- Search Container
				================================================== -->						
				<?php if (of_get_option('select_search',$prof_default) == 'On') { ?>					
				<div class="sentient-header-search-container">
					<form action="<?php echo esc_url(get_site_url()); ?>" id="searchform" method="get" role="search">
						<span class="sentient-header-search-icon"><a id="searchsubmit"><i class="icon-search"></i></a></span>							
						<div class="sentient-header-search-input-container animated">
							<input type="search" id="s" name="s" value="" placeholder="Search...">
							<div class="sentient-header-search-pointer-main"><div class="sentient-header-search-pointer">&#9652;</div></div>
						</div>
					</form>
				</div>			
				<?php } ?>
				
				
				<!-- Cart Container
				================================================== -->						
				<?php
					global $woocommerce; 
					if (class_exists('Woocommerce') && of_get_option('select_cart',$prof_default) == 'On') {	
				?>
				<div class="sentient-header-cart-container">
					<a class="cart-contents" href="<?php echo esc_url($woocommerce->cart->get_cart_url()); ?>" title="<?php _e('View your shopping cart', 'woothemes'); ?>"><span class="sentient-header-cart">&#59197;</span><span class="sentient-header-cart-count"><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'woothemes'), $woocommerce->cart->cart_contents_count);?></span></a>
					<div class="sentient-header-cart-items-container">
						<div class="sentient-header-cart-items">
							<div class="sentient-header-search-pointer-main sentient-header-search-tooltip">
								<div class="sentient-header-search-pointer">▴</div>
							</div>
							<div class="widget_shopping_cart_content">
								<?php echo sentient_get_header_cart(); ?>
							</div>
						</div>
					</div>
				</div>
				<?php } ?>
				
				<!-- Menu Container
				================================================== -->	
				<div id="cssmenu">						
					<?php wp_nav_menu( array( 'theme_location' => 'header-menu' , 'fallback_cb' => 'sentient_menu_fall_back', 'walker' => new sentient_description_walker() )); ?>					
				</div>
				
				<span class="mobileMenu-icon"><i class="icon-menu"></i></span>
			</div>	
		</div>
		
		<!-- Mobile Container
		================================================== -->			
		<div id='mobileMenu' class="mobile-menu-three">
			<span class="mobileMenu-icon-close"><i class="icon-cancel"></i></span>			
			<div id="MobileMenuContainer">			
				<?php wp_nav_menu( array( 'theme_location' => 'header-menu' , 'fallback_cb' => 'sentient_menu_fall_back', 'walker' => new sentient_description_walker() )); ?>					
			</div>
		</div>		
	</div>
	<!-- Menu Style 3 End
	================================================== -->	



	<!-- Menu Style 4 Started
	================================================== -->		
	<?php
		/* Menu Option Four*/	
	} elseif($SentientHeaderOption == 'OptionFour') { 
	?>
	
	<!-- Phone/Email/Language/Login Container
	================================================== -->		
	<?php if (of_get_option('select_top_header_section',$prof_default) == 'On') { ?>
	<div class="sentient-header-top-container sentient-body-style-four">
		<div class="sentient-header-top-internal-container">
			<div class="sentient-header-top-info-container">
				<span class="sentient-header-phone"><?php _e('Call Us: ', 'sentient'); ?><?php echo esc_attr(of_get_option('theme_site_phone',$prof_default)); ?></span>
				<span class="sentient-header-email"><?php _e('Email: ', 'sentient'); ?><a href="mailto:<?php echo esc_attr(of_get_option('theme_site_email',$prof_default)); ?>"><?php echo esc_attr(of_get_option('theme_site_email',$prof_default)); ?></a></span>			
			</div>
			<div class="sentient-header-top-social-container">
				<div class="sentient-header-top-login-divider">
					<span class="sentient-header-login-title"><a href="<?php echo esc_url(wp_login_url()); ?>"><?php _e('Login', 'sentient'); ?></a></span>
				</div>
				<div class="sentient-header-top-login-divider">
					<span class="sentient-header-top-info-languages"><a href="#"><?php _e('Languages', 'sentient'); ?></a><span class="sentient-menu-arrow">&#59232;</span></span>				
				</div>
			</div>			
		</div>
	</div>
	<?php } ?>
	
	
	<div class="container-wide sentient-body-style-four <?php echo $sentient_sticky; ?>">
		<div class="logo-container">
						
			<!-- Logo Container
			================================================== -->					
			<div class="logo">				
				<a href="<?php  echo esc_url(home_url()); ?>" title="<?php bloginfo( 'name' ) ?>" rel="home">
					<?php if (!sentient_check_if_empty(of_get_option('theme_logo',$prof_default))){?>
					<img src="<?php echo esc_url(of_get_option('theme_logo',$prof_default)); ?>" alt="logo" />
					<?php } else { ?>
					<h1 class="prof-page-title"><?php echo esc_attr(of_get_option('theme_site_logo_text',$prof_default)); ?></h1>
					<?php } ?>
				</a>
			</div>
			
			<!-- Social Container
			================================================== -->						
			<div class="sentient-header-bottom-social sentient-header-top-social-container sentient-header-four-social-container">
				<?php if(of_get_option('flicker_user_account',$prof_default) != ''){ ?>
				<div class="sentient-header-top-social-two-divider">
					<span class="sentient-header-top-info-flickr"><a target="_blank" href="<?php echo esc_url(of_get_option('flicker_user_account',$prof_default)); ?>"><i class="icon-flickr"></i></a></span>
				</div>
				<?php } ?>
				<?php if(of_get_option('vimeo_user_account',$prof_default) != ''){ ?>				
				<div class="sentient-header-top-social-two-divider">
					<span class="sentient-header-top-info-vimeo"><a target="_blank" href="<?php echo esc_url(of_get_option('vimeo_user_account',$prof_default)); ?>"><i class="icon-vimeo"></i></a></span>			
				</div>
				<?php } ?>
				<?php if(of_get_option('twitter_user_account',$prof_default) != ''){ ?>				
				<div class="sentient-header-top-social-two-divider">
					<span class="sentient-header-top-info-twitter"><a target="_blank" href="<?php echo esc_url(of_get_option('twitter_user_account',$prof_default)); ?>"><i class="icon-twitter"></i></a></span>			
				</div>
				<?php } ?>
				<?php if(of_get_option('facebook_user_account',$prof_default) != ''){ ?>					
				<div class="sentient-header-top-social-two-divider">
					<span class="sentient-header-top-info-facebook"><a target="_blank" href="<?php echo esc_url(of_get_option('facebook_user_account',$prof_default)); ?>"><i class="icon-facebook"></i></a></span>				
				</div>
				<?php } ?>
				<?php if(of_get_option('dribbble_user_account',$prof_default) != ''){ ?>				
				<div class="sentient-header-top-social-two-divider">
					<span class="sentient-header-top-info-dribbble"><a target="_blank" href="<?php echo esc_url(of_get_option('dribbble_user_account',$prof_default)); ?>"><i class="icon-dribbble"></i></a></span>			
				</div>
				<?php } ?>
				<?php if(of_get_option('linkedin_user_account',$prof_default) != ''){ ?>				
				<div class="sentient-header-top-social-two-divider">
					<span class="sentient-header-top-info-linkedin"><a target="_blank" href="<?php echo esc_url(of_get_option('linkedin_user_account',$prof_default)); ?>"><i class="icon-linkedin"></i></a></span>			
				</div>
				<?php } ?>	
				<?php if(of_get_option('google_user_account',$prof_default) != ''){ ?>				
				<div class="sentient-header-top-social-two-divider">
					<span class="sentient-header-top-info-google"><a target="_blank" href="<?php echo esc_url(of_get_option('google_user_account',$prof_default)); ?>"><i class="icon-gplus"></i></a></span>			
				</div>
				<?php } ?>
				<?php if(of_get_option('rss_user_account',$prof_default) != ''){ ?>				
				<div class="sentient-header-top-social-two-divider">
					<span class="sentient-header-top-info-rss"><a target="_blank" href="<?php echo esc_url(of_get_option('rss_user_account',$prof_default)); ?>"><i class="icon-rss"></i></a></span>			
				</div>
				<?php } ?>
				<?php if(of_get_option('pinterest_user_account',$prof_default) != ''){ ?>				
				<div class="sentient-header-top-social-two-divider">
					<span class="sentient-header-top-info-pinterest"><a target="_blank" href="<?php echo esc_url(of_get_option('pinterest_user_account',$prof_default)); ?>"><i class="icon-pinterest"></i></a></span>			
				</div>
				<?php } ?>	
				<?php if(of_get_option('github_user_account',$prof_default) != ''){ ?>				
				<div class="sentient-header-top-social-two-divider">
					<span class="sentient-header-top-info-github"><a target="_blank" href="<?php echo esc_url(of_get_option('github_user_account',$prof_default)); ?>"><i class="icon-github"></i></a></span>			
				</div>
				<?php } ?>
				<?php if(of_get_option('tumblr_user_account',$prof_default) != ''){ ?>				
				<div class="sentient-header-top-social-two-divider">
					<span class="sentient-header-top-info-tumblr"><a target="_blank" href="<?php echo esc_url(of_get_option('tumblr_user_account',$prof_default)); ?>"><i class="icon-tumblr"></i></a></span>			
				</div>
				<?php } ?>
				<?php if(of_get_option('instagram_user_account',$prof_default) != ''){ ?>				
				<div class="sentient-header-top-social-two-divider">
					<span class="sentient-header-top-info-instagram"><a target="_blank" href="<?php echo esc_url(of_get_option('instagram_user_account',$prof_default)); ?>"><i class="icon-instagram"></i></a></span>			
				</div>
				<?php } ?>
				<?php if(of_get_option('skype_user_account',$prof_default) != ''){ ?>				
				<div class="sentient-header-top-social-two-divider">
					<span class="sentient-header-top-info-skype"><a target="_blank" href="<?php echo esc_url(of_get_option('skype_user_account',$prof_default)); ?>"><i class="icon-skype"></i></a></span>			
				</div>
				<?php } ?>				
			</div>
		</div>			
	</div>
	<div class="sentient-header-bottom-container sentient-body-style-four <?php echo $sentient_sticky; ?>">
		<div class="sentient-header-bottom-internal">
	
			<!-- Menu Container
			================================================== -->				
			<div class="sentient-header-bottom-menu">
				<div class="navigation">
					<div id="cssmenu">						
						<?php wp_nav_menu( array( 'theme_location' => 'header-menu' , 'fallback_cb' => 'sentient_menu_fall_back', 'walker' => new sentient_description_walker() )); ?>					
					</div>
					<span class="mobileMenu-icon"><i class="icon-menu"></i></span>
				</div>			
			</div>				
			<div class="sentient-header-bottom-cart">
			
				<!-- Search Container
				================================================== -->
				<?php if (of_get_option('select_search',$prof_default) == 'On') { ?>					
				<div class="sentient-header-search-container">
					<form action="<?php echo esc_url(get_site_url()); ?>" id="searchform" method="get" role="search">
						<span class="sentient-header-search-icon"><a id="searchsubmit"><i class="icon-search"></i></a></span>							
						<div class="sentient-header-search-input-container animated">
							<input type="search" id="s" name="s" value="" placeholder="Search...">
							<div class="sentient-header-search-pointer-main"><div class="sentient-header-search-pointer">&#9652;</div></div>
						</div>
					</form>
				</div>					
				<?php } ?>
				
				
				<!-- Cart Container
				================================================== -->				
				<?php
					global $woocommerce; 
					if (class_exists('Woocommerce') && of_get_option('select_cart',$prof_default) == 'On') {	
				?>
					<div class="sentient-header-cart-container">
						<a class="cart-contents" href="<?php echo esc_url($woocommerce->cart->get_cart_url()); ?>" title="<?php _e('View your shopping cart', 'woothemes'); ?>"><span class="sentient-header-cart">&#59197;</span><span class="sentient-header-cart-count"><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'woothemes'), $woocommerce->cart->cart_contents_count);?></span></a>
						<div class="sentient-header-cart-items-container">
							<div class="sentient-header-cart-items">
								<div class="sentient-header-search-pointer-main sentient-header-search-tooltip">
									<div class="sentient-header-search-pointer">▴</div>
								</div>
								<div class="widget_shopping_cart_content">
									<?php echo sentient_get_header_cart(); ?>
								</div>
							</div>
						</div>
					</div>
				<?php } ?>
				
			</div>
		</div>
		
		<!-- Mobile Container
		================================================== -->				
		<div id='mobileMenu' class="mobile-menu-four">
			<span class="mobileMenu-icon-close"><i class="icon-cancel"></i></span>			
			<div id="MobileMenuContainer">			
				<?php wp_nav_menu( array( 'theme_location' => 'header-menu' , 'fallback_cb' => 'sentient_menu_fall_back', 'walker' => new sentient_description_walker() )); ?>					
			</div>
		</div>		
	</div>

	<!-- Menu Style 4 End
	================================================== -->	

	<?php
		/* Menu Option One*/	
		} else {
	?>

	<!-- Menu Style 1 Started
	================================================== -->
	<div class="container-wide sentient-style-one <?php echo $sentient_sticky; ?>">
		<div class="logo-container">
			
			<!-- Logo Container
			================================================== -->						
			<div class="logo">				
				<a href="<?php  echo esc_url(home_url()) ; ?>" title="<?php bloginfo( 'name' ) ?>" rel="home">
					<?php if (!sentient_check_if_empty(of_get_option('theme_logo',$prof_default))){?>
					<img src="<?php echo esc_url(of_get_option('theme_logo',$prof_default)); ?>" alt="logo" />
					<?php } else { ?>
					<h1 class="prof-page-title"><?php echo esc_attr(of_get_option('theme_site_logo_text',$prof_default)); ?></h1>
					<?php } ?>
				</a>
			</div>										
			<div class="navigation">
				
				<!-- Menu Search Container
				================================================== -->
				<?php if (of_get_option('select_search',$prof_default) == 'On') { ?>					
				<div class="sentient-header-search-container">
					<form action="<?php echo esc_attr(get_site_url()); ?>" id="searchform" method="get" role="search">
						<span class="sentient-header-search-icon"><a id="searchsubmit"><i class="icon-search"></i></a></span>							
						<div class="sentient-header-search-input-container animated">
							<input type="search" id="s" name="s" value="" placeholder="Search...">
							<div class="sentient-header-search-pointer-main"><div class="sentient-header-search-pointer">&#9652;</div></div>
						</div>
					</form>
				</div>			
				<?php } ?>
				
				<!-- Menu Cart Container
				================================================== -->						
				<?php
					global $woocommerce; 
					if (class_exists('Woocommerce') && of_get_option('select_cart',$prof_default) == 'On') {	
				?>
				<div class="sentient-header-cart-container">
					<a class="cart-contents" href="<?php echo esc_url($woocommerce->cart->get_cart_url()); ?>" title="<?php _e('View your shopping cart', 'woothemes'); ?>"><span class="sentient-header-cart">&#59197;</span><span class="sentient-header-cart-count"><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'woothemes'), $woocommerce->cart->cart_contents_count);?></span></a>
					<div class="sentient-header-cart-items-container">
						<div class="sentient-header-cart-items">
							<div class="sentient-header-search-pointer-main sentient-header-search-tooltip">
								<div class="sentient-header-search-pointer">▴</div>
							</div>
							<div class="widget_shopping_cart_content">
								<?php echo sentient_get_header_cart(); ?>
							</div>
						</div>
					</div>
				</div>
				<?php } ?>
				
				
				<!-- Menu Container
				================================================== -->							
				<div id="cssmenu">						
					<?php wp_nav_menu( array( 'theme_location' => 'header-menu' , 'fallback_cb' => 'sentient_menu_fall_back', 'walker' => new sentient_description_walker() )); ?>					
				</div>
				
				<span class="mobileMenu-icon"><i class="icon-menu"></i></span>
			</div>
		</div>			
	</div>
		
	<!-- Mobile Menu Started
	================================================== -->	
	<div id='mobileMenu'>
		<span class="mobileMenu-icon-close"><i class="icon-cancel"></i></span>			
		<div id="MobileMenuContainer">			
			<?php wp_nav_menu( array( 'theme_location' => 'header-menu' , 'fallback_cb' => 'sentient_menu_fall_back', 'walker' => new sentient_description_walker() )); ?>					
		</div>
	</div>
	<!-- Menu Style 1 End
	================================================== -->		
	<?php } ?>
		


	<!-- Start the Pages
	================================================== -->	
	<?php
	
	if($SentientHeaderOption == 'OptionOne') {	
		$sentient_menu_body_class = 'sentient-style-one';
	}elseif($SentientHeaderOption == 'OptionTwo') {
		$sentient_menu_body_class = 'sentient-body-style-two';	
	}elseif($SentientHeaderOption == 'OptionThree'){
		$sentient_menu_body_class = 'sentient-body-style-three';	
	} elseif($SentientHeaderOption == 'OptionFour') { 
		$sentient_menu_body_class = 'sentient-body-style-four';	
	} else {
		$sentient_menu_body_class = 'sentient-style-one';
	}
	?>	
	<div  id="SentientMainContentContainer" class="boxed <?php echo esc_attr($sentient_menu_body_class);?> <?php echo $sentient_sticky; ?>">	
