function tutorial_create_slideshow() {
 
	// Remove the HTML tags generated in the gallery.
	if(jQuery('.gallery').hasClass('gallery-slideshow')){

		jQuery('.single-format-gallery style').remove();
		jQuery('.gallery br').remove();
		
		jQuery('.gallery-slideshow').each(function( index ) {
		  
			// Wrap the gallery.
			var profid = jQuery(this).attr('id');
			jQuery(this).wrap('<div class="gallery-wrap prof-' + profid + '">');
		  
			// Add the slideshow controller.
			jQuery('.gallery-wrap.prof-'+ profid).append('<div id="slideshow-controller-' + index + '" class="slideshow-controller"><span id="jqc-pages-' + index + '"></span></div>');
			
			// Add the controls.
			
			jQuery('.gallery-wrap.prof-' + profid + ' .gallery.gallery-slideshow').cycle({
				fx                : 'fade',
				speed             : 1000,
				timeout           : 3000,
				cleartypeNoBg     : true,
				activePagerClass  : 'jqc-active',
				pager             : '#jqc-pages-' + index,
				prev              : '#jqc-prev',
				next              : '#jqc-next',
				pause             : true,
				pagerAnchorBuilder: function (index,elem) {
					return '<div class="jqc-button jqc-button-pages" id="jqc-button-' + index + '" value="' + index + '"><span></span></div>';
				}
			});			
		});
	
	}
}
 
jQuery(document).ready(function() {
	jQuery.noConflict();
	tutorial_create_slideshow();	
});