
(function($){
	$.fn.rotator = function(options){
		var settings = $.extend({
			starting: 0,
			ending: 100,
			percentage: true,
			color: 'green',
			lineWidth: 7,
			timer: 10,
			radius: 40,
			fontStyle: 'Calibri',
			fontSize: '20pt',
			fontColor: 'darkblue',
			backgroundColor: 'lightgray',
			callback: function () {

			}
		}, options);
			  

		/*this.empty().append("<canvas height ="+this.height() + " width="+this.width()+" id='my-canvas'/ ></canvas>");*/
		if(!this.hasClass("sentient-stop-circle")){
		
			var SentientGenerateID = $(this).attr("sentient-id");
			this.empty().append("<canvas height ="+this.height() + " width="+this.width()+" id='sentient-circle-"+ SentientGenerateID + "'/ ></canvas>");
		

			/*var canvas = document.getElementById('my-canvas');*/
		
			var canvas = document.getElementById("sentient-circle-" + SentientGenerateID + "");

			var x = canvas.width / 2;
			var y = canvas.height / 2;
			var radius = settings.radius;
			var context = canvas.getContext("2d");
			if(settings.backgroundColor){
				var ctx = canvas.getContext('2d');
				ctx.arc(x, y, radius, 0, 2*Math.PI, false);
				ctx.strokeStyle = settings.backgroundColor;
				ctx.lineWidth = settings.lineWidth;
				ctx.stroke()
			}
			var steps = settings.ending - settings.starting;
			var step = settings.starting;
			var z = setInterval(function(){
				var text;
				if(settings.percentage){text = step + "%"}else{text = step}
				var start_angle = (1.5 + (step/50))*Math.PI;
				var end_angle = (1.5 + (++step/50))*Math.PI;
				context.beginPath();
				context.arc(x, y, radius, start_angle, end_angle, false);
				context.lineWidth = settings.lineWidth;
				context.strokeStyle = settings.color;
				context.stroke();
				context.font = '300 ' + settings.fontSize + ' ' + settings.fontStyle;
				context.textBaseline = 'middle';
				context.textAlign = 'center';
				context.fillStyle = settings.fontColor;
				context.clearRect(x - parseInt(settings.fontSize)*1.5, y - parseInt(settings.fontSize)/2, parseInt(settings.fontSize)*3, parseInt(settings.fontSize));
				context.fillText(text, x , y );
				if(step >= steps){
					window.clearInterval(z);
					if(settings.percentage){text = step + "%"}else{text = step}
					context.clearRect(x - parseInt(settings.fontSize)*1.5, y - parseInt(settings.fontSize)/2, parseInt(settings.fontSize)*3, parseInt(settings.fontSize));
					context.fillText(text, x , y );
					if(typeof(settings.callback) == 'function'){
						settings.callback.call(this);
					}
				}
			}, settings.timer)

		}
		
	}
}(jQuery));		  

	


// $(document).ready(function(){
// 	$('#rotator').rotator({
// 		starting: 0,
// 		ending: 100,
// 		lineWidth: 10
// 	})
// })