<?php  
/* Template Name: Template - Portfolio Full Width*/  
?>


<!-- Get Page Header
================================================== -->		
<?php get_header(); ?>



<!-- Page Title Section
================================================== -->		
<?php

	global $prof_default;
	$sentient_breadcrumb_text = __("You are here:  ","sentient");
	if(of_get_option('select_breadcrumb_position',$prof_default) == 'Right') {$breadcrumbPosition = '';} else {$breadcrumbPosition = 'breadcrumb-left';}
?>


<?php if(of_get_option('select_breadcrumb',$prof_default) == 'On'){ ?>
	<div class="homepage-container-design  homepage-container-design-top sentient-page-title-container">
		<div class="homepage-container-design-inner">
			<span class="sentient-page-title-text <?php echo $breadcrumbPosition; ?>"><?php echo get_the_title(); ?></span>
			<span class="sentient-page-breadcrumb-text <?php echo $breadcrumbPosition; ?>"><span class="sentient-page-breadcrumb-text-colored"><?php echo esc_attr($sentient_breadcrumb_text); ?></span><?php sentient_bread_crumbs(); ?></span>
		</div>
	</div>
<?php } ?>


<!-- Page Body Started
================================================== -->		
<div class="portfolio-group-container">
<div id="portfolio" class="sentient-portfolio-full-width-container">

	<!-- Loop Started
	================================================== -->	
	<?php if(have_posts()) : while(have_posts()) : the_post(); ?>
		<?php
			if ($post->post_content == ""){
			
			} else {
		?>
			<div class="portfolio-internal-columns-content">
				<?php the_content(); ?>
			</div>
		<?php } ?>
	<?php endwhile; endif; ?>

	
	<!-- Get Portfolio Client
	================================================== -->		
	<?php
		$cat_count = 1;
		$client_string =  __('Client:  ' , 'sentient');
		
		if(of_get_option('portfolio_pagination',$prof_default) == 'On' ){
			$loop = new WP_Query(array('post_type' => 'portfolio', 'posts_per_page' => 6 , 'paged' => $paged));
		} else {
			$loop = new WP_Query(array('post_type' => 'portfolio', 'posts_per_page' => -1));
		}
				
	?> 
	
	
	<!-- Get Portfolio Categories
	================================================== -->			
	<?php
		$terms = get_terms("portfolio_category");  
		$count = count($terms);  
		$return_string = '';
		$allString = __("All" , "sentient");
		$return_string .='<div class="sentient-portfolio-five-col-filter sentient-portfolio-five-col-filter-internal"><ul id="portfolio-filter">';  
		$return_string .= '<li><button data-filter="*">' . $allString . '</button></li>';  
		if ( $count > 0 ){  
		  
			foreach ( $terms as $term ) {  
				if($term->name != 'Uncategorized' && $term->name != 'uncategorized'){
					$termname = strtolower($term->name);  
					$termname = str_replace(' ', '-', $termname);  
					$return_string .= '<li><button data-filter=".' . $termname . '">' . $term->name . '</button></li>';  
				}
			}  
		}  
		$return_string .= "</ul>";
		
		if(of_get_option('portfolio_pagination',$prof_default) == 'On' ){
			$return_string .= "<div class='portfolio-pagination'>";

			$big = 999999999;
			
			echo $return_string . paginate_links( array(
				'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
				'format' => '?paged=%#%',
				'current' => max( 1, get_query_var('paged') ),
				'total' => $loop->max_num_pages
			) ) . '</div>';
		}
		
		
		
		
		$return_string .= "</div>";

	?>
	
	
	<!-- Page Body Started
	================================================== -->			
	<div class="group portfolio-four-column">  
            <div id="portfolio-wrapper" class="portfolio-wrapper-internal-page sentient-portfolio-fw-container">  
                <ul id="portfolio-list" class="sentient-full-portfolio-items">  
              
                <?php if ( $loop ) :   
                       
                    while ( $loop->have_posts() ) : $loop->the_post(); ?>  
                      <?php
						$terms = get_the_terms( get_the_ID() , 'portfolio_category' );  
														  
						if ( $terms && ! is_wp_error( $terms ) ) {   
							$links = array();  

							foreach ( $terms as $term )   
							{  
								$links[] = $term->name;  
							}  
							$links = str_replace(' ', '-', $links);   
							$tax = join( " ", $links );       
						} else {   
							$tax = '';    
						}

						$tax = strtolower($tax);						
					  ?>
						<li class="grid-sizer <?php echo esc_attr($tax); ?>">
							<div class="sentient-portfolio-fullwidth-thumb">
								<a href="<?php echo esc_url(the_permalink()); ?>">
									<?php the_post_thumbnail('full'); ?>
								</a>
								<a href="<?php echo esc_url(the_permalink()); ?>"><i class="fa-plus"></i></a>
							</div>
							<div class="sentient-portfolio-fw-content">
								<div class="sentient-portfolio-fw-title">
									<a href="<?php echo esc_url(the_permalink()); ?>"><?php the_title(); ?></a>
								</div>
								<div class="sentient-portfolio-fw-client">
									<span class="sentient-portfolio-fw-clientText"><?php echo $client_string; ?></span><span class="sentient-portfolio-fw-clientValue"><a href="<?php echo esc_url(get_post_meta(get_the_ID(), 'Project Client URL', true)); ?>"><?php echo esc_attr(get_post_meta(get_the_ID(), 'Project Client', true)); ?></a></span>
								</div>
								<div class="sentient-portfolio-fw-cat">
								<?php
									$terms = get_the_terms( get_the_ID() , 'portfolio_category' );  
									$separator = ' / ';
									$output = '';
									if ( $terms && ! is_wp_error( $terms ) ) {   
										$links = array();  

										foreach ( $terms as $term )   
										{  
											$output .= '<a href="'. esc_url(get_category_link( $term->term_id )) .'" >'.$term->name.'</a>'.$separator;
											$links[] = $term->name;  
										} 
										
										echo trim($output, $separator);
										
									} else {   
									   
									}						  										  
								?>								
								</div>
								<div class="sentient-portfolio-divider"></div>					
								<div class="sentient-portfolio-fw-text">
									<?php echo strip_shortcodes(wp_trim_words( get_the_excerpt(), 41 )); ?>
								</div>						
							</div>				
						</li>
						<?php $cat_count = 1;	?>                        
			    						
                    <?php endwhile; else: ?>  
                       
                    <li class="error-not-found"><?php _e("Sorry, no portfolio entries for while." , "sentient"); ?></li>  
                          
                <?php endif; ?>  
                </ul>  
                <div class="clearboth"></div> 				
            </div>
		</div>
	</div>
</div>
<!-- Page Body End
================================================== -->		



<!-- Get Page Footer
================================================== -->		
<?php get_footer(); ?>  