<?php  
/* Template Name: Template - Portfolio Two Columns */  
?>



<!-- Get Page Header Section
================================================== -->			
<?php get_header();  ?>



<!-- Page Title Section
================================================== -->	
<?php

	global $prof_default;
	$sentient_breadcrumb_text = __("You are here:  ","sentient");
	if(of_get_option('select_breadcrumb_position',$prof_default) == 'Right') {$breadcrumbPosition = '';} else {$breadcrumbPosition = 'breadcrumb-left';}
?>


<?php if(of_get_option('select_breadcrumb',$prof_default) == 'On'){ ?>
	<div class="homepage-container-design  homepage-container-design-top sentient-page-title-container">
		<div class="homepage-container-design-inner">
			<span class="sentient-page-title-text <?php echo $breadcrumbPosition; ?>"><?php echo get_the_title(); ?></span>
			<span class="sentient-page-breadcrumb-text <?php echo $breadcrumbPosition; ?>"><span class="sentient-page-breadcrumb-text-colored"><?php echo esc_attr($sentient_breadcrumb_text); ?></span><?php sentient_bread_crumbs(); ?></span>
		</div>
	</div>
<?php } ?>


<!-- Page Body Started
================================================== -->	
<div class="portfolio-group-container">
<div id="portfolio" class="group two-column"> 

	<!-- Loop Started
	================================================== -->	
	<?php if(have_posts()) : while(have_posts()) : the_post(); ?>
		<?php
			if ($post->post_content == ""){
			
			} else {
		?>
			<div class="portfolio-internal-columns-content">
				<?php the_content(); ?>
			</div>
		<?php } ?>
	<?php endwhile; endif; ?>

	
	<!-- Portfolio Categories
	================================================== -->		
	<?php
		$terms = get_terms("portfolio_category");  
		$count = count($terms);  
		$return_string = '';
		$allString = __("All" , "sentient");
		$return_string .='<div class="sentient-portfolio-five-col-filter sentient-portfolio-five-col-filter-internal"><ul id="portfolio-filter">';  
		$return_string .= '<li><button data-filter="*">' . $allString . '</button></li>';  
		if ( $count > 0 ){  
		  
			foreach ( $terms as $term ) {  
				if($term->name != 'Uncategorized' && $term->name != 'uncategorized'){
					$termname = strtolower($term->name);  
					$termname = str_replace(' ', '-', $termname);  
					$return_string .= '<li><button data-filter=".'.$termname.'">'.$term->name.'</button></li>';  
				}
			}  
		}  
		$return_string .= "</ul></div>";
		
		echo $return_string;		
	?>	
	<div class="group two-column">  	
		 <?php
			$cat_count = 1;
			
			if(of_get_option('portfolio_pagination',$prof_default) == 'On' ){
				$loop = new WP_Query(array('post_type' => 'portfolio', 'posts_per_page' => 8 , 'paged' => $paged));  	
			} else {
				$loop = new WP_Query(array('post_type' => 'portfolio', 'posts_per_page' => -1));
			}				
			
				
		?>  
		  
		<div id="portfolio-wrapper" class="portfolio-wrapper-internal-page sentient-portfolio-four-col sentient-portfolio-two-col">  
			<ul id="portfolio-list">  
		  
			<?php if ( $loop ) :   
				   
				while ( $loop->have_posts() ) : $loop->the_post(); ?>  
				  <?php
					$terms = get_the_terms( get_the_ID() , 'portfolio_category' );  
													  
					if ( $terms && ! is_wp_error( $terms ) ) :   
						$links = array();  

						foreach ( $terms as $term )   
						{  
							$links[] = $term->name;  
						}  
						$links = str_replace(' ', '-', $links);   
						$tax = join( " ", $links );       
					else :    
						$tax = '';    
					endif;

					$tax = strtolower($tax);
				  ?>
					<li class="grid-sizer <?php echo esc_attr($tax); ?>">
						<div class="sentient-portfolio-four-col-thumb">
							<a href="<?php echo esc_url(the_permalink()); ?>">
								<?php the_post_thumbnail('full') ?>
							</a>
							<a href="<?php echo esc_url(the_permalink()); ?>"><i class="fa-plus"></i></a>
						</div>
						<div class="sentient-portfolio-four-col-content-container">
							<div class="sentient-portfolio-four-col-title">
								<a href="<?php echo esc_url(the_permalink()); ?>"><?php the_title() ?></a>
							</div>
							<div class="sentient-portfolio-four-col-categories">
								<?php
										$terms = get_the_terms( get_the_ID() , 'portfolio_category' );  
										$separator = ' . ';
										$output = '';
										if ( $terms && ! is_wp_error( $terms ) ) {   

											foreach ( $terms as $term )   
											{  
												if($cat_count < 3){											
													$output .= '<a href="' . esc_url(get_category_link( $term->term_id )) . '" >' . $term->name . '</a>'.$separator;
												}
												$cat_count = $cat_count + 1;
											} 
											
											echo trim($output, $separator);
											
										} else {   
										   
										}						  										  
									?>	
								</div>	
						</div>				
					</li>
					<?php $cat_count = 1;	?>                        
									
				<?php endwhile; else: ?>  
				   
				<li class="error-not-found"><?php _e("Sorry, no portfolio entries for while." , "sentient"); ?></li>  
					  
			<?php endif; ?>  

			</ul>  

			<div class="clearboth"></div>
			
			<?php
				if(of_get_option('portfolio_pagination',$prof_default) == 'On' ){
			?>

			<div class="sentient-portfolio-internal-pagination">
			
				<!-- Pagination Started
				================================================== -->	
				<div class="portfolio-pagination">
					<?php

						$big = 999999999;
						
						echo paginate_links( array(
							'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
							'format' => '?paged=%#%',
							'current' => max( 1, get_query_var('paged') ),
							'total' => $loop->max_num_pages
						) );
					?>
				</div>
				<!-- Pagination End
				================================================== -->	


				<!-- Pagination Number Section
				================================================== -->					
				<?php
					$sentient_pagination = '';
					$sentient_page_text = __("Page","sentient");
					$sentient_of_text = __("of","sentient");
					$total = $loop->max_num_pages;

					if ( $total > 1 ) {
						if ( !$current_page = get_query_var('paged') ){$current_page = 1;}
						$sentient_pagination = '<span class="sentient-number-of-pages">' . $sentient_page_text . ' ' . $current_page . ' ' . $sentient_of_text . ' ' . $total . '</span>';
					} else {
						$sentient_pagination = '';
					}
					
					echo $sentient_pagination;
				?>
			</div>
			<?php
				}			
			?>			
		</div> 
	</div>  
</div>
</div>
<!-- Page Body End
================================================== -->	




<!-- Get Page Footer
================================================== -->	
<?php get_footer(); ?>