<?php
/* Search Page */
?>


<!-- Get Page Header
================================================== -->	
<?php get_header(); ?>


<!-- Page Variables and Query
================================================== -->	
<?php

	global $query_string;

	$query_args = explode("&", $query_string);
	$search_query = array();

	foreach($query_args as $key => $string) {
		$query_split = explode("=", $string);
		$search_query[$query_split[0]] = urldecode($query_split[1]);
	}

	$search = new WP_Query($search_query);

?>


<!-- Page Title Section
================================================== -->	
<?php
	global $prof_default;
	$sentient_breadcrumb_text = __("You are here:  ","sentient");
	if(of_get_option('select_breadcrumb_position',$prof_default) == 'Right') {$breadcrumbPosition = '';} else {$breadcrumbPosition = 'breadcrumb-left';}	
?>

<?php if(of_get_option('select_breadcrumb',$prof_default) == 'On'){ ?>
	<div class="homepage-container-design  homepage-container-design-top sentient-page-title-container">
		<div class="homepage-container-design-inner">
			<span class="sentient-page-title-text <?php echo $breadcrumbPosition; ?>"><?php _e( 'Search Results for: "', 'sentient' ); echo urldecode($query_split[1]); _e( '"', 'sentient' ); ?></span>
			<span class="sentient-page-breadcrumb-text <?php echo $breadcrumbPosition; ?>"><span class="sentient-page-breadcrumb-text-colored"><?php echo esc_attr($sentient_breadcrumb_text); ?></span><?php sentient_bread_crumbs(); ?></span>
		</div>
	</div>
<?php } ?>

<!-- Page Content Started
================================================== -->	
<div class="page-main-container page-full-template">
	<div class="middle-container page-full-sample">
		<div class="page-content-container">
			<div class="sentient-new-search-wrapper">
				<div class="sentient-new-search-title"><?php _e("New Search" , "sentient"); ?></div>
				<div class="sentient-new-search-desc"><?php _e("If you didn't find answer in the results below please do another search" , "sentient"); ?></div>				
				<div class="sentient-new-search-form">
					<form action="<?php echo esc_url(get_site_url()); ?>" id="searchform" method="get" role="search">
						<input type="search" id="s" name="s" placeholder="Search...">
						<input type="submit" value="Search" id="searchsubmit">
						<i class="icon-search"></i>
					</form>				
				</div>		
			</div>
			
			<!-- Loop Started
			================================================== -->				
			<?php 
						
			if (have_posts() ) { ?>			 
				<?php while ( have_posts() ) : the_post();?>		
					<div id="post-<?php /*the_ID();*/ ?>" <?php post_class(); ?>>
					
					
						<span class="prof-blog-col-title">
							<a href="<?php echo esc_url(the_permalink()); ?>"><?php the_title(); ?></a>
						</span>
						
						<div class="prof-blog-col-icon-container">
							<span class="blog-modern-thumb-text-date"><?php echo get_the_time('j') . ' ' . get_the_time('M') . ', ' . get_the_time('Y'); ?></span><span class="sentient-blog-normal-date-seperator">.</span>													
							<span class="blog-modern-thumb-text-author"><?php echo  _e('Posted By: ','sentient')?><a href="<?php echo esc_url(get_author_posts_url( get_the_author_meta( 'ID' ) )); ?>"><?php esc_attr(the_author_meta( 'display_name' )); ?></a></span>
						</div> 

						<div class="blog-modern-left-box-content-text">
							<?php echo do_shortcode(strip_shortcodes(wp_trim_words( get_the_content(), 100 ))); ?>
						</div>	
						
					</div>

				<?php endwhile; ?>
				
				<!-- Pagination Started
				================================================== -->						
				<div class="portfolio-pagination">
				<?php
				global $wp_query;

				$big = 999999999;

				echo paginate_links( array(
					'base' => str_replace( $big, '%#%', esc_url( get_pagenum_link( $big ) ) ),
					'format' => '?paged=%#%',
					'current' => max( 1, get_query_var('paged') ),
					'total' => $wp_query->max_num_pages
				) );
				?>
				</div>
				<!-- Pagination End
				================================================== -->		
				
			<?php } else { ?>
			<div id="post-0" class="post no-results not-found">
				<h2 class="entry-title"><?php _e( 'Nothing Found', 'sentient' ) ?></h2>
				<div class="entry-content">
					<p><?php _e( 'Sorry, but nothing matched your search criteria. Please try again with some different keywords.', 'sentient' ); ?></p>                    
				</div>
			</div>
			<?php } ?>   
		</div>
		
		<!-- Page Sidebar
		================================================== -->				
		<div class="sidebar-container blog-sidebar">
			<?php get_sidebar(); ?>
		</div>				
	 </div>
</div>
<!-- Page Content End
================================================== -->	



<!-- Get Page Footer
================================================== -->	
<?php get_footer(); ?>											