<?php
/**
 * The template for displaying product content within loops.
 *
 * Override this template by copying it to yourtheme/woocommerce/content-product.php
 *
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     1.6.4
 */

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

global $product, $woocommerce_loop;

// Store loop count we're currently on
if ( empty( $woocommerce_loop['loop'] ) )
	$woocommerce_loop['loop'] = 0;

// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) )
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );

// Ensure visibility
if ( ! $product || ! $product->is_visible() )
	return;

// Increase loop count
$woocommerce_loop['loop']++;

// Extra post classes
$classes = array();
if ( 0 == ( $woocommerce_loop['loop'] - 1 ) % $woocommerce_loop['columns'] || 1 == $woocommerce_loop['columns'] )
	$classes[] = 'first';
if ( 0 == $woocommerce_loop['loop'] % $woocommerce_loop['columns'] )
	$classes[] = 'last';
?>

<li <?php post_class( $classes ); ?>>

	<?php do_action( 'woocommerce_before_shop_loop_item' ); ?>

			<div class="sentient-top-rated-items-thumb">
				<a href="<?php the_permalink(); ?>">
					<?php
						/**
						 * woocommerce_before_shop_loop_item_title hook
						 *
						 * @hooked woocommerce_show_product_loop_sale_flash - 10
						 * @hooked woocommerce_template_loop_product_thumbnail - 10
						 */
						
						/*do_action( 'woocommerce_before_shop_loop_item_title' );*/
						
						$sentient_sale_text = __("Sale!","sentient");
						if((get_post_meta( get_the_ID(), '_sale_price', true) != get_post_meta( get_the_ID(), '_regular_price', true) && get_post_meta( get_the_ID(), '_sale_price', true) == get_post_meta( get_the_ID(), '_price', true))){
							$sentient_sale = '<span class="sentient-sale">' . $sentient_sale_text . '</span>';
						} else {
							$sentient_sale = '';
						}						
						
						$sentient_gallery_count = 0;
						$sentient_gallery_container = '';
						$sentient_gallery_class = '';
						$sentientargs = array(
							'post_type' => 'attachment',
							'numberposts' => -1,
							'post_status' => null,
							'post_parent' => get_the_ID()
						);

						$attachments = get_posts( $sentientargs );						
						
						if ( $attachments ) {
							foreach ( $attachments as $attachment) {
								if($sentient_gallery_count < 1){
									if(wp_get_attachment_image_src($attachment->ID) != wp_get_attachment_image_src( get_post_thumbnail_id(get_the_ID()) )){
										$sentient_gallery_container = '<div class="sentient-product-second-image">' . wp_get_attachment_image( $attachment->ID, 'full' ) . '</div>';
										$sentient_gallery_class = 'yes-flip-me';
									}
							   }
							   $sentient_gallery_count = $sentient_gallery_count + 1;
							}
						}						
						
						echo '<div class="sentient-product-first-image ' . $sentient_gallery_class . '">' . get_the_post_thumbnail( get_the_ID() , array(280,9999)  ) . $sentient_sale . '</div>';

						echo $sentient_gallery_container;

					?>
				</a>
			</div>
			<div class="sentient-top-rated-items-thumb-content-container">
				<div class="sentient-top-rated-items-title">
					<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
				</div>
				<div class="sentient-top-rated-items-prices">				
					<?php
						$sentient_currency_sale = get_woocommerce_currency_symbol();
						$sentient_get_variation_id = get_post_meta( get_the_ID(), '_min_price_variation_id', true );
							
						if( $sentient_get_variation_id != '' ) {			
							$sentient_price = __("From: " , "sentient") . $sentient_currency_sale . get_post_meta( $sentient_get_variation_id, '_price', true );
							$sentient_sale = '';
						}
						else{
							$sentient_sale = get_post_meta( get_the_ID(), '_sale_price', true);
							if($sentient_sale == ''){
								$sentient_price = $sentient_currency_sale . get_post_meta( get_the_ID(), '_regular_price', true);
							} else {
								$sentient_price = '<del>' . $sentient_currency_sale . get_post_meta( get_the_ID(), '_regular_price', true) . '</del>';
							}					
						}

						if($sentient_sale == ''){$sentient_sale_container='';} else {$sentient_sale_container=' - <span class="sentient-product-slider-sale-price">' . $sentient_currency_sale . $sentient_sale . '</span>';}
										
					?>
					<span class="sentient-product-slider-regular-price"><?php echo $sentient_price; ?></span><?php echo $sentient_sale_container; ?>
					<?php woocommerce_template_loop_price(); ?>					
				</div>			
			</div>		

			<?php 
				$product_content= '<a class="button add_to_cart_button product_type_simple added" data-product_sku="" data-product_id="' . get_the_ID() . '" rel="nofollow" href="' . do_shortcode('[add_to_cart_url id="' . get_the_ID() . '"]') . '">Add to cart</a>';
				$sentient_more_details = __("More Details","sentient");	
			?>

			<div class="sentient-top-rated-items-buttons">
				<span class="sentient-top-rated-items-add-to-cart"><?php echo $product_content ?></span>
				<span class="sentient-top-rated-items-view-details"><a href="<?php the_permalink() ?>"><i class="fa-list"></i><?php echo $sentient_more_details ?></a></span>
			</div>			
		<?php
			/**
			 * woocommerce_after_shop_loop_item_title hook
			 *
			 * @hooked woocommerce_template_loop_rating - 5
			 * @hooked woocommerce_template_loop_price - 10
			 */
			
			/*do_action( 'woocommerce_after_shop_loop_item_title' );*/
		?>


	<?php /* do_action( 'woocommerce_after_shop_loop_item' ); */ ?>

</li>

