DROP TABLE IF EXISTS `retengcms_admin`;
CREATE TABLE `retengcms_admin` (
  `userid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `username` char(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `logintime` varchar(10) NOT NULL,
  `allowmultilogin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `roleid` int(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_admin_cache`;
CREATE TABLE `retengcms_admin_cache` (
  `userid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `username` char(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `logintime` varchar(10) NOT NULL,
  `allowmultilogin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `roleid` int(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_ads`;
CREATE TABLE `retengcms_ads` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL DEFAULT 'name',
  `introduce` varchar(255) DEFAULT NULL,
  `adsposid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `type` varchar(10) NOT NULL,
  `linkurl` varchar(100) NOT NULL DEFAULT 'http://',
  `imageurl` varchar(100) NOT NULL DEFAULT 'http://',
  `alt` varchar(80) NOT NULL DEFAULT 'http://www.reteng.org',
  `flashurl` varchar(100) NOT NULL DEFAULT 'http://',
  `wmode` varchar(20) DEFAULT NULL,
  `text` text,
  `text_link` varchar(100) NOT NULL DEFAULT 'http://',
  `code` text,
  `fromdate` varchar(20) NOT NULL DEFAULT '0',
  `todate` varchar(20) NOT NULL DEFAULT '0',
  `addtime` varchar(20) NOT NULL DEFAULT '0',
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `clicks` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ispassed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fromdate` (`fromdate`,`todate`),
  KEY `adsposid` (`adsposid`,`ispassed`,`fromdate`,`todate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_adspos`;
CREATE TABLE `retengcms_adspos` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(50) NOT NULL,
  `template` char(30) NOT NULL DEFAULT '0',
  `introduce` char(100) DEFAULT NULL,
  `price` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `width` smallint(4) unsigned NOT NULL DEFAULT '0',
  `number` tinyint(2) NOT NULL DEFAULT '0',
  `height` smallint(4) unsigned NOT NULL DEFAULT '0',
  `ispassed` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `option` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_appointment`;
CREATE TABLE `retengcms_appointment` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `username` varchar(40) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `appdate` varchar(40) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_article`;
CREATE TABLE `retengcms_article` (
  `contentid` mediumint(8) NOT NULL,
  `content` mediumtext NOT NULL,
  `editor` varchar(30) NOT NULL,
  `copyfrom` varchar(100) NOT NULL,
  `video` varchar(255) NOT NULL,
  KEY `contentid` (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_article` VALUES('1','<p style=\"text-indent: 2em; text-align: left;\">按照哲学的原理，任何事物都是运动变化发展的，那么作为影视制作公司的我们也是需要发展的，在日新月异的今天，我们更应该要有创新的精神，那么创新应该体现在哪些方面呢？巨石企业宣传片制作公司作为一家为企业制作宣传片，专题片以及各种视频制作的公司，从拍摄到后期制作都是需要创新的，那么今天给大家分析拍摄镜头方面的创新。</p><p style=\"text-indent: 2em; text-align: left;\">1、宣传片拍摄需要在技术上创新</p><p style=\"text-indent: 2em; text-align: left;\">企业宣传片的拍摄不仅局限于一般的推、拉、摇、移。因为各个企业所从事的行业不同，因此，我们不仅要满足这几点之外，还应满足在水下拍摄，以及航拍的技巧，做到这几个拍摄中也能清晰而稳重。这是需要我们创新的。</p><p style=\"text-indent: 2em; text-align: left;\">2、宣传片拍摄需要在角度上创新</p><p style=\"text-indent: 2em; text-align: left;\">宣传片的拍摄不仅局限于一个角度，不同角度的拍摄能给人呈现不同的视觉感受，因此，在宣传片拍摄过程中，要根据具体的场景以及景物来发挥拍摄的水平，多角度的取景拍摄，以达到完美的效果。</p><p style=\"text-indent: 2em; text-align: left;\">3、宣传片拍摄需要在自身身上创新</p><p style=\"text-indent: 2em; text-align: left;\">作为影视公司的摄影师，拍摄出的作品就代表了这个公司的拍摄水平，因此，一个好的摄影师就应该在自身身上不断的创新，以求达到更高更好更完美的境界，让自己拍摄的作品让客户找不出挑剔的理由。</p><p style=\"text-indent: 2em; text-align: left;\">因此，创新很重要，不仅是针对影视广告制作行业，其他行业也是一样，只有创新才能使企业不断的进步与发展。</p>','','热腾CMS（RTCMS）','');
REPLACE INTO `retengcms_article` VALUES('2','<p style=\"text-indent: 2em; text-align: left;\">虽然企业宣传片设计有别于一般的绘画艺术，但是它毕竟不是简单的商品外观展示与勾画。从某种意义上来说，宣传片作品的设计也是一门艺术，是一种有目的的审美创造活动。成功的宣传片作品能够集科学、艺术与文化于一身，给人以美的享受。宣传片制作中，光依靠创意什么的是不能真正成功的，符合人们的审美的，才能更好的去成功，那么宣传片制作中都有哪些美学特征呢？</p><p style=\"text-indent: 2em; text-align: left;\">追求美和欣赏美是现代社会人的心理需要的一部分，也是现代社会文明的重要标志。对美的追求是人类的天性，体现了社会文化的进步与发展。宣传片作品设计是一种商业美的创造，具有美的特征。它将企业与商品的形象赋予美的无限意义，使宣传片作品达到实用与审美的有机统一，挥然一体。通幼宣传片作品设计，企业将人文美学引入宣传活动之中，不仅使美学向应用方向发展，而且使宣传片作品获得美的特质。基于人文美学而创造的意境，能够无限满足公众的美学情趣，并激发出公众无穷的想象力。</p><p style=\"text-indent: 2em; text-align: left;\">现代公众比较注重感性化思维，如果只有内容意境美，公众可能体验不出其中的美。对于现代公众来说，宣传片作品只有当内容意境美与形式美有机统一后，才能真正发挥作用。为了更好地表达官传片主题，吸引公众的注意力，宣传片作品必须强化形式美感。</p><p style=\"text-indent: 2em; text-align: left;\">和谐美就是多样统一。多样统一是人文美学的一般规律，也是成功作品所遵循的一个共同准则。它要求宣传片作品无论是内容还是形式，都应该在统一中求得变化，在变化中求得统一、将各种因素有机地组合在一起，做到既丰富多彩，又活泼有序。</p>','','热腾CMS（RTCMS）','');
REPLACE INTO `retengcms_article` VALUES('3','<p style=\"text-indent: 2em; text-align: left;\">酒店都是集商务、旅游、度假、休闲、餐饮、娱乐于一体的按五星级标准建设的综合型大酒店，品位和档次都非同一般，其消费群体都是中高层社会人士。因此酒店企业形象宣传片在主题定位上就得彰显出酒店的魅力，根据酒店对其宣传片的几点要求，RAD辐射视觉根据之前拍摄制作的经验对酒店企业形象宣传片拍摄制作方案进行归纳：</p><p style=\"text-indent: 2em; text-align: left;\">首先是主题阐述：酒店形象宣传片主要艺术地再现酒店高雅、时尚、尊贵、舒适等，酒店是梦想的府邸，是盈满好梦的故土，都市精英情迷的精神家园；正因如此，才显卓越本色，才能在同行业中永远超群，这也是与酒店企业形象相吻合的。</p><p style=\"text-indent: 2em; text-align: left;\">中间根据酒店功能的不同特点提炼不同的诉求点，集中反映酒店的文化和经营理念、硬件设施、优美环境、优质服务、特色餐饮、特色服务等融合而成的形象品牌，需要在宣传片中集中彰扬：</p><p style=\"text-indent: 2em; text-align: left;\">然后进入创作思路描述：酒店企业形象宣传片大气、高档次、高品位，全片上下既体现酒店功能设施与服务品牌的完美结合，又贯穿企业文化与艺术风格的和谐统一。充分应用演员把身临其境的感受注入酒店经营，彰显时尚，提升休闲生活艺术般享受的品位。制作时大量运用特效画面与特效声音合成，以富于艺术性，增强可视性和感染力。</p>','','热腾CMS（RTCMS）','');
REPLACE INTO `retengcms_article` VALUES('4','<p style=\"text-indent: 2em; text-align: left;\">现在对于拥有一定实力的企业来说，为了企业的进一步的发展和宣传，企业宣传片的制作就显得非常的重要，因为这可以在一定程度上帮助企业进行宣传传播，相对于生硬的广告，宣传片也是有优势的，那么企业宣传片的具体分类和制作时怎样的呢？</p><p style=\"text-indent: 2em; text-align: left;\">1、企业整体宣传片——用于企业对外交往，赠送给上级领导、大客户或目标客户；企业自身进行新员工培训；企业阶段性的工作总结的影视版。一般时长在5至8分钟最长可至10—15分钟。</p><p style=\"text-indent: 2em; text-align: left;\">2、企业形象宣传片——用于企业展会或大型会议前播放。一般时长为3—5分钟。</p><p style=\"text-indent: 2em; text-align: left;\">3、企业产品演示片——用于系统全面地介绍企业主打产品或新产品、系列产品的整体介绍，多作为产品的平面宣传品的附件赠送给客户和消费者。一般时长为3—5分钟，最长为10分钟左右。</p><p style=\"text-indent: 2em; text-align: left;\">企业宣传片的制作：</p><p style=\"text-indent: 2em; text-align: left;\">目前企业宣传片的制作根据企业的具体要求和预算可分为数字BET和数字高清摄像机、胶片制作两种。前者采用数字摄像机进行拍摄，辅助以专业灯光及影视设备的整合运用的拍摄制作方式。</p><p style=\"text-indent: 2em; text-align: left;\">后者采用现代国际、国内知名企业通用的数字高清摄像机或采用电影胶片16毫米或35毫米摄影机进行拍摄，这种方式其视觉表现力和冲击力更强，画质更加完美。</p><p style=\"text-indent: 2em; text-align: left;\">上述两种企业宣传片的制作方式在整体拍摄上都已摒弃了过去一些传统的电视台编导拍摄专题片的操作方式。取尔代之，采用目前运用在电视剧和电影领域的影视拍摄和制作手法，配合运用一些如广角镜、轨道、摇臂升降及专业影视灯光等专业的辅助设备。此外，根据企业的不同特点有时还需要适当的融入专业演员进行角色扮演以达到更加完美的表现效果。后期制作采用数字无损工作站进行，适当进行二维、三维的视频制作包装，力求使全片表现力更强，更具国际感、现代感。</p>','','热腾CMS（RTCMS）','');
REPLACE INTO `retengcms_article` VALUES('5','<p style=\"text-indent: 2em; text-align: left;\">宣传片的策划案，在整个片子的制作中都是至关重要的，片子的策划案能把握整个片子的结构、内容、思路走向等等，是决定整个片子质量的好坏重要要素，那么细分下，宣传片的策划案能够起到哪些具体的作用呢？北京零度数字带您一起来看看：</p><p style=\"text-indent: 2em; text-align: left;\">视觉艺术、画面思维是宣传片制作中的基本思维。我们最终的目的是展现在观众面前的是具有视觉欣赏能力的片子，所以，我们在制作中要考虑最终的视觉欣赏，是不是符合消费者的欣赏，是不是能够达到我们的预期效果。</p><p style=\"text-indent: 2em; text-align: left;\">专题片制作是需要片头的，片头起到承上启下的作用，所以，我们的正片是在片头的哪个位置切入进去最好，最适合我们观众的观看。</p><p style=\"text-indent: 2em; text-align: left;\">细节是表现人物、时间、社会环节和自然景物的最小元素，越是把握好细节，从而越能给观众留下深刻的印象。</p><p style=\"text-indent: 2em; text-align: left;\">最后就是宣传片的思维角度，我们的产品是卖给消费者的，所以，我们的策划者在策划的过程中要站在消费者的角度深思熟虑的考虑到我们消费者的想法，从这个角度挖掘产品的内涵，从而获取展现的机会。</p>','','热腾CMS（RTCMS）','');
REPLACE INTO `retengcms_article` VALUES('6','<p style=\"text-indent: 2em; text-align: left;\">沃尔沃集团2010年企业宣传片（Corporate Presentation 2010）在于日前举行的戛纳商业媒体和电视大奖（Cannes Corporate Media and TV Awards）上收获颇丰。在10月14日举行的颁奖礼上，由Stark Film &amp; Event AB制作的沃尔沃企业宣传片获得市场营销类别最佳动画、最佳画面以及最佳特效金奖。</p><p style=\"text-indent: 2em; text-align: left;\">　　整个影片旨在推介沃尔沃集团——全球领先的商业运输解决方案供应商。它战胜了其它来自27个国家的350个参赛短片，在法国戛纳最终夺魁。</p><p style=\"text-indent: 2em; text-align: left;\">　　沃尔沃集团品牌管理副总裁Mats Nilsson表示：对宣传片能在企业之外和目标受众中赢得如此多的赞誉，我们深表荣幸。每次我们播放这个宣传片，它极受到观众的喜爱。</p>','','热腾CMS（RTCMS）','');
REPLACE INTO `retengcms_article` VALUES('7','<p style=\"text-indent: 2em; text-align: left;\">昨日，在国家形象宣传推广合作框架协议签字仪式暨新闻发布会后，中央对外宣传办公室、国务院新闻办公室副主任王仲伟在接受本报记者采访时表示，目前，国家形象宣传片的人物篇已经制作完成，有望本月内在美国播放。</p><p style=\"text-indent: 2em; text-align: left;\">王仲伟告诉记者，国家形象片分为两部分，一个是角度篇，一个是人物篇。目前，人物篇已经制作完成。</p><p style=\"text-indent: 2em; text-align: left;\">“人物篇有两个版本，一个是30秒的版本，一个是1分钟的版本，这两个版本主要是出于不同播放载体的需要。”王仲伟称，在人物篇中，杨利伟、姚明等各领域优秀代表以及普通百姓都在片中出现，展示立体的中国。</p><p style=\"text-indent: 2em; text-align: left;\">对于国家形象宣传片何时在全球播放，王仲伟透露，根据现有进展，时长约12分钟的角度篇仍在后期制作过程中，近期不会播放。根据现在的设想，已经完成的人物篇准备在本月胡锦涛主席访问美国时首先在美国播放，人物篇将出现在美国时代广场以及电视台等相关载体中。随后，国新办计划两部国家形象片陆续在欧洲、拉美、中东等地区进行播放，向世界宣传中国的国家形象，向世界推介中国。除了传统媒体外，国新办还将尝试在全球各个地区的互联网等新兴媒体上播放国家形象宣传片。</p><p style=\"text-indent: 2em; text-align: left;\">在全球各大传统和新兴媒体上播放“中国形象广告”，广告费用谁掏？对此，王仲伟表示，在国家形象宣传片的制作与投放上，国家只是在形象片拍摄与制作上进行补贴，投放等环节完全以商业运作为主体，由专业的公司来进行操作。</p>','','热腾CMS（RTCMS）','');
REPLACE INTO `retengcms_article` VALUES('8','<p style=\"text-align: center;\"><object class=\"\" id=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,19,0\" width=\"640\" height=\"480\"><param name=\"movie\" value=\"/template/chuanmei/images/flvplayer.swf\"/><param name=\"quality\" value=\"high\"/><param name=\"allowFullScreen\" value=\"true\"/><param name=\"FlashVars\" value=\"vcastr_file=http://www.stonecm.com/UploadFiles/projects/信谊制药企业宣传片.flv&amp;BufferTime=3&amp;IsAutoPlay=1\"/><embed src=\"/template/chuanmei/images/flvplayer.swf\" allowfullscreen=\"true\" flashvars=\"vcastr_file=http://www.stonecm.com/UploadFiles/projects/信谊制药企业宣传片.flv&amp;IsAutoPlay=1\" quality=\"high\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" type=\"application/x-shockwave-flash\" width=\"640\" height=\"480\"/></object></p>','','热腾CMS（RTCMS）','');
REPLACE INTO `retengcms_article` VALUES('9','<p style=\"text-align: center;\"><object class=\"\" id=\"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000\" codebase=\"http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version=7,0,19,0\" width=\"640\" height=\"360\"><param name=\"movie\" value=\"/template/chuanmei/images/flvplayer.swf\"/><param name=\"quality\" value=\"high\"/><param name=\"allowFullScreen\" value=\"true\"/><param name=\"FlashVars\" value=\"vcastr_file=http://www.stonecm.com/UploadFiles/projects/融汇地板企业宣传片.flv&amp;BufferTime=3&amp;IsAutoPlay=1\"/><embed src=\"/template/chuanmei/images/flvplayer.swf\" allowfullscreen=\"true\" flashvars=\"vcastr_file=http://www.stonecm.com/UploadFiles/projects/融汇地板企业宣传片.flv&amp;IsAutoPlay=1\" quality=\"high\" pluginspage=\"http://www.macromedia.com/go/getflashplayer\" type=\"application/x-shockwave-flash\" width=\"640\" height=\"360\"/></object></p>','','热腾CMS（RTCMS）','');
REPLACE INTO `retengcms_article` VALUES('10','<p style=\"text-align: center;\"><object type=\"application/x-shockwave-flash\" data=\"http://www.tangxiaoer.com/KS_Inc/vcastr3.swf\" width=\"480\" height=\"320\" id=\"vcastr3\"><param name=\"movie\" value=\"http://www.tangxiaoer.com/KS_Inc/vcastr3.swf\"/><param name=\"allowFullScreen\" value=\"true\"/><param name=\"FlashVars\" value=\"xml=&lt;vcastr&gt;&lt;channel&gt;&lt;item&gt;&lt;source&gt;http://www.tangxiaoer.com/uploadfiles/projects/电影诸子百家预告广告片.flv&lt;/source&gt;&lt;/item&gt;&lt;/channel&gt;&lt;/vcastr&gt;\"/></object></p>','','热腾CMS（RTCMS）','');
REPLACE INTO `retengcms_article` VALUES('11','<p style=\"text-align: center;\"><object type=\"application/x-shockwave-flash\" data=\"http://www.tangxiaoer.com/KS_Inc/vcastr3.swf\" width=\"480\" height=\"384\" id=\"vcastr3\"><param name=\"movie\" value=\"http://www.tangxiaoer.com/KS_Inc/vcastr3.swfKS_Inc/vcastr3.swf\"/><param name=\"allowFullScreen\" value=\"true\"/><param name=\"FlashVars\" value=\"xml=&lt;vcastr&gt;&lt;channel&gt;&lt;item&gt;&lt;source&gt;http://www.tangxiaoer.com/uploadfiles/projects/公寓广告片制作.flv&lt;/source&gt;&lt;/item&gt;&lt;/channel&gt;&lt;/vcastr&gt;\"/></object></p>','','热腾CMS（RTCMS）','');
DROP TABLE IF EXISTS `retengcms_author`;
CREATE TABLE `retengcms_author` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `orderby` int(6) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_badwords`;
CREATE TABLE `retengcms_badwords` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `badwords` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_badwords` VALUES('1','');
DROP TABLE IF EXISTS `retengcms_cache`;
CREATE TABLE `retengcms_cache` (
  `name` varchar(32) NOT NULL,
  `value` mediumtext NOT NULL,
  `expire` int(10) unsigned NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_cache` VALUES('a614f7ae6a553286b580842cf8fa36e7','array (\n  0 => \n  array (\n    \'id\' => \'10\',\n    \'modelid\' => \'1\',\n    \'catid\' => \'26\',\n    \'areaid\' => \'0\',\n    \'template\' => \'article_project\',\n    \'title\' => \'电影预告广告片影视制作\',\n    \'style\' => \'\',\n    \'thumb\' => \'/uploads/image/201409/14113800608762.jpg\',\n    \'keywords\' => \'电影 预告 广告 影视 制作\',\n    \'description\' => \'电影预告广告片影视制作,电影 预告 广告 影视 制作\',\n    \'posid\' => \'1\',\n    \'url\' => \'/show/?id=10&page=1&siteid=1\',\n    \'status\' => \'1\',\n    \'point\' => \'0\',\n    \'amount\' => \'0.00\',\n    \'userid\' => \'1\',\n    \'username\' => \'admin\',\n    \'inputtime\' => \'1411380139\',\n    \'updatetime\' => \'1411380320\',\n    \'clicks\' => \'125\',\n    \'comments\' => \'0\',\n    \'islink\' => \'0\',\n    \'password\' => \'\',\n    \'expire\' => \'0\',\n    \'ispage\' => \'1\',\n    \'pagecount\' => \'20000\',\n    \'iscomment\' => \'1\',\n    \'orderby\' => \'10\',\n    \'siteid\' => \'1\',\n    \'navtype\' => \'\',\n    \'support\' => \'0\',\n    \'oppose\' => \'0\',\n  ),\n  1 => \n  array (\n    \'id\' => \'9\',\n    \'modelid\' => \'1\',\n    \'catid\' => \'24\',\n    \'areaid\' => \'0\',\n    \'template\' => \'article_project\',\n    \'title\' => \'融汇地板企业宣传片\',\n    \'style\' => \'\',\n    \'thumb\' => \'/uploads/image/201409/14113799593231.jpg\',\n    \'keywords\' => \'融汇 地板 企业 宣传\',\n    \'description\' => \'融汇地板企业宣传片,融汇 地板 企业 宣传\',\n    \'posid\' => \'0\',\n    \'url\' => \'/show/?id=9&page=1&siteid=1\',\n    \'status\' => \'1\',\n    \'point\' => \'0\',\n    \'amount\' => \'0.00\',\n    \'userid\' => \'1\',\n    \'username\' => \'admin\',\n    \'inputtime\' => \'1411379909\',\n    \'updatetime\' => \'1411379962\',\n    \'clicks\' => \'107\',\n    \'comments\' => \'0\',\n    \'islink\' => \'0\',\n    \'password\' => \'\',\n    \'expire\' => \'0\',\n    \'ispage\' => \'1\',\n    \'pagecount\' => \'20000\',\n    \'iscomment\' => \'1\',\n    \'orderby\' => \'9\',\n    \'siteid\' => \'1\',\n    \'navtype\' => \'\',\n    \'support\' => \'0\',\n    \'oppose\' => \'0\',\n  ),\n  2 => \n  array (\n    \'id\' => \'8\',\n    \'modelid\' => \'1\',\n    \'catid\' => \'24\',\n    \'areaid\' => \'0\',\n    \'template\' => \'article_project\',\n    \'title\' => \'信谊制药企业宣传片\',\n    \'style\' => \'\',\n    \'thumb\' => \'/uploads/image/201409/14113796513771.jpg\',\n    \'keywords\' => \'制药 企业 宣传\',\n    \'description\' => \'信谊制药企业宣传片,\',\n    \'posid\' => \'0\',\n    \'url\' => \'/show/?id=8&page=1&siteid=1\',\n    \'status\' => \'1\',\n    \'point\' => \'0\',\n    \'amount\' => \'0.00\',\n    \'userid\' => \'1\',\n    \'username\' => \'admin\',\n    \'inputtime\' => \'1411379717\',\n    \'updatetime\' => \'1411379842\',\n    \'clicks\' => \'188\',\n    \'comments\' => \'0\',\n    \'islink\' => \'0\',\n    \'password\' => \'\',\n    \'expire\' => \'0\',\n    \'ispage\' => \'1\',\n    \'pagecount\' => \'20000\',\n    \'iscomment\' => \'1\',\n    \'orderby\' => \'8\',\n    \'siteid\' => \'1\',\n    \'navtype\' => \'\',\n    \'support\' => \'0\',\n    \'oppose\' => \'0\',\n  ),\n)','1411386285');
REPLACE INTO `retengcms_cache` VALUES('31550f8ec6f94efafd853aec827d69cd','array (\n  0 => \n  array (\n    \'id\' => \'7\',\n    \'modelid\' => \'1\',\n    \'catid\' => \'21\',\n    \'areaid\' => \'0\',\n    \'template\' => \'article_article\',\n    \'title\' => \'国家形象宣传片有望在美播放\',\n    \'style\' => \'\',\n    \'thumb\' => \'\',\n    \'keywords\' => \'国家 形象 宣传 有望 播放\',\n    \'description\' => \'昨日，在国家形象宣传推广合作框架协议签字仪式暨新闻发布会后，中央对外宣传办公室、国务院新闻办公室副主任王仲伟在接受本报记者采访时表示，目前，国家形象宣传片的人物篇已经制作完成，有望本月内在美国播放。王仲伟告诉记者，国家形象片分为两部分，一个是角度篇，一个是人物篇。目前，人\',\n    \'posid\' => \'0\',\n    \'url\' => \'/show/?id=7&page=1&siteid=1\',\n    \'status\' => \'1\',\n    \'point\' => \'0\',\n    \'amount\' => \'0.00\',\n    \'userid\' => \'1\',\n    \'username\' => \'admin\',\n    \'inputtime\' => \'1411375035\',\n    \'updatetime\' => \'1411375035\',\n    \'clicks\' => \'150\',\n    \'comments\' => \'0\',\n    \'islink\' => \'0\',\n    \'password\' => \'\',\n    \'expire\' => \'0\',\n    \'ispage\' => \'1\',\n    \'pagecount\' => \'20000\',\n    \'iscomment\' => \'1\',\n    \'orderby\' => \'7\',\n    \'siteid\' => \'1\',\n    \'navtype\' => \'\',\n    \'support\' => \'0\',\n    \'oppose\' => \'0\',\n  ),\n  1 => \n  array (\n    \'id\' => \'6\',\n    \'modelid\' => \'1\',\n    \'catid\' => \'21\',\n    \'areaid\' => \'0\',\n    \'template\' => \'article_article\',\n    \'title\' => \'沃尔沃集团企业宣传片戛纳获金奖\',\n    \'style\' => \'\',\n    \'thumb\' => \'\',\n    \'keywords\' => \'集团 企业 宣传 金奖\',\n    \'description\' => \'沃尔沃集团2010年企业宣传片（Corporate Presentation 2010）在于日前举行的戛纳商业媒体和电视大奖（Cannes Corporate Media and TV Awards）上收获颇丰。在10月14日举行的颁奖礼上，由Stark Film &amp;amp; Event AB制作的沃尔沃企业宣传片获得市场营销类别最佳动画、最佳画面以及最佳特效金\',\n    \'posid\' => \'0\',\n    \'url\' => \'/show/?id=6&page=1&siteid=1\',\n    \'status\' => \'1\',\n    \'point\' => \'0\',\n    \'amount\' => \'0.00\',\n    \'userid\' => \'1\',\n    \'username\' => \'admin\',\n    \'inputtime\' => \'1411375004\',\n    \'updatetime\' => \'1411375004\',\n    \'clicks\' => \'129\',\n    \'comments\' => \'0\',\n    \'islink\' => \'0\',\n    \'password\' => \'\',\n    \'expire\' => \'0\',\n    \'ispage\' => \'1\',\n    \'pagecount\' => \'20000\',\n    \'iscomment\' => \'1\',\n    \'orderby\' => \'6\',\n    \'siteid\' => \'1\',\n    \'navtype\' => \'\',\n    \'support\' => \'0\',\n    \'oppose\' => \'0\',\n  ),\n)','1411386285');
REPLACE INTO `retengcms_cache` VALUES('b7c329917e98d338c4a37b39c6338837','array (\n  0 => \n  array (\n    \'id\' => \'5\',\n    \'modelid\' => \'1\',\n    \'catid\' => \'22\',\n    \'areaid\' => \'0\',\n    \'template\' => \'article_article\',\n    \'title\' => \'宣传片制作前策划的作用体现\',\n    \'style\' => \'\',\n    \'thumb\' => \'\',\n    \'keywords\' => \'宣传 制作 策划 作用 体现\',\n    \'description\' => \'宣传片的策划案，在整个片子的制作中都是至关重要的，片子的策划案能把握整个片子的结构、内容、思路走向等等，是决定整个片子质量的好坏重要要素，那么细分下，宣传片的策划案能够起到哪些具体的作用呢？北京零度数字带您一起来看看：视觉艺术、画面思维是宣传片制作中的基本思维。我们最\',\n    \'posid\' => \'0\',\n    \'url\' => \'/show/?id=5&page=1&siteid=1\',\n    \'status\' => \'1\',\n    \'point\' => \'0\',\n    \'amount\' => \'0.00\',\n    \'userid\' => \'1\',\n    \'username\' => \'admin\',\n    \'inputtime\' => \'1411374919\',\n    \'updatetime\' => \'1411374919\',\n    \'clicks\' => \'113\',\n    \'comments\' => \'0\',\n    \'islink\' => \'0\',\n    \'password\' => \'\',\n    \'expire\' => \'0\',\n    \'ispage\' => \'1\',\n    \'pagecount\' => \'20000\',\n    \'iscomment\' => \'1\',\n    \'orderby\' => \'5\',\n    \'siteid\' => \'1\',\n    \'navtype\' => \'\',\n    \'support\' => \'0\',\n    \'oppose\' => \'0\',\n  ),\n  1 => \n  array (\n    \'id\' => \'4\',\n    \'modelid\' => \'1\',\n    \'catid\' => \'22\',\n    \'areaid\' => \'0\',\n    \'template\' => \'article_article\',\n    \'title\' => \'企业宣传片的详细分类和制作方法都有哪些\',\n    \'style\' => \'\',\n    \'thumb\' => \'\',\n    \'keywords\' => \'企业 宣传 详细 分类 制作 方法 哪些\',\n    \'description\' => \'现在对于拥有一定实力的企业来说，为了企业的进一步的发展和宣传，企业宣传片的制作就显得非常的重要，因为这可以在一定程度上帮助企业进行宣传传播，相对于生硬的广告，宣传片也是有优势的，那么企业宣传片的具体分类和制作时怎样的呢？1、企业整体宣传片——用于企业对外交往，赠送给上级领\',\n    \'posid\' => \'0\',\n    \'url\' => \'/show/?id=4&page=1&siteid=1\',\n    \'status\' => \'1\',\n    \'point\' => \'0\',\n    \'amount\' => \'0.00\',\n    \'userid\' => \'1\',\n    \'username\' => \'admin\',\n    \'inputtime\' => \'1411374897\',\n    \'updatetime\' => \'1411374897\',\n    \'clicks\' => \'200\',\n    \'comments\' => \'0\',\n    \'islink\' => \'0\',\n    \'password\' => \'\',\n    \'expire\' => \'0\',\n    \'ispage\' => \'1\',\n    \'pagecount\' => \'20000\',\n    \'iscomment\' => \'1\',\n    \'orderby\' => \'4\',\n    \'siteid\' => \'1\',\n    \'navtype\' => \'\',\n    \'support\' => \'0\',\n    \'oppose\' => \'0\',\n  ),\n)','1411386285');
REPLACE INTO `retengcms_cache` VALUES('6631818073685dcca1b98428bf00d541','array (\n  0 => \n  array (\n    \'id\' => \'3\',\n    \'modelid\' => \'1\',\n    \'catid\' => \'23\',\n    \'areaid\' => \'0\',\n    \'template\' => \'article_article\',\n    \'title\' => \'酒店服务业拍摄宣传片需要注意哪些\',\n    \'style\' => \'\',\n    \'thumb\' => \'\',\n    \'keywords\' => \'酒店 服务业 拍摄 宣传 需要 注意 哪些\',\n    \'description\' => \'酒店都是集商务、旅游、度假、休闲、餐饮、娱乐于一体的按五星级标准建设的综合型大酒店，品位和档次都非同一般，其消费群体都是中高层社会人士。因此酒店企业形象宣传片在主题定位上就得彰显出酒店的魅力，根据酒店对其宣传片的几点要求，RAD辐射视觉根据之前拍摄制作的经验对酒店企\',\n    \'posid\' => \'0\',\n    \'url\' => \'/show/?id=3&page=1&siteid=1\',\n    \'status\' => \'1\',\n    \'point\' => \'0\',\n    \'amount\' => \'0.00\',\n    \'userid\' => \'1\',\n    \'username\' => \'admin\',\n    \'inputtime\' => \'1411374852\',\n    \'updatetime\' => \'1411374852\',\n    \'clicks\' => \'200\',\n    \'comments\' => \'0\',\n    \'islink\' => \'0\',\n    \'password\' => \'\',\n    \'expire\' => \'0\',\n    \'ispage\' => \'1\',\n    \'pagecount\' => \'20000\',\n    \'iscomment\' => \'1\',\n    \'orderby\' => \'3\',\n    \'siteid\' => \'1\',\n    \'navtype\' => \'\',\n    \'support\' => \'0\',\n    \'oppose\' => \'0\',\n  ),\n  1 => \n  array (\n    \'id\' => \'2\',\n    \'modelid\' => \'1\',\n    \'catid\' => \'23\',\n    \'areaid\' => \'0\',\n    \'template\' => \'article_article\',\n    \'title\' => \'企业宣传片制作中的美学特征有哪些\',\n    \'style\' => \'\',\n    \'thumb\' => \'\',\n    \'keywords\' => \'企业 宣传 制作 美学 特征 哪些\',\n    \'description\' => \'虽然企业宣传片设计有别于一般的绘画艺术，但是它毕竟不是简单的商品外观展示与勾画。从某种意义上来说，宣传片作品的设计也是一门艺术，是一种有目的的审美创造活动。成功的宣传片作品能够集科学、艺术与文化于一身，给人以美的享受。宣传片制作中，光依靠创意什么的是不能真正成功的，\',\n    \'posid\' => \'0\',\n    \'url\' => \'/show/?id=2&page=1&siteid=1\',\n    \'status\' => \'1\',\n    \'point\' => \'0\',\n    \'amount\' => \'0.00\',\n    \'userid\' => \'1\',\n    \'username\' => \'admin\',\n    \'inputtime\' => \'1411374814\',\n    \'updatetime\' => \'1411374814\',\n    \'clicks\' => \'113\',\n    \'comments\' => \'0\',\n    \'islink\' => \'0\',\n    \'password\' => \'\',\n    \'expire\' => \'0\',\n    \'ispage\' => \'1\',\n    \'pagecount\' => \'20000\',\n    \'iscomment\' => \'1\',\n    \'orderby\' => \'2\',\n    \'siteid\' => \'1\',\n    \'navtype\' => \'\',\n    \'support\' => \'0\',\n    \'oppose\' => \'0\',\n  ),\n  2 => \n  array (\n    \'id\' => \'1\',\n    \'modelid\' => \'1\',\n    \'catid\' => \'23\',\n    \'areaid\' => \'0\',\n    \'template\' => \'article_article\',\n    \'title\' => \'企业宣传片创新应该体现在哪些方面呢？\',\n    \'style\' => \'\',\n    \'thumb\' => \'\',\n    \'keywords\' => \'企业 宣传 创新 应该 现在 哪些 方面\',\n    \'description\' => \'按照哲学的原理，任何事物都是运动变化发展的，那么作为影视制作公司的我们也是需要发展的，在日新月异的今天，我们更应该要有创新的精神，那么创新应该体现在哪些方面呢？巨石企业宣传片制作公司作为一家为企业制作宣传片，专题片以及各种视频制作的公司，从拍摄到后期制作都是需要创新的，那\',\n    \'posid\' => \'0\',\n    \'url\' => \'/show/?id=1&page=1&siteid=1\',\n    \'status\' => \'1\',\n    \'point\' => \'0\',\n    \'amount\' => \'0.00\',\n    \'userid\' => \'1\',\n    \'username\' => \'admin\',\n    \'inputtime\' => \'1411374485\',\n    \'updatetime\' => \'1411374485\',\n    \'clicks\' => \'173\',\n    \'comments\' => \'0\',\n    \'islink\' => \'0\',\n    \'password\' => \'\',\n    \'expire\' => \'0\',\n    \'ispage\' => \'1\',\n    \'pagecount\' => \'20000\',\n    \'iscomment\' => \'1\',\n    \'orderby\' => \'1\',\n    \'siteid\' => \'1\',\n    \'navtype\' => \'\',\n    \'support\' => \'0\',\n    \'oppose\' => \'0\',\n  ),\n)','1411386285');
REPLACE INTO `retengcms_cache` VALUES('616a567e3e4bd9f045eae51e18e99d83','array (\n  0 => \n  array (\n    \'id\' => \'10\',\n    \'modelid\' => \'1\',\n    \'catid\' => \'26\',\n    \'areaid\' => \'0\',\n    \'template\' => \'article_project\',\n    \'title\' => \'电影预告广告片影视制作\',\n    \'style\' => \'\',\n    \'thumb\' => \'/uploads/image/201409/14113800608762.jpg\',\n    \'keywords\' => \'电影 预告 广告 影视 制作\',\n    \'description\' => \'电影预告广告片影视制作,电影 预告 广告 影视 制作\',\n    \'posid\' => \'1\',\n    \'url\' => \'/show/?id=10&page=1&siteid=1\',\n    \'status\' => \'1\',\n    \'point\' => \'0\',\n    \'amount\' => \'0.00\',\n    \'userid\' => \'1\',\n    \'username\' => \'admin\',\n    \'inputtime\' => \'1411380139\',\n    \'updatetime\' => \'1411380320\',\n    \'clicks\' => \'125\',\n    \'comments\' => \'0\',\n    \'islink\' => \'0\',\n    \'password\' => \'\',\n    \'expire\' => \'0\',\n    \'ispage\' => \'1\',\n    \'pagecount\' => \'20000\',\n    \'iscomment\' => \'1\',\n    \'orderby\' => \'10\',\n    \'siteid\' => \'1\',\n    \'navtype\' => \'\',\n    \'support\' => \'0\',\n    \'oppose\' => \'0\',\n  ),\n  1 => \n  array (\n    \'id\' => \'9\',\n    \'modelid\' => \'1\',\n    \'catid\' => \'24\',\n    \'areaid\' => \'0\',\n    \'template\' => \'article_project\',\n    \'title\' => \'融汇地板企业宣传片\',\n    \'style\' => \'\',\n    \'thumb\' => \'/uploads/image/201409/14113799593231.jpg\',\n    \'keywords\' => \'融汇 地板 企业 宣传\',\n    \'description\' => \'融汇地板企业宣传片,融汇 地板 企业 宣传\',\n    \'posid\' => \'0\',\n    \'url\' => \'/show/?id=9&page=1&siteid=1\',\n    \'status\' => \'1\',\n    \'point\' => \'0\',\n    \'amount\' => \'0.00\',\n    \'userid\' => \'1\',\n    \'username\' => \'admin\',\n    \'inputtime\' => \'1411379909\',\n    \'updatetime\' => \'1411379962\',\n    \'clicks\' => \'107\',\n    \'comments\' => \'0\',\n    \'islink\' => \'0\',\n    \'password\' => \'\',\n    \'expire\' => \'0\',\n    \'ispage\' => \'1\',\n    \'pagecount\' => \'20000\',\n    \'iscomment\' => \'1\',\n    \'orderby\' => \'9\',\n    \'siteid\' => \'1\',\n    \'navtype\' => \'\',\n    \'support\' => \'0\',\n    \'oppose\' => \'0\',\n  ),\n  2 => \n  array (\n    \'id\' => \'8\',\n    \'modelid\' => \'1\',\n    \'catid\' => \'24\',\n    \'areaid\' => \'0\',\n    \'template\' => \'article_project\',\n    \'title\' => \'信谊制药企业宣传片\',\n    \'style\' => \'\',\n    \'thumb\' => \'/uploads/image/201409/14113796513771.jpg\',\n    \'keywords\' => \'制药 企业 宣传\',\n    \'description\' => \'信谊制药企业宣传片,\',\n    \'posid\' => \'0\',\n    \'url\' => \'/show/?id=8&page=1&siteid=1\',\n    \'status\' => \'1\',\n    \'point\' => \'0\',\n    \'amount\' => \'0.00\',\n    \'userid\' => \'1\',\n    \'username\' => \'admin\',\n    \'inputtime\' => \'1411379717\',\n    \'updatetime\' => \'1411379842\',\n    \'clicks\' => \'188\',\n    \'comments\' => \'0\',\n    \'islink\' => \'0\',\n    \'password\' => \'\',\n    \'expire\' => \'0\',\n    \'ispage\' => \'1\',\n    \'pagecount\' => \'20000\',\n    \'iscomment\' => \'1\',\n    \'orderby\' => \'8\',\n    \'siteid\' => \'1\',\n    \'navtype\' => \'\',\n    \'support\' => \'0\',\n    \'oppose\' => \'0\',\n  ),\n)','1411386288');
DROP TABLE IF EXISTS `retengcms_category`;
CREATE TABLE `retengcms_category` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `modelid` int(6) NOT NULL,
  `parentid` int(6) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `catname` varchar(60) NOT NULL,
  `domain` varchar(100) NOT NULL,
  `image` varchar(100) NOT NULL DEFAULT 'images/image128x128.png',
  `catdir` varchar(100) NOT NULL,
  `url` varchar(100) NOT NULL,
  `setting` text NOT NULL,
  `orderby` int(6) unsigned NOT NULL,
  `ispost` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ismenu` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `m` tinyint(2) NOT NULL DEFAULT '1',
  `expand` text NOT NULL,
  `siteid` smallint(4) unsigned NOT NULL,
  `content` text,
  `navtype` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `modelid` (`modelid`,`parentid`,`type`),
  KEY `catdir` (`catdir`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_category` VALUES('1','0','0','3','会员管理','','images/image128x128.png','member','member/','','1','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('2','0','0','3','个人空间','','images/image128x128.png','space','','','2','0','0','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('3','0','0','3','友情链接','','images/image128x128.png','link','link/','','3','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('4','0','0','3','在线投票','','images/image128x128.png','vote','vote/','','4','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('5','0','0','3','搜索模块','','images/image128x128.png','search','search/','','5','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('6','0','0','3','广告管理','','images/image128x128.png','adv','','','6','0','0','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('7','0','0','3','文章tag标签','','images/image128x128.png','tags','tags/','','7','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('8','0','0','3','在线投稿','','images/image128x128.png','post','post/','','8','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('9','0','0','3','站外链接','','images/image128x128.png','workbox','','','9','0','0','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('10','0','0','3','订单支付','','images/image128x128.png','pay','','','10','0','0','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('11','0','0','3','留言管理','','images/image128x128.png','guestbook','guestbook/','','11','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('13','0','0','3','diy表单','','images/image128x128.png','form','','','13','0','0','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('14','-1','0','2','关于我们','','images/image128x128.png','/guanyuwomen/','/list/?id=14&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_about\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','14','1','1','1','array (\n  \'encatname\' => \'ABOUT US\',\n)','1','<div style=\"text-indent: 2em; text-align: left;\"><p style=\"text-indent: 2em; text-align: left;\"><span style=\"font-family: Verdana;\">上海巨石国际传媒提供最优价的企业宣传片，影视制作，广告片制作，视频短片制作，多媒体制作，三维制作，动画制作。公司集三维动画师、视频特效剪辑师、卡</span><span style=\"font-family: Verdana;\">通人物设计师、平面精英人员为一体，各项专业技术都有着非常雄厚的经验。</span></p></div><div style=\"text-indent: 2em; text-align: left;\"><p style=\"text-indent: 2em; text-align: left;\"><span style=\"font-family:Verdana\">公司业务</span><span style=\"font-family:Verdana\">范围包括：企业宣传片;项目汇报片;电视广告片;展会宣传片;三维建筑动画; 三维角色动画片;影视广告片;栏目包装。我们有一流的创意、先进的技术、诚信的服务，为您提供全方位的多媒体解决方案!</span></p><p style=\"text-indent: 2em; text-align: left;\">公司秉承服务至上的原则，为上百家企业打造出极具价值的企业宣传片和三维演示动画制作，为企业的业务拓展提供了更多机会和更大竞争空间，凭借多年的优质服务，我们积累了大量知名客户企业，如中国银行，香格里拉房产，瑞士军刀，统一拉面，罗氏中国制药，上海航空等等。我们的服务理念是，无论客户的大小，无论制作的简单与复杂，我们都赋予完全的专注，做一个您值得信赖的长期合作伙伴。</p><p style=\"text-indent: 2em; text-align: left;\">公司拥有先进的三维和后期特效设备，包括SGI图形工作站，Finalcut pro非编设备；拥有有高清专业级的摄录设备，sony970，Handycam专业级高清数码摄像机HDR-FX1000E和便携型HDV录放机GV-HD700E。高清拍摄中我们会配备摇臂，轨道，大炮，摄像灯光等专业的辅助设备。</p><p style=\"text-indent: 2em; text-align: left;\">公司拥有极具专业素质的制作人员，从前期创意到脚本创作人员，到摄影师导演，到最后的配音人员，三维特效和剪辑人员，工作室的专业与专注品质将会给您最优质的服务。</p></div>','2');
REPLACE INTO `retengcms_category` VALUES('15','1','0','1','新闻中心','','images/image128x128.png','/xinwenzhongxin/','/list/?id=15&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_article\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','15','1','1','1','array (\n  \'encatname\' => \'NEWS CENTER\',\n)','1','','2');
REPLACE INTO `retengcms_category` VALUES('16','1','0','1','项目展示','','images/image128x128.png','/xiangmuzhanshi/','/list/?id=16&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_project\',\n  \'temparticle\' => \'article_project\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','16','1','1','1','array (\n  \'encatname\' => \'CASES\',\n)','1','','2');
REPLACE INTO `retengcms_category` VALUES('17','-1','0','2','业务范围','','images/image128x128.png','/yewufanwei/','/list/?id=17&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_page\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','17','1','1','1','array (\n  \'encatname\' => \'CURRENT ACCOUNT\',\n)','1','<style type=\"text/css\"><!--\r\n.STYLE1 {color: #FF0000}\r\n--></style><p class=\"STYLE1\">·电视购物片/直销片</p><p>电视购物是指以在电视上播放广告片的方式宣传产品，而要求通过屏幕上显示的免费电话达成订购的销售方式，明显区别于只用于增加品牌知名度的一般商业广告。电视购物又分为电视直销和家庭购物二种目前国在大多数属于前者。</p><p>&nbsp;</p><p class=\"STYLE1\">·企业宣传片/企业形象片</p><p>企业宣传片如同一张企业名片，利用影像、声音、动画等资讯形式，随着音乐的节奏，让观看者在轻松的环境之中就可以去真正了解一个企业的精神、文化和发展状况。</p><p>&nbsp;</p><p class=\"STYLE1\">·三维动画/3D角色动画</p><p>三维动画依赖的技术通过电脑强大的运算能力来模拟现实，建模、运动、渲染是制造三维动画的基本步骤我们在电视广告、动画片、电影中经常能看到三维动画设计的元素。</p><p>&nbsp;</p><p class=\"STYLE1\">·三维产品剖析动画</p><p>用三维数字手段来展示自己的作品与产品，用数字虚拟技术来表现更加丰富生动的建筑内涵，数字动画充分诠释了建筑的内涵，使建筑不再仅仅停留在方案与设计本身。</p><p>&nbsp;</p><p class=\"STYLE1\">·影视广告/电视广告</p><p>电视广告是一种付费的大众传播，其最终目的为传递情报，变化人们对广告商品之态度，诱发行动而使广告主得到利益。</p><p>&nbsp;</p><p class=\"STYLE1\">·产品介绍片/产品演示片</p><p>产品介绍片或服务介绍片利用影像、声音、动画等资讯形式，让观看者在轻松的环境之中就可以去真正了解一个产品的用途、优点、生产环境、使用方法、售后服务等信息。</p>','2');
REPLACE INTO `retengcms_category` VALUES('18','-1','0','2','项目报价','','images/image128x128.png','/xiangmubaojia/','/list/?id=18&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_page\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','18','1','1','1','array (\n  \'encatname\' => \'QUOTATION\',\n)','1','<p style=\"text-align:center;\"><br/></p><table style=\"color: #333333\" border=\"1\" cellspacing=\"0\" bordercolorlight=\"#0c0c0c\" bordercolordark=\"#060606\" cellpadding=\"1\" width=\"100%\"><tbody><tr class=\"firstRow\"><td width=\"34\"><p style=\"text-align:center;\">&nbsp;</p></td><td colspan=\"2\"><p style=\"text-align:center;\"><strong>类型 </strong></p></td><td width=\"73\"><p style=\"text-align:center;\"><strong>报价 </strong></p></td><td width=\"310\"><p style=\"text-align:center;\"><strong>说明 </strong></p></td></tr><tr><td rowspan=\"2\" width=\"34\"><p style=\"text-align:center;\"><strong>宣<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;传<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;片<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;专<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;题<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;片<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;汇<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;报<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;片<br/> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<br/> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</strong></p></td><td height=\"94\" colspan=\"2\"><p style=\"text-align:left;\">高清摄像机，Sony专业脚架，新闻灯光，轻型摇臂拍摄电视广播级高清宣传片。免费制作价值近万元的三维LOGO片头制作。<a href=\"#\">【片头参考】</a><br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;【<a href=\"#\">参考链接：中国银行</a>】</p></td><td width=\"73\"><p style=\"text-align:left;\">1900元/分钟</p></td><td rowspan=\"2\" width=\"310\"><p style=\"text-align:left;\">企业宣传片 报价 上海 企业宣传片 报价 企业形象宣传片制作 报价 企业形象宣传片制作 报价 上海：<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;上述费用我们负责从前期策划到最终刻盘的一条龙服务，内容包括： <br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;前期拍摄、后期剪辑、配音员配音、添加字幕、配置音乐、刻制最终光盘。</p></td></tr><tr><td height=\"83\" colspan=\"2\"><p style=\"text-align:left;\">全程使用大炮，重型摇臂，轨道，布景等专业电影级别设备的高端影视宣传片。<a href=\"#\">【设备图例】</a> <br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;三维LOGO片头制作，500元/秒。 <br/> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;<a href=\"#\">【参考链接：熊猫机械集团宣传片】</a></p></td><td width=\"73\"><p style=\"text-align:left;\">2500元/分钟</p></td></tr><tr><td rowspan=\"4\" width=\"34\"><p style=\"text-align:center;\"><strong>三<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;维<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;动<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;画<br/> &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;</strong></p></td><td rowspan=\"2\" width=\"50\"><p style=\"text-align:center;\">建筑动画</p></td><td height=\"51\" width=\"446\"><p style=\"text-align:left;\">建筑房产动画 <br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p></td><td width=\"73\"><p style=\"text-align:left;\">250元/秒</p></td><td rowspan=\"2\" width=\"310\"><p>上述费用包括从前期工程图纸的建模到渲染三维视频动画，并最终刻制DVD光盘，附送盘面制作。</p></td></tr><tr><td height=\"48\" width=\"446\"><p style=\"text-align:left;\">大型商业规划 <br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p></td><td width=\"73\"><p style=\"text-align:left;\">280元/秒</p></td></tr><tr><td height=\"65\" colspan=\"2\"><p style=\"text-align:left;\">产品互动动画，机械设备虚拟动画，<a href=\"#\">【参考链接：英格索兰设备三维演示动画】</a></p></td><td width=\"73\"><p style=\"text-align:left;\">260元/秒</p></td><td width=\"310\"><p style=\"text-align:left;\">为机械制造企业进行设备原理模拟动画制作，以便于销售。<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p></td></tr><tr><td height=\"63\" colspan=\"2\"><p style=\"text-align:left;\">三维角色制作</p></td><td width=\"73\"><p style=\"text-align:left;\">350元/秒</p></td><td width=\"310\"><p style=\"text-align:left;\">为游戏公司制作高端角色动画，也包括企业的标志卡通形象的动画制作。<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p></td></tr><tr><td rowspan=\"3\" width=\"34\"><p style=\"text-align:center;\"><strong>高<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;端<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;电<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;视<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;广<br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;告</strong><br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;&nbsp;</p></td><td colspan=\"2\"><p style=\"text-align:left;\">电视广告制作，<a href=\"#\">【参考链接：冠军瓷砖电视广告片】</a></p></td><td width=\"73\"><p style=\"text-align:left;\">20000元/15秒 <br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;15000元/10秒 <br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;10000元/5秒</p></td><td rowspan=\"3\" width=\"310\"><p style=\"text-align:left;\">1.不含以上未列入的各项费用:作词作曲录音拍摄花动画播出等 <br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;2.不含外景收费,一些外景拍摄需交场地费 <br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;3.不含制景及美术设计费用,通常制景2000-20000不等 <br/>\r\n &nbsp; &nbsp; &nbsp; &nbsp; &nbsp; &nbsp;4.不含外地拍摄往返机票在当地住宿餐饮及交通费</p></td></tr><tr><td><br/></td><td><br/></td><td><br/></td></tr><tr><td><br/></td><td><br/></td><td><br/></td></tr></tbody></table><p><br/></p><div contenteditable=\"false\" style=\"width: 15px; height: 15px; background-image: url(http://127.0.0.1/ueditor/dialogs/table/dragicon.png); position: absolute; cursor: move; top: -7px; left: 8px; -webkit-user-select: none;\"></div>','2');
REPLACE INTO `retengcms_category` VALUES('19','-1','0','2','合作伙伴','','images/image128x128.png','/hezuohuoban/','/list/?id=19&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_about\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','19','1','1','1','array (\n  \'encatname\' => \'PARTNER\',\n)','1','<div class=\"content\"><div align=\"center\"><p><img alt=\"合作伙伴\" src=\"/uploads/image/201409/39771411373087.jpg\"/></p></div></div>','2');
REPLACE INTO `retengcms_category` VALUES('20','-1','0','2','联系我们','','images/image128x128.png','/lianxiwomen/','/list/?id=20&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_page\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','20','1','1','1','array (\n  \'encatname\' => \'CONTACT US\',\n)','1','<p style=\"text-indent: 2em; text-align: left;\"><iframe class=\"ueditor_baidumap\" src=\"/ueditor/dialogs/map/show.html#center=114.482932,38.052248&zoom=17&width=530&height=340&markers=114.482932,38.052248&markerStyles=l,A\" style=\"width: 698px; height: 340px; float: right;\" frameborder=\"0\" width=\"534\" height=\"344\"></iframe></p><p style=\"text-indent: 2em; text-align: left;\">地址：河北石家庄</p><p style=\"text-indent: 2em; text-align: left;\">电话：0311-88888888</p><p style=\"text-indent: 2em; text-align: left;\">邮箱：master@reteng.org</p><p style=\"text-indent: 2em; text-align: left;\">网址：http://www.reteng.org</p><p style=\"text-indent: 2em; text-align: left;\">邮编：050000</p>','2');
REPLACE INTO `retengcms_category` VALUES('21','1','15','1','企业新闻','','images/image128x128.png','/xinwenzhongxin/qiyexinwen/','/list/?id=21&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_article\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','21','1','1','2','','1','','1,2,3');
REPLACE INTO `retengcms_category` VALUES('22','1','15','1','业内资讯','','images/image128x128.png','/xinwenzhongxin/yenazixun/','/list/?id=22&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_article\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','22','1','1','2','','1','','1,2,3');
REPLACE INTO `retengcms_category` VALUES('23','1','15','1','行业相关','','images/image128x128.png','/xinwenzhongxin/xingyexiangguan/','/list/?id=23&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_article\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','23','1','1','2','','1','','1,2,3');
REPLACE INTO `retengcms_category` VALUES('24','1','16','1','企业宣传','','images/image128x128.png','/xiangmuzhanshi/qiyexuanchuan/','/list/?id=24&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_project\',\n  \'temparticle\' => \'article_project\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','24','1','1','2','','1','','1,2,3');
REPLACE INTO `retengcms_category` VALUES('25','1','16','1','电视广告','','images/image128x128.png','/xiangmuzhanshi/dianshiguanggao/','/list/?id=25&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_project\',\n  \'temparticle\' => \'article_project\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','25','1','1','2','','1','','1,2,3');
REPLACE INTO `retengcms_category` VALUES('26','1','16','1','短片及三维','','images/image128x128.png','/xiangmuzhanshi/duanpianjisanwei/','/list/?id=26&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_project\',\n  \'temparticle\' => \'article_project\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','26','1','1','2','','1','','1,2,3');
DROP TABLE IF EXISTS `retengcms_category_roleid`;
CREATE TABLE `retengcms_category_roleid` (
  `adminid` int(8) NOT NULL,
  `catid` varchar(100) NOT NULL,
  UNIQUE KEY `roleid` (`adminid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_category_roleid` VALUES('1','22,19,20,21,30');
DROP TABLE IF EXISTS `retengcms_collect`;
CREATE TABLE `retengcms_collect` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) NOT NULL DEFAULT '0',
  `title` varchar(160) NOT NULL,
  `url` varchar(100) NOT NULL DEFAULT '',
  `time` varchar(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_comment`;
CREATE TABLE `retengcms_comment` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` mediumint(8) unsigned NOT NULL,
  `contentid` mediumint(8) NOT NULL DEFAULT '0',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` varchar(20) NOT NULL,
  `userface` varchar(100) NOT NULL,
  `support` smallint(5) unsigned NOT NULL DEFAULT '0',
  `against` smallint(5) unsigned NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL DEFAULT '0.0.0.0',
  `addtime` varchar(10) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`,`status`,`id`,`contentid`),
  KEY `status` (`status`,`contentid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_company`;
CREATE TABLE `retengcms_company` (
  `userid` mediumint(8) NOT NULL,
  `address` varchar(100) NOT NULL,
  `about` mediumtext NOT NULL,
  `busroute` varchar(100) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `openingtime` varchar(20) NOT NULL,
  `shenfenzheng` varchar(200) NOT NULL,
  `zhizhao` varchar(200) NOT NULL,
  `qq` varchar(20) NOT NULL,
  `pics` mediumtext NOT NULL,
  `dianhua` varchar(30) NOT NULL,
  `dizhi` varchar(200) NOT NULL,
  `lianxiren` varchar(30) NOT NULL,
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_config`;
CREATE TABLE `retengcms_config` (
  `id` smallint(8) unsigned NOT NULL AUTO_INCREMENT,
  `groupid` smallint(6) NOT NULL DEFAULT '1',
  `varname` varchar(20) NOT NULL DEFAULT '',
  `desc` varchar(100) NOT NULL DEFAULT '',
  `alt` varchar(100) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'string',
  `value` text,
  `system` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_config` VALUES('1','1','site_name','网站名称','','string','石家庄市热腾传媒有限公司','1','1');
REPLACE INTO `retengcms_config` VALUES('2','1','childsite_url','网站地址','请填写完整URL地址，以\"/\"结尾','string','http://127.0.0.1/','1','1');
REPLACE INTO `retengcms_config` VALUES('3','1','tpl_name','默认模板','','string','chuanmei','1','1');
REPLACE INTO `retengcms_config` VALUES('4','1','meta_title','网站副标题','','string','ReTengCMS网站内容管理系统','1','1');
REPLACE INTO `retengcms_config` VALUES('5','1','meta_keywords','网站关键字','设置Meta标签的关键字，用英文逗号分隔','string','热腾CMS,RTCMS模板,ReTengCMS,开源,PHPCMS,PHP网站程序,CMS内容管理系统','1','1');
REPLACE INTO `retengcms_config` VALUES('6','1','meta_description','网站描述','设置Meta标签的描述信息','bstring','热腾CMS是集简单、灵活、开源几大特点的开源内容管理系统,完全符合SEO，是企业和个人建设网站的首选CMS系统。','1','1');
REPLACE INTO `retengcms_config` VALUES('7','1','separator','导航分隔符','如：网站首页 > 新闻','string','>','1','1');
REPLACE INTO `retengcms_config` VALUES('8','1','htmlext','HTML后缀','HTML后缀不要经常修改!修改后请更新内容。','string','.htm','1','1');
REPLACE INTO `retengcms_config` VALUES('9','1','iscity','只读取默认地区数据','开启后, 将自动读取默认地区数据，其他地区数据将不显示在前台。','bool','0','1','1');
REPLACE INTO `retengcms_config` VALUES('10','1','city','默认地区名','','string','615','1','1');
REPLACE INTO `retengcms_config` VALUES('11','1','map','地图精准定位','','string','120.1888,30.249800','1','1');
REPLACE INTO `retengcms_config` VALUES('12','1','ishtml','首页是否静态化','','string','0','1','1');
REPLACE INTO `retengcms_config` VALUES('13','1','copyright','版权信息','','string','CopyRight © 2014 <a href=\"http://www.reteng.org\" target=\"_blank\" style=\"text-decoration:none;\">热腾网</a> RETENG.Org, All Rights Reserved.','1','1');
REPLACE INTO `retengcms_config` VALUES('14','1','icpno','网站ICP备案序号','','string','ICP备:05002345号','1','1');
REPLACE INTO `retengcms_config` VALUES('15','1','logo','网站logo','','image','/images/logo.png','1','1');
REPLACE INTO `retengcms_config` VALUES('16','1','contact_phone','联系电话','网站头部电话号码','string','0311-88888888','0','1');
DROP TABLE IF EXISTS `retengcms_content`;
CREATE TABLE `retengcms_content` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `modelid` int(6) NOT NULL,
  `catid` int(6) unsigned NOT NULL DEFAULT '0',
  `areaid` smallint(6) NOT NULL,
  `template` char(100) NOT NULL,
  `title` char(160) NOT NULL,
  `style` char(30) NOT NULL,
  `thumb` char(100) NOT NULL DEFAULT '',
  `keywords` char(100) NOT NULL,
  `description` char(255) NOT NULL,
  `posid` tinyint(1) NOT NULL DEFAULT '0',
  `url` char(100) NOT NULL DEFAULT 'http://',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '99',
  `point` smallint(5) NOT NULL DEFAULT '0',
  `amount` decimal(8,2) NOT NULL,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` char(80) NOT NULL,
  `inputtime` char(10) NOT NULL,
  `updatetime` char(10) NOT NULL,
  `clicks` int(5) unsigned NOT NULL DEFAULT '0',
  `comments` int(5) unsigned NOT NULL DEFAULT '0',
  `islink` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `password` varchar(32) NOT NULL,
  `expire` int(4) NOT NULL DEFAULT '0',
  `ispage` tinyint(1) NOT NULL DEFAULT '0',
  `pagecount` int(4) NOT NULL DEFAULT '5000',
  `iscomment` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `orderby` mediumint(8) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  `navtype` varchar(100) NOT NULL,
  `support` int(11) NOT NULL DEFAULT '0',
  `oppose` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `catid` (`catid`,`status`,`id`,`areaid`),
  KEY `status` (`status`,`id`),
  KEY `userid` (`userid`),
  KEY `modelid` (`modelid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_content` VALUES('1','1','23','0','article_article','企业宣传片创新应该体现在哪些方面呢？','','','企业 宣传 创新 应该 现在 哪些 方面','按照哲学的原理，任何事物都是运动变化发展的，那么作为影视制作公司的我们也是需要发展的，在日新月异的今天，我们更应该要有创新的精神，那么创新应该体现在哪些方面呢？巨石企业宣传片制作公司作为一家为企业制作宣传片，专题片以及各种视频制作的公司，从拍摄到后期制作都是需要创新的，那','0','/show/?id=1&page=1&siteid=1','1','0','0.00','1','admin','1411374485','1411374485','173','0','0','','0','1','20000','1','1','1','','0','0');
REPLACE INTO `retengcms_content` VALUES('2','1','23','0','article_article','企业宣传片制作中的美学特征有哪些','','','企业 宣传 制作 美学 特征 哪些','虽然企业宣传片设计有别于一般的绘画艺术，但是它毕竟不是简单的商品外观展示与勾画。从某种意义上来说，宣传片作品的设计也是一门艺术，是一种有目的的审美创造活动。成功的宣传片作品能够集科学、艺术与文化于一身，给人以美的享受。宣传片制作中，光依靠创意什么的是不能真正成功的，','0','/show/?id=2&page=1&siteid=1','1','0','0.00','1','admin','1411374814','1411374814','113','0','0','','0','1','20000','1','2','1','','0','0');
REPLACE INTO `retengcms_content` VALUES('3','1','23','0','article_article','酒店服务业拍摄宣传片需要注意哪些','','','酒店 服务业 拍摄 宣传 需要 注意 哪些','酒店都是集商务、旅游、度假、休闲、餐饮、娱乐于一体的按五星级标准建设的综合型大酒店，品位和档次都非同一般，其消费群体都是中高层社会人士。因此酒店企业形象宣传片在主题定位上就得彰显出酒店的魅力，根据酒店对其宣传片的几点要求，RAD辐射视觉根据之前拍摄制作的经验对酒店企','0','/show/?id=3&page=1&siteid=1','1','0','0.00','1','admin','1411374852','1411374852','200','0','0','','0','1','20000','1','3','1','','0','0');
REPLACE INTO `retengcms_content` VALUES('4','1','22','0','article_article','企业宣传片的详细分类和制作方法都有哪些','','','企业 宣传 详细 分类 制作 方法 哪些','现在对于拥有一定实力的企业来说，为了企业的进一步的发展和宣传，企业宣传片的制作就显得非常的重要，因为这可以在一定程度上帮助企业进行宣传传播，相对于生硬的广告，宣传片也是有优势的，那么企业宣传片的具体分类和制作时怎样的呢？1、企业整体宣传片——用于企业对外交往，赠送给上级领','0','/show/?id=4&page=1&siteid=1','1','0','0.00','1','admin','1411374897','1411374897','200','0','0','','0','1','20000','1','4','1','','0','0');
REPLACE INTO `retengcms_content` VALUES('5','1','22','0','article_article','宣传片制作前策划的作用体现','','','宣传 制作 策划 作用 体现','宣传片的策划案，在整个片子的制作中都是至关重要的，片子的策划案能把握整个片子的结构、内容、思路走向等等，是决定整个片子质量的好坏重要要素，那么细分下，宣传片的策划案能够起到哪些具体的作用呢？北京零度数字带您一起来看看：视觉艺术、画面思维是宣传片制作中的基本思维。我们最','0','/show/?id=5&page=1&siteid=1','1','0','0.00','1','admin','1411374919','1411374919','113','0','0','','0','1','20000','1','5','1','','0','0');
REPLACE INTO `retengcms_content` VALUES('6','1','21','0','article_article','沃尔沃集团企业宣传片戛纳获金奖','','','集团 企业 宣传 金奖','沃尔沃集团2010年企业宣传片（Corporate Presentation 2010）在于日前举行的戛纳商业媒体和电视大奖（Cannes Corporate Media and TV Awards）上收获颇丰。在10月14日举行的颁奖礼上，由Stark Film &amp;amp; Event AB制作的沃尔沃企业宣传片获得市场营销类别最佳动画、最佳画面以及最佳特效金','0','/show/?id=6&page=1&siteid=1','1','0','0.00','1','admin','1411375004','1411375004','129','0','0','','0','1','20000','1','6','1','','0','0');
REPLACE INTO `retengcms_content` VALUES('7','1','21','0','article_article','国家形象宣传片有望在美播放','','','国家 形象 宣传 有望 播放','昨日，在国家形象宣传推广合作框架协议签字仪式暨新闻发布会后，中央对外宣传办公室、国务院新闻办公室副主任王仲伟在接受本报记者采访时表示，目前，国家形象宣传片的人物篇已经制作完成，有望本月内在美国播放。王仲伟告诉记者，国家形象片分为两部分，一个是角度篇，一个是人物篇。目前，人','0','/show/?id=7&page=1&siteid=1','1','0','0.00','1','admin','1411375035','1411375035','150','0','0','','0','1','20000','1','7','1','','0','0');
REPLACE INTO `retengcms_content` VALUES('8','1','24','0','article_project','信谊制药企业宣传片','','/uploads/image/201409/14113796513771.jpg','制药 企业 宣传','信谊制药企业宣传片,','0','/show/?id=8&page=1&siteid=1','1','0','0.00','1','admin','1411379717','1411379842','188','0','0','','0','1','20000','1','8','1','','0','0');
REPLACE INTO `retengcms_content` VALUES('9','1','24','0','article_project','融汇地板企业宣传片','','/uploads/image/201409/14113799593231.jpg','融汇 地板 企业 宣传','融汇地板企业宣传片,融汇 地板 企业 宣传','0','/show/?id=9&page=1&siteid=1','1','0','0.00','1','admin','1411379909','1411379962','107','0','0','','0','1','20000','1','9','1','','0','0');
REPLACE INTO `retengcms_content` VALUES('10','1','26','0','article_project','电影预告广告片影视制作','','/uploads/image/201409/14113800608762.jpg','电影 预告 广告 影视 制作','电影预告广告片影视制作,电影 预告 广告 影视 制作','1','/show/?id=10&page=1&siteid=1','1','0','0.00','1','admin','1411380139','1411380320','125','0','0','','0','1','20000','1','10','1','','0','0');
REPLACE INTO `retengcms_content` VALUES('11','1','26','0','article_project','公寓广告片拍摄影视制作','','','公寓 广告 拍摄 影视 制作','公寓广告片拍摄影视制作,公寓 广告 拍摄 影视 制作','1','/show/?id=11&page=1&siteid=1','1','0','0.00','1','admin','1411380284','1411380284','139','0','0','','0','1','20000','1','11','1','','0','0');
DROP TABLE IF EXISTS `retengcms_content_posid`;
CREATE TABLE `retengcms_content_posid` (
  `contentid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `posid` smallint(5) unsigned NOT NULL DEFAULT '0',
  KEY `posid` (`posid`),
  KEY `contentid` (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_content_posid` VALUES('11','1');
REPLACE INTO `retengcms_content_posid` VALUES('10','1');
DROP TABLE IF EXISTS `retengcms_copyfrom`;
CREATE TABLE `retengcms_copyfrom` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT 'http://',
  `orderby` int(6) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_copyfrom` VALUES('1','本站原创','http://','0','1');
DROP TABLE IF EXISTS `retengcms_counts`;
CREATE TABLE `retengcms_counts` (
  `id` char(32) NOT NULL DEFAULT '',
  `count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `updatetime` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_counts` VALUES('b3c1475cb19beb739447534b7774de2d','7','1411552306');
DROP TABLE IF EXISTS `retengcms_form`;
CREATE TABLE `retengcms_form` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `table` varchar(30) NOT NULL,
  `siteid` smallint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_form_fields`;
CREATE TABLE `retengcms_form_fields` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `form` varchar(80) NOT NULL,
  `formid` int(6) NOT NULL,
  `name` varchar(64) NOT NULL,
  `enname` varchar(32) NOT NULL,
  `tips` varchar(80) NOT NULL,
  `unit` varchar(32) NOT NULL,
  `options` text NOT NULL,
  `default` varchar(255) NOT NULL,
  `regex` varchar(80) NOT NULL,
  `css` varchar(32) NOT NULL,
  `length` varchar(8) NOT NULL,
  `orderby` int(6) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `cantdelete` tinyint(1) NOT NULL DEFAULT '0',
  `adminonly` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `formid` (`formid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_gather`;
CREATE TABLE `retengcms_gather` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `modelid` smallint(4) NOT NULL,
  `cotime` char(10) NOT NULL,
  `addtime` char(10) NOT NULL,
  `code` varchar(10) NOT NULL,
  `urlcounts` mediumint(8) NOT NULL,
  `listsetting` text NOT NULL,
  `itemsetting` text NOT NULL,
  `istask` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_gather_tmp`;
CREATE TABLE `retengcms_gather_tmp` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `nodeid` mediumint(8) NOT NULL,
  `title` varchar(80) NOT NULL,
  `url` varchar(160) NOT NULL,
  `content` mediumtext NOT NULL,
  `ispost` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_guestbook`;
CREATE TABLE `retengcms_guestbook` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `title` char(200) NOT NULL,
  `email` varchar(40) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `sex` varchar(6) NOT NULL,
  `content` text NOT NULL,
  `reply` text NOT NULL,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` char(20) NOT NULL,
  `hidden` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `passed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL,
  `addtime` int(10) unsigned NOT NULL DEFAULT '0',
  `replyer` char(20) NOT NULL,
  `replytime` int(10) unsigned NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `hidden` (`hidden`,`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_keywords`;
CREATE TABLE `retengcms_keywords` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `keywords` varchar(30) NOT NULL,
  `weight` smallint(4) NOT NULL DEFAULT '0',
  `counts` mediumint(8) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`keywords`,`weight`,`counts`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_link`;
CREATE TABLE `retengcms_link` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `typeid` smallint(4) NOT NULL,
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(80) NOT NULL,
  `logo` varchar(100) NOT NULL DEFAULT '',
  `introduce` varchar(255) NOT NULL,
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `addtime` char(10) NOT NULL,
  `isindex` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `orderby` smallint(5) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`typeid`),
  KEY `typeid` (`typeid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_link` VALUES('1','1','热腾网','http://www.reteng.org','','','','0','1357653685','1','1','1');
REPLACE INTO `retengcms_link` VALUES('4','1','RTCMS','http://cms.reteng.org','','','','0','1406125267','1','4','1');
DROP TABLE IF EXISTS `retengcms_linktype`;
CREATE TABLE `retengcms_linktype` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `orderby` smallint(5) NOT NULL,
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `disabled` (`disabled`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_linktype` VALUES('1','友情连接','0','1','1');
DROP TABLE IF EXISTS `retengcms_log`;
CREATE TABLE `retengcms_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `admin` char(64) NOT NULL DEFAULT '',
  `method` char(10) NOT NULL DEFAULT '',
  `query` char(200) NOT NULL DEFAULT '',
  `comeurl` varchar(200) NOT NULL,
  `ip` char(15) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_log` VALUES('1','admin','GET','file=admin&action=log','http://127.0.0.1/admin.php?file=left&menu=system','127.0.0.1','1411384564');
REPLACE INTO `retengcms_log` VALUES('2','admin','GET','file=main','http://127.0.0.1/admin.php','127.0.0.1','1411384565');
REPLACE INTO `retengcms_log` VALUES('3','admin','GET','file=db&action=export','http://127.0.0.1/admin.php?file=left&module=index','127.0.0.1','1411384566');
REPLACE INTO `retengcms_log` VALUES('4','admin','POST','file=db&action=export','http://127.0.0.1/admin.php?file=db&action=export','127.0.0.1','1411384576');
DROP TABLE IF EXISTS `retengcms_member`;
CREATE TABLE `retengcms_member` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `touserid` mediumint(8) NOT NULL DEFAULT '0',
  `modelid` int(6) NOT NULL,
  `groupid` int(6) NOT NULL DEFAULT '4',
  `gradeid` int(6) NOT NULL DEFAULT '10',
  `honorid` int(6) NOT NULL DEFAULT '0',
  `areaid` int(6) NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `facephoto` varchar(100) NOT NULL DEFAULT 'member/images/nophoto.gif',
  `email` varchar(80) NOT NULL,
  `telephone` varchar(20) NOT NULL,
  `message` tinyint(3) NOT NULL DEFAULT '0',
  `amount` decimal(8,2) unsigned NOT NULL DEFAULT '0.00',
  `point` int(6) NOT NULL DEFAULT '5',
  `regtime` varchar(10) NOT NULL DEFAULT '0',
  `logintime` varchar(10) NOT NULL DEFAULT '0',
  `logintimes` int(6) NOT NULL DEFAULT '0',
  `loginip` varchar(20) NOT NULL DEFAULT '0.0.0.0',
  `level` tinyint(1) NOT NULL DEFAULT '1',
  `expire` char(10) NOT NULL,
  `openid` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `modelid` (`modelid`,`groupid`),
  KEY `username` (`username`),
  KEY `openid` (`openid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_member` VALUES('1','0','1','1','10','0','0','admin','81f0a81f45125924be09cd15468ed5c5','member/images/nophoto.gif','master@reteng.org','','0','0.00','5','1411369817','1411369817','0','127.0.0.1','1','0','');
DROP TABLE IF EXISTS `retengcms_member_cache`;
CREATE TABLE `retengcms_member_cache` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `touserid` mediumint(8) NOT NULL DEFAULT '0',
  `modelid` int(6) NOT NULL,
  `groupid` int(6) NOT NULL,
  `gradeid` int(6) NOT NULL DEFAULT '0',
  `honorid` int(6) NOT NULL DEFAULT '0',
  `areaid` int(6) NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `facephoto` varchar(100) NOT NULL DEFAULT 'member/images/nophoto.gif',
  `email` varchar(80) NOT NULL,
  `telephone` varchar(20) NOT NULL,
  `message` tinyint(3) NOT NULL DEFAULT '0',
  `amount` decimal(8,2) unsigned NOT NULL DEFAULT '0.00',
  `point` int(6) NOT NULL DEFAULT '5',
  `regtime` varchar(10) NOT NULL DEFAULT '0',
  `logintime` varchar(10) NOT NULL DEFAULT '0',
  `logintimes` int(6) NOT NULL DEFAULT '0',
  `loginip` varchar(20) NOT NULL DEFAULT '0.0.0.0',
  `level` tinyint(1) NOT NULL DEFAULT '1',
  `expire` char(10) NOT NULL,
  `openid` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `openid` (`openid`),
  KEY `modelid` (`modelid`,`groupid`),
  KEY `username` (`username`),
  KEY `openid_2` (`openid`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_memberdb_fields`;
CREATE TABLE `retengcms_memberdb_fields` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `form` varchar(80) NOT NULL,
  `modelid` int(6) NOT NULL,
  `name` varchar(64) NOT NULL,
  `enname` varchar(32) NOT NULL,
  `tips` varchar(80) NOT NULL,
  `unit` varchar(32) NOT NULL,
  `options` text NOT NULL,
  `default` varchar(255) NOT NULL,
  `regex` varchar(80) NOT NULL,
  `css` varchar(32) NOT NULL,
  `length` varchar(8) NOT NULL,
  `orderby` int(6) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `cantdelete` tinyint(1) NOT NULL DEFAULT '0',
  `adminonly` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `modelid` (`modelid`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_memberdb_fields` VALUES('2','text','1','真实姓名','realname','','','选项值|选项\r\n选项值|选项','','chinese','','30','2','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('5','selectmenu_area','1','所属地区','areaid','','','','31','','','','1','0','1','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('6','selectmenu_area','2','所属地区','areaid','','','','5','','','','1','0','1','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('7','text','2','企业地址','address','','','选项值|选项\r\n选项值|选项','','','','100','5','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('8','fckeditor','2','企业简介','about','','','Basic','','','','255','12','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('9','text','2','公交线路','busroute','','','选项值|选项\r\n选项值|选项','','','','100','7','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('10','text','2','联系电话','phone','','','选项值|选项\r\n选项值|选项','','','','20','2','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('11','text','2','营业时间','openingtime','','','选项值|选项\r\n选项值|选项','8:00-18:00','','','20','8','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('12','image','2','身 份 证','shenfenzheng','','','选项值|选项\r\n选项值|选项','','','','200','9','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('13','image','2','营业执照','zhizhao','','','选项值|选项\r\n选项值|选项','','','','200','10','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('14','text','2','客服QQ','qq','','','选项值|选项\r\n选项值|选项','','qq','','20','4','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('15','images','2','企业图片','pics','','','选项值|选项\r\n选项值|选项','','','','255','11','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('16','text','1','联系电话','dianhua','','','选项值|选项\r\n选项值|选项','','','','30','3','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('17','text','1','客服QQ','qq','','','选项值|选项\r\n选项值|选项','','qq','','30','4','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('18','text','1','详细地址','dizhi','','','选项值|选项\r\n选项值|选项','','','','200','5','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('19','text','2','手机号码','dianhua','','','选项值|选项\r\n选项值|选项','','','','30','3','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('20','text','2','咨询地址','dizhi','','','选项值|选项\r\n选项值|选项','','','','200','6','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('21','text','2','联系人','lianxiren','','','选项值|选项\r\n选项值|选项','李先生','chinese','','30','2','0','0','0');
DROP TABLE IF EXISTS `retengcms_membergrade`;
CREATE TABLE `retengcms_membergrade` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `grade` varchar(10) NOT NULL,
  `amount` varchar(10) NOT NULL,
  `point` varchar(10) NOT NULL,
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `info` varchar(255) NOT NULL,
  `postcatid` text NOT NULL,
  `viewcatid` text NOT NULL,
  `module` char(100) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_membergrade` VALUES('1','普通会员','10','0','0','1','0','一号注册，全站通行。','0','0','9,28,7');
REPLACE INTO `retengcms_membergrade` VALUES('2','高级会员','20','100','100','1','0','一号注册，全站通行。享受更多特权，更多功能模块。','0','0','7,9,10,11,12');
DROP TABLE IF EXISTS `retengcms_membergroup`;
CREATE TABLE `retengcms_membergroup` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `orderby` int(6) NOT NULL,
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `postcatid` text NOT NULL,
  `viewcatid` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_membergroup` VALUES('1','管理员','1','1','0','0','0');
REPLACE INTO `retengcms_membergroup` VALUES('2','游客','2','1','0','0','0');
REPLACE INTO `retengcms_membergroup` VALUES('3','待审核','3','1','0','0','0');
REPLACE INTO `retengcms_membergroup` VALUES('4','注册会员','4','1','0','0','0');
DROP TABLE IF EXISTS `retengcms_memberhonor`;
CREATE TABLE `retengcms_memberhonor` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `point` varchar(10) NOT NULL,
  `ico` varchar(10) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_memberhonor` VALUES('1','列兵','100','1','0');
REPLACE INTO `retengcms_memberhonor` VALUES('2','班长','200','2','0');
DROP TABLE IF EXISTS `retengcms_membermodel`;
CREATE TABLE `retengcms_membermodel` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `table` varchar(30) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `register` tinyint(1) NOT NULL DEFAULT '1',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `module` char(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_membermodel` VALUES('1','普通会员','regular','0','1','1','');
REPLACE INTO `retengcms_membermodel` VALUES('2','企业会员','company','0','1','1','');
DROP TABLE IF EXISTS `retengcms_message`;
CREATE TABLE `retengcms_message` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `send_from_user` varchar(30) NOT NULL,
  `send_to_user` varchar(30) NOT NULL,
  `folder` enum('all','inbox','outbox') NOT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `message_time` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` char(200) NOT NULL,
  `content` text NOT NULL,
  `replyid` int(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `msgtoid` (`send_to_user`,`folder`),
  KEY `replyid` (`replyid`),
  KEY `folder` (`send_from_user`,`folder`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_model`;
CREATE TABLE `retengcms_model` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `table` varchar(32) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `table` (`table`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_model` VALUES('1','文章','article','0','1','1');
DROP TABLE IF EXISTS `retengcms_model_fields`;
CREATE TABLE `retengcms_model_fields` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `form` varchar(80) NOT NULL,
  `modelid` int(6) NOT NULL,
  `name` varchar(64) NOT NULL,
  `enname` varchar(32) NOT NULL,
  `tips` varchar(80) NOT NULL,
  `unit` varchar(32) NOT NULL,
  `options` text NOT NULL,
  `default` varchar(255) NOT NULL,
  `regex` varchar(80) NOT NULL,
  `css` varchar(32) NOT NULL,
  `length` varchar(8) NOT NULL,
  `orderby` int(6) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `cantdelete` tinyint(1) NOT NULL DEFAULT '0',
  `adminonly` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `modelid` (`modelid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_model_fields` VALUES('1','title','1','文章标题','title','','','','','','','','1','0','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('2','style','1','字体颜色','style','','','','','','','','2','1','1','3','1');
REPLACE INTO `retengcms_model_fields` VALUES('3','thumb','1','封面图片','thumb','','','','','','','','3','0','1','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('4','keywords','1','关键字','keywords','','','','','','','','11','0','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('5','selectmenu_area','1','所属地区','areaid','','','','327','','','','101','1','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('6','description','1','内容简介','description','','','','','','','','8','0','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('7','posid','1','推荐位','posid','','','','','','','','9','0','1','3','1');
REPLACE INTO `retengcms_model_fields` VALUES('8','content','1','内容','content','','','','','','','','10','0','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('9','status','1','发布状态','status','','','','1','','','8','100','0','1','3','1');
REPLACE INTO `retengcms_model_fields` VALUES('10','iscomment','1','评论状态','iscomment','','','','1','','','','96','0','1','3','1');
REPLACE INTO `retengcms_model_fields` VALUES('11','point','1','阅读点数','point','','点','','0','','','','97','1','1','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('12','amount','1','阅读钱数','amount','','元','','0.0','','','','98','1','1','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('13','author','1','责任编辑','editor','','','选项值|选项\r\n选项值|选项','','','','30','79','0','0','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('14','copyfrom','1','稿件来源','copyfrom','','','选项值|选项\r\n选项值|选项','','','','100','80','0','0','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('15','password','1','信息删除密码','password','针对游客有效，留空为屏蔽此功能!','','','','','','98','10','1','1','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('16','expire','1','信息有效期','expire','0为不限!','天','','0','','','','99','1','1','2','1');
DROP TABLE IF EXISTS `retengcms_module`;
CREATE TABLE `retengcms_module` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `folder` varchar(10) NOT NULL,
  `author` varchar(60) NOT NULL,
  `site` varchar(100) NOT NULL,
  `version` varchar(10) NOT NULL,
  `tables` varchar(255) NOT NULL,
  `menu_admin` text NOT NULL,
  `menu_member` text NOT NULL,
  `agreement` mediumtext NOT NULL,
  `roleid` varchar(60) NOT NULL,
  `modelid` varchar(60) NOT NULL,
  `menu` tinyint(1) NOT NULL DEFAULT '0',
  `adminmenu` tinyint(1) NOT NULL DEFAULT '0',
  `adminonly` tinyint(1) NOT NULL DEFAULT '1',
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `orderby` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `folder` (`folder`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_module` VALUES('1','会员管理','member','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_member,retengcms_member_cache,retengcms_membermodel,retengcms_membergrade,retengcms_membergroup,retengcms_memberhonor,retengcms_memberdb_fields,retengcms_message,retengcms_collect','?mod=member&file=member&action=cache|更新缓存\r\n?mod=member&file=member&action=setting|配置选项\r\n?mod=member&file=member&action=manage|会员管理\r\n?mod=member&file=member&action=group|会 员 组\r\n?mod=member&file=member&action=grade|会员级别\r\n?mod=member&file=member&action=honor|会员头衔\r\n?mod=member&file=member&action=model|会员模型\r\n?mod=member&file=member&action=message|系统信息','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','1,2','1','0','1','0','本模块是由ReTengCMS官方开发的一款会员管理模块,可以实现会员注册等功能','1');
REPLACE INTO `retengcms_module` VALUES('2','个人空间','space','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_space,retengcms_space_comment,retengcms_space_newvisitor,retengcms_space_friends','?mod=space&file=space&action=manage|空间管理\r\n?mod=space&file=space&action=tagspace|空间调用\r\n?mod=space&file=space&action=tag|留言调用','member/index.php?mod=space&file=space&action=view|刷新空间\r\nmember/index.php?mod=space&file=space&action=info|空间设置\r\nmember/index.php?mod=space&file=space&action=template|模板样式\r\nmember/index.php?mod=space&file=space&action=guestbook|留言管理','本软件为自由软件, 你可以自由修改并使用。','1,2','1,2','0','0','0','0','本模块是由ReTengCMS内容管理系统开发的一款个人空间功能模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','9');
REPLACE INTO `retengcms_module` VALUES('3','友情链接','link','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_linktype,retengcms_link','?mod=link&file=link&action=cache|更新缓存\r\n?mod=link&file=link&action=type|友链类型\r\n?mod=link&file=link&action=type_add|添加类型\r\n?mod=link&file=link&action=tag|模板调用','','本软件为自由软件, 你可以自由修改并使用。','1,2','','1','0','1','0','本模块是由ReTengCMS内容管理系统开发的友情链接管理模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','5');
REPLACE INTO `retengcms_module` VALUES('4','在线投票','vote','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_vote,retengcms_vote_ip','?mod=vote&file=vote&action=manage|投票管理\r\n?mod=vote&file=vote&action=vote_add|添加投票','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','','1','0','1','0','本模块是由ReTengCMS内容管理系统开发的一款在线投票模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','7');
REPLACE INTO `retengcms_module` VALUES('5','搜索模块','search','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_keywords','?mod=search&file=search&action=keywords|关键字管理','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','1,2','1','0','1','0','本模块是由ReTengCMS内容管理系统开发的一款搜索功能模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','10');
REPLACE INTO `retengcms_module` VALUES('6','广告管理','adv','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_ads,retengcms_adspos','?mod=adv&file=ads&action=cache|更新缓存\r\n?mod=adv&file=ads&action=adspos|常规广告位\r\n?mod=adv&file=ads&action=adspos_add|添加广告位','','本软件为自由软件, 你可以自由修改并使用。','1,2,5','','0','0','1','0','本模块是由ReTengCMS内容管理系统开发的广告管理模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','4');
REPLACE INTO `retengcms_module` VALUES('7','文章tag标签','tags','热腾网','http://www.reteng.org/','1.0','retengcms_taglist,retengcms_tagindex','','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','1,2','1','0','0','0','本模块是由ReTeng开发的一款ReTengCMS内容管理系统功能模块,感谢您的下载使用.本模块主要是方便网站tag提取，增强网站优化等作用\r\n网址:http://www.reteng.org/','8');
REPLACE INTO `retengcms_module` VALUES('8','在线投稿','post','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','','?mod=post&file=post&action=config|配置选项','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','1,2','1','0','1','0','本模块是由热腾内容管理系统开发的一款ReTengCMS内容管理系统功能模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','14');
REPLACE INTO `retengcms_module` VALUES('9','站外链接','workbox','热腾网','http://www.reteng.org','1.0','retengcms_workbox,retengcms_tools','?mod=workbox&file=workbox&action=workbox|工具管理\r\n?mod=workbox&file=workbox&action=tag|模板调用','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','1,2','0','0','0','0','本模块可以是实现站内内容与设定的关键词相关联。从而有效的实现网站SEO外链增加！','12');
REPLACE INTO `retengcms_module` VALUES('10','订单支付','pay','热腾官方','http://www.reteng.org/','1.0','retengcms_pay_method,retengcms_pay_card,retengcms_pay_cardtype,retengcms_pay_log','?mod=pay&file=pay&action=paymethod|支付配置\r\n?mod=pay&file=pay&action=card|点卡管理\r\n?mod=pay&file=pay&action=cardtype|点卡类型\r\n?mod=pay&file=pay&action=log|财务日志\r\n?mod=pay&file=pay&action=member|会员充值\r\n?mod=pay&file=pay&action=order|订单查询\r\n?mod=pay&file=pay&action=paymethod_button|支付按钮','member/index.php?mod=pay&file=pay&action=online|在线充值\r\nmember/index.php?mod=pay&file=pay&action=card|点卡充值\r\nmember/index.php?mod=pay&file=pay&action=log|财务日志\r\nmember/index.php?mod=pay&file=pay&action=order|订单查询','本软件为自由软件, 你可以自由修改并使用。','1,5','1,2','0','0','0','0','本模块是由ReTengCMS官方开发支付功能模块，启用以后可以在模版中实现商品在线交易等功能','2');
REPLACE INTO `retengcms_module` VALUES('11','留言管理','guestbook','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_guestbook','?mod=guestbook&file=guestbook&action=manage&passed=1|已审留言\r\n?mod=guestbook&file=guestbook&action=manage&passed=0|待审留言','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','','1','0','1','0','本模块是由ReTengCMS内容管理系统开发的一款留言管理模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','6');
REPLACE INTO `retengcms_module` VALUES('13','diy表单','form','热腾内容管理系统','http://www.reteng.org/','1.0','retengcms_form,retengcms_form_fields','?mod=form&file=form&action=manage|自定义表单\r\n?mod=form&file=form&action=add|添加表单','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','1,2','0','0','1','0','本模块是由可以实现自定义表单数据，增强网站功能，例如：意见反馈，在线报名等功能！','16');
DROP TABLE IF EXISTS `retengcms_mood`;
CREATE TABLE `retengcms_mood` (
  `contentid` mediumint(8) NOT NULL,
  `surprise` mediumint(8) NOT NULL DEFAULT '0',
  `batting` mediumint(8) NOT NULL DEFAULT '0',
  `support` mediumint(8) NOT NULL DEFAULT '0',
  `great` mediumint(8) NOT NULL DEFAULT '0',
  `anger` mediumint(8) NOT NULL DEFAULT '0',
  `funny` mediumint(8) NOT NULL DEFAULT '0',
  `nausea` mediumint(8) NOT NULL DEFAULT '0',
  `puzzled` mediumint(8) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_onlinereg`;
CREATE TABLE `retengcms_onlinereg` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_onlinereg` VALUES('1','张三');
DROP TABLE IF EXISTS `retengcms_order`;
CREATE TABLE `retengcms_order` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `sn` char(32) NOT NULL,
  `product` varchar(200) NOT NULL,
  `amount` varchar(20) NOT NULL,
  `number` varchar(20) NOT NULL,
  `payment` smallint(4) NOT NULL,
  `shipment` smallint(4) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `buyuser` varchar(60) NOT NULL,
  `buyemail` varchar(60) NOT NULL,
  `buyphone` varchar(20) NOT NULL,
  `buyaddress` varchar(200) NOT NULL,
  `buymessage` text NOT NULL,
  `receiveuser` varchar(60) NOT NULL,
  `receivephone` varchar(20) NOT NULL,
  `receiveaddress` varchar(200) NOT NULL,
  `datetime` char(10) NOT NULL,
  `ip` varchar(20) NOT NULL,
  `userid` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sn` (`sn`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_pay_card`;
CREATE TABLE `retengcms_pay_card` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `cardid` varchar(32) NOT NULL DEFAULT '0',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` char(30) NOT NULL DEFAULT 'anonymity',
  `typeid` smallint(4) unsigned NOT NULL DEFAULT '0',
  `inputerid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `inputer` char(30) NOT NULL DEFAULT 'anonymity',
  `expire` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL DEFAULT '0.0.0.0',
  `price` varchar(5) NOT NULL DEFAULT '0',
  `amount` varchar(5) NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `cardid` (`cardid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_pay_cardtype`;
CREATE TABLE `retengcms_pay_cardtype` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `amount` varchar(5) NOT NULL DEFAULT '0',
  `price` varchar(5) NOT NULL DEFAULT '0',
  `orderby` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_pay_log`;
CREATE TABLE `retengcms_pay_log` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `sn` varchar(32) NOT NULL,
  `username` varchar(30) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `manage` tinyint(1) NOT NULL DEFAULT '1',
  `type` varchar(10) NOT NULL,
  `amount` varchar(10) NOT NULL,
  `payment` varchar(32) NOT NULL,
  `note` text NOT NULL,
  `time` varchar(10) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sn` (`sn`),
  KEY `username` (`username`,`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_pay_method`;
CREATE TABLE `retengcms_pay_method` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL,
  `name` varchar(30) NOT NULL,
  `desc` text NOT NULL,
  `fee` varchar(10) NOT NULL,
  `config` text NOT NULL,
  `is_cod` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_online` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `orderby` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `author` varchar(100) NOT NULL,
  `website` varchar(100) NOT NULL,
  `version` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_pay_method` VALUES('1','alipay','支付宝','支付宝网站(www.alipay.com) 是国内先进的网上支付平台。\r\nReTengCMS联合支付宝推出支付宝接口。','0','array (\n  \'alipay_account\' => \'master@reteng.org\',\n  \'alipay_key\' => \'\',\n  \'alipay_partner\' => \'\',\n  \'service_type\' => \'0\',\n)','0','1','0','1','ReTengCMS','http://www.alipay.com','1.0.0');
REPLACE INTO `retengcms_pay_method` VALUES('2','post','邮局汇款','收款人信息：姓名 ××× ；地址 ××× ；邮编 ××× 。\r\n注意事项： 请在汇款单背面的附言中注明您的订单号，只填写后6位即可。','0','array (\n)','0','0','0','1','ReTengCMS','','1.0.0');
REPLACE INTO `retengcms_pay_method` VALUES('3','bank','银行汇款/转帐','银行名称\r\n收款人信息：全称 ××× ；帐号或地址 ××× ；开户行 ×××。\r\n注意事项：办理电汇时，请在电汇单“汇款用途”一栏处注明您的订单号。','0','array (\n)','0','0','0','1','ReTengCMS','','1.0.0');
DROP TABLE IF EXISTS `retengcms_permission`;
CREATE TABLE `retengcms_permission` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `parentid` smallint(6) NOT NULL,
  `name` varchar(60) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `roleid` varchar(80) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_permission` VALUES('1','0','系统配置','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('2','1','网站配置','1','1,2');
REPLACE INTO `retengcms_permission` VALUES('3','1','管理员','1','1');
REPLACE INTO `retengcms_permission` VALUES('4','1','数据备份','1','1');
REPLACE INTO `retengcms_permission` VALUES('5','6','级联菜单','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('6','0','栏目内容','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('7','6','栏目单页','1','1,2,3,4');
REPLACE INTO `retengcms_permission` VALUES('8','0','更新网站','1','1,2,3,4');
REPLACE INTO `retengcms_permission` VALUES('9','0','内容管理','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('10','0','模板管理','1','1,4');
REPLACE INTO `retengcms_permission` VALUES('11','10','模板方案','1','1,4');
REPLACE INTO `retengcms_permission` VALUES('12','10','内容调用','1','1,4');
REPLACE INTO `retengcms_permission` VALUES('13','0','模块插件','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('14','13','功能模块','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('15','13','插件管理','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('16','13','内容模型','1','1,2,3');
DROP TABLE IF EXISTS `retengcms_posid`;
CREATE TABLE `retengcms_posid` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `orderby` int(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_posid` VALUES('1','首页头条','1');
REPLACE INTO `retengcms_posid` VALUES('2','栏目页推荐','2');
REPLACE INTO `retengcms_posid` VALUES('3','内容页推荐','3');
REPLACE INTO `retengcms_posid` VALUES('4','置顶信息','4');
REPLACE INTO `retengcms_posid` VALUES('5','切换焦点图','5');
DROP TABLE IF EXISTS `retengcms_regular`;
CREATE TABLE `retengcms_regular` (
  `userid` mediumint(8) NOT NULL,
  `realname` varchar(30) NOT NULL,
  `dianhua` varchar(30) NOT NULL,
  `qq` varchar(30) NOT NULL,
  `dizhi` varchar(200) NOT NULL,
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('2','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
DROP TABLE IF EXISTS `retengcms_role`;
CREATE TABLE `retengcms_role` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `orderby` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_role` VALUES('1','超级管理员','1','1','0');
REPLACE INTO `retengcms_role` VALUES('2','网站总编','2','1','0');
REPLACE INTO `retengcms_role` VALUES('3','栏目编辑','3','1','0');
REPLACE INTO `retengcms_role` VALUES('4','美工设计师','4','1','0');
REPLACE INTO `retengcms_role` VALUES('5','会计人员','5','1','0');
DROP TABLE IF EXISTS `retengcms_server_task`;
CREATE TABLE `retengcms_server_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET gbk NOT NULL,
  `url` varchar(200) CHARACTER SET gbk NOT NULL,
  `updatetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `count` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
DROP TABLE IF EXISTS `retengcms_session`;
CREATE TABLE `retengcms_session` (
  `sessionid` char(32) NOT NULL,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL,
  `lastvisit` int(10) unsigned NOT NULL DEFAULT '0',
  `data` char(255) NOT NULL,
  PRIMARY KEY (`sessionid`),
  KEY `lastvisit` (`lastvisit`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_session` VALUES('fdca22c1850647876d4db1e64bb8debb','1','127.0.0.1','1411384566','is_admin|b:1;admin_id|i:1;');
DROP TABLE IF EXISTS `retengcms_shipment`;
CREATE TABLE `retengcms_shipment` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `desc` text NOT NULL,
  `fee` varchar(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_sitecrowd`;
CREATE TABLE `retengcms_sitecrowd` (
  `id` mediumint(4) unsigned NOT NULL AUTO_INCREMENT,
  `site_name` varchar(200) NOT NULL,
  `site_url` varchar(200) NOT NULL,
  `site_dir` varchar(30) NOT NULL,
  `issueid` text NOT NULL,
  `tlp_name` varchar(80) NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_description` varchar(255) NOT NULL,
  `seo_keywords` varchar(255) NOT NULL,
  `separator` varchar(8) NOT NULL DEFAULT '>',
  `htmlext` varchar(8) NOT NULL DEFAULT '.htm',
  `iscity` tinyint(1) NOT NULL DEFAULT '0',
  `city` mediumint(8) NOT NULL,
  `map` varchar(32) NOT NULL,
  `ishtml` tinyint(1) NOT NULL DEFAULT '0',
  `copyright` text NOT NULL,
  `icpno` varchar(32) NOT NULL,
  `system` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_sitecrowd` VALUES('1','默认站点','http://127.0.0.1/','/','','chuanmei','ReTengCMS网站内容管理系统','热腾CMS是集简单、灵活、开源几大特点的开源内容管理系统,完全符合SEO，是企业和个人建设网站的首选CMS系统。','热腾CMS,RTCMS模板,ReTengCMS,开源,PHPCMS,PHP网站程序,CMS内容管理系统','>','.htm','0','0','','0','CopyRight © 2014 <a href=\"http://www.reteng.org\" target=\"_blank\" style=\"text-decoration:none;\">热腾网</a> RETENG.Org, All Rights Reserved.','ICP备:05002345号','1');
DROP TABLE IF EXISTS `retengcms_sitecrowdissue`;
CREATE TABLE `retengcms_sitecrowdissue` (
  `issueid` mediumint(4) unsigned NOT NULL AUTO_INCREMENT,
  `issuename` varchar(80) NOT NULL,
  `ftphost` varchar(32) NOT NULL,
  `ftpport` varchar(4) NOT NULL,
  `ftpuser` varchar(64) NOT NULL,
  `ftppwd` varchar(64) NOT NULL,
  `ftpdir` varchar(80) NOT NULL,
  `ftpssl` tinyint(1) NOT NULL DEFAULT '0',
  `ftppasv` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`issueid`),
  UNIQUE KEY `ftphost` (`ftphost`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_space`;
CREATE TABLE `retengcms_space` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) unsigned NOT NULL,
  `logo` varchar(100) NOT NULL,
  `banner` varchar(100) NOT NULL,
  `name` varchar(80) NOT NULL,
  `meta_keywords` varchar(100) NOT NULL,
  `meta_description` varchar(250) NOT NULL,
  `template` varchar(40) NOT NULL,
  `opentime` varchar(10) NOT NULL,
  `lock` tinyint(1) NOT NULL DEFAULT '0',
  `syslock` tinyint(1) NOT NULL DEFAULT '0',
  `index` tinyint(1) NOT NULL DEFAULT '0',
  `visits` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`lock`),
  UNIQUE KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_space_comment`;
CREATE TABLE `retengcms_space_comment` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL,
  `guestid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `guestname` varchar(20) NOT NULL,
  `guestface` varchar(100) NOT NULL DEFAULT 'space/images/nophoto.gif',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL DEFAULT '0.0.0.0',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`,`status`,`id`),
  KEY `ip` (`ip`,`status`,`id`),
  KEY `status` (`status`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_space_friends`;
CREATE TABLE `retengcms_space_friends` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) NOT NULL,
  `spaceid` mediumint(8) NOT NULL,
  `spacename` varchar(80) NOT NULL,
  `spacelogo` varchar(200) NOT NULL,
  `addtime` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_space_newvisitor`;
CREATE TABLE `retengcms_space_newvisitor` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) NOT NULL,
  `spaceid` mediumint(8) NOT NULL,
  `spacename` varchar(80) NOT NULL,
  `spacelogo` varchar(200) NOT NULL,
  `visittime` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `spaceid` (`spaceid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_stepselect`;
CREATE TABLE `retengcms_stepselect` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `table` varchar(30) NOT NULL,
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `table` (`table`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_stepselect` VALUES('1','地区区域','area','0','1');
DROP TABLE IF EXISTS `retengcms_stepselect_enum`;
CREATE TABLE `retengcms_stepselect_enum` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `selectid` int(6) NOT NULL,
  `name` varchar(60) NOT NULL,
  `parentid` int(8) NOT NULL,
  `orderby` int(8) NOT NULL,
  `evalue` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `evalue` (`evalue`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_stepselect_enum` VALUES('1','1','石家庄市','0','25500','25500');
REPLACE INTO `retengcms_stepselect_enum` VALUES('2','1','鹿泉市','1','25501','25501');
REPLACE INTO `retengcms_stepselect_enum` VALUES('3','1','辛集市','1','25502','25502');
DROP TABLE IF EXISTS `retengcms_tagindex`;
CREATE TABLE `retengcms_tagindex` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` char(12) NOT NULL DEFAULT '',
  `catid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `total` int(10) unsigned NOT NULL DEFAULT '0',
  `uptime` int(10) unsigned NOT NULL DEFAULT '0',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0',
  `siteid` smallint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=40 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_tagindex` VALUES('1','企业','0','6','0','1411379962','1411374485','1');
REPLACE INTO `retengcms_tagindex` VALUES('2','宣传','0','9','0','1411379962','1411374485','1');
REPLACE INTO `retengcms_tagindex` VALUES('3','创新','0','1','0','1411374485','1411374485','1');
REPLACE INTO `retengcms_tagindex` VALUES('4','应该','0','1','0','1411374485','1411374485','1');
REPLACE INTO `retengcms_tagindex` VALUES('5','现在','0','1','0','1411374485','1411374485','1');
REPLACE INTO `retengcms_tagindex` VALUES('6','哪些','0','4','0','1411374897','1411374485','1');
REPLACE INTO `retengcms_tagindex` VALUES('7','方面','0','1','0','1411374485','1411374485','1');
REPLACE INTO `retengcms_tagindex` VALUES('8','制作','0','5','0','1411380320','1411374814','1');
REPLACE INTO `retengcms_tagindex` VALUES('9','美学','0','1','0','1411374814','1411374814','1');
REPLACE INTO `retengcms_tagindex` VALUES('10','特征','0','1','0','1411374814','1411374814','1');
REPLACE INTO `retengcms_tagindex` VALUES('11','酒店','0','1','0','1411374852','1411374852','1');
REPLACE INTO `retengcms_tagindex` VALUES('12','服务业','0','1','0','1411374852','1411374852','1');
REPLACE INTO `retengcms_tagindex` VALUES('13','拍摄','0','2','0','1411380284','1411374852','1');
REPLACE INTO `retengcms_tagindex` VALUES('14','需要','0','1','0','1411374852','1411374852','1');
REPLACE INTO `retengcms_tagindex` VALUES('15','注意','0','1','0','1411374852','1411374852','1');
REPLACE INTO `retengcms_tagindex` VALUES('16','详细','0','1','0','1411374897','1411374897','1');
REPLACE INTO `retengcms_tagindex` VALUES('17','分类','0','1','0','1411374897','1411374897','1');
REPLACE INTO `retengcms_tagindex` VALUES('18','方法','0','1','0','1411374897','1411374897','1');
REPLACE INTO `retengcms_tagindex` VALUES('19','策划','0','1','0','1411374919','1411374919','1');
REPLACE INTO `retengcms_tagindex` VALUES('20','作用','0','1','0','1411374919','1411374919','1');
REPLACE INTO `retengcms_tagindex` VALUES('21','体现','0','1','0','1411374919','1411374919','1');
REPLACE INTO `retengcms_tagindex` VALUES('22','集团','0','1','0','1411375004','1411375004','1');
REPLACE INTO `retengcms_tagindex` VALUES('23','金奖','0','1','0','1411375004','1411375004','1');
REPLACE INTO `retengcms_tagindex` VALUES('24','国家','0','1','0','1411375035','1411375035','1');
REPLACE INTO `retengcms_tagindex` VALUES('25','形象','0','1','0','1411375035','1411375035','1');
REPLACE INTO `retengcms_tagindex` VALUES('26','有望','0','1','0','1411375035','1411375035','1');
REPLACE INTO `retengcms_tagindex` VALUES('27','播放','0','1','0','1411375035','1411375035','1');
REPLACE INTO `retengcms_tagindex` VALUES('28','制药','0','1','0','1411379842','1411379842','1');
REPLACE INTO `retengcms_tagindex` VALUES('32','地板','0','1','0','1411379962','1411379962','1');
REPLACE INTO `retengcms_tagindex` VALUES('31','融汇','0','1','0','1411379962','1411379962','1');
REPLACE INTO `retengcms_tagindex` VALUES('39','预告','0','1','0','1411380320','1411380320','1');
REPLACE INTO `retengcms_tagindex` VALUES('38','电影','0','1','0','1411380320','1411380320','1');
REPLACE INTO `retengcms_tagindex` VALUES('35','广告','0','2','0','1411380320','1411380139','1');
REPLACE INTO `retengcms_tagindex` VALUES('36','影视','0','2','0','1411380320','1411380139','1');
REPLACE INTO `retengcms_tagindex` VALUES('37','公寓','0','1','0','1411380284','1411380284','1');
DROP TABLE IF EXISTS `retengcms_taglist`;
CREATE TABLE `retengcms_taglist` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contentid` int(10) unsigned NOT NULL DEFAULT '0',
  `orderby` smallint(6) NOT NULL DEFAULT '0',
  `catid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tag` varchar(12) NOT NULL DEFAULT '',
  `siteid` smallint(4) NOT NULL,
  PRIMARY KEY (`id`,`contentid`)
) ENGINE=MyISAM AUTO_INCREMENT=68 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_taglist` VALUES('1','1','0','23','企业','1');
REPLACE INTO `retengcms_taglist` VALUES('2','1','0','23','宣传','1');
REPLACE INTO `retengcms_taglist` VALUES('3','1','0','23','创新','1');
REPLACE INTO `retengcms_taglist` VALUES('4','1','0','23','应该','1');
REPLACE INTO `retengcms_taglist` VALUES('5','1','0','23','现在','1');
REPLACE INTO `retengcms_taglist` VALUES('6','1','0','23','哪些','1');
REPLACE INTO `retengcms_taglist` VALUES('7','1','0','23','方面','1');
REPLACE INTO `retengcms_taglist` VALUES('8','2','0','23','企业','1');
REPLACE INTO `retengcms_taglist` VALUES('9','2','0','23','宣传','1');
REPLACE INTO `retengcms_taglist` VALUES('10','2','0','23','制作','1');
REPLACE INTO `retengcms_taglist` VALUES('11','2','0','23','美学','1');
REPLACE INTO `retengcms_taglist` VALUES('12','2','0','23','特征','1');
REPLACE INTO `retengcms_taglist` VALUES('13','2','0','23','哪些','1');
REPLACE INTO `retengcms_taglist` VALUES('14','3','0','23','酒店','1');
REPLACE INTO `retengcms_taglist` VALUES('15','3','0','23','服务业','1');
REPLACE INTO `retengcms_taglist` VALUES('16','3','0','23','拍摄','1');
REPLACE INTO `retengcms_taglist` VALUES('17','3','0','23','宣传','1');
REPLACE INTO `retengcms_taglist` VALUES('18','3','0','23','需要','1');
REPLACE INTO `retengcms_taglist` VALUES('19','3','0','23','注意','1');
REPLACE INTO `retengcms_taglist` VALUES('20','3','0','23','哪些','1');
REPLACE INTO `retengcms_taglist` VALUES('21','4','0','22','企业','1');
REPLACE INTO `retengcms_taglist` VALUES('22','4','0','22','宣传','1');
REPLACE INTO `retengcms_taglist` VALUES('23','4','0','22','详细','1');
REPLACE INTO `retengcms_taglist` VALUES('24','4','0','22','分类','1');
REPLACE INTO `retengcms_taglist` VALUES('25','4','0','22','制作','1');
REPLACE INTO `retengcms_taglist` VALUES('26','4','0','22','方法','1');
REPLACE INTO `retengcms_taglist` VALUES('27','4','0','22','哪些','1');
REPLACE INTO `retengcms_taglist` VALUES('28','5','0','22','宣传','1');
REPLACE INTO `retengcms_taglist` VALUES('29','5','0','22','制作','1');
REPLACE INTO `retengcms_taglist` VALUES('30','5','0','22','策划','1');
REPLACE INTO `retengcms_taglist` VALUES('31','5','0','22','作用','1');
REPLACE INTO `retengcms_taglist` VALUES('32','5','0','22','体现','1');
REPLACE INTO `retengcms_taglist` VALUES('33','6','0','21','集团','1');
REPLACE INTO `retengcms_taglist` VALUES('34','6','0','21','企业','1');
REPLACE INTO `retengcms_taglist` VALUES('35','6','0','21','宣传','1');
REPLACE INTO `retengcms_taglist` VALUES('36','6','0','21','金奖','1');
REPLACE INTO `retengcms_taglist` VALUES('37','7','0','21','国家','1');
REPLACE INTO `retengcms_taglist` VALUES('38','7','0','21','形象','1');
REPLACE INTO `retengcms_taglist` VALUES('39','7','0','21','宣传','1');
REPLACE INTO `retengcms_taglist` VALUES('40','7','0','21','有望','1');
REPLACE INTO `retengcms_taglist` VALUES('41','7','0','21','播放','1');
REPLACE INTO `retengcms_taglist` VALUES('42','8','0','24','制药','1');
REPLACE INTO `retengcms_taglist` VALUES('43','8','0','24','企业','1');
REPLACE INTO `retengcms_taglist` VALUES('44','8','0','24','宣传','1');
REPLACE INTO `retengcms_taglist` VALUES('52','9','0','24','宣传','1');
REPLACE INTO `retengcms_taglist` VALUES('51','9','0','24','企业','1');
REPLACE INTO `retengcms_taglist` VALUES('50','9','0','24','地板','1');
REPLACE INTO `retengcms_taglist` VALUES('49','9','0','24','融汇','1');
REPLACE INTO `retengcms_taglist` VALUES('67','10','0','26','制作','1');
REPLACE INTO `retengcms_taglist` VALUES('66','10','0','26','影视','1');
REPLACE INTO `retengcms_taglist` VALUES('65','10','0','26','广告','1');
REPLACE INTO `retengcms_taglist` VALUES('64','10','0','26','预告','1');
REPLACE INTO `retengcms_taglist` VALUES('63','10','0','26','电影','1');
REPLACE INTO `retengcms_taglist` VALUES('58','11','0','26','公寓','1');
REPLACE INTO `retengcms_taglist` VALUES('59','11','0','26','广告','1');
REPLACE INTO `retengcms_taglist` VALUES('60','11','0','26','拍摄','1');
REPLACE INTO `retengcms_taglist` VALUES('61','11','0','26','影视','1');
REPLACE INTO `retengcms_taglist` VALUES('62','11','0','26','制作','1');
DROP TABLE IF EXISTS `retengcms_tools`;
CREATE TABLE `retengcms_tools` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `boxid` mediumint(8) NOT NULL,
  `name` varchar(100) NOT NULL,
  `style` varchar(100) NOT NULL,
  `image` varchar(100) NOT NULL,
  `url` varchar(100) NOT NULL,
  `orderby` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `boxid` (`boxid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_vipread`;
CREATE TABLE `retengcms_vipread` (
  `contentid` mediumint(8) NOT NULL,
  `userid` mediumint(8) NOT NULL,
  KEY `contentid` (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_vote`;
CREATE TABLE `retengcms_vote` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `votename` varchar(50) NOT NULL DEFAULT '',
  `starttime` char(10) NOT NULL,
  `endtime` char(10) NOT NULL,
  `delay` mediumint(8) NOT NULL DEFAULT '0',
  `totalcount` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ismore` tinyint(1) NOT NULL DEFAULT '0',
  `votenote` text,
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_vote` VALUES('1','您觉得ReTengCMS对你有什么帮助？','1357574400','1375804800','24','0','1','<vote id=\"1\" count=\"0\">界面做的还不错 </vote>\n<vote id=\"2\" count=\"0\">功能基本满足我的需求 </vote>\n<vote id=\"3\" count=\"0\">让企业建站更简单</vote>\n<vote id=\"4\" count=\"0\">对我没啥帮助</vote>\n','1');
DROP TABLE IF EXISTS `retengcms_vote_ip`;
CREATE TABLE `retengcms_vote_ip` (
  `voteid` mediumint(8) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `votetime` varchar(10) NOT NULL,
  KEY `voteid` (`voteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_workbox`;
CREATE TABLE `retengcms_workbox` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `inlink` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
