DROP TABLE IF EXISTS `retengcms_admin`;
CREATE TABLE `retengcms_admin` (
  `userid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `username` char(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `logintime` varchar(10) NOT NULL,
  `allowmultilogin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `roleid` int(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_admin_cache`;
CREATE TABLE `retengcms_admin_cache` (
  `userid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `username` char(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `logintime` varchar(10) NOT NULL,
  `allowmultilogin` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `roleid` int(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`userid`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_ads`;
CREATE TABLE `retengcms_ads` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(40) NOT NULL DEFAULT 'name',
  `introduce` varchar(255) DEFAULT NULL,
  `adsposid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `type` varchar(10) NOT NULL,
  `linkurl` varchar(100) NOT NULL DEFAULT 'http://',
  `imageurl` varchar(100) NOT NULL DEFAULT 'http://',
  `alt` varchar(80) NOT NULL DEFAULT 'http://www.reteng.org',
  `flashurl` varchar(100) NOT NULL DEFAULT 'http://',
  `wmode` varchar(20) DEFAULT NULL,
  `text` text,
  `text_link` varchar(100) NOT NULL DEFAULT 'http://',
  `code` text,
  `fromdate` varchar(20) NOT NULL DEFAULT '0',
  `todate` varchar(20) NOT NULL DEFAULT '0',
  `addtime` varchar(20) NOT NULL DEFAULT '0',
  `views` int(10) unsigned NOT NULL DEFAULT '0',
  `clicks` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ispassed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `fromdate` (`fromdate`,`todate`),
  KEY `adsposid` (`adsposid`,`ispassed`,`fromdate`,`todate`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_adspos`;
CREATE TABLE `retengcms_adspos` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` char(50) NOT NULL,
  `template` char(30) NOT NULL DEFAULT '0',
  `introduce` char(100) DEFAULT NULL,
  `price` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `width` smallint(4) unsigned NOT NULL DEFAULT '0',
  `number` tinyint(2) NOT NULL DEFAULT '0',
  `height` smallint(4) unsigned NOT NULL DEFAULT '0',
  `ispassed` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `option` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_appointment`;
CREATE TABLE `retengcms_appointment` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `username` varchar(40) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `appdate` varchar(40) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_article`;
CREATE TABLE `retengcms_article` (
  `contentid` mediumint(8) NOT NULL,
  `content` mediumtext NOT NULL,
  `editor` varchar(30) NOT NULL,
  `copyfrom` varchar(100) NOT NULL,
  `video` varchar(255) NOT NULL,
  KEY `contentid` (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_author`;
CREATE TABLE `retengcms_author` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `orderby` int(6) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_badwords`;
CREATE TABLE `retengcms_badwords` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `badwords` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_badwords` VALUES('1','');
DROP TABLE IF EXISTS `retengcms_cache`;
CREATE TABLE `retengcms_cache` (
  `name` varchar(32) NOT NULL,
  `value` mediumtext NOT NULL,
  `expire` int(10) unsigned NOT NULL,
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_category`;
CREATE TABLE `retengcms_category` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `modelid` int(6) NOT NULL,
  `parentid` int(6) unsigned NOT NULL,
  `type` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `catname` varchar(60) NOT NULL,
  `domain` varchar(100) NOT NULL,
  `image` varchar(100) NOT NULL DEFAULT 'images/image128x128.png',
  `catdir` varchar(100) NOT NULL,
  `url` varchar(100) NOT NULL,
  `setting` text NOT NULL,
  `orderby` int(6) unsigned NOT NULL,
  `ispost` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `ismenu` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `m` tinyint(2) NOT NULL DEFAULT '1',
  `expand` text NOT NULL,
  `siteid` smallint(4) unsigned NOT NULL,
  `content` text,
  `navtype` varchar(100) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `modelid` (`modelid`,`parentid`,`type`),
  KEY `catdir` (`catdir`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_category` VALUES('1','0','0','3','会员管理','','images/image128x128.png','member','member/','','1','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('2','0','0','3','个人空间','','images/image128x128.png','space','','','2','0','0','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('3','0','0','3','友情链接','','images/image128x128.png','link','link/','','3','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('4','0','0','3','在线投票','','images/image128x128.png','vote','vote/','','4','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('5','0','0','3','搜索模块','','images/image128x128.png','search','search/','','5','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('6','0','0','3','广告管理','','images/image128x128.png','adv','','','6','0','0','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('7','0','0','3','文章tag标签','','images/image128x128.png','tags','tags/','','7','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('8','0','0','3','在线投稿','','images/image128x128.png','post','post/','','8','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('9','0','0','3','站外链接','','images/image128x128.png','workbox','','','9','0','0','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('10','0','0','3','订单支付','','images/image128x128.png','pay','','','10','0','0','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('11','0','0','3','留言管理','','images/image128x128.png','guestbook','guestbook/','','11','0','1','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('13','0','0','3','diy表单','','images/image128x128.png','form','','','13','0','0','1','','0','','');
REPLACE INTO `retengcms_category` VALUES('14','-1','0','2','关于我们','','images/image128x128.png','/guanyuwomen/','/list/?id=14&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_about\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','14','1','1','1','array (\n  \'encatname\' => \'ABOUT US\',\n)','1','','2');
REPLACE INTO `retengcms_category` VALUES('15','1','0','1','新闻中心','','images/image128x128.png','/xinwenzhongxin/','/list/?id=15&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_article\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','15','1','1','1','array (\n  \'encatname\' => \'NEWS CENTER\',\n)','1','','2');
REPLACE INTO `retengcms_category` VALUES('16','1','0','1','项目展示','','images/image128x128.png','/xiangmuzhanshi/','/list/?id=16&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_project\',\n  \'temparticle\' => \'article_project\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','16','1','1','1','array (\n  \'encatname\' => \'CASES\',\n)','1','','2');
REPLACE INTO `retengcms_category` VALUES('17','-1','0','2','业务范围','','images/image128x128.png','/yewufanwei/','/list/?id=17&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_page\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','17','1','1','1','array (\n  \'encatname\' => \'CURRENT ACCOUNT\',\n)','1','','2');
REPLACE INTO `retengcms_category` VALUES('18','-1','0','2','项目报价','','images/image128x128.png','/xiangmubaojia/','/list/?id=18&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_page\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','18','1','1','1','array (\n  \'encatname\' => \'QUOTATIOM\',\n)','1','','2');
REPLACE INTO `retengcms_category` VALUES('19','-1','0','2','合作伙伴','','images/image128x128.png','/hezuohuoban/','/list/?id=19&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_about\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','19','1','1','1','array (\n  \'encatname\' => \'PARTNER\',\n)','1','','2');
REPLACE INTO `retengcms_category` VALUES('20','-1','0','2','联系我们','','images/image128x128.png','/lianxiwomen/','/list/?id=20&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'single_page\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','20','1','1','1','array (\n  \'encatname\' => \'CONTACT US\',\n)','1','','2');
REPLACE INTO `retengcms_category` VALUES('21','1','15','1','企业新闻','','images/image128x128.png','/xinwenzhongxin/qiyexinwen/','/list/?id=21&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_article\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','21','1','1','2','','1','','1,2,3');
REPLACE INTO `retengcms_category` VALUES('22','1','15','1','业内资讯','','images/image128x128.png','/xinwenzhongxin/yenazixun/','/list/?id=22&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_article\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','22','1','1','2','','1','','1,2,3');
REPLACE INTO `retengcms_category` VALUES('23','1','15','1','行业相关','','images/image128x128.png','/xinwenzhongxin/xingyexiangguan/','/list/?id=23&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_article\',\n  \'temparticle\' => \'article_article\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','23','1','1','2','','1','','1,2,3');
REPLACE INTO `retengcms_category` VALUES('24','1','16','1','企业宣传','','images/image128x128.png','/xiangmuzhanshi/qiyexuanchuan/','/list/?id=24&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_project\',\n  \'temparticle\' => \'article_project\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','24','1','1','2','','1','','1,2,3');
REPLACE INTO `retengcms_category` VALUES('25','1','16','1','电视广告','','images/image128x128.png','/xiangmuzhanshi/dianshiguanggao/','/list/?id=25&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_project\',\n  \'temparticle\' => \'article_project\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','25','1','1','2','','1','','1,2,3');
REPLACE INTO `retengcms_category` VALUES('26','1','16','1','短片及三维','','images/image128x128.png','/xiangmuzhanshi/duanpianjisanwei/','/list/?id=26&siteid=1','array (\n  \'catishtml\' => \'0\',\n  \'ishtml\' => \'0\',\n  \'urlrule\' => \'{sitedir}html/{Y}{M}/a{cid}.htm\',\n  \'listurlrule\' => \'{catdir}list_{tid}_{page}.htm\',\n  \'islist\' => \'1\',\n  \'templist\' => \'list_project\',\n  \'temparticle\' => \'article_project\',\n  \'meta_title\' => \'\',\n  \'meta_keywords\' => \'\',\n  \'meta_description\' => \'\',\n)','26','1','1','2','','1','','1,2,3');
DROP TABLE IF EXISTS `retengcms_category_roleid`;
CREATE TABLE `retengcms_category_roleid` (
  `adminid` int(8) NOT NULL,
  `catid` varchar(100) NOT NULL,
  UNIQUE KEY `roleid` (`adminid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_category_roleid` VALUES('1','22,19,20,21,30');
DROP TABLE IF EXISTS `retengcms_collect`;
CREATE TABLE `retengcms_collect` (
  `id` int(5) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) NOT NULL DEFAULT '0',
  `title` varchar(160) NOT NULL,
  `url` varchar(100) NOT NULL DEFAULT '',
  `time` varchar(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_comment`;
CREATE TABLE `retengcms_comment` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` mediumint(8) unsigned NOT NULL,
  `contentid` mediumint(8) NOT NULL DEFAULT '0',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` varchar(20) NOT NULL,
  `userface` varchar(100) NOT NULL,
  `support` smallint(5) unsigned NOT NULL DEFAULT '0',
  `against` smallint(5) unsigned NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL DEFAULT '0.0.0.0',
  `addtime` varchar(10) NOT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`,`status`,`id`,`contentid`),
  KEY `status` (`status`,`contentid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_company`;
CREATE TABLE `retengcms_company` (
  `userid` mediumint(8) NOT NULL,
  `address` varchar(100) NOT NULL,
  `about` mediumtext NOT NULL,
  `busroute` varchar(100) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `openingtime` varchar(20) NOT NULL,
  `shenfenzheng` varchar(200) NOT NULL,
  `zhizhao` varchar(200) NOT NULL,
  `qq` varchar(20) NOT NULL,
  `pics` mediumtext NOT NULL,
  `dianhua` varchar(30) NOT NULL,
  `dizhi` varchar(200) NOT NULL,
  `lianxiren` varchar(30) NOT NULL,
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_config`;
CREATE TABLE `retengcms_config` (
  `id` smallint(8) unsigned NOT NULL AUTO_INCREMENT,
  `groupid` smallint(6) NOT NULL DEFAULT '1',
  `varname` varchar(20) NOT NULL DEFAULT '',
  `desc` varchar(100) NOT NULL DEFAULT '',
  `alt` varchar(100) NOT NULL DEFAULT '',
  `type` varchar(10) NOT NULL DEFAULT 'string',
  `value` text,
  `system` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_config` VALUES('1','1','site_name','网站名称','','string','石家庄市热腾传媒有限公司','1','1');
REPLACE INTO `retengcms_config` VALUES('2','1','childsite_url','网站地址','请填写完整URL地址，以\"/\"结尾','string','http://127.0.0.1/','1','1');
REPLACE INTO `retengcms_config` VALUES('3','1','tpl_name','默认模板','','string','chuanmei','1','1');
REPLACE INTO `retengcms_config` VALUES('4','1','meta_title','网站副标题','','string','ReTengCMS网站内容管理系统','1','1');
REPLACE INTO `retengcms_config` VALUES('5','1','meta_keywords','网站关键字','设置Meta标签的关键字，用英文逗号分隔','string','热腾CMS,RTCMS模板,ReTengCMS,开源,PHPCMS,PHP网站程序,CMS内容管理系统','1','1');
REPLACE INTO `retengcms_config` VALUES('6','1','meta_description','网站描述','设置Meta标签的描述信息','bstring','热腾CMS是集简单、灵活、开源几大特点的开源内容管理系统,完全符合SEO，是企业和个人建设网站的首选CMS系统。','1','1');
REPLACE INTO `retengcms_config` VALUES('7','1','separator','导航分隔符','如：网站首页 > 新闻','string','>','1','1');
REPLACE INTO `retengcms_config` VALUES('8','1','htmlext','HTML后缀','HTML后缀不要经常修改!修改后请更新内容。','string','.htm','1','1');
REPLACE INTO `retengcms_config` VALUES('9','1','iscity','只读取默认地区数据','开启后, 将自动读取默认地区数据，其他地区数据将不显示在前台。','bool','0','1','1');
REPLACE INTO `retengcms_config` VALUES('10','1','city','默认地区名','','string','615','1','1');
REPLACE INTO `retengcms_config` VALUES('11','1','map','地图精准定位','','string','120.1888,30.249800','1','1');
REPLACE INTO `retengcms_config` VALUES('12','1','ishtml','首页是否静态化','','string','0','1','1');
REPLACE INTO `retengcms_config` VALUES('13','1','copyright','版权信息','','string','CopyRight © 2014 <a href=\"http://www.reteng.org\" target=\"_blank\" style=\"text-decoration:none;\">热腾网</a> RETENG.Org, All Rights Reserved.','1','1');
REPLACE INTO `retengcms_config` VALUES('14','1','icpno','网站ICP备案序号','','string','ICP备:05002345号','1','1');
REPLACE INTO `retengcms_config` VALUES('15','1','logo','网站logo','','image','/images/logo.png','1','1');
REPLACE INTO `retengcms_config` VALUES('16','1','contact_phone','联系电话','网站头部电话号码','string','0311-88888888','0','1');
DROP TABLE IF EXISTS `retengcms_content`;
CREATE TABLE `retengcms_content` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `modelid` int(6) NOT NULL,
  `catid` int(6) unsigned NOT NULL DEFAULT '0',
  `areaid` smallint(6) NOT NULL,
  `template` char(100) NOT NULL,
  `title` char(160) NOT NULL,
  `style` char(30) NOT NULL,
  `thumb` char(100) NOT NULL DEFAULT '',
  `keywords` char(100) NOT NULL,
  `description` char(255) NOT NULL,
  `posid` tinyint(1) NOT NULL DEFAULT '0',
  `url` char(100) NOT NULL DEFAULT 'http://',
  `status` tinyint(2) unsigned NOT NULL DEFAULT '99',
  `point` smallint(5) NOT NULL DEFAULT '0',
  `amount` decimal(8,2) NOT NULL,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` char(80) NOT NULL,
  `inputtime` char(10) NOT NULL,
  `updatetime` char(10) NOT NULL,
  `clicks` int(5) unsigned NOT NULL DEFAULT '0',
  `comments` int(5) unsigned NOT NULL DEFAULT '0',
  `islink` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `password` varchar(32) NOT NULL,
  `expire` int(4) NOT NULL DEFAULT '0',
  `ispage` tinyint(1) NOT NULL DEFAULT '0',
  `pagecount` int(4) NOT NULL DEFAULT '5000',
  `iscomment` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `orderby` mediumint(8) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  `navtype` varchar(100) NOT NULL,
  `support` int(11) NOT NULL DEFAULT '0',
  `oppose` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `catid` (`catid`,`status`,`id`,`areaid`),
  KEY `status` (`status`,`id`),
  KEY `userid` (`userid`),
  KEY `modelid` (`modelid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_content_posid`;
CREATE TABLE `retengcms_content_posid` (
  `contentid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `posid` smallint(5) unsigned NOT NULL DEFAULT '0',
  KEY `posid` (`posid`),
  KEY `contentid` (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_copyfrom`;
CREATE TABLE `retengcms_copyfrom` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT 'http://',
  `orderby` int(6) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_copyfrom` VALUES('1','本站原创','http://','0','1');
DROP TABLE IF EXISTS `retengcms_counts`;
CREATE TABLE `retengcms_counts` (
  `id` char(32) NOT NULL DEFAULT '',
  `count` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `updatetime` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_counts` VALUES('ec31c6c14ee86c28f3e777efb95aed27','61','1411384328');
REPLACE INTO `retengcms_counts` VALUES('73f202dc29ccd0f4b6e282cef9847123','1','1411384327');
DROP TABLE IF EXISTS `retengcms_form`;
CREATE TABLE `retengcms_form` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `table` varchar(30) NOT NULL,
  `siteid` smallint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_form_fields`;
CREATE TABLE `retengcms_form_fields` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `form` varchar(80) NOT NULL,
  `formid` int(6) NOT NULL,
  `name` varchar(64) NOT NULL,
  `enname` varchar(32) NOT NULL,
  `tips` varchar(80) NOT NULL,
  `unit` varchar(32) NOT NULL,
  `options` text NOT NULL,
  `default` varchar(255) NOT NULL,
  `regex` varchar(80) NOT NULL,
  `css` varchar(32) NOT NULL,
  `length` varchar(8) NOT NULL,
  `orderby` int(6) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `cantdelete` tinyint(1) NOT NULL DEFAULT '0',
  `adminonly` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `formid` (`formid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_gather`;
CREATE TABLE `retengcms_gather` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `modelid` smallint(4) NOT NULL,
  `cotime` char(10) NOT NULL,
  `addtime` char(10) NOT NULL,
  `code` varchar(10) NOT NULL,
  `urlcounts` mediumint(8) NOT NULL,
  `listsetting` text NOT NULL,
  `itemsetting` text NOT NULL,
  `istask` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_gather_tmp`;
CREATE TABLE `retengcms_gather_tmp` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `nodeid` mediumint(8) NOT NULL,
  `title` varchar(80) NOT NULL,
  `url` varchar(160) NOT NULL,
  `content` mediumtext NOT NULL,
  `ispost` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_guestbook`;
CREATE TABLE `retengcms_guestbook` (
  `id` smallint(5) NOT NULL AUTO_INCREMENT,
  `title` char(200) NOT NULL,
  `email` varchar(40) NOT NULL,
  `phone` varchar(20) NOT NULL,
  `sex` varchar(6) NOT NULL,
  `content` text NOT NULL,
  `reply` text NOT NULL,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` char(20) NOT NULL,
  `hidden` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `passed` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL,
  `addtime` int(10) unsigned NOT NULL DEFAULT '0',
  `replyer` char(20) NOT NULL,
  `replytime` int(10) unsigned NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `hidden` (`hidden`,`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_keywords`;
CREATE TABLE `retengcms_keywords` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `keywords` varchar(30) NOT NULL,
  `weight` smallint(4) NOT NULL DEFAULT '0',
  `counts` mediumint(8) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`keywords`,`weight`,`counts`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_link`;
CREATE TABLE `retengcms_link` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `typeid` smallint(4) NOT NULL,
  `name` varchar(50) NOT NULL DEFAULT '',
  `url` varchar(100) NOT NULL DEFAULT '',
  `email` varchar(80) NOT NULL,
  `logo` varchar(100) NOT NULL DEFAULT '',
  `introduce` varchar(255) NOT NULL,
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `addtime` char(10) NOT NULL,
  `isindex` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `orderby` smallint(5) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`,`typeid`),
  KEY `typeid` (`typeid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_link` VALUES('1','1','热腾网','http://www.reteng.org','','','','0','1357653685','1','1','1');
REPLACE INTO `retengcms_link` VALUES('4','1','RTCMS','http://cms.reteng.org','','','','0','1406125267','1','4','1');
DROP TABLE IF EXISTS `retengcms_linktype`;
CREATE TABLE `retengcms_linktype` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `orderby` smallint(5) NOT NULL,
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `disabled` (`disabled`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_linktype` VALUES('1','友情连接','0','1','1');
DROP TABLE IF EXISTS `retengcms_log`;
CREATE TABLE `retengcms_log` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `admin` char(64) NOT NULL DEFAULT '',
  `method` char(10) NOT NULL DEFAULT '',
  `query` char(200) NOT NULL DEFAULT '',
  `comeurl` varchar(200) NOT NULL,
  `ip` char(15) NOT NULL DEFAULT '',
  `time` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_log` VALUES('1','admin','GET','file=admin&action=log','http://127.0.0.1/admin.php?file=left&menu=system','127.0.0.1','1411384331');
REPLACE INTO `retengcms_log` VALUES('2','admin','GET','file=main','http://127.0.0.1/admin.php','127.0.0.1','1411384331');
REPLACE INTO `retengcms_log` VALUES('3','admin','GET','file=db&action=export','http://127.0.0.1/admin.php?file=left&module=index','127.0.0.1','1411384332');
REPLACE INTO `retengcms_log` VALUES('4','admin','POST','file=db&action=export','http://127.0.0.1/admin.php?file=db&action=export','127.0.0.1','1411384334');
DROP TABLE IF EXISTS `retengcms_member`;
CREATE TABLE `retengcms_member` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `touserid` mediumint(8) NOT NULL DEFAULT '0',
  `modelid` int(6) NOT NULL,
  `groupid` int(6) NOT NULL DEFAULT '4',
  `gradeid` int(6) NOT NULL DEFAULT '10',
  `honorid` int(6) NOT NULL DEFAULT '0',
  `areaid` int(6) NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `facephoto` varchar(100) NOT NULL DEFAULT 'member/images/nophoto.gif',
  `email` varchar(80) NOT NULL,
  `telephone` varchar(20) NOT NULL,
  `message` tinyint(3) NOT NULL DEFAULT '0',
  `amount` decimal(8,2) unsigned NOT NULL DEFAULT '0.00',
  `point` int(6) NOT NULL DEFAULT '5',
  `regtime` varchar(10) NOT NULL DEFAULT '0',
  `logintime` varchar(10) NOT NULL DEFAULT '0',
  `logintimes` int(6) NOT NULL DEFAULT '0',
  `loginip` varchar(20) NOT NULL DEFAULT '0.0.0.0',
  `level` tinyint(1) NOT NULL DEFAULT '1',
  `expire` char(10) NOT NULL,
  `openid` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `modelid` (`modelid`,`groupid`),
  KEY `username` (`username`),
  KEY `openid` (`openid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_member` VALUES('1','0','1','1','10','0','0','admin','81f0a81f45125924be09cd15468ed5c5','member/images/nophoto.gif','master@reteng.org','','0','0.00','5','1411369817','1411369817','0','127.0.0.1','1','0','');
DROP TABLE IF EXISTS `retengcms_member_cache`;
CREATE TABLE `retengcms_member_cache` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `touserid` mediumint(8) NOT NULL DEFAULT '0',
  `modelid` int(6) NOT NULL,
  `groupid` int(6) NOT NULL,
  `gradeid` int(6) NOT NULL DEFAULT '0',
  `honorid` int(6) NOT NULL DEFAULT '0',
  `areaid` int(6) NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `facephoto` varchar(100) NOT NULL DEFAULT 'member/images/nophoto.gif',
  `email` varchar(80) NOT NULL,
  `telephone` varchar(20) NOT NULL,
  `message` tinyint(3) NOT NULL DEFAULT '0',
  `amount` decimal(8,2) unsigned NOT NULL DEFAULT '0.00',
  `point` int(6) NOT NULL DEFAULT '5',
  `regtime` varchar(10) NOT NULL DEFAULT '0',
  `logintime` varchar(10) NOT NULL DEFAULT '0',
  `logintimes` int(6) NOT NULL DEFAULT '0',
  `loginip` varchar(20) NOT NULL DEFAULT '0.0.0.0',
  `level` tinyint(1) NOT NULL DEFAULT '1',
  `expire` char(10) NOT NULL,
  `openid` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `openid` (`openid`),
  KEY `modelid` (`modelid`,`groupid`),
  KEY `username` (`username`),
  KEY `openid_2` (`openid`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_memberdb_fields`;
CREATE TABLE `retengcms_memberdb_fields` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `form` varchar(80) NOT NULL,
  `modelid` int(6) NOT NULL,
  `name` varchar(64) NOT NULL,
  `enname` varchar(32) NOT NULL,
  `tips` varchar(80) NOT NULL,
  `unit` varchar(32) NOT NULL,
  `options` text NOT NULL,
  `default` varchar(255) NOT NULL,
  `regex` varchar(80) NOT NULL,
  `css` varchar(32) NOT NULL,
  `length` varchar(8) NOT NULL,
  `orderby` int(6) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `cantdelete` tinyint(1) NOT NULL DEFAULT '0',
  `adminonly` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `modelid` (`modelid`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_memberdb_fields` VALUES('2','text','1','真实姓名','realname','','','选项值|选项\r\n选项值|选项','','chinese','','30','2','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('5','selectmenu_area','1','所属地区','areaid','','','','31','','','','1','0','1','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('6','selectmenu_area','2','所属地区','areaid','','','','5','','','','1','0','1','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('7','text','2','企业地址','address','','','选项值|选项\r\n选项值|选项','','','','100','5','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('8','fckeditor','2','企业简介','about','','','Basic','','','','255','12','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('9','text','2','公交线路','busroute','','','选项值|选项\r\n选项值|选项','','','','100','7','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('10','text','2','联系电话','phone','','','选项值|选项\r\n选项值|选项','','','','20','2','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('11','text','2','营业时间','openingtime','','','选项值|选项\r\n选项值|选项','8:00-18:00','','','20','8','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('12','image','2','身 份 证','shenfenzheng','','','选项值|选项\r\n选项值|选项','','','','200','9','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('13','image','2','营业执照','zhizhao','','','选项值|选项\r\n选项值|选项','','','','200','10','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('14','text','2','客服QQ','qq','','','选项值|选项\r\n选项值|选项','','qq','','20','4','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('15','images','2','企业图片','pics','','','选项值|选项\r\n选项值|选项','','','','255','11','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('16','text','1','联系电话','dianhua','','','选项值|选项\r\n选项值|选项','','','','30','3','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('17','text','1','客服QQ','qq','','','选项值|选项\r\n选项值|选项','','qq','','30','4','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('18','text','1','详细地址','dizhi','','','选项值|选项\r\n选项值|选项','','','','200','5','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('19','text','2','手机号码','dianhua','','','选项值|选项\r\n选项值|选项','','','','30','3','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('20','text','2','咨询地址','dizhi','','','选项值|选项\r\n选项值|选项','','','','200','6','0','0','0');
REPLACE INTO `retengcms_memberdb_fields` VALUES('21','text','2','联系人','lianxiren','','','选项值|选项\r\n选项值|选项','李先生','chinese','','30','2','0','0','0');
DROP TABLE IF EXISTS `retengcms_membergrade`;
CREATE TABLE `retengcms_membergrade` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `grade` varchar(10) NOT NULL,
  `amount` varchar(10) NOT NULL,
  `point` varchar(10) NOT NULL,
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `info` varchar(255) NOT NULL,
  `postcatid` text NOT NULL,
  `viewcatid` text NOT NULL,
  `module` char(100) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_membergrade` VALUES('1','普通会员','10','0','0','1','0','一号注册，全站通行。','0','0','9,28,7');
REPLACE INTO `retengcms_membergrade` VALUES('2','高级会员','20','100','100','1','0','一号注册，全站通行。享受更多特权，更多功能模块。','0','0','7,9,10,11,12');
DROP TABLE IF EXISTS `retengcms_membergroup`;
CREATE TABLE `retengcms_membergroup` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `orderby` int(6) NOT NULL,
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `postcatid` text NOT NULL,
  `viewcatid` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_membergroup` VALUES('1','管理员','1','1','0','0','0');
REPLACE INTO `retengcms_membergroup` VALUES('2','游客','2','1','0','0','0');
REPLACE INTO `retengcms_membergroup` VALUES('3','待审核','3','1','0','0','0');
REPLACE INTO `retengcms_membergroup` VALUES('4','注册会员','4','1','0','0','0');
DROP TABLE IF EXISTS `retengcms_memberhonor`;
CREATE TABLE `retengcms_memberhonor` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `point` varchar(10) NOT NULL,
  `ico` varchar(10) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_memberhonor` VALUES('1','列兵','100','1','0');
REPLACE INTO `retengcms_memberhonor` VALUES('2','班长','200','2','0');
DROP TABLE IF EXISTS `retengcms_membermodel`;
CREATE TABLE `retengcms_membermodel` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `table` varchar(30) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `register` tinyint(1) NOT NULL DEFAULT '1',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `module` char(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_membermodel` VALUES('1','普通会员','regular','0','1','1','');
REPLACE INTO `retengcms_membermodel` VALUES('2','企业会员','company','0','1','1','');
DROP TABLE IF EXISTS `retengcms_message`;
CREATE TABLE `retengcms_message` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `send_from_user` varchar(30) NOT NULL,
  `send_to_user` varchar(30) NOT NULL,
  `folder` enum('all','inbox','outbox') NOT NULL,
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `message_time` int(10) unsigned NOT NULL DEFAULT '0',
  `subject` char(200) NOT NULL,
  `content` text NOT NULL,
  `replyid` int(6) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `msgtoid` (`send_to_user`,`folder`),
  KEY `replyid` (`replyid`),
  KEY `folder` (`send_from_user`,`folder`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_model`;
CREATE TABLE `retengcms_model` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `table` varchar(32) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `table` (`table`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_model` VALUES('1','文章','article','0','1','1');
DROP TABLE IF EXISTS `retengcms_model_fields`;
CREATE TABLE `retengcms_model_fields` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `form` varchar(80) NOT NULL,
  `modelid` int(6) NOT NULL,
  `name` varchar(64) NOT NULL,
  `enname` varchar(32) NOT NULL,
  `tips` varchar(80) NOT NULL,
  `unit` varchar(32) NOT NULL,
  `options` text NOT NULL,
  `default` varchar(255) NOT NULL,
  `regex` varchar(80) NOT NULL,
  `css` varchar(32) NOT NULL,
  `length` varchar(8) NOT NULL,
  `orderby` int(6) NOT NULL,
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `cantdelete` tinyint(1) NOT NULL DEFAULT '0',
  `adminonly` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `modelid` (`modelid`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_model_fields` VALUES('1','title','1','文章标题','title','','','','','','','','1','0','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('2','style','1','字体颜色','style','','','','','','','','2','1','1','3','1');
REPLACE INTO `retengcms_model_fields` VALUES('3','thumb','1','封面图片','thumb','','','','','','','','3','0','1','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('4','keywords','1','关键字','keywords','','','','','','','','11','0','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('5','selectmenu_area','1','所属地区','areaid','','','','327','','','','101','1','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('6','description','1','内容简介','description','','','','','','','','8','0','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('7','posid','1','推荐位','posid','','','','','','','','9','0','1','3','1');
REPLACE INTO `retengcms_model_fields` VALUES('8','content','1','内容','content','','','','','','','','10','0','1','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('9','status','1','发布状态','status','','','','1','','','8','100','0','1','3','1');
REPLACE INTO `retengcms_model_fields` VALUES('10','iscomment','1','评论状态','iscomment','','','','1','','','','96','0','1','3','1');
REPLACE INTO `retengcms_model_fields` VALUES('11','point','1','阅读点数','point','','点','','0','','','','97','1','1','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('12','amount','1','阅读钱数','amount','','元','','0.0','','','','98','1','1','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('13','author','1','责任编辑','editor','','','选项值|选项\r\n选项值|选项','','','','30','79','0','0','1','1');
REPLACE INTO `retengcms_model_fields` VALUES('14','copyfrom','1','稿件来源','copyfrom','','','选项值|选项\r\n选项值|选项','','','','100','80','0','0','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('15','password','1','信息删除密码','password','针对游客有效，留空为屏蔽此功能!','','','','','','98','10','1','1','2','1');
REPLACE INTO `retengcms_model_fields` VALUES('16','expire','1','信息有效期','expire','0为不限!','天','','0','','','','99','1','1','2','1');
DROP TABLE IF EXISTS `retengcms_module`;
CREATE TABLE `retengcms_module` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `folder` varchar(10) NOT NULL,
  `author` varchar(60) NOT NULL,
  `site` varchar(100) NOT NULL,
  `version` varchar(10) NOT NULL,
  `tables` varchar(255) NOT NULL,
  `menu_admin` text NOT NULL,
  `menu_member` text NOT NULL,
  `agreement` mediumtext NOT NULL,
  `roleid` varchar(60) NOT NULL,
  `modelid` varchar(60) NOT NULL,
  `menu` tinyint(1) NOT NULL DEFAULT '0',
  `adminmenu` tinyint(1) NOT NULL DEFAULT '0',
  `adminonly` tinyint(1) NOT NULL DEFAULT '1',
  `disabled` tinyint(1) NOT NULL DEFAULT '0',
  `description` text NOT NULL,
  `orderby` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `folder` (`folder`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_module` VALUES('1','会员管理','member','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_member,retengcms_member_cache,retengcms_membermodel,retengcms_membergrade,retengcms_membergroup,retengcms_memberhonor,retengcms_memberdb_fields,retengcms_message,retengcms_collect','?mod=member&file=member&action=cache|更新缓存\r\n?mod=member&file=member&action=setting|配置选项\r\n?mod=member&file=member&action=manage|会员管理\r\n?mod=member&file=member&action=group|会 员 组\r\n?mod=member&file=member&action=grade|会员级别\r\n?mod=member&file=member&action=honor|会员头衔\r\n?mod=member&file=member&action=model|会员模型\r\n?mod=member&file=member&action=message|系统信息','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','1,2','1','0','1','0','本模块是由ReTengCMS官方开发的一款会员管理模块,可以实现会员注册等功能','1');
REPLACE INTO `retengcms_module` VALUES('2','个人空间','space','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_space,retengcms_space_comment,retengcms_space_newvisitor,retengcms_space_friends','?mod=space&file=space&action=manage|空间管理\r\n?mod=space&file=space&action=tagspace|空间调用\r\n?mod=space&file=space&action=tag|留言调用','member/index.php?mod=space&file=space&action=view|刷新空间\r\nmember/index.php?mod=space&file=space&action=info|空间设置\r\nmember/index.php?mod=space&file=space&action=template|模板样式\r\nmember/index.php?mod=space&file=space&action=guestbook|留言管理','本软件为自由软件, 你可以自由修改并使用。','1,2','1,2','0','0','0','0','本模块是由ReTengCMS内容管理系统开发的一款个人空间功能模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','9');
REPLACE INTO `retengcms_module` VALUES('3','友情链接','link','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_linktype,retengcms_link','?mod=link&file=link&action=cache|更新缓存\r\n?mod=link&file=link&action=type|友链类型\r\n?mod=link&file=link&action=type_add|添加类型\r\n?mod=link&file=link&action=tag|模板调用','','本软件为自由软件, 你可以自由修改并使用。','1,2','','1','0','1','0','本模块是由ReTengCMS内容管理系统开发的友情链接管理模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','5');
REPLACE INTO `retengcms_module` VALUES('4','在线投票','vote','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_vote,retengcms_vote_ip','?mod=vote&file=vote&action=manage|投票管理\r\n?mod=vote&file=vote&action=vote_add|添加投票','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','','1','0','1','0','本模块是由ReTengCMS内容管理系统开发的一款在线投票模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','7');
REPLACE INTO `retengcms_module` VALUES('5','搜索模块','search','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_keywords','?mod=search&file=search&action=keywords|关键字管理','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','1,2','1','0','1','0','本模块是由ReTengCMS内容管理系统开发的一款搜索功能模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','10');
REPLACE INTO `retengcms_module` VALUES('6','广告管理','adv','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_ads,retengcms_adspos','?mod=adv&file=ads&action=cache|更新缓存\r\n?mod=adv&file=ads&action=adspos|常规广告位\r\n?mod=adv&file=ads&action=adspos_add|添加广告位','','本软件为自由软件, 你可以自由修改并使用。','1,2,5','','0','0','1','0','本模块是由ReTengCMS内容管理系统开发的广告管理模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','4');
REPLACE INTO `retengcms_module` VALUES('7','文章tag标签','tags','热腾网','http://www.reteng.org/','1.0','retengcms_taglist,retengcms_tagindex','','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','1,2','1','0','0','0','本模块是由ReTeng开发的一款ReTengCMS内容管理系统功能模块,感谢您的下载使用.本模块主要是方便网站tag提取，增强网站优化等作用\r\n网址:http://www.reteng.org/','8');
REPLACE INTO `retengcms_module` VALUES('8','在线投稿','post','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','','?mod=post&file=post&action=config|配置选项','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','1,2','1','0','1','0','本模块是由热腾内容管理系统开发的一款ReTengCMS内容管理系统功能模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','14');
REPLACE INTO `retengcms_module` VALUES('9','站外链接','workbox','热腾网','http://www.reteng.org','1.0','retengcms_workbox,retengcms_tools','?mod=workbox&file=workbox&action=workbox|工具管理\r\n?mod=workbox&file=workbox&action=tag|模板调用','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','1,2','0','0','0','0','本模块可以是实现站内内容与设定的关键词相关联。从而有效的实现网站SEO外链增加！','12');
REPLACE INTO `retengcms_module` VALUES('10','订单支付','pay','热腾官方','http://www.reteng.org/','1.0','retengcms_pay_method,retengcms_pay_card,retengcms_pay_cardtype,retengcms_pay_log','?mod=pay&file=pay&action=paymethod|支付配置\r\n?mod=pay&file=pay&action=card|点卡管理\r\n?mod=pay&file=pay&action=cardtype|点卡类型\r\n?mod=pay&file=pay&action=log|财务日志\r\n?mod=pay&file=pay&action=member|会员充值\r\n?mod=pay&file=pay&action=order|订单查询\r\n?mod=pay&file=pay&action=paymethod_button|支付按钮','member/index.php?mod=pay&file=pay&action=online|在线充值\r\nmember/index.php?mod=pay&file=pay&action=card|点卡充值\r\nmember/index.php?mod=pay&file=pay&action=log|财务日志\r\nmember/index.php?mod=pay&file=pay&action=order|订单查询','本软件为自由软件, 你可以自由修改并使用。','1,5','1,2','0','0','0','0','本模块是由ReTengCMS官方开发支付功能模块，启用以后可以在模版中实现商品在线交易等功能','2');
REPLACE INTO `retengcms_module` VALUES('11','留言管理','guestbook','ReTengCMS内容管理系统','http://www.reteng.org/','1.0','retengcms_guestbook','?mod=guestbook&file=guestbook&action=manage&passed=1|已审留言\r\n?mod=guestbook&file=guestbook&action=manage&passed=0|待审留言','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','','1','0','1','0','本模块是由ReTengCMS内容管理系统开发的一款留言管理模块,感谢您的下载使用.如有任何问题可到我们的官方网址咨询!\r\n网址:http://www.reteng.org/','6');
REPLACE INTO `retengcms_module` VALUES('13','diy表单','form','热腾内容管理系统','http://www.reteng.org/','1.0','retengcms_form,retengcms_form_fields','?mod=form&file=form&action=manage|自定义表单\r\n?mod=form&file=form&action=add|添加表单','','本软件为自由软件, 你可以自由修改并使用。','1,2,3,4,5','1,2','0','0','1','0','本模块是由可以实现自定义表单数据，增强网站功能，例如：意见反馈，在线报名等功能！','16');
DROP TABLE IF EXISTS `retengcms_mood`;
CREATE TABLE `retengcms_mood` (
  `contentid` mediumint(8) NOT NULL,
  `surprise` mediumint(8) NOT NULL DEFAULT '0',
  `batting` mediumint(8) NOT NULL DEFAULT '0',
  `support` mediumint(8) NOT NULL DEFAULT '0',
  `great` mediumint(8) NOT NULL DEFAULT '0',
  `anger` mediumint(8) NOT NULL DEFAULT '0',
  `funny` mediumint(8) NOT NULL DEFAULT '0',
  `nausea` mediumint(8) NOT NULL DEFAULT '0',
  `puzzled` mediumint(8) NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_onlinereg`;
CREATE TABLE `retengcms_onlinereg` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_onlinereg` VALUES('1','张三');
DROP TABLE IF EXISTS `retengcms_order`;
CREATE TABLE `retengcms_order` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `sn` char(32) NOT NULL,
  `product` varchar(200) NOT NULL,
  `amount` varchar(20) NOT NULL,
  `number` varchar(20) NOT NULL,
  `payment` smallint(4) NOT NULL,
  `shipment` smallint(4) NOT NULL,
  `status` tinyint(2) NOT NULL DEFAULT '0',
  `buyuser` varchar(60) NOT NULL,
  `buyemail` varchar(60) NOT NULL,
  `buyphone` varchar(20) NOT NULL,
  `buyaddress` varchar(200) NOT NULL,
  `buymessage` text NOT NULL,
  `receiveuser` varchar(60) NOT NULL,
  `receivephone` varchar(20) NOT NULL,
  `receiveaddress` varchar(200) NOT NULL,
  `datetime` char(10) NOT NULL,
  `ip` varchar(20) NOT NULL,
  `userid` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `sn` (`sn`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_pay_card`;
CREATE TABLE `retengcms_pay_card` (
  `id` int(6) unsigned NOT NULL AUTO_INCREMENT,
  `cardid` varchar(32) NOT NULL DEFAULT '0',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `username` char(30) NOT NULL DEFAULT 'anonymity',
  `typeid` smallint(4) unsigned NOT NULL DEFAULT '0',
  `inputerid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `inputer` char(30) NOT NULL DEFAULT 'anonymity',
  `expire` int(10) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL DEFAULT '0.0.0.0',
  `price` varchar(5) NOT NULL DEFAULT '0',
  `amount` varchar(5) NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `cardid` (`cardid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_pay_cardtype`;
CREATE TABLE `retengcms_pay_cardtype` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `amount` varchar(5) NOT NULL DEFAULT '0',
  `price` varchar(5) NOT NULL DEFAULT '0',
  `orderby` smallint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_pay_log`;
CREATE TABLE `retengcms_pay_log` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `sn` varchar(32) NOT NULL,
  `username` varchar(30) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `manage` tinyint(1) NOT NULL DEFAULT '1',
  `type` varchar(10) NOT NULL,
  `amount` varchar(10) NOT NULL,
  `payment` varchar(32) NOT NULL,
  `note` text NOT NULL,
  `time` varchar(10) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `sn` (`sn`),
  KEY `username` (`username`,`ip`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_pay_method`;
CREATE TABLE `retengcms_pay_method` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) NOT NULL,
  `name` varchar(30) NOT NULL,
  `desc` text NOT NULL,
  `fee` varchar(10) NOT NULL,
  `config` text NOT NULL,
  `is_cod` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `is_online` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `orderby` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `enabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `author` varchar(100) NOT NULL,
  `website` varchar(100) NOT NULL,
  `version` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_pay_method` VALUES('1','alipay','支付宝','支付宝网站(www.alipay.com) 是国内先进的网上支付平台。\r\nReTengCMS联合支付宝推出支付宝接口。','0','array (\n  \'alipay_account\' => \'master@reteng.org\',\n  \'alipay_key\' => \'\',\n  \'alipay_partner\' => \'\',\n  \'service_type\' => \'0\',\n)','0','1','0','1','ReTengCMS','http://www.alipay.com','1.0.0');
REPLACE INTO `retengcms_pay_method` VALUES('2','post','邮局汇款','收款人信息：姓名 ××× ；地址 ××× ；邮编 ××× 。\r\n注意事项： 请在汇款单背面的附言中注明您的订单号，只填写后6位即可。','0','array (\n)','0','0','0','1','ReTengCMS','','1.0.0');
REPLACE INTO `retengcms_pay_method` VALUES('3','bank','银行汇款/转帐','银行名称\r\n收款人信息：全称 ××× ；帐号或地址 ××× ；开户行 ×××。\r\n注意事项：办理电汇时，请在电汇单“汇款用途”一栏处注明您的订单号。','0','array (\n)','0','0','0','1','ReTengCMS','','1.0.0');
DROP TABLE IF EXISTS `retengcms_permission`;
CREATE TABLE `retengcms_permission` (
  `id` smallint(6) NOT NULL AUTO_INCREMENT,
  `parentid` smallint(6) NOT NULL,
  `name` varchar(60) NOT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `roleid` varchar(80) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_permission` VALUES('1','0','系统配置','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('2','1','网站配置','1','1,2');
REPLACE INTO `retengcms_permission` VALUES('3','1','管理员','1','1');
REPLACE INTO `retengcms_permission` VALUES('4','1','数据备份','1','1');
REPLACE INTO `retengcms_permission` VALUES('5','6','级联菜单','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('6','0','栏目内容','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('7','6','栏目单页','1','1,2,3,4');
REPLACE INTO `retengcms_permission` VALUES('8','0','更新网站','1','1,2,3,4');
REPLACE INTO `retengcms_permission` VALUES('9','0','内容管理','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('10','0','模板管理','1','1,4');
REPLACE INTO `retengcms_permission` VALUES('11','10','模板方案','1','1,4');
REPLACE INTO `retengcms_permission` VALUES('12','10','内容调用','1','1,4');
REPLACE INTO `retengcms_permission` VALUES('13','0','模块插件','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('14','13','功能模块','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('15','13','插件管理','1','1,2,3');
REPLACE INTO `retengcms_permission` VALUES('16','13','内容模型','1','1,2,3');
DROP TABLE IF EXISTS `retengcms_posid`;
CREATE TABLE `retengcms_posid` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) NOT NULL,
  `orderby` int(6) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_posid` VALUES('1','首页头条','1');
REPLACE INTO `retengcms_posid` VALUES('2','栏目页推荐','2');
REPLACE INTO `retengcms_posid` VALUES('3','内容页推荐','3');
REPLACE INTO `retengcms_posid` VALUES('4','置顶信息','4');
REPLACE INTO `retengcms_posid` VALUES('5','切换焦点图','5');
DROP TABLE IF EXISTS `retengcms_regular`;
CREATE TABLE `retengcms_regular` (
  `userid` mediumint(8) NOT NULL,
  `realname` varchar(30) NOT NULL,
  `dianhua` varchar(30) NOT NULL,
  `qq` varchar(30) NOT NULL,
  `dizhi` varchar(200) NOT NULL,
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('2','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
REPLACE INTO `retengcms_regular` VALUES('1','','','','');
DROP TABLE IF EXISTS `retengcms_role`;
CREATE TABLE `retengcms_role` (
  `id` tinyint(3) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `orderby` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `disabled` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_role` VALUES('1','超级管理员','1','1','0');
REPLACE INTO `retengcms_role` VALUES('2','网站总编','2','1','0');
REPLACE INTO `retengcms_role` VALUES('3','栏目编辑','3','1','0');
REPLACE INTO `retengcms_role` VALUES('4','美工设计师','4','1','0');
REPLACE INTO `retengcms_role` VALUES('5','会计人员','5','1','0');
DROP TABLE IF EXISTS `retengcms_server_task`;
CREATE TABLE `retengcms_server_task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) CHARACTER SET gbk NOT NULL,
  `url` varchar(200) CHARACTER SET gbk NOT NULL,
  `updatetime` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `count` int(11) NOT NULL,
  `status` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=latin1;
DROP TABLE IF EXISTS `retengcms_session`;
CREATE TABLE `retengcms_session` (
  `sessionid` char(32) NOT NULL,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ip` char(15) NOT NULL,
  `lastvisit` int(10) unsigned NOT NULL DEFAULT '0',
  `data` char(255) NOT NULL,
  PRIMARY KEY (`sessionid`),
  KEY `lastvisit` (`lastvisit`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_session` VALUES('fdca22c1850647876d4db1e64bb8debb','1','127.0.0.1','1411384332','is_admin|b:1;admin_id|i:1;');
DROP TABLE IF EXISTS `retengcms_shipment`;
CREATE TABLE `retengcms_shipment` (
  `id` smallint(4) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `desc` text NOT NULL,
  `fee` varchar(10) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_sitecrowd`;
CREATE TABLE `retengcms_sitecrowd` (
  `id` mediumint(4) unsigned NOT NULL AUTO_INCREMENT,
  `site_name` varchar(200) NOT NULL,
  `site_url` varchar(200) NOT NULL,
  `site_dir` varchar(30) NOT NULL,
  `issueid` text NOT NULL,
  `tlp_name` varchar(80) NOT NULL,
  `seo_title` varchar(255) NOT NULL,
  `seo_description` varchar(255) NOT NULL,
  `seo_keywords` varchar(255) NOT NULL,
  `separator` varchar(8) NOT NULL DEFAULT '>',
  `htmlext` varchar(8) NOT NULL DEFAULT '.htm',
  `iscity` tinyint(1) NOT NULL DEFAULT '0',
  `city` mediumint(8) NOT NULL,
  `map` varchar(32) NOT NULL,
  `ishtml` tinyint(1) NOT NULL DEFAULT '0',
  `copyright` text NOT NULL,
  `icpno` varchar(32) NOT NULL,
  `system` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_sitecrowd` VALUES('1','默认站点','http://127.0.0.1/','/','','chuanmei','ReTengCMS网站内容管理系统','热腾CMS是集简单、灵活、开源几大特点的开源内容管理系统,完全符合SEO，是企业和个人建设网站的首选CMS系统。','热腾CMS,RTCMS模板,ReTengCMS,开源,PHPCMS,PHP网站程序,CMS内容管理系统','>','.htm','0','0','','0','CopyRight © 2014 <a href=\"http://www.reteng.org\" target=\"_blank\" style=\"text-decoration:none;\">热腾网</a> RETENG.Org, All Rights Reserved.','ICP备:05002345号','1');
DROP TABLE IF EXISTS `retengcms_sitecrowdissue`;
CREATE TABLE `retengcms_sitecrowdissue` (
  `issueid` mediumint(4) unsigned NOT NULL AUTO_INCREMENT,
  `issuename` varchar(80) NOT NULL,
  `ftphost` varchar(32) NOT NULL,
  `ftpport` varchar(4) NOT NULL,
  `ftpuser` varchar(64) NOT NULL,
  `ftppwd` varchar(64) NOT NULL,
  `ftpdir` varchar(80) NOT NULL,
  `ftpssl` tinyint(1) NOT NULL DEFAULT '0',
  `ftppasv` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`issueid`),
  UNIQUE KEY `ftphost` (`ftphost`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_space`;
CREATE TABLE `retengcms_space` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) unsigned NOT NULL,
  `logo` varchar(100) NOT NULL,
  `banner` varchar(100) NOT NULL,
  `name` varchar(80) NOT NULL,
  `meta_keywords` varchar(100) NOT NULL,
  `meta_description` varchar(250) NOT NULL,
  `template` varchar(40) NOT NULL,
  `opentime` varchar(10) NOT NULL,
  `lock` tinyint(1) NOT NULL DEFAULT '0',
  `syslock` tinyint(1) NOT NULL DEFAULT '0',
  `index` tinyint(1) NOT NULL DEFAULT '0',
  `visits` mediumint(8) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`,`lock`),
  UNIQUE KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_space_comment`;
CREATE TABLE `retengcms_space_comment` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) NOT NULL DEFAULT '0',
  `username` varchar(30) NOT NULL,
  `guestid` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `guestname` varchar(20) NOT NULL,
  `guestface` varchar(100) NOT NULL DEFAULT 'space/images/nophoto.gif',
  `content` text NOT NULL,
  `ip` varchar(15) NOT NULL DEFAULT '0.0.0.0',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0',
  `status` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`,`status`,`id`),
  KEY `ip` (`ip`,`status`,`id`),
  KEY `status` (`status`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_space_friends`;
CREATE TABLE `retengcms_space_friends` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) NOT NULL,
  `spaceid` mediumint(8) NOT NULL,
  `spacename` varchar(80) NOT NULL,
  `spacelogo` varchar(200) NOT NULL,
  `addtime` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_space_newvisitor`;
CREATE TABLE `retengcms_space_newvisitor` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `userid` mediumint(8) NOT NULL,
  `spaceid` mediumint(8) NOT NULL,
  `spacename` varchar(80) NOT NULL,
  `spacelogo` varchar(200) NOT NULL,
  `visittime` int(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `userid` (`userid`),
  KEY `spaceid` (`spaceid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_stepselect`;
CREATE TABLE `retengcms_stepselect` (
  `id` int(6) NOT NULL AUTO_INCREMENT,
  `name` varchar(60) NOT NULL,
  `table` varchar(30) NOT NULL,
  `issystem` tinyint(1) NOT NULL DEFAULT '0',
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `table` (`table`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_stepselect` VALUES('1','地区区域','area','0','1');
DROP TABLE IF EXISTS `retengcms_stepselect_enum`;
CREATE TABLE `retengcms_stepselect_enum` (
  `id` int(8) NOT NULL AUTO_INCREMENT,
  `selectid` int(6) NOT NULL,
  `name` varchar(60) NOT NULL,
  `parentid` int(8) NOT NULL,
  `orderby` int(8) NOT NULL,
  `evalue` varchar(20) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `evalue` (`evalue`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_stepselect_enum` VALUES('1','1','石家庄市','0','25500','25500');
REPLACE INTO `retengcms_stepselect_enum` VALUES('2','1','鹿泉市','1','25501','25501');
REPLACE INTO `retengcms_stepselect_enum` VALUES('3','1','辛集市','1','25502','25502');
DROP TABLE IF EXISTS `retengcms_tagindex`;
CREATE TABLE `retengcms_tagindex` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `tag` char(12) NOT NULL DEFAULT '',
  `catid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `count` int(10) unsigned NOT NULL DEFAULT '0',
  `total` int(10) unsigned NOT NULL DEFAULT '0',
  `uptime` int(10) unsigned NOT NULL DEFAULT '0',
  `addtime` int(10) unsigned NOT NULL DEFAULT '0',
  `siteid` smallint(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_taglist`;
CREATE TABLE `retengcms_taglist` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contentid` int(10) unsigned NOT NULL DEFAULT '0',
  `orderby` smallint(6) NOT NULL DEFAULT '0',
  `catid` smallint(5) unsigned NOT NULL DEFAULT '0',
  `tag` varchar(12) NOT NULL DEFAULT '',
  `siteid` smallint(4) NOT NULL,
  PRIMARY KEY (`id`,`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_tools`;
CREATE TABLE `retengcms_tools` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `boxid` mediumint(8) NOT NULL,
  `name` varchar(100) NOT NULL,
  `style` varchar(100) NOT NULL,
  `image` varchar(100) NOT NULL,
  `url` varchar(100) NOT NULL,
  `orderby` mediumint(8) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `boxid` (`boxid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_vipread`;
CREATE TABLE `retengcms_vipread` (
  `contentid` mediumint(8) NOT NULL,
  `userid` mediumint(8) NOT NULL,
  KEY `contentid` (`contentid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_vote`;
CREATE TABLE `retengcms_vote` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `votename` varchar(50) NOT NULL DEFAULT '',
  `starttime` char(10) NOT NULL,
  `endtime` char(10) NOT NULL,
  `delay` mediumint(8) NOT NULL DEFAULT '0',
  `totalcount` mediumint(8) unsigned NOT NULL DEFAULT '0',
  `ismore` tinyint(1) NOT NULL DEFAULT '0',
  `votenote` text,
  `siteid` smallint(4) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `siteid` (`siteid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
REPLACE INTO `retengcms_vote` VALUES('1','您觉得ReTengCMS对你有什么帮助？','1357574400','1375804800','24','0','1','<vote id=\"1\" count=\"0\">界面做的还不错 </vote>\n<vote id=\"2\" count=\"0\">功能基本满足我的需求 </vote>\n<vote id=\"3\" count=\"0\">让企业建站更简单</vote>\n<vote id=\"4\" count=\"0\">对我没啥帮助</vote>\n','1');
DROP TABLE IF EXISTS `retengcms_vote_ip`;
CREATE TABLE `retengcms_vote_ip` (
  `voteid` mediumint(8) NOT NULL,
  `ip` varchar(15) NOT NULL,
  `votetime` varchar(10) NOT NULL,
  KEY `voteid` (`voteid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
DROP TABLE IF EXISTS `retengcms_workbox`;
CREATE TABLE `retengcms_workbox` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `inlink` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
