# -----------------------------------------------------------
# Luojiaming database backup files
# Blog: http://www.duzui.org
# Type: 系统自动备份
# Description:当前SQL文件包含了表：zy_access、zy_admin、zy_category、zy_member、zy_news、zy_node、zy_picture、zy_role、zy_role_user的结构信息，表：zy_access、zy_admin、zy_category、zy_member、zy_news、zy_node、zy_picture、zy_role、zy_role_user的数据
# Time: 2014-08-08 09:57:25
# -----------------------------------------------------------
# 当前SQL卷标：#1
# -----------------------------------------------------------


# 数据库表：zy_access 结构信息
DROP TABLE IF EXISTS `zy_access`;
CREATE TABLE `zy_access` (
  `role_id` smallint(6) unsigned NOT NULL,
  `node_id` smallint(6) unsigned NOT NULL,
  `level` tinyint(1) NOT NULL,
  `pid` smallint(6) DEFAULT NULL,
  `module` varchar(50) DEFAULT NULL,
  KEY `groupId` (`role_id`),
  KEY `nodeId` (`node_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='权限分配表' ;

# 数据库表：zy_admin 结构信息
DROP TABLE IF EXISTS `zy_admin`;
CREATE TABLE `zy_admin` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `nickname` varchar(20) DEFAULT NULL,
  `email` varchar(50) DEFAULT NULL COMMENT '登录账号',
  `pwd` char(32) DEFAULT NULL COMMENT '登录密码',
  `status` int(11) DEFAULT '1' COMMENT '账号状态',
  `remark` varchar(255) DEFAULT '' COMMENT '备注信息',
  `find_code` char(5) DEFAULT NULL COMMENT '找回账号验证码',
  `time` int(10) DEFAULT NULL COMMENT '开通时间',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COMMENT='网站后台管理员表' ;

# 数据库表：zy_category 结构信息
DROP TABLE IF EXISTS `zy_category`;
CREATE TABLE `zy_category` (
  `cid` int(5) NOT NULL AUTO_INCREMENT,
  `pid` int(5) DEFAULT NULL COMMENT 'parentCategory上级分类',
  `name` varchar(20) DEFAULT NULL COMMENT '分类名称',
  PRIMARY KEY (`cid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='新闻分类表' ;

# 数据库表：zy_member 结构信息
DROP TABLE IF EXISTS `zy_member`;
CREATE TABLE `zy_member` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `weibo_uid` varchar(15) DEFAULT NULL COMMENT '对应的新浪微博uid',
  `tencent_uid` varchar(20) DEFAULT NULL COMMENT '腾讯微博UID',
  `email` varchar(100) DEFAULT NULL COMMENT '邮箱地址',
  `nickname` varchar(20) DEFAULT NULL COMMENT '用户昵称',
  `pwd` char(32) DEFAULT NULL COMMENT '密码',
  `reg_date` int(10) DEFAULT NULL,
  `reg_ip` char(15) DEFAULT NULL COMMENT '注册IP地址',
  `verify_status` int(1) DEFAULT '0' COMMENT '电子邮件验证标示 0未验证，1已验证',
  `verify_code` varchar(32) DEFAULT NULL COMMENT '电子邮件验证随机码',
  `verify_time` int(10) DEFAULT NULL COMMENT '邮箱验证时间',
  `verify_exp_time` int(10) DEFAULT NULL COMMENT '验证邮件过期时间',
  `find_fwd_code` varchar(32) DEFAULT NULL COMMENT '找回密码验证随机码',
  `find_pwd_time` int(10) DEFAULT NULL COMMENT '找回密码申请提交时间',
  `find_pwd_exp_time` int(10) DEFAULT NULL COMMENT '找回密码验证随机码过期时间',
  `avatar` varchar(100) DEFAULT NULL COMMENT '用户头像',
  `birthday` int(10) DEFAULT NULL COMMENT '用户生日',
  `sex` int(1) DEFAULT NULL COMMENT '0女1男',
  `address` varchar(50) DEFAULT NULL COMMENT '地址',
  `province` varchar(100) DEFAULT NULL COMMENT '省份',
  `city` varchar(100) DEFAULT NULL COMMENT '城市',
  `intr` varchar(500) DEFAULT NULL COMMENT '个人介绍',
  `mobile` varchar(11) DEFAULT NULL COMMENT '手机号码',
  `phone` varchar(30) DEFAULT NULL COMMENT '电话',
  `fax` varchar(30) DEFAULT NULL,
  `qq` int(15) DEFAULT NULL,
  `msn` varchar(100) DEFAULT NULL,
  `login_ip` varchar(15) DEFAULT NULL COMMENT '登录ip',
  `login_time` int(10) DEFAULT NULL COMMENT '登录时间',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=350 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='网站前台会员表' ;

# 数据库表：zy_news 结构信息
DROP TABLE IF EXISTS `zy_news`;
CREATE TABLE `zy_news` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `cid` smallint(3) DEFAULT NULL COMMENT '所在分类',
  `title` varchar(200) DEFAULT NULL COMMENT '新闻标题',
  `pic` varchar(200) DEFAULT NULL COMMENT '文章封面',
  `keywords` varchar(50) DEFAULT NULL COMMENT '文章关键字',
  `description` mediumtext COMMENT '文章描述',
  `status` tinyint(1) DEFAULT NULL,
  `summary` varchar(255) DEFAULT NULL COMMENT '文章摘要',
  `published` int(10) DEFAULT NULL,
  `update_time` int(10) DEFAULT NULL,
  `content` text,
  `views` int(10) DEFAULT '0' COMMENT '浏览量',
  `aid` smallint(3) DEFAULT NULL COMMENT '发布者UID',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='新闻表' ;

# 数据库表：zy_node 结构信息
DROP TABLE IF EXISTS `zy_node`;
CREATE TABLE `zy_node` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `title` varchar(50) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '0',
  `remark` varchar(255) DEFAULT NULL,
  `sort` smallint(6) unsigned DEFAULT NULL,
  `pid` smallint(6) unsigned NOT NULL,
  `level` tinyint(1) unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `level` (`level`),
  KEY `pid` (`pid`),
  KEY `status` (`status`),
  KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8 COMMENT='权限节点表' ;

# 数据库表：zy_picture 结构信息
DROP TABLE IF EXISTS `zy_picture`;
CREATE TABLE `zy_picture` (
  `id` int(5) NOT NULL AUTO_INCREMENT,
  `title` varchar(20) DEFAULT NULL COMMENT '广告名称',
  `url` varchar(255) DEFAULT NULL COMMENT '链接',
  `img` varchar(255) DEFAULT NULL COMMENT '图片',
  `status` tinyint(1) DEFAULT '0',
  `published` int(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='网站案例表' ;

# 数据库表：zy_role 结构信息
DROP TABLE IF EXISTS `zy_role`;
CREATE TABLE `zy_role` (
  `id` smallint(6) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(20) NOT NULL,
  `pid` smallint(6) DEFAULT NULL,
  `status` tinyint(1) unsigned DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='权限角色表' ;

# 数据库表：zy_role_user 结构信息
DROP TABLE IF EXISTS `zy_role_user`;
CREATE TABLE `zy_role_user` (
  `role_id` mediumint(9) unsigned DEFAULT NULL,
  `user_id` char(32) DEFAULT NULL,
  KEY `group_id` (`role_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='用户角色表' ;



# 数据库表：zy_access 数据信息
INSERT INTO `zy_access` VALUES ('2','31','3','26','');
INSERT INTO `zy_access` VALUES ('2','30','3','26','');
INSERT INTO `zy_access` VALUES ('2','29','3','26','');
INSERT INTO `zy_access` VALUES ('2','28','3','26','');
INSERT INTO `zy_access` VALUES ('2','27','3','26','');
INSERT INTO `zy_access` VALUES ('2','26','2','1','');
INSERT INTO `zy_access` VALUES ('2','25','3','14','');
INSERT INTO `zy_access` VALUES ('2','24','3','14','');
INSERT INTO `zy_access` VALUES ('2','23','3','14','');
INSERT INTO `zy_access` VALUES ('2','22','3','14','');
INSERT INTO `zy_access` VALUES ('3','14','2','1','');
INSERT INTO `zy_access` VALUES ('3','13','3','4','');
INSERT INTO `zy_access` VALUES ('3','12','3','4','');
INSERT INTO `zy_access` VALUES ('3','11','3','4','');
INSERT INTO `zy_access` VALUES ('3','10','3','4','');
INSERT INTO `zy_access` VALUES ('3','4','2','1','');
INSERT INTO `zy_access` VALUES ('3','9','3','3','');
INSERT INTO `zy_access` VALUES ('3','8','3','3','');
INSERT INTO `zy_access` VALUES ('3','7','3','3','');
INSERT INTO `zy_access` VALUES ('3','3','2','1','');
INSERT INTO `zy_access` VALUES ('3','6','3','2','');
INSERT INTO `zy_access` VALUES ('3','5','3','2','');
INSERT INTO `zy_access` VALUES ('3','2','2','1','');
INSERT INTO `zy_access` VALUES ('3','1','1','0','');
INSERT INTO `zy_access` VALUES ('4','7','3','3','');
INSERT INTO `zy_access` VALUES ('4','3','2','1','');
INSERT INTO `zy_access` VALUES ('4','6','3','2','');
INSERT INTO `zy_access` VALUES ('4','5','3','2','');
INSERT INTO `zy_access` VALUES ('4','2','2','1','');
INSERT INTO `zy_access` VALUES ('4','1','1','0','');
INSERT INTO `zy_access` VALUES ('2','21','3','14','');
INSERT INTO `zy_access` VALUES ('2','20','3','14','');
INSERT INTO `zy_access` VALUES ('2','19','3','14','');
INSERT INTO `zy_access` VALUES ('2','18','3','14','');
INSERT INTO `zy_access` VALUES ('2','17','3','14','');
INSERT INTO `zy_access` VALUES ('2','16','3','14','');
INSERT INTO `zy_access` VALUES ('2','15','3','14','');
INSERT INTO `zy_access` VALUES ('2','9','3','14','');
INSERT INTO `zy_access` VALUES ('2','8','3','14','');
INSERT INTO `zy_access` VALUES ('2','14','2','1','');
INSERT INTO `zy_access` VALUES ('2','10','3','4','');
INSERT INTO `zy_access` VALUES ('2','4','2','1','');
INSERT INTO `zy_access` VALUES ('2','7','3','3','');
INSERT INTO `zy_access` VALUES ('2','3','2','1','');
INSERT INTO `zy_access` VALUES ('2','6','3','2','');
INSERT INTO `zy_access` VALUES ('2','5','3','2','');
INSERT INTO `zy_access` VALUES ('2','2','2','1','');
INSERT INTO `zy_access` VALUES ('2','1','1','0','');
INSERT INTO `zy_access` VALUES ('2','45','3','26','');
INSERT INTO `zy_access` VALUES ('2','46','3','26','');
INSERT INTO `zy_access` VALUES ('2','47','3','26','');
INSERT INTO `zy_access` VALUES ('2','48','3','26','');


# 数据库表：zy_admin 数据信息
INSERT INTO `zy_admin` VALUES ('1','超级管理员','345179552@qq.com','89f06856c3943f7ecaab4b5e5e297144','1','我是超级管理员 哈哈~~','','1407463012');


# 数据库表：zy_category 数据信息


# 数据库表：zy_member 数据信息


# 数据库表：zy_news 数据信息


# 数据库表：zy_node 数据信息
INSERT INTO `zy_node` VALUES ('1','Admin','后台管理','1','网站后台管理项目','10','0','1');
INSERT INTO `zy_node` VALUES ('2','Index','管理首页','1','','1','1','2');
INSERT INTO `zy_node` VALUES ('3','Member','注册会员管理','1','','3','1','2');
INSERT INTO `zy_node` VALUES ('4','Webinfo','系统管理','1','','4','1','2');
INSERT INTO `zy_node` VALUES ('5','index','默认页','1','','5','2','3');
INSERT INTO `zy_node` VALUES ('6','myInfo','我的个人信息','1','','6','2','3');
INSERT INTO `zy_node` VALUES ('7','index','会员首页','1','','7','3','3');
INSERT INTO `zy_node` VALUES ('8','index','管理员列表','1','','8','14','3');
INSERT INTO `zy_node` VALUES ('9','addAdmin','添加管理员','1','','9','14','3');
INSERT INTO `zy_node` VALUES ('10','index','系统设置首页','1','','10','4','3');
INSERT INTO `zy_node` VALUES ('11','setEmailConfig','设置系统邮件','1','','12','4','3');
INSERT INTO `zy_node` VALUES ('12','testEmailConfig','发送测试邮件','1','','0','4','3');
INSERT INTO `zy_node` VALUES ('13','setSafeConfig','系统安全设置','1','','0','4','3');
INSERT INTO `zy_node` VALUES ('14','Access','权限管理','1','权限管理，为系统后台管理员设置不同的权限','0','1','2');
INSERT INTO `zy_node` VALUES ('15','nodeList','查看节点','1','节点列表信息','0','14','3');
INSERT INTO `zy_node` VALUES ('16','roleList','角色列表查看','1','角色列表查看','0','14','3');
INSERT INTO `zy_node` VALUES ('17','addRole','添加角色','1','','0','14','3');
INSERT INTO `zy_node` VALUES ('18','editRole','编辑角色','1','','0','14','3');
INSERT INTO `zy_node` VALUES ('19','opNodeStatus','便捷开启禁用节点','1','','0','14','3');
INSERT INTO `zy_node` VALUES ('20','opRoleStatus','便捷开启禁用角色','1','','0','14','3');
INSERT INTO `zy_node` VALUES ('21','editNode','编辑节点','1','','0','14','3');
INSERT INTO `zy_node` VALUES ('22','addNode','添加节点','1','','0','14','3');
INSERT INTO `zy_node` VALUES ('23','addAdmin','添加管理员','1','','0','14','3');
INSERT INTO `zy_node` VALUES ('24','editAdmin','编辑管理员信息','1','','0','14','3');
INSERT INTO `zy_node` VALUES ('25','changeRole','权限分配','1','','0','14','3');
INSERT INTO `zy_node` VALUES ('26','News','资讯管理','1','','0','1','2');
INSERT INTO `zy_node` VALUES ('27','index','新闻列表','1','','0','26','3');
INSERT INTO `zy_node` VALUES ('28','category','新闻分类管理','1','','0','26','3');
INSERT INTO `zy_node` VALUES ('29','add','发布新闻','1','','0','26','3');
INSERT INTO `zy_node` VALUES ('30','edit','编辑新闻','1','','0','26','3');
INSERT INTO `zy_node` VALUES ('31','del','删除信息','0','','0','26','3');
INSERT INTO `zy_node` VALUES ('32','SysData','数据库管理','1','包含数据库备份、还原、打包等','0','1','2');
INSERT INTO `zy_node` VALUES ('33','index','查看数据库表结构信息','1','','0','32','3');
INSERT INTO `zy_node` VALUES ('34','backup','备份数据库','1','','0','32','3');
INSERT INTO `zy_node` VALUES ('35','restore','查看已备份SQL文件','1','','0','32','3');
INSERT INTO `zy_node` VALUES ('36','restoreData','执行数据库还原操作','1','','0','32','3');
INSERT INTO `zy_node` VALUES ('37','delSqlFiles','删除SQL文件','1','','0','32','3');
INSERT INTO `zy_node` VALUES ('38','sendSql','邮件发送SQL文件','1','','0','32','3');
INSERT INTO `zy_node` VALUES ('39','zipSql','打包SQL文件','1','','0','32','3');
INSERT INTO `zy_node` VALUES ('40','zipList','查看已打包SQL文件','1','','0','32','3');
INSERT INTO `zy_node` VALUES ('41','unzipSqlfile','解压缩ZIP文件','1','','0','32','3');
INSERT INTO `zy_node` VALUES ('42','delZipFiles','删除zip压缩文件','1','','0','32','3');
INSERT INTO `zy_node` VALUES ('43','downFile','下载备份的SQL,ZIP文件','1','','0','32','3');
INSERT INTO `zy_node` VALUES ('44','repair','数据库优化修复','1','','0','32','3');
INSERT INTO `zy_node` VALUES ('45','picture','案例管理','1','','0','26','3');
INSERT INTO `zy_node` VALUES ('46','pictureadd','发布案例','1','','0','26','3');
INSERT INTO `zy_node` VALUES ('47','pictureedit','编辑案例','1','','0','26','3');
INSERT INTO `zy_node` VALUES ('48','picturedel','删除案例','1','','0','26','3');
INSERT INTO `zy_node` VALUES ('49','system','系统信息','1','','0','2','3');


# 数据库表：zy_picture 数据信息


# 数据库表：zy_role 数据信息
INSERT INTO `zy_role` VALUES ('1','超级管理员','0','1','系统内置超级管理员组，不受权限分配账号限制');
INSERT INTO `zy_role` VALUES ('2','系统管理员','1','1','拥有系统仅此于超级管理员的权限');
INSERT INTO `zy_role` VALUES ('3','普通管理员','1','1','拥有所有操作的读权限，无增加、删除、修改的权限');
INSERT INTO `zy_role` VALUES ('4','游客','1','1','后台测试用户组 - 无相关操作权限。');


# 数据库表：zy_role_user 数据信息
