<?php

// Menu
define("EW_MENUBAR_VERTICAL_CLASSNAME", "ewMenuBarVertical", TRUE);
define("EW_MENUBAR_SUBMENU_CLASSNAME", "", TRUE);
define("EW_MENUBAR_RIGHTHOVER_IMAGE", "", TRUE);
?>
<?php

/**
 * Menu class
 */

class cMenu {
	var $Id;
	var $IsRoot = FALSE;
	var $NoItem = NULL;
	var $ItemData = array();

	function cMenu($id) {
		$this->Id = $id;
	}

	// Add a menu item
	function AddMenuItem($id, $text, $url, $parentid, $src, $allowed = TRUE) {
		$item = new cMenuItem($id, $text, $url, $parentid, $src, $allowed);
		if (!MenuItem_Adding($item)) return;
		if ($item->ParentId < 0) {
			$this->AddItem($item);
		} else {
			if ($oParentMenu =& $this->FindItem($item->ParentId))
				$oParentMenu->AddItem($item);
		}
	}

	// Add item to internal array
	function AddItem($item) {
		$this->ItemData[] = $item;
	}

	// Find item
	function &FindItem($id) {
		$cnt = count($this->ItemData);
		for ($i = 0; $i < $cnt; $i++) {
			$item =& $this->ItemData[$i];
			if ($item->Id == $id) {
				return $item;
			} elseif (!is_null($item->SubMenu)) {
				if ($subitem =& $item->SubMenu->FindItem($id))
					return $subitem;
			}
		}
		return $this->NoItem;
	}

	// Check if a menu item should be shown
	function RenderItem($item) {
		if (!is_null($item->SubMenu)) {
			foreach ($item->SubMenu->ItemData as $subitem) {
				if ($item->SubMenu->RenderItem($subitem))
					return TRUE;
			}
		}
		return ($item->Allowed && $item->Url <> "");
	}

	// Check if this menu should be rendered
	function RenderMenu() {
		foreach ($this->ItemData as $item) {
			if ($this->RenderItem($item))
				return TRUE;
		}
		return FALSE;
	}

	// Render the menu
	function Render() {
		if (!$this->RenderMenu())
			return;
		echo "<ul";
		if ($this->Id <> "") {
			if (is_numeric($this->Id)) {
				echo " id=\"menu_" . $this->Id . "\"";
			} else {
				echo " id=\"" . $this->Id . "\"";
			}
		}
		if ($this->IsRoot)
			echo " class=\"" . EW_MENUBAR_VERTICAL_CLASSNAME . "\"";
		echo ">\n";
		foreach ($this->ItemData as $item) {
			if ($this->RenderItem($item)) {
				echo "<li><a";
				if (!is_null($item->SubMenu) && $item->SubMenu->RenderMenu())
					echo " class=\"" . EW_MENUBAR_SUBMENU_CLASSNAME . "\"";
				if ($item->Url <> "")
					echo " href=\"" . htmlspecialchars(strval($item->Url)) . "\"";
				echo ">" . $item->Text . "</a>\n";
				if (!is_null($item->SubMenu))
					$item->SubMenu->Render();
				echo "</li>\n";
			}
		}
		echo "</ul>\n";
	}
}

// Menu item class
class cMenuItem {
	var $Id;
	var $Text;
	var $Url;
	var $ParentId; 
	var $SubMenu = NULL; // Data type = cMenu
	var $Source;
	var $Allowed = TRUE;

	function cMenuItem($id, $text, $url, $parentid, $src, $allowed) {
		$this->Id = $id;
		$this->Text = $text;
		$this->Url = $url;
		$this->ParentId = $parentid;
		$this->Source = $src;
		$this->Allowed = $allowed;
	}

	function AddItem($item) { // Add submenu item
		if (is_null($this->SubMenu))
			$this->SubMenu = new cMenu($this->Id);
		$this->SubMenu->AddItem($item);
	}
}

// MenuItem Adding event
function MenuItem_Adding(&$Item) {

	//var_dump($Item);
	// Return FALSE if menu item not allowed

	return TRUE;
}
?>
<!-- Begin Main Menu -->
<div class="phpmaker">
<?php

// Generate all menu items
$RootMenu = new cMenu("RootMenu");
$RootMenu->IsRoot = TRUE;
$RootMenu->AddMenuItem(12, "", "", -1, "");
$RootMenu->AddMenuItem(2, "", "aboutuslblist.php", 12, "", IsLoggedIn());
$RootMenu->AddMenuItem(1, "", "aboutuslist.php?cmd=resetall", 12, "", IsLoggedIn());
$RootMenu->AddMenuItem(13, "ͻ", "", -1, "");
$RootMenu->AddMenuItem(3, "", "anlilist.php", 13, "", IsLoggedIn());
$RootMenu->AddMenuItem(14, "Ʒվ", "", -1, "");
$RootMenu->AddMenuItem(5, "Ʒվ", "cpwzlist.php", 14, "", IsLoggedIn());
$RootMenu->AddMenuItem(15, "Ѷ", "", -1, "");
$RootMenu->AddMenuItem(7, "Ѷ", "newlblist.php", 15, "", IsLoggedIn());
$RootMenu->AddMenuItem(8, "Ѷ", "newslist.php", 15, "", IsLoggedIn());
$RootMenu->AddMenuItem(16, "վײ", "", -1, "");
$RootMenu->AddMenuItem(9, "ײ", "taocanlist.php", 16, "", IsLoggedIn());
$RootMenu->AddMenuItem(17, "վԴ", "", -1, "");
$RootMenu->AddMenuItem(10, "Դ", "yuanmalist.php", 17, "", IsLoggedIn());
$RootMenu->AddMenuItem(4, "վɫ", "colorlist.php", -1, "", IsLoggedIn());
$RootMenu->AddMenuItem(6, "ģ", "mblblist.php", -1, "", IsLoggedIn());
$RootMenu->AddMenuItem(18, "ؼ", "gjclist.php", -1, "", IsLoggedIn());
$RootMenu->AddMenuItem(0xFFFFFFFF, "ע", "logout.php", -1, "", IsLoggedIn());
$RootMenu->AddMenuItem(0xFFFFFFFF, "¼", "login.php", -1, "", !IsLoggedIn() && substr(@$_SERVER["URL"], -1 * strlen("login.php")) <> "login.php");
$RootMenu->Render();
?>
</div>
<!-- End Main Menu -->
