DROP TABLE IF EXISTS `nitc_ad`;
CREATE TABLE `nitc_ad` (
`ad_id` int(10) unsigned NOT NULL auto_increment,
`language_id` int(10) NOT NULL default '1',
`category` varchar(50) NOT NULL,
`name` varchar(255) NOT NULL,
`url` varchar(255) NOT NULL,
`file` varchar(100) NOT NULL,
`sort_order` int(10) NOT NULL default '0',
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
`date_modified` datetime NOT NULL default '0000-00-00 00:00:00',
`type` int(10) NOT NULL default '0',
`state` tinyint(1) NOT NULL default '0',
PRIMARY KEY  (`ad_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_cart`;
CREATE TABLE `nitc_cart` (
`rec_id` mediumint(8) unsigned NOT NULL auto_increment,
`session_id` varchar(32) NOT NULL default '',
`product_id` mediumint(8) unsigned NOT NULL default '0',
`model` varchar(60) NOT NULL default '',
`weight` decimal(10,2) NOT NULL default '0.00',
`name` varchar(120) NOT NULL default '',
`price` decimal(10,2) unsigned NOT NULL default '0.00',
`quantity` smallint(5) unsigned NOT NULL default '0',
`attr` text NOT NULL,
`is_sale` tinyint(1) unsigned NOT NULL default '0',
PRIMARY KEY  (`rec_id`),
KEY `session_id` (`session_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_category`;
CREATE TABLE `nitc_category` (
`category_id` int(10) unsigned NOT NULL auto_increment,
`image` varchar(100) NOT NULL,
`parent_id` int(10) NOT NULL default '0',
`root_category_id` int(10) NOT NULL default '0',
`sort_order` int(3) default '0',
`state` int(1) default '0',
`is_protection` tinyint(1) unsigned NOT NULL default '0',
`view_style` int(10) unsigned NOT NULL default '0',
`product_list_cnt` int(10) unsigned NOT NULL default '0',
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
`date_modified` datetime NOT NULL default '0000-00-00 00:00:00',
`html_flag` int(3) unsigned NOT NULL default '0',
PRIMARY KEY  (`category_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_category_desc`;
CREATE TABLE `nitc_category_desc` (
`category_id` int(10) NOT NULL default '0',
`language_id` int(10) NOT NULL default '1',
`name` varchar(100) NOT NULL default '',
`abstract` text NOT NULL,
`meta_title` varchar(255) default NULL,
`meta_keywords` text,
`meta_description` text,
`description` text,
`page_name` varchar(100) default NULL,
PRIMARY KEY  (`category_id`,`language_id`),
KEY `name` (`name`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_channel_category`;
CREATE TABLE `nitc_channel_category` (
`channel_category_id` int(10) unsigned NOT NULL auto_increment,
`image` varchar(100) NOT NULL,
`parent_id` int(10) NOT NULL default '0',
`sort_order` float(10,1) default '0.0',
`state` int(1) default '0',
`flag` varchar(20) NOT NULL,
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
`date_modified` datetime NOT NULL default '0000-00-00 00:00:00',
`html_flag` int(3) unsigned NOT NULL default '0',
`sta` int(1) default '0',
`manage_url` varchar(255) NOT NULL default '',
`is_lock` int(1) NOT NULL default '0',
`is_display` int(1) NOT NULL default '0',
`is_share` tinyint(1) unsigned NOT NULL default '0',
`is_comment` tinyint(1) unsigned NOT NULL default '0',
PRIMARY KEY  (`channel_category_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

INSERT INTO `nitc_channel_category` (`channel_category_id`, `image`, `parent_id`, `sort_order`, `state`, `flag`, `date_added`, `date_modified`, `html_flag`, `sta`, `manage_url`, `is_lock`, `is_display`, `is_share`, `is_comment`) VALUES
(1, '', 0, 1.0, 0, 'index', '2010-04-30 13:33:28', '2010-05-04 10:23:00', 0, 0, 'home_meta.php?action=edit', 1, 0, 0, 0),
(2, '', 0, 2.0, 0, 'about-us', '2010-04-30 13:38:13', '2010-05-04 11:38:19', 0, 0, 'company.php?action=edit', 1, 0, 0, 0),
(3, '', 0, 3.0, 0, 'products', '2010-04-30 13:40:13', '2013-10-14 14:49:25', 0, 0, 'product.php?action=list', 1, 0, 1, 1),
(4, '', 0, 4.0, 0, 'news', '2010-04-30 13:42:13', '2013-08-31 22:05:37', 0, 0, 'channel_content.php?action=list&category_id=4', 1, 0, 1, 1),
(5, '', 0, 5.0, 0, 'download', '2010-04-30 13:45:13', '2013-10-14 15:00:58', 0, 0, 'channel_content.php?action=list&category_id=5', 0, 0, 1, 1),
(6, '', 0, 6.0, 0, 'inquiry', '2010-04-30 13:47:13', '2013-09-01 09:55:43', 0, 0, 'inquiry.php?action=list', 1, 0, 0, 0),
(7, '', 0, 7.0, 0, 'contact-us', '2010-04-30 13:50:13', '2010-05-04 16:50:40', 0, 0, 'contact.php?action=list', 1, 0, 0, 0),
(8, '', 0, 8.0, 0, 'links', '2010-04-30 13:57:13', '2010-05-04 16:59:47', 0, 1, 'channel_category.php?action=single&category_id=8', 0, 0, 0, 0);

DROP TABLE IF EXISTS `nitc_channel_category_desc`;
CREATE TABLE `nitc_channel_category_desc` (
`channel_category_id` int(10) NOT NULL default '0',
`language_id` int(10) NOT NULL default '1',
`name` varchar(100) NOT NULL default '',
`meta_title` varchar(255) default NULL,
`meta_keywords` text,
`meta_description` text,
`description` text,
`url` varchar(100) default NULL,
PRIMARY KEY  (`channel_category_id`,`language_id`),
KEY `name` (`name`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

INSERT INTO `nitc_channel_category_desc` (`channel_category_id`, `language_id`, `name`, `meta_title`, `meta_keywords`, `meta_description`, `description`, `url`) VALUES
(1, 1, 'Home', 'Home', 'Home', 'Home', '<p>Home</p>', ''),
(1, 2, '首页', '首页', '首页', '首页', '<p>首页</p>', ''),
(2, 1, 'About Us', 'About Us', 'About Us', 'About Us', '<p>About Us</p>', ''),
(2, 2, '公司介绍', '公司介绍', '公司介绍', '公司介绍', '<p>公司介绍</p>', ''),
(3, 1, 'Products', 'Products', 'Products', 'Products', '<p>Products</p>', ''),
(3, 2, '产品展示', '产品展示', '产品展示', '产品展示', '<p>产品展示</p>', ''),
(4, 1, 'News', 'News', 'News', 'News', '<p>News</p>', ''),
(4, 2, '新闻动态', '新闻动态', '新闻动态', '新闻动态', '<p>新闻动态</p>', ''),
(5, 1, 'Download', 'Download', 'Download', 'Download', '<p>Download</p>', ''),
(5, 2, '资料下载', '资料下载', '资料下载', '资料下载', '<p>资料下载</p>', ''),
(6, 1, 'Inquiry', 'Inquiry', 'Inquiry', 'Inquiry', 'Shipping Cart', ''),
(6, 2, '在线咨询', '在线咨询', '在线咨询', '在线咨询', '我的购物车', ''),
(7, 1, 'Contact Us', 'Contact Us', 'Contact Us', 'Contact Us', '<p>Contact Us</p>', ''),
(7, 2, '联系我们', '联系我们', '联系我们', '联系我们', '<p>联系我们</p>', ''),
(8, 1, 'Links', 'Links', 'Links', 'Links', '<p>Links</p>', ''),
(8, 2, '友情链接', '友情链接', '友情链接', '友情链接', '', '');

DROP TABLE IF EXISTS `nitc_channel_content`;
CREATE TABLE `nitc_channel_content` (
`channel_content_id` int(10) unsigned NOT NULL auto_increment,
`channel_category_id` int(10) NOT NULL default '0',
`filename` varchar(100) NOT NULL,
`small_image` varchar(100) NOT NULL default '',
`original_image` varchar(100) NOT NULL default '',
`is_featured` int(1) NOT NULL default '0',
`is_image` int(1) NOT NULL default '0',
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
`date_modified` datetime NOT NULL default '0000-00-00 00:00:00',
`viewed` int(5) NOT NULL default '0',
`html_flag` int(3) unsigned NOT NULL default '0',
`is_color` int(1) NOT NULL default '0',
`color` varchar(10) NOT NULL default '',
`is_underline` int(1) NOT NULL default '0',
`is_bold` int(1) NOT NULL default '0',
`is_italic` int(1) NOT NULL default '0',
`sort_order` int(10) NOT NULL default '0',
PRIMARY KEY  (`channel_content_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_channel_content_desc`;
CREATE TABLE `nitc_channel_content_desc` (
`channel_content_id` int(10) NOT NULL default '0',
`language_id` int(10) NOT NULL default '1',
`name` varchar(255) NOT NULL default '',
`abstract` text NOT NULL,
`meta_title` varchar(255) default NULL,
`meta_keywords` text,
`meta_description` text,
`description` text,
PRIMARY KEY  (`channel_content_id`,`language_id`),
KEY `name` (`name`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_channel_file`;
CREATE TABLE `nitc_channel_file` (
`file_id` int(10) NOT NULL auto_increment,
`channel_content_id` int(10) NOT NULL default '0',
`filename` varchar(100) NOT NULL default '0',
`small_image` varchar(100) NOT NULL default '0',
`original_image` varchar(100) NOT NULL default '0',
PRIMARY KEY  (`file_id`),
KEY `channel_content_id` (`channel_content_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_comment`;
CREATE TABLE `nitc_comment` (
`comment_id` int(10) unsigned NOT NULL auto_increment,
`language_id` int(10) unsigned NOT NULL default '0',
`comment_type` int(10) NOT NULL default '0',
`id_value` int(10) unsigned NOT NULL default '0',
`parent_id` int(10) unsigned NOT NULL default '0',
`title` varchar(120) NOT NULL,
`name` varchar(50) NOT NULL,
`email` varchar(60) NOT NULL default '',
`user_name` varchar(60) NOT NULL default '',
`content` text NOT NULL,
`comment_rank` tinyint(1) unsigned NOT NULL default '0',
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
`date_modified` datetime NOT NULL default '0000-00-00 00:00:00',
`ip` varchar(20) NOT NULL,
`is_read` tinyint(1) unsigned NOT NULL default '0',
`status` tinyint(1) unsigned NOT NULL default '0',
PRIMARY KEY  (`comment_id`),
KEY `parent_id` (`parent_id`),
KEY `id_value` (`id_value`),
KEY `language_id` (`language_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_company`;
CREATE TABLE `nitc_company` (
`company_id` int(10) unsigned NOT NULL auto_increment,
`html_flag` int(3) unsigned NOT NULL default '0',
`year_company_registered` varchar(100) default NULL,
`zip` varchar(50) default NULL,
`googleMapAddress` varchar(255) default NULL,
`googleMapKey` varchar(255) default NULL,
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
`date_modified` datetime NOT NULL default '0000-00-00 00:00:00',
PRIMARY KEY  (`company_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

INSERT INTO `nitc_company` (`company_id`) VALUES (1),(2);

DROP TABLE IF EXISTS `nitc_company_desc`;
CREATE TABLE `nitc_company_desc` (
`company_id` int(10) NOT NULL default '0',
`language_id` int(10) NOT NULL default '1',
`company_name` varchar(255) NOT NULL default '',
`logo` varchar(100) default NULL,
`abstract` text NOT NULL default '',
`address` varchar(250) NOT NULL default '',
`description` text default NULL,
`business_type` varchar(255) default NULL,
`product_service` varchar(255) default NULL,
`export_percentage` varchar(100) default NULL,
`factory_size` varchar(100) default NULL,
`factory_location` varchar(255) default NULL,
`employee_number` varchar(100) default NULL,
`annual_turnover` varchar(100) default NULL,
`brands` varchar(100) default NULL,
`main_markets` varchar(255) default NULL,
`certification` varchar(255) default NULL,
`website` varchar(255) default NULL,
PRIMARY KEY  (`company_id`,`language_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

INSERT INTO `nitc_company_desc` (`company_id`, `language_id`) VALUES (1, 1),(1, 2),(2, 1),(2, 2);

DROP TABLE IF EXISTS `nitc_config`;
CREATE TABLE `nitc_config` (
`id` smallint(5) unsigned NOT NULL auto_increment,
`code` varchar(30) NOT NULL default '',
`value` text NOT NULL,
PRIMARY KEY  (`id`),
UNIQUE KEY `code` (`code`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

INSERT INTO `nitc_config` (`id`, `code`, `value`) VALUES
(1, 'config_id', '1'),
(2, 'weburl', '-HTTP_URL_CHANGE'),
(3, 'date_start', '2010-01-01 00:00:00'),
(4, 'date_end', '2050-01-01 00:00:00'),
(5, 'flow_code', '<script type="text/javascript" src="-HTTP_URL_CHANGE/js/statistics.js"></script>'),
(6, 'share_code', ''),
(7, 'company_name', '您的公司名称'),
(8, 'version', ''),
(9, 'email_type', '0'),
(10, 'smtp_host', ''),
(11, 'smtp_port', '25'),
(12, 'smtp_user_name', ''),
(13, 'smtp_password', ''),
(14, 'smtp_email', ''),
(15, 'watermark_location', '0'),
(16, 'watermark_transparency', '65'),
(17, 'watermark_value', ''),
(18, 'support_name', ''),
(19, 'support_logo', ''),
(20, 'support_url', ''),
(21, 'featured_product_cnt', '6'),
(22, 'new_product_cnt', '6'),
(23, 'view_style', '0'),
(24, 'other_product_cnt', '10'),
(25, 'home_news_cnt', '6'),
(26, 'product_list_cnt', '20'),
(27, 'channel_cnt', '10'),
(28, 'channel_img_cnt', '12'),
(29, 'cache_time', '7200'),
(30, 'template', 'default'),
(31, 'small_img_thumb_width', '110'),
(32, 'small_img_thumb_height', '110'),
(33, 'middle_img_thumb_width', '250'),
(34, 'middle_img_thumb_height', '250'),
(35, 'news_img_thumb_width', '100'),
(36, 'news_img_thumb_height', '80'),
(37, 'channel_img_thumb_width', '200'),
(38, 'channel_img_thumb_height', '200'),
(39, 'enable_gzip', '0'),
(40, 'skin', 'blue_2010'),
(41, 'beian', ''),
(42, 'homepage_priority', '1'),
(43, 'homepage_changefreq', 'daily'),
(44, 'category_priority', '0.8'),
(45, 'category_changefreq', 'daily'),
(46, 'content_priority', '0.6'),
(47, 'content_changefreq', 'weekly'),
(48, 'copyright_year', '2013'),
(49, 'online_services', ''),
(50, 'online_state', '2'),
(51, 'custom_url', '1'),
(52, 'pseudo_static', '0'),
(53, 'products_show_type', '0'),
(54, 'htaccess', '<IfModule mod_rewrite.c>\nRewriteEngine on\nRewriteBase /\n\n\nRewriteRule ^(|/)$ index.php [L]\nRewriteRule ^(about[-|_]us|products|news|download|contact[-|_]us|sitemap|links).html$ index.php?action=$1 [L]\nRewriteRule ^(products|channel|download|news|brand)[-|_]page([0-9]{1,}).html$ index.php?action=$1&rpage=$2 [L]\nRewriteRule ^(products|channel|download|news|brand)[-|_]([0-9]{1,})[-|_]page([0-9]{1,}).html$ index.php?action=$1&rid=$2&rpage=$3 [L]\nRewriteRule ^(about[-|_]us|news|download|channel)/(.*)[-|_]([0-9]{1,}).html$ index.php?action=content&channel_flag=$1&rid=$2&rid=$3 [L]\n\nRewriteRule ^([a-zA-Z]{2})(|/)$ index.php?directory=$1 [L]\nRewriteRule ^([a-zA-Z]{2})/(about[-|_]us|products|news|download|contact[-|_]us|sitemap|links).html$ index.php?directory=$1&action=$2 [L]\nRewriteRule ^([a-zA-Z]{2})/(products|channel|download|news|brand)[-|_]page([0-9]{1,}).html$ index.php?directory=$1&action=$2&rpage=$3 [L]\nRewriteRule ^([a-zA-Z]{2})/(products|channel|download|news|brand)[-|_]([0-9]{1,})[-|_]page([0-9]{1,}).html$ index.php?directory=$1&action=$2&rid=$3&rpage=$4 [L]\nRewriteRule ^([a-zA-Z]{2})/(about[-|_]us|news|download|channel)/(.*)[-|_]([0-9]{1,}).html$ index.php?directory=$1&action=content&channel_flag=$2&rid=$3&rid=$4 [L]\n\nRewriteRule ^(.*).html$ index.php?static_url=$1 [L]\n\n</IfModule>'),
(55, 'randKey', ''),
(56, 'external_call', ''),
(57, 'is_shop', '1'),
(60, 'wap_url', '-HTTP_URL_CHANGE/wap/'),
(58, 'wap_enabled', '0'),
(59, 'wap_logo', '');

DROP TABLE IF EXISTS `nitc_contact`;
CREATE TABLE `nitc_contact` (
`contact_id` int(10) unsigned NOT NULL auto_increment,
`language_id` int(10) NOT NULL default '1',
`department` varchar(100) NOT NULL,
`email` varchar(255) NOT NULL default '',
`tel` varchar(100) NOT NULL default '',
`fax` varchar(100) default NULL,
`aliwangwang` text,
`yahoo` text,
`skype` text,
`qq` text,
`msn` text,
`state` int(1) NOT NULL default '0',
`contact_person` varchar(100) NOT NULL default '0',
`company_name` varchar(255) NOT NULL default '',
`address` varchar(255) NOT NULL default '',
`zip` varchar(30) NOT NULL default '',
`sort_order` int(10) NOT NULL default '0',
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
`date_modified` datetime NOT NULL default '0000-00-00 00:00:00',
`html_flag` int(3) unsigned NOT NULL default '0',
PRIMARY KEY  (`contact_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_country`;
CREATE TABLE `nitc_country` (
`country_id` int(10) NOT NULL auto_increment,
`country` varchar(100) NOT NULL default '',
`countrynum` varchar(10) NOT NULL default '',
`value` varchar(10) NOT NULL default '',
PRIMARY KEY  (`country_id`),
KEY `value` (`value`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

INSERT INTO `nitc_country` (`country_id`, `country`, `countrynum`, `value`) VALUES
(1, 'Afghanistan', '93', 'AF'),
(2, 'Albania', '355', 'AL'),
(3, 'Algeria', '213', 'DZ'),
(4, 'American Samoa', '684', 'AS'),
(5, 'Andorra', '376', 'AD'),
(6, 'Angola', '244', 'AO'),
(7, 'Anguilla', '1-264', 'AI'),
(8, 'Antarctica', '672', 'AQ'),
(9, 'Antigua and Barbuda', '1-268', 'AG'),
(10, 'Argentina', '54', 'AR'),
(11, 'Armenia', '374', 'AM'),
(12, 'Aruba', '297', 'AW'),
(13, 'Australia', '61', 'AU'),
(14, 'Austria', '43', 'AT'),
(15, 'Azerbaijan', '994', 'AZ'),
(16, 'Bahamas', '1-242', 'BS'),
(17, 'Bahrain', '973', 'BH'),
(18, 'Bangladesh', '880', 'BD'),
(19, 'Barbados', '1-246', 'BB'),
(20, 'Belarus', '375', 'BY'),
(21, 'Belgium', '32', 'BE'),
(22, 'Belize', '501', 'BZ'),
(23, 'Benin', '229', 'BJ'),
(24, 'Bermuda', '1-441', 'BM'),
(25, 'Bhutan', '975', 'BT'),
(26, 'Bolivia', '591', 'BO'),
(27, 'Bosnia and Herzegovina', '387', 'BA'),
(28, 'Botswana', '267', 'BW'),
(29, 'Bouvet Island', '', 'BV'),
(30, 'Brazil', '55', 'BR'),
(31, 'British Indian Ocean Territory', '1-284', 'IO'),
(32, 'Brunei Darussalam', '673', 'BN'),
(33, 'Bulgaria', '359', 'BG'),
(34, 'Burkina Faso', '226', 'BF'),
(35, 'Burundi', '257', 'BI'),
(36, 'Cambodia', '855', 'KH'),
(37, 'Cameroon', '237', 'CM'),
(38, 'Canada', '1', 'CA'),
(39, 'Cape Verde', '238', 'CV'),
(40, 'Cayman Islands', '1-345', 'KY'),
(41, 'Central African Republic', '236', 'CF'),
(42, 'Chad', '235', 'TD'),
(43, 'Chile', '56', 'CL'),
(44, 'China', '86', 'CN'),
(45, 'Christmas Island', '61', 'CX'),
(46, 'Cocos (Keeling) Islands', '61', 'CC'),
(47, 'Colombia', '57', 'CO'),
(48, 'Comoros', '269', 'KM'),
(49, 'Congo', '242', 'CG'),
(50, 'Congo, The Democratic Republic Of The', '243', 'ZR'),
(51, 'Cook Islands', '682', 'CK'),
(52, 'Costa Rica', '506', 'CR'),
(53, 'Cote D''Ivoire', '225', 'CI'),
(54, 'Croatia (local name: Hrvatska)', '385', 'HR'),
(55, 'Cuba', '53', 'CU'),
(56, 'Cyprus', '357', 'CY'),
(57, 'Czech Republic', '420', 'CZ'),
(58, 'Denmark', '45', 'DK'),
(59, 'Djibouti', '253', 'DJ'),
(60, 'Dominica', '1-767', 'DM'),
(61, 'Dominican Republic', '1-809', 'DO'),
(62, 'East Timor', '670', 'TP'),
(63, 'Ecuador', '593', 'EC'),
(64, 'Egypt', '20', 'EG'),
(65, 'El Salvador', '503', 'SV'),
(66, 'Equatorial Guinea', '240', 'GQ'),
(67, 'Eritrea', '291', 'ER'),
(68, 'Estonia', '372', 'EE'),
(69, 'Ethiopia', '251', 'ET'),
(70, 'Falkland Islands (Malvinas)', '500', 'FK'),
(71, 'Faroe Islands', '298', 'FO'),
(72, 'Fiji', '679', 'FJ'),
(73, 'Finland', '358', 'FI'),
(74, 'France', '33', 'FR'),
(75, 'France Metropolitan', '33', 'FX'),
(76, 'French Guiana', '594', 'GF'),
(77, 'French Polynesia', '689', 'PF'),
(78, 'French Southern Territories', '', 'TF'),
(79, 'Gabon', '241', 'GA'),
(80, 'Gambia', '220', 'GM'),
(81, 'Georgia', '995', 'GE'),
(82, 'Germany', '49', 'DE'),
(83, 'Ghana', '233', 'GH'),
(84, 'Gibraltar', '350', 'GI'),
(85, 'Greece', '30', 'GR'),
(86, 'Greenland', '299', 'GL'),
(87, 'Grenada', '1-473', 'GD'),
(88, 'Guadeloupe', '590', 'GP'),
(89, 'Guam', '1-671', 'GU'),
(90, 'Guatemala', '502', 'GT'),
(91, 'Guinea', '224', 'GN'),
(92, 'Guinea-Bissau', '245', 'GW'),
(93, 'Guyana', '592', 'GY'),
(94, 'Haiti', '509', 'HT'),
(95, 'Heard and Mc Donald Islands', '', 'HM'),
(96, 'Honduras', '504', 'HN'),
(97, 'Hong Kong', '852', 'HK'),
(98, 'Hungary', '36', 'HU'),
(99, 'Iceland', '354', 'IS'),
(100, 'India', '91', 'IN'),
(101, 'Indonesia', '62', 'ID'),
(102, 'Iran (Islamic Republic of)', '98', 'IR'),
(103, 'Iraq', '964', 'IQ'),
(104, 'Ireland', '353', 'IE'),
(105, 'Israel', '972', 'IL'),
(106, 'Italy', '39', 'IT'),
(107, 'Jamaica', '1-876', 'JM'),
(108, 'Japan', '81', 'JP'),
(109, 'Jordan', '962', 'JO'),
(110, 'Kazakhstan', '7', 'KZ'),
(111, 'Kenya', '254', 'KE'),
(112, 'Kiribati', '686', 'KI'),
(113, 'Kuwait', '965', 'KW'),
(114, 'Kyrgyzstan', '996', 'KG'),
(115, 'Lao People''s Democratic Republic', '', 'LA'),
(116, 'Latvia', '371', 'LV'),
(117, 'Lebanon', '961', 'LB'),
(118, 'Lesotho', '266', 'LS'),
(119, 'Liberia', '231', 'LR'),
(120, 'Libyan Arab Jamahiriya', '218', 'LY'),
(121, 'Liechtenstein', '423', 'LI'),
(122, 'Lithuania', '370', 'LT'),
(123, 'Luxembourg', '352', 'LU'),
(124, 'Macau', '853', 'MO'),
(125, 'Macedonia', '389', 'MK'),
(126, 'Madagascar', '261', 'MG'),
(127, 'Malawi', '265', 'MW'),
(128, 'Malaysia', '60', 'MY'),
(129, 'Maldives', '960', 'MV'),
(130, 'Mali', '223', 'ML'),
(131, 'Malta', '356', 'MT'),
(132, 'Marshall Islands', '692', 'MH'),
(133, 'Martinique', '596', 'MQ'),
(134, 'Mauritania', '222', 'MR'),
(135, 'Mauritius', '230', 'MU'),
(136, 'Mayotte', '269', 'YT'),
(137, 'Mexico', '52', 'MX'),
(138, 'Micronesia', '691', 'FM'),
(139, 'Moldova', '373', 'MD'),
(140, 'Monaco', '377', 'MC'),
(141, 'Mongolia', '976', 'MN'),
(142, 'Montserrat', '1-664', 'MS'),
(143, 'Montenegro', '382', 'MNE'),
(144, 'Morocco', '212', 'MA'),
(145, 'Mozambique', '258', 'MZ'),
(146, 'Myanmar', '95', 'MM'),
(147, 'Namibia', '264', 'NA'),
(148, 'Nauru', '674', 'NR'),
(149, 'Nepal', '977', 'NP'),
(150, 'Netherlands', '31', 'NL'),
(151, 'Netherlands Antilles', '599', 'AN'),
(152, 'New Caledonia', '687', 'NC'),
(153, 'New Zealand', '64', 'NZ'),
(154, 'Nicaragua', '505', 'NI'),
(155, 'Niger', '227', 'NE'),
(156, 'Nigeria', '234', 'NG'),
(157, 'Niue', '683', 'NU'),
(158, 'Norfolk Island', '672', 'NF'),
(159, 'North Korea', '850', 'KP'),
(160, 'Northern Mariana Islands', '1670', 'MP'),
(161, 'Norway', '47', 'NO'),
(162, 'Oman', '968', 'OM'),
(163, 'Pakistan', '92', 'PK'),
(164, 'Palau', '680', 'PW'),
(165, 'Palestine', '970', 'PS'),
(166, 'Panama', '507', 'PA'),
(167, 'Papua New Guinea', '675', 'PG'),
(168, 'Paraguay', '595', 'PY'),
(169, 'Peru', '51', 'PE'),
(170, 'Philippines', '63', 'PH'),
(171, 'Pitcairn', '872', 'PN'),
(172, 'Poland', '48', 'PL'),
(173, 'Portugal', '351', 'PT'),
(174, 'Puerto Rico', '1-787', 'PR'),
(175, 'Qatar', '974', 'QA'),
(176, 'Reunion', '262', 'RE'),
(177, 'Romania', '40', 'RO'),
(178, 'Russian Federation', '7', 'RU'),
(179, 'Rwanda', '250', 'RW'),
(180, 'Saint Kitts and Nevis', '', 'KN'),
(181, 'Saint Lucia', '', 'LC'),
(182, 'Saint Vincent and the Grenadines', '', 'VC'),
(183, 'Samoa', '685', 'WS'),
(184, 'San Marino', '378', 'SM'),
(185, 'Sao Tome and Principe', '', 'ST'),
(186, 'Saudi Arabia', '966', 'SA'),
(187, 'Serbia', '381', 'SRB'),
(188, 'Senegal', '221', 'SN'),
(189, 'Seychelles', '248', 'SC'),
(190, 'Sierra Leone', '232', 'SL'),
(191, 'Singapore', '65', 'SG'),
(192, 'Slovakia (Slovak Republic)', '421', 'SK'),
(193, 'Slovenia', '386', 'SI'),
(194, 'Solomon Islands', '677', 'SB'),
(195, 'Somalia', '252', 'SO'),
(196, 'South Africa', '27', 'ZA'),
(197, 'South Korea', '82', 'KR'),
(198, 'Spain', '34', 'ES'),
(199, 'Sri Lanka', '94', 'LK'),
(200, 'St. Helena', '290', 'SH'),
(201, 'St. Pierre and Miquelon', '508', 'PM'),
(202, 'Sudan', '249', 'SD'),
(203, 'Suriname', '597', 'SR'),
(204, 'Svalbard and Jan Mayen Islands', '', 'SJ'),
(205, 'Swaziland', '268', 'SZ'),
(206, 'Sweden', '46', 'SE'),
(207, 'Switzerland', '41', 'CH'),
(208, 'Syrian Arab Republic', '963', 'SY'),
(209, 'Taiwan', '886', 'TW'),
(210, 'Tajikistan', '992', 'TJ'),
(211, 'Tanzania', '255', 'TZ'),
(212, 'Thailand', '66', 'TH'),
(213, 'Togo', '228', 'TG'),
(214, 'Tokelau', '690', 'TK'),
(215, 'Tonga', '676', 'TO'),
(216, 'Trinidad and Tobago', '1-868', 'TT'),
(217, 'Tunisia', '216', 'TN'),
(218, 'Turkey', '90', 'TR'),
(219, 'Turkmenistan', '993', 'TM'),
(220, 'Turks and Caicos Islands', '1-649', 'TC'),
(221, 'Tuvalu', '688', 'TV'),
(222, 'Uganda', '256', 'UG'),
(223, 'Ukraine', '380', 'UA'),
(224, 'United Arab Emirates', '971', 'AE'),
(225, 'United Kingdom', '44', 'UK'),
(226, 'United States', '1', 'US'),
(227, 'United States Minor Outlying Islands', '', 'UM'),
(228, 'Uruguay', '598', 'UY'),
(229, 'Uzbekistan', '998', 'UZ'),
(230, 'Vanuatu', '678', 'VU'),
(231, 'Vatican City State (Holy See)', '39', 'VA'),
(232, 'Venezuela', '58', 'VE'),
(233, 'Vietnam', '84', 'VN'),
(234, 'Virgin Islands (British)', '1284', 'VG'),
(235, 'Virgin Islands (U.S.)', '1340', 'VI'),
(236, 'Wallis And Futuna Islands', '681', 'WF'),
(237, 'Western Sahara', '685', 'EH'),
(238, 'Yemen', '967', 'YE'),
(239, 'Yugoslavia', '381', 'YU'),
(240, 'Zambia', '260', 'ZM'),
(241, 'Zimbabwe', '263', 'ZW');

DROP TABLE IF EXISTS `nitc_customer`;
CREATE TABLE `nitc_customer` (
`customer_id` bigint(20) NOT NULL auto_increment,
`company_name` varchar(100) NOT NULL default '',
`address` varchar(250) default NULL,
`country` int(10) NOT NULL default '0',
`sex` varchar(10) NOT NULL,
`contact_person` varchar(100) NOT NULL default '',
`email` varchar(100) NOT NULL default '',
`tel` varchar(100) NOT NULL default '',
`fax` varchar(100) default NULL,
`website` varchar(100) default NULL,
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
`language_id` int(10) NOT NULL default '0',
PRIMARY KEY  (`customer_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_gallery`;
CREATE TABLE `nitc_gallery` (
`gallery_id` int(10) unsigned NOT NULL auto_increment,
`original` varchar(100) default NULL,
`filename` varchar(50) NOT NULL,
`filetype` varchar(50) default NULL,
`size` int(10) default NULL,
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
PRIMARY KEY  (`gallery_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_home_meta`;
CREATE TABLE `nitc_home_meta` (
`meta_id` int(20) NOT NULL auto_increment,
`meta_title` varchar(255) default NULL,
`meta_keywords` text default NULL,
`meta_description` text default NULL,
`language_id` int(10) NOT NULL default '1',
PRIMARY KEY  (`meta_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

INSERT INTO `nitc_home_meta` (`meta_id`,`language_id`) VALUES (1,2),(2,1);

DROP TABLE IF EXISTS `nitc_inquiry`;
CREATE TABLE `nitc_inquiry` (
`inquiry_id` int(10) NOT NULL auto_increment,
`product_id` int(10) NOT NULL default '0',
`member_id` int(10) unsigned NOT NULL default '0',
`subject` varchar(250) NOT NULL default '',
`company_name` varchar(255) default NULL,
`sex` varchar(10) NOT NULL,
`name` varchar(100) NOT NULL default '',
`email` varchar(250) NOT NULL default '',
`tel` varchar(250) NOT NULL default '',
`ip` varchar(20) NOT NULL default '',
`fax` varchar(100) default NULL,
`zip` varchar(50) NOT NULL,
`website` varchar(100) default NULL,
`state` int(1) NOT NULL default '0',
`content` text,
`country` int(10) NOT NULL default '0',
`address` varchar(250) default NULL,
`order_sn` varchar(100) NOT NULL default '',
`order_status` int(10) NOT NULL default '0' COMMENT '0=待付款,1=待发货,2=已发货,3=已完成,4=已取消',
`order_remark` text,
`shipping_name` varchar(100) NOT NULL default '',
`shipping_sn` varchar(100) NOT NULL default '',
`pay_name` varchar(100) NOT NULL default '',
`shipping_id` int(10) NOT NULL default '0',
`pay_id` int(10) NOT NULL default '0',
`pay_time` datetime NOT NULL default '0000-00-00 00:00:00',
`shipping_fee` decimal(10,2) NOT NULL default '0.00',
`order_amount` decimal(10,2) NOT NULL default '0.00',
`total_amount` decimal(10,2) NOT NULL default '0.00',
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
`customer_id` int(10) NOT NULL default '0',
`language_id` int(10) NOT NULL default '0',
PRIMARY KEY  (`inquiry_id`),
KEY `customer_id` (`customer_id`),
KEY `product_id` (`product_id`),
KEY `member_id` (`member_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_inquiry_product`;
CREATE TABLE `nitc_inquiry_product` (
`id` int(10) unsigned NOT NULL auto_increment,
`inquiry_id` int(10) unsigned NOT NULL default '0',
`product_id` int(10) unsigned NOT NULL default '0',
`name` varchar(255) NOT NULL,
`model` varchar(100) NOT NULL,
`price` varchar(100) NOT NULL,
`quantity` varchar(100) NOT NULL,
`page_name` varchar(100) default NULL,
PRIMARY KEY  (`id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_keywords`;
CREATE TABLE `nitc_keywords` (
`keyword_id` int(20) NOT NULL auto_increment,
`product_id` int(10) NOT NULL default '0',
`keyword` char(100) NOT NULL default '',
`language_id` int(10) NOT NULL default '1',
PRIMARY KEY  (`keyword_id`),
KEY `keyword` (`keyword`),
KEY `product_id` (`product_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_language`;
CREATE TABLE `nitc_language` (
`language_id` int(10) NOT NULL auto_increment,
`name` varchar(32) NOT NULL default '',
`image` varchar(64) default NULL,
`directory` varchar(100) NOT NULL default '',
`sort_order` int(3) default NULL,
`default_value` int(1) NOT NULL default '0',
`state` int(1) NOT NULL default '1',
`url` varchar(255) default NULL,
PRIMARY KEY  (`language_id`),
KEY `name` (`name`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

INSERT INTO `nitc_language` (`language_id`, `name`, `image`, `directory`, `sort_order`, `default_value`, `state`, `url`) VALUES
(1, 'English', 'country.png', 'en', 1, 0, 1, NULL),
(2, '简体中文', 'country.png', 'cn', 2, 1, 1, NULL);

DROP TABLE IF EXISTS `nitc_link`;
CREATE TABLE `nitc_link` (
`link_id` int(10) unsigned NOT NULL auto_increment,
`language_id` int(10) NOT NULL default '1',
`link_name` varchar(255) NOT NULL,
`link_logo` varchar(255) NOT NULL,
`link_url` varchar(255) NOT NULL default '',
`sort_order` int(10) NOT NULL default '0',
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
`date_modified` datetime NOT NULL default '0000-00-00 00:00:00',
PRIMARY KEY  (`link_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_mail_templates`;
CREATE TABLE `nitc_mail_templates` (
`template_id` tinyint(1) unsigned NOT NULL auto_increment,
`template_code` varchar(30) NOT NULL default '',
`is_html` tinyint(1) unsigned NOT NULL default '0',
`template_subject` varchar(200) NOT NULL default '',
`template_content` text NOT NULL,
`last_modify` int(10) unsigned NOT NULL default '0',
PRIMARY KEY  (`template_id`),
UNIQUE KEY `template_code` (`template_code`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

INSERT INTO `nitc_mail_templates` (`template_id`, `template_code`, `is_html`, `template_subject`, `template_content`, `last_modify`) VALUES
(1, 'send_password', 1, '找回密码', '{$user_name}，您好!\r\n\r\n您已经进行了密码重置的操作，请点击以下链接(或者复制到您的浏览器):\r\n\r\n{$reset_email}\r\n\r\n以确认您的新密码重置操作!\r\n\r\n{$send_date}', 1248768897),
(2, 'send_inquiry', 1, '咨询信息转发', '咨询主题:{$subject}\r\n咨询内容:\r\n{$content}\r\n日期:{$date_added}\r\n咨询产品:{$product_name}\r\n公司名:{$company_name}\r\n联系人:{$name} {$sex}\r\n邮箱:{$email}\r\n电话:{$tel}\r\n传真:{$fax}\r\n地址:{$address}\r\n国家:{$country}\r\nIP:{$ip}\r\n网站:{$website}', 1248848239);

DROP TABLE IF EXISTS `nitc_member`;
CREATE TABLE `nitc_member` (
`member_id` int(11) unsigned NOT NULL auto_increment,
`email` varchar(100) NOT NULL default '',
`name` varchar(100) NOT NULL default '',
`address` varchar(100) NOT NULL default '',
`tel` varchar(100) NOT NULL default '',
`zip` varchar(50) NOT NULL,
`password` varchar(255) default NULL,
`state` tinyint(1) unsigned NOT NULL default '0',
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
`last_time` datetime NOT NULL default '0000-00-00 00:00:00',
`last_ip` varchar(50) NOT NULL,
PRIMARY KEY  (`member_id`),
KEY `email` (`email`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_payment`;
CREATE TABLE `nitc_payment` (
`pay_id` tinyint(3) unsigned NOT NULL auto_increment,
`pay_code` varchar(20) NOT NULL default '',
`pay_name` varchar(120) NOT NULL default '',
`pay_fee` varchar(10) NOT NULL default '0',
`pay_desc` text NOT NULL,
`pay_order` tinyint(3) unsigned NOT NULL default '0',
`pay_config` text NOT NULL,
`enabled` tinyint(1) unsigned NOT NULL default '0',
`is_cod` tinyint(1) unsigned NOT NULL default '0',
`is_online` tinyint(1) unsigned NOT NULL default '0',
PRIMARY KEY  (`pay_id`),
UNIQUE KEY `pay_code` (`pay_code`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

INSERT INTO `nitc_payment` (`pay_id`, `pay_code`, `pay_name`, `pay_fee`, `pay_desc`, `pay_order`, `pay_config`, `enabled`, `is_cod`, `is_online`) VALUES
(1, 'alipay', '', '0', '', 0, 'a:4:{i:0;a:3:{s:4:"name";s:14:"alipay_account";s:4:"type";s:4:"text";s:5:"value";s:0:"";}i:1;a:3:{s:4:"name";s:10:"alipay_key";s:4:"type";s:4:"text";s:5:"value";s:0:"";}i:2;a:3:{s:4:"name";s:14:"alipay_partner";s:4:"type";s:4:"text";s:5:"value";s:0:"";}i:3;a:3:{s:4:"name";s:17:"alipay_pay_method";s:4:"type";s:6:"select";s:5:"value";s:1:"2";}}', 1, 0, 1);

DROP TABLE IF EXISTS `nitc_pay_log`;
CREATE TABLE `nitc_pay_log` (
`log_id` int(10) unsigned NOT NULL auto_increment,
`order_id` mediumint(8) unsigned NOT NULL default '0',
`order_amount` decimal(10,2) unsigned NOT NULL,
`order_type` tinyint(1) unsigned NOT NULL default '0',
`is_paid` tinyint(1) unsigned NOT NULL default '0',
PRIMARY KEY  (`log_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_product`;
CREATE TABLE `nitc_product` (
`product_id` int(10) NOT NULL auto_increment,
`model` varchar(100) NOT NULL,
`product_brand_id` int(10) NOT NULL default '0',
`category_id` int(10) NOT NULL default '0',
`price` decimal(10,2) NOT NULL default '0.00',
`weight` decimal(10,2) NOT NULL default '0.00',
`stock` int(10) unsigned NOT NULL default '0',
`small_image` varchar(100) default NULL,
`big_image` varchar(100) default NULL,
`original_image` varchar(100) default NULL,
`minorder` varchar(255) NOT NULL default '',
`sort_order` int(10) NOT NULL default '0',
`state` int(1) NOT NULL default '0',
`is_new_product` int(1) NOT NULL default '0',
`is_featured_product` int(1) NOT NULL default '0',
`is_wap` tinyint(1) unsigned NOT NULL default '0',
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
`date_modified` datetime NOT NULL default '0000-00-00 00:00:00',
`viewed` int(5) NOT NULL default '0',
`html_flag` int(3) unsigned NOT NULL default '0',
PRIMARY KEY  (`product_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_product_brand`;
CREATE TABLE `nitc_product_brand` (
`product_brand_id` int(11) unsigned NOT NULL auto_increment,
`logo` varchar(100) default NULL,
`sort_order` int(11) unsigned NOT NULL default '0',
`html_flag` tinyint(1) unsigned NOT NULL default '0',
PRIMARY KEY  (`product_brand_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_product_brand_desc`;
CREATE TABLE `nitc_product_brand_desc` (
`product_brand_id` int(11) NOT NULL auto_increment,
`language_id` int(11) NOT NULL default '1',
`name` varchar(255) NOT NULL default '',
PRIMARY KEY  (`product_brand_id`,`language_id`),
KEY `name` (`name`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_product_desc`;
CREATE TABLE `nitc_product_desc` (
`product_id` int(10) NOT NULL auto_increment,
`language_id` int(10) NOT NULL default '1',
`name` varchar(255) NOT NULL,
`abstract` text NOT NULL,
`keywords` text,
`meta_title` varchar(255) default NULL,
`meta_keywords` text,
`meta_description` text,
`description` text NOT NULL,
`video` text NOT NULL,
`page_name` varchar(100) default NULL,
`attachment` varchar(100) default NULL,
PRIMARY KEY  (`product_id`,`language_id`),
KEY `name` (`name`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_product_image`;
CREATE TABLE `nitc_product_image` (
`product_image_id` int(10) NOT NULL auto_increment,
`product_id` int(10) NOT NULL default '0',
`small_image` varchar(100) NOT NULL default '0',
`big_image` varchar(100) NOT NULL default '0',
`original_image` varchar(100) NOT NULL default '0',
PRIMARY KEY  (`product_image_id`),
KEY `product_id` (`product_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_sessions`;
CREATE TABLE `nitc_sessions` (
`sesskey` varchar(32) NOT NULL,
`expiry` int(10) unsigned NOT NULL,
`userid` mediumint(8) unsigned NOT NULL,
`adminid` mediumint(8) unsigned NOT NULL,
`ip` varchar(15) NOT NULL,
`data` longtext NOT NULL,
PRIMARY KEY  (`sesskey`),
KEY `expiry` (`expiry`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_shipping`;
CREATE TABLE `nitc_shipping` (
`shipping_id` tinyint(3) unsigned NOT NULL auto_increment,
`shipping_code` varchar(20) NOT NULL default '',
`shipping_name` varchar(120) NOT NULL default '',
`shipping_desc` varchar(255) NOT NULL default '',
`enabled` tinyint(1) unsigned NOT NULL default '0',
`configure` text,
`shipping_order` tinyint(3) unsigned NOT NULL default '0',
PRIMARY KEY  (`shipping_id`),
KEY `shipping_code` (`shipping_code`,`enabled`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

INSERT INTO `nitc_shipping` (`shipping_id`, `shipping_code`, `shipping_name`, `shipping_desc`, `enabled`, `configure`, `shipping_order`) VALUES
(1, 'express', '快递', '江、浙、沪地区首重为15元/KG，其他地区18元/KG， 续重均为5-6元/KG， 云南地区为8元', 1, 'a:5:{i:0;a:2:{s:4:"name";s:8:"item_fee";s:5:"value";s:1:"0";}i:1;a:2:{s:4:"name";s:8:"base_fee";s:5:"value";s:2:"";}i:2;a:2:{s:4:"name";s:8:"step_fee";s:5:"value";s:2:"";}i:3;a:2:{s:4:"name";s:10:"free_money";s:5:"value";s:0:"";}i:4;a:2:{s:4:"name";s:16:"fee_compute_mode";s:5:"value";s:9:"by_number";}}', 0);

DROP TABLE IF EXISTS `nitc_static_url`;
CREATE TABLE `nitc_static_url` (
`static_url_id` int(11) unsigned NOT NULL auto_increment,
`action` varchar(30) default NULL,
`rid` int(11) unsigned default NULL,
`static_url` varchar(100) default NULL,
`language_id` int(10) unsigned default NULL,
PRIMARY KEY  (`static_url_id`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_statistics`;
CREATE TABLE `nitc_statistics` (
`id` bigint(20) unsigned NOT NULL auto_increment,
`referer` varchar(255) NOT NULL default '',
`pageurl` varchar(255) NOT NULL default '',
`firsttime` varchar(50) NOT NULL default '',
`lasttime` varchar(50) default NULL,
`timezone` varchar(10) default NULL,
`ip` varchar(50) NOT NULL default '',
`search_text` varchar(100) NOT NULL,
`domain` varchar(50) NOT NULL,
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
PRIMARY KEY  (`id`),
KEY `search_text` (`search_text`),
KEY `domain` (`domain`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_tags`;
CREATE TABLE `nitc_tags` (
`tag_id` int(20) NOT NULL auto_increment,
`tag` varchar(100) NOT NULL,
`url` varchar(255) NOT NULL,
`sort_order` int(10) NOT NULL default '0',
`language_id` int(10) NOT NULL default '1',
PRIMARY KEY  (`tag_id`),
KEY `keyword` (`tag`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;

DROP TABLE IF EXISTS `nitc_user`;
CREATE TABLE `nitc_user` (
`user_id` tinyint(3) unsigned NOT NULL auto_increment,
`user_name` varchar(60) NOT NULL,
`password` varchar(32) NOT NULL,
`name` varchar(100) NOT NULL,
`tel` varchar(100) NOT NULL,
`email` varchar(100) NOT NULL,
`permission` text NOT NULL,
`date_added` datetime NOT NULL default '0000-00-00 00:00:00',
`date_modified` datetime NOT NULL default '0000-00-00 00:00:00',
`last_time` datetime NOT NULL default '0000-00-00 00:00:00',
`last_ip` varchar(50) NOT NULL,
PRIMARY KEY  (`user_id`),
KEY `user_name` (`user_name`)
) ENGINE=MyISAM -MYSQL_CHARSET_CHANGE;