
-- ----------------------------
--  Table structure for `cmseasy_a_attachment`
-- ----------------------------
CREATE TABLE `cmseasy_a_attachment` (
  `id` int(11) NOT NULL auto_increment,
  `aid` int(11) default NULL,
  `path` varchar(150) NOT NULL,
  `intro` varchar(100) default NULL,
  `adddate` datetime default NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `cmseasy_a_comment`
-- ----------------------------
CREATE TABLE `cmseasy_a_comment` (
  `id` int(11) NOT NULL auto_increment,
  `aid` int(11) NOT NULL,
  `content` text NOT NULL,
  `userid` int(11) default NULL,
  `username` varchar(50) default NULL,
  `adddate` datetime default NULL,
  `ip` varchar(20) default NULL,
  `state` tinyint(2) default '1',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `cmseasy_a_rank`
-- ----------------------------
CREATE TABLE `cmseasy_a_rank` (
  `id` int(11) NOT NULL auto_increment,
  `aid` int(11) default NULL,
  `typeid` int(11) default NULL,
  `ranks` text,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `cmseasy_a_vote`
-- ----------------------------
CREATE TABLE `cmseasy_a_vote` (
  `id` int(11) NOT NULL auto_increment,
  `aid` int(11) default NULL,
  `titles` text,
  `votes` text,
  `users` text,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `aid` (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- ----------------------------
--  Table structure for `cmseasy_announcement`
-- ----------------------------
CREATE TABLE `cmseasy_announcement` (
  `id` int(11) NOT NULL auto_increment,
  `title` varchar(100) default NULL,
  `content` mediumtext NOT NULL,
  `adddate` datetime default NULL,
  `state` tinyint(2) default '1',
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `cmseasy_archive`
-- ----------------------------
CREATE TABLE `cmseasy_archive` (
  `aid` int(11) NOT NULL auto_increment,
  `typeid` int(6) NOT NULL,
  `title` varchar(60) NOT NULL,
  `username` varchar(50) NOT NULL,
  `userid` int(11) NOT NULL,
  `view` int(11) NOT NULL default '0',
  `color` char(20) default NULL,
  `font` char(6) default NULL,
  `specialid` int(11) default NULL,
  `ip` varchar(20) default NULL,
  `mtitle` varchar(255) default NULL,
  `keyword` varchar(255) default NULL,
  `description` text,
  `order` int(11) default NULL,
  `adddate` datetime default NULL,
  `author` varchar(20) default NULL,
  `image` varchar(255) default NULL,
  `state` tinyint(2) default '1',
  `checked` tinyint(2) default '0',
  `introduce` text,
  `introduce_len` int(5) default NULL,
  `content` mediumtext,
  `template` varchar(50) default NULL,
  `htmlrule` varchar(100) default NULL,
  `ishtml` tinyint(2) default NULL,
  `linkto` varchar(100) default NULL,
  `arcatt1` varchar(20) default NULL,
  `arcatt2` varchar(20) default NULL,
  `arcatt3` varchar(20) default NULL,
  `comment_num` int(11) default '0',
  `attachment_id` varchar(50) default NULL,
  `grade` tinyint(1) unsigned NOT NULL default '0',
  `pics` text,
  PRIMARY KEY  (`aid`),
  UNIQUE KEY `aid` (`aid`),
  KEY `keyword` (`keyword`),
  KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `cmseasy_settings`
-- ----------------------------
CREATE TABLE `cmseasy_settings` (
  `id` int(11) NOT NULL auto_increment,
  `type` varchar(10) default NULL,
  `tag` varchar(30) NOT NULL default '',
  `value` mediumtext NOT NULL,
  `array` mediumtext,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `tag` (`tag`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `cmseasy_templatetag`
-- ----------------------------
CREATE TABLE `cmseasy_templatetag` (
  `id` int(11) NOT NULL auto_increment,
  `name` varchar(100) NOT NULL,
  `tagmodule` varchar(32) default NULL,
  `tagtype` varchar(32) default NULL,
  `tagcontent` text NOT NULL,
  `tagvar` text,
  `note` text,
  `tagfrom` varchar(16) default 'define',
  `template_name` varchar(50) NOT NULL,
  PRIMARY KEY  (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `cmseasy_type`
-- ----------------------------
CREATE TABLE `cmseasy_type` (
  `typeid` int(6) NOT NULL auto_increment,
  `parentid` int(6) NOT NULL,
  `typename` varchar(30) NOT NULL,
  `stype` varchar(50) default NULL,
  `order` int(11) DEFAULT NULL,
  `image` varchar(150) default NULL,
  `meta_title` varchar(255) default NULL,
  `keyword` varchar(150) default NULL,
  `description` text,
  `typecontent` mediumtext,
  `htmldir` varchar(50) NOT NULL,
  `template` varchar(50) default NULL,
  `listtemplate` varchar(50) default NULL,
  `showtemplate` varchar(50) default NULL,
  `htmlrule` varchar(100) default NULL,
  `listhtmlrule` varchar(100) default NULL,
  `showhtmlrule` varchar(100) default NULL,
  `module` varchar(16) NOT NULL default 'article',
  `isshow` tinyint(2) default '1',
  `ishtml` tinyint(2) default NULL,
  `ispages` tinyint(2) default NULL,
  `includecatarchives` tinyint(2) DEFAULT '0',
  `addarcenable` tinyint(2) default NULL,
  `linkto` varchar(150) default NULL,
  `typeatt1` varchar(20) default NULL,
  `typeatt2` varchar(20) default NULL,
  `typeatt3` varchar(20) default NULL,
  PRIMARY KEY  (`typeid`),
  UNIQUE KEY `type` (`typeid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `cmseasy_user`
-- ----------------------------
CREATE TABLE `cmseasy_user` (
  `userid` int(11) NOT NULL auto_increment,
  `username` varchar(20) NOT NULL,
  `password` varchar(50) NOT NULL,
  `nickname` varchar(20) default NULL,
  `groupid` int(2) NOT NULL default '0',
  `checked` tinyint(2) default NULL,
  `avatar` varchar(100) default NULL,
  `userip` varchar(20) default NULL,
  `state` tinyint(4) default '1',
  `qq` int(15) default NULL,
  `e_mail` varchar(60) default NULL,
  `address` varchar(255) default NULL,
  `tel` varchar(100) default NULL,
  `question` varchar(255) default NULL,
  `answer` varchar(255) default NULL,
  `intro` text,
  PRIMARY KEY  (`userid`),
  UNIQUE KEY `userid` (`userid`),
  UNIQUE KEY `username` (`username`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `cmseasy_ballot`
-- ----------------------------

CREATE TABLE IF NOT EXISTS `cmseasy_ballot` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `title` varchar(255) NOT NULL,
  `type` set('radio','checkbox') NOT NULL default 'radio',
  `num` int(11) unsigned NOT NULL default '0',
  `order` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `cmseasy_option`
-- ----------------------------

DROP TABLE IF EXISTS `cmseasy_option`;
CREATE TABLE IF NOT EXISTS `cmseasy_option` (
  `id` int(11) unsigned NOT NULL auto_increment,
  `bid` int(11) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `num` int(11) unsigned NOT NULL default '0',
  `order` int(11) unsigned NOT NULL default '0',
  PRIMARY KEY  (`id`),
  KEY `bid` (`bid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
--  Table structure for `cmseasy_usergroup`
-- ----------------------------
CREATE TABLE `cmseasy_usergroup` (
  `id` int(6) NOT NULL auto_increment,
  `groupid` int(6) NOT NULL,
  `name` varchar(20) NOT NULL,
  PRIMARY KEY  (`id`)
) ENGINE=MyISAM  DEFAULT CHARSET=utf8;


-- Table "cmseasy_event" DDL

CREATE TABLE `cmseasy_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) DEFAULT NULL,
  `username` varchar(50) DEFAULT NULL,
  `ip` varchar(20) DEFAULT NULL,
  `addtime` int(11) DEFAULT NULL,
  `event` varchar(30) DEFAULT NULL,
  `note` text NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  KEY `user` (`uid`,`username`,`ip`),
  KEY `time` (`addtime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- Table "cmseasy_friendlink" DDL

CREATE TABLE `cmseasy_friendlink` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `linktype` tinyint(2) DEFAULT NULL,
  `typeid` tinyint(2) DEFAULT NULL,
  `name` varchar(60) NOT NULL,
  `listorder` int(11) DEFAULT NULL,
  `url` varchar(255) NOT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `introduce` text,
  `uid` int(11) DEFAULT NULL,
  `username` varchar(60) DEFAULT NULL,
  `adddate` datetime DEFAULT NULL,
  `hits` int(11) DEFAULT NULL,
  `state` tinyint(2) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



CREATE TABLE `cmseasy_guestbook` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `userid` int(11) NOT NULL,
  `adddate` datetime NOT NULL,
  `state` tinyint(2) DEFAULT '1',
  `guesttel` varchar(50) NOT NULL,
  `guestemail` varchar(50) NOT NULL,
  `guestqq` varchar(50) NOT NULL,
  `title` varchar(50) NOT NULL,
  `content` text NOT NULL,
  `reply` text,
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


CREATE TABLE `cmseasy_linkword` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `linkword` varchar(255) NOT NULL,
  `linkurl` varchar(255) DEFAULT NULL,
  `linkorder` int(11) DEFAULT NULL,
  `linktimes` int(3) DEFAULT '1',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id` (`id`),
  UNIQUE KEY `word` (`linkword`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


-- ----------------------------
--  Records 
-- ----------------------------
INSERT INTO `cmseasy_type` VALUES('1','0','关于我们',NULL,NULL,NULL,NULL,NULL,NULL,'<p>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; CmsEasy是一款基于 PHP+Mysql 架构的网站内容管理系统，也是一个 PHP 开发平台。 采用模块化方式开发，功能易用便于扩展，可面向大中型站点提供重量级网站建设解决方案。2年来，凭借 团队长期积累的丰富的Web开发及数据库经验和勇于创新追求完美的设计理念，使得 CmsEasy v1.0 得到了众多网站的认可，并且越来越多地被应用到大中型商业网站。</p>','about','archive/list_page.html','archive/list_page.html','archive/show.html',NULL,NULL,NULL,'article','1','0','1','1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO cmseasy_type VALUES('2','0','企业新闻',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'news','archive/list_text.html','0','0',NULL,NULL,NULL,'article','1','0','1','1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO cmseasy_type VALUES('3','0','产品中心',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'products','archive/list_pic.html','archive/list_text_pic.html','0',NULL,NULL,NULL,'article','1','0','1','1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO cmseasy_type VALUES('4','0','营销网络',NULL,NULL,NULL,NULL,NULL,NULL,NULL,'marketing','archive/list_text.html','0','0',NULL,NULL,NULL,'article','1','0','1','1',NULL,NULL,NULL,NULL,NULL);
INSERT INTO cmseasy_type VALUES('5','0','联系我们',NULL,NULL,NULL,NULL,NULL,NULL,'<p>如果你想拥有一份自由有趣的工作，如果你对界面设计拥有一份热情和动力，那么请与我们联系。在这里你能发现一群志同道合的年轻人，并为了实践理想而努力！</p> <p>我们的团队为自己的理想奋斗，我们互补性强，分工明确，目标一致，我们艰苦奋斗，坚持不辍！因为我们坚信，一个好的理念和一个优秀的团队势必会成就一个远大的理想！<br /> &nbsp;</p> <p>联系我们：<br /> 售前咨询客服QQ-01：<br /> 售前咨询客服QQ-02：<br /> 客户售前咨询热线：<br /> 客户售后服务热线：<br /> 客服信箱：</p>','contact','archive/list_page.html','archive/list_page.html','0',NULL,NULL,NULL,'article','1','0','1','1',NULL,NULL,NULL,NULL,NULL);

INSERT INTO `cmseasy_archive` VALUES('1','1','版权声明','管理员','127','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2009-10-07 18:41:24','cmseasy',NULL,'1','1','版权声明','200','<p>版权声明</p>','0','license.html',NULL,NULL,NULL,NULL,NULL,'0',NULL,'0',NULL);
INSERT INTO `cmseasy_archive` VALUES('2','1','付款方式','管理员','127','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2009-10-07 18:43:47','cmseasy',NULL,'1','1','付款方式','200','<p>付款方式</p>','0','contact.html',NULL,NULL,NULL,NULL,NULL,'0',NULL,'0',NULL);
INSERT INTO `cmseasy_archive` VALUES('3','1','诚聘英才','管理员','127','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2009-10-07 18:45:12','cmseasy',NULL,'1','1','诚聘英才','200','<p>诚聘英才</p>','0','job.html',NULL,NULL,NULL,NULL,NULL,'0',NULL,'0',NULL);
INSERT INTO `cmseasy_archive` VALUES('4','1','网站地图','管理员','127','0',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2009-10-07 18:45:43','cmseasy',NULL,'1','1',NULL,'200',NULL,'archive/sitemap.html','sitemap.html',NULL,NULL,NULL,NULL,NULL,'0',NULL,'0',NULL);

INSERT INTO cmseasy_settings VALUES('1','0','table-archive','a:1:{s:7:\"arcatt1\";s:93:\"(1)首页推荐 \r\n(2)首页焦点 \r\n(3)首页头条 \r\n(4)列表页推荐 \r\n(5)内容页推荐\";}','array (\n  \'arcatt1\' => \'(1)首页推荐 \r\n(2)首页焦点 \r\n(3)首页头条 \r\n(4)列表页推荐 \r\n(5)内容页推荐\',\n)');

INSERT INTO cmseasy_friendlink VALUES('1','1',NULL,'易通免费企业CMS','0','http://www.cmseasy.cn',NULL,NULL,NULL,'cmseasy','2009-11-12 13:14:37',NULL,'1');
INSERT INTO cmseasy_friendlink VALUES('2','1',NULL,'CmsEasy论坛','0','http://www.cmseasy.org',NULL,NULL,NULL,'cmseasy','2009-11-12 13:15:00',NULL,'1');
INSERT INTO cmseasy_friendlink VALUES('3','1',NULL,'九州易通科技有限公司','0','http://www.pown.net',NULL,NULL,NULL,'cmseasy','2009-11-12 13:28:53',NULL,'1');

INSERT INTO `cmseasy_templatetag` VALUES ('1','根目录','all',NULL,'{$base_url}',NULL,NULL,'system',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('2','Skin目录','all',NULL,'{$skin_url}',NULL,NULL,'system',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('3','网站当前位置','article',NULL,'<a href=\"{$base_url}/\">{get(\'sitename\')}</a> >>\r\n{loop position($typeid) $t}\r\n<a href=\"{$t.url}\">{$t[\'name\']} </a>>\r\n{/loop}','$typeid=','参数: $typeid','system',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('5','栏目列表','all',NULL,'{loop type($typeid) $type}\r\n<a href=\"{$type[url]}\">{$type[typename]}</a>\r\n{/loop}','$typeid=','参数: $typeid','system',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('6','首页链接','all',NULL,'<a href=\"{$base_url}/\">首页</a>',NULL,NULL,'system',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('7','取得下级栏目','all',NULL,'type($typeid)',NULL,'参数: $typeid\r\n取得一级栏目： type()\r\n取得ID为8的栏目的下级栏目: type(8)\r\n取得当前栏目的下级栏目: type($typeid)','function',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('8','取得栏目url','all',NULL,'typeurl($typeid)',NULL,'参数: $typeid\r\n取得栏目url','function',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('9','栏目链接','all',NULL,'<a href=\"{typeurl($typeid)}\">{typename($typeid)}</a>','$typeid=','参数: $typeid','system',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('19','导航栏','all',NULL,'<ul style=\"width:980px\">\r\n{loop type() $t}\r\n	<li style=\"float:left;display:inline;width:120px\">\r\n	<a href=\"{$t[url]}\" {if isset($topid) && $topid==$t[typeid]}class=\"current\"{/if}>{$t[typename]}</a>\r\n	<!--loop一级目录-->\r\n	{loop type($t) $t1}\r\n		<ul style=\"float:left;display:inline;width:100px\">\r\n		<a href=\"{$t1[url]}\" {if isset($typeid) && $typeid==$t1[typeid]}class=\"current\"{/if}>{$t1[typename]}</a>\r\n		<!--loop二级目录...-->\r\n		{loop type($t1) $t2}\r\n			<ul style=\"float:left;display:inline;width:80px\"><a href=\"{$t2[url]}\" {if isset($typeid) && $typeid==$t2[typeid]}class=\"current\"{/if}>{$t2[typename]}</a>\r\n			<!--loop三级目录...-->\r\n			{loop type($t2) $t3}\r\n				<ul style=\"float:left;display:inline;width:60px\"><a href=\"{$t3[url]}\" {if isset($typeid) && $typeid==$t3[typeid]}class=\"current\"{/if}>{$t3[typename]}</a></ul>\r\n			{/loop}\r\n			</ul>\r\n		{/loop}\r\n		</ul>\r\n	{/loop}\r\n	</li>\r\n{/loop}\r\n</ul>\r\n',NULL,'导航栏示范','system',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('12','用户信息',NULL,NULL,'{if isset($user) && is_array($user)}\r\n欢迎你， {$user.username}!<br>\r\n<a href=\"{url(\'user/logout\')}\">退出</a>\r\n | <a href=\"{url(\'user\')}\" target=\"_blank\">会员中心</a>\r\n{if $user[\'username\']==\'admin\'}\r\n | <a href=\"{$base_url}/admin\" target=\"_blank\">后台管理</a>\r\n{/if}\r\n<?php }else{ ?>\r\n\r\n<form id=\"login_form\"   name=\"loginform\" method=\"post\"  action=\"{url(\'user/login\')}\" onsubmit=\"return checkform();\">\r\n用户名：<input type=\'text\' id=\"username\"  name=\"username\" size=\"16\"/><br>\r\n密??码：<input type=\'password\' id=\"password\"  name=\"password\" size=\"17\"/><br>\r\n验证码：<input type=\'text\' id=\"verify\"  name=\"verify\" size=\"4\"/>\r\n{verify()}<br>\r\n有效期: <select name=\"expire\">\r\n<option value=\"<?php echo 3600; ?>\">一小时</option>\r\n<option value=\"<?php echo 3600*24; ?>\">一天</option>\r\n<option value=\"<?php echo 3600*24*7; ?>\">一星期</option>\r\n<option value=\"<?php echo 3600*24*30; ?>\">一个月</option>\r\n<option value=\"<?php echo 3600*24*365; ?>\">一年</option>\r\n</select><br>\r\n<input type=\'submit\' name=\"submit\" value=\"登陆\" style=\"margin-left:30px\"/>\r\n<input type=\'button\' name=\"register\" value=\"注册\" onclick=\"javascript:location.href=\'{url(\'user/register\')}\'\"  style=\"margin-left:10px\">\r\n</form>\r\n{/if}',NULL,'一般用JS调用','system',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('13','ICP备案号',NULL,NULL,'{get(\'site_icp\')}',NULL,NULL,'define',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('14','首页关键词',NULL,NULL,'{get(\'site_keyword\')}',NULL,NULL,'define',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('15','首页网页描述',NULL,NULL,'{get(\'site_description\')}',NULL,NULL,'define',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('16','版权所有',NULL,NULL,'{get(\'site_right\')}',NULL,NULL,'define',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('17','调用模板','all',NULL,'template($tpl)',NULL,'在当前模板中调用其他模板。变量值基于模板根目录。\r\n\r\n例子：\r\n\r\n{template(\'mypage/about.html\')}','function',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('18','调用文章','archive',NULL,'article($typeid,$titlelen,$sort,$num,$son,$where)','$typeid=\r\n$titlelen=\r\n$sort=\r\n$num=\r\n$son=\r\n$where=','变量解释：\r\n\r\n$typeid —— 分类ID \r\n$titlelen —— 标题截取字符长度\r\n$sort —— 排序字段\r\n$num —— 调用记录条数\r\n$son —— 是否调用子目录\r\n$where —— 条件\r\n\r\n\r\n例子：\r\n\r\n热点文章-TOP-10:\r\n\r\n{loop article(0,20,\'view\',10) $arc}\r\n <li>·[<a href=\"{$arc[typeurl]}\">{$arc[typename]}</a>] <a href=\"{$arc[url]}\">{$arc[title]}</a>\r\n{/loop}\r\n\r\n如果要按位置调用:\r\n$where可以写作 \" my_posid like \'位置数值\' \"\r\n\r\n上例改成调用首页置顶就可以改成：\r\n\r\n{loop article(0,20,\'view\',10,1,\" my_posid like ‘1’ \") $arc}\r\n <li>·[<a href=\"{$arc[typeurl]}\">{$arc[typename]}</a>] <a href=\"{$arc[url]}\">{$arc[title]}</a>\r\n{/loop}','function',NULL);
INSERT INTO `cmseasy_templatetag` VALUES ('20','公告列表','announ',NULL,'{loop announ($num) $an}\r\n○ <a href=\"{$an[url]}\"> {$an[title]} </a> ({$an[adddate]}) \r\n{/loop}','$num=10',NULL,'system',NULL);

INSERT INTO `cmseasy_usergroup` VALUES ('1','888','管理员');
INSERT INTO `cmseasy_usergroup` VALUES ('2','101','一般会员');
INSERT INTO `cmseasy_usergroup` VALUES ('3','0','游客');
INSERT INTO `cmseasy_user` VALUES ('127','admin','21232f297a57a5a743894a0e4a801fc3','管理员','888','1',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL);
