<?php
/**
 * 文章
 *
 */

class archive extends table {

    function getcols($act) {

        switch($act) {
            case  'list' :
                return 'aid,title,typeid,introduce,keyword,view,adddate,userid,author,image,content,attachment,checked,linkto,ispages'.$this->mycols();

            case 'modify':
                return 'aid,title,typeid,introduce,introduce_len,description,keyword,image,content,attachment,checked,template,linkto,mtitle,description,keyword,htmlrule,ishtml,arcatt1'.$this->mycols();

            case 'manage':
                return 'aid,title,username,typeid,adddate,view,checked,linkto';

            case 'user_modify':
                return 'aid,title,typeid,introduce,keyword,image,content,attachment'.$this->mycols();

            case 'user_manage':
                return 'aid,title,username,typeid,adddate,view,checked';

            default: return '1';
        }
    }

    function get_verify() {
        return array(

        );
    }

    function get_form() {
        return array(
        'typeid'=>array(
        'selecttype'=>'select',
        'select'=>form::arraytoselect(type::option(0,'tolast')),
        'default'=>get('typeid'),
        'regex'=>'/\d+/',
        'filter'=>'is_numeric',
        ),
        'ishtml'=>array(
        'selecttype'=>'radio',
        'select'=>form::arraytoselect(array(0=>'继承',1=>'生成',2=>'不生成')),
        ),
        'checked'=>array(
        'selecttype'=>'radio',
        'select'=>form::arraytoselect(form::yesornotoarray('审核')),
        ),
        'image'=>array(
        'filetype'=>'image',
        ),
        'displaypos'=>array(
        'selecttype'=>'checkbox',
        'select'=>form::arraytoselect(array(1=>'首页推荐',2=>'首页焦点',3=>'首页头条',4=>'列表页推荐',5=>'内容页推荐')),
        ),
        'htmlrule'=>array(
        'tips'=>" 默认：{?type::gethtmlrule(get('id'),'showhtmlrule')}",
        ),
        'template'=>array(
        'selecttype'=>'select',
        'select'=>form::arraytoselect(front::$view->archive_tpl_list()),
        'tips'=>" 默认：{?type::gettemplate(get('id'),'showtemplate')}",
        ),
        'introduce_len'=>array(
        'default'=>config::get('archive_introducelen'),
        ),
        'arcatt1'=>array(
        'selecttype'=>'checkbox',
        'select'=>form::arraytoselect($this->getarcatts(1)),
        ),
        'grade'=>array(
        'selecttype'=>'radio',
        'select'=>form::arraytoselect(array(0,1,2,3,4,5)),
        ),
        'pics'=>array(
        'filetype'=>'image2',
        ),
        );
    }
    
    function get_form_field() {
    	$arr = array(0=>'全站使用');
        return array(
        'typeid'=>array(
        'selecttype'=>'select',
        'select'=>form::arraytoselect(type::option(0,'tolast',$arr)),
        'default'=>get('typeid'),
        'regex'=>'/\d+/',
        'filter'=>'is_numeric',
        ),
        'ishtml'=>array(
        'selecttype'=>'radio',
        'select'=>form::arraytoselect(array(0=>'继承',1=>'生成',2=>'不生成')),
        ),
        'checked'=>array(
        'selecttype'=>'radio',
        'select'=>form::arraytoselect(form::yesornotoarray('审核')),
        ),
        'image'=>array(
        'filetype'=>'image',
        ),
        'displaypos'=>array(
        'selecttype'=>'checkbox',
        'select'=>form::arraytoselect(array(1=>'首页推荐',2=>'首页焦点',3=>'首页头条',4=>'列表页推荐',5=>'内容页推荐')),
        ),
        'htmlrule'=>array(
        'tips'=>" 默认：{?type::gethtmlrule(get('id'),'showhtmlrule')}",
        ),
        'template'=>array(
        'selecttype'=>'select',
        'select'=>form::arraytoselect(front::$view->archive_tpl_list()),
        'tips'=>" 默认：{?type::gettemplate(get('id'),'showtemplate')}",
        ),
        'introduce_len'=>array(
        'default'=>config::get('archive_introducelen'),
        ),
        'arcatt1'=>array(
        'selecttype'=>'checkbox',
        'select'=>form::arraytoselect($this->getarcatts(1)),
        ),
        );
    }


    public function get_where($act) {
        switch($act) {
            case  'list' :
                return '';
            case 'manage':
                $where='aid>0';
                if(front::get('needcheck'))
                    $where .=" and checked=0";
                return $where;
            case 'user_manage':
                $where='aid>0';
                if(front::get('needcheck'))
                    $where .=" and checked=0";
                return $where;
            default: return '0';
        }
    }

    public static function getInstance() {
        $class = new archive();
        return $class;
    }


    static function url($info,$page=null,$relative=false) {
        if($info['linkto']) return $info['linkto'];

        if(config::get('html_prefix'))
            $html_prefix='/'.trim(config::get('html_prefix'),'/');

        $type=type::getInstance();
        if(!type::getarcishtml($info)  || front::$rewrite)
            if($page) return url::create('archive/show/aid/'.$info['aid'].'/page/'.$page);
            else return url::create('archive/show/aid/'.$info['aid']);
        else {
            if($info['htmlrule']) $rule=$info['htmlrule'];
            else $rule=type::gethtmlrule($info['typeid'],'showhtmlrule');
            $rule=str_replace('{$typeurl}',$type->htmlpath($info['typeid']),$rule);
            $rule=str_replace('{$typeid}',$info['typeid'],$rule);
            $rule=str_replace('{$aid}',$info['aid'],$rule);
            
            if($page) $rule=str_replace('{$page}',$page,$rule);
            else $rule=preg_replace('/\(.*?\)/','',$rule);

            $rule=preg_replace('/[\(\)]/','',$rule);
            $rule=preg_replace('%[\\/]index\.htm1%','',$rule);
            $rule=rtrim($rule,'/');
            $rule=trim($rule,'\\');

            if($relative) return $html_prefix.'/'.$rule;
            return config::get('base_url').$html_prefix.'/'.$rule;
        }
    }

    static function countarchive($typeid) {
        $arc=archive::getInstance();
        return $arc->rec_count($arc->name,'typeid='.$typeid);
    }


    function getarcatts($att_order=1) {
        $attr='arcatt'.$att_order;
        $sets=settings::getInstance()->getrow(array('tag'=>'table-archive'));
        if(!is_array($sets)) return;
        $data=unserialize($sets['value']);

        preg_match_all('%\(([\d\w\/\.-]+)\)(\S+)%m', $data[$attr], $result, PREG_SET_ORDER);
        $data=array();
        foreach($result as $res) $data[$res[1]]=$res[2];

        return $data;
    }

    static function getgrade($grade){
        $count = 5;
        $path = config::get('base_url').'/';
        $star1 = "<img src=\"{$path}images/user/star1.gif\" border=\"0\" />";
        $star2 = "<img src=\"{$path}images/user/star2.gif\" border=\"0\" />";
        $str = "";
        for($i=0;$i<$count;$i++){
            if($i<$grade){
                $str .= $star1;
            }else{
                $str .= $star2;
            }
        }
        return $str;
    }
}