<?php
class type extends table {

    static $me;

    function getcols($act) {
        if($act=='modify') return 'typeid,typename,parentid,htmldir,template,listtemplate,showtemplate,ishtml,isshow,ispages,includecatarchives,linkto,htmlrule,listhtmlrule,showhtmlrule,mtitle,description,keyword,stype,islast';
        else return 'typeid,typename,htmldir,isshow,ispages,linkto,stype';
    }

    function get_form() {
        return array(
        'parentid'=>array(
        'selecttype'=>'select',
        'select'=>form::arraytoselect(type::option(0,'isnotlast')),
        'default'=>get('parentid'),
        ),
        'ishtml'=>array(
        'selecttype'=>'radio',
        'select'=>form::arraytoselect(array(0=>'继承',1=>'生成',2=>'不生成')),
        'default'=>0,
        ),
        'isshow'=>array(
        'selecttype'=>'radio',
        'select'=>form::arraytoselect(array(1=>'正常显示',0=>'禁用')),
        ),
        'ispages'=>array(
        'selecttype'=>'radio',
        'select'=>form::arraytoselect(array(1=>'分页',0=>'单页')),
		'default'=>1,
        ),
        'includecatarchives'=>array(
        'selecttype'=>'radio',
        'select'=>form::arraytoselect(array(1=>'包含',0=>'不包含')),
        'default'=>1,
        ),
        'stype'=>array(
        'tips'=>"&nbsp;被调用的格式 type(\$typeid,'标记')",
        ),
        'htmlrule'=>array(
        'tips'=>" 默认：{?type::gethtmlrule(get('id'))}",
        ),
        'listhtmlrule'=>array(
        'tips'=>" 默认：{?type::gethtmlrule(get('id'),'listhtmlrule')}",
        ),
        'showhtmlrule'=>array(
        'tips'=>" 默认：{?type::gethtmlrule(get('id'),'showhtmlrule')}",
        ),
        'image'=>array(
        'filetype'=>'image1',
        ),
        'template'=>array(
        'selecttype'=>'select',
        'select'=>form::arraytoselect(front::$view->archive_tpl_list()),
        'default'=>"{?type::gettemplate(get('id'),'listtemplate',false)}",
        'tips'=>" 默认：{?type::gettemplate(get('id'))}",
        ),
        'listtemplate'=>array(
        'selecttype'=>'select',
        'select'=>form::arraytoselect(front::$view->archive_tpl_list()),
        'default'=>"{?type::gettemplate(get('id'),'listtemplate',false)}",
        'tips'=>" 默认：{?type::gettemplate(get('id'),'listtemplate')}",
        ),
        'showtemplate'=>array(
        'selecttype'=>'select',
        'select'=>form::arraytoselect(front::$view->archive_tpl_list()),
        'default'=>"{?type::gettemplate(get('id'),'showtemplate',false)}",
        'tips'=>" 默认：{?type::gettemplate(get('id'),'showtemplate')}",
        ),
        'htmldir'=>array(
        'tips'=>"栏目英文名，留空则自动使用拼音名",
        ),
        );
    }


    public static function getInstance() {
        if(!self::$me) {
            $class = new type();
            $class->init();
            self::$me=$class;
        }
        return self::$me;
    }

    function init() {

        $_type=$this->getrows(null,1000,'`order`,1');
        $type=array();

        foreach($_type as $one) {
            if(!front::$admin && !$one['isshow']) continue;
            $type[$one['typeid']]=$one;
        }
        $this->type=$type;

        $parent=array();

        foreach($type as $one) {
            $parent[$one['typeid']]=$one['parentid'];
        }
        $this->parent=$parent;
        $this->tree=new tree($parent);
    }


    function son($id) {
        if(!isset($this->tree)) $this->init();
        return $this->tree->get_son($id);
    }

    function sons($id) {
        if(!isset($this->tree)) $this->init();
        $sons=array();
        $this->tree->get_sons($id,$sons);
        return $sons;
    }

    function getparents($id,$up=true) {
        if(!isset($this->tree)) $this->init();
        return $this->tree->get_parents($id);
    }

    function getparent($id) {
        if(isset($this->tree->parent[$id]))
            return $this->tree->parent[$id];
        else return false;
    }

    function getposition($id) {
        if(!isset($this->tree)) $this->init();
        $position=$this->tree->get_parents($id);
        return $position;
    }
    
    function getposition1($id) {
        if(!isset($this->tree)) $this->init();
        $position=$this->tree->get_parents1($id);
        return $position;
    }

    static function gettopparent($id) {
        $position=self::getInstance()->getposition($id);
        return $position[count($position)-1];
    }

    function htmlpath($id) {
        if(!isset($this->tree)) $this->init();
        $positions=$this->tree->get_parents($id);
        $path=array();
        foreach($positions as $_id) {
            if($_id && isset($this->type[$_id]))
                $path[]=$this->type[$_id]['htmldir'];
        }
        return implode('/',$path);
    }

    static function option($typeid=0,$tag='all',&$option=array(0=>'请选择...'),&$level=0) {
        $type=self::getInstance();

        if(is_array($type->son($typeid)))
            foreach($type->son($typeid) as $_typeid) {
                if(!self::check($_typeid,$tag)) continue;
                $strpre=$level>0? str_pad('',$level*24,'&nbsp;').'└':'';
                $option[$_typeid]=$strpre.$type->type[$_typeid]['typename'];
                if(is_array($type->son($_typeid))) {
                    $level++;
                    self::option($_typeid,$tag,$option,$level);
                    $level--;
                }
            }

        return $option;
    }

    static function name($typeid) {
        $type=self::getInstance();
        if(isset($type->type[$typeid]['typename'])) return $type->type[$typeid]['typename'];
        else return '';
    }

    static function image($typeid) {
        $type=self::getInstance();
        if(isset($type->type[$typeid]['image'])) return config::get('base_url').'/'.$type->type[$typeid]['image'];
        else return '';
    }

    static function url($typeid,$page=null,$relative=false) {
        $type=self::getInstance();
        if(@$type->type[$typeid]['linkto']) return $type->type[$typeid]['linkto'];
        if(config::get('html_prefix'))
            $html_prefix='/'.trim(config::get('html_prefix'),'/');
        if(!type::getishtml($typeid) || front::$rewrite) {
            if(!$page)
                return url::create('archive/list/typeid/'.$typeid);
            else
                return url::create('archive/list/typeid/'.$typeid.'/page/'.$page);
        }
        else {
			

            $rule=type::gethtmlrule($typeid,'listhtmlrule');

            $rule=str_replace('{$typeurl}',$type->htmlpath($typeid),$rule);
            $rule=str_replace('{$typeid}',$typeid,$rule);

            if($type->type[$typeid]['ispages'] && !$page) $page=1;

            if($page) $rule=str_replace('{$page}',$page,$rule);
            else $rule=preg_replace('/\(.*?\)/','',$rule);

            $rule=preg_replace('%/\.html$%','/index.html',$rule);

            $rule=preg_replace('/[\(\)]/','',$rule);
            $rule=preg_replace('%[\\/]index\.htm(l)?%','',$rule);
            $rule=rtrim($rule,'/');
            $rule=trim($rule,'\\');
            if($relative) return $html_prefix.'/'.$rule;
            return config::get('base_url').$html_prefix.'/'.$rule;
        }
    }

    static function getpositionlink($typeid) {
        $type=self::getInstance();
        if(!isset($type->type[$typeid])) return;
        $position=$type->getposition($typeid);
        $links=array();
        if(!$typeid) return $links;
        foreach($position as $order=>$id) {
            $links[$order]['id']=$id;
            $links[$order]['name']=@$type->type[$id]['typename'];
            $links[$order]['url']=self::url($id);
        }
        return $links;
    }
    
    //phpox1108 在模板中调用单独的分类 不包含子分类
    static function getpositionlink1($typeid) {
        $type=self::getInstance();
        if(!isset($type->type[$typeid])) return;
        $position=$type->getposition($typeid);
        $links=array();
        if(!$typeid) return $links;
        foreach($position as $order=>$id) {
            $links['id']=$id;
            $links['name']=@$type->type[$id]['typename'];
            $links['url']=self::url($id);
            break;
        }
        return $links;
    }
    
    static function getpositionlink2($typeid) {
        $type=self::getInstance();
        if(!isset($type->type[$typeid])) return;
        $position=$type->getposition1($typeid);
        $links=array();
        if(!$typeid) return $links;
        foreach($position as $order=>$id) {
            $links[$order]['id']=$id;
            $links[$order]['name']=@$type->type[$id]['typename'];
            $links[$order]['url']=self::url($id);
        }
        return $links;
    }

    static function gettemplate($typeid,$tag='listtemplate',$up=true) {
        if(!$typeid && front::get('parentid')) $typeid=front::get('parentid');
        $type=self::getInstance();
        if(@$type->type[$typeid]['template'] && $tag=='listtemplate') return $type->type[$typeid]['template'];
        if(@$type->type[$typeid][$tag]) return $type->type[$typeid][$tag];
        if(!$up) return;
        $parents=$type->getparents($typeid,true);
        ksort($parents);
        foreach($parents as $pid) {
            if($pid==$typeid) continue;
            if(@$type->type[$pid][$tag]) return $type->type[$pid][$tag];
        }
        $default=array(
            'listtemplate'=>'archive/list.html',
            'showtemplate'=>'archive/show.html',
        );
        if(isset($default[$tag])) return $default[$tag];
    }

    static function gethtmlrule($typeid,$tag='listhtmlrule') {
        if(!$typeid && front::get('parentid')) $typeid=front::get('parentid');
        $type=self::getInstance();
        if(@$type->type[$typeid]['htmlrule'] && $tag=='listhtmlrule') return $type->type[$typeid]['htmlrule'];
        $parents=$type->getparents($typeid,true);
        ksort($parents);
        foreach($parents as $pid) {
            if($pid==$typeid) continue;
            if(@$type->type[$pid][$tag]) return $type->type[$pid][$tag];
        }
        $default=array(
            'listhtmlrule'=>'{$typeurl}/index(_{$page}).html',
            'showhtmlrule'=>'{$typeurl}/show_{$aid}(_{$page}).html',
        );
        if(isset($default[$tag])) return $default[$tag];
    }


    static function getishtml($typeid) {
        if(config::get('list_page_php')=='1') return true;
        if(config::get('list_page_php')=='2') return false;

        $type=self::getInstance();
        if(@$type->type[$typeid]['ishtml']=='1') return true;

        $parents=$type->getparents($typeid,true);
        ksort($parents);
        foreach($parents as $pid) {
            if($pid==$typeid) continue;
            if(@$type->type[$pid]['ishtml']=='1') return true;
            if(@$type->type[$pid]['ishtml']=='2') return false;
        }
        return false;
    }

    static function getarcishtml($arc) {
        if(config::get('show_page_php')=='1') return true;
        if(config::get('show_page_php')=='2') return false;

        if($arc['ishtml']) return true;
        if(self::getishtml($arc['typeid'])) return true;
        return false;
    }


    static function gettypedata($_typeid=0,&$data=array(),&$level=0) {
        $type=self::getInstance();

        $types=$type->son($_typeid);
        foreach($types as $typeid) {
            $info_=$type->type[$typeid];
            $strpre=$level>0? str_pad('',$level*24,'&nbsp;').'└':'';
            $info_['typename']= $strpre.$info_['typename'].'<font color="Blue">'.(self::check($typeid,'islast')?('('.countarchive($typeid).')'):'').'</font>';
            $info_['level']=$level;
            $data[]=$info_;
            if(is_array($type->son($typeid))) {
                $level++;
                self::gettypedata($typeid,$data,$level);
                $level--;
            }
        }
        
        return $data;
    }


    static function check($typeid,$tag='isnotlast') {return true;
        $_type=self::getInstance();
        $type=$_type->type[$typeid];
        if($tag=='islast' && !$type['islast']) return false;
        if($tag=='isnotlast' && $type['islast']) return false;
        if($tag=='tolast') {
            if($_type->type[$typeid]['islast']) return true;
            $sons=$_type->sons($typeid);
            foreach($sons as $tid) {
                if($_type->type[$tid]['islast']) return true;
            }
            return false;
        }
        return true;
    }

    static function htmlcache($typeid) {

    }
}