<?php defined('SYSPATH') OR die('No direct access allowed.');
/*
 * Arlicle admin Users controller.
 * 
 * @packpage	Arlicle
 * @author 		Edison Rao
 * @copyright 	(c) 2009 Arlicle Team
 * @license 	GNU General Public License 2.0 
 */
class Options_General_Controller extends Controller {

    public function index() {
        $site_url_error = '';
        $site_title = Kohana::config('arlicle.site_title');
        $site_description = Kohana::config('arlicle.site_description');
        $site_url = Kohana::config('arlicle.site_url');
        $default_language = Kohana::config('arlicle.default_language');
        $space_size = Kohana::config('arlicle.space_size');
        $database_size = Kohana::config('arlicle.database_size');
        $upload_max_filesize = Kohana::config('arlicle.upload_max_filesize');
        $editor_width = Kohana::config('arlicle.editor_width');
        $editor_height = Kohana::config('arlicle.editor_height');

        if ($_POST) {
            // check is use have role
            if (!$this->user->can('edit_options_general')) {
                die(T::_('You are not access allowed.'));
            }

            $site_url = trim($this->input->post('site_url'), ' /');

            if (!valid::url($site_url)) {
                $site_url_error = T::_('Url is invalid.');
            }

            if (empty($site_url_error)) {
                Arlicle::config_save('arlicle.site_title', trim($this->input->post('site_title')));
                Arlicle::config_save('arlicle.site_description', trim($this->input->post('site_description')));
                Arlicle::config_save('arlicle.site_url', $site_url);
                Arlicle::config_save('arlicle.default_language', $this->input->post('default_language'));
                Arlicle::config_save('arlicle.space_size', $this->input->post('space_size'));
                Arlicle::config_save('arlicle.database_size', $this->input->post('database_size'));
                Arlicle::config_save('arlicle.upload_max_filesize', $this->input->post('upload_max_filesize'));
                Arlicle::config_save('arlicle.editor_width', $this->input->post('editor_width'));
                Arlicle::config_save('arlicle.editor_height', $this->input->post('editor_height'));
                Arlicle::config_save('arlicle.default_date_format', $this->input->post('default_date_format'));
                Tip::set('Options saved.');
                url::admin_redirect('options_general');
            }
        }

        $view = new View('layouts/admin');
        $view->page_title = 'Options General';
        $view->site_title = $site_title;
        $view->site_description = $site_description;
        $view->site_url = $site_url;
        $view->site_url_error = $site_url_error;
        $view->languages = T::get_languages();
        $view->default_language = $default_language;
        $view->space_size = $space_size;
        $view->database_size = $database_size;
        $view->upload_max_filesize = $upload_max_filesize;
        $view->editor_width = $editor_width;
        $view->editor_height = $editor_height;

        $date_formats = date::date_formats();
        $formats = array();
        foreach($date_formats as $key => $value) {
            if (isset($value[2])) {
                $formats[$key] = $value[2];
            }
        }
        $view->date_formats = $formats;
        $view->default_date_format = Kohana::config('arlicle.default_date_format');
        $view->render(true);
    }
}
