<?php defined('SYSPATH') OR die('No direct access allowed.');

class Arlicle {
    // is the admin visit
    public static $is_admin_uri = false;
    public static $config_data = array();
	/**
	 * Check is the admin status,
	 * set the $is_admin login static status
	 *
	 * @return  null
	 */
    public static function check_admin_uri() {
        if (isset(Router::$segments[0]) && Router::$segments[0] == Kohana::config('arlicle.admin_uri')) {
            self::$is_admin_uri = TRUE;
        } else {
            self::$is_admin_uri = FALSE;
        }
        return self::$is_admin_uri;
    }

	/**
	 * Sets a configuration item and save it into config file, if allowed. a method like Kohana::config_set
	 *
	 * @param   string   config key string
	 * @param   string   config value
	 * @return  boolean
	 */
    public static function config_save($key, $value, $create = true) {
        //get original value
        $original_value = Kohana::config($key);

		// Get the group name from the key
		$keys = explode('.', $key, 2); // $keys[0] is the config filename, $keys[1] is the parameter name
        $config_file = APPPATH . 'config/' . $keys[0] . '.php';

        if (!file_exists($config_file) && $create) {
            $config_files = Kohana::find_file('config', $keys[0]);
            self::$config_data[$keys[0]] = file_get_contents(array_pop($config_files));
            $handle = fopen($config_file, 'w+b');
            fclose($handle);
        }

        if (empty(self::$config_data[$keys[0]])) {
            self::$config_data[$keys[0]] = file_get_contents($config_file);
        }

        
        if ((is_array($original_value) and is_array($value)) or (is_string($original_value) and is_string($value))) {
                // save string
            if (is_string($value)) {
                $value = addslashes($value);
                $pattern = "/(\\\$config\['$keys[1]'\] = ')(.*)(';)/";
                // save array
            } else if (is_array($value)) {
                $pattern = "/(\\\$config\['$keys[1]'\] = )(.*)(;)/s";
                $value = var_export($value, true);
            }
            self::$config_data[$keys[0]] = preg_replace($pattern, '${1}' . $value . '${3}', self::$config_data[$keys[0]]);
        } else {
            if (is_string($value)) {
                $value = addslashes($value);
                $pattern = "/(\\\$config\['$keys[1]'\] = )(.*)(;)/s";
                self::$config_data[$keys[0]] = preg_replace($pattern, '${1}\'' . $value . '\'${3}', self::$config_data[$keys[0]]);
                // save array
            } else if (is_array($value)) {
                $pattern = "/(\\\$config\['$keys[1]'\] = )'(.*)'(;)/";
                $value = var_export($value, true);
                self::$config_data[$keys[0]] = preg_replace($pattern, '${1}' . $value . '${3}', self::$config_data[$keys[0]]);
            }
        }
        
        file_put_contents($config_file, self::$config_data[$keys[0]]);
        return true;
    }

    // check if arlicle is installed
    public static function is_installed() {
        if (!file_exists(APPPATH . 'config/database.php')) {
            return false;
        }

        if (!file_exists(APPPATH . 'cache')) {
            return false;
        }

        $cache = Cache::instance();
        if ($cache->get('arlicle_installed')) {
            return true;
        } else {
            return false;
        }
    }

    public static function upload_file_filter($value) {
        $base = trim(url::base(), '/');
        $replace = empty($base) ? '' : '/' . $base;
        $replace = $replace . '$1';
        $result = preg_replace('/\/?[a-z]*(\/webroot\/attach\/[0-9\/]*\.?[a-z0-9]*)/i', $replace, $value);
        return $result;
    }
}
