<?php defined('SYSPATH') OR die('No direct access allowed.');

class Comment_Model extends ORM {
    protected $sorting = array('id' => 'asc');
    protected $belongs_to = array('post');
    protected $has_one = array('user', 'post', 'diagram');

    public function __get($key) {
        $value = '';
        switch($key) {
            case 'username':
                $value = parent::__get($key);
                if (empty($value) and !empty($this->user->id)) {
                    $value = $this->user->username;
                }
            break;
            case 'email':
                $value = parent::__get($key);
                if (empty($value) and !empty($this->user->id)) {
                    $value = $this->user->email;
                }
            break;
            case 'id':
            case 'parent_id':
            case 'parent':
            case 'post_id':
            case 'post':
            case 'diagram_id':
            case 'diagram':
            case 'url':
            case 'ip':
            case 'date':
            case 'content':
            case 'is_approved':
            case 'agent':
            case 'user_id':
            case 'user':
                $value = parent::__get($key);
            break;
        }
        return $value;
    }
}
